/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAuthenticationFactor is the corresponding interface of BACnetAuthenticationFactor
type BACnetAuthenticationFactor interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFormatType returns FormatType (property field)
	GetFormatType() BACnetAuthenticationFactorTypeTagged
	// GetFormatClass returns FormatClass (property field)
	GetFormatClass() BACnetContextTagUnsignedInteger
	// GetValue returns Value (property field)
	GetValue() BACnetContextTagOctetString
	// IsBACnetAuthenticationFactor is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetAuthenticationFactor()
	// CreateBuilder creates a BACnetAuthenticationFactorBuilder
	CreateBACnetAuthenticationFactorBuilder() BACnetAuthenticationFactorBuilder
}

// _BACnetAuthenticationFactor is the data-structure of this message
type _BACnetAuthenticationFactor struct {
	FormatType  BACnetAuthenticationFactorTypeTagged
	FormatClass BACnetContextTagUnsignedInteger
	Value       BACnetContextTagOctetString
}

var _ BACnetAuthenticationFactor = (*_BACnetAuthenticationFactor)(nil)

// NewBACnetAuthenticationFactor factory function for _BACnetAuthenticationFactor
func NewBACnetAuthenticationFactor(formatType BACnetAuthenticationFactorTypeTagged, formatClass BACnetContextTagUnsignedInteger, value BACnetContextTagOctetString) *_BACnetAuthenticationFactor {
	if formatType == nil {
		panic("formatType of type BACnetAuthenticationFactorTypeTagged for BACnetAuthenticationFactor must not be nil")
	}
	if formatClass == nil {
		panic("formatClass of type BACnetContextTagUnsignedInteger for BACnetAuthenticationFactor must not be nil")
	}
	if value == nil {
		panic("value of type BACnetContextTagOctetString for BACnetAuthenticationFactor must not be nil")
	}
	return &_BACnetAuthenticationFactor{FormatType: formatType, FormatClass: formatClass, Value: value}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetAuthenticationFactorBuilder is a builder for BACnetAuthenticationFactor
type BACnetAuthenticationFactorBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(formatType BACnetAuthenticationFactorTypeTagged, formatClass BACnetContextTagUnsignedInteger, value BACnetContextTagOctetString) BACnetAuthenticationFactorBuilder
	// WithFormatType adds FormatType (property field)
	WithFormatType(BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorBuilder
	// WithFormatTypeBuilder adds FormatType (property field) which is build by the builder
	WithFormatTypeBuilder(func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorBuilder
	// WithFormatClass adds FormatClass (property field)
	WithFormatClass(BACnetContextTagUnsignedInteger) BACnetAuthenticationFactorBuilder
	// WithFormatClassBuilder adds FormatClass (property field) which is build by the builder
	WithFormatClassBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetAuthenticationFactorBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetContextTagOctetString) BACnetAuthenticationFactorBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(BACnetContextTagOctetStringBuilder) BACnetContextTagOctetStringBuilder) BACnetAuthenticationFactorBuilder
	// Build builds the BACnetAuthenticationFactor or returns an error if something is wrong
	Build() (BACnetAuthenticationFactor, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetAuthenticationFactor
}

// NewBACnetAuthenticationFactorBuilder() creates a BACnetAuthenticationFactorBuilder
func NewBACnetAuthenticationFactorBuilder() BACnetAuthenticationFactorBuilder {
	return &_BACnetAuthenticationFactorBuilder{_BACnetAuthenticationFactor: new(_BACnetAuthenticationFactor)}
}

type _BACnetAuthenticationFactorBuilder struct {
	*_BACnetAuthenticationFactor

	err *utils.MultiError
}

var _ (BACnetAuthenticationFactorBuilder) = (*_BACnetAuthenticationFactorBuilder)(nil)

func (b *_BACnetAuthenticationFactorBuilder) WithMandatoryFields(formatType BACnetAuthenticationFactorTypeTagged, formatClass BACnetContextTagUnsignedInteger, value BACnetContextTagOctetString) BACnetAuthenticationFactorBuilder {
	return b.WithFormatType(formatType).WithFormatClass(formatClass).WithValue(value)
}

func (b *_BACnetAuthenticationFactorBuilder) WithFormatType(formatType BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorBuilder {
	b.FormatType = formatType
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) WithFormatTypeBuilder(builderSupplier func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorBuilder {
	builder := builderSupplier(b.FormatType.CreateBACnetAuthenticationFactorTypeTaggedBuilder())
	var err error
	b.FormatType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAuthenticationFactorTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) WithFormatClass(formatClass BACnetContextTagUnsignedInteger) BACnetAuthenticationFactorBuilder {
	b.FormatClass = formatClass
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) WithFormatClassBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetAuthenticationFactorBuilder {
	builder := builderSupplier(b.FormatClass.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.FormatClass, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) WithValue(value BACnetContextTagOctetString) BACnetAuthenticationFactorBuilder {
	b.Value = value
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) WithValueBuilder(builderSupplier func(BACnetContextTagOctetStringBuilder) BACnetContextTagOctetStringBuilder) BACnetAuthenticationFactorBuilder {
	builder := builderSupplier(b.Value.CreateBACnetContextTagOctetStringBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorBuilder) Build() (BACnetAuthenticationFactor, error) {
	if b.FormatType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'formatType' not set"))
	}
	if b.FormatClass == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'formatClass' not set"))
	}
	if b.Value == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'value' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetAuthenticationFactor.deepCopy(), nil
}

func (b *_BACnetAuthenticationFactorBuilder) MustBuild() BACnetAuthenticationFactor {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetAuthenticationFactorBuilder) DeepCopy() any {
	_copy := b.CreateBACnetAuthenticationFactorBuilder().(*_BACnetAuthenticationFactorBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetAuthenticationFactorBuilder creates a BACnetAuthenticationFactorBuilder
func (b *_BACnetAuthenticationFactor) CreateBACnetAuthenticationFactorBuilder() BACnetAuthenticationFactorBuilder {
	if b == nil {
		return NewBACnetAuthenticationFactorBuilder()
	}
	return &_BACnetAuthenticationFactorBuilder{_BACnetAuthenticationFactor: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAuthenticationFactor) GetFormatType() BACnetAuthenticationFactorTypeTagged {
	return m.FormatType
}

func (m *_BACnetAuthenticationFactor) GetFormatClass() BACnetContextTagUnsignedInteger {
	return m.FormatClass
}

func (m *_BACnetAuthenticationFactor) GetValue() BACnetContextTagOctetString {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetAuthenticationFactor(structType any) BACnetAuthenticationFactor {
	if casted, ok := structType.(BACnetAuthenticationFactor); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAuthenticationFactor); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAuthenticationFactor) GetTypeName() string {
	return "BACnetAuthenticationFactor"
}

func (m *_BACnetAuthenticationFactor) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (formatType)
	lengthInBits += m.FormatType.GetLengthInBits(ctx)

	// Simple field (formatClass)
	lengthInBits += m.FormatClass.GetLengthInBits(ctx)

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetAuthenticationFactor) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAuthenticationFactorParse(ctx context.Context, theBytes []byte) (BACnetAuthenticationFactor, error) {
	return BACnetAuthenticationFactorParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAuthenticationFactorParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactor, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactor, error) {
		return BACnetAuthenticationFactorParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetAuthenticationFactorParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactor, error) {
	v, err := (&_BACnetAuthenticationFactor{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetAuthenticationFactor) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetAuthenticationFactor BACnetAuthenticationFactor, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetAuthenticationFactor"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAuthenticationFactor")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	formatType, err := ReadSimpleField[BACnetAuthenticationFactorTypeTagged](ctx, "formatType", ReadComplex[BACnetAuthenticationFactorTypeTagged](BACnetAuthenticationFactorTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'formatType' field"))
	}
	m.FormatType = formatType

	formatClass, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "formatClass", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'formatClass' field"))
	}
	m.FormatClass = formatClass

	value, err := ReadSimpleField[BACnetContextTagOctetString](ctx, "value", ReadComplex[BACnetContextTagOctetString](BACnetContextTagParseWithBufferProducer[BACnetContextTagOctetString]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_OCTET_STRING)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetAuthenticationFactor"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAuthenticationFactor")
	}

	return m, nil
}

func (m *_BACnetAuthenticationFactor) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAuthenticationFactor) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAuthenticationFactor"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAuthenticationFactor")
	}

	if err := WriteSimpleField[BACnetAuthenticationFactorTypeTagged](ctx, "formatType", m.GetFormatType(), WriteComplex[BACnetAuthenticationFactorTypeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'formatType' field")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "formatClass", m.GetFormatClass(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'formatClass' field")
	}

	if err := WriteSimpleField[BACnetContextTagOctetString](ctx, "value", m.GetValue(), WriteComplex[BACnetContextTagOctetString](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAuthenticationFactor"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAuthenticationFactor")
	}
	return nil
}

func (m *_BACnetAuthenticationFactor) IsBACnetAuthenticationFactor() {}

func (m *_BACnetAuthenticationFactor) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetAuthenticationFactor) deepCopy() *_BACnetAuthenticationFactor {
	if m == nil {
		return nil
	}
	_BACnetAuthenticationFactorCopy := &_BACnetAuthenticationFactor{
		utils.DeepCopy[BACnetAuthenticationFactorTypeTagged](m.FormatType),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.FormatClass),
		utils.DeepCopy[BACnetContextTagOctetString](m.Value),
	}
	return _BACnetAuthenticationFactorCopy
}

func (m *_BACnetAuthenticationFactor) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
