/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AmsSerialAcknowledgeFrame is the corresponding interface of AmsSerialAcknowledgeFrame
type AmsSerialAcknowledgeFrame interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetMagicCookie returns MagicCookie (property field)
	GetMagicCookie() uint16
	// GetTransmitterAddress returns TransmitterAddress (property field)
	GetTransmitterAddress() int8
	// GetReceiverAddress returns ReceiverAddress (property field)
	GetReceiverAddress() int8
	// GetFragmentNumber returns FragmentNumber (property field)
	GetFragmentNumber() int8
	// GetLength returns Length (property field)
	GetLength() int8
	// GetCrc returns Crc (property field)
	GetCrc() uint16
	// IsAmsSerialAcknowledgeFrame is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAmsSerialAcknowledgeFrame()
	// CreateBuilder creates a AmsSerialAcknowledgeFrameBuilder
	CreateAmsSerialAcknowledgeFrameBuilder() AmsSerialAcknowledgeFrameBuilder
}

// _AmsSerialAcknowledgeFrame is the data-structure of this message
type _AmsSerialAcknowledgeFrame struct {
	MagicCookie        uint16
	TransmitterAddress int8
	ReceiverAddress    int8
	FragmentNumber     int8
	Length             int8
	Crc                uint16
}

var _ AmsSerialAcknowledgeFrame = (*_AmsSerialAcknowledgeFrame)(nil)

// NewAmsSerialAcknowledgeFrame factory function for _AmsSerialAcknowledgeFrame
func NewAmsSerialAcknowledgeFrame(magicCookie uint16, transmitterAddress int8, receiverAddress int8, fragmentNumber int8, length int8, crc uint16) *_AmsSerialAcknowledgeFrame {
	return &_AmsSerialAcknowledgeFrame{MagicCookie: magicCookie, TransmitterAddress: transmitterAddress, ReceiverAddress: receiverAddress, FragmentNumber: fragmentNumber, Length: length, Crc: crc}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AmsSerialAcknowledgeFrameBuilder is a builder for AmsSerialAcknowledgeFrame
type AmsSerialAcknowledgeFrameBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(magicCookie uint16, transmitterAddress int8, receiverAddress int8, fragmentNumber int8, length int8, crc uint16) AmsSerialAcknowledgeFrameBuilder
	// WithMagicCookie adds MagicCookie (property field)
	WithMagicCookie(uint16) AmsSerialAcknowledgeFrameBuilder
	// WithTransmitterAddress adds TransmitterAddress (property field)
	WithTransmitterAddress(int8) AmsSerialAcknowledgeFrameBuilder
	// WithReceiverAddress adds ReceiverAddress (property field)
	WithReceiverAddress(int8) AmsSerialAcknowledgeFrameBuilder
	// WithFragmentNumber adds FragmentNumber (property field)
	WithFragmentNumber(int8) AmsSerialAcknowledgeFrameBuilder
	// WithLength adds Length (property field)
	WithLength(int8) AmsSerialAcknowledgeFrameBuilder
	// WithCrc adds Crc (property field)
	WithCrc(uint16) AmsSerialAcknowledgeFrameBuilder
	// Build builds the AmsSerialAcknowledgeFrame or returns an error if something is wrong
	Build() (AmsSerialAcknowledgeFrame, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AmsSerialAcknowledgeFrame
}

// NewAmsSerialAcknowledgeFrameBuilder() creates a AmsSerialAcknowledgeFrameBuilder
func NewAmsSerialAcknowledgeFrameBuilder() AmsSerialAcknowledgeFrameBuilder {
	return &_AmsSerialAcknowledgeFrameBuilder{_AmsSerialAcknowledgeFrame: new(_AmsSerialAcknowledgeFrame)}
}

type _AmsSerialAcknowledgeFrameBuilder struct {
	*_AmsSerialAcknowledgeFrame

	err *utils.MultiError
}

var _ (AmsSerialAcknowledgeFrameBuilder) = (*_AmsSerialAcknowledgeFrameBuilder)(nil)

func (b *_AmsSerialAcknowledgeFrameBuilder) WithMandatoryFields(magicCookie uint16, transmitterAddress int8, receiverAddress int8, fragmentNumber int8, length int8, crc uint16) AmsSerialAcknowledgeFrameBuilder {
	return b.WithMagicCookie(magicCookie).WithTransmitterAddress(transmitterAddress).WithReceiverAddress(receiverAddress).WithFragmentNumber(fragmentNumber).WithLength(length).WithCrc(crc)
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithMagicCookie(magicCookie uint16) AmsSerialAcknowledgeFrameBuilder {
	b.MagicCookie = magicCookie
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithTransmitterAddress(transmitterAddress int8) AmsSerialAcknowledgeFrameBuilder {
	b.TransmitterAddress = transmitterAddress
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithReceiverAddress(receiverAddress int8) AmsSerialAcknowledgeFrameBuilder {
	b.ReceiverAddress = receiverAddress
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithFragmentNumber(fragmentNumber int8) AmsSerialAcknowledgeFrameBuilder {
	b.FragmentNumber = fragmentNumber
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithLength(length int8) AmsSerialAcknowledgeFrameBuilder {
	b.Length = length
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) WithCrc(crc uint16) AmsSerialAcknowledgeFrameBuilder {
	b.Crc = crc
	return b
}

func (b *_AmsSerialAcknowledgeFrameBuilder) Build() (AmsSerialAcknowledgeFrame, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AmsSerialAcknowledgeFrame.deepCopy(), nil
}

func (b *_AmsSerialAcknowledgeFrameBuilder) MustBuild() AmsSerialAcknowledgeFrame {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AmsSerialAcknowledgeFrameBuilder) DeepCopy() any {
	_copy := b.CreateAmsSerialAcknowledgeFrameBuilder().(*_AmsSerialAcknowledgeFrameBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAmsSerialAcknowledgeFrameBuilder creates a AmsSerialAcknowledgeFrameBuilder
func (b *_AmsSerialAcknowledgeFrame) CreateAmsSerialAcknowledgeFrameBuilder() AmsSerialAcknowledgeFrameBuilder {
	if b == nil {
		return NewAmsSerialAcknowledgeFrameBuilder()
	}
	return &_AmsSerialAcknowledgeFrameBuilder{_AmsSerialAcknowledgeFrame: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AmsSerialAcknowledgeFrame) GetMagicCookie() uint16 {
	return m.MagicCookie
}

func (m *_AmsSerialAcknowledgeFrame) GetTransmitterAddress() int8 {
	return m.TransmitterAddress
}

func (m *_AmsSerialAcknowledgeFrame) GetReceiverAddress() int8 {
	return m.ReceiverAddress
}

func (m *_AmsSerialAcknowledgeFrame) GetFragmentNumber() int8 {
	return m.FragmentNumber
}

func (m *_AmsSerialAcknowledgeFrame) GetLength() int8 {
	return m.Length
}

func (m *_AmsSerialAcknowledgeFrame) GetCrc() uint16 {
	return m.Crc
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAmsSerialAcknowledgeFrame(structType any) AmsSerialAcknowledgeFrame {
	if casted, ok := structType.(AmsSerialAcknowledgeFrame); ok {
		return casted
	}
	if casted, ok := structType.(*AmsSerialAcknowledgeFrame); ok {
		return *casted
	}
	return nil
}

func (m *_AmsSerialAcknowledgeFrame) GetTypeName() string {
	return "AmsSerialAcknowledgeFrame"
}

func (m *_AmsSerialAcknowledgeFrame) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (magicCookie)
	lengthInBits += 16

	// Simple field (transmitterAddress)
	lengthInBits += 8

	// Simple field (receiverAddress)
	lengthInBits += 8

	// Simple field (fragmentNumber)
	lengthInBits += 8

	// Simple field (length)
	lengthInBits += 8

	// Simple field (crc)
	lengthInBits += 16

	return lengthInBits
}

func (m *_AmsSerialAcknowledgeFrame) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AmsSerialAcknowledgeFrameParse(ctx context.Context, theBytes []byte) (AmsSerialAcknowledgeFrame, error) {
	return AmsSerialAcknowledgeFrameParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AmsSerialAcknowledgeFrameParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AmsSerialAcknowledgeFrame, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AmsSerialAcknowledgeFrame, error) {
		return AmsSerialAcknowledgeFrameParseWithBuffer(ctx, readBuffer)
	}
}

func AmsSerialAcknowledgeFrameParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AmsSerialAcknowledgeFrame, error) {
	v, err := (&_AmsSerialAcknowledgeFrame{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AmsSerialAcknowledgeFrame) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__amsSerialAcknowledgeFrame AmsSerialAcknowledgeFrame, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AmsSerialAcknowledgeFrame"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AmsSerialAcknowledgeFrame")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	magicCookie, err := ReadSimpleField(ctx, "magicCookie", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'magicCookie' field"))
	}
	m.MagicCookie = magicCookie

	transmitterAddress, err := ReadSimpleField(ctx, "transmitterAddress", ReadSignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transmitterAddress' field"))
	}
	m.TransmitterAddress = transmitterAddress

	receiverAddress, err := ReadSimpleField(ctx, "receiverAddress", ReadSignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'receiverAddress' field"))
	}
	m.ReceiverAddress = receiverAddress

	fragmentNumber, err := ReadSimpleField(ctx, "fragmentNumber", ReadSignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fragmentNumber' field"))
	}
	m.FragmentNumber = fragmentNumber

	length, err := ReadSimpleField(ctx, "length", ReadSignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'length' field"))
	}
	m.Length = length

	crc, err := ReadSimpleField(ctx, "crc", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'crc' field"))
	}
	m.Crc = crc

	if closeErr := readBuffer.CloseContext("AmsSerialAcknowledgeFrame"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AmsSerialAcknowledgeFrame")
	}

	return m, nil
}

func (m *_AmsSerialAcknowledgeFrame) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AmsSerialAcknowledgeFrame) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AmsSerialAcknowledgeFrame"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AmsSerialAcknowledgeFrame")
	}

	if err := WriteSimpleField[uint16](ctx, "magicCookie", m.GetMagicCookie(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'magicCookie' field")
	}

	if err := WriteSimpleField[int8](ctx, "transmitterAddress", m.GetTransmitterAddress(), WriteSignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'transmitterAddress' field")
	}

	if err := WriteSimpleField[int8](ctx, "receiverAddress", m.GetReceiverAddress(), WriteSignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'receiverAddress' field")
	}

	if err := WriteSimpleField[int8](ctx, "fragmentNumber", m.GetFragmentNumber(), WriteSignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'fragmentNumber' field")
	}

	if err := WriteSimpleField[int8](ctx, "length", m.GetLength(), WriteSignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'length' field")
	}

	if err := WriteSimpleField[uint16](ctx, "crc", m.GetCrc(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'crc' field")
	}

	if popErr := writeBuffer.PopContext("AmsSerialAcknowledgeFrame"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AmsSerialAcknowledgeFrame")
	}
	return nil
}

func (m *_AmsSerialAcknowledgeFrame) IsAmsSerialAcknowledgeFrame() {}

func (m *_AmsSerialAcknowledgeFrame) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AmsSerialAcknowledgeFrame) deepCopy() *_AmsSerialAcknowledgeFrame {
	if m == nil {
		return nil
	}
	_AmsSerialAcknowledgeFrameCopy := &_AmsSerialAcknowledgeFrame{
		m.MagicCookie,
		m.TransmitterAddress,
		m.ReceiverAddress,
		m.FragmentNumber,
		m.Length,
		m.Crc,
	}
	return _AmsSerialAcknowledgeFrameCopy
}

func (m *_AmsSerialAcknowledgeFrame) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
