/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsDiscoveryBlockPassword is the corresponding interface of AdsDiscoveryBlockPassword
type AdsDiscoveryBlockPassword interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AdsDiscoveryBlock
	// GetPassword returns Password (property field)
	GetPassword() AmsString
	// IsAdsDiscoveryBlockPassword is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdsDiscoveryBlockPassword()
	// CreateBuilder creates a AdsDiscoveryBlockPasswordBuilder
	CreateAdsDiscoveryBlockPasswordBuilder() AdsDiscoveryBlockPasswordBuilder
}

// _AdsDiscoveryBlockPassword is the data-structure of this message
type _AdsDiscoveryBlockPassword struct {
	AdsDiscoveryBlockContract
	Password AmsString
}

var _ AdsDiscoveryBlockPassword = (*_AdsDiscoveryBlockPassword)(nil)
var _ AdsDiscoveryBlockRequirements = (*_AdsDiscoveryBlockPassword)(nil)

// NewAdsDiscoveryBlockPassword factory function for _AdsDiscoveryBlockPassword
func NewAdsDiscoveryBlockPassword(password AmsString) *_AdsDiscoveryBlockPassword {
	if password == nil {
		panic("password of type AmsString for AdsDiscoveryBlockPassword must not be nil")
	}
	_result := &_AdsDiscoveryBlockPassword{
		AdsDiscoveryBlockContract: NewAdsDiscoveryBlock(),
		Password:                  password,
	}
	_result.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdsDiscoveryBlockPasswordBuilder is a builder for AdsDiscoveryBlockPassword
type AdsDiscoveryBlockPasswordBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(password AmsString) AdsDiscoveryBlockPasswordBuilder
	// WithPassword adds Password (property field)
	WithPassword(AmsString) AdsDiscoveryBlockPasswordBuilder
	// WithPasswordBuilder adds Password (property field) which is build by the builder
	WithPasswordBuilder(func(AmsStringBuilder) AmsStringBuilder) AdsDiscoveryBlockPasswordBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AdsDiscoveryBlockBuilder
	// Build builds the AdsDiscoveryBlockPassword or returns an error if something is wrong
	Build() (AdsDiscoveryBlockPassword, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdsDiscoveryBlockPassword
}

// NewAdsDiscoveryBlockPasswordBuilder() creates a AdsDiscoveryBlockPasswordBuilder
func NewAdsDiscoveryBlockPasswordBuilder() AdsDiscoveryBlockPasswordBuilder {
	return &_AdsDiscoveryBlockPasswordBuilder{_AdsDiscoveryBlockPassword: new(_AdsDiscoveryBlockPassword)}
}

type _AdsDiscoveryBlockPasswordBuilder struct {
	*_AdsDiscoveryBlockPassword

	parentBuilder *_AdsDiscoveryBlockBuilder

	err *utils.MultiError
}

var _ (AdsDiscoveryBlockPasswordBuilder) = (*_AdsDiscoveryBlockPasswordBuilder)(nil)

func (b *_AdsDiscoveryBlockPasswordBuilder) setParent(contract AdsDiscoveryBlockContract) {
	b.AdsDiscoveryBlockContract = contract
	contract.(*_AdsDiscoveryBlock)._SubType = b._AdsDiscoveryBlockPassword
}

func (b *_AdsDiscoveryBlockPasswordBuilder) WithMandatoryFields(password AmsString) AdsDiscoveryBlockPasswordBuilder {
	return b.WithPassword(password)
}

func (b *_AdsDiscoveryBlockPasswordBuilder) WithPassword(password AmsString) AdsDiscoveryBlockPasswordBuilder {
	b.Password = password
	return b
}

func (b *_AdsDiscoveryBlockPasswordBuilder) WithPasswordBuilder(builderSupplier func(AmsStringBuilder) AmsStringBuilder) AdsDiscoveryBlockPasswordBuilder {
	builder := builderSupplier(b.Password.CreateAmsStringBuilder())
	var err error
	b.Password, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "AmsStringBuilder failed"))
	}
	return b
}

func (b *_AdsDiscoveryBlockPasswordBuilder) Build() (AdsDiscoveryBlockPassword, error) {
	if b.Password == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'password' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AdsDiscoveryBlockPassword.deepCopy(), nil
}

func (b *_AdsDiscoveryBlockPasswordBuilder) MustBuild() AdsDiscoveryBlockPassword {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdsDiscoveryBlockPasswordBuilder) Done() AdsDiscoveryBlockBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAdsDiscoveryBlockBuilder().(*_AdsDiscoveryBlockBuilder)
	}
	return b.parentBuilder
}

func (b *_AdsDiscoveryBlockPasswordBuilder) buildForAdsDiscoveryBlock() (AdsDiscoveryBlock, error) {
	return b.Build()
}

func (b *_AdsDiscoveryBlockPasswordBuilder) DeepCopy() any {
	_copy := b.CreateAdsDiscoveryBlockPasswordBuilder().(*_AdsDiscoveryBlockPasswordBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAdsDiscoveryBlockPasswordBuilder creates a AdsDiscoveryBlockPasswordBuilder
func (b *_AdsDiscoveryBlockPassword) CreateAdsDiscoveryBlockPasswordBuilder() AdsDiscoveryBlockPasswordBuilder {
	if b == nil {
		return NewAdsDiscoveryBlockPasswordBuilder()
	}
	return &_AdsDiscoveryBlockPasswordBuilder{_AdsDiscoveryBlockPassword: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsDiscoveryBlockPassword) GetBlockType() AdsDiscoveryBlockType {
	return AdsDiscoveryBlockType_PASSWORD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsDiscoveryBlockPassword) GetParent() AdsDiscoveryBlockContract {
	return m.AdsDiscoveryBlockContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsDiscoveryBlockPassword) GetPassword() AmsString {
	return m.Password
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAdsDiscoveryBlockPassword(structType any) AdsDiscoveryBlockPassword {
	if casted, ok := structType.(AdsDiscoveryBlockPassword); ok {
		return casted
	}
	if casted, ok := structType.(*AdsDiscoveryBlockPassword); ok {
		return *casted
	}
	return nil
}

func (m *_AdsDiscoveryBlockPassword) GetTypeName() string {
	return "AdsDiscoveryBlockPassword"
}

func (m *_AdsDiscoveryBlockPassword) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).getLengthInBits(ctx))

	// Simple field (password)
	lengthInBits += m.Password.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AdsDiscoveryBlockPassword) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AdsDiscoveryBlockPassword) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AdsDiscoveryBlock) (__adsDiscoveryBlockPassword AdsDiscoveryBlockPassword, err error) {
	m.AdsDiscoveryBlockContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdsDiscoveryBlockPassword"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsDiscoveryBlockPassword")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	password, err := ReadSimpleField[AmsString](ctx, "password", ReadComplex[AmsString](AmsStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'password' field"))
	}
	m.Password = password

	if closeErr := readBuffer.CloseContext("AdsDiscoveryBlockPassword"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsDiscoveryBlockPassword")
	}

	return m, nil
}

func (m *_AdsDiscoveryBlockPassword) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsDiscoveryBlockPassword) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsDiscoveryBlockPassword"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsDiscoveryBlockPassword")
		}

		if err := WriteSimpleField[AmsString](ctx, "password", m.GetPassword(), WriteComplex[AmsString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'password' field")
		}

		if popErr := writeBuffer.PopContext("AdsDiscoveryBlockPassword"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsDiscoveryBlockPassword")
		}
		return nil
	}
	return m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsDiscoveryBlockPassword) IsAdsDiscoveryBlockPassword() {}

func (m *_AdsDiscoveryBlockPassword) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdsDiscoveryBlockPassword) deepCopy() *_AdsDiscoveryBlockPassword {
	if m == nil {
		return nil
	}
	_AdsDiscoveryBlockPasswordCopy := &_AdsDiscoveryBlockPassword{
		m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).deepCopy(),
		utils.DeepCopy[AmsString](m.Password),
	}
	_AdsDiscoveryBlockPasswordCopy.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock)._SubType = m
	return _AdsDiscoveryBlockPasswordCopy
}

func (m *_AdsDiscoveryBlockPassword) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
