
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

// Remark: The different fields are encoded in Little-endian.

[type OpcuaConstants
    [const          uint 8     protocolVersion 0]
]

[type OpcuaAPU(bit response) byteOrder='LITTLE_ENDIAN'
    [simple MessagePDU('response') message]
]

[enum string 8 ChunkType
    ['"C"' CONTINUE ]
    ['"F"' FINAL    ]
    ['"A"' ABORT    ]
]

[enum string 24 MessageType
    ['"HEL"' HELLO       ]
    ['"ACK"' ACKNOWLEDGE ]
    ['"ERR"' ERROR       ]
    ['"OPN"' OPEN        ]
    ['"CLO"' CLOSE       ]
    ['"MSG"' MESSAGE     ]
]

[discriminatedType MessagePDU(bit response)
    [discriminator    string 24          messageType]
    [simple           ChunkType          chunk]
    [implicit         uint 32            totalLength 'lengthInBytes']
    [typeSwitch messageType,response
        ['"HEL"','false'      OpcuaHelloRequest
            [simple           uint 32                 version   ]
            [simple           OpcuaProtocolLimits     limits    ]
            [simple           PascalString            endpoint  ]
        ]
        ['"ACK"','true'       OpcuaAcknowledgeResponse
            [simple           uint 32                 version   ]
            [simple           OpcuaProtocolLimits     limits    ]
        ]

        ['"OPN"','false'     OpcuaOpenRequest (uint 32 totalLength)
            [simple          OpenChannelMessage('response')  openRequest]
            [simple          Payload('false', 'totalLength - openRequest.lengthInBytes - 16') message]
        ]
        ['"OPN"','true'      OpcuaOpenResponse (uint 32 totalLength)
            [simple          OpenChannelMessage('response') openResponse]
            [simple          Payload('false', 'totalLength - openResponse.lengthInBytes - 16') message]
        ]
        ['"CLO"','false'     OpcuaCloseRequest
            [simple          SecurityHeader        securityHeader ]
            [simple          Payload('false', '0') message        ]
        ]
        ['"MSG"','false'     OpcuaMessageRequest (uint 32 totalLength)
            [simple          SecurityHeader     securityHeader ]
            [simple          Payload('false', 'totalLength - securityHeader.lengthInBytes - 16') message]
        ]
        ['"MSG"','true'      OpcuaMessageResponse (uint 32 totalLength)
            [simple          SecurityHeader     securityHeader ]
            [simple          Payload('false', 'totalLength - securityHeader.lengthInBytes - 16') message]
        ]
        ['"ERR"','true'      OpcuaMessageError
            [simple          OpcuaStatusCode    error ]
            [simple          PascalString       reason]
        ]
    ]
]

[type OpenChannelMessage (bit response)
    [typeSwitch response
        ['false' OpenChannelMessageRequest
            [simple          int 32             secureChannelId]
            [simple          PascalString       endpoint]
            [simple          PascalByteString   senderCertificate]
            [simple          PascalByteString   receiverCertificateThumbprint]
        ]
        ['true' OpenChannelMessageResponse
            [simple          int 32             secureChannelId]
            [simple          PascalString       securityPolicyUri]
            [simple          PascalByteString   senderCertificate]
            [simple          PascalByteString   receiverCertificateThumbprint]
        ]
    ]
]

[type OpcuaProtocolLimits
    [simple           uint 32             receiveBufferSize]
    [simple           uint 32             sendBufferSize]
    [simple           uint 32             maxMessageSize]
    [simple           uint 32             maxChunkCount]
]

[type SecurityHeader
    [simple           uint 32            secureChannelId]
    [simple           uint 32            secureTokenId]
]

[discriminatedType Payload (bit extensible, uint 32 byteCount)
    [simple SequenceHeader                    sequenceHeader ]
    [typeSwitch extensible
        ['true'       ExtensiblePayload
            [simple   ExtensionObject('false') payload ]
        ]
        ['false'      BinaryPayload
            [array    byte                     payload count 'byteCount']
        ]
    ]
]

[type SequenceHeader
    [simple           int 32             sequenceNumber]
    [simple           int 32             requestId]
]

[type ByteStringArray
    [simple int 32 arrayLength]
    [array uint 8 value count 'arrayLength']
]

[type GuidValue
    [simple uint 32 data1]
    [simple uint 16 data2]
    [simple uint 16 data3]
    [array  byte    data4 count '2']
    [array  byte    data5 count '6']
]

[type ExpandedNodeId
    [simple bit namespaceURISpecified]
    [simple bit serverIndexSpecified]
    [simple NodeIdTypeDefinition nodeId]
    [virtual vstring '-1' identifier 'nodeId.identifier']
    [optional PascalString namespaceURI 'namespaceURISpecified']
    [optional uint 32 serverIndex 'serverIndexSpecified']
]

[type ExtensionHeader
    [reserved int 5 '0x00']
    [simple bit xmlbody]
    [simple bit binaryBody]
]

[type ExtensionObjectEncodingMask
    [reserved int 5 '0x00']
    [simple bit typeIdSpecified]
    [simple bit xmlbody]
    [simple bit binaryBody]
]

[type ExtensionObject(bit includeEncodingMask)
    //A serialized object prefixed with its data type identifier.
    [simple ExpandedNodeId typeId]
    [optional ExtensionObjectEncodingMask encodingMask 'includeEncodingMask']
    [virtual vstring '-1' identifier 'typeId.identifier']
    [simple ExtensionObjectDefinition('identifier') body]
]

[discriminatedType ExtensionObjectDefinition(vstring '-1' identifier)
    [typeSwitch identifier
        ['"0"' NullExtension
        ]

        
        ['"12758"' Union
            
        ]
        ['"14535"' KeyValuePair
            [simple QualifiedName key]
            [simple Variant value]
            
        ]
        ['"16315"' AdditionalParametersType
            [simple int 32 noOfParameters]
            
            [array ExtensionObjectDefinition('"14535"') parameters count 'noOfParameters']
                    
        ]
        ['"17550"' EphemeralKeyType
            [simple PascalByteString publicKey]
            [simple PascalByteString signature]
            
        ]
        ['"15530"' EndpointType
            [simple PascalString endpointUrl]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [simple PascalString transportProfileUri]
            
        ]
        ['"32423"' BitFieldDefinition
            [simple PascalString name]
            [simple LocalizedText description]
            [reserved uint 7 '0x00']
            [reserved bit 'false']
            [simple uint 32 startingBitPosition]
            [simple uint 32 endingBitPosition]
            
        ]
        ['"18808"' RationalNumber
            [simple int 32 numerator]
            [simple uint 32 denominator]
            
        ]
        ['"18809"' OpcuaVector
            
        ]
        ['"18811"' CartesianCoordinates
            
        ]
        ['"18813"' Orientation
            
        ]
        ['"18815"' Frame
            
        ]
        ['"15636"' IdentityMappingRuleType
            [simple IdentityCriteriaType criteriaType]
            [simple PascalString criteria]
            
        ]
        ['"23500"' CurrencyUnitType
            [simple int 16 numericCode]
            [simple int 8 exponent]
            [simple PascalString alphabeticCode]
            [simple LocalizedText currency]
            
        ]
        ['"32436"' AnnotationDataType
            [simple PascalString annotation]
            [simple PascalString discipline]
            [simple PascalString uri]
            
        ]
        ['"32437"' LinearConversionDataType
            [simple float 32 initialAddend]
            [simple float 32 multiplicand]
            [simple float 32 divisor]
            [simple float 32 finalAddend]
            
        ]
        ['"32440"' QuantityDimension
            [simple int 8 massExponent]
            [simple int 8 lengthExponent]
            [simple int 8 timeExponent]
            [simple int 8 electricCurrentExponent]
            [simple int 8 amountOfSubstanceExponent]
            [simple int 8 luminousIntensityExponent]
            [simple int 8 absoluteTemperatureExponent]
            [simple int 8 dimensionlessExponent]
            
        ]
        ['"12556"' TrustListDataType
            [simple uint 32 specifiedLists]
            [simple int 32 noOfTrustedCertificates]
            [array PascalByteString trustedCertificates count 'noOfTrustedCertificates']
                    [simple int 32 noOfTrustedCrls]
            [array PascalByteString trustedCrls count 'noOfTrustedCrls']
                    [simple int 32 noOfIssuerCertificates]
            [array PascalByteString issuerCertificates count 'noOfIssuerCertificates']
                    [simple int 32 noOfIssuerCrls]
            [array PascalByteString issuerCrls count 'noOfIssuerCrls']
                    
        ]
        ['"32287"' TransactionErrorType
            [simple NodeId targetId]
            [simple StatusCode error]
            [simple LocalizedText message]
            
        ]
        ['"15536"' DataTypeSchemaHeader
            [simple int 32 noOfNamespaces]
            [array PascalString namespaces count 'noOfNamespaces']
                    [simple int 32 noOfStructureDataTypes]
            [array DataTypeDescription('"14525"') structureDataTypes count 'noOfStructureDataTypes']
                    [simple int 32 noOfEnumDataTypes]
            [array DataTypeDescription('"14525"') enumDataTypes count 'noOfEnumDataTypes']
                    [simple int 32 noOfSimpleDataTypes]
            [array DataTypeDescription('"14525"') simpleDataTypes count 'noOfSimpleDataTypes']
                    
        ]
        ['"14527"' DataTypeDescription
            [simple NodeId dataTypeId]
            [simple QualifiedName name]
            
        ]
        ['"24107"' PortableQualifiedName
            [simple PascalString namespaceUri]
            [simple PascalString name]
            
        ]
        ['"24109"' UnsignedRationalNumber
            [simple uint 32 numerator]
            [simple uint 32 denominator]
            
        ]
        ['"14526"' FieldMetaData
            [simple PascalString name]
            [simple LocalizedText description]
            [simple DataSetFieldFlags fieldFlags]
            [simple uint 8 builtInType]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [simple int 32 noOfArrayDimensions]
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
                    [simple uint 32 maxStringLength]
            [simple GuidValue dataSetFieldId]
            [simple int 32 noOfProperties]
            
            [array ExtensionObjectDefinition('"14535"') properties count 'noOfProperties']
                    
        ]
        ['"14595"' ConfigurationVersionDataType
            [simple uint 32 majorVersion]
            [simple uint 32 minorVersion]
            
        ]
        ['"15582"' PublishedDataSetSourceDataType
            
        ]
        ['"14275"' PublishedVariableDataType
            [simple NodeId publishedVariable]
            [simple uint 32 attributeId]
            [simple float 64 samplingIntervalHint]
            [simple uint 32 deadbandType]
            [simple float 64 deadbandValue]
            [simple PascalString indexRange]
            [simple Variant substituteValue]
            [simple int 32 noOfMetaDataProperties]
            [array QualifiedName metaDataProperties count 'noOfMetaDataProperties']
                    
        ]
        ['"15599"' DataSetWriterDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple uint 16 dataSetWriterId]
            [simple DataSetFieldContentMask dataSetFieldContentMask]
            [simple uint 32 keyFrameCount]
            [simple PascalString dataSetName]
            [simple int 32 noOfDataSetWriterProperties]
            
            [array ExtensionObjectDefinition('"14535"') dataSetWriterProperties count 'noOfDataSetWriterProperties']
                    [simple ExtensionObject('true') transportSettings]
            [simple ExtensionObject('true') messageSettings]
            
        ]
        ['"15600"' DataSetWriterTransportDataType
            
        ]
        ['"15607"' DataSetWriterMessageDataType
            
        ]
        ['"15611"' PubSubGroupDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityGroupId]
            [simple int 32 noOfSecurityKeyServices]
            
            [array ExtensionObjectDefinition('"314"') securityKeyServices count 'noOfSecurityKeyServices']
                    [simple uint 32 maxNetworkMessageSize]
            [simple int 32 noOfGroupProperties]
            
            [array ExtensionObjectDefinition('"14535"') groupProperties count 'noOfGroupProperties']
                    
        ]
        ['"15613"' WriterGroupTransportDataType
            
        ]
        ['"15618"' WriterGroupMessageDataType
            
        ]
        ['"15619"' PubSubConnectionDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple Variant publisherId]
            [simple PascalString transportProfileUri]
            [simple ExtensionObject('true') address]
            [simple int 32 noOfConnectionProperties]
            
            [array ExtensionObjectDefinition('"14535"') connectionProperties count 'noOfConnectionProperties']
                    [simple ExtensionObject('true') transportSettings]
            [simple int 32 noOfWriterGroups]
            [array PubSubGroupDataType('"15609"') writerGroups count 'noOfWriterGroups']
                    [simple int 32 noOfReaderGroups]
            [array PubSubGroupDataType('"15609"') readerGroups count 'noOfReaderGroups']
                    
        ]
        ['"15620"' ConnectionTransportDataType
            
        ]
        ['"15504"' NetworkAddressDataType
            [simple PascalString networkInterface]
            
        ]
        ['"15623"' ReaderGroupTransportDataType
            
        ]
        ['"15624"' ReaderGroupMessageDataType
            
        ]
        ['"15630"' DataSetReaderTransportDataType
            
        ]
        ['"15631"' DataSetReaderMessageDataType
            
        ]
        ['"15632"' SubscribedDataSetDataType
            
        ]
        ['"14746"' FieldTargetDataType
            [simple GuidValue dataSetFieldId]
            [simple PascalString receiverIndexRange]
            [simple NodeId targetNodeId]
            [simple uint 32 attributeId]
            [simple PascalString writeIndexRange]
            [simple OverrideValueHandling overrideValueHandling]
            [simple Variant overrideValue]
            
        ]
        ['"15532"' PubSubConfigurationDataType
            [simple int 32 noOfPublishedDataSets]
            
            [array ExtensionObjectDefinition('"15580"') publishedDataSets count 'noOfPublishedDataSets']
                    [simple int 32 noOfConnections]
            
            [array ExtensionObjectDefinition('"15619"') connections count 'noOfConnections']
                    [reserved uint 7 '0x00']
            [simple bit enabled]
            
        ]
        ['"23603"' SecurityGroupDataType
            [simple PascalString name]
            [simple int 32 noOfSecurityGroupFolder]
            [array PascalString securityGroupFolder count 'noOfSecurityGroupFolder']
                    [simple float 64 keyLifetime]
            [simple PascalString securityPolicyUri]
            [simple uint 32 maxFutureKeyCount]
            [simple uint 32 maxPastKeyCount]
            [simple PascalString securityGroupId]
            [simple int 32 noOfRolePermissions]
            
            [array ExtensionObjectDefinition('"98"') rolePermissions count 'noOfRolePermissions']
                    [simple int 32 noOfGroupProperties]
            
            [array ExtensionObjectDefinition('"14535"') groupProperties count 'noOfGroupProperties']
                    
        ]
        ['"25272"' PubSubKeyPushTargetDataType
            [simple PascalString applicationUri]
            [simple int 32 noOfPushTargetFolder]
            [array PascalString pushTargetFolder count 'noOfPushTargetFolder']
                    [simple PascalString endpointUrl]
            [simple PascalString securityPolicyUri]
            
            [simple ExtensionObjectDefinition('"306"') userTokenType]
            [simple uint 16 requestedKeyCount]
            [simple float 64 retryInterval]
            [simple int 32 noOfPushTargetProperties]
            
            [array ExtensionObjectDefinition('"14535"') pushTargetProperties count 'noOfPushTargetProperties']
                    [simple int 32 noOfSecurityGroups]
            [array PascalString securityGroups count 'noOfSecurityGroups']
                    
        ]
        ['"23605"' QosDataType
            
        ]
        ['"25521"' PubSubConfigurationRefDataType
            [simple PubSubConfigurationRefMask configurationMask]
            [simple uint 16 elementIndex]
            [simple uint 16 connectionIndex]
            [simple uint 16 groupIndex]
            
        ]
        ['"23470"' AliasNameDataType
            [simple QualifiedName aliasName]
            [simple int 32 noOfReferencedNodes]
            [array ExpandedNodeId referencedNodes count 'noOfReferencedNodes']
                    
        ]
        ['"24283"' UserManagementDataType
            [simple PascalString userName]
            [simple UserConfigurationMask userConfiguration]
            [simple PascalString description]
            
        ]
        ['"25222"' PriorityMappingEntryType
            [simple PascalString mappingUri]
            [simple PascalString priorityLabel]
            [simple uint 8 priorityValue_PCP]
            [simple uint 32 priorityValue_DSCP]
            
        ]
        ['"32661"' ReferenceDescriptionDataType
            [simple NodeId sourceNode]
            [simple NodeId referenceType]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNode]
            
        ]
        ['"32662"' ReferenceListEntryDataType
            [simple NodeId referenceType]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNode]
            
        ]
        ['"98"' RolePermissionType
            [simple NodeId roleId]
            [simple PermissionType permissions]
            
        ]
        ['"99"' DataTypeDefinition
            
        ]
        ['"103"' StructureField
            [simple PascalString name]
            [simple LocalizedText description]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [simple int 32 noOfArrayDimensions]
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
                    [simple uint 32 maxStringLength]
            [reserved uint 7 '0x00']
            [simple bit isOptional]
            
        ]
        ['"298"' Argument
            [simple PascalString name]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [simple int 32 noOfArrayDimensions]
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
                    [simple LocalizedText description]
            
        ]
        ['"7596"' EnumValueType
            [simple int 64 value]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            
        ]
        ['"12757"' OptionSet
            [simple PascalByteString value]
            [simple PascalByteString validBits]
            
        ]
        ['"8914"' TimeZoneDataType
            [simple int 16 offset]
            [reserved uint 7 '0x00']
            [simple bit daylightSavingInOffset]
            
        ]
        ['"310"' ApplicationDescription
            [simple PascalString applicationUri]
            [simple PascalString productUri]
            [simple LocalizedText applicationName]
            [simple ApplicationType applicationType]
            [simple PascalString gatewayServerUri]
            [simple PascalString discoveryProfileUri]
            [simple int 32 noOfDiscoveryUrls]
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
                    
        ]
        ['"391"' RequestHeader
            [simple NodeId authenticationToken]
            [simple int 64 timestamp]
            [simple uint 32 requestHandle]
            [simple uint 32 returnDiagnostics]
            [simple PascalString auditEntryId]
            [simple uint 32 timeoutHint]
            [simple ExtensionObject('true') additionalHeader]
            
        ]
        ['"394"' ResponseHeader
            [simple int 64 timestamp]
            [simple uint 32 requestHandle]
            [simple StatusCode serviceResult]
            [simple DiagnosticInfo serviceDiagnostics]
            [simple int 32 noOfStringTable]
            [array PascalString stringTable count 'noOfStringTable']
                    [simple ExtensionObject('true') additionalHeader]
            
        ]
        ['"397"' ServiceFault
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
        ]
        ['"15903"' SessionlessInvokeRequestType
            [simple uint 32 urisVersion]
            [simple int 32 noOfNamespaceUris]
            [array PascalString namespaceUris count 'noOfNamespaceUris']
                    [simple int 32 noOfServerUris]
            [array PascalString serverUris count 'noOfServerUris']
                    [simple int 32 noOfLocaleIds]
            [array PascalString localeIds count 'noOfLocaleIds']
                    [simple uint 32 serviceId]
            
        ]
        ['"21001"' SessionlessInvokeResponseType
            [simple int 32 noOfNamespaceUris]
            [array PascalString namespaceUris count 'noOfNamespaceUris']
                    [simple int 32 noOfServerUris]
            [array PascalString serverUris count 'noOfServerUris']
                    [simple uint 32 serviceId]
            
        ]
        ['"422"' FindServersRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple PascalString endpointUrl]
            [simple int 32 noOfLocaleIds]
            [array PascalString localeIds count 'noOfLocaleIds']
                    [simple int 32 noOfServerUris]
            [array PascalString serverUris count 'noOfServerUris']
                    
        ]
        ['"425"' FindServersResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfServers]
            
            [array ExtensionObjectDefinition('"310"') servers count 'noOfServers']
                    
        ]
        ['"12191"' ServerOnNetwork
            [simple uint 32 recordId]
            [simple PascalString serverName]
            [simple PascalString discoveryUrl]
            [simple int 32 noOfServerCapabilities]
            [array PascalString serverCapabilities count 'noOfServerCapabilities']
                    
        ]
        ['"12192"' FindServersOnNetworkRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 startingRecordId]
            [simple uint 32 maxRecordsToReturn]
            [simple int 32 noOfServerCapabilityFilter]
            [array PascalString serverCapabilityFilter count 'noOfServerCapabilityFilter']
                    
        ]
        ['"12193"' FindServersOnNetworkResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 64 lastCounterResetTime]
            [simple int 32 noOfServers]
            
            [array ExtensionObjectDefinition('"12191"') servers count 'noOfServers']
                    
        ]
        ['"306"' UserTokenPolicy
            [simple PascalString policyId]
            [simple UserTokenType tokenType]
            [simple PascalString issuedTokenType]
            [simple PascalString issuerEndpointUrl]
            [simple PascalString securityPolicyUri]
            
        ]
        ['"314"' EndpointDescription
            [simple PascalString endpointUrl]
            
            [simple ExtensionObjectDefinition('"310"') server]
            [simple PascalByteString serverCertificate]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [simple int 32 noOfUserIdentityTokens]
            
            [array ExtensionObjectDefinition('"306"') userIdentityTokens count 'noOfUserIdentityTokens']
                    [simple PascalString transportProfileUri]
            [simple uint 8 securityLevel]
            
        ]
        ['"428"' GetEndpointsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple PascalString endpointUrl]
            [simple int 32 noOfLocaleIds]
            [array PascalString localeIds count 'noOfLocaleIds']
                    [simple int 32 noOfProfileUris]
            [array PascalString profileUris count 'noOfProfileUris']
                    
        ]
        ['"431"' GetEndpointsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfEndpoints]
            
            [array ExtensionObjectDefinition('"314"') endpoints count 'noOfEndpoints']
                    
        ]
        ['"434"' RegisteredServer
            [simple PascalString serverUri]
            [simple PascalString productUri]
            [simple int 32 noOfServerNames]
            [array LocalizedText serverNames count 'noOfServerNames']
                    [simple ApplicationType serverType]
            [simple PascalString gatewayServerUri]
            [simple int 32 noOfDiscoveryUrls]
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
                    [simple PascalString semaphoreFilePath]
            [reserved uint 7 '0x00']
            [simple bit isOnline]
            
        ]
        ['"437"' RegisterServerRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"434"') server]
            
        ]
        ['"440"' RegisterServerResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
        ]
        ['"12892"' DiscoveryConfiguration
            
        ]
        ['"12195"' RegisterServer2Request
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"434"') server]
            [simple int 32 noOfDiscoveryConfiguration]
            [array ExtensionObject('true') discoveryConfiguration count 'noOfDiscoveryConfiguration']
                    
        ]
        ['"12196"' RegisterServer2Response
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfConfigurationResults]
            [array StatusCode configurationResults count 'noOfConfigurationResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"443"' ChannelSecurityToken
            [simple uint 32 channelId]
            [simple uint 32 tokenId]
            [simple int 64 createdAt]
            [simple uint 32 revisedLifetime]
            
        ]
        ['"446"' OpenSecureChannelRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 clientProtocolVersion]
            [simple SecurityTokenRequestType requestType]
            [simple MessageSecurityMode securityMode]
            [simple PascalByteString clientNonce]
            [simple uint 32 requestedLifetime]
            
        ]
        ['"449"' OpenSecureChannelResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple uint 32 serverProtocolVersion]
            
            [simple ExtensionObjectDefinition('"443"') securityToken]
            [simple PascalByteString serverNonce]
            
        ]
        ['"452"' CloseSecureChannelRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
        ]
        ['"455"' CloseSecureChannelResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
        ]
        ['"346"' SignedSoftwareCertificate
            [simple PascalByteString certificateData]
            [simple PascalByteString signature]
            
        ]
        ['"458"' SignatureData
            [simple PascalString algorithm]
            [simple PascalByteString signature]
            
        ]
        ['"461"' CreateSessionRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"310"') clientDescription]
            [simple PascalString serverUri]
            [simple PascalString endpointUrl]
            [simple PascalString sessionName]
            [simple PascalByteString clientNonce]
            [simple PascalByteString clientCertificate]
            [simple float 64 requestedSessionTimeout]
            [simple uint 32 maxResponseMessageSize]
            
        ]
        ['"464"' CreateSessionResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple NodeId sessionId]
            [simple NodeId authenticationToken]
            [simple float 64 revisedSessionTimeout]
            [simple PascalByteString serverNonce]
            [simple PascalByteString serverCertificate]
            [simple int 32 noOfServerEndpoints]
            
            [array ExtensionObjectDefinition('"314"') serverEndpoints count 'noOfServerEndpoints']
                    [simple int 32 noOfServerSoftwareCertificates]
            
            [array ExtensionObjectDefinition('"346"') serverSoftwareCertificates count 'noOfServerSoftwareCertificates']
                    
            [simple ExtensionObjectDefinition('"458"') serverSignature]
            [simple uint 32 maxRequestMessageSize]
            
        ]
        ['"467"' ActivateSessionRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"458"') clientSignature]
            [simple int 32 noOfClientSoftwareCertificates]
            
            [array ExtensionObjectDefinition('"346"') clientSoftwareCertificates count 'noOfClientSoftwareCertificates']
                    [simple int 32 noOfLocaleIds]
            [array PascalString localeIds count 'noOfLocaleIds']
                    [simple ExtensionObject('true') userIdentityToken]
            
            [simple ExtensionObjectDefinition('"458"') userTokenSignature]
            
        ]
        ['"470"' ActivateSessionResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple PascalByteString serverNonce]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"473"' CloseSessionRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit deleteSubscriptions]
            
        ]
        ['"476"' CloseSessionResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
        ]
        ['"479"' CancelRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 requestHandle]
            
        ]
        ['"482"' CancelResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple uint 32 cancelCount]
            
        ]
        ['"351"' NodeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            
        ]
        ['"17608"' GenericAttributeValue
            [simple uint 32 attributeId]
            [simple Variant value]
            
        ]
        ['"378"' AddNodesItem
            [simple ExpandedNodeId parentNodeId]
            [simple NodeId referenceTypeId]
            [simple ExpandedNodeId requestedNewNodeId]
            [simple QualifiedName browseName]
            [simple NodeClass nodeClass]
            [simple ExtensionObject('true') nodeAttributes]
            [simple ExpandedNodeId typeDefinition]
            
        ]
        ['"485"' AddNodesResult
            [simple StatusCode statusCode]
            [simple NodeId addedNodeId]
            
        ]
        ['"488"' AddNodesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfNodesToAdd]
            
            [array ExtensionObjectDefinition('"378"') nodesToAdd count 'noOfNodesToAdd']
                    
        ]
        ['"491"' AddNodesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"485"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"381"' AddReferencesItem
            [simple NodeId sourceNodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple PascalString targetServerUri]
            [simple ExpandedNodeId targetNodeId]
            [simple NodeClass targetNodeClass]
            
        ]
        ['"494"' AddReferencesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfReferencesToAdd]
            
            [array ExtensionObjectDefinition('"381"') referencesToAdd count 'noOfReferencesToAdd']
                    
        ]
        ['"497"' AddReferencesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"384"' DeleteNodesItem
            [simple NodeId nodeId]
            [reserved uint 7 '0x00']
            [simple bit deleteTargetReferences]
            
        ]
        ['"500"' DeleteNodesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfNodesToDelete]
            
            [array ExtensionObjectDefinition('"384"') nodesToDelete count 'noOfNodesToDelete']
                    
        ]
        ['"503"' DeleteNodesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"387"' DeleteReferencesItem
            [simple NodeId sourceNodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNodeId]
            [reserved uint 7 '0x00']
            [simple bit deleteBidirectional]
            
        ]
        ['"506"' DeleteReferencesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfReferencesToDelete]
            
            [array ExtensionObjectDefinition('"387"') referencesToDelete count 'noOfReferencesToDelete']
                    
        ]
        ['"509"' DeleteReferencesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"513"' ViewDescription
            [simple NodeId viewId]
            [simple int 64 timestamp]
            [simple uint 32 viewVersion]
            
        ]
        ['"516"' BrowseDescription
            [simple NodeId nodeId]
            [simple BrowseDirection browseDirection]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit includeSubtypes]
            [simple uint 32 nodeClassMask]
            [simple uint 32 resultMask]
            
        ]
        ['"520"' ReferenceDescription
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId nodeId]
            [simple QualifiedName browseName]
            [simple LocalizedText displayName]
            [simple NodeClass nodeClass]
            [simple ExpandedNodeId typeDefinition]
            
        ]
        ['"524"' BrowseResult
            [simple StatusCode statusCode]
            [simple PascalByteString continuationPoint]
            [simple int 32 noOfReferences]
            
            [array ExtensionObjectDefinition('"520"') references count 'noOfReferences']
                    
        ]
        ['"527"' BrowseRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"513"') view]
            [simple uint 32 requestedMaxReferencesPerNode]
            [simple int 32 noOfNodesToBrowse]
            
            [array ExtensionObjectDefinition('"516"') nodesToBrowse count 'noOfNodesToBrowse']
                    
        ]
        ['"530"' BrowseResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"524"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"533"' BrowseNextRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoints]
            [simple int 32 noOfContinuationPoints]
            [array PascalByteString continuationPoints count 'noOfContinuationPoints']
                    
        ]
        ['"536"' BrowseNextResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"524"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"539"' RelativePathElement
            [simple NodeId referenceTypeId]
            [reserved uint 6 '0x00']
            [simple bit includeSubtypes]
            [simple bit isInverse]
            [simple QualifiedName targetName]
            
        ]
        ['"542"' RelativePath
            [simple int 32 noOfElements]
            
            [array ExtensionObjectDefinition('"539"') elements count 'noOfElements']
                    
        ]
        ['"545"' BrowsePath
            [simple NodeId startingNode]
            
            [simple ExtensionObjectDefinition('"542"') relativePath]
            
        ]
        ['"548"' BrowsePathTarget
            [simple ExpandedNodeId targetId]
            [simple uint 32 remainingPathIndex]
            
        ]
        ['"551"' BrowsePathResult
            [simple StatusCode statusCode]
            [simple int 32 noOfTargets]
            
            [array ExtensionObjectDefinition('"548"') targets count 'noOfTargets']
                    
        ]
        ['"554"' TranslateBrowsePathsToNodeIdsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfBrowsePaths]
            
            [array ExtensionObjectDefinition('"545"') browsePaths count 'noOfBrowsePaths']
                    
        ]
        ['"557"' TranslateBrowsePathsToNodeIdsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"551"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"560"' RegisterNodesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfNodesToRegister]
            [array NodeId nodesToRegister count 'noOfNodesToRegister']
                    
        ]
        ['"563"' RegisterNodesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfRegisteredNodeIds]
            [array NodeId registeredNodeIds count 'noOfRegisteredNodeIds']
                    
        ]
        ['"566"' UnregisterNodesRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfNodesToUnregister]
            [array NodeId nodesToUnregister count 'noOfNodesToUnregister']
                    
        ]
        ['"569"' UnregisterNodesResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
        ]
        ['"333"' EndpointConfiguration
            [simple int 32 operationTimeout]
            [reserved uint 7 '0x00']
            [simple bit useBinaryEncoding]
            [simple int 32 maxStringLength]
            [simple int 32 maxByteStringLength]
            [simple int 32 maxArrayLength]
            [simple int 32 maxMessageSize]
            [simple int 32 maxBufferSize]
            [simple int 32 channelLifetime]
            [simple int 32 securityTokenLifetime]
            
        ]
        ['"572"' QueryDataDescription
            
            [simple ExtensionObjectDefinition('"542"') relativePath]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
            
        ]
        ['"575"' NodeTypeDescription
            [simple ExpandedNodeId typeDefinitionNode]
            [reserved uint 7 '0x00']
            [simple bit includeSubTypes]
            [simple int 32 noOfDataToReturn]
            
            [array ExtensionObjectDefinition('"572"') dataToReturn count 'noOfDataToReturn']
                    
        ]
        ['"579"' QueryDataSet
            [simple ExpandedNodeId nodeId]
            [simple ExpandedNodeId typeDefinitionNode]
            [simple int 32 noOfValues]
            [array Variant values count 'noOfValues']
                    
        ]
        ['"582"' NodeReference
            [simple NodeId nodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple int 32 noOfReferencedNodeIds]
            [array NodeId referencedNodeIds count 'noOfReferencedNodeIds']
                    
        ]
        ['"585"' ContentFilterElement
            [simple FilterOperator filterOperator]
            [simple int 32 noOfFilterOperands]
            [array ExtensionObject('true') filterOperands count 'noOfFilterOperands']
                    
        ]
        ['"588"' ContentFilter
            [simple int 32 noOfElements]
            
            [array ExtensionObjectDefinition('"585"') elements count 'noOfElements']
                    
        ]
        ['"591"' FilterOperand
            
        ]
        ['"606"' ContentFilterElementResult
            [simple StatusCode statusCode]
            [simple int 32 noOfOperandStatusCodes]
            [array StatusCode operandStatusCodes count 'noOfOperandStatusCodes']
                    [simple int 32 noOfOperandDiagnosticInfos]
            [array DiagnosticInfo operandDiagnosticInfos count 'noOfOperandDiagnosticInfos']
                    
        ]
        ['"609"' ContentFilterResult
            [simple int 32 noOfElementResults]
            
            [array ExtensionObjectDefinition('"606"') elementResults count 'noOfElementResults']
                    [simple int 32 noOfElementDiagnosticInfos]
            [array DiagnosticInfo elementDiagnosticInfos count 'noOfElementDiagnosticInfos']
                    
        ]
        ['"612"' ParsingResult
            [simple StatusCode statusCode]
            [simple int 32 noOfDataStatusCodes]
            [array StatusCode dataStatusCodes count 'noOfDataStatusCodes']
                    [simple int 32 noOfDataDiagnosticInfos]
            [array DiagnosticInfo dataDiagnosticInfos count 'noOfDataDiagnosticInfos']
                    
        ]
        ['"615"' QueryFirstRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            
            [simple ExtensionObjectDefinition('"513"') view]
            [simple int 32 noOfNodeTypes]
            
            [array ExtensionObjectDefinition('"575"') nodeTypes count 'noOfNodeTypes']
                    
            [simple ExtensionObjectDefinition('"588"') filter]
            [simple uint 32 maxDataSetsToReturn]
            [simple uint 32 maxReferencesToReturn]
            
        ]
        ['"618"' QueryFirstResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfQueryDataSets]
            
            [array ExtensionObjectDefinition('"579"') queryDataSets count 'noOfQueryDataSets']
                    [simple PascalByteString continuationPoint]
            [simple int 32 noOfParsingResults]
            
            [array ExtensionObjectDefinition('"612"') parsingResults count 'noOfParsingResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
            [simple ExtensionObjectDefinition('"609"') filterResult]
            
        ]
        ['"621"' QueryNextRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoint]
            [simple PascalByteString continuationPoint]
            
        ]
        ['"624"' QueryNextResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfQueryDataSets]
            
            [array ExtensionObjectDefinition('"579"') queryDataSets count 'noOfQueryDataSets']
                    [simple PascalByteString revisedContinuationPoint]
            
        ]
        ['"628"' ReadValueId
            [simple NodeId nodeId]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
            [simple QualifiedName dataEncoding]
            
        ]
        ['"631"' ReadRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple float 64 maxAge]
            [simple TimestampsToReturn timestampsToReturn]
            [simple int 32 noOfNodesToRead]
            
            [array ExtensionObjectDefinition('"628"') nodesToRead count 'noOfNodesToRead']
                    
        ]
        ['"634"' ReadResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array DataValue results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"637"' HistoryReadValueId
            [simple NodeId nodeId]
            [simple PascalString indexRange]
            [simple QualifiedName dataEncoding]
            [simple PascalByteString continuationPoint]
            
        ]
        ['"640"' HistoryReadResult
            [simple StatusCode statusCode]
            [simple PascalByteString continuationPoint]
            [simple ExtensionObject('true') historyData]
            
        ]
        ['"643"' HistoryReadDetails
            
        ]
        ['"658"' HistoryData
            [simple int 32 noOfDataValues]
            [array DataValue dataValues count 'noOfDataValues']
                    
        ]
        ['"11218"' ModificationInfo
            [simple int 64 modificationTime]
            [simple HistoryUpdateType updateType]
            [simple PascalString userName]
            
        ]
        ['"661"' HistoryEvent
            [simple int 32 noOfEvents]
            
            [array ExtensionObjectDefinition('"922"') events count 'noOfEvents']
                    
        ]
        ['"664"' HistoryReadRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple ExtensionObject('true') historyReadDetails]
            [simple TimestampsToReturn timestampsToReturn]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoints]
            [simple int 32 noOfNodesToRead]
            
            [array ExtensionObjectDefinition('"637"') nodesToRead count 'noOfNodesToRead']
                    
        ]
        ['"667"' HistoryReadResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"640"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"670"' WriteValue
            [simple NodeId nodeId]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
            [simple DataValue value]
            
        ]
        ['"673"' WriteRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfNodesToWrite]
            
            [array ExtensionObjectDefinition('"670"') nodesToWrite count 'noOfNodesToWrite']
                    
        ]
        ['"676"' WriteResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"679"' HistoryUpdateDetails
            
        ]
        ['"697"' HistoryUpdateResult
            [simple StatusCode statusCode]
            [simple int 32 noOfOperationResults]
            [array StatusCode operationResults count 'noOfOperationResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"700"' HistoryUpdateRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfHistoryUpdateDetails]
            [array ExtensionObject('true') historyUpdateDetails count 'noOfHistoryUpdateDetails']
                    
        ]
        ['"703"' HistoryUpdateResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"697"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"706"' CallMethodRequest
            [simple NodeId objectId]
            [simple NodeId methodId]
            [simple int 32 noOfInputArguments]
            [array Variant inputArguments count 'noOfInputArguments']
                    
        ]
        ['"709"' CallMethodResult
            [simple StatusCode statusCode]
            [simple int 32 noOfInputArgumentResults]
            [array StatusCode inputArgumentResults count 'noOfInputArgumentResults']
                    [simple int 32 noOfInputArgumentDiagnosticInfos]
            [array DiagnosticInfo inputArgumentDiagnosticInfos count 'noOfInputArgumentDiagnosticInfos']
                    [simple int 32 noOfOutputArguments]
            [array Variant outputArguments count 'noOfOutputArguments']
                    
        ]
        ['"712"' CallRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfMethodsToCall]
            
            [array ExtensionObjectDefinition('"706"') methodsToCall count 'noOfMethodsToCall']
                    
        ]
        ['"715"' CallResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"709"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"721"' MonitoringFilter
            
        ]
        ['"950"' AggregateConfiguration
            [reserved uint 6 '0x00']
            [simple bit treatUncertainAsBad]
            [simple bit useServerCapabilitiesDefaults]
            [simple uint 8 percentDataBad]
            [simple uint 8 percentDataGood]
            [reserved uint 7 '0x00']
            [simple bit useSlopedExtrapolation]
            
        ]
        ['"733"' MonitoringFilterResult
            
        ]
        ['"742"' MonitoringParameters
            [simple uint 32 clientHandle]
            [simple float 64 samplingInterval]
            [simple ExtensionObject('true') filter]
            [simple uint 32 queueSize]
            [reserved uint 7 '0x00']
            [simple bit discardOldest]
            
        ]
        ['"745"' MonitoredItemCreateRequest
            
            [simple ExtensionObjectDefinition('"628"') itemToMonitor]
            [simple MonitoringMode monitoringMode]
            
            [simple ExtensionObjectDefinition('"742"') requestedParameters]
            
        ]
        ['"748"' MonitoredItemCreateResult
            [simple StatusCode statusCode]
            [simple uint 32 monitoredItemId]
            [simple float 64 revisedSamplingInterval]
            [simple uint 32 revisedQueueSize]
            [simple ExtensionObject('true') filterResult]
            
        ]
        ['"751"' CreateMonitoredItemsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple TimestampsToReturn timestampsToReturn]
            [simple int 32 noOfItemsToCreate]
            
            [array ExtensionObjectDefinition('"745"') itemsToCreate count 'noOfItemsToCreate']
                    
        ]
        ['"754"' CreateMonitoredItemsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"748"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"757"' MonitoredItemModifyRequest
            [simple uint 32 monitoredItemId]
            
            [simple ExtensionObjectDefinition('"742"') requestedParameters]
            
        ]
        ['"760"' MonitoredItemModifyResult
            [simple StatusCode statusCode]
            [simple float 64 revisedSamplingInterval]
            [simple uint 32 revisedQueueSize]
            [simple ExtensionObject('true') filterResult]
            
        ]
        ['"763"' ModifyMonitoredItemsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple TimestampsToReturn timestampsToReturn]
            [simple int 32 noOfItemsToModify]
            
            [array ExtensionObjectDefinition('"757"') itemsToModify count 'noOfItemsToModify']
                    
        ]
        ['"766"' ModifyMonitoredItemsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"760"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"769"' SetMonitoringModeRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple MonitoringMode monitoringMode]
            [simple int 32 noOfMonitoredItemIds]
            [array uint 32 monitoredItemIds count 'noOfMonitoredItemIds']
                    
        ]
        ['"772"' SetMonitoringModeResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"775"' SetTriggeringRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple uint 32 triggeringItemId]
            [simple int 32 noOfLinksToAdd]
            [array uint 32 linksToAdd count 'noOfLinksToAdd']
                    [simple int 32 noOfLinksToRemove]
            [array uint 32 linksToRemove count 'noOfLinksToRemove']
                    
        ]
        ['"778"' SetTriggeringResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfAddResults]
            [array StatusCode addResults count 'noOfAddResults']
                    [simple int 32 noOfAddDiagnosticInfos]
            [array DiagnosticInfo addDiagnosticInfos count 'noOfAddDiagnosticInfos']
                    [simple int 32 noOfRemoveResults]
            [array StatusCode removeResults count 'noOfRemoveResults']
                    [simple int 32 noOfRemoveDiagnosticInfos]
            [array DiagnosticInfo removeDiagnosticInfos count 'noOfRemoveDiagnosticInfos']
                    
        ]
        ['"781"' DeleteMonitoredItemsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple int 32 noOfMonitoredItemIds]
            [array uint 32 monitoredItemIds count 'noOfMonitoredItemIds']
                    
        ]
        ['"784"' DeleteMonitoredItemsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"787"' CreateSubscriptionRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple float 64 requestedPublishingInterval]
            [simple uint 32 requestedLifetimeCount]
            [simple uint 32 requestedMaxKeepAliveCount]
            [simple uint 32 maxNotificationsPerPublish]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [simple uint 8 priority]
            
        ]
        ['"790"' CreateSubscriptionResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple uint 32 subscriptionId]
            [simple float 64 revisedPublishingInterval]
            [simple uint 32 revisedLifetimeCount]
            [simple uint 32 revisedMaxKeepAliveCount]
            
        ]
        ['"793"' ModifySubscriptionRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple float 64 requestedPublishingInterval]
            [simple uint 32 requestedLifetimeCount]
            [simple uint 32 requestedMaxKeepAliveCount]
            [simple uint 32 maxNotificationsPerPublish]
            [simple uint 8 priority]
            
        ]
        ['"796"' ModifySubscriptionResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple float 64 revisedPublishingInterval]
            [simple uint 32 revisedLifetimeCount]
            [simple uint 32 revisedMaxKeepAliveCount]
            
        ]
        ['"799"' SetPublishingModeRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [simple int 32 noOfSubscriptionIds]
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
                    
        ]
        ['"802"' SetPublishingModeResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"805"' NotificationMessage
            [simple uint 32 sequenceNumber]
            [simple int 64 publishTime]
            [simple int 32 noOfNotificationData]
            [array ExtensionObject('true') notificationData count 'noOfNotificationData']
                    
        ]
        ['"947"' NotificationData
            
        ]
        ['"808"' MonitoredItemNotification
            [simple uint 32 clientHandle]
            [simple DataValue value]
            
        ]
        ['"919"' EventFieldList
            [simple uint 32 clientHandle]
            [simple int 32 noOfEventFields]
            [array Variant eventFields count 'noOfEventFields']
                    
        ]
        ['"922"' HistoryEventFieldList
            [simple int 32 noOfEventFields]
            [array Variant eventFields count 'noOfEventFields']
                    
        ]
        ['"823"' SubscriptionAcknowledgement
            [simple uint 32 subscriptionId]
            [simple uint 32 sequenceNumber]
            
        ]
        ['"826"' PublishRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfSubscriptionAcknowledgements]
            
            [array ExtensionObjectDefinition('"823"') subscriptionAcknowledgements count 'noOfSubscriptionAcknowledgements']
                    
        ]
        ['"829"' PublishResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple uint 32 subscriptionId]
            [simple int 32 noOfAvailableSequenceNumbers]
            [array uint 32 availableSequenceNumbers count 'noOfAvailableSequenceNumbers']
                    [reserved uint 7 '0x00']
            [simple bit moreNotifications]
            
            [simple ExtensionObjectDefinition('"805"') notificationMessage]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"832"' RepublishRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple uint 32 subscriptionId]
            [simple uint 32 retransmitSequenceNumber]
            
        ]
        ['"835"' RepublishResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            
            [simple ExtensionObjectDefinition('"805"') notificationMessage]
            
        ]
        ['"838"' TransferResult
            [simple StatusCode statusCode]
            [simple int 32 noOfAvailableSequenceNumbers]
            [array uint 32 availableSequenceNumbers count 'noOfAvailableSequenceNumbers']
                    
        ]
        ['"841"' TransferSubscriptionsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfSubscriptionIds]
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
                    [reserved uint 7 '0x00']
            [simple bit sendInitialValues]
            
        ]
        ['"844"' TransferSubscriptionsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            
            [array ExtensionObjectDefinition('"838"') results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"847"' DeleteSubscriptionsRequest
            
            [simple ExtensionObjectDefinition('"391"') requestHeader]
            [simple int 32 noOfSubscriptionIds]
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
                    
        ]
        ['"850"' DeleteSubscriptionsResponse
            
            [simple ExtensionObjectDefinition('"394"') responseHeader]
            [simple int 32 noOfResults]
            [array StatusCode results count 'noOfResults']
                    [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
                    
        ]
        ['"340"' BuildInfo
            [simple PascalString productUri]
            [simple PascalString manufacturerName]
            [simple PascalString productName]
            [simple PascalString softwareVersion]
            [simple PascalString buildNumber]
            [simple int 64 buildDate]
            
        ]
        ['"855"' RedundantServerDataType
            [simple PascalString serverId]
            [simple uint 8 serviceLevel]
            [simple ServerState serverState]
            
        ]
        ['"11945"' EndpointUrlListDataType
            [simple int 32 noOfEndpointUrlList]
            [array PascalString endpointUrlList count 'noOfEndpointUrlList']
                    
        ]
        ['"11946"' NetworkGroupDataType
            [simple PascalString serverUri]
            [simple int 32 noOfNetworkPaths]
            
            [array ExtensionObjectDefinition('"11945"') networkPaths count 'noOfNetworkPaths']
                    
        ]
        ['"858"' SamplingIntervalDiagnosticsDataType
            [simple float 64 samplingInterval]
            [simple uint 32 monitoredItemCount]
            [simple uint 32 maxMonitoredItemCount]
            [simple uint 32 disabledMonitoredItemCount]
            
        ]
        ['"861"' ServerDiagnosticsSummaryDataType
            [simple uint 32 serverViewCount]
            [simple uint 32 currentSessionCount]
            [simple uint 32 cumulatedSessionCount]
            [simple uint 32 securityRejectedSessionCount]
            [simple uint 32 rejectedSessionCount]
            [simple uint 32 sessionTimeoutCount]
            [simple uint 32 sessionAbortCount]
            [simple uint 32 currentSubscriptionCount]
            [simple uint 32 cumulatedSubscriptionCount]
            [simple uint 32 publishingIntervalCount]
            [simple uint 32 securityRejectedRequestsCount]
            [simple uint 32 rejectedRequestsCount]
            
        ]
        ['"864"' ServerStatusDataType
            [simple int 64 startTime]
            [simple int 64 currentTime]
            [simple ServerState state]
            
            [simple ExtensionObjectDefinition('"340"') buildInfo]
            [simple uint 32 secondsTillShutdown]
            [simple LocalizedText shutdownReason]
            
        ]
        ['"867"' SessionDiagnosticsDataType
            [simple NodeId sessionId]
            [simple PascalString sessionName]
            
            [simple ExtensionObjectDefinition('"310"') clientDescription]
            [simple PascalString serverUri]
            [simple PascalString endpointUrl]
            [simple int 32 noOfLocaleIds]
            [array PascalString localeIds count 'noOfLocaleIds']
                    [simple float 64 actualSessionTimeout]
            [simple uint 32 maxResponseMessageSize]
            [simple int 64 clientConnectionTime]
            [simple int 64 clientLastContactTime]
            [simple uint 32 currentSubscriptionsCount]
            [simple uint 32 currentMonitoredItemsCount]
            [simple uint 32 currentPublishRequestsInQueue]
            
            [simple ExtensionObjectDefinition('"873"') totalRequestCount]
            [simple uint 32 unauthorizedRequestCount]
            
            [simple ExtensionObjectDefinition('"873"') readCount]
            
            [simple ExtensionObjectDefinition('"873"') historyReadCount]
            
            [simple ExtensionObjectDefinition('"873"') writeCount]
            
            [simple ExtensionObjectDefinition('"873"') historyUpdateCount]
            
            [simple ExtensionObjectDefinition('"873"') callCount]
            
            [simple ExtensionObjectDefinition('"873"') createMonitoredItemsCount]
            
            [simple ExtensionObjectDefinition('"873"') modifyMonitoredItemsCount]
            
            [simple ExtensionObjectDefinition('"873"') setMonitoringModeCount]
            
            [simple ExtensionObjectDefinition('"873"') setTriggeringCount]
            
            [simple ExtensionObjectDefinition('"873"') deleteMonitoredItemsCount]
            
            [simple ExtensionObjectDefinition('"873"') createSubscriptionCount]
            
            [simple ExtensionObjectDefinition('"873"') modifySubscriptionCount]
            
            [simple ExtensionObjectDefinition('"873"') setPublishingModeCount]
            
            [simple ExtensionObjectDefinition('"873"') publishCount]
            
            [simple ExtensionObjectDefinition('"873"') republishCount]
            
            [simple ExtensionObjectDefinition('"873"') transferSubscriptionsCount]
            
            [simple ExtensionObjectDefinition('"873"') deleteSubscriptionsCount]
            
            [simple ExtensionObjectDefinition('"873"') addNodesCount]
            
            [simple ExtensionObjectDefinition('"873"') addReferencesCount]
            
            [simple ExtensionObjectDefinition('"873"') deleteNodesCount]
            
            [simple ExtensionObjectDefinition('"873"') deleteReferencesCount]
            
            [simple ExtensionObjectDefinition('"873"') browseCount]
            
            [simple ExtensionObjectDefinition('"873"') browseNextCount]
            
            [simple ExtensionObjectDefinition('"873"') translateBrowsePathsToNodeIdsCount]
            
            [simple ExtensionObjectDefinition('"873"') queryFirstCount]
            
            [simple ExtensionObjectDefinition('"873"') queryNextCount]
            
            [simple ExtensionObjectDefinition('"873"') registerNodesCount]
            
            [simple ExtensionObjectDefinition('"873"') unregisterNodesCount]
            
        ]
        ['"870"' SessionSecurityDiagnosticsDataType
            [simple NodeId sessionId]
            [simple PascalString clientUserIdOfSession]
            [simple int 32 noOfClientUserIdHistory]
            [array PascalString clientUserIdHistory count 'noOfClientUserIdHistory']
                    [simple PascalString authenticationMechanism]
            [simple PascalString encoding]
            [simple PascalString transportProtocol]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [simple PascalByteString clientCertificate]
            
        ]
        ['"873"' ServiceCounterDataType
            [simple uint 32 totalCount]
            [simple uint 32 errorCount]
            
        ]
        ['"301"' StatusResult
            [simple StatusCode statusCode]
            [simple DiagnosticInfo diagnosticInfo]
            
        ]
        ['"876"' SubscriptionDiagnosticsDataType
            [simple NodeId sessionId]
            [simple uint 32 subscriptionId]
            [simple uint 8 priority]
            [simple float 64 publishingInterval]
            [simple uint 32 maxKeepAliveCount]
            [simple uint 32 maxLifetimeCount]
            [simple uint 32 maxNotificationsPerPublish]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [simple uint 32 modifyCount]
            [simple uint 32 enableCount]
            [simple uint 32 disableCount]
            [simple uint 32 republishRequestCount]
            [simple uint 32 republishMessageRequestCount]
            [simple uint 32 republishMessageCount]
            [simple uint 32 transferRequestCount]
            [simple uint 32 transferredToAltClientCount]
            [simple uint 32 transferredToSameClientCount]
            [simple uint 32 publishRequestCount]
            [simple uint 32 dataChangeNotificationsCount]
            [simple uint 32 eventNotificationsCount]
            [simple uint 32 notificationsCount]
            [simple uint 32 latePublishRequestCount]
            [simple uint 32 currentKeepAliveCount]
            [simple uint 32 currentLifetimeCount]
            [simple uint 32 unacknowledgedMessageCount]
            [simple uint 32 discardedMessageCount]
            [simple uint 32 monitoredItemCount]
            [simple uint 32 disabledMonitoredItemCount]
            [simple uint 32 monitoringQueueOverflowCount]
            [simple uint 32 nextSequenceNumber]
            [simple uint 32 eventQueueOverFlowCount]
            
        ]
        ['"879"' ModelChangeStructureDataType
            [simple NodeId affected]
            [simple NodeId affectedType]
            [simple uint 8 verb]
            
        ]
        ['"899"' SemanticChangeStructureDataType
            [simple NodeId affected]
            [simple NodeId affectedType]
            
        ]
        ['"886"' Range
            [simple float 64 low]
            [simple float 64 high]
            
        ]
        ['"889"' EUInformation
            [simple PascalString namespaceUri]
            [simple int 32 unitId]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            
        ]
        ['"12173"' ComplexNumberType
            [simple float 32 real]
            [simple float 32 imaginary]
            
        ]
        ['"12174"' DoubleComplexNumberType
            [simple float 64 real]
            [simple float 64 imaginary]
            
        ]
        ['"12081"' AxisInformation
            
            [simple ExtensionObjectDefinition('"889"') engineeringUnits]
            
            [simple ExtensionObjectDefinition('"886"') eURange]
            [simple LocalizedText title]
            [simple AxisScaleEnumeration axisScaleType]
            [simple int 32 noOfAxisSteps]
            [array float 64 axisSteps count 'noOfAxisSteps']
                    
        ]
        ['"12082"' XVType
            [simple float 64 x]
            [simple float 32 value]
            
        ]
        ['"896"' ProgramDiagnosticDataType
            [simple NodeId createSessionId]
            [simple PascalString createClientName]
            [simple int 64 invocationCreationTime]
            [simple int 64 lastTransitionTime]
            [simple PascalString lastMethodCall]
            [simple NodeId lastMethodSessionId]
            [simple int 32 noOfLastMethodInputArguments]
            
            [array ExtensionObjectDefinition('"298"') lastMethodInputArguments count 'noOfLastMethodInputArguments']
                    [simple int 32 noOfLastMethodOutputArguments]
            
            [array ExtensionObjectDefinition('"298"') lastMethodOutputArguments count 'noOfLastMethodOutputArguments']
                    [simple int 64 lastMethodCallTime]
            
            [simple ExtensionObjectDefinition('"301"') lastMethodReturnStatus]
            
        ]
        ['"24035"' ProgramDiagnostic2DataType
            [simple NodeId createSessionId]
            [simple PascalString createClientName]
            [simple int 64 invocationCreationTime]
            [simple int 64 lastTransitionTime]
            [simple PascalString lastMethodCall]
            [simple NodeId lastMethodSessionId]
            [simple int 32 noOfLastMethodInputArguments]
            
            [array ExtensionObjectDefinition('"298"') lastMethodInputArguments count 'noOfLastMethodInputArguments']
                    [simple int 32 noOfLastMethodOutputArguments]
            
            [array ExtensionObjectDefinition('"298"') lastMethodOutputArguments count 'noOfLastMethodOutputArguments']
                    [simple int 32 noOfLastMethodInputValues]
            [array Variant lastMethodInputValues count 'noOfLastMethodInputValues']
                    [simple int 32 noOfLastMethodOutputValues]
            [array Variant lastMethodOutputValues count 'noOfLastMethodOutputValues']
                    [simple int 64 lastMethodCallTime]
            [simple StatusCode lastMethodReturnStatus]
            
        ]
        ['"893"' Annotation
            [simple PascalString message]
            [simple PascalString userName]
            [simple int 64 annotationTime]
            
        ]

        ['"811"' DataChangeNotification
            [implicit int 32 notificationLength 'lengthInBytes']
            [simple int 32 noOfMonitoredItems]
            [array ExtensionObjectDefinition('"808"')  monitoredItems count 'noOfMonitoredItems']
            [simple int 32 noOfDiagnosticInfos]
            [array DiagnosticInfo  diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['"916"' EventNotificationList
            [implicit int 32 notificationLength 'lengthInBytes']
            [simple int 32 noOfEvents]
            [array ExtensionObjectDefinition('"919"')  events count 'noOfEvents']
        ]
        ['"820"' StatusChangeNotification
            [implicit int 32 notificationLength 'lengthInBytes']
            [simple StatusCode status]
            [simple DiagnosticInfo diagnosticInfo]
        ]

        ['"316"' UserIdentityToken
            [implicit int 32 policyLength 'policyId.lengthInBytes  + userIdentityTokenDefinition.lengthInBytes']
            [simple PascalString policyId]
            [simple UserIdentityTokenDefinition('policyId.stringValue') userIdentityTokenDefinition]
        ]
    ]
]

[discriminatedType UserIdentityTokenDefinition(vstring '-1' identifier)
    [typeSwitch identifier
        ['"anonymous"' AnonymousIdentityToken
        ]
        ['"username"' UserNameIdentityToken
            [simple PascalString userName]
            [simple PascalByteString password]
            [simple PascalString encryptionAlgorithm]
        ]
        ['"certificate"' X509IdentityToken
            [simple PascalByteString certificateData]
        ]
        ['"identity"' IssuedIdentityToken
            [simple PascalByteString tokenData]
            [simple PascalString encryptionAlgorithm]
        ]
    ]
]


[discriminatedType Variant
    [simple bit arrayLengthSpecified]
    [simple bit arrayDimensionsSpecified]
    [discriminator uint 6 VariantType]
    [typeSwitch VariantType,arrayLengthSpecified
        ['0' VariantNull
        ]
        ['1' VariantBoolean (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array byte value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['2' VariantSByte (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array byte value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['3' VariantByte (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 8 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['4' VariantInt16 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 16 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['5' VariantUInt16 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 16 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['6' VariantInt32 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['7' VariantUInt32 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['8' VariantInt64 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['9' VariantUInt64 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['10' VariantFloat (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array float 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['11' VariantDouble (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array float 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['12' VariantString (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array PascalString value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['13' VariantDateTime (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['14' VariantGuid (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array GuidValue value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['15' VariantByteString (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ByteStringArray value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['16' VariantXmlElement (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array PascalString value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['17' VariantNodeId (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array NodeId value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['18' VariantExpandedNodeId (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ExpandedNodeId value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['19' VariantStatusCode (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array StatusCode value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['20' VariantQualifiedName (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array QualifiedName value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['21' VariantLocalizedText (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array LocalizedText value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['22' VariantExtensionObject (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ExtensionObject('true') value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['23' VariantDataValue (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array DataValue value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['24' VariantVariant (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array Variant value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['25' VariantDiagnosticInfo (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array DiagnosticInfo value count 'arrayLength == null ? 1 : arrayLength']
        ]
    ]
    [optional int 32 noOfArrayDimensions 'arrayDimensionsSpecified']
    [array bit arrayDimensions count 'noOfArrayDimensions == null ? 0 : noOfArrayDimensions']
]

[discriminatedType NodeIdTypeDefinition
    [abstract vstring '-1' identifier]
    [discriminator NodeIdType nodeType]
    [typeSwitch nodeType
        ['nodeIdTypeTwoByte' NodeIdTwoByte
            [simple uint 8 id]
            [virtual vstring '-1' identifier 'id']
        ]
        ['nodeIdTypeFourByte' NodeIdFourByte
            [simple uint 8 namespaceIndex]
            [simple uint 16 id]
            [virtual vstring '-1' identifier 'id']
        ]
        ['nodeIdTypeNumeric' NodeIdNumeric
            [simple uint 16 namespaceIndex]
            [simple uint 32 id]
            [virtual vstring '-1' identifier 'id']
        ]
        ['nodeIdTypeString' NodeIdString
            [simple uint 16 namespaceIndex]
            [simple PascalString id]
            [virtual vstring '-1' identifier 'id.stringValue']
        ]
        ['nodeIdTypeGuid' NodeIdGuid
            [simple uint 16 namespaceIndex]
            [array byte id count '16']
            [virtual vstring '-1' identifier 'id']
        ]
        ['nodeIdTypeByteString' NodeIdByteString
            [simple uint 16 namespaceIndex]
            [simple PascalByteString id]
            [virtual vstring '-1' identifier 'id.stringValue']
        ]
    ]
]

[type NodeId
    [reserved int 2 '0x00']
    [simple NodeIdTypeDefinition nodeId]
    [virtual vstring '-1' id 'nodeId.identifier']
]

[type PascalString
    [implicit int 32    sLength      'STATIC_CALL("utf8LengthToPascalLength", stringValue)' ]
    [virtual  int 32    stringLength 'STATIC_CALL("pascalLengthToUtf8Length", sLength)'     ]
    [simple   vstring   'stringLength*8' stringValue                                        ]
]

[type PascalByteString
    [simple int 32 stringLength]
    [array byte stringValue count 'stringLength == -1 ? 0 : stringLength' ]
]

[type Structure

]

//[type DataTypeDefinition
//
//]

// StructuredTypes
[type XmlElement
    // An XML element encoded as a UTF-8 string.
    [simple int 32 length]
            [array string 8 value count 'length']
                    
]
    [type TwoByteNodeId
    
    [simple uint 8 identifier]
            
]
    [type FourByteNodeId
    
    [simple uint 8 namespaceIndex]
            [simple uint 16 identifier]
            
]
    [type NumericNodeId
    
    [simple uint 16 namespaceIndex]
            [simple uint 32 identifier]
            
]
    [type StringNodeId
    
    [simple uint 16 namespaceIndex]
            [simple PascalString identifier]
            
]
    [type GuidNodeId
    
    [simple uint 16 namespaceIndex]
            [simple GuidValue identifier]
            
]
    [type ByteStringNodeId
    
    [simple uint 16 namespaceIndex]
            [simple PascalByteString identifier]
            
]
    [type DiagnosticInfo
    // A recursive structure containing diagnostic information associated with a status code.
    [reserved bit 'false']
            [simple bit innerDiagnosticInfoSpecified]
            [simple bit innerStatusCodeSpecified]
            [simple bit additionalInfoSpecified]
            [simple bit localeSpecified]
            [simple bit localizedTextSpecified]
            [simple bit namespaceURISpecified]
            [simple bit symbolicIdSpecified]
            [optional int 32 symbolicId 'symbolicIdSpecified']
            [optional int 32 namespaceURI 'namespaceURISpecified']
            [optional int 32 locale 'localeSpecified']
            [optional int 32 localizedText 'localizedTextSpecified']
            [optional PascalString additionalInfo 'additionalInfoSpecified']
            [optional StatusCode innerStatusCode 'innerStatusCodeSpecified']
            [optional DiagnosticInfo innerDiagnosticInfo 'innerDiagnosticInfoSpecified']
            
]
    [type QualifiedName
    // A string qualified with a namespace index.
    [simple uint 16 namespaceIndex]
            [simple PascalString name]
            
]
    [type LocalizedText
    // A string qualified with a namespace index.
    [reserved uint 6 '0x00']
            [simple bit textSpecified]
            [simple bit localeSpecified]
            [optional PascalString locale 'localeSpecified']
            [optional PascalString text 'textSpecified']
            
]
    [type DataValue
    // A value with an associated timestamp, and quality.
    [reserved uint 2 '0x00']
            [simple bit serverPicosecondsSpecified]
            [simple bit sourcePicosecondsSpecified]
            [simple bit serverTimestampSpecified]
            [simple bit sourceTimestampSpecified]
            [simple bit statusCodeSpecified]
            [simple bit valueSpecified]
            [optional Variant value 'valueSpecified']
            [optional StatusCode statusCode 'statusCodeSpecified']
            [optional int 64 sourceTimestamp 'sourceTimestampSpecified']
            [optional uint 16 sourcePicoseconds 'sourcePicosecondsSpecified']
            [optional int 64 serverTimestamp 'serverTimestampSpecified']
            [optional uint 16 serverPicoseconds 'serverPicosecondsSpecified']
            
]
    

// EnumeratedTypes


[enum uint 6 NodeIdType
// The possible encodings for a NodeId value.
    ['0' nodeIdTypeTwoByte]
    ['1' nodeIdTypeFourByte]
    ['2' nodeIdTypeNumeric]
    ['3' nodeIdTypeString]
    ['4' nodeIdTypeGuid]
    ['5' nodeIdTypeByteString]
    
]
            

[enum uint 32 NamingRuleType

    ['1' namingRuleTypeMandatory]
    ['2' namingRuleTypeOptional]
    ['3' namingRuleTypeConstraint]
    
]
            

[enum uint 32 RedundantServerMode

    ['0' redundantServerModePrimaryWithBackup]
    ['1' redundantServerModePrimaryOnly]
    ['2' redundantServerModeBackupReady]
    ['3' redundantServerModeBackupNotReady]
    
]
            

[enum uint 32 OpenFileMode

    ['1' openFileModeRead]
    ['2' openFileModeWrite]
    ['4' openFileModeEraseExisting]
    ['8' openFileModeAppend]
    
]
            

[enum uint 32 IdentityCriteriaType

    ['1' identityCriteriaTypeUserName]
    ['2' identityCriteriaTypeThumbprint]
    ['3' identityCriteriaTypeRole]
    ['4' identityCriteriaTypeGroupId]
    ['5' identityCriteriaTypeAnonymous]
    ['6' identityCriteriaTypeAuthenticatedUser]
    ['7' identityCriteriaTypeApplication]
    ['8' identityCriteriaTypeX509Subject]
    
]
            

[enum uint 32 ConversionLimitEnum

    ['0' conversionLimitEnumNoConversion]
    ['1' conversionLimitEnumLimited]
    ['2' conversionLimitEnumUnlimited]
    
]
            

[enum uint 16 AlarmMask

    ['0' alarmMaskNone]
    ['1' alarmMaskActive]
    ['2' alarmMaskUnacknowledged]
    ['4' alarmMaskUnconfirmed]
    
]
            

[enum uint 32 TrustListValidationOptions

    ['0' trustListValidationOptionsNone]
    ['1' trustListValidationOptionsSuppressCertificateExpired]
    ['2' trustListValidationOptionsSuppressHostNameInvalid]
    ['4' trustListValidationOptionsSuppressRevocationStatusUnknown]
    ['8' trustListValidationOptionsSuppressIssuerCertificateExpired]
    ['16' trustListValidationOptionsSuppressIssuerRevocationStatusUnknown]
    ['32' trustListValidationOptionsCheckRevocationStatusOnline]
    ['64' trustListValidationOptionsCheckRevocationStatusOffline]
    
]
            

[enum uint 32 TrustListMasks

    ['0' trustListMasksNone]
    ['1' trustListMasksTrustedCertificates]
    ['2' trustListMasksTrustedCrls]
    ['4' trustListMasksIssuerCertificates]
    ['8' trustListMasksIssuerCrls]
    ['15' trustListMasksAll]
    
]
            

[enum uint 32 PubSubState

    ['0' pubSubStateDisabled]
    ['1' pubSubStatePaused]
    ['2' pubSubStateOperational]
    ['3' pubSubStateError]
    ['4' pubSubStatePreOperational]
    
]
            

[enum uint 16 DataSetFieldFlags

    ['0' dataSetFieldFlagsNone]
    ['1' dataSetFieldFlagsPromotedField]
    
]
            

[enum uint 32 DataSetFieldContentMask

    ['0' dataSetFieldContentMaskNone]
    ['1' dataSetFieldContentMaskStatusCode]
    ['2' dataSetFieldContentMaskSourceTimestamp]
    ['4' dataSetFieldContentMaskServerTimestamp]
    ['8' dataSetFieldContentMaskSourcePicoSeconds]
    ['16' dataSetFieldContentMaskServerPicoSeconds]
    ['32' dataSetFieldContentMaskRawData]
    
]
            

[enum uint 32 OverrideValueHandling

    ['0' overrideValueHandlingDisabled]
    ['1' overrideValueHandlingLastUsableValue]
    ['2' overrideValueHandlingOverrideValue]
    
]
            

[enum uint 32 DataSetOrderingType

    ['0' dataSetOrderingTypeUndefined]
    ['1' dataSetOrderingTypeAscendingWriterId]
    ['2' dataSetOrderingTypeAscendingWriterIdSingle]
    
]
            

[enum uint 32 UadpNetworkMessageContentMask

    ['0' uadpNetworkMessageContentMaskNone]
    ['1' uadpNetworkMessageContentMaskPublisherId]
    ['2' uadpNetworkMessageContentMaskGroupHeader]
    ['4' uadpNetworkMessageContentMaskWriterGroupId]
    ['8' uadpNetworkMessageContentMaskGroupVersion]
    ['16' uadpNetworkMessageContentMaskNetworkMessageNumber]
    ['32' uadpNetworkMessageContentMaskSequenceNumber]
    ['64' uadpNetworkMessageContentMaskPayloadHeader]
    ['128' uadpNetworkMessageContentMaskTimestamp]
    ['256' uadpNetworkMessageContentMaskPicoSeconds]
    ['512' uadpNetworkMessageContentMaskDataSetClassId]
    ['1024' uadpNetworkMessageContentMaskPromotedFields]
    
]
            

[enum uint 32 UadpDataSetMessageContentMask

    ['0' uadpDataSetMessageContentMaskNone]
    ['1' uadpDataSetMessageContentMaskTimestamp]
    ['2' uadpDataSetMessageContentMaskPicoSeconds]
    ['4' uadpDataSetMessageContentMaskStatus]
    ['8' uadpDataSetMessageContentMaskMajorVersion]
    ['16' uadpDataSetMessageContentMaskMinorVersion]
    ['32' uadpDataSetMessageContentMaskSequenceNumber]
    
]
            

[enum uint 32 JsonNetworkMessageContentMask

    ['0' jsonNetworkMessageContentMaskNone]
    ['1' jsonNetworkMessageContentMaskNetworkMessageHeader]
    ['2' jsonNetworkMessageContentMaskDataSetMessageHeader]
    ['4' jsonNetworkMessageContentMaskSingleDataSetMessage]
    ['8' jsonNetworkMessageContentMaskPublisherId]
    ['16' jsonNetworkMessageContentMaskDataSetClassId]
    ['32' jsonNetworkMessageContentMaskReplyTo]
    ['64' jsonNetworkMessageContentMaskWriterGroupName]
    
]
            

[enum uint 32 JsonDataSetMessageContentMask

    ['0' jsonDataSetMessageContentMaskNone]
    ['1' jsonDataSetMessageContentMaskDataSetWriterId]
    ['2' jsonDataSetMessageContentMaskMetaDataVersion]
    ['4' jsonDataSetMessageContentMaskSequenceNumber]
    ['8' jsonDataSetMessageContentMaskTimestamp]
    ['16' jsonDataSetMessageContentMaskStatus]
    ['32' jsonDataSetMessageContentMaskMessageType]
    ['64' jsonDataSetMessageContentMaskDataSetWriterName]
    ['128' jsonDataSetMessageContentMaskReversibleFieldEncoding]
    ['256' jsonDataSetMessageContentMaskPublisherId]
    ['512' jsonDataSetMessageContentMaskWriterGroupName]
    ['1024' jsonDataSetMessageContentMaskMinorVersion]
    
]
            

[enum uint 32 BrokerTransportQualityOfService

    ['0' brokerTransportQualityOfServiceNotSpecified]
    ['1' brokerTransportQualityOfServiceBestEffort]
    ['2' brokerTransportQualityOfServiceAtLeastOnce]
    ['3' brokerTransportQualityOfServiceAtMostOnce]
    ['4' brokerTransportQualityOfServiceExactlyOnce]
    
]
            

[enum uint 32 PubSubConfigurationRefMask

    ['0' pubSubConfigurationRefMaskNone]
    ['1' pubSubConfigurationRefMaskElementAdd]
    ['2' pubSubConfigurationRefMaskElementMatch]
    ['4' pubSubConfigurationRefMaskElementModify]
    ['8' pubSubConfigurationRefMaskElementRemove]
    ['16' pubSubConfigurationRefMaskReferenceWriter]
    ['32' pubSubConfigurationRefMaskReferenceReader]
    ['64' pubSubConfigurationRefMaskReferenceWriterGroup]
    ['128' pubSubConfigurationRefMaskReferenceReaderGroup]
    ['256' pubSubConfigurationRefMaskReferenceConnection]
    ['512' pubSubConfigurationRefMaskReferencePubDataset]
    ['1024' pubSubConfigurationRefMaskReferenceSubDataset]
    ['2048' pubSubConfigurationRefMaskReferenceSecurityGroup]
    ['4096' pubSubConfigurationRefMaskReferencePushTarget]
    
]
            

[enum uint 32 DiagnosticsLevel

    ['0' diagnosticsLevelBasic]
    ['1' diagnosticsLevelAdvanced]
    ['2' diagnosticsLevelInfo]
    ['3' diagnosticsLevelLog]
    ['4' diagnosticsLevelDebug]
    
]
            

[enum uint 32 PubSubDiagnosticsCounterClassification

    ['0' pubSubDiagnosticsCounterClassificationInformation]
    ['1' pubSubDiagnosticsCounterClassificationError]
    
]
            

[enum uint 32 PasswordOptionsMask

    ['0' passwordOptionsMaskNone]
    ['1' passwordOptionsMaskSupportInitialPasswordChange]
    ['2' passwordOptionsMaskSupportDisableUser]
    ['4' passwordOptionsMaskSupportDisableDeleteForUser]
    ['8' passwordOptionsMaskSupportNoChangeForUser]
    ['16' passwordOptionsMaskSupportDescriptionForUser]
    ['32' passwordOptionsMaskRequiresUpperCaseCharacters]
    ['64' passwordOptionsMaskRequiresLowerCaseCharacters]
    ['128' passwordOptionsMaskRequiresDigitCharacters]
    ['256' passwordOptionsMaskRequiresSpecialCharacters]
    
]
            

[enum uint 32 UserConfigurationMask

    ['0' userConfigurationMaskNone]
    ['1' userConfigurationMaskNoDelete]
    ['2' userConfigurationMaskDisabled]
    ['4' userConfigurationMaskNoChangeByUser]
    ['8' userConfigurationMaskMustChangePassword]
    
]
            

[enum uint 32 Duplex

    ['0' duplexFull]
    ['1' duplexHalf]
    ['2' duplexUnknown]
    
]
            

[enum uint 32 InterfaceAdminStatus

    ['0' interfaceAdminStatusUp]
    ['1' interfaceAdminStatusDown]
    ['2' interfaceAdminStatusTesting]
    
]
            

[enum uint 32 InterfaceOperStatus

    ['0' interfaceOperStatusUp]
    ['1' interfaceOperStatusDown]
    ['2' interfaceOperStatusTesting]
    ['3' interfaceOperStatusUnknown]
    ['4' interfaceOperStatusDormant]
    ['5' interfaceOperStatusNotPresent]
    ['6' interfaceOperStatusLowerLayerDown]
    
]
            

[enum uint 32 NegotiationStatus

    ['0' negotiationStatusInProgress]
    ['1' negotiationStatusComplete]
    ['2' negotiationStatusFailed]
    ['3' negotiationStatusUnknown]
    ['4' negotiationStatusNoNegotiation]
    
]
            

[enum uint 32 TsnFailureCode

    ['0' tsnFailureCodeNoFailure]
    ['1' tsnFailureCodeInsufficientBandwidth]
    ['2' tsnFailureCodeInsufficientResources]
    ['3' tsnFailureCodeInsufficientTrafficClassBandwidth]
    ['4' tsnFailureCodeStreamIdInUse]
    ['5' tsnFailureCodeStreamDestinationAddressInUse]
    ['6' tsnFailureCodeStreamPreemptedByHigherRank]
    ['7' tsnFailureCodeLatencyHasChanged]
    ['8' tsnFailureCodeEgressPortNotAvbCapable]
    ['9' tsnFailureCodeUseDifferentDestinationAddress]
    ['10' tsnFailureCodeOutOfMsrpResources]
    ['11' tsnFailureCodeOutOfMmrpResources]
    ['12' tsnFailureCodeCannotStoreDestinationAddress]
    ['13' tsnFailureCodePriorityIsNotAnSrcClass]
    ['14' tsnFailureCodeMaxFrameSizeTooLarge]
    ['15' tsnFailureCodeMaxFanInPortsLimitReached]
    ['16' tsnFailureCodeFirstValueChangedForStreamId]
    ['17' tsnFailureCodeVlanBlockedOnEgress]
    ['18' tsnFailureCodeVlanTaggingDisabledOnEgress]
    ['19' tsnFailureCodeSrClassPriorityMismatch]
    ['20' tsnFailureCodeFeatureNotPropagated]
    ['21' tsnFailureCodeMaxLatencyExceeded]
    ['22' tsnFailureCodeBridgeDoesNotProvideNetworkId]
    ['23' tsnFailureCodeStreamTransformNotSupported]
    ['24' tsnFailureCodeStreamIdTypeNotSupported]
    ['25' tsnFailureCodeFeatureNotSupported]
    
]
            

[enum uint 32 TsnStreamState

    ['0' tsnStreamStateDisabled]
    ['1' tsnStreamStateConfiguring]
    ['2' tsnStreamStateReady]
    ['3' tsnStreamStateOperational]
    ['4' tsnStreamStateError]
    
]
            

[enum uint 32 TsnTalkerStatus

    ['0' tsnTalkerStatusNone]
    ['1' tsnTalkerStatusReady]
    ['2' tsnTalkerStatusFailed]
    
]
            

[enum uint 32 TsnListenerStatus

    ['0' tsnListenerStatusNone]
    ['1' tsnListenerStatusReady]
    ['2' tsnListenerStatusPartialFailed]
    ['3' tsnListenerStatusFailed]
    
]
            

[enum uint 32 IdType

    ['0' idTypeNumeric]
    ['1' idTypeString]
    ['2' idTypeGuid]
    ['3' idTypeOpaque]
    
]
            

[enum uint 32 NodeClass

    ['0' nodeClassUnspecified]
    ['1' nodeClassObject]
    ['2' nodeClassVariable]
    ['4' nodeClassMethod]
    ['8' nodeClassObjectType]
    ['16' nodeClassVariableType]
    ['32' nodeClassReferenceType]
    ['64' nodeClassDataType]
    ['128' nodeClassView]
    
]
            

[enum uint 32 PermissionType

    ['0' permissionTypeNone]
    ['1' permissionTypeBrowse]
    ['2' permissionTypeReadRolePermissions]
    ['4' permissionTypeWriteAttribute]
    ['8' permissionTypeWriteRolePermissions]
    ['16' permissionTypeWriteHistorizing]
    ['32' permissionTypeRead]
    ['64' permissionTypeWrite]
    ['128' permissionTypeReadHistory]
    ['256' permissionTypeInsertHistory]
    ['512' permissionTypeModifyHistory]
    ['1024' permissionTypeDeleteHistory]
    ['2048' permissionTypeReceiveEvents]
    ['4096' permissionTypeCall]
    ['8192' permissionTypeAddReference]
    ['16384' permissionTypeRemoveReference]
    ['32768' permissionTypeDeleteNode]
    ['65536' permissionTypeAddNode]
    
]
            

[enum uint 8 AccessLevelType

    ['0' accessLevelTypeNone]
    ['1' accessLevelTypeCurrentRead]
    ['2' accessLevelTypeCurrentWrite]
    ['4' accessLevelTypeHistoryRead]
    ['8' accessLevelTypeHistoryWrite]
    ['16' accessLevelTypeSemanticChange]
    ['32' accessLevelTypeStatusWrite]
    ['64' accessLevelTypeTimestampWrite]
    
]
            

[enum uint 32 AccessLevelExType

    ['0' accessLevelExTypeNone]
    ['1' accessLevelExTypeCurrentRead]
    ['2' accessLevelExTypeCurrentWrite]
    ['4' accessLevelExTypeHistoryRead]
    ['8' accessLevelExTypeHistoryWrite]
    ['16' accessLevelExTypeSemanticChange]
    ['32' accessLevelExTypeStatusWrite]
    ['64' accessLevelExTypeTimestampWrite]
    ['256' accessLevelExTypeNonatomicRead]
    ['512' accessLevelExTypeNonatomicWrite]
    ['1024' accessLevelExTypeWriteFullArrayOnly]
    ['2048' accessLevelExTypeNoSubDataTypes]
    ['4096' accessLevelExTypeNonVolatile]
    ['8192' accessLevelExTypeConstant]
    
]
            

[enum uint 8 EventNotifierType

    ['0' eventNotifierTypeNone]
    ['1' eventNotifierTypeSubscribeToEvents]
    ['4' eventNotifierTypeHistoryRead]
    ['8' eventNotifierTypeHistoryWrite]
    
]
            

[enum uint 16 AccessRestrictionType

    ['0' accessRestrictionTypeNone]
    ['1' accessRestrictionTypeSigningRequired]
    ['2' accessRestrictionTypeEncryptionRequired]
    ['4' accessRestrictionTypeSessionRequired]
    ['8' accessRestrictionTypeApplyRestrictionsToBrowse]
    
]
            

[enum uint 32 StructureType

    ['0' structureTypeStructure]
    ['1' structureTypeStructureWithOptionalFields]
    ['2' structureTypeUnion]
    ['3' structureTypeStructureWithSubtypedValues]
    ['4' structureTypeUnionWithSubtypedValues]
    
]
            

[enum uint 32 ApplicationType

    ['0' applicationTypeServer]
    ['1' applicationTypeClient]
    ['2' applicationTypeClientAndServer]
    ['3' applicationTypeDiscoveryServer]
    
]
            

[enum uint 32 MessageSecurityMode

    ['0' messageSecurityModeInvalid]
    ['1' messageSecurityModeNone]
    ['2' messageSecurityModeSign]
    ['3' messageSecurityModeSignAndEncrypt]
    
]
            

[enum uint 32 UserTokenType

    ['0' userTokenTypeAnonymous]
    ['1' userTokenTypeUserName]
    ['2' userTokenTypeCertificate]
    ['3' userTokenTypeIssuedToken]
    
]
            

[enum uint 32 SecurityTokenRequestType

    ['0' securityTokenRequestTypeIssue]
    ['1' securityTokenRequestTypeRenew]
    
]
            

[enum uint 32 NodeAttributesMask

    ['0' nodeAttributesMaskNone]
    ['1' nodeAttributesMaskAccessLevel]
    ['2' nodeAttributesMaskArrayDimensions]
    ['4' nodeAttributesMaskBrowseName]
    ['8' nodeAttributesMaskContainsNoLoops]
    ['16' nodeAttributesMaskDataType]
    ['32' nodeAttributesMaskDescription]
    ['64' nodeAttributesMaskDisplayName]
    ['128' nodeAttributesMaskEventNotifier]
    ['256' nodeAttributesMaskExecutable]
    ['512' nodeAttributesMaskHistorizing]
    ['1024' nodeAttributesMaskInverseName]
    ['2048' nodeAttributesMaskIsAbstract]
    ['4096' nodeAttributesMaskMinimumSamplingInterval]
    ['8192' nodeAttributesMaskNodeClass]
    ['16384' nodeAttributesMaskNodeId]
    ['32768' nodeAttributesMaskSymmetric]
    ['65536' nodeAttributesMaskUserAccessLevel]
    ['131072' nodeAttributesMaskUserExecutable]
    ['262144' nodeAttributesMaskUserWriteMask]
    ['524288' nodeAttributesMaskValueRank]
    ['1048576' nodeAttributesMaskWriteMask]
    ['2097152' nodeAttributesMaskValue]
    ['4194304' nodeAttributesMaskDataTypeDefinition]
    ['8388608' nodeAttributesMaskRolePermissions]
    ['16777216' nodeAttributesMaskAccessRestrictions]
    ['33554431' nodeAttributesMaskAll]
    ['26501220' nodeAttributesMaskBaseNode]
    ['26501348' nodeAttributesMaskObject]
    ['26503268' nodeAttributesMaskObjectType]
    ['26571383' nodeAttributesMaskVariable]
    ['28600438' nodeAttributesMaskVariableType]
    ['26632548' nodeAttributesMaskMethod]
    ['26537060' nodeAttributesMaskReferenceType]
    ['26501356' nodeAttributesMaskView]
    
]
            

[enum uint 32 AttributeWriteMask

    ['0' attributeWriteMaskNone]
    ['1' attributeWriteMaskAccessLevel]
    ['2' attributeWriteMaskArrayDimensions]
    ['4' attributeWriteMaskBrowseName]
    ['8' attributeWriteMaskContainsNoLoops]
    ['16' attributeWriteMaskDataType]
    ['32' attributeWriteMaskDescription]
    ['64' attributeWriteMaskDisplayName]
    ['128' attributeWriteMaskEventNotifier]
    ['256' attributeWriteMaskExecutable]
    ['512' attributeWriteMaskHistorizing]
    ['1024' attributeWriteMaskInverseName]
    ['2048' attributeWriteMaskIsAbstract]
    ['4096' attributeWriteMaskMinimumSamplingInterval]
    ['8192' attributeWriteMaskNodeClass]
    ['16384' attributeWriteMaskNodeId]
    ['32768' attributeWriteMaskSymmetric]
    ['65536' attributeWriteMaskUserAccessLevel]
    ['131072' attributeWriteMaskUserExecutable]
    ['262144' attributeWriteMaskUserWriteMask]
    ['524288' attributeWriteMaskValueRank]
    ['1048576' attributeWriteMaskWriteMask]
    ['2097152' attributeWriteMaskValueForVariableType]
    ['4194304' attributeWriteMaskDataTypeDefinition]
    ['8388608' attributeWriteMaskRolePermissions]
    ['16777216' attributeWriteMaskAccessRestrictions]
    ['33554432' attributeWriteMaskAccessLevelEx]
    
]
            

[enum uint 32 BrowseDirection

    ['0' browseDirectionForward]
    ['1' browseDirectionInverse]
    ['2' browseDirectionBoth]
    ['3' browseDirectionInvalid]
    
]
            

[enum uint 32 BrowseResultMask

    ['0' browseResultMaskNone]
    ['1' browseResultMaskReferenceTypeId]
    ['2' browseResultMaskIsForward]
    ['4' browseResultMaskNodeClass]
    ['8' browseResultMaskBrowseName]
    ['16' browseResultMaskDisplayName]
    ['32' browseResultMaskTypeDefinition]
    ['63' browseResultMaskAll]
    ['3' browseResultMaskReferenceTypeInfo]
    ['60' browseResultMaskTargetInfo]
    
]
            

[enum uint 32 FilterOperator

    ['0' filterOperatorEquals]
    ['1' filterOperatorIsNull]
    ['2' filterOperatorGreaterThan]
    ['3' filterOperatorLessThan]
    ['4' filterOperatorGreaterThanOrEqual]
    ['5' filterOperatorLessThanOrEqual]
    ['6' filterOperatorLike]
    ['7' filterOperatorNot]
    ['8' filterOperatorBetween]
    ['9' filterOperatorInList]
    ['10' filterOperatorAnd]
    ['11' filterOperatorOr]
    ['12' filterOperatorCast]
    ['13' filterOperatorInView]
    ['14' filterOperatorOfType]
    ['15' filterOperatorRelatedTo]
    ['16' filterOperatorBitwiseAnd]
    ['17' filterOperatorBitwiseOr]
    
]
            

[enum uint 32 TimestampsToReturn

    ['0' timestampsToReturnSource]
    ['1' timestampsToReturnServer]
    ['2' timestampsToReturnBoth]
    ['3' timestampsToReturnNeither]
    ['4' timestampsToReturnInvalid]
    
]
            

[enum uint 32 HistoryUpdateType

    ['1' historyUpdateTypeInsert]
    ['2' historyUpdateTypeReplace]
    ['3' historyUpdateTypeUpdate]
    ['4' historyUpdateTypeDelete]
    
]
            

[enum uint 32 PerformUpdateType

    ['1' performUpdateTypeInsert]
    ['2' performUpdateTypeReplace]
    ['3' performUpdateTypeUpdate]
    ['4' performUpdateTypeRemove]
    
]
            

[enum uint 32 MonitoringMode

    ['0' monitoringModeDisabled]
    ['1' monitoringModeSampling]
    ['2' monitoringModeReporting]
    
]
            

[enum uint 32 DataChangeTrigger

    ['0' dataChangeTriggerStatus]
    ['1' dataChangeTriggerStatusValue]
    ['2' dataChangeTriggerStatusValueTimestamp]
    
]
            

[enum uint 32 DeadbandType

    ['0' deadbandTypeNone]
    ['1' deadbandTypeAbsolute]
    ['2' deadbandTypePercent]
    
]
            

[enum uint 32 RedundancySupport

    ['0' redundancySupportNone]
    ['1' redundancySupportCold]
    ['2' redundancySupportWarm]
    ['3' redundancySupportHot]
    ['4' redundancySupportTransparent]
    ['5' redundancySupportHotAndMirrored]
    
]
            

[enum uint 32 ServerState

    ['0' serverStateRunning]
    ['1' serverStateFailed]
    ['2' serverStateNoConfiguration]
    ['3' serverStateSuspended]
    ['4' serverStateShutdown]
    ['5' serverStateTest]
    ['6' serverStateCommunicationFault]
    ['7' serverStateUnknown]
    
]
            

[enum uint 32 ModelChangeStructureVerbMask

    ['1' modelChangeStructureVerbMaskNodeAdded]
    ['2' modelChangeStructureVerbMaskNodeDeleted]
    ['4' modelChangeStructureVerbMaskReferenceAdded]
    ['8' modelChangeStructureVerbMaskReferenceDeleted]
    ['16' modelChangeStructureVerbMaskDataTypeChanged]
    
]
            

[enum uint 32 AxisScaleEnumeration

    ['0' axisScaleEnumerationLinear]
    ['1' axisScaleEnumerationLog]
    ['2' axisScaleEnumerationLn]
    
]
            

[enum uint 32 ExceptionDeviationFormat

    ['0' exceptionDeviationFormatAbsoluteValue]
    ['1' exceptionDeviationFormatPercentOfValue]
    ['2' exceptionDeviationFormatPercentOfRange]
    ['3' exceptionDeviationFormatPercentOfEURange]
    ['4' exceptionDeviationFormatUnknown]
    
]
            

// OpaqueType
[type StatusCode
    // A 32-bit status code value.
                [simple uint 32 statusCode]
]
    [type ImageBMP
    
]
    [type ImageGIF
    
]
    [type ImageJPG
    
]
    [type ImagePNG
    
]
    [type AudioDataType
    
]
    [type UriString
    
]
    [type BitFieldMaskDataType
    
]
    [type SemanticVersionString
    
]
    [type Handle
    
]
    [type TrimmedString
    
]
    [type EncodedTicket
    
]
    [type NormalizedString
    
]
    [type DecimalString
    
]
    [type DurationString
    
]
    [type TimeString
    
]
    [type DateString
    
]
    
  [type UtcTime
    
]
    [type LocaleId
    
]
    [type Index
    
]
    [type IntegerId
    
]
    [type VersionTime
    
]
    [type ApplicationInstanceCertificate
    
]
    [type SessionAuthenticationToken
    
]
    [type RsaEncryptedSecret
    
]
    [type EccEncryptedSecret
    
]
    [type ContinuationPoint
    
]
    [type Counter
    
]
    [type NumericRange
    
]
    

[enum string 112 OpcuaDataType(uint 8 variantType)
    ['"NULL"' NULL ['0']]
    ['"BOOL"' BOOL ['1']]
    ['"BYTE"' BYTE ['3']]
    ['"SINT"' SINT ['2']]
    ['"INT"' INT ['4']]
    ['"DINT"' DINT ['6']]
    ['"LINT"' LINT ['8']]
    ['"USINT"' USINT ['3']]
    ['"UINT"' UINT ['5']]
    ['"UDINT"' UDINT ['7']]
    ['"ULINT"' ULINT ['9']]
    ['"REAL"' REAL ['10']]
    ['"LREAL"' LREAL ['11']]
    ['"TIME"' TIME ['1']]
    ['"LTIME"' LTIME ['1']]
    ['"DATE"' DATE ['1']]
    ['"LDATE"' LDATE ['1']]
    ['"TIME_OF_DAY"' TIME_OF_DAY ['1']]
    ['"LTIME_OF_DAY"' LTIME_OF_DAY ['1']]
    ['"DATE_AND_TIME"' DATE_AND_TIME ['13']]
    ['"LDATE_AND_TIME"' LDATE_AND_TIME ['1']]
    ['"CHAR"' CHAR ['1']]
    ['"WCHAR"' WCHAR ['1']]
    ['"STRING"' STRING ['12']]
]

[enum string 8 OpcuaIdentifierType
    ['"s"' STRING_IDENTIFIER]
    ['"i"' NUMBER_IDENTIFIER]
    ['"g"' GUID_IDENTIFIER]
    ['"b"' BINARY_IDENTIFIER]
]


    