/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

using System;
using System.Collections.Generic;
using NLog;
using org.apache.plc4net.api.value;
using org.apache.plc4net.spi.generation;
using org.apache.plc4net.spi.model.values;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public class KnxProperty
    {

        private static readonly ILogger Logger = LogManager.GetCurrentClassLogger();

        public static IPlcValue StaticParse(ReadBuffer readBuffer, KnxPropertyDataType propertyType, byte dataLengthInBytes)
        {
if( propertyType == KnxPropertyDataType.PDT_CONTROL ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } else if( propertyType == KnxPropertyDataType.PDT_CHAR ) { // SINT

                // Simple Field (value)
                var value = readBuffer.ReadSbyte("", 8);

                return new PlcSINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_CHAR ) { // USINT

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_INT ) { // INT

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_INT && dataLengthInBytes == 4 ) { // UDINT

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_INT ) { // UINT

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_KNX_FLOAT ) { // REAL

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } else if( propertyType == KnxPropertyDataType.PDT_DATE ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (dayOfMonth)
                var dayOfMonth = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (year)
                var year = readBuffer.ReadByte("", 7);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_TIME ) { // Struct

                // Simple Field (day)
                var day = readBuffer.ReadByte("", 3);

                // Simple Field (hour)
                var hour = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 6);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_LONG ) { // DINT

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_LONG ) { // UDINT

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_FLOAT ) { // REAL

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } else if( propertyType == KnxPropertyDataType.PDT_DOUBLE ) { // LREAL

                // Simple Field (value)
                var value = readBuffer.ReadDouble("", 64);

                return new PlcLREAL(value);
            } else if( propertyType == KnxPropertyDataType.PDT_CHAR_BLOCK ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 10;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS ) { // Struct
                // Array field (groupAddress)
                // Count array
                List<IPlcValue> groupAddress;
                {
                    var itemCount = 2;
                    groupAddress = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        groupAddress.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                // Simple Field (disable)
                var disable = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x0) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x0, reserved);
                    }
                }

                // Simple Field (pollingSoftNr)
                var pollingSoftNr = readBuffer.ReadByte("", 4);

                var _map = new Dictionary<string, IPlcValue>();
                _map["groupAddress"] = new PlcList(groupAddress);

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 5;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_DATE_TIME ) { // Struct

                // Simple Field (year)
                var year = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (dayOfMonth)
                var dayOfMonth = readBuffer.ReadByte("", 5);

                // Simple Field (dayOfWeek)
                var dayOfWeek = readBuffer.ReadByte("", 3);

                // Simple Field (hour)
                var hour = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 6);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 6);

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                // Simple Field (workingDay)
                var workingDay = readBuffer.ReadBit("");

                // Simple Field (noWd)
                var noWd = readBuffer.ReadBit("");

                // Simple Field (noYear)
                var noYear = readBuffer.ReadBit("");

                // Simple Field (noDate)
                var noDate = readBuffer.ReadBit("");

                // Simple Field (noDayOfWeek)
                var noDayOfWeek = readBuffer.ReadBit("");

                // Simple Field (noTime)
                var noTime = readBuffer.ReadBit("");

                // Simple Field (standardSummerTime)
                var standardSummerTime = readBuffer.ReadBit("");

                // Simple Field (qualityOfClock)
                var qualityOfClock = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_01 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 1;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_02 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 2;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_03 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 3;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_04 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 4;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_05 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 5;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_06 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 6;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_07 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 7;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_08 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 8;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_09 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 9;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_10 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 10;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_11 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 11;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_12 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 12;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_13 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 13;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_14 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 14;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_15 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 15;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_16 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 16;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_17 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 17;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_18 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 18;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_19 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 19;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_20 ) { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = 20;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            } else if( propertyType == KnxPropertyDataType.PDT_VERSION ) { // Struct

                // Simple Field (magicNumber)
                var magicNumber = readBuffer.ReadByte("", 5);

                // Simple Field (versionNumber)
                var versionNumber = readBuffer.ReadByte("", 5);

                // Simple Field (revisionNumber)
                var revisionNumber = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_ALARM_INFO ) { // Struct

                // Simple Field (logNumber)
                var logNumber = readBuffer.ReadByte("", 8);

                // Simple Field (alarmPriority)
                var alarmPriority = readBuffer.ReadByte("", 8);

                // Simple Field (applicationArea)
                var applicationArea = readBuffer.ReadByte("", 8);

                // Simple Field (errorClass)
                var errorClass = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (errorcodeSup)
                var errorcodeSup = readBuffer.ReadBit("");

                // Simple Field (alarmtextSup)
                var alarmtextSup = readBuffer.ReadBit("");

                // Simple Field (timestampSup)
                var timestampSup = readBuffer.ReadBit("");

                // Simple Field (ackSup)
                var ackSup = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (locked)
                var locked = readBuffer.ReadBit("");

                // Simple Field (alarmunack)
                var alarmunack = readBuffer.ReadBit("");

                // Simple Field (inalarm)
                var inalarm = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } else if( propertyType == KnxPropertyDataType.PDT_BINARY_INFORMATION ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } else if( propertyType == KnxPropertyDataType.PDT_BITSET8 ) { // BYTE

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcBYTE(value);
            } else if( propertyType == KnxPropertyDataType.PDT_BITSET16 ) { // WORD

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcWORD(value);
            } else if( propertyType == KnxPropertyDataType.PDT_ENUM8 ) { // USINT

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } else if( propertyType == KnxPropertyDataType.PDT_SCALING ) { // USINT

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } else  { // List
                // Array field (value)
                // Count array
                List<IPlcValue> value;
                {
                    var itemCount = dataLengthInBytes;
                    value = new List<IPlcValue>();
                    for (var curItem = 0; curItem < itemCount; curItem++) {
                        value.Add(new PlcBYTE(readBuffer.ReadByte("", 8)));
                    }
                }

                return new PlcList(value);
            }
        }

            public static WriteBuffer StaticSerialize(IPlcValue _value, KnxPropertyDataType propertyType, byte dataLengthInBytes)
            {
                return StaticSerialize(_value, propertyType, dataLengthInBytes, ByteOrder.BIG_ENDIAN);
            }

            public static WriteBuffer StaticSerialize(IPlcValue _value, KnxPropertyDataType propertyType, byte dataLengthInBytes, ByteOrder byteOrder)
            {
if( propertyType == KnxPropertyDataType.PDT_CONTROL ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_CHAR ) { // SINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (sbyte) _value.GetSbyte();
                writeBuffer.WriteSbyte("", 8, (sbyte) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_CHAR ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_INT ) { // INT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_INT && dataLengthInBytes == 4 ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_INT ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_KNX_FLOAT ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_DATE ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (dayOfMonth)
                var dayOfMonth = (byte) _value.GetStruct()["dayOfMonth"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (dayOfMonth));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (month)
                var month = (byte) _value.GetStruct()["month"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (month));
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (year)
                var year = (byte) _value.GetStruct()["year"].GetByte();
                writeBuffer.WriteByte("", 7, (byte) (year));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_TIME ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Simple Field (day)
                var day = (byte) _value.GetStruct()["day"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (day));
                // Simple Field (hour)
                var hour = (byte) _value.GetStruct()["hour"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (hour));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (minutes)
                var minutes = (byte) _value.GetStruct()["minutes"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (minutes));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (seconds)
                var seconds = (byte) _value.GetStruct()["seconds"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (seconds));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_LONG ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_UNSIGNED_LONG ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_FLOAT ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_DOUBLE ) { // LREAL
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (double) _value.GetDouble();
                writeBuffer.WriteDouble("", 64,(value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_CHAR_BLOCK ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS ) { // Struct
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetStruct()["groupAddress"].GetList()) {
                    byte value = (byte) val.GetByte();
                    writeBuffer.WriteByte("", value, 8);
                }

                // Simple Field (disable)
                var disable = (bool) _value.GetStruct()["disable"].GetBool();
                writeBuffer.WriteBit("", (disable));
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x0);
                // Simple Field (pollingSoftNr)
                var pollingSoftNr = (byte) _value.GetStruct()["pollingSoftNr"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (pollingSoftNr));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_DATE_TIME ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Simple Field (year)
                var year = (byte) _value.GetStruct()["year"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (year));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (month)
                var month = (byte) _value.GetStruct()["month"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (month));
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (dayOfMonth)
                var dayOfMonth = (byte) _value.GetStruct()["dayOfMonth"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (dayOfMonth));
                // Simple Field (dayOfWeek)
                var dayOfWeek = (byte) _value.GetStruct()["dayOfWeek"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (dayOfWeek));
                // Simple Field (hour)
                var hour = (byte) _value.GetStruct()["hour"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (hour));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (minutes)
                var minutes = (byte) _value.GetStruct()["minutes"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (minutes));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (seconds)
                var seconds = (byte) _value.GetStruct()["seconds"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (seconds));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
                // Simple Field (workingDay)
                var workingDay = (bool) _value.GetStruct()["workingDay"].GetBool();
                writeBuffer.WriteBit("", (workingDay));
                // Simple Field (noWd)
                var noWd = (bool) _value.GetStruct()["noWd"].GetBool();
                writeBuffer.WriteBit("", (noWd));
                // Simple Field (noYear)
                var noYear = (bool) _value.GetStruct()["noYear"].GetBool();
                writeBuffer.WriteBit("", (noYear));
                // Simple Field (noDate)
                var noDate = (bool) _value.GetStruct()["noDate"].GetBool();
                writeBuffer.WriteBit("", (noDate));
                // Simple Field (noDayOfWeek)
                var noDayOfWeek = (bool) _value.GetStruct()["noDayOfWeek"].GetBool();
                writeBuffer.WriteBit("", (noDayOfWeek));
                // Simple Field (noTime)
                var noTime = (bool) _value.GetStruct()["noTime"].GetBool();
                writeBuffer.WriteBit("", (noTime));
                // Simple Field (standardSummerTime)
                var standardSummerTime = (bool) _value.GetStruct()["standardSummerTime"].GetBool();
                writeBuffer.WriteBit("", (standardSummerTime));
                // Simple Field (qualityOfClock)
                var qualityOfClock = (bool) _value.GetStruct()["qualityOfClock"].GetBool();
                writeBuffer.WriteBit("", (qualityOfClock));
                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_01 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_02 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_03 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_04 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_05 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_06 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_07 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_08 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_09 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_10 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_11 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_12 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_13 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_14 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_15 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_16 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_17 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_18 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_19 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_GENERIC_20 ) { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_VERSION ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Simple Field (magicNumber)
                var magicNumber = (byte) _value.GetStruct()["magicNumber"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (magicNumber));
                // Simple Field (versionNumber)
                var versionNumber = (byte) _value.GetStruct()["versionNumber"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (versionNumber));
                // Simple Field (revisionNumber)
                var revisionNumber = (byte) _value.GetStruct()["revisionNumber"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (revisionNumber));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_ALARM_INFO ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Simple Field (logNumber)
                var logNumber = (byte) _value.GetStruct()["logNumber"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (logNumber));
                // Simple Field (alarmPriority)
                var alarmPriority = (byte) _value.GetStruct()["alarmPriority"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (alarmPriority));
                // Simple Field (applicationArea)
                var applicationArea = (byte) _value.GetStruct()["applicationArea"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (applicationArea));
                // Simple Field (errorClass)
                var errorClass = (byte) _value.GetStruct()["errorClass"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (errorClass));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (errorcodeSup)
                var errorcodeSup = (bool) _value.GetStruct()["errorcodeSup"].GetBool();
                writeBuffer.WriteBit("", (errorcodeSup));
                // Simple Field (alarmtextSup)
                var alarmtextSup = (bool) _value.GetStruct()["alarmtextSup"].GetBool();
                writeBuffer.WriteBit("", (alarmtextSup));
                // Simple Field (timestampSup)
                var timestampSup = (bool) _value.GetStruct()["timestampSup"].GetBool();
                writeBuffer.WriteBit("", (timestampSup));
                // Simple Field (ackSup)
                var ackSup = (bool) _value.GetStruct()["ackSup"].GetBool();
                writeBuffer.WriteBit("", (ackSup));
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (locked)
                var locked = (bool) _value.GetStruct()["locked"].GetBool();
                writeBuffer.WriteBit("", (locked));
                // Simple Field (alarmunack)
                var alarmunack = (bool) _value.GetStruct()["alarmunack"].GetBool();
                writeBuffer.WriteBit("", (alarmunack));
                // Simple Field (inalarm)
                var inalarm = (bool) _value.GetStruct()["inalarm"].GetBool();
                writeBuffer.WriteBit("", (inalarm));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_BINARY_INFORMATION ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_BITSET8 ) { // BYTE
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_BITSET16 ) { // WORD
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_ENUM8 ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } else if( propertyType == KnxPropertyDataType.PDT_SCALING ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } else  { // List
                var writeBuffer = new WriteBuffer();

                PlcList values = (PlcList) _value;

                foreach (IPlcValue val in values.GetList()) {
                    byte value = val.GetByte();
                    writeBuffer.WriteByte("", (value), 8);
                }

            return writeBuffer;
        }
        }
    }

}
