/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public enum KnxDatapointType
    {
        DPT_UNKNOWN = 0,
        BOOL = 1,
        BYTE = 2,
        WORD = 3,
        DWORD = 4,
        LWORD = 5,
        USINT = 6,
        SINT = 7,
        UINT = 8,
        INT = 9,
        UDINT = 10,
        DINT = 11,
        ULINT = 12,
        LINT = 13,
        REAL = 14,
        LREAL = 15,
        CHAR = 16,
        WCHAR = 17,
        STRING = 18,
        WSTRING = 19,
        TIME = 20,
        LTIME = 21,
        DATE = 22,
        TIME_OF_DAY = 23,
        TOD = 24,
        DATE_AND_TIME = 25,
        DT = 26,
        DPT_Switch = 27,
        DPT_Bool = 28,
        DPT_Enable = 29,
        DPT_Ramp = 30,
        DPT_Alarm = 31,
        DPT_BinaryValue = 32,
        DPT_Step = 33,
        DPT_UpDown = 34,
        DPT_OpenClose = 35,
        DPT_Start = 36,
        DPT_State = 37,
        DPT_Invert = 38,
        DPT_DimSendStyle = 39,
        DPT_InputSource = 40,
        DPT_Reset = 41,
        DPT_Ack = 42,
        DPT_Trigger = 43,
        DPT_Occupancy = 44,
        DPT_Window_Door = 45,
        DPT_LogicalFunction = 46,
        DPT_Scene_AB = 47,
        DPT_ShutterBlinds_Mode = 48,
        DPT_DayNight = 49,
        DPT_Heat_Cool = 50,
        DPT_Switch_Control = 51,
        DPT_Bool_Control = 52,
        DPT_Enable_Control = 53,
        DPT_Ramp_Control = 54,
        DPT_Alarm_Control = 55,
        DPT_BinaryValue_Control = 56,
        DPT_Step_Control = 57,
        DPT_Direction1_Control = 58,
        DPT_Direction2_Control = 59,
        DPT_Start_Control = 60,
        DPT_State_Control = 61,
        DPT_Invert_Control = 62,
        DPT_Control_Dimming = 63,
        DPT_Control_Blinds = 64,
        DPT_Char_ASCII = 65,
        DPT_Char_8859_1 = 66,
        DPT_Scaling = 67,
        DPT_Angle = 68,
        DPT_Percent_U8 = 69,
        DPT_DecimalFactor = 70,
        DPT_Tariff = 71,
        DPT_Value_1_Ucount = 72,
        DPT_FanStage = 73,
        DPT_Percent_V8 = 74,
        DPT_Value_1_Count = 75,
        DPT_Status_Mode3 = 76,
        DPT_Value_2_Ucount = 77,
        DPT_TimePeriodMsec = 78,
        DPT_TimePeriod10Msec = 79,
        DPT_TimePeriod100Msec = 80,
        DPT_TimePeriodSec = 81,
        DPT_TimePeriodMin = 82,
        DPT_TimePeriodHrs = 83,
        DPT_PropDataType = 84,
        DPT_Length_mm = 85,
        DPT_UElCurrentmA = 86,
        DPT_Brightness = 87,
        DPT_Absolute_Colour_Temperature = 88,
        DPT_Value_2_Count = 89,
        DPT_DeltaTimeMsec = 90,
        DPT_DeltaTime10Msec = 91,
        DPT_DeltaTime100Msec = 92,
        DPT_DeltaTimeSec = 93,
        DPT_DeltaTimeMin = 94,
        DPT_DeltaTimeHrs = 95,
        DPT_Percent_V16 = 96,
        DPT_Rotation_Angle = 97,
        DPT_Length_m = 98,
        DPT_Value_Temp = 99,
        DPT_Value_Tempd = 100,
        DPT_Value_Tempa = 101,
        DPT_Value_Lux = 102,
        DPT_Value_Wsp = 103,
        DPT_Value_Pres = 104,
        DPT_Value_Humidity = 105,
        DPT_Value_AirQuality = 106,
        DPT_Value_AirFlow = 107,
        DPT_Value_Time1 = 108,
        DPT_Value_Time2 = 109,
        DPT_Value_Volt = 110,
        DPT_Value_Curr = 111,
        DPT_PowerDensity = 112,
        DPT_KelvinPerPercent = 113,
        DPT_Power = 114,
        DPT_Value_Volume_Flow = 115,
        DPT_Rain_Amount = 116,
        DPT_Value_Temp_F = 117,
        DPT_Value_Wsp_kmh = 118,
        DPT_Value_Absolute_Humidity = 119,
        DPT_Concentration_ygm3 = 120,
        DPT_Coefficient = 121,
        DPT_TimeOfDay = 122,
        DPT_Date = 123,
        DPT_Value_4_Ucount = 124,
        DPT_LongTimePeriod_Sec = 125,
        DPT_LongTimePeriod_Min = 126,
        DPT_LongTimePeriod_Hrs = 127,
        DPT_VolumeLiquid_Litre = 128,
        DPT_Volume_m_3 = 129,
        DPT_Value_4_Count = 130,
        DPT_FlowRate_m3h = 131,
        DPT_ActiveEnergy = 132,
        DPT_ApparantEnergy = 133,
        DPT_ReactiveEnergy = 134,
        DPT_ActiveEnergy_kWh = 135,
        DPT_ApparantEnergy_kVAh = 136,
        DPT_ReactiveEnergy_kVARh = 137,
        DPT_ActiveEnergy_MWh = 138,
        DPT_LongDeltaTimeSec = 139,
        DPT_DeltaVolumeLiquid_Litre = 140,
        DPT_DeltaVolume_m_3 = 141,
        DPT_Value_Acceleration = 142,
        DPT_Value_Acceleration_Angular = 143,
        DPT_Value_Activation_Energy = 144,
        DPT_Value_Activity = 145,
        DPT_Value_Mol = 146,
        DPT_Value_Amplitude = 147,
        DPT_Value_AngleRad = 148,
        DPT_Value_AngleDeg = 149,
        DPT_Value_Angular_Momentum = 150,
        DPT_Value_Angular_Velocity = 151,
        DPT_Value_Area = 152,
        DPT_Value_Capacitance = 153,
        DPT_Value_Charge_DensitySurface = 154,
        DPT_Value_Charge_DensityVolume = 155,
        DPT_Value_Compressibility = 156,
        DPT_Value_Conductance = 157,
        DPT_Value_Electrical_Conductivity = 158,
        DPT_Value_Density = 159,
        DPT_Value_Electric_Charge = 160,
        DPT_Value_Electric_Current = 161,
        DPT_Value_Electric_CurrentDensity = 162,
        DPT_Value_Electric_DipoleMoment = 163,
        DPT_Value_Electric_Displacement = 164,
        DPT_Value_Electric_FieldStrength = 165,
        DPT_Value_Electric_Flux = 166,
        DPT_Value_Electric_FluxDensity = 167,
        DPT_Value_Electric_Polarization = 168,
        DPT_Value_Electric_Potential = 169,
        DPT_Value_Electric_PotentialDifference = 170,
        DPT_Value_ElectromagneticMoment = 171,
        DPT_Value_Electromotive_Force = 172,
        DPT_Value_Energy = 173,
        DPT_Value_Force = 174,
        DPT_Value_Frequency = 175,
        DPT_Value_Angular_Frequency = 176,
        DPT_Value_Heat_Capacity = 177,
        DPT_Value_Heat_FlowRate = 178,
        DPT_Value_Heat_Quantity = 179,
        DPT_Value_Impedance = 180,
        DPT_Value_Length = 181,
        DPT_Value_Light_Quantity = 182,
        DPT_Value_Luminance = 183,
        DPT_Value_Luminous_Flux = 184,
        DPT_Value_Luminous_Intensity = 185,
        DPT_Value_Magnetic_FieldStrength = 186,
        DPT_Value_Magnetic_Flux = 187,
        DPT_Value_Magnetic_FluxDensity = 188,
        DPT_Value_Magnetic_Moment = 189,
        DPT_Value_Magnetic_Polarization = 190,
        DPT_Value_Magnetization = 191,
        DPT_Value_MagnetomotiveForce = 192,
        DPT_Value_Mass = 193,
        DPT_Value_MassFlux = 194,
        DPT_Value_Momentum = 195,
        DPT_Value_Phase_AngleRad = 196,
        DPT_Value_Phase_AngleDeg = 197,
        DPT_Value_Power = 198,
        DPT_Value_Power_Factor = 199,
        DPT_Value_Pressure = 200,
        DPT_Value_Reactance = 201,
        DPT_Value_Resistance = 202,
        DPT_Value_Resistivity = 203,
        DPT_Value_SelfInductance = 204,
        DPT_Value_SolidAngle = 205,
        DPT_Value_Sound_Intensity = 206,
        DPT_Value_Speed = 207,
        DPT_Value_Stress = 208,
        DPT_Value_Surface_Tension = 209,
        DPT_Value_Common_Temperature = 210,
        DPT_Value_Absolute_Temperature = 211,
        DPT_Value_TemperatureDifference = 212,
        DPT_Value_Thermal_Capacity = 213,
        DPT_Value_Thermal_Conductivity = 214,
        DPT_Value_ThermoelectricPower = 215,
        DPT_Value_Time = 216,
        DPT_Value_Torque = 217,
        DPT_Value_Volume = 218,
        DPT_Value_Volume_Flux = 219,
        DPT_Value_Weight = 220,
        DPT_Value_Work = 221,
        DPT_Value_ApparentPower = 222,
        DPT_Volume_Flux_Meter = 223,
        DPT_Volume_Flux_ls = 224,
        DPT_Access_Data = 225,
        DPT_String_ASCII = 226,
        DPT_String_8859_1 = 227,
        DPT_SceneNumber = 228,
        DPT_SceneControl = 229,
        DPT_DateTime = 230,
        DPT_SCLOMode = 231,
        DPT_BuildingMode = 232,
        DPT_OccMode = 233,
        DPT_Priority = 234,
        DPT_LightApplicationMode = 235,
        DPT_ApplicationArea = 236,
        DPT_AlarmClassType = 237,
        DPT_PSUMode = 238,
        DPT_ErrorClass_System = 239,
        DPT_ErrorClass_HVAC = 240,
        DPT_Time_Delay = 241,
        DPT_Beaufort_Wind_Force_Scale = 242,
        DPT_SensorSelect = 243,
        DPT_ActuatorConnectType = 244,
        DPT_Cloud_Cover = 245,
        DPT_PowerReturnMode = 246,
        DPT_FuelType = 247,
        DPT_BurnerType = 248,
        DPT_HVACMode = 249,
        DPT_DHWMode = 250,
        DPT_LoadPriority = 251,
        DPT_HVACContrMode = 252,
        DPT_HVACEmergMode = 253,
        DPT_ChangeoverMode = 254,
        DPT_ValveMode = 255,
        DPT_DamperMode = 256,
        DPT_HeaterMode = 257,
        DPT_FanMode = 258,
        DPT_MasterSlaveMode = 259,
        DPT_StatusRoomSetp = 260,
        DPT_Metering_DeviceType = 261,
        DPT_HumDehumMode = 262,
        DPT_EnableHCStage = 263,
        DPT_ADAType = 264,
        DPT_BackupMode = 265,
        DPT_StartSynchronization = 266,
        DPT_Behaviour_Lock_Unlock = 267,
        DPT_Behaviour_Bus_Power_Up_Down = 268,
        DPT_DALI_Fade_Time = 269,
        DPT_BlinkingMode = 270,
        DPT_LightControlMode = 271,
        DPT_SwitchPBModel = 272,
        DPT_PBAction = 273,
        DPT_DimmPBModel = 274,
        DPT_SwitchOnMode = 275,
        DPT_LoadTypeSet = 276,
        DPT_LoadTypeDetected = 277,
        DPT_Converter_Test_Control = 278,
        DPT_SABExcept_Behaviour = 279,
        DPT_SABBehaviour_Lock_Unlock = 280,
        DPT_SSSBMode = 281,
        DPT_BlindsControlMode = 282,
        DPT_CommMode = 283,
        DPT_AddInfoTypes = 284,
        DPT_RF_ModeSelect = 285,
        DPT_RF_FilterSelect = 286,
        DPT_StatusGen = 287,
        DPT_Device_Control = 288,
        DPT_ForceSign = 289,
        DPT_ForceSignCool = 290,
        DPT_StatusRHC = 291,
        DPT_StatusSDHWC = 292,
        DPT_FuelTypeSet = 293,
        DPT_StatusRCC = 294,
        DPT_StatusAHU = 295,
        DPT_CombinedStatus_RTSM = 296,
        DPT_LightActuatorErrorInfo = 297,
        DPT_RF_ModeInfo = 298,
        DPT_RF_FilterInfo = 299,
        DPT_Channel_Activation_8 = 300,
        DPT_StatusDHWC = 301,
        DPT_StatusRHCC = 302,
        DPT_CombinedStatus_HVA = 303,
        DPT_CombinedStatus_RTC = 304,
        DPT_Media = 305,
        DPT_Channel_Activation_16 = 306,
        DPT_OnOffAction = 307,
        DPT_Alarm_Reaction = 308,
        DPT_UpDown_Action = 309,
        DPT_HVAC_PB_Action = 310,
        DPT_DoubleNibble = 311,
        DPT_SceneInfo = 312,
        DPT_CombinedInfoOnOff = 313,
        DPT_ActiveEnergy_V64 = 314,
        DPT_ApparantEnergy_V64 = 315,
        DPT_ReactiveEnergy_V64 = 316,
        DPT_Channel_Activation_24 = 317,
        DPT_HVACModeNext = 318,
        DPT_DHWModeNext = 319,
        DPT_OccModeNext = 320,
        DPT_BuildingModeNext = 321,
        DPT_StatusLightingActuator = 322,
        DPT_Version = 323,
        DPT_AlarmInfo = 324,
        DPT_TempRoomSetpSetF16_3 = 325,
        DPT_TempRoomSetpSetShiftF16_3 = 326,
        DPT_Scaling_Speed = 327,
        DPT_Scaling_Step_Time = 328,
        DPT_MeteringValue = 329,
        DPT_MBus_Address = 330,
        DPT_Colour_RGB = 331,
        DPT_LanguageCodeAlpha2_ASCII = 332,
        DPT_Tariff_ActiveEnergy = 333,
        DPT_Prioritised_Mode_Control = 334,
        DPT_DALI_Control_Gear_Diagnostic = 335,
        DPT_DALI_Diagnostics = 336,
        DPT_CombinedPosition = 337,
        DPT_StatusSAB = 338,
        DPT_Colour_xyY = 339,
        DPT_Converter_Status = 340,
        DPT_Converter_Test_Result = 341,
        DPT_Battery_Info = 342,
        DPT_Brightness_Colour_Temperature_Transition = 343,
        DPT_Brightness_Colour_Temperature_Control = 344,
        DPT_Colour_RGBW = 345,
        DPT_Relative_Control_RGBW = 346,
        DPT_Relative_Control_RGB = 347,
        DPT_GeographicalLocation = 348,
        DPT_TempRoomSetpSetF16_4 = 349,
        DPT_TempRoomSetpSetShiftF16_4 = 350,
    }

    public static class KnxDatapointTypeInfo
    {

        public static ushort? Number(this KnxDatapointType value)
        {
            switch (value)
            {
                case KnxDatapointType.DPT_UNKNOWN: { /* '0' */
                    return 0;
                }
                case KnxDatapointType.BOOL: { /* '1' */
                    return 0;
                }
                case KnxDatapointType.UDINT: { /* '10' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Tempd: { /* '100' */
                    return 2;
                }
                case KnxDatapointType.DPT_Value_Tempa: { /* '101' */
                    return 3;
                }
                case KnxDatapointType.DPT_Value_Lux: { /* '102' */
                    return 4;
                }
                case KnxDatapointType.DPT_Value_Wsp: { /* '103' */
                    return 5;
                }
                case KnxDatapointType.DPT_Value_Pres: { /* '104' */
                    return 6;
                }
                case KnxDatapointType.DPT_Value_Humidity: { /* '105' */
                    return 7;
                }
                case KnxDatapointType.DPT_Value_AirQuality: { /* '106' */
                    return 8;
                }
                case KnxDatapointType.DPT_Value_AirFlow: { /* '107' */
                    return 9;
                }
                case KnxDatapointType.DPT_Value_Time1: { /* '108' */
                    return 10;
                }
                case KnxDatapointType.DPT_Value_Time2: { /* '109' */
                    return 11;
                }
                case KnxDatapointType.DINT: { /* '11' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Volt: { /* '110' */
                    return 20;
                }
                case KnxDatapointType.DPT_Value_Curr: { /* '111' */
                    return 21;
                }
                case KnxDatapointType.DPT_PowerDensity: { /* '112' */
                    return 22;
                }
                case KnxDatapointType.DPT_KelvinPerPercent: { /* '113' */
                    return 23;
                }
                case KnxDatapointType.DPT_Power: { /* '114' */
                    return 24;
                }
                case KnxDatapointType.DPT_Value_Volume_Flow: { /* '115' */
                    return 25;
                }
                case KnxDatapointType.DPT_Rain_Amount: { /* '116' */
                    return 26;
                }
                case KnxDatapointType.DPT_Value_Temp_F: { /* '117' */
                    return 27;
                }
                case KnxDatapointType.DPT_Value_Wsp_kmh: { /* '118' */
                    return 28;
                }
                case KnxDatapointType.DPT_Value_Absolute_Humidity: { /* '119' */
                    return 29;
                }
                case KnxDatapointType.ULINT: { /* '12' */
                    return 0;
                }
                case KnxDatapointType.DPT_Concentration_ygm3: { /* '120' */
                    return 30;
                }
                case KnxDatapointType.DPT_Coefficient: { /* '121' */
                    return 31;
                }
                case KnxDatapointType.DPT_TimeOfDay: { /* '122' */
                    return 1;
                }
                case KnxDatapointType.DPT_Date: { /* '123' */
                    return 1;
                }
                case KnxDatapointType.DPT_Value_4_Ucount: { /* '124' */
                    return 1;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Sec: { /* '125' */
                    return 100;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Min: { /* '126' */
                    return 101;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Hrs: { /* '127' */
                    return 102;
                }
                case KnxDatapointType.DPT_VolumeLiquid_Litre: { /* '128' */
                    return 1200;
                }
                case KnxDatapointType.DPT_Volume_m_3: { /* '129' */
                    return 1201;
                }
                case KnxDatapointType.LINT: { /* '13' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_4_Count: { /* '130' */
                    return 1;
                }
                case KnxDatapointType.DPT_FlowRate_m3h: { /* '131' */
                    return 2;
                }
                case KnxDatapointType.DPT_ActiveEnergy: { /* '132' */
                    return 10;
                }
                case KnxDatapointType.DPT_ApparantEnergy: { /* '133' */
                    return 11;
                }
                case KnxDatapointType.DPT_ReactiveEnergy: { /* '134' */
                    return 12;
                }
                case KnxDatapointType.DPT_ActiveEnergy_kWh: { /* '135' */
                    return 13;
                }
                case KnxDatapointType.DPT_ApparantEnergy_kVAh: { /* '136' */
                    return 14;
                }
                case KnxDatapointType.DPT_ReactiveEnergy_kVARh: { /* '137' */
                    return 15;
                }
                case KnxDatapointType.DPT_ActiveEnergy_MWh: { /* '138' */
                    return 16;
                }
                case KnxDatapointType.DPT_LongDeltaTimeSec: { /* '139' */
                    return 100;
                }
                case KnxDatapointType.REAL: { /* '14' */
                    return 0;
                }
                case KnxDatapointType.DPT_DeltaVolumeLiquid_Litre: { /* '140' */
                    return 1200;
                }
                case KnxDatapointType.DPT_DeltaVolume_m_3: { /* '141' */
                    return 1201;
                }
                case KnxDatapointType.DPT_Value_Acceleration: { /* '142' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Acceleration_Angular: { /* '143' */
                    return 1;
                }
                case KnxDatapointType.DPT_Value_Activation_Energy: { /* '144' */
                    return 2;
                }
                case KnxDatapointType.DPT_Value_Activity: { /* '145' */
                    return 3;
                }
                case KnxDatapointType.DPT_Value_Mol: { /* '146' */
                    return 4;
                }
                case KnxDatapointType.DPT_Value_Amplitude: { /* '147' */
                    return 5;
                }
                case KnxDatapointType.DPT_Value_AngleRad: { /* '148' */
                    return 6;
                }
                case KnxDatapointType.DPT_Value_AngleDeg: { /* '149' */
                    return 7;
                }
                case KnxDatapointType.LREAL: { /* '15' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Angular_Momentum: { /* '150' */
                    return 8;
                }
                case KnxDatapointType.DPT_Value_Angular_Velocity: { /* '151' */
                    return 9;
                }
                case KnxDatapointType.DPT_Value_Area: { /* '152' */
                    return 10;
                }
                case KnxDatapointType.DPT_Value_Capacitance: { /* '153' */
                    return 11;
                }
                case KnxDatapointType.DPT_Value_Charge_DensitySurface: { /* '154' */
                    return 12;
                }
                case KnxDatapointType.DPT_Value_Charge_DensityVolume: { /* '155' */
                    return 13;
                }
                case KnxDatapointType.DPT_Value_Compressibility: { /* '156' */
                    return 14;
                }
                case KnxDatapointType.DPT_Value_Conductance: { /* '157' */
                    return 15;
                }
                case KnxDatapointType.DPT_Value_Electrical_Conductivity: { /* '158' */
                    return 16;
                }
                case KnxDatapointType.DPT_Value_Density: { /* '159' */
                    return 17;
                }
                case KnxDatapointType.CHAR: { /* '16' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Electric_Charge: { /* '160' */
                    return 18;
                }
                case KnxDatapointType.DPT_Value_Electric_Current: { /* '161' */
                    return 19;
                }
                case KnxDatapointType.DPT_Value_Electric_CurrentDensity: { /* '162' */
                    return 20;
                }
                case KnxDatapointType.DPT_Value_Electric_DipoleMoment: { /* '163' */
                    return 21;
                }
                case KnxDatapointType.DPT_Value_Electric_Displacement: { /* '164' */
                    return 22;
                }
                case KnxDatapointType.DPT_Value_Electric_FieldStrength: { /* '165' */
                    return 23;
                }
                case KnxDatapointType.DPT_Value_Electric_Flux: { /* '166' */
                    return 24;
                }
                case KnxDatapointType.DPT_Value_Electric_FluxDensity: { /* '167' */
                    return 25;
                }
                case KnxDatapointType.DPT_Value_Electric_Polarization: { /* '168' */
                    return 26;
                }
                case KnxDatapointType.DPT_Value_Electric_Potential: { /* '169' */
                    return 27;
                }
                case KnxDatapointType.WCHAR: { /* '17' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Electric_PotentialDifference: { /* '170' */
                    return 28;
                }
                case KnxDatapointType.DPT_Value_ElectromagneticMoment: { /* '171' */
                    return 29;
                }
                case KnxDatapointType.DPT_Value_Electromotive_Force: { /* '172' */
                    return 30;
                }
                case KnxDatapointType.DPT_Value_Energy: { /* '173' */
                    return 31;
                }
                case KnxDatapointType.DPT_Value_Force: { /* '174' */
                    return 32;
                }
                case KnxDatapointType.DPT_Value_Frequency: { /* '175' */
                    return 33;
                }
                case KnxDatapointType.DPT_Value_Angular_Frequency: { /* '176' */
                    return 34;
                }
                case KnxDatapointType.DPT_Value_Heat_Capacity: { /* '177' */
                    return 35;
                }
                case KnxDatapointType.DPT_Value_Heat_FlowRate: { /* '178' */
                    return 36;
                }
                case KnxDatapointType.DPT_Value_Heat_Quantity: { /* '179' */
                    return 37;
                }
                case KnxDatapointType.STRING: { /* '18' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Impedance: { /* '180' */
                    return 38;
                }
                case KnxDatapointType.DPT_Value_Length: { /* '181' */
                    return 39;
                }
                case KnxDatapointType.DPT_Value_Light_Quantity: { /* '182' */
                    return 40;
                }
                case KnxDatapointType.DPT_Value_Luminance: { /* '183' */
                    return 41;
                }
                case KnxDatapointType.DPT_Value_Luminous_Flux: { /* '184' */
                    return 42;
                }
                case KnxDatapointType.DPT_Value_Luminous_Intensity: { /* '185' */
                    return 43;
                }
                case KnxDatapointType.DPT_Value_Magnetic_FieldStrength: { /* '186' */
                    return 44;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Flux: { /* '187' */
                    return 45;
                }
                case KnxDatapointType.DPT_Value_Magnetic_FluxDensity: { /* '188' */
                    return 46;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Moment: { /* '189' */
                    return 47;
                }
                case KnxDatapointType.WSTRING: { /* '19' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Polarization: { /* '190' */
                    return 48;
                }
                case KnxDatapointType.DPT_Value_Magnetization: { /* '191' */
                    return 49;
                }
                case KnxDatapointType.DPT_Value_MagnetomotiveForce: { /* '192' */
                    return 50;
                }
                case KnxDatapointType.DPT_Value_Mass: { /* '193' */
                    return 51;
                }
                case KnxDatapointType.DPT_Value_MassFlux: { /* '194' */
                    return 52;
                }
                case KnxDatapointType.DPT_Value_Momentum: { /* '195' */
                    return 53;
                }
                case KnxDatapointType.DPT_Value_Phase_AngleRad: { /* '196' */
                    return 54;
                }
                case KnxDatapointType.DPT_Value_Phase_AngleDeg: { /* '197' */
                    return 55;
                }
                case KnxDatapointType.DPT_Value_Power: { /* '198' */
                    return 56;
                }
                case KnxDatapointType.DPT_Value_Power_Factor: { /* '199' */
                    return 57;
                }
                case KnxDatapointType.BYTE: { /* '2' */
                    return 0;
                }
                case KnxDatapointType.TIME: { /* '20' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Pressure: { /* '200' */
                    return 58;
                }
                case KnxDatapointType.DPT_Value_Reactance: { /* '201' */
                    return 59;
                }
                case KnxDatapointType.DPT_Value_Resistance: { /* '202' */
                    return 60;
                }
                case KnxDatapointType.DPT_Value_Resistivity: { /* '203' */
                    return 61;
                }
                case KnxDatapointType.DPT_Value_SelfInductance: { /* '204' */
                    return 62;
                }
                case KnxDatapointType.DPT_Value_SolidAngle: { /* '205' */
                    return 63;
                }
                case KnxDatapointType.DPT_Value_Sound_Intensity: { /* '206' */
                    return 64;
                }
                case KnxDatapointType.DPT_Value_Speed: { /* '207' */
                    return 65;
                }
                case KnxDatapointType.DPT_Value_Stress: { /* '208' */
                    return 66;
                }
                case KnxDatapointType.DPT_Value_Surface_Tension: { /* '209' */
                    return 67;
                }
                case KnxDatapointType.LTIME: { /* '21' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Common_Temperature: { /* '210' */
                    return 68;
                }
                case KnxDatapointType.DPT_Value_Absolute_Temperature: { /* '211' */
                    return 69;
                }
                case KnxDatapointType.DPT_Value_TemperatureDifference: { /* '212' */
                    return 70;
                }
                case KnxDatapointType.DPT_Value_Thermal_Capacity: { /* '213' */
                    return 71;
                }
                case KnxDatapointType.DPT_Value_Thermal_Conductivity: { /* '214' */
                    return 72;
                }
                case KnxDatapointType.DPT_Value_ThermoelectricPower: { /* '215' */
                    return 73;
                }
                case KnxDatapointType.DPT_Value_Time: { /* '216' */
                    return 74;
                }
                case KnxDatapointType.DPT_Value_Torque: { /* '217' */
                    return 75;
                }
                case KnxDatapointType.DPT_Value_Volume: { /* '218' */
                    return 76;
                }
                case KnxDatapointType.DPT_Value_Volume_Flux: { /* '219' */
                    return 77;
                }
                case KnxDatapointType.DATE: { /* '22' */
                    return 0;
                }
                case KnxDatapointType.DPT_Value_Weight: { /* '220' */
                    return 78;
                }
                case KnxDatapointType.DPT_Value_Work: { /* '221' */
                    return 79;
                }
                case KnxDatapointType.DPT_Value_ApparentPower: { /* '222' */
                    return 80;
                }
                case KnxDatapointType.DPT_Volume_Flux_Meter: { /* '223' */
                    return 1200;
                }
                case KnxDatapointType.DPT_Volume_Flux_ls: { /* '224' */
                    return 1201;
                }
                case KnxDatapointType.DPT_Access_Data: { /* '225' */
                    return 0;
                }
                case KnxDatapointType.DPT_String_ASCII: { /* '226' */
                    return 0;
                }
                case KnxDatapointType.DPT_String_8859_1: { /* '227' */
                    return 1;
                }
                case KnxDatapointType.DPT_SceneNumber: { /* '228' */
                    return 1;
                }
                case KnxDatapointType.DPT_SceneControl: { /* '229' */
                    return 1;
                }
                case KnxDatapointType.TIME_OF_DAY: { /* '23' */
                    return 0;
                }
                case KnxDatapointType.DPT_DateTime: { /* '230' */
                    return 1;
                }
                case KnxDatapointType.DPT_SCLOMode: { /* '231' */
                    return 1;
                }
                case KnxDatapointType.DPT_BuildingMode: { /* '232' */
                    return 2;
                }
                case KnxDatapointType.DPT_OccMode: { /* '233' */
                    return 3;
                }
                case KnxDatapointType.DPT_Priority: { /* '234' */
                    return 4;
                }
                case KnxDatapointType.DPT_LightApplicationMode: { /* '235' */
                    return 5;
                }
                case KnxDatapointType.DPT_ApplicationArea: { /* '236' */
                    return 6;
                }
                case KnxDatapointType.DPT_AlarmClassType: { /* '237' */
                    return 7;
                }
                case KnxDatapointType.DPT_PSUMode: { /* '238' */
                    return 8;
                }
                case KnxDatapointType.DPT_ErrorClass_System: { /* '239' */
                    return 11;
                }
                case KnxDatapointType.TOD: { /* '24' */
                    return 0;
                }
                case KnxDatapointType.DPT_ErrorClass_HVAC: { /* '240' */
                    return 12;
                }
                case KnxDatapointType.DPT_Time_Delay: { /* '241' */
                    return 13;
                }
                case KnxDatapointType.DPT_Beaufort_Wind_Force_Scale: { /* '242' */
                    return 14;
                }
                case KnxDatapointType.DPT_SensorSelect: { /* '243' */
                    return 17;
                }
                case KnxDatapointType.DPT_ActuatorConnectType: { /* '244' */
                    return 20;
                }
                case KnxDatapointType.DPT_Cloud_Cover: { /* '245' */
                    return 21;
                }
                case KnxDatapointType.DPT_PowerReturnMode: { /* '246' */
                    return 22;
                }
                case KnxDatapointType.DPT_FuelType: { /* '247' */
                    return 100;
                }
                case KnxDatapointType.DPT_BurnerType: { /* '248' */
                    return 101;
                }
                case KnxDatapointType.DPT_HVACMode: { /* '249' */
                    return 102;
                }
                case KnxDatapointType.DATE_AND_TIME: { /* '25' */
                    return 0;
                }
                case KnxDatapointType.DPT_DHWMode: { /* '250' */
                    return 103;
                }
                case KnxDatapointType.DPT_LoadPriority: { /* '251' */
                    return 104;
                }
                case KnxDatapointType.DPT_HVACContrMode: { /* '252' */
                    return 105;
                }
                case KnxDatapointType.DPT_HVACEmergMode: { /* '253' */
                    return 106;
                }
                case KnxDatapointType.DPT_ChangeoverMode: { /* '254' */
                    return 107;
                }
                case KnxDatapointType.DPT_ValveMode: { /* '255' */
                    return 108;
                }
                case KnxDatapointType.DPT_DamperMode: { /* '256' */
                    return 109;
                }
                case KnxDatapointType.DPT_HeaterMode: { /* '257' */
                    return 110;
                }
                case KnxDatapointType.DPT_FanMode: { /* '258' */
                    return 111;
                }
                case KnxDatapointType.DPT_MasterSlaveMode: { /* '259' */
                    return 112;
                }
                case KnxDatapointType.DT: { /* '26' */
                    return 0;
                }
                case KnxDatapointType.DPT_StatusRoomSetp: { /* '260' */
                    return 113;
                }
                case KnxDatapointType.DPT_Metering_DeviceType: { /* '261' */
                    return 114;
                }
                case KnxDatapointType.DPT_HumDehumMode: { /* '262' */
                    return 115;
                }
                case KnxDatapointType.DPT_EnableHCStage: { /* '263' */
                    return 116;
                }
                case KnxDatapointType.DPT_ADAType: { /* '264' */
                    return 120;
                }
                case KnxDatapointType.DPT_BackupMode: { /* '265' */
                    return 121;
                }
                case KnxDatapointType.DPT_StartSynchronization: { /* '266' */
                    return 122;
                }
                case KnxDatapointType.DPT_Behaviour_Lock_Unlock: { /* '267' */
                    return 600;
                }
                case KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down: { /* '268' */
                    return 601;
                }
                case KnxDatapointType.DPT_DALI_Fade_Time: { /* '269' */
                    return 602;
                }
                case KnxDatapointType.DPT_Switch: { /* '27' */
                    return 1;
                }
                case KnxDatapointType.DPT_BlinkingMode: { /* '270' */
                    return 603;
                }
                case KnxDatapointType.DPT_LightControlMode: { /* '271' */
                    return 604;
                }
                case KnxDatapointType.DPT_SwitchPBModel: { /* '272' */
                    return 605;
                }
                case KnxDatapointType.DPT_PBAction: { /* '273' */
                    return 606;
                }
                case KnxDatapointType.DPT_DimmPBModel: { /* '274' */
                    return 607;
                }
                case KnxDatapointType.DPT_SwitchOnMode: { /* '275' */
                    return 608;
                }
                case KnxDatapointType.DPT_LoadTypeSet: { /* '276' */
                    return 609;
                }
                case KnxDatapointType.DPT_LoadTypeDetected: { /* '277' */
                    return 610;
                }
                case KnxDatapointType.DPT_Converter_Test_Control: { /* '278' */
                    return 611;
                }
                case KnxDatapointType.DPT_SABExcept_Behaviour: { /* '279' */
                    return 801;
                }
                case KnxDatapointType.DPT_Bool: { /* '28' */
                    return 2;
                }
                case KnxDatapointType.DPT_SABBehaviour_Lock_Unlock: { /* '280' */
                    return 802;
                }
                case KnxDatapointType.DPT_SSSBMode: { /* '281' */
                    return 803;
                }
                case KnxDatapointType.DPT_BlindsControlMode: { /* '282' */
                    return 804;
                }
                case KnxDatapointType.DPT_CommMode: { /* '283' */
                    return 1000;
                }
                case KnxDatapointType.DPT_AddInfoTypes: { /* '284' */
                    return 1001;
                }
                case KnxDatapointType.DPT_RF_ModeSelect: { /* '285' */
                    return 1002;
                }
                case KnxDatapointType.DPT_RF_FilterSelect: { /* '286' */
                    return 1003;
                }
                case KnxDatapointType.DPT_StatusGen: { /* '287' */
                    return 1;
                }
                case KnxDatapointType.DPT_Device_Control: { /* '288' */
                    return 2;
                }
                case KnxDatapointType.DPT_ForceSign: { /* '289' */
                    return 100;
                }
                case KnxDatapointType.DPT_Enable: { /* '29' */
                    return 3;
                }
                case KnxDatapointType.DPT_ForceSignCool: { /* '290' */
                    return 101;
                }
                case KnxDatapointType.DPT_StatusRHC: { /* '291' */
                    return 102;
                }
                case KnxDatapointType.DPT_StatusSDHWC: { /* '292' */
                    return 103;
                }
                case KnxDatapointType.DPT_FuelTypeSet: { /* '293' */
                    return 104;
                }
                case KnxDatapointType.DPT_StatusRCC: { /* '294' */
                    return 105;
                }
                case KnxDatapointType.DPT_StatusAHU: { /* '295' */
                    return 106;
                }
                case KnxDatapointType.DPT_CombinedStatus_RTSM: { /* '296' */
                    return 107;
                }
                case KnxDatapointType.DPT_LightActuatorErrorInfo: { /* '297' */
                    return 601;
                }
                case KnxDatapointType.DPT_RF_ModeInfo: { /* '298' */
                    return 1000;
                }
                case KnxDatapointType.DPT_RF_FilterInfo: { /* '299' */
                    return 1001;
                }
                case KnxDatapointType.WORD: { /* '3' */
                    return 0;
                }
                case KnxDatapointType.DPT_Ramp: { /* '30' */
                    return 4;
                }
                case KnxDatapointType.DPT_Channel_Activation_8: { /* '300' */
                    return 1010;
                }
                case KnxDatapointType.DPT_StatusDHWC: { /* '301' */
                    return 100;
                }
                case KnxDatapointType.DPT_StatusRHCC: { /* '302' */
                    return 101;
                }
                case KnxDatapointType.DPT_CombinedStatus_HVA: { /* '303' */
                    return 102;
                }
                case KnxDatapointType.DPT_CombinedStatus_RTC: { /* '304' */
                    return 103;
                }
                case KnxDatapointType.DPT_Media: { /* '305' */
                    return 1000;
                }
                case KnxDatapointType.DPT_Channel_Activation_16: { /* '306' */
                    return 1010;
                }
                case KnxDatapointType.DPT_OnOffAction: { /* '307' */
                    return 1;
                }
                case KnxDatapointType.DPT_Alarm_Reaction: { /* '308' */
                    return 2;
                }
                case KnxDatapointType.DPT_UpDown_Action: { /* '309' */
                    return 3;
                }
                case KnxDatapointType.DPT_Alarm: { /* '31' */
                    return 5;
                }
                case KnxDatapointType.DPT_HVAC_PB_Action: { /* '310' */
                    return 102;
                }
                case KnxDatapointType.DPT_DoubleNibble: { /* '311' */
                    return 1000;
                }
                case KnxDatapointType.DPT_SceneInfo: { /* '312' */
                    return 1;
                }
                case KnxDatapointType.DPT_CombinedInfoOnOff: { /* '313' */
                    return 1;
                }
                case KnxDatapointType.DPT_ActiveEnergy_V64: { /* '314' */
                    return 10;
                }
                case KnxDatapointType.DPT_ApparantEnergy_V64: { /* '315' */
                    return 11;
                }
                case KnxDatapointType.DPT_ReactiveEnergy_V64: { /* '316' */
                    return 12;
                }
                case KnxDatapointType.DPT_Channel_Activation_24: { /* '317' */
                    return 1010;
                }
                case KnxDatapointType.DPT_HVACModeNext: { /* '318' */
                    return 100;
                }
                case KnxDatapointType.DPT_DHWModeNext: { /* '319' */
                    return 102;
                }
                case KnxDatapointType.DPT_BinaryValue: { /* '32' */
                    return 6;
                }
                case KnxDatapointType.DPT_OccModeNext: { /* '320' */
                    return 104;
                }
                case KnxDatapointType.DPT_BuildingModeNext: { /* '321' */
                    return 105;
                }
                case KnxDatapointType.DPT_StatusLightingActuator: { /* '322' */
                    return 600;
                }
                case KnxDatapointType.DPT_Version: { /* '323' */
                    return 1;
                }
                case KnxDatapointType.DPT_AlarmInfo: { /* '324' */
                    return 1;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_3: { /* '325' */
                    return 100;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3: { /* '326' */
                    return 101;
                }
                case KnxDatapointType.DPT_Scaling_Speed: { /* '327' */
                    return 1;
                }
                case KnxDatapointType.DPT_Scaling_Step_Time: { /* '328' */
                    return 2;
                }
                case KnxDatapointType.DPT_MeteringValue: { /* '329' */
                    return 1;
                }
                case KnxDatapointType.DPT_Step: { /* '33' */
                    return 7;
                }
                case KnxDatapointType.DPT_MBus_Address: { /* '330' */
                    return 1000;
                }
                case KnxDatapointType.DPT_Colour_RGB: { /* '331' */
                    return 600;
                }
                case KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII: { /* '332' */
                    return 1;
                }
                case KnxDatapointType.DPT_Tariff_ActiveEnergy: { /* '333' */
                    return 1;
                }
                case KnxDatapointType.DPT_Prioritised_Mode_Control: { /* '334' */
                    return 1;
                }
                case KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic: { /* '335' */
                    return 600;
                }
                case KnxDatapointType.DPT_DALI_Diagnostics: { /* '336' */
                    return 600;
                }
                case KnxDatapointType.DPT_CombinedPosition: { /* '337' */
                    return 800;
                }
                case KnxDatapointType.DPT_StatusSAB: { /* '338' */
                    return 800;
                }
                case KnxDatapointType.DPT_Colour_xyY: { /* '339' */
                    return 600;
                }
                case KnxDatapointType.DPT_UpDown: { /* '34' */
                    return 8;
                }
                case KnxDatapointType.DPT_Converter_Status: { /* '340' */
                    return 600;
                }
                case KnxDatapointType.DPT_Converter_Test_Result: { /* '341' */
                    return 600;
                }
                case KnxDatapointType.DPT_Battery_Info: { /* '342' */
                    return 600;
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition: { /* '343' */
                    return 600;
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Control: { /* '344' */
                    return 600;
                }
                case KnxDatapointType.DPT_Colour_RGBW: { /* '345' */
                    return 600;
                }
                case KnxDatapointType.DPT_Relative_Control_RGBW: { /* '346' */
                    return 600;
                }
                case KnxDatapointType.DPT_Relative_Control_RGB: { /* '347' */
                    return 600;
                }
                case KnxDatapointType.DPT_GeographicalLocation: { /* '348' */
                    return 1;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_4: { /* '349' */
                    return 100;
                }
                case KnxDatapointType.DPT_OpenClose: { /* '35' */
                    return 9;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4: { /* '350' */
                    return 101;
                }
                case KnxDatapointType.DPT_Start: { /* '36' */
                    return 10;
                }
                case KnxDatapointType.DPT_State: { /* '37' */
                    return 11;
                }
                case KnxDatapointType.DPT_Invert: { /* '38' */
                    return 12;
                }
                case KnxDatapointType.DPT_DimSendStyle: { /* '39' */
                    return 13;
                }
                case KnxDatapointType.DWORD: { /* '4' */
                    return 0;
                }
                case KnxDatapointType.DPT_InputSource: { /* '40' */
                    return 14;
                }
                case KnxDatapointType.DPT_Reset: { /* '41' */
                    return 15;
                }
                case KnxDatapointType.DPT_Ack: { /* '42' */
                    return 16;
                }
                case KnxDatapointType.DPT_Trigger: { /* '43' */
                    return 17;
                }
                case KnxDatapointType.DPT_Occupancy: { /* '44' */
                    return 18;
                }
                case KnxDatapointType.DPT_Window_Door: { /* '45' */
                    return 19;
                }
                case KnxDatapointType.DPT_LogicalFunction: { /* '46' */
                    return 21;
                }
                case KnxDatapointType.DPT_Scene_AB: { /* '47' */
                    return 22;
                }
                case KnxDatapointType.DPT_ShutterBlinds_Mode: { /* '48' */
                    return 23;
                }
                case KnxDatapointType.DPT_DayNight: { /* '49' */
                    return 24;
                }
                case KnxDatapointType.LWORD: { /* '5' */
                    return 0;
                }
                case KnxDatapointType.DPT_Heat_Cool: { /* '50' */
                    return 100;
                }
                case KnxDatapointType.DPT_Switch_Control: { /* '51' */
                    return 1;
                }
                case KnxDatapointType.DPT_Bool_Control: { /* '52' */
                    return 2;
                }
                case KnxDatapointType.DPT_Enable_Control: { /* '53' */
                    return 3;
                }
                case KnxDatapointType.DPT_Ramp_Control: { /* '54' */
                    return 4;
                }
                case KnxDatapointType.DPT_Alarm_Control: { /* '55' */
                    return 5;
                }
                case KnxDatapointType.DPT_BinaryValue_Control: { /* '56' */
                    return 6;
                }
                case KnxDatapointType.DPT_Step_Control: { /* '57' */
                    return 7;
                }
                case KnxDatapointType.DPT_Direction1_Control: { /* '58' */
                    return 8;
                }
                case KnxDatapointType.DPT_Direction2_Control: { /* '59' */
                    return 9;
                }
                case KnxDatapointType.USINT: { /* '6' */
                    return 0;
                }
                case KnxDatapointType.DPT_Start_Control: { /* '60' */
                    return 10;
                }
                case KnxDatapointType.DPT_State_Control: { /* '61' */
                    return 11;
                }
                case KnxDatapointType.DPT_Invert_Control: { /* '62' */
                    return 12;
                }
                case KnxDatapointType.DPT_Control_Dimming: { /* '63' */
                    return 7;
                }
                case KnxDatapointType.DPT_Control_Blinds: { /* '64' */
                    return 8;
                }
                case KnxDatapointType.DPT_Char_ASCII: { /* '65' */
                    return 1;
                }
                case KnxDatapointType.DPT_Char_8859_1: { /* '66' */
                    return 2;
                }
                case KnxDatapointType.DPT_Scaling: { /* '67' */
                    return 1;
                }
                case KnxDatapointType.DPT_Angle: { /* '68' */
                    return 3;
                }
                case KnxDatapointType.DPT_Percent_U8: { /* '69' */
                    return 4;
                }
                case KnxDatapointType.SINT: { /* '7' */
                    return 0;
                }
                case KnxDatapointType.DPT_DecimalFactor: { /* '70' */
                    return 5;
                }
                case KnxDatapointType.DPT_Tariff: { /* '71' */
                    return 6;
                }
                case KnxDatapointType.DPT_Value_1_Ucount: { /* '72' */
                    return 10;
                }
                case KnxDatapointType.DPT_FanStage: { /* '73' */
                    return 100;
                }
                case KnxDatapointType.DPT_Percent_V8: { /* '74' */
                    return 1;
                }
                case KnxDatapointType.DPT_Value_1_Count: { /* '75' */
                    return 10;
                }
                case KnxDatapointType.DPT_Status_Mode3: { /* '76' */
                    return 20;
                }
                case KnxDatapointType.DPT_Value_2_Ucount: { /* '77' */
                    return 1;
                }
                case KnxDatapointType.DPT_TimePeriodMsec: { /* '78' */
                    return 2;
                }
                case KnxDatapointType.DPT_TimePeriod10Msec: { /* '79' */
                    return 3;
                }
                case KnxDatapointType.UINT: { /* '8' */
                    return 0;
                }
                case KnxDatapointType.DPT_TimePeriod100Msec: { /* '80' */
                    return 4;
                }
                case KnxDatapointType.DPT_TimePeriodSec: { /* '81' */
                    return 5;
                }
                case KnxDatapointType.DPT_TimePeriodMin: { /* '82' */
                    return 6;
                }
                case KnxDatapointType.DPT_TimePeriodHrs: { /* '83' */
                    return 7;
                }
                case KnxDatapointType.DPT_PropDataType: { /* '84' */
                    return 10;
                }
                case KnxDatapointType.DPT_Length_mm: { /* '85' */
                    return 11;
                }
                case KnxDatapointType.DPT_UElCurrentmA: { /* '86' */
                    return 12;
                }
                case KnxDatapointType.DPT_Brightness: { /* '87' */
                    return 13;
                }
                case KnxDatapointType.DPT_Absolute_Colour_Temperature: { /* '88' */
                    return 600;
                }
                case KnxDatapointType.DPT_Value_2_Count: { /* '89' */
                    return 1;
                }
                case KnxDatapointType.INT: { /* '9' */
                    return 0;
                }
                case KnxDatapointType.DPT_DeltaTimeMsec: { /* '90' */
                    return 2;
                }
                case KnxDatapointType.DPT_DeltaTime10Msec: { /* '91' */
                    return 3;
                }
                case KnxDatapointType.DPT_DeltaTime100Msec: { /* '92' */
                    return 4;
                }
                case KnxDatapointType.DPT_DeltaTimeSec: { /* '93' */
                    return 5;
                }
                case KnxDatapointType.DPT_DeltaTimeMin: { /* '94' */
                    return 6;
                }
                case KnxDatapointType.DPT_DeltaTimeHrs: { /* '95' */
                    return 7;
                }
                case KnxDatapointType.DPT_Percent_V16: { /* '96' */
                    return 10;
                }
                case KnxDatapointType.DPT_Rotation_Angle: { /* '97' */
                    return 11;
                }
                case KnxDatapointType.DPT_Length_m: { /* '98' */
                    return 12;
                }
                case KnxDatapointType.DPT_Value_Temp: { /* '99' */
                    return 1;
                }
                default: {
                    return 0;
                }
            }
        }

        public static string Name(this KnxDatapointType value)
        {
            switch (value)
            {
                case KnxDatapointType.DPT_UNKNOWN: { /* '0' */
                    return "Unknown Datapoint Subtype";
                }
                case KnxDatapointType.BOOL: { /* '1' */
                    return "BOOL";
                }
                case KnxDatapointType.UDINT: { /* '10' */
                    return "UDINT";
                }
                case KnxDatapointType.DPT_Value_Tempd: { /* '100' */
                    return "temperature difference (K)";
                }
                case KnxDatapointType.DPT_Value_Tempa: { /* '101' */
                    return "kelvin/hour (K/h)";
                }
                case KnxDatapointType.DPT_Value_Lux: { /* '102' */
                    return "lux (Lux)";
                }
                case KnxDatapointType.DPT_Value_Wsp: { /* '103' */
                    return "speed (m/s)";
                }
                case KnxDatapointType.DPT_Value_Pres: { /* '104' */
                    return "pressure (Pa)";
                }
                case KnxDatapointType.DPT_Value_Humidity: { /* '105' */
                    return "humidity (%)";
                }
                case KnxDatapointType.DPT_Value_AirQuality: { /* '106' */
                    return "parts/million (ppm)";
                }
                case KnxDatapointType.DPT_Value_AirFlow: { /* '107' */
                    return "air flow (m³/h)";
                }
                case KnxDatapointType.DPT_Value_Time1: { /* '108' */
                    return "time (s)";
                }
                case KnxDatapointType.DPT_Value_Time2: { /* '109' */
                    return "time (ms)";
                }
                case KnxDatapointType.DINT: { /* '11' */
                    return "DINT";
                }
                case KnxDatapointType.DPT_Value_Volt: { /* '110' */
                    return "voltage (mV)";
                }
                case KnxDatapointType.DPT_Value_Curr: { /* '111' */
                    return "current (mA)";
                }
                case KnxDatapointType.DPT_PowerDensity: { /* '112' */
                    return "power density (W/m²)";
                }
                case KnxDatapointType.DPT_KelvinPerPercent: { /* '113' */
                    return "kelvin/percent (K/%)";
                }
                case KnxDatapointType.DPT_Power: { /* '114' */
                    return "power (kW)";
                }
                case KnxDatapointType.DPT_Value_Volume_Flow: { /* '115' */
                    return "volume flow (l/h)";
                }
                case KnxDatapointType.DPT_Rain_Amount: { /* '116' */
                    return "rain amount (l/m²)";
                }
                case KnxDatapointType.DPT_Value_Temp_F: { /* '117' */
                    return "temperature (°F)";
                }
                case KnxDatapointType.DPT_Value_Wsp_kmh: { /* '118' */
                    return "wind speed (km/h)";
                }
                case KnxDatapointType.DPT_Value_Absolute_Humidity: { /* '119' */
                    return "absolute humidity (g/m³)";
                }
                case KnxDatapointType.ULINT: { /* '12' */
                    return "ULINT";
                }
                case KnxDatapointType.DPT_Concentration_ygm3: { /* '120' */
                    return "concentration (µg/m³)";
                }
                case KnxDatapointType.DPT_Coefficient: { /* '121' */
                    return "coefficient";
                }
                case KnxDatapointType.DPT_TimeOfDay: { /* '122' */
                    return "time of day";
                }
                case KnxDatapointType.DPT_Date: { /* '123' */
                    return "date";
                }
                case KnxDatapointType.DPT_Value_4_Ucount: { /* '124' */
                    return "counter pulses (unsigned)";
                }
                case KnxDatapointType.DPT_LongTimePeriod_Sec: { /* '125' */
                    return "counter timesec (s)";
                }
                case KnxDatapointType.DPT_LongTimePeriod_Min: { /* '126' */
                    return "counter timemin (min)";
                }
                case KnxDatapointType.DPT_LongTimePeriod_Hrs: { /* '127' */
                    return "counter timehrs (h)";
                }
                case KnxDatapointType.DPT_VolumeLiquid_Litre: { /* '128' */
                    return "volume liquid (l)";
                }
                case KnxDatapointType.DPT_Volume_m_3: { /* '129' */
                    return "volume (m³)";
                }
                case KnxDatapointType.LINT: { /* '13' */
                    return "LINT";
                }
                case KnxDatapointType.DPT_Value_4_Count: { /* '130' */
                    return "counter pulses (signed)";
                }
                case KnxDatapointType.DPT_FlowRate_m3h: { /* '131' */
                    return "flow rate (m³/h)";
                }
                case KnxDatapointType.DPT_ActiveEnergy: { /* '132' */
                    return "active energy (Wh)";
                }
                case KnxDatapointType.DPT_ApparantEnergy: { /* '133' */
                    return "apparant energy (VAh)";
                }
                case KnxDatapointType.DPT_ReactiveEnergy: { /* '134' */
                    return "reactive energy (VARh)";
                }
                case KnxDatapointType.DPT_ActiveEnergy_kWh: { /* '135' */
                    return "active energy (kWh)";
                }
                case KnxDatapointType.DPT_ApparantEnergy_kVAh: { /* '136' */
                    return "apparant energy (kVAh)";
                }
                case KnxDatapointType.DPT_ReactiveEnergy_kVARh: { /* '137' */
                    return "reactive energy (kVARh)";
                }
                case KnxDatapointType.DPT_ActiveEnergy_MWh: { /* '138' */
                    return "active energy (MWh)";
                }
                case KnxDatapointType.DPT_LongDeltaTimeSec: { /* '139' */
                    return "time lag (s)";
                }
                case KnxDatapointType.REAL: { /* '14' */
                    return "REAL";
                }
                case KnxDatapointType.DPT_DeltaVolumeLiquid_Litre: { /* '140' */
                    return "delta volume liquid (l)";
                }
                case KnxDatapointType.DPT_DeltaVolume_m_3: { /* '141' */
                    return "delta volume (m³)";
                }
                case KnxDatapointType.DPT_Value_Acceleration: { /* '142' */
                    return "acceleration (m/s²)";
                }
                case KnxDatapointType.DPT_Value_Acceleration_Angular: { /* '143' */
                    return "angular acceleration (rad/s²)";
                }
                case KnxDatapointType.DPT_Value_Activation_Energy: { /* '144' */
                    return "activation energy (J/mol)";
                }
                case KnxDatapointType.DPT_Value_Activity: { /* '145' */
                    return "radioactive activity (1/s)";
                }
                case KnxDatapointType.DPT_Value_Mol: { /* '146' */
                    return "amount of substance (mol)";
                }
                case KnxDatapointType.DPT_Value_Amplitude: { /* '147' */
                    return "amplitude";
                }
                case KnxDatapointType.DPT_Value_AngleRad: { /* '148' */
                    return "angle (radiant)";
                }
                case KnxDatapointType.DPT_Value_AngleDeg: { /* '149' */
                    return "angle (degree)";
                }
                case KnxDatapointType.LREAL: { /* '15' */
                    return "LREAL";
                }
                case KnxDatapointType.DPT_Value_Angular_Momentum: { /* '150' */
                    return "angular momentum (Js)";
                }
                case KnxDatapointType.DPT_Value_Angular_Velocity: { /* '151' */
                    return "angular velocity (rad/s)";
                }
                case KnxDatapointType.DPT_Value_Area: { /* '152' */
                    return "area (m*m)";
                }
                case KnxDatapointType.DPT_Value_Capacitance: { /* '153' */
                    return "capacitance (F)";
                }
                case KnxDatapointType.DPT_Value_Charge_DensitySurface: { /* '154' */
                    return "flux density (C/m²)";
                }
                case KnxDatapointType.DPT_Value_Charge_DensityVolume: { /* '155' */
                    return "charge density (C/m³)";
                }
                case KnxDatapointType.DPT_Value_Compressibility: { /* '156' */
                    return "compressibility (m²/N)";
                }
                case KnxDatapointType.DPT_Value_Conductance: { /* '157' */
                    return "conductance (S)";
                }
                case KnxDatapointType.DPT_Value_Electrical_Conductivity: { /* '158' */
                    return "conductivity  (S/m)";
                }
                case KnxDatapointType.DPT_Value_Density: { /* '159' */
                    return "density (kg/m³)";
                }
                case KnxDatapointType.CHAR: { /* '16' */
                    return "CHAR";
                }
                case KnxDatapointType.DPT_Value_Electric_Charge: { /* '160' */
                    return "electric charge (C)";
                }
                case KnxDatapointType.DPT_Value_Electric_Current: { /* '161' */
                    return "electric current (A)";
                }
                case KnxDatapointType.DPT_Value_Electric_CurrentDensity: { /* '162' */
                    return "electric current density (A/m²)";
                }
                case KnxDatapointType.DPT_Value_Electric_DipoleMoment: { /* '163' */
                    return "electric dipole moment (Cm)";
                }
                case KnxDatapointType.DPT_Value_Electric_Displacement: { /* '164' */
                    return "electric displacement (C/m²)";
                }
                case KnxDatapointType.DPT_Value_Electric_FieldStrength: { /* '165' */
                    return "electric field strength (V/m)";
                }
                case KnxDatapointType.DPT_Value_Electric_Flux: { /* '166' */
                    return "electric flux (C)";
                }
                case KnxDatapointType.DPT_Value_Electric_FluxDensity: { /* '167' */
                    return "electric flux density (C/m²)";
                }
                case KnxDatapointType.DPT_Value_Electric_Polarization: { /* '168' */
                    return "electric polarization (C/m²)";
                }
                case KnxDatapointType.DPT_Value_Electric_Potential: { /* '169' */
                    return "electric potential (V)";
                }
                case KnxDatapointType.WCHAR: { /* '17' */
                    return "WCHAR";
                }
                case KnxDatapointType.DPT_Value_Electric_PotentialDifference: { /* '170' */
                    return "electric potential difference (V)";
                }
                case KnxDatapointType.DPT_Value_ElectromagneticMoment: { /* '171' */
                    return "electromagnetic moment (Am²)";
                }
                case KnxDatapointType.DPT_Value_Electromotive_Force: { /* '172' */
                    return "electromotive force (V)";
                }
                case KnxDatapointType.DPT_Value_Energy: { /* '173' */
                    return "energy (J)";
                }
                case KnxDatapointType.DPT_Value_Force: { /* '174' */
                    return "force (N)";
                }
                case KnxDatapointType.DPT_Value_Frequency: { /* '175' */
                    return "frequency (Hz)";
                }
                case KnxDatapointType.DPT_Value_Angular_Frequency: { /* '176' */
                    return "angular frequency (rad/s)";
                }
                case KnxDatapointType.DPT_Value_Heat_Capacity: { /* '177' */
                    return "heat capacity (J/K)";
                }
                case KnxDatapointType.DPT_Value_Heat_FlowRate: { /* '178' */
                    return "heat flow rate (W)";
                }
                case KnxDatapointType.DPT_Value_Heat_Quantity: { /* '179' */
                    return "heat quantity";
                }
                case KnxDatapointType.STRING: { /* '18' */
                    return "STRING";
                }
                case KnxDatapointType.DPT_Value_Impedance: { /* '180' */
                    return "impedance (Ω)";
                }
                case KnxDatapointType.DPT_Value_Length: { /* '181' */
                    return "length (m)";
                }
                case KnxDatapointType.DPT_Value_Light_Quantity: { /* '182' */
                    return "light quantity (J)";
                }
                case KnxDatapointType.DPT_Value_Luminance: { /* '183' */
                    return "luminance (cd/m²)";
                }
                case KnxDatapointType.DPT_Value_Luminous_Flux: { /* '184' */
                    return "luminous flux (lm)";
                }
                case KnxDatapointType.DPT_Value_Luminous_Intensity: { /* '185' */
                    return "luminous intensity (cd)";
                }
                case KnxDatapointType.DPT_Value_Magnetic_FieldStrength: { /* '186' */
                    return "magnetic field strength (A/m)";
                }
                case KnxDatapointType.DPT_Value_Magnetic_Flux: { /* '187' */
                    return "magnetic flux (Wb)";
                }
                case KnxDatapointType.DPT_Value_Magnetic_FluxDensity: { /* '188' */
                    return "magnetic flux density (T)";
                }
                case KnxDatapointType.DPT_Value_Magnetic_Moment: { /* '189' */
                    return "magnetic moment (Am²)";
                }
                case KnxDatapointType.WSTRING: { /* '19' */
                    return "WSTRING";
                }
                case KnxDatapointType.DPT_Value_Magnetic_Polarization: { /* '190' */
                    return "magnetic polarization (T)";
                }
                case KnxDatapointType.DPT_Value_Magnetization: { /* '191' */
                    return "magnetization (A/m)";
                }
                case KnxDatapointType.DPT_Value_MagnetomotiveForce: { /* '192' */
                    return "magnetomotive force (A)";
                }
                case KnxDatapointType.DPT_Value_Mass: { /* '193' */
                    return "mass (kg)";
                }
                case KnxDatapointType.DPT_Value_MassFlux: { /* '194' */
                    return "mass flux (kg/s)";
                }
                case KnxDatapointType.DPT_Value_Momentum: { /* '195' */
                    return "momentum (N/s)";
                }
                case KnxDatapointType.DPT_Value_Phase_AngleRad: { /* '196' */
                    return "phase angle (rad)";
                }
                case KnxDatapointType.DPT_Value_Phase_AngleDeg: { /* '197' */
                    return "phase angle (°)";
                }
                case KnxDatapointType.DPT_Value_Power: { /* '198' */
                    return "power (W)";
                }
                case KnxDatapointType.DPT_Value_Power_Factor: { /* '199' */
                    return "power factor (cos Φ)";
                }
                case KnxDatapointType.BYTE: { /* '2' */
                    return "BYTE";
                }
                case KnxDatapointType.TIME: { /* '20' */
                    return "TIME";
                }
                case KnxDatapointType.DPT_Value_Pressure: { /* '200' */
                    return "pressure (Pa)";
                }
                case KnxDatapointType.DPT_Value_Reactance: { /* '201' */
                    return "reactance (Ω)";
                }
                case KnxDatapointType.DPT_Value_Resistance: { /* '202' */
                    return "resistance (Ω)";
                }
                case KnxDatapointType.DPT_Value_Resistivity: { /* '203' */
                    return "resistivity (Ωm)";
                }
                case KnxDatapointType.DPT_Value_SelfInductance: { /* '204' */
                    return "self inductance (H)";
                }
                case KnxDatapointType.DPT_Value_SolidAngle: { /* '205' */
                    return "solid angle (sr)";
                }
                case KnxDatapointType.DPT_Value_Sound_Intensity: { /* '206' */
                    return "sound intensity (W/m²)";
                }
                case KnxDatapointType.DPT_Value_Speed: { /* '207' */
                    return "speed (m/s)";
                }
                case KnxDatapointType.DPT_Value_Stress: { /* '208' */
                    return "stress (Pa)";
                }
                case KnxDatapointType.DPT_Value_Surface_Tension: { /* '209' */
                    return "surface tension (N/m)";
                }
                case KnxDatapointType.LTIME: { /* '21' */
                    return "LTIME";
                }
                case KnxDatapointType.DPT_Value_Common_Temperature: { /* '210' */
                    return "temperature (°C)";
                }
                case KnxDatapointType.DPT_Value_Absolute_Temperature: { /* '211' */
                    return "temperature absolute (K)";
                }
                case KnxDatapointType.DPT_Value_TemperatureDifference: { /* '212' */
                    return "temperature difference (K)";
                }
                case KnxDatapointType.DPT_Value_Thermal_Capacity: { /* '213' */
                    return "thermal capacity (J/K)";
                }
                case KnxDatapointType.DPT_Value_Thermal_Conductivity: { /* '214' */
                    return "thermal conductivity (W/mK)";
                }
                case KnxDatapointType.DPT_Value_ThermoelectricPower: { /* '215' */
                    return "thermoelectric power (V/K)";
                }
                case KnxDatapointType.DPT_Value_Time: { /* '216' */
                    return "time (s)";
                }
                case KnxDatapointType.DPT_Value_Torque: { /* '217' */
                    return "torque (Nm)";
                }
                case KnxDatapointType.DPT_Value_Volume: { /* '218' */
                    return "volume (m³)";
                }
                case KnxDatapointType.DPT_Value_Volume_Flux: { /* '219' */
                    return "volume flux (m³/s)";
                }
                case KnxDatapointType.DATE: { /* '22' */
                    return "DATE";
                }
                case KnxDatapointType.DPT_Value_Weight: { /* '220' */
                    return "weight (N)";
                }
                case KnxDatapointType.DPT_Value_Work: { /* '221' */
                    return "work (J)";
                }
                case KnxDatapointType.DPT_Value_ApparentPower: { /* '222' */
                    return "apparent power (VA)";
                }
                case KnxDatapointType.DPT_Volume_Flux_Meter: { /* '223' */
                    return "volume flux for meters (m³/h)";
                }
                case KnxDatapointType.DPT_Volume_Flux_ls: { /* '224' */
                    return "volume flux for meters (1/ls)";
                }
                case KnxDatapointType.DPT_Access_Data: { /* '225' */
                    return "entrance access";
                }
                case KnxDatapointType.DPT_String_ASCII: { /* '226' */
                    return "Character String (ASCII)";
                }
                case KnxDatapointType.DPT_String_8859_1: { /* '227' */
                    return "Character String (ISO 8859-1)";
                }
                case KnxDatapointType.DPT_SceneNumber: { /* '228' */
                    return "scene number";
                }
                case KnxDatapointType.DPT_SceneControl: { /* '229' */
                    return "scene control";
                }
                case KnxDatapointType.TIME_OF_DAY: { /* '23' */
                    return "TIME_OF_DAY";
                }
                case KnxDatapointType.DPT_DateTime: { /* '230' */
                    return "date time";
                }
                case KnxDatapointType.DPT_SCLOMode: { /* '231' */
                    return "SCLO mode";
                }
                case KnxDatapointType.DPT_BuildingMode: { /* '232' */
                    return "building mode";
                }
                case KnxDatapointType.DPT_OccMode: { /* '233' */
                    return "occupied";
                }
                case KnxDatapointType.DPT_Priority: { /* '234' */
                    return "priority";
                }
                case KnxDatapointType.DPT_LightApplicationMode: { /* '235' */
                    return "light application mode";
                }
                case KnxDatapointType.DPT_ApplicationArea: { /* '236' */
                    return "light application area";
                }
                case KnxDatapointType.DPT_AlarmClassType: { /* '237' */
                    return "alarm class";
                }
                case KnxDatapointType.DPT_PSUMode: { /* '238' */
                    return "PSU mode";
                }
                case KnxDatapointType.DPT_ErrorClass_System: { /* '239' */
                    return "system error class";
                }
                case KnxDatapointType.TOD: { /* '24' */
                    return "TOD";
                }
                case KnxDatapointType.DPT_ErrorClass_HVAC: { /* '240' */
                    return "HVAC error class";
                }
                case KnxDatapointType.DPT_Time_Delay: { /* '241' */
                    return "time delay";
                }
                case KnxDatapointType.DPT_Beaufort_Wind_Force_Scale: { /* '242' */
                    return "wind force scale (0..12)";
                }
                case KnxDatapointType.DPT_SensorSelect: { /* '243' */
                    return "sensor mode";
                }
                case KnxDatapointType.DPT_ActuatorConnectType: { /* '244' */
                    return "actuator connect type";
                }
                case KnxDatapointType.DPT_Cloud_Cover: { /* '245' */
                    return "cloud cover";
                }
                case KnxDatapointType.DPT_PowerReturnMode: { /* '246' */
                    return "power return mode";
                }
                case KnxDatapointType.DPT_FuelType: { /* '247' */
                    return "fuel type";
                }
                case KnxDatapointType.DPT_BurnerType: { /* '248' */
                    return "burner type";
                }
                case KnxDatapointType.DPT_HVACMode: { /* '249' */
                    return "HVAC mode";
                }
                case KnxDatapointType.DATE_AND_TIME: { /* '25' */
                    return "DATE_AND_TIME";
                }
                case KnxDatapointType.DPT_DHWMode: { /* '250' */
                    return "DHW mode";
                }
                case KnxDatapointType.DPT_LoadPriority: { /* '251' */
                    return "load priority";
                }
                case KnxDatapointType.DPT_HVACContrMode: { /* '252' */
                    return "HVAC control mode";
                }
                case KnxDatapointType.DPT_HVACEmergMode: { /* '253' */
                    return "HVAC emergency mode";
                }
                case KnxDatapointType.DPT_ChangeoverMode: { /* '254' */
                    return "changeover mode";
                }
                case KnxDatapointType.DPT_ValveMode: { /* '255' */
                    return "valve mode";
                }
                case KnxDatapointType.DPT_DamperMode: { /* '256' */
                    return "damper mode";
                }
                case KnxDatapointType.DPT_HeaterMode: { /* '257' */
                    return "heater mode";
                }
                case KnxDatapointType.DPT_FanMode: { /* '258' */
                    return "fan mode";
                }
                case KnxDatapointType.DPT_MasterSlaveMode: { /* '259' */
                    return "master/slave mode";
                }
                case KnxDatapointType.DT: { /* '26' */
                    return "DT";
                }
                case KnxDatapointType.DPT_StatusRoomSetp: { /* '260' */
                    return "status room setpoint";
                }
                case KnxDatapointType.DPT_Metering_DeviceType: { /* '261' */
                    return "metering device type";
                }
                case KnxDatapointType.DPT_HumDehumMode: { /* '262' */
                    return "hum dehum mode";
                }
                case KnxDatapointType.DPT_EnableHCStage: { /* '263' */
                    return "enable H/C stage";
                }
                case KnxDatapointType.DPT_ADAType: { /* '264' */
                    return "ADA type";
                }
                case KnxDatapointType.DPT_BackupMode: { /* '265' */
                    return "backup mode";
                }
                case KnxDatapointType.DPT_StartSynchronization: { /* '266' */
                    return "start syncronization type";
                }
                case KnxDatapointType.DPT_Behaviour_Lock_Unlock: { /* '267' */
                    return "behavior lock/unlock";
                }
                case KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down: { /* '268' */
                    return "behavior bus power up/down";
                }
                case KnxDatapointType.DPT_DALI_Fade_Time: { /* '269' */
                    return "dali fade time";
                }
                case KnxDatapointType.DPT_Switch: { /* '27' */
                    return "switch";
                }
                case KnxDatapointType.DPT_BlinkingMode: { /* '270' */
                    return "blink mode";
                }
                case KnxDatapointType.DPT_LightControlMode: { /* '271' */
                    return "light control mode";
                }
                case KnxDatapointType.DPT_SwitchPBModel: { /* '272' */
                    return "PB switch mode";
                }
                case KnxDatapointType.DPT_PBAction: { /* '273' */
                    return "PB action mode";
                }
                case KnxDatapointType.DPT_DimmPBModel: { /* '274' */
                    return "PB dimm mode";
                }
                case KnxDatapointType.DPT_SwitchOnMode: { /* '275' */
                    return "switch on mode";
                }
                case KnxDatapointType.DPT_LoadTypeSet: { /* '276' */
                    return "load type";
                }
                case KnxDatapointType.DPT_LoadTypeDetected: { /* '277' */
                    return "load type detection";
                }
                case KnxDatapointType.DPT_Converter_Test_Control: { /* '278' */
                    return "converter test control";
                }
                case KnxDatapointType.DPT_SABExcept_Behaviour: { /* '279' */
                    return "SAB except behavior";
                }
                case KnxDatapointType.DPT_Bool: { /* '28' */
                    return "boolean";
                }
                case KnxDatapointType.DPT_SABBehaviour_Lock_Unlock: { /* '280' */
                    return "SAB behavior on lock/unlock";
                }
                case KnxDatapointType.DPT_SSSBMode: { /* '281' */
                    return "SSSB mode";
                }
                case KnxDatapointType.DPT_BlindsControlMode: { /* '282' */
                    return "blinds control mode";
                }
                case KnxDatapointType.DPT_CommMode: { /* '283' */
                    return "communication mode";
                }
                case KnxDatapointType.DPT_AddInfoTypes: { /* '284' */
                    return "additional information type";
                }
                case KnxDatapointType.DPT_RF_ModeSelect: { /* '285' */
                    return "RF mode selection";
                }
                case KnxDatapointType.DPT_RF_FilterSelect: { /* '286' */
                    return "RF filter mode selection";
                }
                case KnxDatapointType.DPT_StatusGen: { /* '287' */
                    return "general status";
                }
                case KnxDatapointType.DPT_Device_Control: { /* '288' */
                    return "device control";
                }
                case KnxDatapointType.DPT_ForceSign: { /* '289' */
                    return "forcing signal";
                }
                case KnxDatapointType.DPT_Enable: { /* '29' */
                    return "enable";
                }
                case KnxDatapointType.DPT_ForceSignCool: { /* '290' */
                    return "forcing signal cool";
                }
                case KnxDatapointType.DPT_StatusRHC: { /* '291' */
                    return "room heating controller status";
                }
                case KnxDatapointType.DPT_StatusSDHWC: { /* '292' */
                    return "solar DHW controller status";
                }
                case KnxDatapointType.DPT_FuelTypeSet: { /* '293' */
                    return "fuel type set";
                }
                case KnxDatapointType.DPT_StatusRCC: { /* '294' */
                    return "room cooling controller status";
                }
                case KnxDatapointType.DPT_StatusAHU: { /* '295' */
                    return "ventilation controller status";
                }
                case KnxDatapointType.DPT_CombinedStatus_RTSM: { /* '296' */
                    return "combined status RTSM";
                }
                case KnxDatapointType.DPT_LightActuatorErrorInfo: { /* '297' */
                    return "lighting actuator error information";
                }
                case KnxDatapointType.DPT_RF_ModeInfo: { /* '298' */
                    return "RF communication mode info";
                }
                case KnxDatapointType.DPT_RF_FilterInfo: { /* '299' */
                    return "cEMI server supported RF filtering modes";
                }
                case KnxDatapointType.WORD: { /* '3' */
                    return "WORD";
                }
                case KnxDatapointType.DPT_Ramp: { /* '30' */
                    return "ramp";
                }
                case KnxDatapointType.DPT_Channel_Activation_8: { /* '300' */
                    return "channel activation for 8 channels";
                }
                case KnxDatapointType.DPT_StatusDHWC: { /* '301' */
                    return "DHW controller status";
                }
                case KnxDatapointType.DPT_StatusRHCC: { /* '302' */
                    return "RHCC status";
                }
                case KnxDatapointType.DPT_CombinedStatus_HVA: { /* '303' */
                    return "combined status HVA";
                }
                case KnxDatapointType.DPT_CombinedStatus_RTC: { /* '304' */
                    return "combined status RTC";
                }
                case KnxDatapointType.DPT_Media: { /* '305' */
                    return "media";
                }
                case KnxDatapointType.DPT_Channel_Activation_16: { /* '306' */
                    return "channel activation for 16 channels";
                }
                case KnxDatapointType.DPT_OnOffAction: { /* '307' */
                    return "on/off action";
                }
                case KnxDatapointType.DPT_Alarm_Reaction: { /* '308' */
                    return "alarm reaction";
                }
                case KnxDatapointType.DPT_UpDown_Action: { /* '309' */
                    return "up/down action";
                }
                case KnxDatapointType.DPT_Alarm: { /* '31' */
                    return "alarm";
                }
                case KnxDatapointType.DPT_HVAC_PB_Action: { /* '310' */
                    return "HVAC push button action";
                }
                case KnxDatapointType.DPT_DoubleNibble: { /* '311' */
                    return "busy/nak repetitions";
                }
                case KnxDatapointType.DPT_SceneInfo: { /* '312' */
                    return "scene information";
                }
                case KnxDatapointType.DPT_CombinedInfoOnOff: { /* '313' */
                    return "bit-combined info on/off";
                }
                case KnxDatapointType.DPT_ActiveEnergy_V64: { /* '314' */
                    return "active energy (Wh)";
                }
                case KnxDatapointType.DPT_ApparantEnergy_V64: { /* '315' */
                    return "apparant energy (VAh)";
                }
                case KnxDatapointType.DPT_ReactiveEnergy_V64: { /* '316' */
                    return "reactive energy (VARh)";
                }
                case KnxDatapointType.DPT_Channel_Activation_24: { /* '317' */
                    return "activation state 0..23";
                }
                case KnxDatapointType.DPT_HVACModeNext: { /* '318' */
                    return "time delay & HVAC mode";
                }
                case KnxDatapointType.DPT_DHWModeNext: { /* '319' */
                    return "time delay & DHW mode";
                }
                case KnxDatapointType.DPT_BinaryValue: { /* '32' */
                    return "binary value";
                }
                case KnxDatapointType.DPT_OccModeNext: { /* '320' */
                    return "time delay & occupancy mode";
                }
                case KnxDatapointType.DPT_BuildingModeNext: { /* '321' */
                    return "time delay & building mode";
                }
                case KnxDatapointType.DPT_StatusLightingActuator: { /* '322' */
                    return "Status Lighting Actuator";
                }
                case KnxDatapointType.DPT_Version: { /* '323' */
                    return "DPT version";
                }
                case KnxDatapointType.DPT_AlarmInfo: { /* '324' */
                    return "alarm info";
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_3: { /* '325' */
                    return "room temperature setpoint";
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3: { /* '326' */
                    return "room temperature setpoint shift";
                }
                case KnxDatapointType.DPT_Scaling_Speed: { /* '327' */
                    return "scaling speed";
                }
                case KnxDatapointType.DPT_Scaling_Step_Time: { /* '328' */
                    return "scaling step time";
                }
                case KnxDatapointType.DPT_MeteringValue: { /* '329' */
                    return "metering value (value,encoding,cmd)";
                }
                case KnxDatapointType.DPT_Step: { /* '33' */
                    return "step";
                }
                case KnxDatapointType.DPT_MBus_Address: { /* '330' */
                    return "MBus address";
                }
                case KnxDatapointType.DPT_Colour_RGB: { /* '331' */
                    return "RGB value 3x(0..255)";
                }
                case KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII: { /* '332' */
                    return "language code (ASCII)";
                }
                case KnxDatapointType.DPT_Tariff_ActiveEnergy: { /* '333' */
                    return "electrical energy with tariff";
                }
                case KnxDatapointType.DPT_Prioritised_Mode_Control: { /* '334' */
                    return "priority control";
                }
                case KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic: { /* '335' */
                    return "diagnostic value";
                }
                case KnxDatapointType.DPT_DALI_Diagnostics: { /* '336' */
                    return "diagnostic value";
                }
                case KnxDatapointType.DPT_CombinedPosition: { /* '337' */
                    return "combined position";
                }
                case KnxDatapointType.DPT_StatusSAB: { /* '338' */
                    return "status sunblind & shutter actuator";
                }
                case KnxDatapointType.DPT_Colour_xyY: { /* '339' */
                    return "colour xyY";
                }
                case KnxDatapointType.DPT_UpDown: { /* '34' */
                    return "up/down";
                }
                case KnxDatapointType.DPT_Converter_Status: { /* '340' */
                    return "DALI converter status";
                }
                case KnxDatapointType.DPT_Converter_Test_Result: { /* '341' */
                    return "DALI converter test result";
                }
                case KnxDatapointType.DPT_Battery_Info: { /* '342' */
                    return "Battery Information";
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition: { /* '343' */
                    return "brightness colour temperature transition";
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Control: { /* '344' */
                    return "brightness colour temperature control";
                }
                case KnxDatapointType.DPT_Colour_RGBW: { /* '345' */
                    return "RGBW value 4x(0..100%)";
                }
                case KnxDatapointType.DPT_Relative_Control_RGBW: { /* '346' */
                    return "RGBW relative control";
                }
                case KnxDatapointType.DPT_Relative_Control_RGB: { /* '347' */
                    return "RGB relative control";
                }
                case KnxDatapointType.DPT_GeographicalLocation: { /* '348' */
                    return "geographical location (longitude and latitude) expressed in degrees";
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_4: { /* '349' */
                    return "Temperature setpoint setting for 4 HVAC Modes";
                }
                case KnxDatapointType.DPT_OpenClose: { /* '35' */
                    return "open/close";
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4: { /* '350' */
                    return "Temperature setpoint shift setting for 4 HVAC Modes";
                }
                case KnxDatapointType.DPT_Start: { /* '36' */
                    return "start/stop";
                }
                case KnxDatapointType.DPT_State: { /* '37' */
                    return "state";
                }
                case KnxDatapointType.DPT_Invert: { /* '38' */
                    return "invert";
                }
                case KnxDatapointType.DPT_DimSendStyle: { /* '39' */
                    return "dim send style";
                }
                case KnxDatapointType.DWORD: { /* '4' */
                    return "DWORD";
                }
                case KnxDatapointType.DPT_InputSource: { /* '40' */
                    return "input source";
                }
                case KnxDatapointType.DPT_Reset: { /* '41' */
                    return "reset";
                }
                case KnxDatapointType.DPT_Ack: { /* '42' */
                    return "acknowledge";
                }
                case KnxDatapointType.DPT_Trigger: { /* '43' */
                    return "trigger";
                }
                case KnxDatapointType.DPT_Occupancy: { /* '44' */
                    return "occupancy";
                }
                case KnxDatapointType.DPT_Window_Door: { /* '45' */
                    return "window/door";
                }
                case KnxDatapointType.DPT_LogicalFunction: { /* '46' */
                    return "logical function";
                }
                case KnxDatapointType.DPT_Scene_AB: { /* '47' */
                    return "scene";
                }
                case KnxDatapointType.DPT_ShutterBlinds_Mode: { /* '48' */
                    return "shutter/blinds mode";
                }
                case KnxDatapointType.DPT_DayNight: { /* '49' */
                    return "day/night";
                }
                case KnxDatapointType.LWORD: { /* '5' */
                    return "LWORD";
                }
                case KnxDatapointType.DPT_Heat_Cool: { /* '50' */
                    return "cooling/heating";
                }
                case KnxDatapointType.DPT_Switch_Control: { /* '51' */
                    return "switch control";
                }
                case KnxDatapointType.DPT_Bool_Control: { /* '52' */
                    return "boolean control";
                }
                case KnxDatapointType.DPT_Enable_Control: { /* '53' */
                    return "enable control";
                }
                case KnxDatapointType.DPT_Ramp_Control: { /* '54' */
                    return "ramp control";
                }
                case KnxDatapointType.DPT_Alarm_Control: { /* '55' */
                    return "alarm control";
                }
                case KnxDatapointType.DPT_BinaryValue_Control: { /* '56' */
                    return "binary value control";
                }
                case KnxDatapointType.DPT_Step_Control: { /* '57' */
                    return "step control";
                }
                case KnxDatapointType.DPT_Direction1_Control: { /* '58' */
                    return "direction control 1";
                }
                case KnxDatapointType.DPT_Direction2_Control: { /* '59' */
                    return "direction control 2";
                }
                case KnxDatapointType.USINT: { /* '6' */
                    return "USINT";
                }
                case KnxDatapointType.DPT_Start_Control: { /* '60' */
                    return "start control";
                }
                case KnxDatapointType.DPT_State_Control: { /* '61' */
                    return "state control";
                }
                case KnxDatapointType.DPT_Invert_Control: { /* '62' */
                    return "invert control";
                }
                case KnxDatapointType.DPT_Control_Dimming: { /* '63' */
                    return "dimming control";
                }
                case KnxDatapointType.DPT_Control_Blinds: { /* '64' */
                    return "blind control";
                }
                case KnxDatapointType.DPT_Char_ASCII: { /* '65' */
                    return "character (ASCII)";
                }
                case KnxDatapointType.DPT_Char_8859_1: { /* '66' */
                    return "character (ISO 8859-1)";
                }
                case KnxDatapointType.DPT_Scaling: { /* '67' */
                    return "percentage (0..100%)";
                }
                case KnxDatapointType.DPT_Angle: { /* '68' */
                    return "angle (degrees)";
                }
                case KnxDatapointType.DPT_Percent_U8: { /* '69' */
                    return "percentage (0..255%)";
                }
                case KnxDatapointType.SINT: { /* '7' */
                    return "SINT";
                }
                case KnxDatapointType.DPT_DecimalFactor: { /* '70' */
                    return "ratio (0..255)";
                }
                case KnxDatapointType.DPT_Tariff: { /* '71' */
                    return "tariff (0..255)";
                }
                case KnxDatapointType.DPT_Value_1_Ucount: { /* '72' */
                    return "counter pulses (0..255)";
                }
                case KnxDatapointType.DPT_FanStage: { /* '73' */
                    return "fan stage (0..255)";
                }
                case KnxDatapointType.DPT_Percent_V8: { /* '74' */
                    return "percentage (-128..127%)";
                }
                case KnxDatapointType.DPT_Value_1_Count: { /* '75' */
                    return "counter pulses (-128..127)";
                }
                case KnxDatapointType.DPT_Status_Mode3: { /* '76' */
                    return "status with mode";
                }
                case KnxDatapointType.DPT_Value_2_Ucount: { /* '77' */
                    return "pulses";
                }
                case KnxDatapointType.DPT_TimePeriodMsec: { /* '78' */
                    return "time (ms)";
                }
                case KnxDatapointType.DPT_TimePeriod10Msec: { /* '79' */
                    return "time (10 ms)";
                }
                case KnxDatapointType.UINT: { /* '8' */
                    return "UINT";
                }
                case KnxDatapointType.DPT_TimePeriod100Msec: { /* '80' */
                    return "time (100 ms)";
                }
                case KnxDatapointType.DPT_TimePeriodSec: { /* '81' */
                    return "time (s)";
                }
                case KnxDatapointType.DPT_TimePeriodMin: { /* '82' */
                    return "time (min)";
                }
                case KnxDatapointType.DPT_TimePeriodHrs: { /* '83' */
                    return "time (h)";
                }
                case KnxDatapointType.DPT_PropDataType: { /* '84' */
                    return "property data type";
                }
                case KnxDatapointType.DPT_Length_mm: { /* '85' */
                    return "length (mm)";
                }
                case KnxDatapointType.DPT_UElCurrentmA: { /* '86' */
                    return "current (mA)";
                }
                case KnxDatapointType.DPT_Brightness: { /* '87' */
                    return "brightness (lux)";
                }
                case KnxDatapointType.DPT_Absolute_Colour_Temperature: { /* '88' */
                    return "absolute colour temperature (K)";
                }
                case KnxDatapointType.DPT_Value_2_Count: { /* '89' */
                    return "pulses difference";
                }
                case KnxDatapointType.INT: { /* '9' */
                    return "INT";
                }
                case KnxDatapointType.DPT_DeltaTimeMsec: { /* '90' */
                    return "time lag (ms)";
                }
                case KnxDatapointType.DPT_DeltaTime10Msec: { /* '91' */
                    return "time lag(10 ms)";
                }
                case KnxDatapointType.DPT_DeltaTime100Msec: { /* '92' */
                    return "time lag (100 ms)";
                }
                case KnxDatapointType.DPT_DeltaTimeSec: { /* '93' */
                    return "time lag (s)";
                }
                case KnxDatapointType.DPT_DeltaTimeMin: { /* '94' */
                    return "time lag (min)";
                }
                case KnxDatapointType.DPT_DeltaTimeHrs: { /* '95' */
                    return "time lag (h)";
                }
                case KnxDatapointType.DPT_Percent_V16: { /* '96' */
                    return "percentage difference (%)";
                }
                case KnxDatapointType.DPT_Rotation_Angle: { /* '97' */
                    return "rotation angle (°)";
                }
                case KnxDatapointType.DPT_Length_m: { /* '98' */
                    return "length (m)";
                }
                case KnxDatapointType.DPT_Value_Temp: { /* '99' */
                    return "temperature (°C)";
                }
                default: {
                    return null;
                }
            }
        }

        public static KnxDatapointMainType? DatapointMainType(this KnxDatapointType value)
        {
            switch (value)
            {
                case KnxDatapointType.DPT_UNKNOWN: { /* '0' */
                    return model.KnxDatapointMainType.DPT_UNKNOWN;
                }
                case KnxDatapointType.BOOL: { /* '1' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.UDINT: { /* '10' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Tempd: { /* '100' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Tempa: { /* '101' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Lux: { /* '102' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Wsp: { /* '103' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Pres: { /* '104' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Humidity: { /* '105' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_AirQuality: { /* '106' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_AirFlow: { /* '107' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Time1: { /* '108' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Time2: { /* '109' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DINT: { /* '11' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Volt: { /* '110' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Curr: { /* '111' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_PowerDensity: { /* '112' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_KelvinPerPercent: { /* '113' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Power: { /* '114' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Volume_Flow: { /* '115' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Rain_Amount: { /* '116' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Temp_F: { /* '117' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Wsp_kmh: { /* '118' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Absolute_Humidity: { /* '119' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.ULINT: { /* '12' */
                    return model.KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Concentration_ygm3: { /* '120' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Coefficient: { /* '121' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_TimeOfDay: { /* '122' */
                    return model.KnxDatapointMainType.DPT_TIME;
                }
                case KnxDatapointType.DPT_Date: { /* '123' */
                    return model.KnxDatapointMainType.DPT_DATE;
                }
                case KnxDatapointType.DPT_Value_4_Ucount: { /* '124' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Sec: { /* '125' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Min: { /* '126' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_LongTimePeriod_Hrs: { /* '127' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_VolumeLiquid_Litre: { /* '128' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Volume_m_3: { /* '129' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.LINT: { /* '13' */
                    return model.KnxDatapointMainType.DPT_8_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_4_Count: { /* '130' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_FlowRate_m3h: { /* '131' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ActiveEnergy: { /* '132' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ApparantEnergy: { /* '133' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ReactiveEnergy: { /* '134' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ActiveEnergy_kWh: { /* '135' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ApparantEnergy_kVAh: { /* '136' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ReactiveEnergy_kVARh: { /* '137' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ActiveEnergy_MWh: { /* '138' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_LongDeltaTimeSec: { /* '139' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.REAL: { /* '14' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_DeltaVolumeLiquid_Litre: { /* '140' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaVolume_m_3: { /* '141' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Acceleration: { /* '142' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Acceleration_Angular: { /* '143' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Activation_Energy: { /* '144' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Activity: { /* '145' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Mol: { /* '146' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Amplitude: { /* '147' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_AngleRad: { /* '148' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_AngleDeg: { /* '149' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.LREAL: { /* '15' */
                    return model.KnxDatapointMainType.DPT_8_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Angular_Momentum: { /* '150' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Angular_Velocity: { /* '151' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Area: { /* '152' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Capacitance: { /* '153' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Charge_DensitySurface: { /* '154' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Charge_DensityVolume: { /* '155' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Compressibility: { /* '156' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Conductance: { /* '157' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electrical_Conductivity: { /* '158' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Density: { /* '159' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.CHAR: { /* '16' */
                    return model.KnxDatapointMainType.DPT_CHARACTER;
                }
                case KnxDatapointType.DPT_Value_Electric_Charge: { /* '160' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_Current: { /* '161' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_CurrentDensity: { /* '162' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_DipoleMoment: { /* '163' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_Displacement: { /* '164' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_FieldStrength: { /* '165' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_Flux: { /* '166' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_FluxDensity: { /* '167' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_Polarization: { /* '168' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_Potential: { /* '169' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.WCHAR: { /* '17' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electric_PotentialDifference: { /* '170' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_ElectromagneticMoment: { /* '171' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Electromotive_Force: { /* '172' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Energy: { /* '173' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Force: { /* '174' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Frequency: { /* '175' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Angular_Frequency: { /* '176' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Heat_Capacity: { /* '177' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Heat_FlowRate: { /* '178' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Heat_Quantity: { /* '179' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.STRING: { /* '18' */
                    return model.KnxDatapointMainType.DPT_UNKNOWN;
                }
                case KnxDatapointType.DPT_Value_Impedance: { /* '180' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Length: { /* '181' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Light_Quantity: { /* '182' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Luminance: { /* '183' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Luminous_Flux: { /* '184' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Luminous_Intensity: { /* '185' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Magnetic_FieldStrength: { /* '186' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Flux: { /* '187' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Magnetic_FluxDensity: { /* '188' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Moment: { /* '189' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.WSTRING: { /* '19' */
                    return model.KnxDatapointMainType.DPT_UNKNOWN;
                }
                case KnxDatapointType.DPT_Value_Magnetic_Polarization: { /* '190' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Magnetization: { /* '191' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_MagnetomotiveForce: { /* '192' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Mass: { /* '193' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_MassFlux: { /* '194' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Momentum: { /* '195' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Phase_AngleRad: { /* '196' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Phase_AngleDeg: { /* '197' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Power: { /* '198' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Power_Factor: { /* '199' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.BYTE: { /* '2' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.TIME: { /* '20' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Pressure: { /* '200' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Reactance: { /* '201' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Resistance: { /* '202' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Resistivity: { /* '203' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_SelfInductance: { /* '204' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_SolidAngle: { /* '205' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Sound_Intensity: { /* '206' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Speed: { /* '207' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Stress: { /* '208' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Surface_Tension: { /* '209' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.LTIME: { /* '21' */
                    return model.KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Common_Temperature: { /* '210' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Absolute_Temperature: { /* '211' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_TemperatureDifference: { /* '212' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Thermal_Capacity: { /* '213' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Thermal_Conductivity: { /* '214' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_ThermoelectricPower: { /* '215' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Time: { /* '216' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Torque: { /* '217' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Volume: { /* '218' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Volume_Flux: { /* '219' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DATE: { /* '22' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Weight: { /* '220' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_Work: { /* '221' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Value_ApparentPower: { /* '222' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Volume_Flux_Meter: { /* '223' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Volume_Flux_ls: { /* '224' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Access_Data: { /* '225' */
                    return model.KnxDatapointMainType.DPT_ENTRANCE_ACCESS;
                }
                case KnxDatapointType.DPT_String_ASCII: { /* '226' */
                    return model.KnxDatapointMainType.DPT_CHARACTER_STRING;
                }
                case KnxDatapointType.DPT_String_8859_1: { /* '227' */
                    return model.KnxDatapointMainType.DPT_CHARACTER_STRING;
                }
                case KnxDatapointType.DPT_SceneNumber: { /* '228' */
                    return model.KnxDatapointMainType.DPT_SCENE_NUMBER;
                }
                case KnxDatapointType.DPT_SceneControl: { /* '229' */
                    return model.KnxDatapointMainType.DPT_SCENE_CONTROL;
                }
                case KnxDatapointType.TIME_OF_DAY: { /* '23' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DateTime: { /* '230' */
                    return model.KnxDatapointMainType.DPT_DATE_TIME;
                }
                case KnxDatapointType.DPT_SCLOMode: { /* '231' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_BuildingMode: { /* '232' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_OccMode: { /* '233' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Priority: { /* '234' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_LightApplicationMode: { /* '235' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ApplicationArea: { /* '236' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_AlarmClassType: { /* '237' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_PSUMode: { /* '238' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ErrorClass_System: { /* '239' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.TOD: { /* '24' */
                    return model.KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_ErrorClass_HVAC: { /* '240' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Time_Delay: { /* '241' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Beaufort_Wind_Force_Scale: { /* '242' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_SensorSelect: { /* '243' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ActuatorConnectType: { /* '244' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Cloud_Cover: { /* '245' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_PowerReturnMode: { /* '246' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_FuelType: { /* '247' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_BurnerType: { /* '248' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_HVACMode: { /* '249' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DATE_AND_TIME: { /* '25' */
                    return model.KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DHWMode: { /* '250' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_LoadPriority: { /* '251' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_HVACContrMode: { /* '252' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_HVACEmergMode: { /* '253' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ChangeoverMode: { /* '254' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ValveMode: { /* '255' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_DamperMode: { /* '256' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_HeaterMode: { /* '257' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_FanMode: { /* '258' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_MasterSlaveMode: { /* '259' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DT: { /* '26' */
                    return model.KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_StatusRoomSetp: { /* '260' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Metering_DeviceType: { /* '261' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_HumDehumMode: { /* '262' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_EnableHCStage: { /* '263' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_ADAType: { /* '264' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_BackupMode: { /* '265' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_StartSynchronization: { /* '266' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Behaviour_Lock_Unlock: { /* '267' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down: { /* '268' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_DALI_Fade_Time: { /* '269' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Switch: { /* '27' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_BlinkingMode: { /* '270' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_LightControlMode: { /* '271' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_SwitchPBModel: { /* '272' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_PBAction: { /* '273' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_DimmPBModel: { /* '274' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_SwitchOnMode: { /* '275' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_LoadTypeSet: { /* '276' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_LoadTypeDetected: { /* '277' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Converter_Test_Control: { /* '278' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_SABExcept_Behaviour: { /* '279' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_Bool: { /* '28' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_SABBehaviour_Lock_Unlock: { /* '280' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_SSSBMode: { /* '281' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_BlindsControlMode: { /* '282' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_CommMode: { /* '283' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_AddInfoTypes: { /* '284' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_RF_ModeSelect: { /* '285' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_RF_FilterSelect: { /* '286' */
                    return model.KnxDatapointMainType.DPT_1_BYTE;
                }
                case KnxDatapointType.DPT_StatusGen: { /* '287' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_Device_Control: { /* '288' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_ForceSign: { /* '289' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_Enable: { /* '29' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_ForceSignCool: { /* '290' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusRHC: { /* '291' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusSDHWC: { /* '292' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_FuelTypeSet: { /* '293' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusRCC: { /* '294' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusAHU: { /* '295' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_CombinedStatus_RTSM: { /* '296' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_LightActuatorErrorInfo: { /* '297' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_RF_ModeInfo: { /* '298' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_RF_FilterInfo: { /* '299' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.WORD: { /* '3' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_Ramp: { /* '30' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Channel_Activation_8: { /* '300' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusDHWC: { /* '301' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_StatusRHCC: { /* '302' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_CombinedStatus_HVA: { /* '303' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_CombinedStatus_RTC: { /* '304' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_Media: { /* '305' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_Channel_Activation_16: { /* '306' */
                    return model.KnxDatapointMainType.DPT_16_BIT_SET;
                }
                case KnxDatapointType.DPT_OnOffAction: { /* '307' */
                    return model.KnxDatapointMainType.DPT_2_BIT_SET;
                }
                case KnxDatapointType.DPT_Alarm_Reaction: { /* '308' */
                    return model.KnxDatapointMainType.DPT_2_BIT_SET;
                }
                case KnxDatapointType.DPT_UpDown_Action: { /* '309' */
                    return model.KnxDatapointMainType.DPT_2_BIT_SET;
                }
                case KnxDatapointType.DPT_Alarm: { /* '31' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_HVAC_PB_Action: { /* '310' */
                    return model.KnxDatapointMainType.DPT_2_BIT_SET;
                }
                case KnxDatapointType.DPT_DoubleNibble: { /* '311' */
                    return model.KnxDatapointMainType.DPT_2_NIBBLE_SET;
                }
                case KnxDatapointType.DPT_SceneInfo: { /* '312' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SET_2;
                }
                case KnxDatapointType.DPT_CombinedInfoOnOff: { /* '313' */
                    return model.KnxDatapointMainType.DPT_32_BIT_SET;
                }
                case KnxDatapointType.DPT_ActiveEnergy_V64: { /* '314' */
                    return model.KnxDatapointMainType.DPT_ELECTRICAL_ENERGY;
                }
                case KnxDatapointType.DPT_ApparantEnergy_V64: { /* '315' */
                    return model.KnxDatapointMainType.DPT_ELECTRICAL_ENERGY;
                }
                case KnxDatapointType.DPT_ReactiveEnergy_V64: { /* '316' */
                    return model.KnxDatapointMainType.DPT_ELECTRICAL_ENERGY;
                }
                case KnxDatapointType.DPT_Channel_Activation_24: { /* '317' */
                    return model.KnxDatapointMainType.DPT_24_TIMES_CHANNEL_ACTIVATION;
                }
                case KnxDatapointType.DPT_HVACModeNext: { /* '318' */
                    return model.KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM;
                }
                case KnxDatapointType.DPT_DHWModeNext: { /* '319' */
                    return model.KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM;
                }
                case KnxDatapointType.DPT_BinaryValue: { /* '32' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_OccModeNext: { /* '320' */
                    return model.KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM;
                }
                case KnxDatapointType.DPT_BuildingModeNext: { /* '321' */
                    return model.KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM;
                }
                case KnxDatapointType.DPT_StatusLightingActuator: { /* '322' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM;
                }
                case KnxDatapointType.DPT_Version: { /* '323' */
                    return model.KnxDatapointMainType.DPT_DATAPOINT_TYPE_VERSION;
                }
                case KnxDatapointType.DPT_AlarmInfo: { /* '324' */
                    return model.KnxDatapointMainType.DPT_ALARM_INFO;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_3: { /* '325' */
                    return model.KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3: { /* '326' */
                    return model.KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE;
                }
                case KnxDatapointType.DPT_Scaling_Speed: { /* '327' */
                    return model.KnxDatapointMainType.DPT_SCALING_SPEED;
                }
                case KnxDatapointType.DPT_Scaling_Step_Time: { /* '328' */
                    return model.KnxDatapointMainType.DPT_SCALING_SPEED;
                }
                case KnxDatapointType.DPT_MeteringValue: { /* '329' */
                    return model.KnxDatapointMainType.DPT_4_1_1_BYTE_COMBINED_INFORMATION;
                }
                case KnxDatapointType.DPT_Step: { /* '33' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_MBus_Address: { /* '330' */
                    return model.KnxDatapointMainType.DPT_MBUS_ADDRESS;
                }
                case KnxDatapointType.DPT_Colour_RGB: { /* '331' */
                    return model.KnxDatapointMainType.DPT_3_BYTE_COLOUR_RGB;
                }
                case KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII: { /* '332' */
                    return model.KnxDatapointMainType.DPT_LANGUAGE_CODE_ISO_639_1;
                }
                case KnxDatapointType.DPT_Tariff_ActiveEnergy: { /* '333' */
                    return model.KnxDatapointMainType.DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY;
                }
                case KnxDatapointType.DPT_Prioritised_Mode_Control: { /* '334' */
                    return model.KnxDatapointMainType.DPT_PRIORITISED_MODE_CONTROL;
                }
                case KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic: { /* '335' */
                    return model.KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_16_BIT;
                }
                case KnxDatapointType.DPT_DALI_Diagnostics: { /* '336' */
                    return model.KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_8_BIT;
                }
                case KnxDatapointType.DPT_CombinedPosition: { /* '337' */
                    return model.KnxDatapointMainType.DPT_POSITIONS;
                }
                case KnxDatapointType.DPT_StatusSAB: { /* '338' */
                    return model.KnxDatapointMainType.DPT_STATUS_32_BIT;
                }
                case KnxDatapointType.DPT_Colour_xyY: { /* '339' */
                    return model.KnxDatapointMainType.DPT_STATUS_48_BIT;
                }
                case KnxDatapointType.DPT_UpDown: { /* '34' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Converter_Status: { /* '340' */
                    return model.KnxDatapointMainType.DPT_CONVERTER_STATUS;
                }
                case KnxDatapointType.DPT_Converter_Test_Result: { /* '341' */
                    return model.KnxDatapointMainType.DPT_CONVERTER_TEST_RESULT;
                }
                case KnxDatapointType.DPT_Battery_Info: { /* '342' */
                    return model.KnxDatapointMainType.DPT_BATTERY_INFORMATION;
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition: { /* '343' */
                    return model.KnxDatapointMainType.DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION;
                }
                case KnxDatapointType.DPT_Brightness_Colour_Temperature_Control: { /* '344' */
                    return model.KnxDatapointMainType.DPT_STATUS_24_BIT;
                }
                case KnxDatapointType.DPT_Colour_RGBW: { /* '345' */
                    return model.KnxDatapointMainType.DPT_COLOUR_RGBW;
                }
                case KnxDatapointType.DPT_Relative_Control_RGBW: { /* '346' */
                    return model.KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGBW;
                }
                case KnxDatapointType.DPT_Relative_Control_RGB: { /* '347' */
                    return model.KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGB;
                }
                case KnxDatapointType.DPT_GeographicalLocation: { /* '348' */
                    return model.KnxDatapointMainType.DPT_F32F32;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetF16_4: { /* '349' */
                    return model.KnxDatapointMainType.DPT_F16F16F16F16;
                }
                case KnxDatapointType.DPT_OpenClose: { /* '35' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4: { /* '350' */
                    return model.KnxDatapointMainType.DPT_F16F16F16F16;
                }
                case KnxDatapointType.DPT_Start: { /* '36' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_State: { /* '37' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Invert: { /* '38' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_DimSendStyle: { /* '39' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DWORD: { /* '4' */
                    return model.KnxDatapointMainType.DPT_32_BIT_SET;
                }
                case KnxDatapointType.DPT_InputSource: { /* '40' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Reset: { /* '41' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Ack: { /* '42' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Trigger: { /* '43' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Occupancy: { /* '44' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Window_Door: { /* '45' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_LogicalFunction: { /* '46' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Scene_AB: { /* '47' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_ShutterBlinds_Mode: { /* '48' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_DayNight: { /* '49' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.LWORD: { /* '5' */
                    return model.KnxDatapointMainType.DPT_64_BIT_SET;
                }
                case KnxDatapointType.DPT_Heat_Cool: { /* '50' */
                    return model.KnxDatapointMainType.DPT_1_BIT;
                }
                case KnxDatapointType.DPT_Switch_Control: { /* '51' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Bool_Control: { /* '52' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Enable_Control: { /* '53' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Ramp_Control: { /* '54' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Alarm_Control: { /* '55' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_BinaryValue_Control: { /* '56' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Step_Control: { /* '57' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Direction1_Control: { /* '58' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Direction2_Control: { /* '59' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.USINT: { /* '6' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Start_Control: { /* '60' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_State_Control: { /* '61' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Invert_Control: { /* '62' */
                    return model.KnxDatapointMainType.DPT_1_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Control_Dimming: { /* '63' */
                    return model.KnxDatapointMainType.DPT_3_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Control_Blinds: { /* '64' */
                    return model.KnxDatapointMainType.DPT_3_BIT_CONTROLLED;
                }
                case KnxDatapointType.DPT_Char_ASCII: { /* '65' */
                    return model.KnxDatapointMainType.DPT_CHARACTER;
                }
                case KnxDatapointType.DPT_Char_8859_1: { /* '66' */
                    return model.KnxDatapointMainType.DPT_CHARACTER;
                }
                case KnxDatapointType.DPT_Scaling: { /* '67' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Angle: { /* '68' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Percent_U8: { /* '69' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.SINT: { /* '7' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DecimalFactor: { /* '70' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Tariff: { /* '71' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_1_Ucount: { /* '72' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_FanStage: { /* '73' */
                    return model.KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Percent_V8: { /* '74' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_1_Count: { /* '75' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Status_Mode3: { /* '76' */
                    return model.KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_2_Ucount: { /* '77' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriodMsec: { /* '78' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriod10Msec: { /* '79' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.UINT: { /* '8' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriod100Msec: { /* '80' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriodSec: { /* '81' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriodMin: { /* '82' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_TimePeriodHrs: { /* '83' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_PropDataType: { /* '84' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Length_mm: { /* '85' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_UElCurrentmA: { /* '86' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Brightness: { /* '87' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Absolute_Colour_Temperature: { /* '88' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_2_Count: { /* '89' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.INT: { /* '9' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTimeMsec: { /* '90' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTime10Msec: { /* '91' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTime100Msec: { /* '92' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTimeSec: { /* '93' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTimeMin: { /* '94' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_DeltaTimeHrs: { /* '95' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Percent_V16: { /* '96' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Rotation_Angle: { /* '97' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Length_m: { /* '98' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE;
                }
                case KnxDatapointType.DPT_Value_Temp: { /* '99' */
                    return model.KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE;
                }
                default: {
                    return null;
                }
            }
        }
    }

}

