/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CycServiceItemType implements Message {

  // Abstract accessors for discriminator values.

  // Constant values.
  public static final Short FUNCTIONID = 0x12;

  // Properties.
  protected final short byteLength;
  protected final short syntaxId;

  public CycServiceItemType(short byteLength, short syntaxId) {
    super();
    this.byteLength = byteLength;
    this.syntaxId = syntaxId;
  }

  public short getByteLength() {
    return byteLength;
  }

  public short getSyntaxId() {
    return syntaxId;
  }

  public short getFunctionId() {
    return FUNCTIONID;
  }

  protected abstract void serializeCycServiceItemTypeChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CycServiceItemType");

    // Const Field (functionId)
    writeConstField("functionId", FUNCTIONID, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (byteLength)
    writeSimpleField("byteLength", byteLength, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (syntaxId)
    writeSimpleField("syntaxId", syntaxId, writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeCycServiceItemTypeChild(writeBuffer);

    writeBuffer.popContext("CycServiceItemType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CycServiceItemType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (functionId)
    lengthInBits += 8;

    // Simple field (byteLength)
    lengthInBits += 8;

    // Simple field (syntaxId)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static CycServiceItemType staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static CycServiceItemType staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CycServiceItemType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short functionId =
        readConstField(
            "functionId", readUnsignedShort(readBuffer, 8), CycServiceItemType.FUNCTIONID);

    short byteLength = readSimpleField("byteLength", readUnsignedShort(readBuffer, 8));

    short syntaxId = readSimpleField("syntaxId", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CycServiceItemTypeBuilder builder = null;
    if (EvaluationHelper.equals(syntaxId, (short) 0x10)) {
      builder = CycServiceItemAnyType.staticParseCycServiceItemTypeBuilder(readBuffer);
    } else if (EvaluationHelper.equals(syntaxId, (short) 0xb0)) {
      builder = CycServiceItemDbReadType.staticParseCycServiceItemTypeBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "syntaxId="
              + syntaxId
              + "]");
    }

    readBuffer.closeContext("CycServiceItemType");
    // Create the instance
    CycServiceItemType _cycServiceItemType = builder.build(byteLength, syntaxId);
    return _cycServiceItemType;
  }

  public interface CycServiceItemTypeBuilder {
    CycServiceItemType build(short byteLength, short syntaxId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CycServiceItemType)) {
      return false;
    }
    CycServiceItemType that = (CycServiceItemType) o;
    return (getByteLength() == that.getByteLength())
        && (getSyntaxId() == that.getSyntaxId())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getByteLength(), getSyntaxId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
