/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_ExpectedSubmoduleBlockReqApi implements Message {

  // Constant values.
  public static final Long API = 0x00000000L;

  // Properties.
  protected final int slotNumber;
  protected final long moduleIdentNumber;
  protected final int moduleProperties;
  protected final List<PnIoCm_Submodule> submodules;

  public PnIoCm_ExpectedSubmoduleBlockReqApi(
      int slotNumber,
      long moduleIdentNumber,
      int moduleProperties,
      List<PnIoCm_Submodule> submodules) {
    super();
    this.slotNumber = slotNumber;
    this.moduleIdentNumber = moduleIdentNumber;
    this.moduleProperties = moduleProperties;
    this.submodules = submodules;
  }

  public int getSlotNumber() {
    return slotNumber;
  }

  public long getModuleIdentNumber() {
    return moduleIdentNumber;
  }

  public int getModuleProperties() {
    return moduleProperties;
  }

  public List<PnIoCm_Submodule> getSubmodules() {
    return submodules;
  }

  public long getApi() {
    return API;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_ExpectedSubmoduleBlockReqApi");

    // Const Field (api)
    writeConstField(
        "api",
        API,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (slotNumber)
    writeSimpleField(
        "slotNumber",
        slotNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (moduleIdentNumber)
    writeSimpleField(
        "moduleIdentNumber",
        moduleIdentNumber,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (moduleProperties)
    writeSimpleField(
        "moduleProperties",
        moduleProperties,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (numSubmodules) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numSubmodules = (int) (COUNT(getSubmodules()));
    writeImplicitField(
        "numSubmodules",
        numSubmodules,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (submodules)
    writeComplexTypeArrayField(
        "submodules", submodules, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_ExpectedSubmoduleBlockReqApi");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_ExpectedSubmoduleBlockReqApi _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (api)
    lengthInBits += 32;

    // Simple field (slotNumber)
    lengthInBits += 16;

    // Simple field (moduleIdentNumber)
    lengthInBits += 32;

    // Simple field (moduleProperties)
    lengthInBits += 16;

    // Implicit Field (numSubmodules)
    lengthInBits += 16;

    // Array field
    if (submodules != null) {
      int i = 0;
      for (PnIoCm_Submodule element : submodules) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= submodules.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnIoCm_ExpectedSubmoduleBlockReqApi staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static PnIoCm_ExpectedSubmoduleBlockReqApi staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_ExpectedSubmoduleBlockReqApi");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long api =
        readConstField(
            "api",
            readUnsignedLong(readBuffer, 32),
            PnIoCm_ExpectedSubmoduleBlockReqApi.API,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int slotNumber =
        readSimpleField(
            "slotNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long moduleIdentNumber =
        readSimpleField(
            "moduleIdentNumber",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int moduleProperties =
        readSimpleField(
            "moduleProperties",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int numSubmodules =
        readImplicitField(
            "numSubmodules",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnIoCm_Submodule> submodules =
        readCountArrayField(
            "submodules",
            new DataReaderComplexDefault<>(
                () -> PnIoCm_Submodule.staticParse(readBuffer), readBuffer),
            numSubmodules,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_ExpectedSubmoduleBlockReqApi");
    // Create the instance
    PnIoCm_ExpectedSubmoduleBlockReqApi _pnIoCm_ExpectedSubmoduleBlockReqApi;
    _pnIoCm_ExpectedSubmoduleBlockReqApi =
        new PnIoCm_ExpectedSubmoduleBlockReqApi(
            slotNumber, moduleIdentNumber, moduleProperties, submodules);
    return _pnIoCm_ExpectedSubmoduleBlockReqApi;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_ExpectedSubmoduleBlockReqApi)) {
      return false;
    }
    PnIoCm_ExpectedSubmoduleBlockReqApi that = (PnIoCm_ExpectedSubmoduleBlockReqApi) o;
    return (getSlotNumber() == that.getSlotNumber())
        && (getModuleIdentNumber() == that.getModuleIdentNumber())
        && (getModuleProperties() == that.getModuleProperties())
        && (getSubmodules() == that.getSubmodules())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getSlotNumber(), getModuleIdentNumber(), getModuleProperties(), getSubmodules());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
