/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLastTighteningResultDataRev7
    extends OpenProtocolMessageLastTighteningResultData implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 7;
  }

  // Constant values.
  public static final Integer BLOCKIDCELLID = 1;
  public static final Integer BLOCKIDCHANNELID = 2;
  public static final Integer BLOCKIDTORQUECONTROLLERNAME = 3;
  public static final Integer BLOCKIDVINNUMBER = 4;
  public static final Integer BLOCKIDJOBID = 5;
  public static final Integer BLOCKIDPARAMETERSETNUMBER = 6;
  public static final Integer BLOCKIDSTRATEGY = 7;
  public static final Integer BLOCKIDSTRATEGYOPTIONS = 8;
  public static final Integer BLOCKIDBATCHSIZE = 9;
  public static final Integer BLOCKIDBATCHCOUNTER = 10;
  public static final Integer BLOCKIDTIGHTENINGSTATUS = 11;
  public static final Integer BLOCKIDBATCHSTATUS = 12;
  public static final Integer BLOCKIDTORQUESTATUS = 13;
  public static final Integer BLOCKIDANGLESTATUS = 14;
  public static final Integer BLOCKIDRUNDOWNANGLESTATUS = 15;
  public static final Integer BLOCKIDCURRENTMONITORINGSTATUS = 16;
  public static final Integer BLOCKIDSELFTAPSTATUS = 17;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGSTATUS = 18;
  public static final Integer BLOCKIDPREVAILTORQUECOMPENSATESTATUS = 19;
  public static final Integer BLOCKIDTIGHTENINGERRORSTATUS = 20;
  public static final Integer BLOCKIDTORQUEMINLIMIT = 21;
  public static final Integer BLOCKIDTORQUEMAXLIMIT = 22;
  public static final Integer BLOCKIDTORQUEFINALTARGET = 23;
  public static final Integer BLOCKIDTORQUE = 24;
  public static final Integer BLOCKIDANGLEMIN = 25;
  public static final Integer BLOCKIDANGLEMAX = 26;
  public static final Integer BLOCKIDFINALANGLETARGET = 27;
  public static final Integer BLOCKIDANGLE = 28;
  public static final Integer BLOCKIDRUNDOWNANGLEMIN = 29;
  public static final Integer BLOCKIDRUNDOWNANGLEMAX = 30;
  public static final Integer BLOCKIDRUNDOWNANGLE = 31;
  public static final Integer BLOCKIDCURRENTMONITORINGMIN = 32;
  public static final Integer BLOCKIDCURRENTMONITORINGMAX = 33;
  public static final Integer BLOCKIDCURRENTMONITORINGVALUE = 34;
  public static final Integer BLOCKIDSELFTAPMIN = 35;
  public static final Integer BLOCKIDSELFTAPMAX = 36;
  public static final Integer BLOCKIDSELFTAPTORQUE = 37;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGMIN = 38;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGMAX = 39;
  public static final Integer BLOCKIDPREVAILTORQUE = 40;
  public static final Integer BLOCKIDTIGHTENINGID = 41;
  public static final Integer BLOCKIDJOBSEQUENCENUMBER = 42;
  public static final Integer BLOCKIDSYNCTIGHTENINGID = 43;
  public static final Integer BLOCKIDTOOLSERIALNUMBER = 44;
  public static final Integer BLOCKIDTIMESTAMP = 45;
  public static final Integer BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS = 46;
  public static final Integer BLOCKIDPARAMETERSETNAME = 47;
  public static final Integer BLOCKIDTORQUEVALUEUNIT = 48;
  public static final Integer BLOCKIDRESULTTYPE = 49;
  public static final Integer BLOCKIDIDENTIFIERRESULTPART2 = 50;
  public static final Integer BLOCKIDIDENTIFIERRESULTPART3 = 51;
  public static final Integer BLOCKIDIDENTIFIERRESULTPART4 = 52;
  public static final Integer BLOCKIDCUSTOMERTIGHTENINGERROR = 53;
  public static final Integer BLOCKIDPREVAILTORQUECOMPENSATEVALUE = 54;
  public static final Integer BLOCKIDTIGHTENINGERRORSTATUS2 = 55;
  public static final Integer BLOCKIDCOMPENSATEDANGLE = 56;
  public static final Integer BLOCKIDFINALANGLEDECIMAL = 57;

  // Properties.
  protected final long cellId;
  protected final int channelId;
  protected final String torqueControllerName;
  protected final String vinNumber;
  protected final long jobId;
  protected final int parameterSetNumber;
  protected final Strategy strategy;
  protected final long batchSize;
  protected final long batchCounter;
  protected final NokOk tighteningStatus;
  protected final BatchStatus batchStatus;
  protected final Status torqueStatus;
  protected final Status angleStatus;
  protected final Status rundownAngleStatus;
  protected final Status currentMonitoringStatus;
  protected final Status selfTapStatus;
  protected final Status prevailTorqueMonitoringStatus;
  protected final Status prevailTorqueCompensateStatus;
  protected final long torqueMinLimit;
  protected final long torqueMaxLimit;
  protected final long torqueFinalTarget;
  protected final long torque;
  protected final long angleMin;
  protected final long angleMax;
  protected final long finalAngleTarget;
  protected final long angle;
  protected final long rundownAngleMin;
  protected final long rundownAngleMax;
  protected final long rundownAngle;
  protected final int currentMonitoringMin;
  protected final int currentMonitoringMax;
  protected final int currentMonitoringValue;
  protected final long selfTapMin;
  protected final long selfTapMax;
  protected final long selfTapTorque;
  protected final long prevailTorqueMonitoringMin;
  protected final long prevailTorqueMonitoringMax;
  protected final long prevailTorque;
  protected final String tighteningId;
  protected final long jobSequenceNumber;
  protected final long syncTighteningId;
  protected final String toolSerialNumber;
  protected final String timeStamp;
  protected final String dateTimeOfLastChangeIndParameterSetSettings;
  protected final String parameterSetName;
  protected final Unit torqueValueUnit;
  protected final ResultType resultType;
  protected final String identifierResultPart2;
  protected final String identifierResultPart3;
  protected final String identifierResultPart4;
  protected final String customerTighteningError;
  protected final long prevailTorqueCompensateValue;
  protected final long compensatedAngle;
  protected final long finalAngleDecimal;

  public OpenProtocolMessageLastTighteningResultDataRev7(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      long cellId,
      int channelId,
      String torqueControllerName,
      String vinNumber,
      long jobId,
      int parameterSetNumber,
      Strategy strategy,
      long batchSize,
      long batchCounter,
      NokOk tighteningStatus,
      BatchStatus batchStatus,
      Status torqueStatus,
      Status angleStatus,
      Status rundownAngleStatus,
      Status currentMonitoringStatus,
      Status selfTapStatus,
      Status prevailTorqueMonitoringStatus,
      Status prevailTorqueCompensateStatus,
      long torqueMinLimit,
      long torqueMaxLimit,
      long torqueFinalTarget,
      long torque,
      long angleMin,
      long angleMax,
      long finalAngleTarget,
      long angle,
      long rundownAngleMin,
      long rundownAngleMax,
      long rundownAngle,
      int currentMonitoringMin,
      int currentMonitoringMax,
      int currentMonitoringValue,
      long selfTapMin,
      long selfTapMax,
      long selfTapTorque,
      long prevailTorqueMonitoringMin,
      long prevailTorqueMonitoringMax,
      long prevailTorque,
      String tighteningId,
      long jobSequenceNumber,
      long syncTighteningId,
      String toolSerialNumber,
      String timeStamp,
      String dateTimeOfLastChangeIndParameterSetSettings,
      String parameterSetName,
      Unit torqueValueUnit,
      ResultType resultType,
      String identifierResultPart2,
      String identifierResultPart3,
      String identifierResultPart4,
      String customerTighteningError,
      long prevailTorqueCompensateValue,
      long compensatedAngle,
      long finalAngleDecimal) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.cellId = cellId;
    this.channelId = channelId;
    this.torqueControllerName = torqueControllerName;
    this.vinNumber = vinNumber;
    this.jobId = jobId;
    this.parameterSetNumber = parameterSetNumber;
    this.strategy = strategy;
    this.batchSize = batchSize;
    this.batchCounter = batchCounter;
    this.tighteningStatus = tighteningStatus;
    this.batchStatus = batchStatus;
    this.torqueStatus = torqueStatus;
    this.angleStatus = angleStatus;
    this.rundownAngleStatus = rundownAngleStatus;
    this.currentMonitoringStatus = currentMonitoringStatus;
    this.selfTapStatus = selfTapStatus;
    this.prevailTorqueMonitoringStatus = prevailTorqueMonitoringStatus;
    this.prevailTorqueCompensateStatus = prevailTorqueCompensateStatus;
    this.torqueMinLimit = torqueMinLimit;
    this.torqueMaxLimit = torqueMaxLimit;
    this.torqueFinalTarget = torqueFinalTarget;
    this.torque = torque;
    this.angleMin = angleMin;
    this.angleMax = angleMax;
    this.finalAngleTarget = finalAngleTarget;
    this.angle = angle;
    this.rundownAngleMin = rundownAngleMin;
    this.rundownAngleMax = rundownAngleMax;
    this.rundownAngle = rundownAngle;
    this.currentMonitoringMin = currentMonitoringMin;
    this.currentMonitoringMax = currentMonitoringMax;
    this.currentMonitoringValue = currentMonitoringValue;
    this.selfTapMin = selfTapMin;
    this.selfTapMax = selfTapMax;
    this.selfTapTorque = selfTapTorque;
    this.prevailTorqueMonitoringMin = prevailTorqueMonitoringMin;
    this.prevailTorqueMonitoringMax = prevailTorqueMonitoringMax;
    this.prevailTorque = prevailTorque;
    this.tighteningId = tighteningId;
    this.jobSequenceNumber = jobSequenceNumber;
    this.syncTighteningId = syncTighteningId;
    this.toolSerialNumber = toolSerialNumber;
    this.timeStamp = timeStamp;
    this.dateTimeOfLastChangeIndParameterSetSettings = dateTimeOfLastChangeIndParameterSetSettings;
    this.parameterSetName = parameterSetName;
    this.torqueValueUnit = torqueValueUnit;
    this.resultType = resultType;
    this.identifierResultPart2 = identifierResultPart2;
    this.identifierResultPart3 = identifierResultPart3;
    this.identifierResultPart4 = identifierResultPart4;
    this.customerTighteningError = customerTighteningError;
    this.prevailTorqueCompensateValue = prevailTorqueCompensateValue;
    this.compensatedAngle = compensatedAngle;
    this.finalAngleDecimal = finalAngleDecimal;
  }

  public long getCellId() {
    return cellId;
  }

  public int getChannelId() {
    return channelId;
  }

  public String getTorqueControllerName() {
    return torqueControllerName;
  }

  public String getVinNumber() {
    return vinNumber;
  }

  public long getJobId() {
    return jobId;
  }

  public int getParameterSetNumber() {
    return parameterSetNumber;
  }

  public Strategy getStrategy() {
    return strategy;
  }

  public long getBatchSize() {
    return batchSize;
  }

  public long getBatchCounter() {
    return batchCounter;
  }

  public NokOk getTighteningStatus() {
    return tighteningStatus;
  }

  public BatchStatus getBatchStatus() {
    return batchStatus;
  }

  public Status getTorqueStatus() {
    return torqueStatus;
  }

  public Status getAngleStatus() {
    return angleStatus;
  }

  public Status getRundownAngleStatus() {
    return rundownAngleStatus;
  }

  public Status getCurrentMonitoringStatus() {
    return currentMonitoringStatus;
  }

  public Status getSelfTapStatus() {
    return selfTapStatus;
  }

  public Status getPrevailTorqueMonitoringStatus() {
    return prevailTorqueMonitoringStatus;
  }

  public Status getPrevailTorqueCompensateStatus() {
    return prevailTorqueCompensateStatus;
  }

  public long getTorqueMinLimit() {
    return torqueMinLimit;
  }

  public long getTorqueMaxLimit() {
    return torqueMaxLimit;
  }

  public long getTorqueFinalTarget() {
    return torqueFinalTarget;
  }

  public long getTorque() {
    return torque;
  }

  public long getAngleMin() {
    return angleMin;
  }

  public long getAngleMax() {
    return angleMax;
  }

  public long getFinalAngleTarget() {
    return finalAngleTarget;
  }

  public long getAngle() {
    return angle;
  }

  public long getRundownAngleMin() {
    return rundownAngleMin;
  }

  public long getRundownAngleMax() {
    return rundownAngleMax;
  }

  public long getRundownAngle() {
    return rundownAngle;
  }

  public int getCurrentMonitoringMin() {
    return currentMonitoringMin;
  }

  public int getCurrentMonitoringMax() {
    return currentMonitoringMax;
  }

  public int getCurrentMonitoringValue() {
    return currentMonitoringValue;
  }

  public long getSelfTapMin() {
    return selfTapMin;
  }

  public long getSelfTapMax() {
    return selfTapMax;
  }

  public long getSelfTapTorque() {
    return selfTapTorque;
  }

  public long getPrevailTorqueMonitoringMin() {
    return prevailTorqueMonitoringMin;
  }

  public long getPrevailTorqueMonitoringMax() {
    return prevailTorqueMonitoringMax;
  }

  public long getPrevailTorque() {
    return prevailTorque;
  }

  public String getTighteningId() {
    return tighteningId;
  }

  public long getJobSequenceNumber() {
    return jobSequenceNumber;
  }

  public long getSyncTighteningId() {
    return syncTighteningId;
  }

  public String getToolSerialNumber() {
    return toolSerialNumber;
  }

  public String getTimeStamp() {
    return timeStamp;
  }

  public String getDateTimeOfLastChangeIndParameterSetSettings() {
    return dateTimeOfLastChangeIndParameterSetSettings;
  }

  public String getParameterSetName() {
    return parameterSetName;
  }

  public Unit getTorqueValueUnit() {
    return torqueValueUnit;
  }

  public ResultType getResultType() {
    return resultType;
  }

  public String getIdentifierResultPart2() {
    return identifierResultPart2;
  }

  public String getIdentifierResultPart3() {
    return identifierResultPart3;
  }

  public String getIdentifierResultPart4() {
    return identifierResultPart4;
  }

  public String getCustomerTighteningError() {
    return customerTighteningError;
  }

  public long getPrevailTorqueCompensateValue() {
    return prevailTorqueCompensateValue;
  }

  public long getCompensatedAngle() {
    return compensatedAngle;
  }

  public long getFinalAngleDecimal() {
    return finalAngleDecimal;
  }

  public int getBlockIdCellId() {
    return BLOCKIDCELLID;
  }

  public int getBlockIdChannelId() {
    return BLOCKIDCHANNELID;
  }

  public int getBlockIdTorqueControllerName() {
    return BLOCKIDTORQUECONTROLLERNAME;
  }

  public int getBlockIdVinNumber() {
    return BLOCKIDVINNUMBER;
  }

  public int getBlockIdJobId() {
    return BLOCKIDJOBID;
  }

  public int getBlockIdParameterSetNumber() {
    return BLOCKIDPARAMETERSETNUMBER;
  }

  public int getBlockIdStrategy() {
    return BLOCKIDSTRATEGY;
  }

  public int getBlockIdStrategyOptions() {
    return BLOCKIDSTRATEGYOPTIONS;
  }

  public int getBlockIdBatchSize() {
    return BLOCKIDBATCHSIZE;
  }

  public int getBlockIdBatchCounter() {
    return BLOCKIDBATCHCOUNTER;
  }

  public int getBlockIdTighteningStatus() {
    return BLOCKIDTIGHTENINGSTATUS;
  }

  public int getBlockIdBatchStatus() {
    return BLOCKIDBATCHSTATUS;
  }

  public int getBlockIdTorqueStatus() {
    return BLOCKIDTORQUESTATUS;
  }

  public int getBlockIdAngleStatus() {
    return BLOCKIDANGLESTATUS;
  }

  public int getBlockIdRundownAngleStatus() {
    return BLOCKIDRUNDOWNANGLESTATUS;
  }

  public int getBlockIdCurrentMonitoringStatus() {
    return BLOCKIDCURRENTMONITORINGSTATUS;
  }

  public int getBlockIdSelfTapStatus() {
    return BLOCKIDSELFTAPSTATUS;
  }

  public int getBlockIdPrevailTorqueMonitoringStatus() {
    return BLOCKIDPREVAILTORQUEMONITORINGSTATUS;
  }

  public int getBlockIdPrevailTorqueCompensateStatus() {
    return BLOCKIDPREVAILTORQUECOMPENSATESTATUS;
  }

  public int getBlockIdTighteningErrorStatus() {
    return BLOCKIDTIGHTENINGERRORSTATUS;
  }

  public int getBlockIdTorqueMinLimit() {
    return BLOCKIDTORQUEMINLIMIT;
  }

  public int getBlockIdTorqueMaxLimit() {
    return BLOCKIDTORQUEMAXLIMIT;
  }

  public int getBlockIdTorqueFinalTarget() {
    return BLOCKIDTORQUEFINALTARGET;
  }

  public int getBlockIdTorque() {
    return BLOCKIDTORQUE;
  }

  public int getBlockIdAngleMin() {
    return BLOCKIDANGLEMIN;
  }

  public int getBlockIdAngleMax() {
    return BLOCKIDANGLEMAX;
  }

  public int getBlockIdFinalAngleTarget() {
    return BLOCKIDFINALANGLETARGET;
  }

  public int getBlockIdAngle() {
    return BLOCKIDANGLE;
  }

  public int getBlockIdRundownAngleMin() {
    return BLOCKIDRUNDOWNANGLEMIN;
  }

  public int getBlockIdRundownAngleMax() {
    return BLOCKIDRUNDOWNANGLEMAX;
  }

  public int getBlockIdRundownAngle() {
    return BLOCKIDRUNDOWNANGLE;
  }

  public int getBlockIdCurrentMonitoringMin() {
    return BLOCKIDCURRENTMONITORINGMIN;
  }

  public int getBlockIdCurrentMonitoringMax() {
    return BLOCKIDCURRENTMONITORINGMAX;
  }

  public int getBlockIdCurrentMonitoringValue() {
    return BLOCKIDCURRENTMONITORINGVALUE;
  }

  public int getBlockIdSelfTapMin() {
    return BLOCKIDSELFTAPMIN;
  }

  public int getBlockIdSelfTapMax() {
    return BLOCKIDSELFTAPMAX;
  }

  public int getBlockIdSelfTapTorque() {
    return BLOCKIDSELFTAPTORQUE;
  }

  public int getBlockIdPrevailTorqueMonitoringMin() {
    return BLOCKIDPREVAILTORQUEMONITORINGMIN;
  }

  public int getBlockIdPrevailTorqueMonitoringMax() {
    return BLOCKIDPREVAILTORQUEMONITORINGMAX;
  }

  public int getBlockIdPrevailTorque() {
    return BLOCKIDPREVAILTORQUE;
  }

  public int getBlockIdTighteningId() {
    return BLOCKIDTIGHTENINGID;
  }

  public int getBlockIdJobSequenceNumber() {
    return BLOCKIDJOBSEQUENCENUMBER;
  }

  public int getBlockIdSyncTighteningId() {
    return BLOCKIDSYNCTIGHTENINGID;
  }

  public int getBlockIdToolSerialNumber() {
    return BLOCKIDTOOLSERIALNUMBER;
  }

  public int getBlockIdTimeStamp() {
    return BLOCKIDTIMESTAMP;
  }

  public int getBlockIdDateTimeOfLastChangeInParameterSetSettings() {
    return BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS;
  }

  public int getBlockIdParameterSetName() {
    return BLOCKIDPARAMETERSETNAME;
  }

  public int getBlockIdTorqueValueUnit() {
    return BLOCKIDTORQUEVALUEUNIT;
  }

  public int getBlockIdResultType() {
    return BLOCKIDRESULTTYPE;
  }

  public int getBlockIdIdentifierResultPart2() {
    return BLOCKIDIDENTIFIERRESULTPART2;
  }

  public int getBlockIdIdentifierResultPart3() {
    return BLOCKIDIDENTIFIERRESULTPART3;
  }

  public int getBlockIdIdentifierResultPart4() {
    return BLOCKIDIDENTIFIERRESULTPART4;
  }

  public int getBlockIdCustomerTighteningError() {
    return BLOCKIDCUSTOMERTIGHTENINGERROR;
  }

  public int getBlockIdPrevailTorqueCompensateValue() {
    return BLOCKIDPREVAILTORQUECOMPENSATEVALUE;
  }

  public int getBlockIdTighteningErrorStatus2() {
    return BLOCKIDTIGHTENINGERRORSTATUS2;
  }

  public int getBlockIdCompensatedAngle() {
    return BLOCKIDCOMPENSATEDANGLE;
  }

  public int getBlockIdFinalAngleDecimal() {
    return BLOCKIDFINALANGLEDECIMAL;
  }

  @Override
  protected void serializeOpenProtocolMessageLastTighteningResultDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLastTighteningResultDataRev7");

    // Const Field (blockIdCellId)
    writeConstField(
        "blockIdCellId",
        BLOCKIDCELLID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (cellId)
    writeSimpleField(
        "cellId", cellId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdChannelId)
    writeConstField(
        "blockIdChannelId",
        BLOCKIDCHANNELID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (channelId)
    writeSimpleField(
        "channelId",
        channelId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueControllerName)
    writeConstField(
        "blockIdTorqueControllerName",
        BLOCKIDTORQUECONTROLLERNAME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueControllerName)
    writeSimpleField(
        "torqueControllerName",
        torqueControllerName,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdVinNumber)
    writeConstField(
        "blockIdVinNumber",
        BLOCKIDVINNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (vinNumber)
    writeSimpleField(
        "vinNumber", vinNumber, writeString(writeBuffer, 200), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobId)
    writeConstField(
        "blockIdJobId",
        BLOCKIDJOBID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobId)
    writeSimpleField(
        "jobId", jobId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdParameterSetNumber)
    writeConstField(
        "blockIdParameterSetNumber",
        BLOCKIDPARAMETERSETNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (parameterSetNumber)
    writeSimpleField(
        "parameterSetNumber",
        parameterSetNumber,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdStrategy)
    writeConstField(
        "blockIdStrategy",
        BLOCKIDSTRATEGY,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (strategy)
    writeSimpleEnumField(
        "strategy",
        "Strategy",
        strategy,
        new DataWriterEnumDefault<>(
            Strategy::getValue, Strategy::name, writeUnsignedInt(writeBuffer, 16)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdStrategyOptions)
    writeConstField(
        "blockIdStrategyOptions",
        BLOCKIDSTRATEGYOPTIONS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchSize)
    writeConstField(
        "blockIdBatchSize",
        BLOCKIDBATCHSIZE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchSize)
    writeSimpleField(
        "batchSize",
        batchSize,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchCounter)
    writeConstField(
        "blockIdBatchCounter",
        BLOCKIDBATCHCOUNTER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchCounter)
    writeSimpleField(
        "batchCounter",
        batchCounter,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningStatus)
    writeConstField(
        "blockIdTighteningStatus",
        BLOCKIDTIGHTENINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningStatus)
    writeSimpleEnumField(
        "tighteningStatus",
        "NokOk",
        tighteningStatus,
        new DataWriterEnumDefault<>(
            NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchStatus)
    writeConstField(
        "blockIdBatchStatus",
        BLOCKIDBATCHSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchStatus)
    writeSimpleEnumField(
        "batchStatus",
        "BatchStatus",
        batchStatus,
        new DataWriterEnumDefault<>(
            BatchStatus::getValue, BatchStatus::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueStatus)
    writeConstField(
        "blockIdTorqueStatus",
        BLOCKIDTORQUESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueStatus)
    writeSimpleEnumField(
        "torqueStatus",
        "Status",
        torqueStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleStatus)
    writeConstField(
        "blockIdAngleStatus",
        BLOCKIDANGLESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleStatus)
    writeSimpleEnumField(
        "angleStatus",
        "Status",
        angleStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleStatus)
    writeConstField(
        "blockIdRundownAngleStatus",
        BLOCKIDRUNDOWNANGLESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleStatus)
    writeSimpleEnumField(
        "rundownAngleStatus",
        "Status",
        rundownAngleStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringStatus)
    writeConstField(
        "blockIdCurrentMonitoringStatus",
        BLOCKIDCURRENTMONITORINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringStatus)
    writeSimpleEnumField(
        "currentMonitoringStatus",
        "Status",
        currentMonitoringStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapStatus)
    writeConstField(
        "blockIdSelfTapStatus",
        BLOCKIDSELFTAPSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapStatus)
    writeSimpleEnumField(
        "selfTapStatus",
        "Status",
        selfTapStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringStatus)
    writeConstField(
        "blockIdPrevailTorqueMonitoringStatus",
        BLOCKIDPREVAILTORQUEMONITORINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringStatus)
    writeSimpleEnumField(
        "prevailTorqueMonitoringStatus",
        "Status",
        prevailTorqueMonitoringStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueCompensateStatus)
    writeConstField(
        "blockIdPrevailTorqueCompensateStatus",
        BLOCKIDPREVAILTORQUECOMPENSATESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueCompensateStatus)
    writeSimpleEnumField(
        "prevailTorqueCompensateStatus",
        "Status",
        prevailTorqueCompensateStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningErrorStatus)
    writeConstField(
        "blockIdTighteningErrorStatus",
        BLOCKIDTIGHTENINGERRORSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueMinLimit)
    writeConstField(
        "blockIdTorqueMinLimit",
        BLOCKIDTORQUEMINLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMinLimit)
    writeSimpleField(
        "torqueMinLimit",
        torqueMinLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueMaxLimit)
    writeConstField(
        "blockIdTorqueMaxLimit",
        BLOCKIDTORQUEMAXLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMaxLimit)
    writeSimpleField(
        "torqueMaxLimit",
        torqueMaxLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueFinalTarget)
    writeConstField(
        "blockIdTorqueFinalTarget",
        BLOCKIDTORQUEFINALTARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueFinalTarget)
    writeSimpleField(
        "torqueFinalTarget",
        torqueFinalTarget,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorque)
    writeConstField(
        "blockIdTorque",
        BLOCKIDTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torque)
    writeSimpleField(
        "torque", torque, writeUnsignedLong(writeBuffer, 48), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMin)
    writeConstField(
        "blockIdAngleMin",
        BLOCKIDANGLEMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMin)
    writeSimpleField(
        "angleMin", angleMin, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMax)
    writeConstField(
        "blockIdAngleMax",
        BLOCKIDANGLEMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMax)
    writeSimpleField(
        "angleMax", angleMax, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdFinalAngleTarget)
    writeConstField(
        "blockIdFinalAngleTarget",
        BLOCKIDFINALANGLETARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (finalAngleTarget)
    writeSimpleField(
        "finalAngleTarget",
        finalAngleTarget,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngle)
    writeConstField(
        "blockIdAngle",
        BLOCKIDANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angle)
    writeSimpleField(
        "angle", angle, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleMin)
    writeConstField(
        "blockIdRundownAngleMin",
        BLOCKIDRUNDOWNANGLEMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleMin)
    writeSimpleField(
        "rundownAngleMin",
        rundownAngleMin,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleMax)
    writeConstField(
        "blockIdRundownAngleMax",
        BLOCKIDRUNDOWNANGLEMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleMax)
    writeSimpleField(
        "rundownAngleMax",
        rundownAngleMax,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngle)
    writeConstField(
        "blockIdRundownAngle",
        BLOCKIDRUNDOWNANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngle)
    writeSimpleField(
        "rundownAngle",
        rundownAngle,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringMin)
    writeConstField(
        "blockIdCurrentMonitoringMin",
        BLOCKIDCURRENTMONITORINGMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringMin)
    writeSimpleField(
        "currentMonitoringMin",
        currentMonitoringMin,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringMax)
    writeConstField(
        "blockIdCurrentMonitoringMax",
        BLOCKIDCURRENTMONITORINGMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringMax)
    writeSimpleField(
        "currentMonitoringMax",
        currentMonitoringMax,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringValue)
    writeConstField(
        "blockIdCurrentMonitoringValue",
        BLOCKIDCURRENTMONITORINGVALUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringValue)
    writeSimpleField(
        "currentMonitoringValue",
        currentMonitoringValue,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapMin)
    writeConstField(
        "blockIdSelfTapMin",
        BLOCKIDSELFTAPMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapMin)
    writeSimpleField(
        "selfTapMin",
        selfTapMin,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapMax)
    writeConstField(
        "blockIdSelfTapMax",
        BLOCKIDSELFTAPMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapMax)
    writeSimpleField(
        "selfTapMax",
        selfTapMax,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapTorque)
    writeConstField(
        "blockIdSelfTapTorque",
        BLOCKIDSELFTAPTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapTorque)
    writeSimpleField(
        "selfTapTorque",
        selfTapTorque,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringMin)
    writeConstField(
        "blockIdPrevailTorqueMonitoringMin",
        BLOCKIDPREVAILTORQUEMONITORINGMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringMin)
    writeSimpleField(
        "prevailTorqueMonitoringMin",
        prevailTorqueMonitoringMin,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringMax)
    writeConstField(
        "blockIdPrevailTorqueMonitoringMax",
        BLOCKIDPREVAILTORQUEMONITORINGMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringMax)
    writeSimpleField(
        "prevailTorqueMonitoringMax",
        prevailTorqueMonitoringMax,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorque)
    writeConstField(
        "blockIdPrevailTorque",
        BLOCKIDPREVAILTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorque)
    writeSimpleField(
        "prevailTorque",
        prevailTorque,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningId)
    writeConstField(
        "blockIdTighteningId",
        BLOCKIDTIGHTENINGID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningId)
    writeSimpleField(
        "tighteningId",
        tighteningId,
        writeString(writeBuffer, 80),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobSequenceNumber)
    writeConstField(
        "blockIdJobSequenceNumber",
        BLOCKIDJOBSEQUENCENUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobSequenceNumber)
    writeSimpleField(
        "jobSequenceNumber",
        jobSequenceNumber,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSyncTighteningId)
    writeConstField(
        "blockIdSyncTighteningId",
        BLOCKIDSYNCTIGHTENINGID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (syncTighteningId)
    writeSimpleField(
        "syncTighteningId",
        syncTighteningId,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdToolSerialNumber)
    writeConstField(
        "blockIdToolSerialNumber",
        BLOCKIDTOOLSERIALNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (toolSerialNumber)
    writeSimpleField(
        "toolSerialNumber",
        toolSerialNumber,
        writeString(writeBuffer, 112),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTimeStamp)
    writeConstField(
        "blockIdTimeStamp",
        BLOCKIDTIMESTAMP,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (timeStamp)
    writeSimpleField(
        "timeStamp", timeStamp, writeString(writeBuffer, 152), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdDateTimeOfLastChangeInParameterSetSettings)
    writeConstField(
        "blockIdDateTimeOfLastChangeInParameterSetSettings",
        BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (dateTimeOfLastChangeIndParameterSetSettings)
    writeSimpleField(
        "dateTimeOfLastChangeIndParameterSetSettings",
        dateTimeOfLastChangeIndParameterSetSettings,
        writeString(writeBuffer, 152),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdParameterSetName)
    writeConstField(
        "blockIdParameterSetName",
        BLOCKIDPARAMETERSETNAME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (parameterSetName)
    writeSimpleField(
        "parameterSetName",
        parameterSetName,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueValueUnit)
    writeConstField(
        "blockIdTorqueValueUnit",
        BLOCKIDTORQUEVALUEUNIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueValueUnit)
    writeSimpleEnumField(
        "torqueValueUnit",
        "Unit",
        torqueValueUnit,
        new DataWriterEnumDefault<>(Unit::getValue, Unit::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdResultType)
    writeConstField(
        "blockIdResultType",
        BLOCKIDRESULTTYPE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (resultType)
    writeSimpleEnumField(
        "resultType",
        "ResultType",
        resultType,
        new DataWriterEnumDefault<>(
            ResultType::getValue, ResultType::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdIdentifierResultPart2)
    writeConstField(
        "blockIdIdentifierResultPart2",
        BLOCKIDIDENTIFIERRESULTPART2,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (identifierResultPart2)
    writeSimpleField(
        "identifierResultPart2",
        identifierResultPart2,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdIdentifierResultPart3)
    writeConstField(
        "blockIdIdentifierResultPart3",
        BLOCKIDIDENTIFIERRESULTPART3,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (identifierResultPart3)
    writeSimpleField(
        "identifierResultPart3",
        identifierResultPart3,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdIdentifierResultPart4)
    writeConstField(
        "blockIdIdentifierResultPart4",
        BLOCKIDIDENTIFIERRESULTPART4,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (identifierResultPart4)
    writeSimpleField(
        "identifierResultPart4",
        identifierResultPart4,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCustomerTighteningError)
    writeConstField(
        "blockIdCustomerTighteningError",
        BLOCKIDCUSTOMERTIGHTENINGERROR,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (customerTighteningError)
    writeSimpleField(
        "customerTighteningError",
        customerTighteningError,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueCompensateValue)
    writeConstField(
        "blockIdPrevailTorqueCompensateValue",
        BLOCKIDPREVAILTORQUECOMPENSATEVALUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueCompensateValue)
    writeSimpleField(
        "prevailTorqueCompensateValue",
        prevailTorqueCompensateValue,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningErrorStatus2)
    writeConstField(
        "blockIdTighteningErrorStatus2",
        BLOCKIDTIGHTENINGERRORSTATUS2,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCompensatedAngle)
    writeConstField(
        "blockIdCompensatedAngle",
        BLOCKIDCOMPENSATEDANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (compensatedAngle)
    writeSimpleField(
        "compensatedAngle",
        compensatedAngle,
        writeUnsignedLong(writeBuffer, 56),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdFinalAngleDecimal)
    writeConstField(
        "blockIdFinalAngleDecimal",
        BLOCKIDFINALANGLEDECIMAL,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (finalAngleDecimal)
    writeSimpleField(
        "finalAngleDecimal",
        finalAngleDecimal,
        writeUnsignedLong(writeBuffer, 56),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLastTighteningResultDataRev7");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLastTighteningResultDataRev7 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (blockIdCellId)
    lengthInBits += 16;

    // Simple field (cellId)
    lengthInBits += 32;

    // Const Field (blockIdChannelId)
    lengthInBits += 16;

    // Simple field (channelId)
    lengthInBits += 16;

    // Const Field (blockIdTorqueControllerName)
    lengthInBits += 16;

    // Simple field (torqueControllerName)
    lengthInBits += 200;

    // Const Field (blockIdVinNumber)
    lengthInBits += 16;

    // Simple field (vinNumber)
    lengthInBits += 200;

    // Const Field (blockIdJobId)
    lengthInBits += 16;

    // Simple field (jobId)
    lengthInBits += 32;

    // Const Field (blockIdParameterSetNumber)
    lengthInBits += 16;

    // Simple field (parameterSetNumber)
    lengthInBits += 24;

    // Const Field (blockIdStrategy)
    lengthInBits += 16;

    // Simple field (strategy)
    lengthInBits += 16;

    // Const Field (blockIdStrategyOptions)
    lengthInBits += 16;

    // Const Field (blockIdBatchSize)
    lengthInBits += 16;

    // Simple field (batchSize)
    lengthInBits += 32;

    // Const Field (blockIdBatchCounter)
    lengthInBits += 16;

    // Simple field (batchCounter)
    lengthInBits += 32;

    // Const Field (blockIdTighteningStatus)
    lengthInBits += 16;

    // Simple field (tighteningStatus)
    lengthInBits += 8;

    // Const Field (blockIdBatchStatus)
    lengthInBits += 16;

    // Simple field (batchStatus)
    lengthInBits += 8;

    // Const Field (blockIdTorqueStatus)
    lengthInBits += 16;

    // Simple field (torqueStatus)
    lengthInBits += 8;

    // Const Field (blockIdAngleStatus)
    lengthInBits += 16;

    // Simple field (angleStatus)
    lengthInBits += 8;

    // Const Field (blockIdRundownAngleStatus)
    lengthInBits += 16;

    // Simple field (rundownAngleStatus)
    lengthInBits += 8;

    // Const Field (blockIdCurrentMonitoringStatus)
    lengthInBits += 16;

    // Simple field (currentMonitoringStatus)
    lengthInBits += 8;

    // Const Field (blockIdSelfTapStatus)
    lengthInBits += 16;

    // Simple field (selfTapStatus)
    lengthInBits += 8;

    // Const Field (blockIdPrevailTorqueMonitoringStatus)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringStatus)
    lengthInBits += 8;

    // Const Field (blockIdPrevailTorqueCompensateStatus)
    lengthInBits += 16;

    // Simple field (prevailTorqueCompensateStatus)
    lengthInBits += 8;

    // Const Field (blockIdTighteningErrorStatus)
    lengthInBits += 16;

    // Const Field (blockIdTorqueMinLimit)
    lengthInBits += 16;

    // Simple field (torqueMinLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueMaxLimit)
    lengthInBits += 16;

    // Simple field (torqueMaxLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueFinalTarget)
    lengthInBits += 16;

    // Simple field (torqueFinalTarget)
    lengthInBits += 48;

    // Const Field (blockIdTorque)
    lengthInBits += 16;

    // Simple field (torque)
    lengthInBits += 48;

    // Const Field (blockIdAngleMin)
    lengthInBits += 16;

    // Simple field (angleMin)
    lengthInBits += 40;

    // Const Field (blockIdAngleMax)
    lengthInBits += 16;

    // Simple field (angleMax)
    lengthInBits += 40;

    // Const Field (blockIdFinalAngleTarget)
    lengthInBits += 16;

    // Simple field (finalAngleTarget)
    lengthInBits += 40;

    // Const Field (blockIdAngle)
    lengthInBits += 16;

    // Simple field (angle)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngleMin)
    lengthInBits += 16;

    // Simple field (rundownAngleMin)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngleMax)
    lengthInBits += 16;

    // Simple field (rundownAngleMax)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngle)
    lengthInBits += 16;

    // Simple field (rundownAngle)
    lengthInBits += 40;

    // Const Field (blockIdCurrentMonitoringMin)
    lengthInBits += 16;

    // Simple field (currentMonitoringMin)
    lengthInBits += 24;

    // Const Field (blockIdCurrentMonitoringMax)
    lengthInBits += 16;

    // Simple field (currentMonitoringMax)
    lengthInBits += 24;

    // Const Field (blockIdCurrentMonitoringValue)
    lengthInBits += 16;

    // Simple field (currentMonitoringValue)
    lengthInBits += 24;

    // Const Field (blockIdSelfTapMin)
    lengthInBits += 16;

    // Simple field (selfTapMin)
    lengthInBits += 48;

    // Const Field (blockIdSelfTapMax)
    lengthInBits += 16;

    // Simple field (selfTapMax)
    lengthInBits += 48;

    // Const Field (blockIdSelfTapTorque)
    lengthInBits += 16;

    // Simple field (selfTapTorque)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorqueMonitoringMin)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringMin)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorqueMonitoringMax)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringMax)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorque)
    lengthInBits += 16;

    // Simple field (prevailTorque)
    lengthInBits += 48;

    // Const Field (blockIdTighteningId)
    lengthInBits += 16;

    // Simple field (tighteningId)
    lengthInBits += 80;

    // Const Field (blockIdJobSequenceNumber)
    lengthInBits += 16;

    // Simple field (jobSequenceNumber)
    lengthInBits += 40;

    // Const Field (blockIdSyncTighteningId)
    lengthInBits += 16;

    // Simple field (syncTighteningId)
    lengthInBits += 40;

    // Const Field (blockIdToolSerialNumber)
    lengthInBits += 16;

    // Simple field (toolSerialNumber)
    lengthInBits += 112;

    // Const Field (blockIdTimeStamp)
    lengthInBits += 16;

    // Simple field (timeStamp)
    lengthInBits += 152;

    // Const Field (blockIdDateTimeOfLastChangeInParameterSetSettings)
    lengthInBits += 16;

    // Simple field (dateTimeOfLastChangeIndParameterSetSettings)
    lengthInBits += 152;

    // Const Field (blockIdParameterSetName)
    lengthInBits += 16;

    // Simple field (parameterSetName)
    lengthInBits += 200;

    // Const Field (blockIdTorqueValueUnit)
    lengthInBits += 16;

    // Simple field (torqueValueUnit)
    lengthInBits += 8;

    // Const Field (blockIdResultType)
    lengthInBits += 16;

    // Simple field (resultType)
    lengthInBits += 8;

    // Const Field (blockIdIdentifierResultPart2)
    lengthInBits += 16;

    // Simple field (identifierResultPart2)
    lengthInBits += 200;

    // Const Field (blockIdIdentifierResultPart3)
    lengthInBits += 16;

    // Simple field (identifierResultPart3)
    lengthInBits += 200;

    // Const Field (blockIdIdentifierResultPart4)
    lengthInBits += 16;

    // Simple field (identifierResultPart4)
    lengthInBits += 200;

    // Const Field (blockIdCustomerTighteningError)
    lengthInBits += 16;

    // Simple field (customerTighteningError)
    lengthInBits += 200;

    // Const Field (blockIdPrevailTorqueCompensateValue)
    lengthInBits += 16;

    // Simple field (prevailTorqueCompensateValue)
    lengthInBits += 48;

    // Const Field (blockIdTighteningErrorStatus2)
    lengthInBits += 16;

    // Const Field (blockIdCompensatedAngle)
    lengthInBits += 16;

    // Simple field (compensatedAngle)
    lengthInBits += 56;

    // Const Field (blockIdFinalAngleDecimal)
    lengthInBits += 16;

    // Simple field (finalAngleDecimal)
    lengthInBits += 56;

    return lengthInBits;
  }

  public static OpenProtocolMessageLastTighteningResultDataBuilder
      staticParseOpenProtocolMessageLastTighteningResultDataBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLastTighteningResultDataRev7");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockIdCellId =
        readConstField(
            "blockIdCellId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCELLID,
            WithOption.WithEncoding("ASCII"));

    long cellId =
        readSimpleField(
            "cellId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdChannelId =
        readConstField(
            "blockIdChannelId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCHANNELID,
            WithOption.WithEncoding("ASCII"));

    int channelId =
        readSimpleField(
            "channelId", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueControllerName =
        readConstField(
            "blockIdTorqueControllerName",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUECONTROLLERNAME,
            WithOption.WithEncoding("ASCII"));

    String torqueControllerName =
        readSimpleField(
            "torqueControllerName", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdVinNumber =
        readConstField(
            "blockIdVinNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDVINNUMBER,
            WithOption.WithEncoding("ASCII"));

    String vinNumber =
        readSimpleField("vinNumber", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdJobId =
        readConstField(
            "blockIdJobId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDJOBID,
            WithOption.WithEncoding("ASCII"));

    long jobId =
        readSimpleField(
            "jobId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdParameterSetNumber =
        readConstField(
            "blockIdParameterSetNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPARAMETERSETNUMBER,
            WithOption.WithEncoding("ASCII"));

    int parameterSetNumber =
        readSimpleField(
            "parameterSetNumber",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdStrategy =
        readConstField(
            "blockIdStrategy",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSTRATEGY,
            WithOption.WithEncoding("ASCII"));

    Strategy strategy =
        readEnumField(
            "strategy",
            "Strategy",
            new DataReaderEnumDefault<>(Strategy::enumForValue, readUnsignedInt(readBuffer, 16)),
            WithOption.WithEncoding("ASCII"));

    int blockIdStrategyOptions =
        readConstField(
            "blockIdStrategyOptions",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSTRATEGYOPTIONS,
            WithOption.WithEncoding("ASCII"));

    int blockIdBatchSize =
        readConstField(
            "blockIdBatchSize",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDBATCHSIZE,
            WithOption.WithEncoding("ASCII"));

    long batchSize =
        readSimpleField(
            "batchSize", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdBatchCounter =
        readConstField(
            "blockIdBatchCounter",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDBATCHCOUNTER,
            WithOption.WithEncoding("ASCII"));

    long batchCounter =
        readSimpleField(
            "batchCounter", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdTighteningStatus =
        readConstField(
            "blockIdTighteningStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTIGHTENINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    NokOk tighteningStatus =
        readEnumField(
            "tighteningStatus",
            "NokOk",
            new DataReaderEnumDefault<>(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdBatchStatus =
        readConstField(
            "blockIdBatchStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDBATCHSTATUS,
            WithOption.WithEncoding("ASCII"));

    BatchStatus batchStatus =
        readEnumField(
            "batchStatus",
            "BatchStatus",
            new DataReaderEnumDefault<>(
                BatchStatus::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorqueStatus =
        readConstField(
            "blockIdTorqueStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status torqueStatus =
        readEnumField(
            "torqueStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdAngleStatus =
        readConstField(
            "blockIdAngleStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDANGLESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status angleStatus =
        readEnumField(
            "angleStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleStatus =
        readConstField(
            "blockIdRundownAngleStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDRUNDOWNANGLESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status rundownAngleStatus =
        readEnumField(
            "rundownAngleStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringStatus =
        readConstField(
            "blockIdCurrentMonitoringStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCURRENTMONITORINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status currentMonitoringStatus =
        readEnumField(
            "currentMonitoringStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapStatus =
        readConstField(
            "blockIdSelfTapStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSELFTAPSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status selfTapStatus =
        readEnumField(
            "selfTapStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringStatus =
        readConstField(
            "blockIdPrevailTorqueMonitoringStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUEMONITORINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status prevailTorqueMonitoringStatus =
        readEnumField(
            "prevailTorqueMonitoringStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueCompensateStatus =
        readConstField(
            "blockIdPrevailTorqueCompensateStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUECOMPENSATESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status prevailTorqueCompensateStatus =
        readEnumField(
            "prevailTorqueCompensateStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTighteningErrorStatus =
        readConstField(
            "blockIdTighteningErrorStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTIGHTENINGERRORSTATUS,
            WithOption.WithEncoding("ASCII"));

    int blockIdTorqueMinLimit =
        readConstField(
            "blockIdTorqueMinLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUEMINLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMinLimit =
        readSimpleField(
            "torqueMinLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueMaxLimit =
        readConstField(
            "blockIdTorqueMaxLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUEMAXLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMaxLimit =
        readSimpleField(
            "torqueMaxLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueFinalTarget =
        readConstField(
            "blockIdTorqueFinalTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUEFINALTARGET,
            WithOption.WithEncoding("ASCII"));

    long torqueFinalTarget =
        readSimpleField(
            "torqueFinalTarget",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorque =
        readConstField(
            "blockIdTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUE,
            WithOption.WithEncoding("ASCII"));

    long torque =
        readSimpleField(
            "torque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMin =
        readConstField(
            "blockIdAngleMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDANGLEMIN,
            WithOption.WithEncoding("ASCII"));

    long angleMin =
        readSimpleField(
            "angleMin", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMax =
        readConstField(
            "blockIdAngleMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDANGLEMAX,
            WithOption.WithEncoding("ASCII"));

    long angleMax =
        readSimpleField(
            "angleMax", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdFinalAngleTarget =
        readConstField(
            "blockIdFinalAngleTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDFINALANGLETARGET,
            WithOption.WithEncoding("ASCII"));

    long finalAngleTarget =
        readSimpleField(
            "finalAngleTarget", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngle =
        readConstField(
            "blockIdAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDANGLE,
            WithOption.WithEncoding("ASCII"));

    long angle =
        readSimpleField(
            "angle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleMin =
        readConstField(
            "blockIdRundownAngleMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDRUNDOWNANGLEMIN,
            WithOption.WithEncoding("ASCII"));

    long rundownAngleMin =
        readSimpleField(
            "rundownAngleMin", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleMax =
        readConstField(
            "blockIdRundownAngleMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDRUNDOWNANGLEMAX,
            WithOption.WithEncoding("ASCII"));

    long rundownAngleMax =
        readSimpleField(
            "rundownAngleMax", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngle =
        readConstField(
            "blockIdRundownAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDRUNDOWNANGLE,
            WithOption.WithEncoding("ASCII"));

    long rundownAngle =
        readSimpleField(
            "rundownAngle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringMin =
        readConstField(
            "blockIdCurrentMonitoringMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCURRENTMONITORINGMIN,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringMin =
        readSimpleField(
            "currentMonitoringMin",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringMax =
        readConstField(
            "blockIdCurrentMonitoringMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCURRENTMONITORINGMAX,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringMax =
        readSimpleField(
            "currentMonitoringMax",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringValue =
        readConstField(
            "blockIdCurrentMonitoringValue",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCURRENTMONITORINGVALUE,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringValue =
        readSimpleField(
            "currentMonitoringValue",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapMin =
        readConstField(
            "blockIdSelfTapMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSELFTAPMIN,
            WithOption.WithEncoding("ASCII"));

    long selfTapMin =
        readSimpleField(
            "selfTapMin", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapMax =
        readConstField(
            "blockIdSelfTapMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSELFTAPMAX,
            WithOption.WithEncoding("ASCII"));

    long selfTapMax =
        readSimpleField(
            "selfTapMax", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapTorque =
        readConstField(
            "blockIdSelfTapTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSELFTAPTORQUE,
            WithOption.WithEncoding("ASCII"));

    long selfTapTorque =
        readSimpleField(
            "selfTapTorque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringMin =
        readConstField(
            "blockIdPrevailTorqueMonitoringMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUEMONITORINGMIN,
            WithOption.WithEncoding("ASCII"));

    long prevailTorqueMonitoringMin =
        readSimpleField(
            "prevailTorqueMonitoringMin",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringMax =
        readConstField(
            "blockIdPrevailTorqueMonitoringMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUEMONITORINGMAX,
            WithOption.WithEncoding("ASCII"));

    long prevailTorqueMonitoringMax =
        readSimpleField(
            "prevailTorqueMonitoringMax",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorque =
        readConstField(
            "blockIdPrevailTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUE,
            WithOption.WithEncoding("ASCII"));

    long prevailTorque =
        readSimpleField(
            "prevailTorque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTighteningId =
        readConstField(
            "blockIdTighteningId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTIGHTENINGID,
            WithOption.WithEncoding("ASCII"));

    String tighteningId =
        readSimpleField(
            "tighteningId", readString(readBuffer, 80), WithOption.WithEncoding("ASCII"));

    int blockIdJobSequenceNumber =
        readConstField(
            "blockIdJobSequenceNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDJOBSEQUENCENUMBER,
            WithOption.WithEncoding("ASCII"));

    long jobSequenceNumber =
        readSimpleField(
            "jobSequenceNumber",
            readUnsignedLong(readBuffer, 40),
            WithOption.WithEncoding("ASCII"));

    int blockIdSyncTighteningId =
        readConstField(
            "blockIdSyncTighteningId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDSYNCTIGHTENINGID,
            WithOption.WithEncoding("ASCII"));

    long syncTighteningId =
        readSimpleField(
            "syncTighteningId", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdToolSerialNumber =
        readConstField(
            "blockIdToolSerialNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTOOLSERIALNUMBER,
            WithOption.WithEncoding("ASCII"));

    String toolSerialNumber =
        readSimpleField(
            "toolSerialNumber", readString(readBuffer, 112), WithOption.WithEncoding("ASCII"));

    int blockIdTimeStamp =
        readConstField(
            "blockIdTimeStamp",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTIMESTAMP,
            WithOption.WithEncoding("ASCII"));

    String timeStamp =
        readSimpleField("timeStamp", readString(readBuffer, 152), WithOption.WithEncoding("ASCII"));

    int blockIdDateTimeOfLastChangeInParameterSetSettings =
        readConstField(
            "blockIdDateTimeOfLastChangeInParameterSetSettings",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7
                .BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS,
            WithOption.WithEncoding("ASCII"));

    String dateTimeOfLastChangeIndParameterSetSettings =
        readSimpleField(
            "dateTimeOfLastChangeIndParameterSetSettings",
            readString(readBuffer, 152),
            WithOption.WithEncoding("ASCII"));

    int blockIdParameterSetName =
        readConstField(
            "blockIdParameterSetName",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPARAMETERSETNAME,
            WithOption.WithEncoding("ASCII"));

    String parameterSetName =
        readSimpleField(
            "parameterSetName", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueValueUnit =
        readConstField(
            "blockIdTorqueValueUnit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTORQUEVALUEUNIT,
            WithOption.WithEncoding("ASCII"));

    Unit torqueValueUnit =
        readEnumField(
            "torqueValueUnit",
            "Unit",
            new DataReaderEnumDefault<>(Unit::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdResultType =
        readConstField(
            "blockIdResultType",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDRESULTTYPE,
            WithOption.WithEncoding("ASCII"));

    ResultType resultType =
        readEnumField(
            "resultType",
            "ResultType",
            new DataReaderEnumDefault<>(ResultType::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdIdentifierResultPart2 =
        readConstField(
            "blockIdIdentifierResultPart2",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDIDENTIFIERRESULTPART2,
            WithOption.WithEncoding("ASCII"));

    String identifierResultPart2 =
        readSimpleField(
            "identifierResultPart2", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdIdentifierResultPart3 =
        readConstField(
            "blockIdIdentifierResultPart3",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDIDENTIFIERRESULTPART3,
            WithOption.WithEncoding("ASCII"));

    String identifierResultPart3 =
        readSimpleField(
            "identifierResultPart3", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdIdentifierResultPart4 =
        readConstField(
            "blockIdIdentifierResultPart4",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDIDENTIFIERRESULTPART4,
            WithOption.WithEncoding("ASCII"));

    String identifierResultPart4 =
        readSimpleField(
            "identifierResultPart4", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdCustomerTighteningError =
        readConstField(
            "blockIdCustomerTighteningError",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCUSTOMERTIGHTENINGERROR,
            WithOption.WithEncoding("ASCII"));

    String customerTighteningError =
        readSimpleField(
            "customerTighteningError",
            readString(readBuffer, 200),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueCompensateValue =
        readConstField(
            "blockIdPrevailTorqueCompensateValue",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDPREVAILTORQUECOMPENSATEVALUE,
            WithOption.WithEncoding("ASCII"));

    long prevailTorqueCompensateValue =
        readSimpleField(
            "prevailTorqueCompensateValue",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdTighteningErrorStatus2 =
        readConstField(
            "blockIdTighteningErrorStatus2",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDTIGHTENINGERRORSTATUS2,
            WithOption.WithEncoding("ASCII"));

    int blockIdCompensatedAngle =
        readConstField(
            "blockIdCompensatedAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDCOMPENSATEDANGLE,
            WithOption.WithEncoding("ASCII"));

    long compensatedAngle =
        readSimpleField(
            "compensatedAngle", readUnsignedLong(readBuffer, 56), WithOption.WithEncoding("ASCII"));

    int blockIdFinalAngleDecimal =
        readConstField(
            "blockIdFinalAngleDecimal",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev7.BLOCKIDFINALANGLEDECIMAL,
            WithOption.WithEncoding("ASCII"));

    long finalAngleDecimal =
        readSimpleField(
            "finalAngleDecimal",
            readUnsignedLong(readBuffer, 56),
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLastTighteningResultDataRev7");
    // Create the instance
    return new OpenProtocolMessageLastTighteningResultDataRev7BuilderImpl(
        cellId,
        channelId,
        torqueControllerName,
        vinNumber,
        jobId,
        parameterSetNumber,
        strategy,
        batchSize,
        batchCounter,
        tighteningStatus,
        batchStatus,
        torqueStatus,
        angleStatus,
        rundownAngleStatus,
        currentMonitoringStatus,
        selfTapStatus,
        prevailTorqueMonitoringStatus,
        prevailTorqueCompensateStatus,
        torqueMinLimit,
        torqueMaxLimit,
        torqueFinalTarget,
        torque,
        angleMin,
        angleMax,
        finalAngleTarget,
        angle,
        rundownAngleMin,
        rundownAngleMax,
        rundownAngle,
        currentMonitoringMin,
        currentMonitoringMax,
        currentMonitoringValue,
        selfTapMin,
        selfTapMax,
        selfTapTorque,
        prevailTorqueMonitoringMin,
        prevailTorqueMonitoringMax,
        prevailTorque,
        tighteningId,
        jobSequenceNumber,
        syncTighteningId,
        toolSerialNumber,
        timeStamp,
        dateTimeOfLastChangeIndParameterSetSettings,
        parameterSetName,
        torqueValueUnit,
        resultType,
        identifierResultPart2,
        identifierResultPart3,
        identifierResultPart4,
        customerTighteningError,
        prevailTorqueCompensateValue,
        compensatedAngle,
        finalAngleDecimal);
  }

  public static class OpenProtocolMessageLastTighteningResultDataRev7BuilderImpl
      implements OpenProtocolMessageLastTighteningResultData
          .OpenProtocolMessageLastTighteningResultDataBuilder {
    private final long cellId;
    private final int channelId;
    private final String torqueControllerName;
    private final String vinNumber;
    private final long jobId;
    private final int parameterSetNumber;
    private final Strategy strategy;
    private final long batchSize;
    private final long batchCounter;
    private final NokOk tighteningStatus;
    private final BatchStatus batchStatus;
    private final Status torqueStatus;
    private final Status angleStatus;
    private final Status rundownAngleStatus;
    private final Status currentMonitoringStatus;
    private final Status selfTapStatus;
    private final Status prevailTorqueMonitoringStatus;
    private final Status prevailTorqueCompensateStatus;
    private final long torqueMinLimit;
    private final long torqueMaxLimit;
    private final long torqueFinalTarget;
    private final long torque;
    private final long angleMin;
    private final long angleMax;
    private final long finalAngleTarget;
    private final long angle;
    private final long rundownAngleMin;
    private final long rundownAngleMax;
    private final long rundownAngle;
    private final int currentMonitoringMin;
    private final int currentMonitoringMax;
    private final int currentMonitoringValue;
    private final long selfTapMin;
    private final long selfTapMax;
    private final long selfTapTorque;
    private final long prevailTorqueMonitoringMin;
    private final long prevailTorqueMonitoringMax;
    private final long prevailTorque;
    private final String tighteningId;
    private final long jobSequenceNumber;
    private final long syncTighteningId;
    private final String toolSerialNumber;
    private final String timeStamp;
    private final String dateTimeOfLastChangeIndParameterSetSettings;
    private final String parameterSetName;
    private final Unit torqueValueUnit;
    private final ResultType resultType;
    private final String identifierResultPart2;
    private final String identifierResultPart3;
    private final String identifierResultPart4;
    private final String customerTighteningError;
    private final long prevailTorqueCompensateValue;
    private final long compensatedAngle;
    private final long finalAngleDecimal;

    public OpenProtocolMessageLastTighteningResultDataRev7BuilderImpl(
        long cellId,
        int channelId,
        String torqueControllerName,
        String vinNumber,
        long jobId,
        int parameterSetNumber,
        Strategy strategy,
        long batchSize,
        long batchCounter,
        NokOk tighteningStatus,
        BatchStatus batchStatus,
        Status torqueStatus,
        Status angleStatus,
        Status rundownAngleStatus,
        Status currentMonitoringStatus,
        Status selfTapStatus,
        Status prevailTorqueMonitoringStatus,
        Status prevailTorqueCompensateStatus,
        long torqueMinLimit,
        long torqueMaxLimit,
        long torqueFinalTarget,
        long torque,
        long angleMin,
        long angleMax,
        long finalAngleTarget,
        long angle,
        long rundownAngleMin,
        long rundownAngleMax,
        long rundownAngle,
        int currentMonitoringMin,
        int currentMonitoringMax,
        int currentMonitoringValue,
        long selfTapMin,
        long selfTapMax,
        long selfTapTorque,
        long prevailTorqueMonitoringMin,
        long prevailTorqueMonitoringMax,
        long prevailTorque,
        String tighteningId,
        long jobSequenceNumber,
        long syncTighteningId,
        String toolSerialNumber,
        String timeStamp,
        String dateTimeOfLastChangeIndParameterSetSettings,
        String parameterSetName,
        Unit torqueValueUnit,
        ResultType resultType,
        String identifierResultPart2,
        String identifierResultPart3,
        String identifierResultPart4,
        String customerTighteningError,
        long prevailTorqueCompensateValue,
        long compensatedAngle,
        long finalAngleDecimal) {
      this.cellId = cellId;
      this.channelId = channelId;
      this.torqueControllerName = torqueControllerName;
      this.vinNumber = vinNumber;
      this.jobId = jobId;
      this.parameterSetNumber = parameterSetNumber;
      this.strategy = strategy;
      this.batchSize = batchSize;
      this.batchCounter = batchCounter;
      this.tighteningStatus = tighteningStatus;
      this.batchStatus = batchStatus;
      this.torqueStatus = torqueStatus;
      this.angleStatus = angleStatus;
      this.rundownAngleStatus = rundownAngleStatus;
      this.currentMonitoringStatus = currentMonitoringStatus;
      this.selfTapStatus = selfTapStatus;
      this.prevailTorqueMonitoringStatus = prevailTorqueMonitoringStatus;
      this.prevailTorqueCompensateStatus = prevailTorqueCompensateStatus;
      this.torqueMinLimit = torqueMinLimit;
      this.torqueMaxLimit = torqueMaxLimit;
      this.torqueFinalTarget = torqueFinalTarget;
      this.torque = torque;
      this.angleMin = angleMin;
      this.angleMax = angleMax;
      this.finalAngleTarget = finalAngleTarget;
      this.angle = angle;
      this.rundownAngleMin = rundownAngleMin;
      this.rundownAngleMax = rundownAngleMax;
      this.rundownAngle = rundownAngle;
      this.currentMonitoringMin = currentMonitoringMin;
      this.currentMonitoringMax = currentMonitoringMax;
      this.currentMonitoringValue = currentMonitoringValue;
      this.selfTapMin = selfTapMin;
      this.selfTapMax = selfTapMax;
      this.selfTapTorque = selfTapTorque;
      this.prevailTorqueMonitoringMin = prevailTorqueMonitoringMin;
      this.prevailTorqueMonitoringMax = prevailTorqueMonitoringMax;
      this.prevailTorque = prevailTorque;
      this.tighteningId = tighteningId;
      this.jobSequenceNumber = jobSequenceNumber;
      this.syncTighteningId = syncTighteningId;
      this.toolSerialNumber = toolSerialNumber;
      this.timeStamp = timeStamp;
      this.dateTimeOfLastChangeIndParameterSetSettings =
          dateTimeOfLastChangeIndParameterSetSettings;
      this.parameterSetName = parameterSetName;
      this.torqueValueUnit = torqueValueUnit;
      this.resultType = resultType;
      this.identifierResultPart2 = identifierResultPart2;
      this.identifierResultPart3 = identifierResultPart3;
      this.identifierResultPart4 = identifierResultPart4;
      this.customerTighteningError = customerTighteningError;
      this.prevailTorqueCompensateValue = prevailTorqueCompensateValue;
      this.compensatedAngle = compensatedAngle;
      this.finalAngleDecimal = finalAngleDecimal;
    }

    public OpenProtocolMessageLastTighteningResultDataRev7 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLastTighteningResultDataRev7
          openProtocolMessageLastTighteningResultDataRev7 =
              new OpenProtocolMessageLastTighteningResultDataRev7(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  cellId,
                  channelId,
                  torqueControllerName,
                  vinNumber,
                  jobId,
                  parameterSetNumber,
                  strategy,
                  batchSize,
                  batchCounter,
                  tighteningStatus,
                  batchStatus,
                  torqueStatus,
                  angleStatus,
                  rundownAngleStatus,
                  currentMonitoringStatus,
                  selfTapStatus,
                  prevailTorqueMonitoringStatus,
                  prevailTorqueCompensateStatus,
                  torqueMinLimit,
                  torqueMaxLimit,
                  torqueFinalTarget,
                  torque,
                  angleMin,
                  angleMax,
                  finalAngleTarget,
                  angle,
                  rundownAngleMin,
                  rundownAngleMax,
                  rundownAngle,
                  currentMonitoringMin,
                  currentMonitoringMax,
                  currentMonitoringValue,
                  selfTapMin,
                  selfTapMax,
                  selfTapTorque,
                  prevailTorqueMonitoringMin,
                  prevailTorqueMonitoringMax,
                  prevailTorque,
                  tighteningId,
                  jobSequenceNumber,
                  syncTighteningId,
                  toolSerialNumber,
                  timeStamp,
                  dateTimeOfLastChangeIndParameterSetSettings,
                  parameterSetName,
                  torqueValueUnit,
                  resultType,
                  identifierResultPart2,
                  identifierResultPart3,
                  identifierResultPart4,
                  customerTighteningError,
                  prevailTorqueCompensateValue,
                  compensatedAngle,
                  finalAngleDecimal);
      return openProtocolMessageLastTighteningResultDataRev7;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLastTighteningResultDataRev7)) {
      return false;
    }
    OpenProtocolMessageLastTighteningResultDataRev7 that =
        (OpenProtocolMessageLastTighteningResultDataRev7) o;
    return (getCellId() == that.getCellId())
        && (getChannelId() == that.getChannelId())
        && (getTorqueControllerName() == that.getTorqueControllerName())
        && (getVinNumber() == that.getVinNumber())
        && (getJobId() == that.getJobId())
        && (getParameterSetNumber() == that.getParameterSetNumber())
        && (getStrategy() == that.getStrategy())
        && (getBatchSize() == that.getBatchSize())
        && (getBatchCounter() == that.getBatchCounter())
        && (getTighteningStatus() == that.getTighteningStatus())
        && (getBatchStatus() == that.getBatchStatus())
        && (getTorqueStatus() == that.getTorqueStatus())
        && (getAngleStatus() == that.getAngleStatus())
        && (getRundownAngleStatus() == that.getRundownAngleStatus())
        && (getCurrentMonitoringStatus() == that.getCurrentMonitoringStatus())
        && (getSelfTapStatus() == that.getSelfTapStatus())
        && (getPrevailTorqueMonitoringStatus() == that.getPrevailTorqueMonitoringStatus())
        && (getPrevailTorqueCompensateStatus() == that.getPrevailTorqueCompensateStatus())
        && (getTorqueMinLimit() == that.getTorqueMinLimit())
        && (getTorqueMaxLimit() == that.getTorqueMaxLimit())
        && (getTorqueFinalTarget() == that.getTorqueFinalTarget())
        && (getTorque() == that.getTorque())
        && (getAngleMin() == that.getAngleMin())
        && (getAngleMax() == that.getAngleMax())
        && (getFinalAngleTarget() == that.getFinalAngleTarget())
        && (getAngle() == that.getAngle())
        && (getRundownAngleMin() == that.getRundownAngleMin())
        && (getRundownAngleMax() == that.getRundownAngleMax())
        && (getRundownAngle() == that.getRundownAngle())
        && (getCurrentMonitoringMin() == that.getCurrentMonitoringMin())
        && (getCurrentMonitoringMax() == that.getCurrentMonitoringMax())
        && (getCurrentMonitoringValue() == that.getCurrentMonitoringValue())
        && (getSelfTapMin() == that.getSelfTapMin())
        && (getSelfTapMax() == that.getSelfTapMax())
        && (getSelfTapTorque() == that.getSelfTapTorque())
        && (getPrevailTorqueMonitoringMin() == that.getPrevailTorqueMonitoringMin())
        && (getPrevailTorqueMonitoringMax() == that.getPrevailTorqueMonitoringMax())
        && (getPrevailTorque() == that.getPrevailTorque())
        && (getTighteningId() == that.getTighteningId())
        && (getJobSequenceNumber() == that.getJobSequenceNumber())
        && (getSyncTighteningId() == that.getSyncTighteningId())
        && (getToolSerialNumber() == that.getToolSerialNumber())
        && (getTimeStamp() == that.getTimeStamp())
        && (getDateTimeOfLastChangeIndParameterSetSettings()
            == that.getDateTimeOfLastChangeIndParameterSetSettings())
        && (getParameterSetName() == that.getParameterSetName())
        && (getTorqueValueUnit() == that.getTorqueValueUnit())
        && (getResultType() == that.getResultType())
        && (getIdentifierResultPart2() == that.getIdentifierResultPart2())
        && (getIdentifierResultPart3() == that.getIdentifierResultPart3())
        && (getIdentifierResultPart4() == that.getIdentifierResultPart4())
        && (getCustomerTighteningError() == that.getCustomerTighteningError())
        && (getPrevailTorqueCompensateValue() == that.getPrevailTorqueCompensateValue())
        && (getCompensatedAngle() == that.getCompensatedAngle())
        && (getFinalAngleDecimal() == that.getFinalAngleDecimal())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getCellId(),
        getChannelId(),
        getTorqueControllerName(),
        getVinNumber(),
        getJobId(),
        getParameterSetNumber(),
        getStrategy(),
        getBatchSize(),
        getBatchCounter(),
        getTighteningStatus(),
        getBatchStatus(),
        getTorqueStatus(),
        getAngleStatus(),
        getRundownAngleStatus(),
        getCurrentMonitoringStatus(),
        getSelfTapStatus(),
        getPrevailTorqueMonitoringStatus(),
        getPrevailTorqueCompensateStatus(),
        getTorqueMinLimit(),
        getTorqueMaxLimit(),
        getTorqueFinalTarget(),
        getTorque(),
        getAngleMin(),
        getAngleMax(),
        getFinalAngleTarget(),
        getAngle(),
        getRundownAngleMin(),
        getRundownAngleMax(),
        getRundownAngle(),
        getCurrentMonitoringMin(),
        getCurrentMonitoringMax(),
        getCurrentMonitoringValue(),
        getSelfTapMin(),
        getSelfTapMax(),
        getSelfTapTorque(),
        getPrevailTorqueMonitoringMin(),
        getPrevailTorqueMonitoringMax(),
        getPrevailTorque(),
        getTighteningId(),
        getJobSequenceNumber(),
        getSyncTighteningId(),
        getToolSerialNumber(),
        getTimeStamp(),
        getDateTimeOfLastChangeIndParameterSetSettings(),
        getParameterSetName(),
        getTorqueValueUnit(),
        getResultType(),
        getIdentifierResultPart2(),
        getIdentifierResultPart3(),
        getIdentifierResultPart4(),
        getCustomerTighteningError(),
        getPrevailTorqueCompensateValue(),
        getCompensatedAngle(),
        getFinalAngleDecimal());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
