/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLastTighteningResultDataRev2
    extends OpenProtocolMessageLastTighteningResultData implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 2;
  }

  // Constant values.
  public static final Integer BLOCKIDCELLID = 1;
  public static final Integer BLOCKIDCHANNELID = 2;
  public static final Integer BLOCKIDTORQUECONTROLLERNAME = 3;
  public static final Integer BLOCKIDVINNUMBER = 4;
  public static final Integer BLOCKIDJOBID = 5;
  public static final Integer BLOCKIDPARAMETERSETNUMBER = 6;
  public static final Integer BLOCKIDSTRATEGY = 7;
  public static final Integer BLOCKIDSTRATEGYOPTIONS = 8;
  public static final Integer BLOCKIDBATCHSIZE = 9;
  public static final Integer BLOCKIDBATCHCOUNTER = 10;
  public static final Integer BLOCKIDTIGHTENINGSTATUS = 11;
  public static final Integer BLOCKIDBATCHSTATUS = 12;
  public static final Integer BLOCKIDTORQUESTATUS = 13;
  public static final Integer BLOCKIDANGLESTATUS = 14;
  public static final Integer BLOCKIDRUNDOWNANGLESTATUS = 15;
  public static final Integer BLOCKIDCURRENTMONITORINGSTATUS = 16;
  public static final Integer BLOCKIDSELFTAPSTATUS = 17;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGSTATUS = 18;
  public static final Integer BLOCKIDPREVAILTORQUECOMPENSATESTATUS = 19;
  public static final Integer BLOCKIDTIGHTENINGERRORSTATUS = 20;
  public static final Integer BLOCKIDTORQUEMINLIMIT = 21;
  public static final Integer BLOCKIDTORQUEMAXLIMIT = 22;
  public static final Integer BLOCKIDTORQUEFINALTARGET = 23;
  public static final Integer BLOCKIDTORQUE = 24;
  public static final Integer BLOCKIDANGLEMIN = 25;
  public static final Integer BLOCKIDANGLEMAX = 26;
  public static final Integer BLOCKIDFINALANGLETARGET = 27;
  public static final Integer BLOCKIDANGLE = 28;
  public static final Integer BLOCKIDRUNDOWNANGLEMIN = 29;
  public static final Integer BLOCKIDRUNDOWNANGLEMAX = 30;
  public static final Integer BLOCKIDRUNDOWNANGLE = 31;
  public static final Integer BLOCKIDCURRENTMONITORINGMIN = 32;
  public static final Integer BLOCKIDCURRENTMONITORINGMAX = 33;
  public static final Integer BLOCKIDCURRENTMONITORINGVALUE = 34;
  public static final Integer BLOCKIDSELFTAPMIN = 35;
  public static final Integer BLOCKIDSELFTAPMAX = 36;
  public static final Integer BLOCKIDSELFTAPTORQUE = 37;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGMIN = 38;
  public static final Integer BLOCKIDPREVAILTORQUEMONITORINGMAX = 39;
  public static final Integer BLOCKIDPREVAILTORQUE = 40;
  public static final Integer BLOCKIDTIGHTENINGID = 41;
  public static final Integer BLOCKIDJOBSEQUENCENUMBER = 42;
  public static final Integer BLOCKIDSYNCTIGHTENINGID = 43;
  public static final Integer BLOCKIDTOOLSERIALNUMBER = 44;
  public static final Integer BLOCKIDTIMESTAMP = 45;
  public static final Integer BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS = 46;

  // Properties.
  protected final long cellId;
  protected final int channelId;
  protected final String torqueControllerName;
  protected final String vinNumber;
  protected final long jobId;
  protected final int parameterSetNumber;
  protected final Strategy strategy;
  protected final long strategyOptions;
  protected final long batchSize;
  protected final long batchCounter;
  protected final NokOk tighteningStatus;
  protected final BatchStatus batchStatus;
  protected final Status torqueStatus;
  protected final Status angleStatus;
  protected final Status rundownAngleStatus;
  protected final Status currentMonitoringStatus;
  protected final Status selfTapStatus;
  protected final Status prevailTorqueMonitoringStatus;
  protected final Status prevailTorqueCompensateStatus;
  protected final String tighteningErrorStatus;
  protected final long torqueMinLimit;
  protected final long torqueMaxLimit;
  protected final long torqueFinalTarget;
  protected final long torque;
  protected final long angleMin;
  protected final long angleMax;
  protected final long finalAngleTarget;
  protected final long angle;
  protected final long rundownAngleMin;
  protected final long rundownAngleMax;
  protected final long rundownAngle;
  protected final int currentMonitoringMin;
  protected final int currentMonitoringMax;
  protected final int currentMonitoringValue;
  protected final long selfTapMin;
  protected final long selfTapMax;
  protected final long selfTapTorque;
  protected final long prevailTorqueMonitoringMin;
  protected final long prevailTorqueMonitoringMax;
  protected final long prevailTorque;
  protected final String tighteningId;
  protected final long jobSequenceNumber;
  protected final long syncTighteningId;
  protected final String toolSerialNumber;
  protected final String timeStamp;
  protected final String dateTimeOfLastChangeIndParameterSetSettings;

  public OpenProtocolMessageLastTighteningResultDataRev2(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      long cellId,
      int channelId,
      String torqueControllerName,
      String vinNumber,
      long jobId,
      int parameterSetNumber,
      Strategy strategy,
      long strategyOptions,
      long batchSize,
      long batchCounter,
      NokOk tighteningStatus,
      BatchStatus batchStatus,
      Status torqueStatus,
      Status angleStatus,
      Status rundownAngleStatus,
      Status currentMonitoringStatus,
      Status selfTapStatus,
      Status prevailTorqueMonitoringStatus,
      Status prevailTorqueCompensateStatus,
      String tighteningErrorStatus,
      long torqueMinLimit,
      long torqueMaxLimit,
      long torqueFinalTarget,
      long torque,
      long angleMin,
      long angleMax,
      long finalAngleTarget,
      long angle,
      long rundownAngleMin,
      long rundownAngleMax,
      long rundownAngle,
      int currentMonitoringMin,
      int currentMonitoringMax,
      int currentMonitoringValue,
      long selfTapMin,
      long selfTapMax,
      long selfTapTorque,
      long prevailTorqueMonitoringMin,
      long prevailTorqueMonitoringMax,
      long prevailTorque,
      String tighteningId,
      long jobSequenceNumber,
      long syncTighteningId,
      String toolSerialNumber,
      String timeStamp,
      String dateTimeOfLastChangeIndParameterSetSettings) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.cellId = cellId;
    this.channelId = channelId;
    this.torqueControllerName = torqueControllerName;
    this.vinNumber = vinNumber;
    this.jobId = jobId;
    this.parameterSetNumber = parameterSetNumber;
    this.strategy = strategy;
    this.strategyOptions = strategyOptions;
    this.batchSize = batchSize;
    this.batchCounter = batchCounter;
    this.tighteningStatus = tighteningStatus;
    this.batchStatus = batchStatus;
    this.torqueStatus = torqueStatus;
    this.angleStatus = angleStatus;
    this.rundownAngleStatus = rundownAngleStatus;
    this.currentMonitoringStatus = currentMonitoringStatus;
    this.selfTapStatus = selfTapStatus;
    this.prevailTorqueMonitoringStatus = prevailTorqueMonitoringStatus;
    this.prevailTorqueCompensateStatus = prevailTorqueCompensateStatus;
    this.tighteningErrorStatus = tighteningErrorStatus;
    this.torqueMinLimit = torqueMinLimit;
    this.torqueMaxLimit = torqueMaxLimit;
    this.torqueFinalTarget = torqueFinalTarget;
    this.torque = torque;
    this.angleMin = angleMin;
    this.angleMax = angleMax;
    this.finalAngleTarget = finalAngleTarget;
    this.angle = angle;
    this.rundownAngleMin = rundownAngleMin;
    this.rundownAngleMax = rundownAngleMax;
    this.rundownAngle = rundownAngle;
    this.currentMonitoringMin = currentMonitoringMin;
    this.currentMonitoringMax = currentMonitoringMax;
    this.currentMonitoringValue = currentMonitoringValue;
    this.selfTapMin = selfTapMin;
    this.selfTapMax = selfTapMax;
    this.selfTapTorque = selfTapTorque;
    this.prevailTorqueMonitoringMin = prevailTorqueMonitoringMin;
    this.prevailTorqueMonitoringMax = prevailTorqueMonitoringMax;
    this.prevailTorque = prevailTorque;
    this.tighteningId = tighteningId;
    this.jobSequenceNumber = jobSequenceNumber;
    this.syncTighteningId = syncTighteningId;
    this.toolSerialNumber = toolSerialNumber;
    this.timeStamp = timeStamp;
    this.dateTimeOfLastChangeIndParameterSetSettings = dateTimeOfLastChangeIndParameterSetSettings;
  }

  public long getCellId() {
    return cellId;
  }

  public int getChannelId() {
    return channelId;
  }

  public String getTorqueControllerName() {
    return torqueControllerName;
  }

  public String getVinNumber() {
    return vinNumber;
  }

  public long getJobId() {
    return jobId;
  }

  public int getParameterSetNumber() {
    return parameterSetNumber;
  }

  public Strategy getStrategy() {
    return strategy;
  }

  public long getStrategyOptions() {
    return strategyOptions;
  }

  public long getBatchSize() {
    return batchSize;
  }

  public long getBatchCounter() {
    return batchCounter;
  }

  public NokOk getTighteningStatus() {
    return tighteningStatus;
  }

  public BatchStatus getBatchStatus() {
    return batchStatus;
  }

  public Status getTorqueStatus() {
    return torqueStatus;
  }

  public Status getAngleStatus() {
    return angleStatus;
  }

  public Status getRundownAngleStatus() {
    return rundownAngleStatus;
  }

  public Status getCurrentMonitoringStatus() {
    return currentMonitoringStatus;
  }

  public Status getSelfTapStatus() {
    return selfTapStatus;
  }

  public Status getPrevailTorqueMonitoringStatus() {
    return prevailTorqueMonitoringStatus;
  }

  public Status getPrevailTorqueCompensateStatus() {
    return prevailTorqueCompensateStatus;
  }

  public String getTighteningErrorStatus() {
    return tighteningErrorStatus;
  }

  public long getTorqueMinLimit() {
    return torqueMinLimit;
  }

  public long getTorqueMaxLimit() {
    return torqueMaxLimit;
  }

  public long getTorqueFinalTarget() {
    return torqueFinalTarget;
  }

  public long getTorque() {
    return torque;
  }

  public long getAngleMin() {
    return angleMin;
  }

  public long getAngleMax() {
    return angleMax;
  }

  public long getFinalAngleTarget() {
    return finalAngleTarget;
  }

  public long getAngle() {
    return angle;
  }

  public long getRundownAngleMin() {
    return rundownAngleMin;
  }

  public long getRundownAngleMax() {
    return rundownAngleMax;
  }

  public long getRundownAngle() {
    return rundownAngle;
  }

  public int getCurrentMonitoringMin() {
    return currentMonitoringMin;
  }

  public int getCurrentMonitoringMax() {
    return currentMonitoringMax;
  }

  public int getCurrentMonitoringValue() {
    return currentMonitoringValue;
  }

  public long getSelfTapMin() {
    return selfTapMin;
  }

  public long getSelfTapMax() {
    return selfTapMax;
  }

  public long getSelfTapTorque() {
    return selfTapTorque;
  }

  public long getPrevailTorqueMonitoringMin() {
    return prevailTorqueMonitoringMin;
  }

  public long getPrevailTorqueMonitoringMax() {
    return prevailTorqueMonitoringMax;
  }

  public long getPrevailTorque() {
    return prevailTorque;
  }

  public String getTighteningId() {
    return tighteningId;
  }

  public long getJobSequenceNumber() {
    return jobSequenceNumber;
  }

  public long getSyncTighteningId() {
    return syncTighteningId;
  }

  public String getToolSerialNumber() {
    return toolSerialNumber;
  }

  public String getTimeStamp() {
    return timeStamp;
  }

  public String getDateTimeOfLastChangeIndParameterSetSettings() {
    return dateTimeOfLastChangeIndParameterSetSettings;
  }

  public boolean getStrategyOptionRbwMonitoring() {
    return (boolean) ((((getStrategyOptions()) & (0x0001))) == (0x0001));
  }

  public boolean getStrategyOptionClickWrench() {
    return (boolean) ((((getStrategyOptions()) & (0x0002))) == (0x0002));
  }

  public boolean getStrategyOptionDsControl() {
    return (boolean) ((((getStrategyOptions()) & (0x0004))) == (0x0004));
  }

  public boolean getStrategyOptionCm() {
    return (boolean) ((((getStrategyOptions()) & (0x0008))) == (0x0008));
  }

  public boolean getStrategyOptionRundown() {
    return (boolean) ((((getStrategyOptions()) & (0x0010))) == (0x0010));
  }

  public boolean getStrategyOptionSelfTap() {
    return (boolean) ((((getStrategyOptions()) & (0x0020))) == (0x0020));
  }

  public boolean getStrategyOptionPvtCompensate() {
    return (boolean) ((((getStrategyOptions()) & (0x0040))) == (0x0040));
  }

  public boolean getStrategyOptionPvtMonitoring() {
    return (boolean) ((((getStrategyOptions()) & (0x0080))) == (0x0080));
  }

  public boolean getStrategyOptionBatch() {
    return (boolean) ((((getStrategyOptions()) & (0x0100))) == (0x0100));
  }

  public boolean getStrategyOptionAngle() {
    return (boolean) ((((getStrategyOptions()) & (0x0200))) == (0x0200));
  }

  public boolean getStrategyOptionTorque() {
    return (boolean) ((((getStrategyOptions()) & (0x0400))) == (0x0400));
  }

  public boolean getTighteningErrorStatusRundownAngleMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 1));
  }

  public boolean getTighteningErrorStatusRundownAngleMinShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 2));
  }

  public boolean getTighteningErrorStatusTorqueMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 3));
  }

  public boolean getTighteningErrorStatusAngleMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 4));
  }

  public boolean getTighteningErrorStatusSelfTapTorqueMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 5));
  }

  public boolean getTighteningErrorStatusSelfTapTorqueMinShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 6));
  }

  public boolean getTighteningErrorStatusPrevailTorqueMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 7));
  }

  public boolean getTighteningErrorStatusPrevailTorqueMinShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 8));
  }

  public boolean getTighteningErrorStatusPrevailTorqueCompensateOverflow() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 9));
  }

  public boolean getTighteningErrorStatusCurrentMonitoringMaxShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 10));
  }

  public boolean getTighteningErrorStatusPostViewTorqueMinTorqueShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 11));
  }

  public boolean getTighteningErrorStatusPostViewTorqueMaxTorqueShutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 12));
  }

  public boolean getTighteningErrorStatusPortViewTorqueAngleTooSmall() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 13));
  }

  public boolean getTighteningErrorStatusTriggerLost() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 14));
  }

  public boolean getTighteningErrorStatusTorqueLessThanTarget() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 15));
  }

  public boolean getTighteningErrorStatusToolHot() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 16));
  }

  public boolean getTighteningErrorStatusMultistageAbort() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 17));
  }

  public boolean getTighteningErrorStatusRehit() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 18));
  }

  public boolean getTighteningErrorStatusDsMeasureFailed() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 19));
  }

  public boolean getTighteningErrorStatusCurrentLimitReached() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 20));
  }

  public boolean getTighteningErrorStatusEndTimeOutShutoff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 21));
  }

  public boolean getTighteningErrorStatusRemoveFastenerLimitExceeded() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 22));
  }

  public boolean getTighteningErrorStatusDisableDrive() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 23));
  }

  public boolean getTighteningErrorStatusTransducerLost() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 24));
  }

  public boolean getTighteningErrorStatusTransducerShorted() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 25));
  }

  public boolean getTighteningErrorStatusTransducerCorrupt() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 26));
  }

  public boolean getTighteningErrorStatusSyncTimeout() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 27));
  }

  public boolean getTighteningErrorStatusDynamicCurrentMonitoringMin() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 28));
  }

  public boolean getTighteningErrorStatusDynamicCurrentMonitoringMax() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 29));
  }

  public boolean getTighteningErrorStatusAngleMaxMonitor() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 30));
  }

  public boolean getTighteningErrorStatusYieldNutOff() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 31));
  }

  public boolean getTighteningErrorStatusYieldTooFewSamples() {
    return (boolean)
        (org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
            getTighteningErrorStatus(), 32));
  }

  public int getBlockIdCellId() {
    return BLOCKIDCELLID;
  }

  public int getBlockIdChannelId() {
    return BLOCKIDCHANNELID;
  }

  public int getBlockIdTorqueControllerName() {
    return BLOCKIDTORQUECONTROLLERNAME;
  }

  public int getBlockIdVinNumber() {
    return BLOCKIDVINNUMBER;
  }

  public int getBlockIdJobId() {
    return BLOCKIDJOBID;
  }

  public int getBlockIdParameterSetNumber() {
    return BLOCKIDPARAMETERSETNUMBER;
  }

  public int getBlockIdStrategy() {
    return BLOCKIDSTRATEGY;
  }

  public int getBlockIdStrategyOptions() {
    return BLOCKIDSTRATEGYOPTIONS;
  }

  public int getBlockIdBatchSize() {
    return BLOCKIDBATCHSIZE;
  }

  public int getBlockIdBatchCounter() {
    return BLOCKIDBATCHCOUNTER;
  }

  public int getBlockIdTighteningStatus() {
    return BLOCKIDTIGHTENINGSTATUS;
  }

  public int getBlockIdBatchStatus() {
    return BLOCKIDBATCHSTATUS;
  }

  public int getBlockIdTorqueStatus() {
    return BLOCKIDTORQUESTATUS;
  }

  public int getBlockIdAngleStatus() {
    return BLOCKIDANGLESTATUS;
  }

  public int getBlockIdRundownAngleStatus() {
    return BLOCKIDRUNDOWNANGLESTATUS;
  }

  public int getBlockIdCurrentMonitoringStatus() {
    return BLOCKIDCURRENTMONITORINGSTATUS;
  }

  public int getBlockIdSelfTapStatus() {
    return BLOCKIDSELFTAPSTATUS;
  }

  public int getBlockIdPrevailTorqueMonitoringStatus() {
    return BLOCKIDPREVAILTORQUEMONITORINGSTATUS;
  }

  public int getBlockIdPrevailTorqueCompensateStatus() {
    return BLOCKIDPREVAILTORQUECOMPENSATESTATUS;
  }

  public int getBlockIdTighteningErrorStatus() {
    return BLOCKIDTIGHTENINGERRORSTATUS;
  }

  public int getBlockIdTorqueMinLimit() {
    return BLOCKIDTORQUEMINLIMIT;
  }

  public int getBlockIdTorqueMaxLimit() {
    return BLOCKIDTORQUEMAXLIMIT;
  }

  public int getBlockIdTorqueFinalTarget() {
    return BLOCKIDTORQUEFINALTARGET;
  }

  public int getBlockIdTorque() {
    return BLOCKIDTORQUE;
  }

  public int getBlockIdAngleMin() {
    return BLOCKIDANGLEMIN;
  }

  public int getBlockIdAngleMax() {
    return BLOCKIDANGLEMAX;
  }

  public int getBlockIdFinalAngleTarget() {
    return BLOCKIDFINALANGLETARGET;
  }

  public int getBlockIdAngle() {
    return BLOCKIDANGLE;
  }

  public int getBlockIdRundownAngleMin() {
    return BLOCKIDRUNDOWNANGLEMIN;
  }

  public int getBlockIdRundownAngleMax() {
    return BLOCKIDRUNDOWNANGLEMAX;
  }

  public int getBlockIdRundownAngle() {
    return BLOCKIDRUNDOWNANGLE;
  }

  public int getBlockIdCurrentMonitoringMin() {
    return BLOCKIDCURRENTMONITORINGMIN;
  }

  public int getBlockIdCurrentMonitoringMax() {
    return BLOCKIDCURRENTMONITORINGMAX;
  }

  public int getBlockIdCurrentMonitoringValue() {
    return BLOCKIDCURRENTMONITORINGVALUE;
  }

  public int getBlockIdSelfTapMin() {
    return BLOCKIDSELFTAPMIN;
  }

  public int getBlockIdSelfTapMax() {
    return BLOCKIDSELFTAPMAX;
  }

  public int getBlockIdSelfTapTorque() {
    return BLOCKIDSELFTAPTORQUE;
  }

  public int getBlockIdPrevailTorqueMonitoringMin() {
    return BLOCKIDPREVAILTORQUEMONITORINGMIN;
  }

  public int getBlockIdPrevailTorqueMonitoringMax() {
    return BLOCKIDPREVAILTORQUEMONITORINGMAX;
  }

  public int getBlockIdPrevailTorque() {
    return BLOCKIDPREVAILTORQUE;
  }

  public int getBlockIdTighteningId() {
    return BLOCKIDTIGHTENINGID;
  }

  public int getBlockIdJobSequenceNumber() {
    return BLOCKIDJOBSEQUENCENUMBER;
  }

  public int getBlockIdSyncTighteningId() {
    return BLOCKIDSYNCTIGHTENINGID;
  }

  public int getBlockIdToolSerialNumber() {
    return BLOCKIDTOOLSERIALNUMBER;
  }

  public int getBlockIdTimeStamp() {
    return BLOCKIDTIMESTAMP;
  }

  public int getBlockIdDateTimeOfLastChangeInParameterSetSettings() {
    return BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS;
  }

  @Override
  protected void serializeOpenProtocolMessageLastTighteningResultDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLastTighteningResultDataRev2");

    // Const Field (blockIdCellId)
    writeConstField(
        "blockIdCellId",
        BLOCKIDCELLID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (cellId)
    writeSimpleField(
        "cellId", cellId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdChannelId)
    writeConstField(
        "blockIdChannelId",
        BLOCKIDCHANNELID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (channelId)
    writeSimpleField(
        "channelId",
        channelId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueControllerName)
    writeConstField(
        "blockIdTorqueControllerName",
        BLOCKIDTORQUECONTROLLERNAME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueControllerName)
    writeSimpleField(
        "torqueControllerName",
        torqueControllerName,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdVinNumber)
    writeConstField(
        "blockIdVinNumber",
        BLOCKIDVINNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (vinNumber)
    writeSimpleField(
        "vinNumber", vinNumber, writeString(writeBuffer, 200), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobId)
    writeConstField(
        "blockIdJobId",
        BLOCKIDJOBID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobId)
    writeSimpleField(
        "jobId", jobId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdParameterSetNumber)
    writeConstField(
        "blockIdParameterSetNumber",
        BLOCKIDPARAMETERSETNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (parameterSetNumber)
    writeSimpleField(
        "parameterSetNumber",
        parameterSetNumber,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdStrategy)
    writeConstField(
        "blockIdStrategy",
        BLOCKIDSTRATEGY,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (strategy)
    writeSimpleEnumField(
        "strategy",
        "Strategy",
        strategy,
        new DataWriterEnumDefault<>(
            Strategy::getValue, Strategy::name, writeUnsignedInt(writeBuffer, 16)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdStrategyOptions)
    writeConstField(
        "blockIdStrategyOptions",
        BLOCKIDSTRATEGYOPTIONS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x30, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (strategyOptions)
    writeSimpleField(
        "strategyOptions",
        strategyOptions,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionRbwMonitoring = getStrategyOptionRbwMonitoring();
    writeBuffer.writeVirtual("strategyOptionRbwMonitoring", strategyOptionRbwMonitoring);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionClickWrench = getStrategyOptionClickWrench();
    writeBuffer.writeVirtual("strategyOptionClickWrench", strategyOptionClickWrench);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionDsControl = getStrategyOptionDsControl();
    writeBuffer.writeVirtual("strategyOptionDsControl", strategyOptionDsControl);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionCm = getStrategyOptionCm();
    writeBuffer.writeVirtual("strategyOptionCm", strategyOptionCm);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionRundown = getStrategyOptionRundown();
    writeBuffer.writeVirtual("strategyOptionRundown", strategyOptionRundown);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionSelfTap = getStrategyOptionSelfTap();
    writeBuffer.writeVirtual("strategyOptionSelfTap", strategyOptionSelfTap);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionPvtCompensate = getStrategyOptionPvtCompensate();
    writeBuffer.writeVirtual("strategyOptionPvtCompensate", strategyOptionPvtCompensate);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionPvtMonitoring = getStrategyOptionPvtMonitoring();
    writeBuffer.writeVirtual("strategyOptionPvtMonitoring", strategyOptionPvtMonitoring);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionBatch = getStrategyOptionBatch();
    writeBuffer.writeVirtual("strategyOptionBatch", strategyOptionBatch);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionAngle = getStrategyOptionAngle();
    writeBuffer.writeVirtual("strategyOptionAngle", strategyOptionAngle);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean strategyOptionTorque = getStrategyOptionTorque();
    writeBuffer.writeVirtual("strategyOptionTorque", strategyOptionTorque);

    // Const Field (blockIdBatchSize)
    writeConstField(
        "blockIdBatchSize",
        BLOCKIDBATCHSIZE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchSize)
    writeSimpleField(
        "batchSize",
        batchSize,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchCounter)
    writeConstField(
        "blockIdBatchCounter",
        BLOCKIDBATCHCOUNTER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchCounter)
    writeSimpleField(
        "batchCounter",
        batchCounter,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningStatus)
    writeConstField(
        "blockIdTighteningStatus",
        BLOCKIDTIGHTENINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningStatus)
    writeSimpleEnumField(
        "tighteningStatus",
        "NokOk",
        tighteningStatus,
        new DataWriterEnumDefault<>(
            NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchStatus)
    writeConstField(
        "blockIdBatchStatus",
        BLOCKIDBATCHSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchStatus)
    writeSimpleEnumField(
        "batchStatus",
        "BatchStatus",
        batchStatus,
        new DataWriterEnumDefault<>(
            BatchStatus::getValue, BatchStatus::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueStatus)
    writeConstField(
        "blockIdTorqueStatus",
        BLOCKIDTORQUESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueStatus)
    writeSimpleEnumField(
        "torqueStatus",
        "Status",
        torqueStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleStatus)
    writeConstField(
        "blockIdAngleStatus",
        BLOCKIDANGLESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleStatus)
    writeSimpleEnumField(
        "angleStatus",
        "Status",
        angleStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleStatus)
    writeConstField(
        "blockIdRundownAngleStatus",
        BLOCKIDRUNDOWNANGLESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleStatus)
    writeSimpleEnumField(
        "rundownAngleStatus",
        "Status",
        rundownAngleStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringStatus)
    writeConstField(
        "blockIdCurrentMonitoringStatus",
        BLOCKIDCURRENTMONITORINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringStatus)
    writeSimpleEnumField(
        "currentMonitoringStatus",
        "Status",
        currentMonitoringStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapStatus)
    writeConstField(
        "blockIdSelfTapStatus",
        BLOCKIDSELFTAPSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapStatus)
    writeSimpleEnumField(
        "selfTapStatus",
        "Status",
        selfTapStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringStatus)
    writeConstField(
        "blockIdPrevailTorqueMonitoringStatus",
        BLOCKIDPREVAILTORQUEMONITORINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringStatus)
    writeSimpleEnumField(
        "prevailTorqueMonitoringStatus",
        "Status",
        prevailTorqueMonitoringStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueCompensateStatus)
    writeConstField(
        "blockIdPrevailTorqueCompensateStatus",
        BLOCKIDPREVAILTORQUECOMPENSATESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueCompensateStatus)
    writeSimpleEnumField(
        "prevailTorqueCompensateStatus",
        "Status",
        prevailTorqueCompensateStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningErrorStatus)
    writeConstField(
        "blockIdTighteningErrorStatus",
        BLOCKIDTIGHTENINGERRORSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningErrorStatus)
    writeSimpleField(
        "tighteningErrorStatus",
        tighteningErrorStatus,
        writeString(writeBuffer, 80),
        WithOption.WithEncoding("ASCII"));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusRundownAngleMaxShutOff =
        getTighteningErrorStatusRundownAngleMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusRundownAngleMaxShutOff", tighteningErrorStatusRundownAngleMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusRundownAngleMinShutOff =
        getTighteningErrorStatusRundownAngleMinShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusRundownAngleMinShutOff", tighteningErrorStatusRundownAngleMinShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTorqueMaxShutOff = getTighteningErrorStatusTorqueMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusTorqueMaxShutOff", tighteningErrorStatusTorqueMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusAngleMaxShutOff = getTighteningErrorStatusAngleMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusAngleMaxShutOff", tighteningErrorStatusAngleMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusSelfTapTorqueMaxShutOff =
        getTighteningErrorStatusSelfTapTorqueMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusSelfTapTorqueMaxShutOff",
        tighteningErrorStatusSelfTapTorqueMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusSelfTapTorqueMinShutOff =
        getTighteningErrorStatusSelfTapTorqueMinShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusSelfTapTorqueMinShutOff",
        tighteningErrorStatusSelfTapTorqueMinShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPrevailTorqueMaxShutOff =
        getTighteningErrorStatusPrevailTorqueMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPrevailTorqueMaxShutOff",
        tighteningErrorStatusPrevailTorqueMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPrevailTorqueMinShutOff =
        getTighteningErrorStatusPrevailTorqueMinShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPrevailTorqueMinShutOff",
        tighteningErrorStatusPrevailTorqueMinShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPrevailTorqueCompensateOverflow =
        getTighteningErrorStatusPrevailTorqueCompensateOverflow();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPrevailTorqueCompensateOverflow",
        tighteningErrorStatusPrevailTorqueCompensateOverflow);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusCurrentMonitoringMaxShutOff =
        getTighteningErrorStatusCurrentMonitoringMaxShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusCurrentMonitoringMaxShutOff",
        tighteningErrorStatusCurrentMonitoringMaxShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPostViewTorqueMinTorqueShutOff =
        getTighteningErrorStatusPostViewTorqueMinTorqueShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPostViewTorqueMinTorqueShutOff",
        tighteningErrorStatusPostViewTorqueMinTorqueShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPostViewTorqueMaxTorqueShutOff =
        getTighteningErrorStatusPostViewTorqueMaxTorqueShutOff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPostViewTorqueMaxTorqueShutOff",
        tighteningErrorStatusPostViewTorqueMaxTorqueShutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusPortViewTorqueAngleTooSmall =
        getTighteningErrorStatusPortViewTorqueAngleTooSmall();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusPortViewTorqueAngleTooSmall",
        tighteningErrorStatusPortViewTorqueAngleTooSmall);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTriggerLost = getTighteningErrorStatusTriggerLost();
    writeBuffer.writeVirtual("tighteningErrorStatusTriggerLost", tighteningErrorStatusTriggerLost);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTorqueLessThanTarget =
        getTighteningErrorStatusTorqueLessThanTarget();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusTorqueLessThanTarget", tighteningErrorStatusTorqueLessThanTarget);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusToolHot = getTighteningErrorStatusToolHot();
    writeBuffer.writeVirtual("tighteningErrorStatusToolHot", tighteningErrorStatusToolHot);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusMultistageAbort = getTighteningErrorStatusMultistageAbort();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusMultistageAbort", tighteningErrorStatusMultistageAbort);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusRehit = getTighteningErrorStatusRehit();
    writeBuffer.writeVirtual("tighteningErrorStatusRehit", tighteningErrorStatusRehit);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusDsMeasureFailed = getTighteningErrorStatusDsMeasureFailed();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusDsMeasureFailed", tighteningErrorStatusDsMeasureFailed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusCurrentLimitReached =
        getTighteningErrorStatusCurrentLimitReached();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusCurrentLimitReached", tighteningErrorStatusCurrentLimitReached);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusEndTimeOutShutoff = getTighteningErrorStatusEndTimeOutShutoff();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusEndTimeOutShutoff", tighteningErrorStatusEndTimeOutShutoff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusRemoveFastenerLimitExceeded =
        getTighteningErrorStatusRemoveFastenerLimitExceeded();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusRemoveFastenerLimitExceeded",
        tighteningErrorStatusRemoveFastenerLimitExceeded);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusDisableDrive = getTighteningErrorStatusDisableDrive();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusDisableDrive", tighteningErrorStatusDisableDrive);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTransducerLost = getTighteningErrorStatusTransducerLost();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusTransducerLost", tighteningErrorStatusTransducerLost);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTransducerShorted = getTighteningErrorStatusTransducerShorted();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusTransducerShorted", tighteningErrorStatusTransducerShorted);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusTransducerCorrupt = getTighteningErrorStatusTransducerCorrupt();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusTransducerCorrupt", tighteningErrorStatusTransducerCorrupt);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusSyncTimeout = getTighteningErrorStatusSyncTimeout();
    writeBuffer.writeVirtual("tighteningErrorStatusSyncTimeout", tighteningErrorStatusSyncTimeout);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusDynamicCurrentMonitoringMin =
        getTighteningErrorStatusDynamicCurrentMonitoringMin();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusDynamicCurrentMonitoringMin",
        tighteningErrorStatusDynamicCurrentMonitoringMin);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusDynamicCurrentMonitoringMax =
        getTighteningErrorStatusDynamicCurrentMonitoringMax();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusDynamicCurrentMonitoringMax",
        tighteningErrorStatusDynamicCurrentMonitoringMax);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusAngleMaxMonitor = getTighteningErrorStatusAngleMaxMonitor();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusAngleMaxMonitor", tighteningErrorStatusAngleMaxMonitor);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusYieldNutOff = getTighteningErrorStatusYieldNutOff();
    writeBuffer.writeVirtual("tighteningErrorStatusYieldNutOff", tighteningErrorStatusYieldNutOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean tighteningErrorStatusYieldTooFewSamples = getTighteningErrorStatusYieldTooFewSamples();
    writeBuffer.writeVirtual(
        "tighteningErrorStatusYieldTooFewSamples", tighteningErrorStatusYieldTooFewSamples);

    // Const Field (blockIdTorqueMinLimit)
    writeConstField(
        "blockIdTorqueMinLimit",
        BLOCKIDTORQUEMINLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMinLimit)
    writeSimpleField(
        "torqueMinLimit",
        torqueMinLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueMaxLimit)
    writeConstField(
        "blockIdTorqueMaxLimit",
        BLOCKIDTORQUEMAXLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMaxLimit)
    writeSimpleField(
        "torqueMaxLimit",
        torqueMaxLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueFinalTarget)
    writeConstField(
        "blockIdTorqueFinalTarget",
        BLOCKIDTORQUEFINALTARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueFinalTarget)
    writeSimpleField(
        "torqueFinalTarget",
        torqueFinalTarget,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorque)
    writeConstField(
        "blockIdTorque",
        BLOCKIDTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torque)
    writeSimpleField(
        "torque", torque, writeUnsignedLong(writeBuffer, 48), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMin)
    writeConstField(
        "blockIdAngleMin",
        BLOCKIDANGLEMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMin)
    writeSimpleField(
        "angleMin", angleMin, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMax)
    writeConstField(
        "blockIdAngleMax",
        BLOCKIDANGLEMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMax)
    writeSimpleField(
        "angleMax", angleMax, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdFinalAngleTarget)
    writeConstField(
        "blockIdFinalAngleTarget",
        BLOCKIDFINALANGLETARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (finalAngleTarget)
    writeSimpleField(
        "finalAngleTarget",
        finalAngleTarget,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngle)
    writeConstField(
        "blockIdAngle",
        BLOCKIDANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angle)
    writeSimpleField(
        "angle", angle, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleMin)
    writeConstField(
        "blockIdRundownAngleMin",
        BLOCKIDRUNDOWNANGLEMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleMin)
    writeSimpleField(
        "rundownAngleMin",
        rundownAngleMin,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngleMax)
    writeConstField(
        "blockIdRundownAngleMax",
        BLOCKIDRUNDOWNANGLEMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngleMax)
    writeSimpleField(
        "rundownAngleMax",
        rundownAngleMax,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRundownAngle)
    writeConstField(
        "blockIdRundownAngle",
        BLOCKIDRUNDOWNANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (rundownAngle)
    writeSimpleField(
        "rundownAngle",
        rundownAngle,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringMin)
    writeConstField(
        "blockIdCurrentMonitoringMin",
        BLOCKIDCURRENTMONITORINGMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringMin)
    writeSimpleField(
        "currentMonitoringMin",
        currentMonitoringMin,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringMax)
    writeConstField(
        "blockIdCurrentMonitoringMax",
        BLOCKIDCURRENTMONITORINGMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringMax)
    writeSimpleField(
        "currentMonitoringMax",
        currentMonitoringMax,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdCurrentMonitoringValue)
    writeConstField(
        "blockIdCurrentMonitoringValue",
        BLOCKIDCURRENTMONITORINGVALUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (currentMonitoringValue)
    writeSimpleField(
        "currentMonitoringValue",
        currentMonitoringValue,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapMin)
    writeConstField(
        "blockIdSelfTapMin",
        BLOCKIDSELFTAPMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapMin)
    writeSimpleField(
        "selfTapMin",
        selfTapMin,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapMax)
    writeConstField(
        "blockIdSelfTapMax",
        BLOCKIDSELFTAPMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapMax)
    writeSimpleField(
        "selfTapMax",
        selfTapMax,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSelfTapTorque)
    writeConstField(
        "blockIdSelfTapTorque",
        BLOCKIDSELFTAPTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (selfTapTorque)
    writeSimpleField(
        "selfTapTorque",
        selfTapTorque,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringMin)
    writeConstField(
        "blockIdPrevailTorqueMonitoringMin",
        BLOCKIDPREVAILTORQUEMONITORINGMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringMin)
    writeSimpleField(
        "prevailTorqueMonitoringMin",
        prevailTorqueMonitoringMin,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorqueMonitoringMax)
    writeConstField(
        "blockIdPrevailTorqueMonitoringMax",
        BLOCKIDPREVAILTORQUEMONITORINGMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorqueMonitoringMax)
    writeSimpleField(
        "prevailTorqueMonitoringMax",
        prevailTorqueMonitoringMax,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdPrevailTorque)
    writeConstField(
        "blockIdPrevailTorque",
        BLOCKIDPREVAILTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (prevailTorque)
    writeSimpleField(
        "prevailTorque",
        prevailTorque,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningId)
    writeConstField(
        "blockIdTighteningId",
        BLOCKIDTIGHTENINGID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningId)
    writeSimpleField(
        "tighteningId",
        tighteningId,
        writeString(writeBuffer, 80),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobSequenceNumber)
    writeConstField(
        "blockIdJobSequenceNumber",
        BLOCKIDJOBSEQUENCENUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobSequenceNumber)
    writeSimpleField(
        "jobSequenceNumber",
        jobSequenceNumber,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdSyncTighteningId)
    writeConstField(
        "blockIdSyncTighteningId",
        BLOCKIDSYNCTIGHTENINGID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (syncTighteningId)
    writeSimpleField(
        "syncTighteningId",
        syncTighteningId,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdToolSerialNumber)
    writeConstField(
        "blockIdToolSerialNumber",
        BLOCKIDTOOLSERIALNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (toolSerialNumber)
    writeSimpleField(
        "toolSerialNumber",
        toolSerialNumber,
        writeString(writeBuffer, 112),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTimeStamp)
    writeConstField(
        "blockIdTimeStamp",
        BLOCKIDTIMESTAMP,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (timeStamp)
    writeSimpleField(
        "timeStamp", timeStamp, writeString(writeBuffer, 152), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdDateTimeOfLastChangeInParameterSetSettings)
    writeConstField(
        "blockIdDateTimeOfLastChangeInParameterSetSettings",
        BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (dateTimeOfLastChangeIndParameterSetSettings)
    writeSimpleField(
        "dateTimeOfLastChangeIndParameterSetSettings",
        dateTimeOfLastChangeIndParameterSetSettings,
        writeString(writeBuffer, 152),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLastTighteningResultDataRev2");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLastTighteningResultDataRev2 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (blockIdCellId)
    lengthInBits += 16;

    // Simple field (cellId)
    lengthInBits += 32;

    // Const Field (blockIdChannelId)
    lengthInBits += 16;

    // Simple field (channelId)
    lengthInBits += 16;

    // Const Field (blockIdTorqueControllerName)
    lengthInBits += 16;

    // Simple field (torqueControllerName)
    lengthInBits += 200;

    // Const Field (blockIdVinNumber)
    lengthInBits += 16;

    // Simple field (vinNumber)
    lengthInBits += 200;

    // Const Field (blockIdJobId)
    lengthInBits += 16;

    // Simple field (jobId)
    lengthInBits += 32;

    // Const Field (blockIdParameterSetNumber)
    lengthInBits += 16;

    // Simple field (parameterSetNumber)
    lengthInBits += 24;

    // Const Field (blockIdStrategy)
    lengthInBits += 16;

    // Simple field (strategy)
    lengthInBits += 16;

    // Const Field (blockIdStrategyOptions)
    lengthInBits += 16;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (strategyOptions)
    lengthInBits += 32;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Const Field (blockIdBatchSize)
    lengthInBits += 16;

    // Simple field (batchSize)
    lengthInBits += 32;

    // Const Field (blockIdBatchCounter)
    lengthInBits += 16;

    // Simple field (batchCounter)
    lengthInBits += 32;

    // Const Field (blockIdTighteningStatus)
    lengthInBits += 16;

    // Simple field (tighteningStatus)
    lengthInBits += 8;

    // Const Field (blockIdBatchStatus)
    lengthInBits += 16;

    // Simple field (batchStatus)
    lengthInBits += 8;

    // Const Field (blockIdTorqueStatus)
    lengthInBits += 16;

    // Simple field (torqueStatus)
    lengthInBits += 8;

    // Const Field (blockIdAngleStatus)
    lengthInBits += 16;

    // Simple field (angleStatus)
    lengthInBits += 8;

    // Const Field (blockIdRundownAngleStatus)
    lengthInBits += 16;

    // Simple field (rundownAngleStatus)
    lengthInBits += 8;

    // Const Field (blockIdCurrentMonitoringStatus)
    lengthInBits += 16;

    // Simple field (currentMonitoringStatus)
    lengthInBits += 8;

    // Const Field (blockIdSelfTapStatus)
    lengthInBits += 16;

    // Simple field (selfTapStatus)
    lengthInBits += 8;

    // Const Field (blockIdPrevailTorqueMonitoringStatus)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringStatus)
    lengthInBits += 8;

    // Const Field (blockIdPrevailTorqueCompensateStatus)
    lengthInBits += 16;

    // Simple field (prevailTorqueCompensateStatus)
    lengthInBits += 8;

    // Const Field (blockIdTighteningErrorStatus)
    lengthInBits += 16;

    // Simple field (tighteningErrorStatus)
    lengthInBits += 80;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Const Field (blockIdTorqueMinLimit)
    lengthInBits += 16;

    // Simple field (torqueMinLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueMaxLimit)
    lengthInBits += 16;

    // Simple field (torqueMaxLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueFinalTarget)
    lengthInBits += 16;

    // Simple field (torqueFinalTarget)
    lengthInBits += 48;

    // Const Field (blockIdTorque)
    lengthInBits += 16;

    // Simple field (torque)
    lengthInBits += 48;

    // Const Field (blockIdAngleMin)
    lengthInBits += 16;

    // Simple field (angleMin)
    lengthInBits += 40;

    // Const Field (blockIdAngleMax)
    lengthInBits += 16;

    // Simple field (angleMax)
    lengthInBits += 40;

    // Const Field (blockIdFinalAngleTarget)
    lengthInBits += 16;

    // Simple field (finalAngleTarget)
    lengthInBits += 40;

    // Const Field (blockIdAngle)
    lengthInBits += 16;

    // Simple field (angle)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngleMin)
    lengthInBits += 16;

    // Simple field (rundownAngleMin)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngleMax)
    lengthInBits += 16;

    // Simple field (rundownAngleMax)
    lengthInBits += 40;

    // Const Field (blockIdRundownAngle)
    lengthInBits += 16;

    // Simple field (rundownAngle)
    lengthInBits += 40;

    // Const Field (blockIdCurrentMonitoringMin)
    lengthInBits += 16;

    // Simple field (currentMonitoringMin)
    lengthInBits += 24;

    // Const Field (blockIdCurrentMonitoringMax)
    lengthInBits += 16;

    // Simple field (currentMonitoringMax)
    lengthInBits += 24;

    // Const Field (blockIdCurrentMonitoringValue)
    lengthInBits += 16;

    // Simple field (currentMonitoringValue)
    lengthInBits += 24;

    // Const Field (blockIdSelfTapMin)
    lengthInBits += 16;

    // Simple field (selfTapMin)
    lengthInBits += 48;

    // Const Field (blockIdSelfTapMax)
    lengthInBits += 16;

    // Simple field (selfTapMax)
    lengthInBits += 48;

    // Const Field (blockIdSelfTapTorque)
    lengthInBits += 16;

    // Simple field (selfTapTorque)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorqueMonitoringMin)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringMin)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorqueMonitoringMax)
    lengthInBits += 16;

    // Simple field (prevailTorqueMonitoringMax)
    lengthInBits += 48;

    // Const Field (blockIdPrevailTorque)
    lengthInBits += 16;

    // Simple field (prevailTorque)
    lengthInBits += 48;

    // Const Field (blockIdTighteningId)
    lengthInBits += 16;

    // Simple field (tighteningId)
    lengthInBits += 80;

    // Const Field (blockIdJobSequenceNumber)
    lengthInBits += 16;

    // Simple field (jobSequenceNumber)
    lengthInBits += 40;

    // Const Field (blockIdSyncTighteningId)
    lengthInBits += 16;

    // Simple field (syncTighteningId)
    lengthInBits += 40;

    // Const Field (blockIdToolSerialNumber)
    lengthInBits += 16;

    // Simple field (toolSerialNumber)
    lengthInBits += 112;

    // Const Field (blockIdTimeStamp)
    lengthInBits += 16;

    // Simple field (timeStamp)
    lengthInBits += 152;

    // Const Field (blockIdDateTimeOfLastChangeInParameterSetSettings)
    lengthInBits += 16;

    // Simple field (dateTimeOfLastChangeIndParameterSetSettings)
    lengthInBits += 152;

    return lengthInBits;
  }

  public static OpenProtocolMessageLastTighteningResultDataBuilder
      staticParseOpenProtocolMessageLastTighteningResultDataBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLastTighteningResultDataRev2");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockIdCellId =
        readConstField(
            "blockIdCellId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCELLID,
            WithOption.WithEncoding("ASCII"));

    long cellId =
        readSimpleField(
            "cellId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdChannelId =
        readConstField(
            "blockIdChannelId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCHANNELID,
            WithOption.WithEncoding("ASCII"));

    int channelId =
        readSimpleField(
            "channelId", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueControllerName =
        readConstField(
            "blockIdTorqueControllerName",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUECONTROLLERNAME,
            WithOption.WithEncoding("ASCII"));

    String torqueControllerName =
        readSimpleField(
            "torqueControllerName", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdVinNumber =
        readConstField(
            "blockIdVinNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDVINNUMBER,
            WithOption.WithEncoding("ASCII"));

    String vinNumber =
        readSimpleField("vinNumber", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdJobId =
        readConstField(
            "blockIdJobId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDJOBID,
            WithOption.WithEncoding("ASCII"));

    long jobId =
        readSimpleField(
            "jobId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdParameterSetNumber =
        readConstField(
            "blockIdParameterSetNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPARAMETERSETNUMBER,
            WithOption.WithEncoding("ASCII"));

    int parameterSetNumber =
        readSimpleField(
            "parameterSetNumber",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdStrategy =
        readConstField(
            "blockIdStrategy",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSTRATEGY,
            WithOption.WithEncoding("ASCII"));

    Strategy strategy =
        readEnumField(
            "strategy",
            "Strategy",
            new DataReaderEnumDefault<>(Strategy::enumForValue, readUnsignedInt(readBuffer, 16)),
            WithOption.WithEncoding("ASCII"));

    int blockIdStrategyOptions =
        readConstField(
            "blockIdStrategyOptions",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSTRATEGYOPTIONS,
            WithOption.WithEncoding("ASCII"));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x30);

    long strategyOptions =
        readSimpleField(
            "strategyOptions", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));
    boolean strategyOptionRbwMonitoring =
        readVirtualField(
            "strategyOptionRbwMonitoring",
            boolean.class,
            (((strategyOptions) & (0x0001))) == (0x0001));
    boolean strategyOptionClickWrench =
        readVirtualField(
            "strategyOptionClickWrench",
            boolean.class,
            (((strategyOptions) & (0x0002))) == (0x0002));
    boolean strategyOptionDsControl =
        readVirtualField(
            "strategyOptionDsControl", boolean.class, (((strategyOptions) & (0x0004))) == (0x0004));
    boolean strategyOptionCm =
        readVirtualField(
            "strategyOptionCm", boolean.class, (((strategyOptions) & (0x0008))) == (0x0008));
    boolean strategyOptionRundown =
        readVirtualField(
            "strategyOptionRundown", boolean.class, (((strategyOptions) & (0x0010))) == (0x0010));
    boolean strategyOptionSelfTap =
        readVirtualField(
            "strategyOptionSelfTap", boolean.class, (((strategyOptions) & (0x0020))) == (0x0020));
    boolean strategyOptionPvtCompensate =
        readVirtualField(
            "strategyOptionPvtCompensate",
            boolean.class,
            (((strategyOptions) & (0x0040))) == (0x0040));
    boolean strategyOptionPvtMonitoring =
        readVirtualField(
            "strategyOptionPvtMonitoring",
            boolean.class,
            (((strategyOptions) & (0x0080))) == (0x0080));
    boolean strategyOptionBatch =
        readVirtualField(
            "strategyOptionBatch", boolean.class, (((strategyOptions) & (0x0100))) == (0x0100));
    boolean strategyOptionAngle =
        readVirtualField(
            "strategyOptionAngle", boolean.class, (((strategyOptions) & (0x0200))) == (0x0200));
    boolean strategyOptionTorque =
        readVirtualField(
            "strategyOptionTorque", boolean.class, (((strategyOptions) & (0x0400))) == (0x0400));

    int blockIdBatchSize =
        readConstField(
            "blockIdBatchSize",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDBATCHSIZE,
            WithOption.WithEncoding("ASCII"));

    long batchSize =
        readSimpleField(
            "batchSize", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdBatchCounter =
        readConstField(
            "blockIdBatchCounter",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDBATCHCOUNTER,
            WithOption.WithEncoding("ASCII"));

    long batchCounter =
        readSimpleField(
            "batchCounter", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdTighteningStatus =
        readConstField(
            "blockIdTighteningStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTIGHTENINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    NokOk tighteningStatus =
        readEnumField(
            "tighteningStatus",
            "NokOk",
            new DataReaderEnumDefault<>(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdBatchStatus =
        readConstField(
            "blockIdBatchStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDBATCHSTATUS,
            WithOption.WithEncoding("ASCII"));

    BatchStatus batchStatus =
        readEnumField(
            "batchStatus",
            "BatchStatus",
            new DataReaderEnumDefault<>(
                BatchStatus::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorqueStatus =
        readConstField(
            "blockIdTorqueStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status torqueStatus =
        readEnumField(
            "torqueStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdAngleStatus =
        readConstField(
            "blockIdAngleStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDANGLESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status angleStatus =
        readEnumField(
            "angleStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleStatus =
        readConstField(
            "blockIdRundownAngleStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDRUNDOWNANGLESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status rundownAngleStatus =
        readEnumField(
            "rundownAngleStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringStatus =
        readConstField(
            "blockIdCurrentMonitoringStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCURRENTMONITORINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status currentMonitoringStatus =
        readEnumField(
            "currentMonitoringStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapStatus =
        readConstField(
            "blockIdSelfTapStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSELFTAPSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status selfTapStatus =
        readEnumField(
            "selfTapStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringStatus =
        readConstField(
            "blockIdPrevailTorqueMonitoringStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPREVAILTORQUEMONITORINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    Status prevailTorqueMonitoringStatus =
        readEnumField(
            "prevailTorqueMonitoringStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueCompensateStatus =
        readConstField(
            "blockIdPrevailTorqueCompensateStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPREVAILTORQUECOMPENSATESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status prevailTorqueCompensateStatus =
        readEnumField(
            "prevailTorqueCompensateStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTighteningErrorStatus =
        readConstField(
            "blockIdTighteningErrorStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTIGHTENINGERRORSTATUS,
            WithOption.WithEncoding("ASCII"));

    String tighteningErrorStatus =
        readSimpleField(
            "tighteningErrorStatus", readString(readBuffer, 80), WithOption.WithEncoding("ASCII"));
    boolean tighteningErrorStatusRundownAngleMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusRundownAngleMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 1));
    boolean tighteningErrorStatusRundownAngleMinShutOff =
        readVirtualField(
            "tighteningErrorStatusRundownAngleMinShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 2));
    boolean tighteningErrorStatusTorqueMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusTorqueMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 3));
    boolean tighteningErrorStatusAngleMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusAngleMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 4));
    boolean tighteningErrorStatusSelfTapTorqueMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusSelfTapTorqueMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 5));
    boolean tighteningErrorStatusSelfTapTorqueMinShutOff =
        readVirtualField(
            "tighteningErrorStatusSelfTapTorqueMinShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 6));
    boolean tighteningErrorStatusPrevailTorqueMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusPrevailTorqueMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 7));
    boolean tighteningErrorStatusPrevailTorqueMinShutOff =
        readVirtualField(
            "tighteningErrorStatusPrevailTorqueMinShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 8));
    boolean tighteningErrorStatusPrevailTorqueCompensateOverflow =
        readVirtualField(
            "tighteningErrorStatusPrevailTorqueCompensateOverflow",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 9));
    boolean tighteningErrorStatusCurrentMonitoringMaxShutOff =
        readVirtualField(
            "tighteningErrorStatusCurrentMonitoringMaxShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 10));
    boolean tighteningErrorStatusPostViewTorqueMinTorqueShutOff =
        readVirtualField(
            "tighteningErrorStatusPostViewTorqueMinTorqueShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 11));
    boolean tighteningErrorStatusPostViewTorqueMaxTorqueShutOff =
        readVirtualField(
            "tighteningErrorStatusPostViewTorqueMaxTorqueShutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 12));
    boolean tighteningErrorStatusPortViewTorqueAngleTooSmall =
        readVirtualField(
            "tighteningErrorStatusPortViewTorqueAngleTooSmall",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 13));
    boolean tighteningErrorStatusTriggerLost =
        readVirtualField(
            "tighteningErrorStatusTriggerLost",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 14));
    boolean tighteningErrorStatusTorqueLessThanTarget =
        readVirtualField(
            "tighteningErrorStatusTorqueLessThanTarget",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 15));
    boolean tighteningErrorStatusToolHot =
        readVirtualField(
            "tighteningErrorStatusToolHot",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 16));
    boolean tighteningErrorStatusMultistageAbort =
        readVirtualField(
            "tighteningErrorStatusMultistageAbort",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 17));
    boolean tighteningErrorStatusRehit =
        readVirtualField(
            "tighteningErrorStatusRehit",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 18));
    boolean tighteningErrorStatusDsMeasureFailed =
        readVirtualField(
            "tighteningErrorStatusDsMeasureFailed",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 19));
    boolean tighteningErrorStatusCurrentLimitReached =
        readVirtualField(
            "tighteningErrorStatusCurrentLimitReached",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 20));
    boolean tighteningErrorStatusEndTimeOutShutoff =
        readVirtualField(
            "tighteningErrorStatusEndTimeOutShutoff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 21));
    boolean tighteningErrorStatusRemoveFastenerLimitExceeded =
        readVirtualField(
            "tighteningErrorStatusRemoveFastenerLimitExceeded",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 22));
    boolean tighteningErrorStatusDisableDrive =
        readVirtualField(
            "tighteningErrorStatusDisableDrive",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 23));
    boolean tighteningErrorStatusTransducerLost =
        readVirtualField(
            "tighteningErrorStatusTransducerLost",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 24));
    boolean tighteningErrorStatusTransducerShorted =
        readVirtualField(
            "tighteningErrorStatusTransducerShorted",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 25));
    boolean tighteningErrorStatusTransducerCorrupt =
        readVirtualField(
            "tighteningErrorStatusTransducerCorrupt",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 26));
    boolean tighteningErrorStatusSyncTimeout =
        readVirtualField(
            "tighteningErrorStatusSyncTimeout",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 27));
    boolean tighteningErrorStatusDynamicCurrentMonitoringMin =
        readVirtualField(
            "tighteningErrorStatusDynamicCurrentMonitoringMin",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 28));
    boolean tighteningErrorStatusDynamicCurrentMonitoringMax =
        readVirtualField(
            "tighteningErrorStatusDynamicCurrentMonitoringMax",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 29));
    boolean tighteningErrorStatusAngleMaxMonitor =
        readVirtualField(
            "tighteningErrorStatusAngleMaxMonitor",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 30));
    boolean tighteningErrorStatusYieldNutOff =
        readVirtualField(
            "tighteningErrorStatusYieldNutOff",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 31));
    boolean tighteningErrorStatusYieldTooFewSamples =
        readVirtualField(
            "tighteningErrorStatusYieldTooFewSamples",
            boolean.class,
            org.apache.plc4x.java.openprotocol.readwrite.utils.StaticHelper.isBitSet(
                tighteningErrorStatus, 32));

    int blockIdTorqueMinLimit =
        readConstField(
            "blockIdTorqueMinLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUEMINLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMinLimit =
        readSimpleField(
            "torqueMinLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueMaxLimit =
        readConstField(
            "blockIdTorqueMaxLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUEMAXLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMaxLimit =
        readSimpleField(
            "torqueMaxLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueFinalTarget =
        readConstField(
            "blockIdTorqueFinalTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUEFINALTARGET,
            WithOption.WithEncoding("ASCII"));

    long torqueFinalTarget =
        readSimpleField(
            "torqueFinalTarget",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorque =
        readConstField(
            "blockIdTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTORQUE,
            WithOption.WithEncoding("ASCII"));

    long torque =
        readSimpleField(
            "torque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMin =
        readConstField(
            "blockIdAngleMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDANGLEMIN,
            WithOption.WithEncoding("ASCII"));

    long angleMin =
        readSimpleField(
            "angleMin", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMax =
        readConstField(
            "blockIdAngleMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDANGLEMAX,
            WithOption.WithEncoding("ASCII"));

    long angleMax =
        readSimpleField(
            "angleMax", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdFinalAngleTarget =
        readConstField(
            "blockIdFinalAngleTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDFINALANGLETARGET,
            WithOption.WithEncoding("ASCII"));

    long finalAngleTarget =
        readSimpleField(
            "finalAngleTarget", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngle =
        readConstField(
            "blockIdAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDANGLE,
            WithOption.WithEncoding("ASCII"));

    long angle =
        readSimpleField(
            "angle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleMin =
        readConstField(
            "blockIdRundownAngleMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDRUNDOWNANGLEMIN,
            WithOption.WithEncoding("ASCII"));

    long rundownAngleMin =
        readSimpleField(
            "rundownAngleMin", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngleMax =
        readConstField(
            "blockIdRundownAngleMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDRUNDOWNANGLEMAX,
            WithOption.WithEncoding("ASCII"));

    long rundownAngleMax =
        readSimpleField(
            "rundownAngleMax", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdRundownAngle =
        readConstField(
            "blockIdRundownAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDRUNDOWNANGLE,
            WithOption.WithEncoding("ASCII"));

    long rundownAngle =
        readSimpleField(
            "rundownAngle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringMin =
        readConstField(
            "blockIdCurrentMonitoringMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCURRENTMONITORINGMIN,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringMin =
        readSimpleField(
            "currentMonitoringMin",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringMax =
        readConstField(
            "blockIdCurrentMonitoringMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCURRENTMONITORINGMAX,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringMax =
        readSimpleField(
            "currentMonitoringMax",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdCurrentMonitoringValue =
        readConstField(
            "blockIdCurrentMonitoringValue",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDCURRENTMONITORINGVALUE,
            WithOption.WithEncoding("ASCII"));

    int currentMonitoringValue =
        readSimpleField(
            "currentMonitoringValue",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapMin =
        readConstField(
            "blockIdSelfTapMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSELFTAPMIN,
            WithOption.WithEncoding("ASCII"));

    long selfTapMin =
        readSimpleField(
            "selfTapMin", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapMax =
        readConstField(
            "blockIdSelfTapMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSELFTAPMAX,
            WithOption.WithEncoding("ASCII"));

    long selfTapMax =
        readSimpleField(
            "selfTapMax", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdSelfTapTorque =
        readConstField(
            "blockIdSelfTapTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSELFTAPTORQUE,
            WithOption.WithEncoding("ASCII"));

    long selfTapTorque =
        readSimpleField(
            "selfTapTorque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringMin =
        readConstField(
            "blockIdPrevailTorqueMonitoringMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPREVAILTORQUEMONITORINGMIN,
            WithOption.WithEncoding("ASCII"));

    long prevailTorqueMonitoringMin =
        readSimpleField(
            "prevailTorqueMonitoringMin",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorqueMonitoringMax =
        readConstField(
            "blockIdPrevailTorqueMonitoringMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPREVAILTORQUEMONITORINGMAX,
            WithOption.WithEncoding("ASCII"));

    long prevailTorqueMonitoringMax =
        readSimpleField(
            "prevailTorqueMonitoringMax",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdPrevailTorque =
        readConstField(
            "blockIdPrevailTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDPREVAILTORQUE,
            WithOption.WithEncoding("ASCII"));

    long prevailTorque =
        readSimpleField(
            "prevailTorque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTighteningId =
        readConstField(
            "blockIdTighteningId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTIGHTENINGID,
            WithOption.WithEncoding("ASCII"));

    String tighteningId =
        readSimpleField(
            "tighteningId", readString(readBuffer, 80), WithOption.WithEncoding("ASCII"));

    int blockIdJobSequenceNumber =
        readConstField(
            "blockIdJobSequenceNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDJOBSEQUENCENUMBER,
            WithOption.WithEncoding("ASCII"));

    long jobSequenceNumber =
        readSimpleField(
            "jobSequenceNumber",
            readUnsignedLong(readBuffer, 40),
            WithOption.WithEncoding("ASCII"));

    int blockIdSyncTighteningId =
        readConstField(
            "blockIdSyncTighteningId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDSYNCTIGHTENINGID,
            WithOption.WithEncoding("ASCII"));

    long syncTighteningId =
        readSimpleField(
            "syncTighteningId", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdToolSerialNumber =
        readConstField(
            "blockIdToolSerialNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTOOLSERIALNUMBER,
            WithOption.WithEncoding("ASCII"));

    String toolSerialNumber =
        readSimpleField(
            "toolSerialNumber", readString(readBuffer, 112), WithOption.WithEncoding("ASCII"));

    int blockIdTimeStamp =
        readConstField(
            "blockIdTimeStamp",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2.BLOCKIDTIMESTAMP,
            WithOption.WithEncoding("ASCII"));

    String timeStamp =
        readSimpleField("timeStamp", readString(readBuffer, 152), WithOption.WithEncoding("ASCII"));

    int blockIdDateTimeOfLastChangeInParameterSetSettings =
        readConstField(
            "blockIdDateTimeOfLastChangeInParameterSetSettings",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev2
                .BLOCKIDDATETIMEOFLASTCHANGEINPARAMETERSETSETTINGS,
            WithOption.WithEncoding("ASCII"));

    String dateTimeOfLastChangeIndParameterSetSettings =
        readSimpleField(
            "dateTimeOfLastChangeIndParameterSetSettings",
            readString(readBuffer, 152),
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLastTighteningResultDataRev2");
    // Create the instance
    return new OpenProtocolMessageLastTighteningResultDataRev2BuilderImpl(
        cellId,
        channelId,
        torqueControllerName,
        vinNumber,
        jobId,
        parameterSetNumber,
        strategy,
        strategyOptions,
        batchSize,
        batchCounter,
        tighteningStatus,
        batchStatus,
        torqueStatus,
        angleStatus,
        rundownAngleStatus,
        currentMonitoringStatus,
        selfTapStatus,
        prevailTorqueMonitoringStatus,
        prevailTorqueCompensateStatus,
        tighteningErrorStatus,
        torqueMinLimit,
        torqueMaxLimit,
        torqueFinalTarget,
        torque,
        angleMin,
        angleMax,
        finalAngleTarget,
        angle,
        rundownAngleMin,
        rundownAngleMax,
        rundownAngle,
        currentMonitoringMin,
        currentMonitoringMax,
        currentMonitoringValue,
        selfTapMin,
        selfTapMax,
        selfTapTorque,
        prevailTorqueMonitoringMin,
        prevailTorqueMonitoringMax,
        prevailTorque,
        tighteningId,
        jobSequenceNumber,
        syncTighteningId,
        toolSerialNumber,
        timeStamp,
        dateTimeOfLastChangeIndParameterSetSettings);
  }

  public static class OpenProtocolMessageLastTighteningResultDataRev2BuilderImpl
      implements OpenProtocolMessageLastTighteningResultData
          .OpenProtocolMessageLastTighteningResultDataBuilder {
    private final long cellId;
    private final int channelId;
    private final String torqueControllerName;
    private final String vinNumber;
    private final long jobId;
    private final int parameterSetNumber;
    private final Strategy strategy;
    private final long strategyOptions;
    private final long batchSize;
    private final long batchCounter;
    private final NokOk tighteningStatus;
    private final BatchStatus batchStatus;
    private final Status torqueStatus;
    private final Status angleStatus;
    private final Status rundownAngleStatus;
    private final Status currentMonitoringStatus;
    private final Status selfTapStatus;
    private final Status prevailTorqueMonitoringStatus;
    private final Status prevailTorqueCompensateStatus;
    private final String tighteningErrorStatus;
    private final long torqueMinLimit;
    private final long torqueMaxLimit;
    private final long torqueFinalTarget;
    private final long torque;
    private final long angleMin;
    private final long angleMax;
    private final long finalAngleTarget;
    private final long angle;
    private final long rundownAngleMin;
    private final long rundownAngleMax;
    private final long rundownAngle;
    private final int currentMonitoringMin;
    private final int currentMonitoringMax;
    private final int currentMonitoringValue;
    private final long selfTapMin;
    private final long selfTapMax;
    private final long selfTapTorque;
    private final long prevailTorqueMonitoringMin;
    private final long prevailTorqueMonitoringMax;
    private final long prevailTorque;
    private final String tighteningId;
    private final long jobSequenceNumber;
    private final long syncTighteningId;
    private final String toolSerialNumber;
    private final String timeStamp;
    private final String dateTimeOfLastChangeIndParameterSetSettings;

    public OpenProtocolMessageLastTighteningResultDataRev2BuilderImpl(
        long cellId,
        int channelId,
        String torqueControllerName,
        String vinNumber,
        long jobId,
        int parameterSetNumber,
        Strategy strategy,
        long strategyOptions,
        long batchSize,
        long batchCounter,
        NokOk tighteningStatus,
        BatchStatus batchStatus,
        Status torqueStatus,
        Status angleStatus,
        Status rundownAngleStatus,
        Status currentMonitoringStatus,
        Status selfTapStatus,
        Status prevailTorqueMonitoringStatus,
        Status prevailTorqueCompensateStatus,
        String tighteningErrorStatus,
        long torqueMinLimit,
        long torqueMaxLimit,
        long torqueFinalTarget,
        long torque,
        long angleMin,
        long angleMax,
        long finalAngleTarget,
        long angle,
        long rundownAngleMin,
        long rundownAngleMax,
        long rundownAngle,
        int currentMonitoringMin,
        int currentMonitoringMax,
        int currentMonitoringValue,
        long selfTapMin,
        long selfTapMax,
        long selfTapTorque,
        long prevailTorqueMonitoringMin,
        long prevailTorqueMonitoringMax,
        long prevailTorque,
        String tighteningId,
        long jobSequenceNumber,
        long syncTighteningId,
        String toolSerialNumber,
        String timeStamp,
        String dateTimeOfLastChangeIndParameterSetSettings) {
      this.cellId = cellId;
      this.channelId = channelId;
      this.torqueControllerName = torqueControllerName;
      this.vinNumber = vinNumber;
      this.jobId = jobId;
      this.parameterSetNumber = parameterSetNumber;
      this.strategy = strategy;
      this.strategyOptions = strategyOptions;
      this.batchSize = batchSize;
      this.batchCounter = batchCounter;
      this.tighteningStatus = tighteningStatus;
      this.batchStatus = batchStatus;
      this.torqueStatus = torqueStatus;
      this.angleStatus = angleStatus;
      this.rundownAngleStatus = rundownAngleStatus;
      this.currentMonitoringStatus = currentMonitoringStatus;
      this.selfTapStatus = selfTapStatus;
      this.prevailTorqueMonitoringStatus = prevailTorqueMonitoringStatus;
      this.prevailTorqueCompensateStatus = prevailTorqueCompensateStatus;
      this.tighteningErrorStatus = tighteningErrorStatus;
      this.torqueMinLimit = torqueMinLimit;
      this.torqueMaxLimit = torqueMaxLimit;
      this.torqueFinalTarget = torqueFinalTarget;
      this.torque = torque;
      this.angleMin = angleMin;
      this.angleMax = angleMax;
      this.finalAngleTarget = finalAngleTarget;
      this.angle = angle;
      this.rundownAngleMin = rundownAngleMin;
      this.rundownAngleMax = rundownAngleMax;
      this.rundownAngle = rundownAngle;
      this.currentMonitoringMin = currentMonitoringMin;
      this.currentMonitoringMax = currentMonitoringMax;
      this.currentMonitoringValue = currentMonitoringValue;
      this.selfTapMin = selfTapMin;
      this.selfTapMax = selfTapMax;
      this.selfTapTorque = selfTapTorque;
      this.prevailTorqueMonitoringMin = prevailTorqueMonitoringMin;
      this.prevailTorqueMonitoringMax = prevailTorqueMonitoringMax;
      this.prevailTorque = prevailTorque;
      this.tighteningId = tighteningId;
      this.jobSequenceNumber = jobSequenceNumber;
      this.syncTighteningId = syncTighteningId;
      this.toolSerialNumber = toolSerialNumber;
      this.timeStamp = timeStamp;
      this.dateTimeOfLastChangeIndParameterSetSettings =
          dateTimeOfLastChangeIndParameterSetSettings;
    }

    public OpenProtocolMessageLastTighteningResultDataRev2 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLastTighteningResultDataRev2
          openProtocolMessageLastTighteningResultDataRev2 =
              new OpenProtocolMessageLastTighteningResultDataRev2(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  cellId,
                  channelId,
                  torqueControllerName,
                  vinNumber,
                  jobId,
                  parameterSetNumber,
                  strategy,
                  strategyOptions,
                  batchSize,
                  batchCounter,
                  tighteningStatus,
                  batchStatus,
                  torqueStatus,
                  angleStatus,
                  rundownAngleStatus,
                  currentMonitoringStatus,
                  selfTapStatus,
                  prevailTorqueMonitoringStatus,
                  prevailTorqueCompensateStatus,
                  tighteningErrorStatus,
                  torqueMinLimit,
                  torqueMaxLimit,
                  torqueFinalTarget,
                  torque,
                  angleMin,
                  angleMax,
                  finalAngleTarget,
                  angle,
                  rundownAngleMin,
                  rundownAngleMax,
                  rundownAngle,
                  currentMonitoringMin,
                  currentMonitoringMax,
                  currentMonitoringValue,
                  selfTapMin,
                  selfTapMax,
                  selfTapTorque,
                  prevailTorqueMonitoringMin,
                  prevailTorqueMonitoringMax,
                  prevailTorque,
                  tighteningId,
                  jobSequenceNumber,
                  syncTighteningId,
                  toolSerialNumber,
                  timeStamp,
                  dateTimeOfLastChangeIndParameterSetSettings);
      return openProtocolMessageLastTighteningResultDataRev2;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLastTighteningResultDataRev2)) {
      return false;
    }
    OpenProtocolMessageLastTighteningResultDataRev2 that =
        (OpenProtocolMessageLastTighteningResultDataRev2) o;
    return (getCellId() == that.getCellId())
        && (getChannelId() == that.getChannelId())
        && (getTorqueControllerName() == that.getTorqueControllerName())
        && (getVinNumber() == that.getVinNumber())
        && (getJobId() == that.getJobId())
        && (getParameterSetNumber() == that.getParameterSetNumber())
        && (getStrategy() == that.getStrategy())
        && (getStrategyOptions() == that.getStrategyOptions())
        && (getBatchSize() == that.getBatchSize())
        && (getBatchCounter() == that.getBatchCounter())
        && (getTighteningStatus() == that.getTighteningStatus())
        && (getBatchStatus() == that.getBatchStatus())
        && (getTorqueStatus() == that.getTorqueStatus())
        && (getAngleStatus() == that.getAngleStatus())
        && (getRundownAngleStatus() == that.getRundownAngleStatus())
        && (getCurrentMonitoringStatus() == that.getCurrentMonitoringStatus())
        && (getSelfTapStatus() == that.getSelfTapStatus())
        && (getPrevailTorqueMonitoringStatus() == that.getPrevailTorqueMonitoringStatus())
        && (getPrevailTorqueCompensateStatus() == that.getPrevailTorqueCompensateStatus())
        && (getTighteningErrorStatus() == that.getTighteningErrorStatus())
        && (getTorqueMinLimit() == that.getTorqueMinLimit())
        && (getTorqueMaxLimit() == that.getTorqueMaxLimit())
        && (getTorqueFinalTarget() == that.getTorqueFinalTarget())
        && (getTorque() == that.getTorque())
        && (getAngleMin() == that.getAngleMin())
        && (getAngleMax() == that.getAngleMax())
        && (getFinalAngleTarget() == that.getFinalAngleTarget())
        && (getAngle() == that.getAngle())
        && (getRundownAngleMin() == that.getRundownAngleMin())
        && (getRundownAngleMax() == that.getRundownAngleMax())
        && (getRundownAngle() == that.getRundownAngle())
        && (getCurrentMonitoringMin() == that.getCurrentMonitoringMin())
        && (getCurrentMonitoringMax() == that.getCurrentMonitoringMax())
        && (getCurrentMonitoringValue() == that.getCurrentMonitoringValue())
        && (getSelfTapMin() == that.getSelfTapMin())
        && (getSelfTapMax() == that.getSelfTapMax())
        && (getSelfTapTorque() == that.getSelfTapTorque())
        && (getPrevailTorqueMonitoringMin() == that.getPrevailTorqueMonitoringMin())
        && (getPrevailTorqueMonitoringMax() == that.getPrevailTorqueMonitoringMax())
        && (getPrevailTorque() == that.getPrevailTorque())
        && (getTighteningId() == that.getTighteningId())
        && (getJobSequenceNumber() == that.getJobSequenceNumber())
        && (getSyncTighteningId() == that.getSyncTighteningId())
        && (getToolSerialNumber() == that.getToolSerialNumber())
        && (getTimeStamp() == that.getTimeStamp())
        && (getDateTimeOfLastChangeIndParameterSetSettings()
            == that.getDateTimeOfLastChangeIndParameterSetSettings())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getCellId(),
        getChannelId(),
        getTorqueControllerName(),
        getVinNumber(),
        getJobId(),
        getParameterSetNumber(),
        getStrategy(),
        getStrategyOptions(),
        getBatchSize(),
        getBatchCounter(),
        getTighteningStatus(),
        getBatchStatus(),
        getTorqueStatus(),
        getAngleStatus(),
        getRundownAngleStatus(),
        getCurrentMonitoringStatus(),
        getSelfTapStatus(),
        getPrevailTorqueMonitoringStatus(),
        getPrevailTorqueCompensateStatus(),
        getTighteningErrorStatus(),
        getTorqueMinLimit(),
        getTorqueMaxLimit(),
        getTorqueFinalTarget(),
        getTorque(),
        getAngleMin(),
        getAngleMax(),
        getFinalAngleTarget(),
        getAngle(),
        getRundownAngleMin(),
        getRundownAngleMax(),
        getRundownAngle(),
        getCurrentMonitoringMin(),
        getCurrentMonitoringMax(),
        getCurrentMonitoringValue(),
        getSelfTapMin(),
        getSelfTapMax(),
        getSelfTapTorque(),
        getPrevailTorqueMonitoringMin(),
        getPrevailTorqueMonitoringMax(),
        getPrevailTorque(),
        getTighteningId(),
        getJobSequenceNumber(),
        getSyncTighteningId(),
        getToolSerialNumber(),
        getTimeStamp(),
        getDateTimeOfLastChangeIndParameterSetSettings());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
