/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageExecuteDynamicJobRequestRev999
    extends OpenProtocolMessageExecuteDynamicJobRequest implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 999;
  }

  // Constant values.
  public static final Integer BLOCKIDJOBID = 1;
  public static final Integer BLOCKIDJOBNAME = 2;
  public static final Integer BLOCKIDNUMBEROFPARAMETERSETS = 3;
  public static final Integer BLOCKIDJOBLIST = 4;
  public static final Integer BLOCKIDFORCEDORDER = 5;
  public static final Integer BLOCKIDLOCKATJOBDONE = 6;
  public static final Integer BLOCKIDTOOLLOOSENING = 7;
  public static final Integer BLOCKIDREPEATJOB = 8;
  public static final Integer BLOCKIDJOBBATCHMODEANDCOUNTTYPE = 9;
  public static final Integer BLOCKIDBATCHSTATUSATINCREMENTBYPASS = 10;
  public static final Integer BLOCKIDDECREMENTBATCHATOKLOOSENING = 11;
  public static final Integer BLOCKIDMAXTIMEFORFIRSTTIGHTENING = 12;
  public static final Integer BLOCKIDMAXTIMETOCOMPLETEJOB = 13;
  public static final Integer BLOCKIDDISPLAYRESULTATAUTOSELECT = 14;
  public static final Integer BLOCKIDUSELINECONTROL = 15;
  public static final Integer BLOCKIDIDENTIFIERRESULTPART = 16;
  public static final Integer BLOCKIDRESULTOFNONTIGHTENINGS = 17;
  public static final Integer BLOCKIDRESETALLIDENTIFIERSATJOBDONE = 18;
  public static final Integer BLOCKIDRESERVED = 19;

  // Properties.
  protected final long jobId;
  protected final String jobName;
  protected final ForcedOrder forcedOrder;
  protected final NoYes lockAtJobDone;
  protected final ToolLoosening toolLoosening;
  protected final NoYes repeatJob;
  protected final JobBatchMode jobBatchModeAndCountType;
  protected final OkNok batchStatusAtIncrementBypass;
  protected final NoYes decrementBatchAtOkLoosening;
  protected final long maxTimeForFirstTightening;
  protected final long maxTimeToCompleteJob;
  protected final long displayResultAtAutoSelect;
  protected final NoYes useLineControl;
  protected final IdentifierResult identifierResultPart;
  protected final NoYes resultOfNonTightenings;
  protected final NoYes resetAllIdentifiersAtJobDone;
  protected final short jobRepair;

  public OpenProtocolMessageExecuteDynamicJobRequestRev999(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      long jobId,
      String jobName,
      ForcedOrder forcedOrder,
      NoYes lockAtJobDone,
      ToolLoosening toolLoosening,
      NoYes repeatJob,
      JobBatchMode jobBatchModeAndCountType,
      OkNok batchStatusAtIncrementBypass,
      NoYes decrementBatchAtOkLoosening,
      long maxTimeForFirstTightening,
      long maxTimeToCompleteJob,
      long displayResultAtAutoSelect,
      NoYes useLineControl,
      IdentifierResult identifierResultPart,
      NoYes resultOfNonTightenings,
      NoYes resetAllIdentifiersAtJobDone,
      short jobRepair) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.jobId = jobId;
    this.jobName = jobName;
    this.forcedOrder = forcedOrder;
    this.lockAtJobDone = lockAtJobDone;
    this.toolLoosening = toolLoosening;
    this.repeatJob = repeatJob;
    this.jobBatchModeAndCountType = jobBatchModeAndCountType;
    this.batchStatusAtIncrementBypass = batchStatusAtIncrementBypass;
    this.decrementBatchAtOkLoosening = decrementBatchAtOkLoosening;
    this.maxTimeForFirstTightening = maxTimeForFirstTightening;
    this.maxTimeToCompleteJob = maxTimeToCompleteJob;
    this.displayResultAtAutoSelect = displayResultAtAutoSelect;
    this.useLineControl = useLineControl;
    this.identifierResultPart = identifierResultPart;
    this.resultOfNonTightenings = resultOfNonTightenings;
    this.resetAllIdentifiersAtJobDone = resetAllIdentifiersAtJobDone;
    this.jobRepair = jobRepair;
  }

  public long getJobId() {
    return jobId;
  }

  public String getJobName() {
    return jobName;
  }

  public ForcedOrder getForcedOrder() {
    return forcedOrder;
  }

  public NoYes getLockAtJobDone() {
    return lockAtJobDone;
  }

  public ToolLoosening getToolLoosening() {
    return toolLoosening;
  }

  public NoYes getRepeatJob() {
    return repeatJob;
  }

  public JobBatchMode getJobBatchModeAndCountType() {
    return jobBatchModeAndCountType;
  }

  public OkNok getBatchStatusAtIncrementBypass() {
    return batchStatusAtIncrementBypass;
  }

  public NoYes getDecrementBatchAtOkLoosening() {
    return decrementBatchAtOkLoosening;
  }

  public long getMaxTimeForFirstTightening() {
    return maxTimeForFirstTightening;
  }

  public long getMaxTimeToCompleteJob() {
    return maxTimeToCompleteJob;
  }

  public long getDisplayResultAtAutoSelect() {
    return displayResultAtAutoSelect;
  }

  public NoYes getUseLineControl() {
    return useLineControl;
  }

  public IdentifierResult getIdentifierResultPart() {
    return identifierResultPart;
  }

  public NoYes getResultOfNonTightenings() {
    return resultOfNonTightenings;
  }

  public NoYes getResetAllIdentifiersAtJobDone() {
    return resetAllIdentifiersAtJobDone;
  }

  public short getJobRepair() {
    return jobRepair;
  }

  public int getBlockIdJobId() {
    return BLOCKIDJOBID;
  }

  public int getBlockIdJobName() {
    return BLOCKIDJOBNAME;
  }

  public int getBlockIdNumberOfParameterSets() {
    return BLOCKIDNUMBEROFPARAMETERSETS;
  }

  public int getBlockIdJobList() {
    return BLOCKIDJOBLIST;
  }

  public int getBlockIdForcedOrder() {
    return BLOCKIDFORCEDORDER;
  }

  public int getBlockIdLockAtJobDone() {
    return BLOCKIDLOCKATJOBDONE;
  }

  public int getBlockIdToolLoosening() {
    return BLOCKIDTOOLLOOSENING;
  }

  public int getBlockIdRepeatJob() {
    return BLOCKIDREPEATJOB;
  }

  public int getBlockIdJobBatchModeAndCountType() {
    return BLOCKIDJOBBATCHMODEANDCOUNTTYPE;
  }

  public int getBlockIdBatchStatusAtIncrementBypass() {
    return BLOCKIDBATCHSTATUSATINCREMENTBYPASS;
  }

  public int getBlockIdDecrementBatchAtOkLoosening() {
    return BLOCKIDDECREMENTBATCHATOKLOOSENING;
  }

  public int getBlockIdMaxTimeForFirstTightening() {
    return BLOCKIDMAXTIMEFORFIRSTTIGHTENING;
  }

  public int getBlockIdMaxTimeToCompleteJob() {
    return BLOCKIDMAXTIMETOCOMPLETEJOB;
  }

  public int getBlockIdDisplayResultAtAutoSelect() {
    return BLOCKIDDISPLAYRESULTATAUTOSELECT;
  }

  public int getBlockIdUseLineControl() {
    return BLOCKIDUSELINECONTROL;
  }

  public int getBlockIdIdentifierResultPart() {
    return BLOCKIDIDENTIFIERRESULTPART;
  }

  public int getBlockIdResultOfNonTightenings() {
    return BLOCKIDRESULTOFNONTIGHTENINGS;
  }

  public int getBlockIdResetAllIdentifiersAtJobDone() {
    return BLOCKIDRESETALLIDENTIFIERSATJOBDONE;
  }

  public int getBlockIdReserved() {
    return BLOCKIDRESERVED;
  }

  @Override
  protected void serializeOpenProtocolMessageExecuteDynamicJobRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageExecuteDynamicJobRequestRev999");

    // Const Field (blockIdJobId)
    writeConstField(
        "blockIdJobId",
        BLOCKIDJOBID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobId)
    writeSimpleField(
        "jobId", jobId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobName)
    writeConstField(
        "blockIdJobName",
        BLOCKIDJOBNAME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobName)
    writeSimpleField(
        "jobName", jobName, writeString(writeBuffer, 200), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdNumberOfParameterSets)
    writeConstField(
        "blockIdNumberOfParameterSets",
        BLOCKIDNUMBEROFPARAMETERSETS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobList)
    writeConstField(
        "blockIdJobList",
        BLOCKIDJOBLIST,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdForcedOrder)
    writeConstField(
        "blockIdForcedOrder",
        BLOCKIDFORCEDORDER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (forcedOrder)
    writeSimpleEnumField(
        "forcedOrder",
        "ForcedOrder",
        forcedOrder,
        new DataWriterEnumDefault<>(
            ForcedOrder::getValue, ForcedOrder::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdLockAtJobDone)
    writeConstField(
        "blockIdLockAtJobDone",
        BLOCKIDLOCKATJOBDONE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (lockAtJobDone)
    writeSimpleEnumField(
        "lockAtJobDone",
        "NoYes",
        lockAtJobDone,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdToolLoosening)
    writeConstField(
        "blockIdToolLoosening",
        BLOCKIDTOOLLOOSENING,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (toolLoosening)
    writeSimpleEnumField(
        "toolLoosening",
        "ToolLoosening",
        toolLoosening,
        new DataWriterEnumDefault<>(
            ToolLoosening::getValue, ToolLoosening::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdRepeatJob)
    writeConstField(
        "blockIdRepeatJob",
        BLOCKIDREPEATJOB,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (repeatJob)
    writeSimpleEnumField(
        "repeatJob",
        "NoYes",
        repeatJob,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobBatchModeAndCountType)
    writeConstField(
        "blockIdJobBatchModeAndCountType",
        BLOCKIDJOBBATCHMODEANDCOUNTTYPE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobBatchModeAndCountType)
    writeSimpleEnumField(
        "jobBatchModeAndCountType",
        "JobBatchMode",
        jobBatchModeAndCountType,
        new DataWriterEnumDefault<>(
            JobBatchMode::getValue, JobBatchMode::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchStatusAtIncrementBypass)
    writeConstField(
        "blockIdBatchStatusAtIncrementBypass",
        BLOCKIDBATCHSTATUSATINCREMENTBYPASS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchStatusAtIncrementBypass)
    writeSimpleEnumField(
        "batchStatusAtIncrementBypass",
        "OkNok",
        batchStatusAtIncrementBypass,
        new DataWriterEnumDefault<>(
            OkNok::getValue, OkNok::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdDecrementBatchAtOkLoosening)
    writeConstField(
        "blockIdDecrementBatchAtOkLoosening",
        BLOCKIDDECREMENTBATCHATOKLOOSENING,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (decrementBatchAtOkLoosening)
    writeSimpleEnumField(
        "decrementBatchAtOkLoosening",
        "NoYes",
        decrementBatchAtOkLoosening,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdMaxTimeForFirstTightening)
    writeConstField(
        "blockIdMaxTimeForFirstTightening",
        BLOCKIDMAXTIMEFORFIRSTTIGHTENING,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (maxTimeForFirstTightening)
    writeSimpleField(
        "maxTimeForFirstTightening",
        maxTimeForFirstTightening,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdMaxTimeToCompleteJob)
    writeConstField(
        "blockIdMaxTimeToCompleteJob",
        BLOCKIDMAXTIMETOCOMPLETEJOB,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (maxTimeToCompleteJob)
    writeSimpleField(
        "maxTimeToCompleteJob",
        maxTimeToCompleteJob,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdDisplayResultAtAutoSelect)
    writeConstField(
        "blockIdDisplayResultAtAutoSelect",
        BLOCKIDDISPLAYRESULTATAUTOSELECT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (displayResultAtAutoSelect)
    writeSimpleField(
        "displayResultAtAutoSelect",
        displayResultAtAutoSelect,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdUseLineControl)
    writeConstField(
        "blockIdUseLineControl",
        BLOCKIDUSELINECONTROL,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (useLineControl)
    writeSimpleEnumField(
        "useLineControl",
        "NoYes",
        useLineControl,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdIdentifierResultPart)
    writeConstField(
        "blockIdIdentifierResultPart",
        BLOCKIDIDENTIFIERRESULTPART,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (identifierResultPart)
    writeSimpleEnumField(
        "identifierResultPart",
        "IdentifierResult",
        identifierResultPart,
        new DataWriterEnumDefault<>(
            IdentifierResult::getValue, IdentifierResult::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdResultOfNonTightenings)
    writeConstField(
        "blockIdResultOfNonTightenings",
        BLOCKIDRESULTOFNONTIGHTENINGS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (resultOfNonTightenings)
    writeSimpleEnumField(
        "resultOfNonTightenings",
        "NoYes",
        resultOfNonTightenings,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdResetAllIdentifiersAtJobDone)
    writeConstField(
        "blockIdResetAllIdentifiersAtJobDone",
        BLOCKIDRESETALLIDENTIFIERSATJOBDONE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (resetAllIdentifiersAtJobDone)
    writeSimpleEnumField(
        "resetAllIdentifiersAtJobDone",
        "NoYes",
        resetAllIdentifiersAtJobDone,
        new DataWriterEnumDefault<>(
            NoYes::getValue, NoYes::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdReserved)
    writeConstField(
        "blockIdReserved",
        BLOCKIDRESERVED,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobRepair)
    writeSimpleField(
        "jobRepair",
        jobRepair,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageExecuteDynamicJobRequestRev999");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageExecuteDynamicJobRequestRev999 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (blockIdJobId)
    lengthInBits += 16;

    // Simple field (jobId)
    lengthInBits += 32;

    // Const Field (blockIdJobName)
    lengthInBits += 16;

    // Simple field (jobName)
    lengthInBits += 200;

    // Const Field (blockIdNumberOfParameterSets)
    lengthInBits += 16;

    // Const Field (blockIdJobList)
    lengthInBits += 16;

    // Const Field (blockIdForcedOrder)
    lengthInBits += 16;

    // Simple field (forcedOrder)
    lengthInBits += 8;

    // Const Field (blockIdLockAtJobDone)
    lengthInBits += 16;

    // Simple field (lockAtJobDone)
    lengthInBits += 8;

    // Const Field (blockIdToolLoosening)
    lengthInBits += 16;

    // Simple field (toolLoosening)
    lengthInBits += 8;

    // Const Field (blockIdRepeatJob)
    lengthInBits += 16;

    // Simple field (repeatJob)
    lengthInBits += 8;

    // Const Field (blockIdJobBatchModeAndCountType)
    lengthInBits += 16;

    // Simple field (jobBatchModeAndCountType)
    lengthInBits += 8;

    // Const Field (blockIdBatchStatusAtIncrementBypass)
    lengthInBits += 16;

    // Simple field (batchStatusAtIncrementBypass)
    lengthInBits += 8;

    // Const Field (blockIdDecrementBatchAtOkLoosening)
    lengthInBits += 16;

    // Simple field (decrementBatchAtOkLoosening)
    lengthInBits += 8;

    // Const Field (blockIdMaxTimeForFirstTightening)
    lengthInBits += 16;

    // Simple field (maxTimeForFirstTightening)
    lengthInBits += 32;

    // Const Field (blockIdMaxTimeToCompleteJob)
    lengthInBits += 16;

    // Simple field (maxTimeToCompleteJob)
    lengthInBits += 40;

    // Const Field (blockIdDisplayResultAtAutoSelect)
    lengthInBits += 16;

    // Simple field (displayResultAtAutoSelect)
    lengthInBits += 32;

    // Const Field (blockIdUseLineControl)
    lengthInBits += 16;

    // Simple field (useLineControl)
    lengthInBits += 8;

    // Const Field (blockIdIdentifierResultPart)
    lengthInBits += 16;

    // Simple field (identifierResultPart)
    lengthInBits += 8;

    // Const Field (blockIdResultOfNonTightenings)
    lengthInBits += 16;

    // Simple field (resultOfNonTightenings)
    lengthInBits += 8;

    // Const Field (blockIdResetAllIdentifiersAtJobDone)
    lengthInBits += 16;

    // Simple field (resetAllIdentifiersAtJobDone)
    lengthInBits += 8;

    // Const Field (blockIdReserved)
    lengthInBits += 16;

    // Simple field (jobRepair)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static OpenProtocolMessageExecuteDynamicJobRequestBuilder
      staticParseOpenProtocolMessageExecuteDynamicJobRequestBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageExecuteDynamicJobRequestRev999");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockIdJobId =
        readConstField(
            "blockIdJobId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDJOBID,
            WithOption.WithEncoding("ASCII"));

    long jobId =
        readSimpleField(
            "jobId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdJobName =
        readConstField(
            "blockIdJobName",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDJOBNAME,
            WithOption.WithEncoding("ASCII"));

    String jobName =
        readSimpleField("jobName", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdNumberOfParameterSets =
        readConstField(
            "blockIdNumberOfParameterSets",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDNUMBEROFPARAMETERSETS,
            WithOption.WithEncoding("ASCII"));

    int blockIdJobList =
        readConstField(
            "blockIdJobList",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDJOBLIST,
            WithOption.WithEncoding("ASCII"));

    int blockIdForcedOrder =
        readConstField(
            "blockIdForcedOrder",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDFORCEDORDER,
            WithOption.WithEncoding("ASCII"));

    ForcedOrder forcedOrder =
        readEnumField(
            "forcedOrder",
            "ForcedOrder",
            new DataReaderEnumDefault<>(
                ForcedOrder::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdLockAtJobDone =
        readConstField(
            "blockIdLockAtJobDone",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDLOCKATJOBDONE,
            WithOption.WithEncoding("ASCII"));

    NoYes lockAtJobDone =
        readEnumField(
            "lockAtJobDone",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdToolLoosening =
        readConstField(
            "blockIdToolLoosening",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDTOOLLOOSENING,
            WithOption.WithEncoding("ASCII"));

    ToolLoosening toolLoosening =
        readEnumField(
            "toolLoosening",
            "ToolLoosening",
            new DataReaderEnumDefault<>(
                ToolLoosening::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdRepeatJob =
        readConstField(
            "blockIdRepeatJob",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDREPEATJOB,
            WithOption.WithEncoding("ASCII"));

    NoYes repeatJob =
        readEnumField(
            "repeatJob",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdJobBatchModeAndCountType =
        readConstField(
            "blockIdJobBatchModeAndCountType",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDJOBBATCHMODEANDCOUNTTYPE,
            WithOption.WithEncoding("ASCII"));

    JobBatchMode jobBatchModeAndCountType =
        readEnumField(
            "jobBatchModeAndCountType",
            "JobBatchMode",
            new DataReaderEnumDefault<>(
                JobBatchMode::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdBatchStatusAtIncrementBypass =
        readConstField(
            "blockIdBatchStatusAtIncrementBypass",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDBATCHSTATUSATINCREMENTBYPASS,
            WithOption.WithEncoding("ASCII"));

    OkNok batchStatusAtIncrementBypass =
        readEnumField(
            "batchStatusAtIncrementBypass",
            "OkNok",
            new DataReaderEnumDefault<>(OkNok::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdDecrementBatchAtOkLoosening =
        readConstField(
            "blockIdDecrementBatchAtOkLoosening",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDDECREMENTBATCHATOKLOOSENING,
            WithOption.WithEncoding("ASCII"));

    NoYes decrementBatchAtOkLoosening =
        readEnumField(
            "decrementBatchAtOkLoosening",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdMaxTimeForFirstTightening =
        readConstField(
            "blockIdMaxTimeForFirstTightening",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDMAXTIMEFORFIRSTTIGHTENING,
            WithOption.WithEncoding("ASCII"));

    long maxTimeForFirstTightening =
        readSimpleField(
            "maxTimeForFirstTightening",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithEncoding("ASCII"));

    int blockIdMaxTimeToCompleteJob =
        readConstField(
            "blockIdMaxTimeToCompleteJob",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDMAXTIMETOCOMPLETEJOB,
            WithOption.WithEncoding("ASCII"));

    long maxTimeToCompleteJob =
        readSimpleField(
            "maxTimeToCompleteJob",
            readUnsignedLong(readBuffer, 40),
            WithOption.WithEncoding("ASCII"));

    int blockIdDisplayResultAtAutoSelect =
        readConstField(
            "blockIdDisplayResultAtAutoSelect",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDDISPLAYRESULTATAUTOSELECT,
            WithOption.WithEncoding("ASCII"));

    long displayResultAtAutoSelect =
        readSimpleField(
            "displayResultAtAutoSelect",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithEncoding("ASCII"));

    int blockIdUseLineControl =
        readConstField(
            "blockIdUseLineControl",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDUSELINECONTROL,
            WithOption.WithEncoding("ASCII"));

    NoYes useLineControl =
        readEnumField(
            "useLineControl",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdIdentifierResultPart =
        readConstField(
            "blockIdIdentifierResultPart",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDIDENTIFIERRESULTPART,
            WithOption.WithEncoding("ASCII"));

    IdentifierResult identifierResultPart =
        readEnumField(
            "identifierResultPart",
            "IdentifierResult",
            new DataReaderEnumDefault<>(
                IdentifierResult::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdResultOfNonTightenings =
        readConstField(
            "blockIdResultOfNonTightenings",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDRESULTOFNONTIGHTENINGS,
            WithOption.WithEncoding("ASCII"));

    NoYes resultOfNonTightenings =
        readEnumField(
            "resultOfNonTightenings",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdResetAllIdentifiersAtJobDone =
        readConstField(
            "blockIdResetAllIdentifiersAtJobDone",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDRESETALLIDENTIFIERSATJOBDONE,
            WithOption.WithEncoding("ASCII"));

    NoYes resetAllIdentifiersAtJobDone =
        readEnumField(
            "resetAllIdentifiersAtJobDone",
            "NoYes",
            new DataReaderEnumDefault<>(NoYes::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdReserved =
        readConstField(
            "blockIdReserved",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageExecuteDynamicJobRequestRev999.BLOCKIDRESERVED,
            WithOption.WithEncoding("ASCII"));

    short jobRepair =
        readSimpleField(
            "jobRepair", readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageExecuteDynamicJobRequestRev999");
    // Create the instance
    return new OpenProtocolMessageExecuteDynamicJobRequestRev999BuilderImpl(
        jobId,
        jobName,
        forcedOrder,
        lockAtJobDone,
        toolLoosening,
        repeatJob,
        jobBatchModeAndCountType,
        batchStatusAtIncrementBypass,
        decrementBatchAtOkLoosening,
        maxTimeForFirstTightening,
        maxTimeToCompleteJob,
        displayResultAtAutoSelect,
        useLineControl,
        identifierResultPart,
        resultOfNonTightenings,
        resetAllIdentifiersAtJobDone,
        jobRepair);
  }

  public static class OpenProtocolMessageExecuteDynamicJobRequestRev999BuilderImpl
      implements OpenProtocolMessageExecuteDynamicJobRequest
          .OpenProtocolMessageExecuteDynamicJobRequestBuilder {
    private final long jobId;
    private final String jobName;
    private final ForcedOrder forcedOrder;
    private final NoYes lockAtJobDone;
    private final ToolLoosening toolLoosening;
    private final NoYes repeatJob;
    private final JobBatchMode jobBatchModeAndCountType;
    private final OkNok batchStatusAtIncrementBypass;
    private final NoYes decrementBatchAtOkLoosening;
    private final long maxTimeForFirstTightening;
    private final long maxTimeToCompleteJob;
    private final long displayResultAtAutoSelect;
    private final NoYes useLineControl;
    private final IdentifierResult identifierResultPart;
    private final NoYes resultOfNonTightenings;
    private final NoYes resetAllIdentifiersAtJobDone;
    private final short jobRepair;

    public OpenProtocolMessageExecuteDynamicJobRequestRev999BuilderImpl(
        long jobId,
        String jobName,
        ForcedOrder forcedOrder,
        NoYes lockAtJobDone,
        ToolLoosening toolLoosening,
        NoYes repeatJob,
        JobBatchMode jobBatchModeAndCountType,
        OkNok batchStatusAtIncrementBypass,
        NoYes decrementBatchAtOkLoosening,
        long maxTimeForFirstTightening,
        long maxTimeToCompleteJob,
        long displayResultAtAutoSelect,
        NoYes useLineControl,
        IdentifierResult identifierResultPart,
        NoYes resultOfNonTightenings,
        NoYes resetAllIdentifiersAtJobDone,
        short jobRepair) {
      this.jobId = jobId;
      this.jobName = jobName;
      this.forcedOrder = forcedOrder;
      this.lockAtJobDone = lockAtJobDone;
      this.toolLoosening = toolLoosening;
      this.repeatJob = repeatJob;
      this.jobBatchModeAndCountType = jobBatchModeAndCountType;
      this.batchStatusAtIncrementBypass = batchStatusAtIncrementBypass;
      this.decrementBatchAtOkLoosening = decrementBatchAtOkLoosening;
      this.maxTimeForFirstTightening = maxTimeForFirstTightening;
      this.maxTimeToCompleteJob = maxTimeToCompleteJob;
      this.displayResultAtAutoSelect = displayResultAtAutoSelect;
      this.useLineControl = useLineControl;
      this.identifierResultPart = identifierResultPart;
      this.resultOfNonTightenings = resultOfNonTightenings;
      this.resetAllIdentifiersAtJobDone = resetAllIdentifiersAtJobDone;
      this.jobRepair = jobRepair;
    }

    public OpenProtocolMessageExecuteDynamicJobRequestRev999 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageExecuteDynamicJobRequestRev999
          openProtocolMessageExecuteDynamicJobRequestRev999 =
              new OpenProtocolMessageExecuteDynamicJobRequestRev999(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  jobId,
                  jobName,
                  forcedOrder,
                  lockAtJobDone,
                  toolLoosening,
                  repeatJob,
                  jobBatchModeAndCountType,
                  batchStatusAtIncrementBypass,
                  decrementBatchAtOkLoosening,
                  maxTimeForFirstTightening,
                  maxTimeToCompleteJob,
                  displayResultAtAutoSelect,
                  useLineControl,
                  identifierResultPart,
                  resultOfNonTightenings,
                  resetAllIdentifiersAtJobDone,
                  jobRepair);
      return openProtocolMessageExecuteDynamicJobRequestRev999;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageExecuteDynamicJobRequestRev999)) {
      return false;
    }
    OpenProtocolMessageExecuteDynamicJobRequestRev999 that =
        (OpenProtocolMessageExecuteDynamicJobRequestRev999) o;
    return (getJobId() == that.getJobId())
        && (getJobName() == that.getJobName())
        && (getForcedOrder() == that.getForcedOrder())
        && (getLockAtJobDone() == that.getLockAtJobDone())
        && (getToolLoosening() == that.getToolLoosening())
        && (getRepeatJob() == that.getRepeatJob())
        && (getJobBatchModeAndCountType() == that.getJobBatchModeAndCountType())
        && (getBatchStatusAtIncrementBypass() == that.getBatchStatusAtIncrementBypass())
        && (getDecrementBatchAtOkLoosening() == that.getDecrementBatchAtOkLoosening())
        && (getMaxTimeForFirstTightening() == that.getMaxTimeForFirstTightening())
        && (getMaxTimeToCompleteJob() == that.getMaxTimeToCompleteJob())
        && (getDisplayResultAtAutoSelect() == that.getDisplayResultAtAutoSelect())
        && (getUseLineControl() == that.getUseLineControl())
        && (getIdentifierResultPart() == that.getIdentifierResultPart())
        && (getResultOfNonTightenings() == that.getResultOfNonTightenings())
        && (getResetAllIdentifiersAtJobDone() == that.getResetAllIdentifiersAtJobDone())
        && (getJobRepair() == that.getJobRepair())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getJobId(),
        getJobName(),
        getForcedOrder(),
        getLockAtJobDone(),
        getToolLoosening(),
        getRepeatJob(),
        getJobBatchModeAndCountType(),
        getBatchStatusAtIncrementBypass(),
        getDecrementBatchAtOkLoosening(),
        getMaxTimeForFirstTightening(),
        getMaxTimeToCompleteJob(),
        getDisplayResultAtAutoSelect(),
        getUseLineControl(),
        getIdentifierResultPart(),
        getResultOfNonTightenings(),
        getResetAllIdentifiersAtJobDone(),
        getJobRepair());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
