/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageAlarmStatusRev2 extends OpenProtocolMessageAlarmStatus
    implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 2;
  }

  // Constant values.
  public static final Integer BLOCKIDALARMSTATUS = 1;
  public static final Integer BLOCKIDERRORCODE = 2;
  public static final Integer BLOCKIDCONTROLLERREADYSTATUS = 3;
  public static final Integer BLOCKIDTOOLREADYSTATUS = 4;
  public static final Integer BLOCKIDTIME = 5;

  // Properties.
  protected final AlarmActiveStatus controllerAlarmStatus;
  protected final String errorCode;
  protected final NokOk controllerReadyStatus;
  protected final NokOk toolReadyStatus;
  protected final String alarmTime;

  public OpenProtocolMessageAlarmStatusRev2(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      AlarmActiveStatus controllerAlarmStatus,
      String errorCode,
      NokOk controllerReadyStatus,
      NokOk toolReadyStatus,
      String alarmTime) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.controllerAlarmStatus = controllerAlarmStatus;
    this.errorCode = errorCode;
    this.controllerReadyStatus = controllerReadyStatus;
    this.toolReadyStatus = toolReadyStatus;
    this.alarmTime = alarmTime;
  }

  public AlarmActiveStatus getControllerAlarmStatus() {
    return controllerAlarmStatus;
  }

  public String getErrorCode() {
    return errorCode;
  }

  public NokOk getControllerReadyStatus() {
    return controllerReadyStatus;
  }

  public NokOk getToolReadyStatus() {
    return toolReadyStatus;
  }

  public String getAlarmTime() {
    return alarmTime;
  }

  public int getBlockIdAlarmStatus() {
    return BLOCKIDALARMSTATUS;
  }

  public int getBlockIdErrorCode() {
    return BLOCKIDERRORCODE;
  }

  public int getBlockIdControllerReadyStatus() {
    return BLOCKIDCONTROLLERREADYSTATUS;
  }

  public int getBlockIdToolReadyStatus() {
    return BLOCKIDTOOLREADYSTATUS;
  }

  public int getBlockIdTime() {
    return BLOCKIDTIME;
  }

  @Override
  protected void serializeOpenProtocolMessageAlarmStatusChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageAlarmStatusRev2");

    // Const Field (blockIdAlarmStatus)
    writeConstField(
        "blockIdAlarmStatus",
        BLOCKIDALARMSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (controllerAlarmStatus)
    writeSimpleEnumField(
        "controllerAlarmStatus",
        "AlarmActiveStatus",
        controllerAlarmStatus,
        new DataWriterEnumDefault<>(
            AlarmActiveStatus::getValue,
            AlarmActiveStatus::name,
            writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdErrorCode)
    writeConstField(
        "blockIdErrorCode",
        BLOCKIDERRORCODE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (errorCode)
    writeSimpleField(
        "errorCode", errorCode, writeString(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdControllerReadyStatus)
    writeConstField(
        "blockIdControllerReadyStatus",
        BLOCKIDCONTROLLERREADYSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (controllerReadyStatus)
    writeSimpleEnumField(
        "controllerReadyStatus",
        "NokOk",
        controllerReadyStatus,
        new DataWriterEnumDefault<>(
            NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdToolReadyStatus)
    writeConstField(
        "blockIdToolReadyStatus",
        BLOCKIDTOOLREADYSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (toolReadyStatus)
    writeSimpleEnumField(
        "toolReadyStatus",
        "NokOk",
        toolReadyStatus,
        new DataWriterEnumDefault<>(
            NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTime)
    writeConstField(
        "blockIdTime",
        BLOCKIDTIME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (alarmTime)
    writeSimpleField(
        "alarmTime", alarmTime, writeString(writeBuffer, 152), WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageAlarmStatusRev2");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageAlarmStatusRev2 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (blockIdAlarmStatus)
    lengthInBits += 16;

    // Simple field (controllerAlarmStatus)
    lengthInBits += 8;

    // Const Field (blockIdErrorCode)
    lengthInBits += 16;

    // Simple field (errorCode)
    lengthInBits += 40;

    // Const Field (blockIdControllerReadyStatus)
    lengthInBits += 16;

    // Simple field (controllerReadyStatus)
    lengthInBits += 8;

    // Const Field (blockIdToolReadyStatus)
    lengthInBits += 16;

    // Simple field (toolReadyStatus)
    lengthInBits += 8;

    // Const Field (blockIdTime)
    lengthInBits += 16;

    // Simple field (alarmTime)
    lengthInBits += 152;

    return lengthInBits;
  }

  public static OpenProtocolMessageAlarmStatusBuilder
      staticParseOpenProtocolMessageAlarmStatusBuilder(ReadBuffer readBuffer, Integer revision)
          throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageAlarmStatusRev2");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockIdAlarmStatus =
        readConstField(
            "blockIdAlarmStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageAlarmStatusRev2.BLOCKIDALARMSTATUS,
            WithOption.WithEncoding("ASCII"));

    AlarmActiveStatus controllerAlarmStatus =
        readEnumField(
            "controllerAlarmStatus",
            "AlarmActiveStatus",
            new DataReaderEnumDefault<>(
                AlarmActiveStatus::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdErrorCode =
        readConstField(
            "blockIdErrorCode",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageAlarmStatusRev2.BLOCKIDERRORCODE,
            WithOption.WithEncoding("ASCII"));

    String errorCode =
        readSimpleField("errorCode", readString(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdControllerReadyStatus =
        readConstField(
            "blockIdControllerReadyStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageAlarmStatusRev2.BLOCKIDCONTROLLERREADYSTATUS,
            WithOption.WithEncoding("ASCII"));

    NokOk controllerReadyStatus =
        readEnumField(
            "controllerReadyStatus",
            "NokOk",
            new DataReaderEnumDefault<>(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdToolReadyStatus =
        readConstField(
            "blockIdToolReadyStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageAlarmStatusRev2.BLOCKIDTOOLREADYSTATUS,
            WithOption.WithEncoding("ASCII"));

    NokOk toolReadyStatus =
        readEnumField(
            "toolReadyStatus",
            "NokOk",
            new DataReaderEnumDefault<>(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTime =
        readConstField(
            "blockIdTime",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageAlarmStatusRev2.BLOCKIDTIME,
            WithOption.WithEncoding("ASCII"));

    String alarmTime =
        readSimpleField("alarmTime", readString(readBuffer, 152), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageAlarmStatusRev2");
    // Create the instance
    return new OpenProtocolMessageAlarmStatusRev2BuilderImpl(
        controllerAlarmStatus, errorCode, controllerReadyStatus, toolReadyStatus, alarmTime);
  }

  public static class OpenProtocolMessageAlarmStatusRev2BuilderImpl
      implements OpenProtocolMessageAlarmStatus.OpenProtocolMessageAlarmStatusBuilder {
    private final AlarmActiveStatus controllerAlarmStatus;
    private final String errorCode;
    private final NokOk controllerReadyStatus;
    private final NokOk toolReadyStatus;
    private final String alarmTime;

    public OpenProtocolMessageAlarmStatusRev2BuilderImpl(
        AlarmActiveStatus controllerAlarmStatus,
        String errorCode,
        NokOk controllerReadyStatus,
        NokOk toolReadyStatus,
        String alarmTime) {
      this.controllerAlarmStatus = controllerAlarmStatus;
      this.errorCode = errorCode;
      this.controllerReadyStatus = controllerReadyStatus;
      this.toolReadyStatus = toolReadyStatus;
      this.alarmTime = alarmTime;
    }

    public OpenProtocolMessageAlarmStatusRev2 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageAlarmStatusRev2 openProtocolMessageAlarmStatusRev2 =
          new OpenProtocolMessageAlarmStatusRev2(
              midRevision,
              noAckFlag,
              targetStationId,
              targetSpindleId,
              sequenceNumber,
              numberOfMessageParts,
              messagePartNumber,
              controllerAlarmStatus,
              errorCode,
              controllerReadyStatus,
              toolReadyStatus,
              alarmTime);
      return openProtocolMessageAlarmStatusRev2;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageAlarmStatusRev2)) {
      return false;
    }
    OpenProtocolMessageAlarmStatusRev2 that = (OpenProtocolMessageAlarmStatusRev2) o;
    return (getControllerAlarmStatus() == that.getControllerAlarmStatus())
        && (getErrorCode() == that.getErrorCode())
        && (getControllerReadyStatus() == that.getControllerReadyStatus())
        && (getToolReadyStatus() == that.getToolReadyStatus())
        && (getAlarmTime() == that.getAlarmTime())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getControllerAlarmStatus(),
        getErrorCode(),
        getControllerReadyStatus(),
        getToolReadyStatus(),
        getAlarmTime());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
