/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class OpenProtocolMessage implements Message {

  // Abstract accessors for discriminator values.
  public abstract Mid getMid();

  // Constant values.
  public static final Short END = 0x00;

  // Properties.
  protected final Integer midRevision;
  protected final Short noAckFlag;
  protected final Integer targetStationId;
  protected final Integer targetSpindleId;
  protected final Integer sequenceNumber;
  protected final Short numberOfMessageParts;
  protected final Short messagePartNumber;

  public OpenProtocolMessage(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber) {
    super();
    this.midRevision = midRevision;
    this.noAckFlag = noAckFlag;
    this.targetStationId = targetStationId;
    this.targetSpindleId = targetSpindleId;
    this.sequenceNumber = sequenceNumber;
    this.numberOfMessageParts = numberOfMessageParts;
    this.messagePartNumber = messagePartNumber;
  }

  public Integer getMidRevision() {
    return midRevision;
  }

  public Short getNoAckFlag() {
    return noAckFlag;
  }

  public Integer getTargetStationId() {
    return targetStationId;
  }

  public Integer getTargetSpindleId() {
    return targetSpindleId;
  }

  public Integer getSequenceNumber() {
    return sequenceNumber;
  }

  public Short getNumberOfMessageParts() {
    return numberOfMessageParts;
  }

  public Short getMessagePartNumber() {
    return messagePartNumber;
  }

  public short getEnd() {
    return END;
  }

  protected abstract void serializeOpenProtocolMessageChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessage");

    // Implicit Field (length) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    long length = (long) ((getLengthInBytes()) - (1L));
    writeImplicitField(
        "length", length, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Discriminator Field (mid) (Used as input to a switch field)
    writeDiscriminatorEnumField(
        "mid",
        "Mid",
        getMid(),
        new DataWriterEnumDefault<>(Mid::getValue, Mid::name, writeUnsignedLong(writeBuffer, 32)),
        WithOption.WithEncoding("ASCII"));

    // Optional Field (midRevision) (Can be skipped, if the value is null)
    writeOptionalField(
        "midRevision",
        midRevision,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("202020"));

    // Optional Field (noAckFlag) (Can be skipped, if the value is null)
    writeOptionalField(
        "noAckFlag",
        noAckFlag,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("20"));

    // Optional Field (targetStationId) (Can be skipped, if the value is null)
    writeOptionalField(
        "targetStationId",
        targetStationId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("2020"));

    // Optional Field (targetSpindleId) (Can be skipped, if the value is null)
    writeOptionalField(
        "targetSpindleId",
        targetSpindleId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("2020"));

    // Optional Field (sequenceNumber) (Can be skipped, if the value is null)
    writeOptionalField(
        "sequenceNumber",
        sequenceNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("2020"));

    // Optional Field (numberOfMessageParts) (Can be skipped, if the value is null)
    writeOptionalField(
        "numberOfMessageParts",
        numberOfMessageParts,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("20"));

    // Optional Field (messagePartNumber) (Can be skipped, if the value is null)
    writeOptionalField(
        "messagePartNumber",
        messagePartNumber,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithEncoding("ASCII"),
        WithOption.WithNullBytesHex("20"));

    // Switch field (Serialize the sub-type)
    serializeOpenProtocolMessageChild(writeBuffer);

    // Const Field (end)
    writeConstField("end", END, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("OpenProtocolMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    OpenProtocolMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (length)
    lengthInBits += 32;

    // Discriminator Field (mid)
    lengthInBits += 32;

    // Optional Field (midRevision)
    lengthInBits += 24;

    // Optional Field (noAckFlag)
    lengthInBits += 8;

    // Optional Field (targetStationId)
    lengthInBits += 16;

    // Optional Field (targetSpindleId)
    lengthInBits += 16;

    // Optional Field (sequenceNumber)
    lengthInBits += 16;

    // Optional Field (numberOfMessageParts)
    lengthInBits += 8;

    // Optional Field (messagePartNumber)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    // Const Field (end)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static OpenProtocolMessage staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Integer revision;
    if (args[0] instanceof Integer) {
      revision = (Integer) args[0];
    } else if (args[0] instanceof String) {
      revision = Integer.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Integer or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, revision);
  }

  public static OpenProtocolMessage staticParse(ReadBuffer readBuffer, Integer revision)
      throws ParseException {
    readBuffer.pullContext("OpenProtocolMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long length =
        readImplicitField(
            "length", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    Mid mid =
        readDiscriminatorEnumField(
            "mid",
            "Mid",
            new DataReaderEnumDefault<>(Mid::enumForValue, readUnsignedLong(readBuffer, 32)),
            WithOption.WithEncoding("ASCII"));

    Integer midRevision =
        readOptionalField(
            "midRevision",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("202020"));

    Short noAckFlag =
        readOptionalField(
            "noAckFlag",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("20"));

    Integer targetStationId =
        readOptionalField(
            "targetStationId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("2020"));

    Integer targetSpindleId =
        readOptionalField(
            "targetSpindleId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("2020"));

    Integer sequenceNumber =
        readOptionalField(
            "sequenceNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("2020"));

    Short numberOfMessageParts =
        readOptionalField(
            "numberOfMessageParts",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("20"));

    Short messagePartNumber =
        readOptionalField(
            "messagePartNumber",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithEncoding("ASCII"),
            WithOption.WithNullBytesHex("20"));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    OpenProtocolMessageBuilder builder = null;
    if (EvaluationHelper.equals(mid, Mid.ApplicationCommunicationStart)) {
      builder =
          OpenProtocolMessageApplicationCommunicationStart.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationCommunicationStartAcknowledge)) {
      builder =
          OpenProtocolMessageApplicationCommunicationStartAcknowledge
              .staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationCommunicationStop)) {
      builder =
          OpenProtocolMessageApplicationCommunicationStop.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationCommandError)) {
      builder =
          OpenProtocolMessageApplicationCommandError.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationCommandAccepted)) {
      builder =
          OpenProtocolMessageApplicationCommandAccepted.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationGenericDataRequest)) {
      builder =
          OpenProtocolMessageApplicationGenericDataRequest.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationGenericSubscription)) {
      builder =
          OpenProtocolMessageApplicationGenericSubscription.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ApplicationGenericUnsubscribe)) {
      builder =
          OpenProtocolMessageApplicationGenericUnsubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetIdUploadRequest)) {
      builder =
          OpenProtocolMessageParameterSetIdUploadRequest.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetIdUploadReply)) {
      builder =
          OpenProtocolMessageParameterSetIdUploadReply.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetDataUploadRequest)) {
      builder =
          OpenProtocolMessageParameterSetDataUploadRequest.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetDataUploadReply)) {
      builder =
          OpenProtocolMessageParameterSetDataUploadReply.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetSelectedSubscribe)) {
      builder =
          OpenProtocolMessageParameterSetSelectedSubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetSelected)) {
      builder =
          OpenProtocolMessageParameterSetSelected.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetSelectedAcknowledge)) {
      builder =
          OpenProtocolMessageParameterSetSelectedAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ParameterSetSelectedUnsubscribe)) {
      builder =
          OpenProtocolMessageParameterSetSelectedUnsubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.SelectParameterSet)) {
      builder =
          OpenProtocolMessageSelectParameterSet.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.SetParameterSetBatchSize)) {
      builder =
          OpenProtocolMessageSetParameterSetBatchSize.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ResetParameterSetBatchCounter)) {
      builder =
          OpenProtocolMessageResetParameterSetBatchCounter.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LockAtBatchDoneSubscribe)) {
      builder =
          OpenProtocolMessageLockAtBatchDoneSubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LockAtBatchDoneUpload)) {
      builder =
          OpenProtocolMessageLockAtBatchDoneUpload.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LockAtBatchDoneUploadAcknowledge)) {
      builder =
          OpenProtocolMessageLockAtBatchDoneUploadAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LockAtBatchDoneUnsubscribe)) {
      builder =
          OpenProtocolMessageLockAtBatchDoneUnsubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.DisableTool)) {
      builder =
          OpenProtocolMessageDisableTool.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.EnableTool)) {
      builder =
          OpenProtocolMessageEnableTool.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LastTighteningResultDataSubscribe)) {
      builder =
          OpenProtocolMessageLastTighteningResultDataSubscribe
              .staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LastTighteningResultData)) {
      builder =
          OpenProtocolMessageLastTighteningResultData.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.AlarmSubscribe)) {
      builder =
          OpenProtocolMessageAlarmSubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.Alarm)) {
      builder =
          OpenProtocolMessageAlarm.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.AlarmAcknowledge)) {
      builder =
          OpenProtocolMessageAlarmAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.AlarmUnsubscribe)) {
      builder =
          OpenProtocolMessageAlarmUnsubscribe.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.AlarmStatus)) {
      builder =
          OpenProtocolMessageAlarmStatus.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.AlarmStatusAcknowledge)) {
      builder =
          OpenProtocolMessageAlarmStatusAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.SetTime)) {
      builder =
          OpenProtocolMessageSetTime.staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ExecuteDynamicJobRequest)) {
      builder =
          OpenProtocolMessageExecuteDynamicJobRequest.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.IdentifierDownloadRequest)) {
      builder =
          OpenProtocolMessageIdentifierDownloadRequest.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ResultTracesCurve)) {
      builder =
          OpenProtocolMessageResultTracesCurve.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ResultTracesCurvePlotData)) {
      builder =
          OpenProtocolMessageResultTracesCurvePlotData.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.ProgramPsetSelectionInDynamicJob)) {
      builder =
          OpenProtocolMessageProgramPsetSelectionInDynamicJob.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.DynamicPsetSelection)) {
      builder =
          OpenProtocolMessageDynamicPsetSelection.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LinkLevelPositiveAcknowledge)) {
      builder =
          OpenProtocolMessageLinkLevelPositiveAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.LinkLevelNegativeAcknowledge)) {
      builder =
          OpenProtocolMessageLinkLevelNegativeAcknowledge.staticParseOpenProtocolMessageBuilder(
              readBuffer, revision);
    } else if (EvaluationHelper.equals(mid, Mid.KeepAliveOpenProtocolCommunication)) {
      builder =
          OpenProtocolMessageKeepAliveOpenProtocolCommunication
              .staticParseOpenProtocolMessageBuilder(readBuffer, revision);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type" + " parameters [" + "mid=" + mid + "]");
    }

    short end = readConstField("end", readUnsignedShort(readBuffer, 8), OpenProtocolMessage.END);

    readBuffer.closeContext("OpenProtocolMessage");
    // Create the instance
    OpenProtocolMessage _openProtocolMessage =
        builder.build(
            midRevision,
            noAckFlag,
            targetStationId,
            targetSpindleId,
            sequenceNumber,
            numberOfMessageParts,
            messagePartNumber);
    return _openProtocolMessage;
  }

  public interface OpenProtocolMessageBuilder {
    OpenProtocolMessage build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessage)) {
      return false;
    }
    OpenProtocolMessage that = (OpenProtocolMessage) o;
    return (getMidRevision() == that.getMidRevision())
        && (getNoAckFlag() == that.getNoAckFlag())
        && (getTargetStationId() == that.getTargetStationId())
        && (getTargetSpindleId() == that.getTargetSpindleId())
        && (getSequenceNumber() == that.getSequenceNumber())
        && (getNumberOfMessageParts() == that.getNumberOfMessageParts())
        && (getMessagePartNumber() == that.getMessagePartNumber())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getMidRevision(),
        getNoAckFlag(),
        getTargetStationId(),
        getTargetSpindleId(),
        getSequenceNumber(),
        getNumberOfMessageParts(),
        getMessagePartNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
