/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SetTriggeringResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "778";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final int noOfAddResults;
  protected final List<StatusCode> addResults;
  protected final int noOfAddDiagnosticInfos;
  protected final List<DiagnosticInfo> addDiagnosticInfos;
  protected final int noOfRemoveResults;
  protected final List<StatusCode> removeResults;
  protected final int noOfRemoveDiagnosticInfos;
  protected final List<DiagnosticInfo> removeDiagnosticInfos;

  public SetTriggeringResponse(
      ExtensionObjectDefinition responseHeader,
      int noOfAddResults,
      List<StatusCode> addResults,
      int noOfAddDiagnosticInfos,
      List<DiagnosticInfo> addDiagnosticInfos,
      int noOfRemoveResults,
      List<StatusCode> removeResults,
      int noOfRemoveDiagnosticInfos,
      List<DiagnosticInfo> removeDiagnosticInfos) {
    super();
    this.responseHeader = responseHeader;
    this.noOfAddResults = noOfAddResults;
    this.addResults = addResults;
    this.noOfAddDiagnosticInfos = noOfAddDiagnosticInfos;
    this.addDiagnosticInfos = addDiagnosticInfos;
    this.noOfRemoveResults = noOfRemoveResults;
    this.removeResults = removeResults;
    this.noOfRemoveDiagnosticInfos = noOfRemoveDiagnosticInfos;
    this.removeDiagnosticInfos = removeDiagnosticInfos;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public int getNoOfAddResults() {
    return noOfAddResults;
  }

  public List<StatusCode> getAddResults() {
    return addResults;
  }

  public int getNoOfAddDiagnosticInfos() {
    return noOfAddDiagnosticInfos;
  }

  public List<DiagnosticInfo> getAddDiagnosticInfos() {
    return addDiagnosticInfos;
  }

  public int getNoOfRemoveResults() {
    return noOfRemoveResults;
  }

  public List<StatusCode> getRemoveResults() {
    return removeResults;
  }

  public int getNoOfRemoveDiagnosticInfos() {
    return noOfRemoveDiagnosticInfos;
  }

  public List<DiagnosticInfo> getRemoveDiagnosticInfos() {
    return removeDiagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SetTriggeringResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfAddResults)
    writeSimpleField("noOfAddResults", noOfAddResults, writeSignedInt(writeBuffer, 32));

    // Array Field (addResults)
    writeComplexTypeArrayField("addResults", addResults, writeBuffer);

    // Simple Field (noOfAddDiagnosticInfos)
    writeSimpleField(
        "noOfAddDiagnosticInfos", noOfAddDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (addDiagnosticInfos)
    writeComplexTypeArrayField("addDiagnosticInfos", addDiagnosticInfos, writeBuffer);

    // Simple Field (noOfRemoveResults)
    writeSimpleField("noOfRemoveResults", noOfRemoveResults, writeSignedInt(writeBuffer, 32));

    // Array Field (removeResults)
    writeComplexTypeArrayField("removeResults", removeResults, writeBuffer);

    // Simple Field (noOfRemoveDiagnosticInfos)
    writeSimpleField(
        "noOfRemoveDiagnosticInfos", noOfRemoveDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (removeDiagnosticInfos)
    writeComplexTypeArrayField("removeDiagnosticInfos", removeDiagnosticInfos, writeBuffer);

    writeBuffer.popContext("SetTriggeringResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SetTriggeringResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (noOfAddResults)
    lengthInBits += 32;

    // Array field
    if (addResults != null) {
      int i = 0;
      for (StatusCode element : addResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= addResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfAddDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (addDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : addDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= addDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfRemoveResults)
    lengthInBits += 32;

    // Array field
    if (removeResults != null) {
      int i = 0;
      for (StatusCode element : removeResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= removeResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfRemoveDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (removeDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : removeDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= removeDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("SetTriggeringResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    int noOfAddResults = readSimpleField("noOfAddResults", readSignedInt(readBuffer, 32));

    List<StatusCode> addResults =
        readCountArrayField(
            "addResults",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfAddResults);

    int noOfAddDiagnosticInfos =
        readSimpleField("noOfAddDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> addDiagnosticInfos =
        readCountArrayField(
            "addDiagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfAddDiagnosticInfos);

    int noOfRemoveResults = readSimpleField("noOfRemoveResults", readSignedInt(readBuffer, 32));

    List<StatusCode> removeResults =
        readCountArrayField(
            "removeResults",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfRemoveResults);

    int noOfRemoveDiagnosticInfos =
        readSimpleField("noOfRemoveDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> removeDiagnosticInfos =
        readCountArrayField(
            "removeDiagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfRemoveDiagnosticInfos);

    readBuffer.closeContext("SetTriggeringResponse");
    // Create the instance
    return new SetTriggeringResponseBuilderImpl(
        responseHeader,
        noOfAddResults,
        addResults,
        noOfAddDiagnosticInfos,
        addDiagnosticInfos,
        noOfRemoveResults,
        removeResults,
        noOfRemoveDiagnosticInfos,
        removeDiagnosticInfos);
  }

  public static class SetTriggeringResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final int noOfAddResults;
    private final List<StatusCode> addResults;
    private final int noOfAddDiagnosticInfos;
    private final List<DiagnosticInfo> addDiagnosticInfos;
    private final int noOfRemoveResults;
    private final List<StatusCode> removeResults;
    private final int noOfRemoveDiagnosticInfos;
    private final List<DiagnosticInfo> removeDiagnosticInfos;

    public SetTriggeringResponseBuilderImpl(
        ExtensionObjectDefinition responseHeader,
        int noOfAddResults,
        List<StatusCode> addResults,
        int noOfAddDiagnosticInfos,
        List<DiagnosticInfo> addDiagnosticInfos,
        int noOfRemoveResults,
        List<StatusCode> removeResults,
        int noOfRemoveDiagnosticInfos,
        List<DiagnosticInfo> removeDiagnosticInfos) {
      this.responseHeader = responseHeader;
      this.noOfAddResults = noOfAddResults;
      this.addResults = addResults;
      this.noOfAddDiagnosticInfos = noOfAddDiagnosticInfos;
      this.addDiagnosticInfos = addDiagnosticInfos;
      this.noOfRemoveResults = noOfRemoveResults;
      this.removeResults = removeResults;
      this.noOfRemoveDiagnosticInfos = noOfRemoveDiagnosticInfos;
      this.removeDiagnosticInfos = removeDiagnosticInfos;
    }

    public SetTriggeringResponse build() {
      SetTriggeringResponse setTriggeringResponse =
          new SetTriggeringResponse(
              responseHeader,
              noOfAddResults,
              addResults,
              noOfAddDiagnosticInfos,
              addDiagnosticInfos,
              noOfRemoveResults,
              removeResults,
              noOfRemoveDiagnosticInfos,
              removeDiagnosticInfos);
      return setTriggeringResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SetTriggeringResponse)) {
      return false;
    }
    SetTriggeringResponse that = (SetTriggeringResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getNoOfAddResults() == that.getNoOfAddResults())
        && (getAddResults() == that.getAddResults())
        && (getNoOfAddDiagnosticInfos() == that.getNoOfAddDiagnosticInfos())
        && (getAddDiagnosticInfos() == that.getAddDiagnosticInfos())
        && (getNoOfRemoveResults() == that.getNoOfRemoveResults())
        && (getRemoveResults() == that.getRemoveResults())
        && (getNoOfRemoveDiagnosticInfos() == that.getNoOfRemoveDiagnosticInfos())
        && (getRemoveDiagnosticInfos() == that.getRemoveDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getNoOfAddResults(),
        getAddResults(),
        getNoOfAddDiagnosticInfos(),
        getAddDiagnosticInfos(),
        getNoOfRemoveResults(),
        getRemoveResults(),
        getNoOfRemoveDiagnosticInfos(),
        getRemoveDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
