/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class Payload implements Message {

  // Abstract accessors for discriminator values.
  public abstract Boolean getExtensible();

  // Properties.
  protected final SequenceHeader sequenceHeader;

  public Payload(SequenceHeader sequenceHeader) {
    super();
    this.sequenceHeader = sequenceHeader;
  }

  public SequenceHeader getSequenceHeader() {
    return sequenceHeader;
  }

  protected abstract void serializePayloadChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Payload");

    // Simple Field (sequenceHeader)
    writeSimpleField("sequenceHeader", sequenceHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Switch field (Serialize the sub-type)
    serializePayloadChild(writeBuffer);

    writeBuffer.popContext("Payload");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Payload _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (sequenceHeader)
    lengthInBits += sequenceHeader.getLengthInBits();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static Payload staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 2)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 2, but got " + args.length);
    }
    Boolean extensible;
    if (args[0] instanceof Boolean) {
      extensible = (Boolean) args[0];
    } else if (args[0] instanceof String) {
      extensible = Boolean.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Boolean or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    Long byteCount;
    if (args[1] instanceof Long) {
      byteCount = (Long) args[1];
    } else if (args[1] instanceof String) {
      byteCount = Long.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type Long or a string which is parseable but was "
              + args[1].getClass().getName());
    }
    return staticParse(readBuffer, extensible, byteCount);
  }

  public static Payload staticParse(ReadBuffer readBuffer, Boolean extensible, Long byteCount)
      throws ParseException {
    readBuffer.pullContext("Payload");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    SequenceHeader sequenceHeader =
        readSimpleField(
            "sequenceHeader",
            new DataReaderComplexDefault<>(
                () -> SequenceHeader.staticParse(readBuffer), readBuffer));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    PayloadBuilder builder = null;
    if (EvaluationHelper.equals(extensible, (boolean) true)) {
      builder = ExtensiblePayload.staticParsePayloadBuilder(readBuffer, extensible, byteCount);
    } else if (EvaluationHelper.equals(extensible, (boolean) false)) {
      builder = BinaryPayload.staticParsePayloadBuilder(readBuffer, extensible, byteCount);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "extensible="
              + extensible
              + "]");
    }

    readBuffer.closeContext("Payload");
    // Create the instance
    Payload _payload = builder.build(sequenceHeader);
    return _payload;
  }

  public interface PayloadBuilder {
    Payload build(SequenceHeader sequenceHeader);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Payload)) {
      return false;
    }
    Payload that = (Payload) o;
    return (getSequenceHeader() == that.getSequenceHeader()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSequenceHeader());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
