/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ApduData implements Message {

  // Abstract accessors for discriminator values.
  public abstract Byte getApciType();

  public ApduData() {
    super();
  }

  protected abstract void serializeApduDataChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduData");

    // Discriminator Field (apciType) (Used as input to a switch field)
    writeDiscriminatorField("apciType", getApciType(), writeUnsignedByte(writeBuffer, 4));

    // Switch field (Serialize the sub-type)
    serializeApduDataChild(writeBuffer);

    writeBuffer.popContext("ApduData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ApduData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (apciType)
    lengthInBits += 4;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ApduData staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Short dataLength;
    if (args[0] instanceof Short) {
      dataLength = (Short) args[0];
    } else if (args[0] instanceof String) {
      dataLength = Short.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Short or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, dataLength);
  }

  public static ApduData staticParse(ReadBuffer readBuffer, Short dataLength)
      throws ParseException {
    readBuffer.pullContext("ApduData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte apciType = readDiscriminatorField("apciType", readUnsignedByte(readBuffer, 4));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ApduDataBuilder builder = null;
    if (EvaluationHelper.equals(apciType, (byte) 0x0)) {
      builder = ApduDataGroupValueRead.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x1)) {
      builder = ApduDataGroupValueResponse.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x2)) {
      builder = ApduDataGroupValueWrite.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x3)) {
      builder = ApduDataIndividualAddressWrite.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x4)) {
      builder = ApduDataIndividualAddressRead.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x5)) {
      builder =
          ApduDataIndividualAddressResponse.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x6)) {
      builder = ApduDataAdcRead.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x7)) {
      builder = ApduDataAdcResponse.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x8)) {
      builder = ApduDataMemoryRead.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0x9)) {
      builder = ApduDataMemoryResponse.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xA)) {
      builder = ApduDataMemoryWrite.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xB)) {
      builder = ApduDataUserMessage.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xC)) {
      builder = ApduDataDeviceDescriptorRead.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xD)) {
      builder = ApduDataDeviceDescriptorResponse.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xE)) {
      builder = ApduDataRestart.staticParseApduDataBuilder(readBuffer, dataLength);
    } else if (EvaluationHelper.equals(apciType, (byte) 0xF)) {
      builder = ApduDataOther.staticParseApduDataBuilder(readBuffer, dataLength);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "apciType="
              + apciType
              + "]");
    }

    readBuffer.closeContext("ApduData");
    // Create the instance
    ApduData _apduData = builder.build();
    return _apduData;
  }

  public interface ApduDataBuilder {
    ApduData build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduData)) {
      return false;
    }
    ApduData that = (ApduData) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
