/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_STEP_POSITION_INFORMATION
    extends InformationObjectWithoutTime implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.STEP_POSITION_INFORMATION;
  }

  // Properties.
  protected final ValueWithTransientStateIndication vti;
  protected final QualityDescriptor qds;

  public InformationObjectWithoutTime_STEP_POSITION_INFORMATION(
      int address, ValueWithTransientStateIndication vti, QualityDescriptor qds) {
    super(address);
    this.vti = vti;
    this.qds = qds;
  }

  public ValueWithTransientStateIndication getVti() {
    return vti;
  }

  public QualityDescriptor getQds() {
    return qds;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_STEP_POSITION_INFORMATION");

    // Simple Field (vti)
    writeSimpleField(
        "vti",
        vti,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (qds)
    writeSimpleField(
        "qds",
        qds,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_STEP_POSITION_INFORMATION");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_STEP_POSITION_INFORMATION _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (vti)
    lengthInBits += vti.getLengthInBits();

    // Simple field (qds)
    lengthInBits += qds.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_STEP_POSITION_INFORMATION");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ValueWithTransientStateIndication vti =
        readSimpleField(
            "vti",
            new DataReaderComplexDefault<>(
                () -> ValueWithTransientStateIndication.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    QualityDescriptor qds =
        readSimpleField(
            "qds",
            new DataReaderComplexDefault<>(
                () -> QualityDescriptor.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_STEP_POSITION_INFORMATION");
    // Create the instance
    return new InformationObjectWithoutTime_STEP_POSITION_INFORMATIONBuilderImpl(vti, qds);
  }

  public static class InformationObjectWithoutTime_STEP_POSITION_INFORMATIONBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final ValueWithTransientStateIndication vti;
    private final QualityDescriptor qds;

    public InformationObjectWithoutTime_STEP_POSITION_INFORMATIONBuilderImpl(
        ValueWithTransientStateIndication vti, QualityDescriptor qds) {
      this.vti = vti;
      this.qds = qds;
    }

    public InformationObjectWithoutTime_STEP_POSITION_INFORMATION build(int address) {
      InformationObjectWithoutTime_STEP_POSITION_INFORMATION
          informationObjectWithoutTime_STEP_POSITION_INFORMATION =
              new InformationObjectWithoutTime_STEP_POSITION_INFORMATION(address, vti, qds);
      return informationObjectWithoutTime_STEP_POSITION_INFORMATION;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_STEP_POSITION_INFORMATION)) {
      return false;
    }
    InformationObjectWithoutTime_STEP_POSITION_INFORMATION that =
        (InformationObjectWithoutTime_STEP_POSITION_INFORMATION) o;
    return (getVti() == that.getVti()) && (getQds() == that.getQds()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getVti(), getQds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
