/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class StatusRequest implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final byte statusType;

  public StatusRequest(byte statusType) {
    super();
    this.statusType = statusType;
  }

  public byte getStatusType() {
    return statusType;
  }

  protected abstract void serializeStatusRequestChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("StatusRequest");

    // Switch field (Serialize the sub-type)
    serializeStatusRequestChild(writeBuffer);

    writeBuffer.popContext("StatusRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    StatusRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static StatusRequest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static StatusRequest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("StatusRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte statusType = readPeekField("statusType", readByte(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    StatusRequestBuilder builder = null;
    if (EvaluationHelper.equals(statusType, (byte) 0x7A)) {
      builder = StatusRequestBinaryState.staticParseStatusRequestBuilder(readBuffer);
    } else if (EvaluationHelper.equals(statusType, (byte) 0xFA)) {
      builder = StatusRequestBinaryStateDeprecated.staticParseStatusRequestBuilder(readBuffer);
    } else if (EvaluationHelper.equals(statusType, (byte) 0x73)) {
      builder = StatusRequestLevel.staticParseStatusRequestBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "statusType="
              + statusType
              + "]");
    }

    readBuffer.closeContext("StatusRequest");
    // Create the instance
    StatusRequest _statusRequest = builder.build(statusType);
    return _statusRequest;
  }

  public interface StatusRequestBuilder {
    StatusRequest build(byte statusType);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof StatusRequest)) {
      return false;
    }
    StatusRequest that = (StatusRequest) o;
    return (getStatusType() == that.getStatusType()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getStatusType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
