/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RequestSmartConnectShortcut extends Request implements Message {

  // Accessors for discriminator values.

  // Constant values.
  public static final Byte PIPE = 0x7C;

  // Properties.
  protected final RequestType pipePeek;
  protected final Byte secondPipe;

  // Arguments.
  protected final CBusOptions cBusOptions;

  public RequestSmartConnectShortcut(
      RequestType peekedByte,
      RequestType startingCR,
      RequestType resetMode,
      RequestType secondPeek,
      RequestTermination termination,
      RequestType pipePeek,
      Byte secondPipe,
      CBusOptions cBusOptions) {
    super(peekedByte, startingCR, resetMode, secondPeek, termination, cBusOptions);
    this.pipePeek = pipePeek;
    this.secondPipe = secondPipe;
    this.cBusOptions = cBusOptions;
  }

  public RequestType getPipePeek() {
    return pipePeek;
  }

  public Byte getSecondPipe() {
    return secondPipe;
  }

  public byte getPipe() {
    return PIPE;
  }

  @Override
  protected void serializeRequestChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("RequestSmartConnectShortcut");

    // Const Field (pipe)
    writeConstField("pipe", PIPE, writeByte(writeBuffer, 8));

    // Optional Field (secondPipe) (Can be skipped, if the value is null)
    writeOptionalField(
        "secondPipe",
        secondPipe,
        writeByte(writeBuffer, 8),
        (getPipePeek()) == (RequestType.SMART_CONNECT_SHORTCUT));

    writeBuffer.popContext("RequestSmartConnectShortcut");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    RequestSmartConnectShortcut _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (pipe)
    lengthInBits += 8;

    // Optional Field (secondPipe)
    if (secondPipe != null) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static RequestBuilder staticParseRequestBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions) throws ParseException {
    readBuffer.pullContext("RequestSmartConnectShortcut");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte pipe = readConstField("pipe", readByte(readBuffer, 8), RequestSmartConnectShortcut.PIPE);

    RequestType pipePeek =
        readPeekField(
            "pipePeek",
            new DataReaderEnumDefault<>(
                RequestType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Byte secondPipe =
        readOptionalField(
            "secondPipe",
            readByte(readBuffer, 8),
            (pipePeek) == (RequestType.SMART_CONNECT_SHORTCUT));

    readBuffer.closeContext("RequestSmartConnectShortcut");
    // Create the instance
    return new RequestSmartConnectShortcutBuilderImpl(pipePeek, secondPipe, cBusOptions);
  }

  public static class RequestSmartConnectShortcutBuilderImpl implements Request.RequestBuilder {
    private final RequestType pipePeek;
    private final Byte secondPipe;
    private final CBusOptions cBusOptions;

    public RequestSmartConnectShortcutBuilderImpl(
        RequestType pipePeek, Byte secondPipe, CBusOptions cBusOptions) {
      this.pipePeek = pipePeek;
      this.secondPipe = secondPipe;
      this.cBusOptions = cBusOptions;
    }

    public RequestSmartConnectShortcut build(
        RequestType peekedByte,
        RequestType startingCR,
        RequestType resetMode,
        RequestType secondPeek,
        RequestTermination termination,
        CBusOptions cBusOptions) {
      RequestSmartConnectShortcut requestSmartConnectShortcut =
          new RequestSmartConnectShortcut(
              peekedByte,
              startingCR,
              resetMode,
              secondPeek,
              termination,
              pipePeek,
              secondPipe,
              cBusOptions);
      return requestSmartConnectShortcut;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RequestSmartConnectShortcut)) {
      return false;
    }
    RequestSmartConnectShortcut that = (RequestSmartConnectShortcut) o;
    return (getPipePeek() == that.getPipePeek())
        && (getSecondPipe() == that.getSecondPipe())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPipePeek(), getSecondPipe());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
