/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CBusPointToPointCommand implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final int bridgeAddressCountPeek;
  protected final CALData calData;

  // Arguments.
  protected final CBusOptions cBusOptions;

  public CBusPointToPointCommand(
      int bridgeAddressCountPeek, CALData calData, CBusOptions cBusOptions) {
    super();
    this.bridgeAddressCountPeek = bridgeAddressCountPeek;
    this.calData = calData;
    this.cBusOptions = cBusOptions;
  }

  public int getBridgeAddressCountPeek() {
    return bridgeAddressCountPeek;
  }

  public CALData getCalData() {
    return calData;
  }

  public boolean getIsDirect() {
    return (boolean) ((((getBridgeAddressCountPeek()) & (0x00FF))) == (0x0000));
  }

  protected abstract void serializeCBusPointToPointCommandChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CBusPointToPointCommand");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isDirect = getIsDirect();
    writeBuffer.writeVirtual("isDirect", isDirect);

    // Switch field (Serialize the sub-type)
    serializeCBusPointToPointCommandChild(writeBuffer);

    // Simple Field (calData)
    writeSimpleField("calData", calData, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("CBusPointToPointCommand");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CBusPointToPointCommand _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    // Simple field (calData)
    lengthInBits += calData.getLengthInBits();

    return lengthInBits;
  }

  public static CBusPointToPointCommand staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    CBusOptions cBusOptions;
    if (args[0] instanceof CBusOptions) {
      cBusOptions = (CBusOptions) args[0];
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type CBusOptions or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, cBusOptions);
  }

  public static CBusPointToPointCommand staticParse(ReadBuffer readBuffer, CBusOptions cBusOptions)
      throws ParseException {
    readBuffer.pullContext("CBusPointToPointCommand");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int bridgeAddressCountPeek =
        readPeekField("bridgeAddressCountPeek", readUnsignedInt(readBuffer, 16));
    boolean isDirect =
        readVirtualField(
            "isDirect", boolean.class, (((bridgeAddressCountPeek) & (0x00FF))) == (0x0000));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CBusPointToPointCommandBuilder builder = null;
    if (EvaluationHelper.equals(isDirect, (boolean) true)) {
      builder =
          CBusPointToPointCommandDirect.staticParseCBusPointToPointCommandBuilder(
              readBuffer, cBusOptions);
    } else if (EvaluationHelper.equals(isDirect, (boolean) false)) {
      builder =
          CBusPointToPointCommandIndirect.staticParseCBusPointToPointCommandBuilder(
              readBuffer, cBusOptions);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "isDirect="
              + isDirect
              + "]");
    }

    CALData calData =
        readSimpleField(
            "calData",
            new DataReaderComplexDefault<>(
                () -> CALData.staticParse(readBuffer, (RequestContext) (null)), readBuffer));

    readBuffer.closeContext("CBusPointToPointCommand");
    // Create the instance
    CBusPointToPointCommand _cBusPointToPointCommand =
        builder.build(bridgeAddressCountPeek, calData, cBusOptions);
    return _cBusPointToPointCommand;
  }

  public interface CBusPointToPointCommandBuilder {
    CBusPointToPointCommand build(
        int bridgeAddressCountPeek, CALData calData, CBusOptions cBusOptions);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CBusPointToPointCommand)) {
      return false;
    }
    CBusPointToPointCommand that = (CBusPointToPointCommand) o;
    return (getBridgeAddressCountPeek() == that.getBridgeAddressCountPeek())
        && (getCalData() == that.getCalData())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getBridgeAddressCountPeek(), getCalData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
