/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CBusMessageToServer extends CBusMessage implements Message {

  // Accessors for discriminator values.
  public Boolean getIsResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final Request request;

  // Arguments.
  protected final RequestContext requestContext;
  protected final CBusOptions cBusOptions;

  public CBusMessageToServer(
      Request request, RequestContext requestContext, CBusOptions cBusOptions) {
    super(requestContext, cBusOptions);
    this.request = request;
    this.requestContext = requestContext;
    this.cBusOptions = cBusOptions;
  }

  public Request getRequest() {
    return request;
  }

  @Override
  protected void serializeCBusMessageChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CBusMessageToServer");

    // Simple Field (request)
    writeSimpleField("request", request, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("CBusMessageToServer");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CBusMessageToServer _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (request)
    lengthInBits += request.getLengthInBits();

    return lengthInBits;
  }

  public static CBusMessageBuilder staticParseCBusMessageBuilder(
      ReadBuffer readBuffer,
      Boolean isResponse,
      RequestContext requestContext,
      CBusOptions cBusOptions)
      throws ParseException {
    readBuffer.pullContext("CBusMessageToServer");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Request request =
        readSimpleField(
            "request",
            new DataReaderComplexDefault<>(
                () -> Request.staticParse(readBuffer, (CBusOptions) (cBusOptions)), readBuffer));

    readBuffer.closeContext("CBusMessageToServer");
    // Create the instance
    return new CBusMessageToServerBuilderImpl(request, requestContext, cBusOptions);
  }

  public static class CBusMessageToServerBuilderImpl implements CBusMessage.CBusMessageBuilder {
    private final Request request;
    private final RequestContext requestContext;
    private final CBusOptions cBusOptions;

    public CBusMessageToServerBuilderImpl(
        Request request, RequestContext requestContext, CBusOptions cBusOptions) {
      this.request = request;
      this.requestContext = requestContext;
      this.cBusOptions = cBusOptions;
    }

    public CBusMessageToServer build(RequestContext requestContext, CBusOptions cBusOptions) {

      CBusMessageToServer cBusMessageToServer =
          new CBusMessageToServer(request, requestContext, cBusOptions);
      return cBusMessageToServer;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CBusMessageToServer)) {
      return false;
    }
    CBusMessageToServer that = (CBusMessageToServer) o;
    return (getRequest() == that.getRequest()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRequest());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
