/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CBusMessage implements Message {

  // Abstract accessors for discriminator values.
  public abstract Boolean getIsResponse();

  // Arguments.
  protected final RequestContext requestContext;
  protected final CBusOptions cBusOptions;

  public CBusMessage(RequestContext requestContext, CBusOptions cBusOptions) {
    super();
    this.requestContext = requestContext;
    this.cBusOptions = cBusOptions;
  }

  protected abstract void serializeCBusMessageChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CBusMessage");

    // Switch field (Serialize the sub-type)
    serializeCBusMessageChild(writeBuffer);

    writeBuffer.popContext("CBusMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CBusMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static CBusMessage staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 3)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 3, but got " + args.length);
    }
    Boolean isResponse;
    if (args[0] instanceof Boolean) {
      isResponse = (Boolean) args[0];
    } else if (args[0] instanceof String) {
      isResponse = Boolean.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Boolean or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    RequestContext requestContext;
    if (args[1] instanceof RequestContext) {
      requestContext = (RequestContext) args[1];
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type RequestContext or a string which is parseable but was "
              + args[1].getClass().getName());
    }
    CBusOptions cBusOptions;
    if (args[2] instanceof CBusOptions) {
      cBusOptions = (CBusOptions) args[2];
    } else {
      throw new PlcRuntimeException(
          "Argument 2 expected to be of type CBusOptions or a string which is parseable but was "
              + args[2].getClass().getName());
    }
    return staticParse(readBuffer, isResponse, requestContext, cBusOptions);
  }

  public static CBusMessage staticParse(
      ReadBuffer readBuffer,
      Boolean isResponse,
      RequestContext requestContext,
      CBusOptions cBusOptions)
      throws ParseException {
    readBuffer.pullContext("CBusMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    // Validation
    if (!((requestContext) != (null))) {
      throw new ParseValidationException("requestContext required");
    }
    // Validation
    if (!((cBusOptions) != (null))) {
      throw new ParseValidationException("cBusOptions required");
    }

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CBusMessageBuilder builder = null;
    if (EvaluationHelper.equals(isResponse, (boolean) false)) {
      builder =
          CBusMessageToServer.staticParseCBusMessageBuilder(
              readBuffer, isResponse, requestContext, cBusOptions);
    } else if (EvaluationHelper.equals(isResponse, (boolean) true)) {
      builder =
          CBusMessageToClient.staticParseCBusMessageBuilder(
              readBuffer, isResponse, requestContext, cBusOptions);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "isResponse="
              + isResponse
              + "]");
    }

    readBuffer.closeContext("CBusMessage");
    // Create the instance
    CBusMessage _cBusMessage = builder.build(requestContext, cBusOptions);

    return _cBusMessage;
  }

  public interface CBusMessageBuilder {
    CBusMessage build(RequestContext requestContext, CBusOptions cBusOptions);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CBusMessage)) {
      return false;
    }
    CBusMessage that = (CBusMessage) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
