/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AirConditioningDataZoneHumidityPlantStatus extends AirConditioningData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte zoneGroup;
  protected final HVACZoneList zoneList;
  protected final HVACHumidityType humidityType;
  protected final HVACHumidityStatusFlags humidityStatus;
  protected final HVACHumidityError humidityErrorCode;

  public AirConditioningDataZoneHumidityPlantStatus(
      AirConditioningCommandTypeContainer commandTypeContainer,
      byte zoneGroup,
      HVACZoneList zoneList,
      HVACHumidityType humidityType,
      HVACHumidityStatusFlags humidityStatus,
      HVACHumidityError humidityErrorCode) {
    super(commandTypeContainer);
    this.zoneGroup = zoneGroup;
    this.zoneList = zoneList;
    this.humidityType = humidityType;
    this.humidityStatus = humidityStatus;
    this.humidityErrorCode = humidityErrorCode;
  }

  public byte getZoneGroup() {
    return zoneGroup;
  }

  public HVACZoneList getZoneList() {
    return zoneList;
  }

  public HVACHumidityType getHumidityType() {
    return humidityType;
  }

  public HVACHumidityStatusFlags getHumidityStatus() {
    return humidityStatus;
  }

  public HVACHumidityError getHumidityErrorCode() {
    return humidityErrorCode;
  }

  @Override
  protected void serializeAirConditioningDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AirConditioningDataZoneHumidityPlantStatus");

    // Simple Field (zoneGroup)
    writeSimpleField("zoneGroup", zoneGroup, writeByte(writeBuffer, 8));

    // Simple Field (zoneList)
    writeSimpleField("zoneList", zoneList, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (humidityType)
    writeSimpleEnumField(
        "humidityType",
        "HVACHumidityType",
        humidityType,
        new DataWriterEnumDefault<>(
            HVACHumidityType::getValue,
            HVACHumidityType::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (humidityStatus)
    writeSimpleField("humidityStatus", humidityStatus, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (humidityErrorCode)
    writeSimpleEnumField(
        "humidityErrorCode",
        "HVACHumidityError",
        humidityErrorCode,
        new DataWriterEnumDefault<>(
            HVACHumidityError::getValue,
            HVACHumidityError::name,
            writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("AirConditioningDataZoneHumidityPlantStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AirConditioningDataZoneHumidityPlantStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (zoneGroup)
    lengthInBits += 8;

    // Simple field (zoneList)
    lengthInBits += zoneList.getLengthInBits();

    // Simple field (humidityType)
    lengthInBits += 8;

    // Simple field (humidityStatus)
    lengthInBits += humidityStatus.getLengthInBits();

    // Simple field (humidityErrorCode)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static AirConditioningDataBuilder staticParseAirConditioningDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AirConditioningDataZoneHumidityPlantStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte zoneGroup = readSimpleField("zoneGroup", readByte(readBuffer, 8));

    HVACZoneList zoneList =
        readSimpleField(
            "zoneList",
            new DataReaderComplexDefault<>(() -> HVACZoneList.staticParse(readBuffer), readBuffer));

    HVACHumidityType humidityType =
        readEnumField(
            "humidityType",
            "HVACHumidityType",
            new DataReaderEnumDefault<>(
                HVACHumidityType::enumForValue, readUnsignedShort(readBuffer, 8)));

    HVACHumidityStatusFlags humidityStatus =
        readSimpleField(
            "humidityStatus",
            new DataReaderComplexDefault<>(
                () -> HVACHumidityStatusFlags.staticParse(readBuffer), readBuffer));

    HVACHumidityError humidityErrorCode =
        readEnumField(
            "humidityErrorCode",
            "HVACHumidityError",
            new DataReaderEnumDefault<>(
                HVACHumidityError::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("AirConditioningDataZoneHumidityPlantStatus");
    // Create the instance
    return new AirConditioningDataZoneHumidityPlantStatusBuilderImpl(
        zoneGroup, zoneList, humidityType, humidityStatus, humidityErrorCode);
  }

  public static class AirConditioningDataZoneHumidityPlantStatusBuilderImpl
      implements AirConditioningData.AirConditioningDataBuilder {
    private final byte zoneGroup;
    private final HVACZoneList zoneList;
    private final HVACHumidityType humidityType;
    private final HVACHumidityStatusFlags humidityStatus;
    private final HVACHumidityError humidityErrorCode;

    public AirConditioningDataZoneHumidityPlantStatusBuilderImpl(
        byte zoneGroup,
        HVACZoneList zoneList,
        HVACHumidityType humidityType,
        HVACHumidityStatusFlags humidityStatus,
        HVACHumidityError humidityErrorCode) {
      this.zoneGroup = zoneGroup;
      this.zoneList = zoneList;
      this.humidityType = humidityType;
      this.humidityStatus = humidityStatus;
      this.humidityErrorCode = humidityErrorCode;
    }

    public AirConditioningDataZoneHumidityPlantStatus build(
        AirConditioningCommandTypeContainer commandTypeContainer) {
      AirConditioningDataZoneHumidityPlantStatus airConditioningDataZoneHumidityPlantStatus =
          new AirConditioningDataZoneHumidityPlantStatus(
              commandTypeContainer,
              zoneGroup,
              zoneList,
              humidityType,
              humidityStatus,
              humidityErrorCode);
      return airConditioningDataZoneHumidityPlantStatus;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AirConditioningDataZoneHumidityPlantStatus)) {
      return false;
    }
    AirConditioningDataZoneHumidityPlantStatus that =
        (AirConditioningDataZoneHumidityPlantStatus) o;
    return (getZoneGroup() == that.getZoneGroup())
        && (getZoneList() == that.getZoneList())
        && (getHumidityType() == that.getHumidityType())
        && (getHumidityStatus() == that.getHumidityStatus())
        && (getHumidityErrorCode() == that.getHumidityErrorCode())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getZoneGroup(),
        getZoneList(),
        getHumidityType(),
        getHumidityStatus(),
        getHumidityErrorCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
