/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AirConditioningDataSetPlantHumidityLevel extends AirConditioningData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte zoneGroup;
  protected final HVACZoneList zoneList;
  protected final HVACHumidityModeAndFlags humidityModeAndFlags;
  protected final HVACHumidityType humidityType;
  protected final HVACHumidity level;
  protected final HVACRawLevels rawLevel;
  protected final HVACAuxiliaryLevel auxLevel;

  public AirConditioningDataSetPlantHumidityLevel(
      AirConditioningCommandTypeContainer commandTypeContainer,
      byte zoneGroup,
      HVACZoneList zoneList,
      HVACHumidityModeAndFlags humidityModeAndFlags,
      HVACHumidityType humidityType,
      HVACHumidity level,
      HVACRawLevels rawLevel,
      HVACAuxiliaryLevel auxLevel) {
    super(commandTypeContainer);
    this.zoneGroup = zoneGroup;
    this.zoneList = zoneList;
    this.humidityModeAndFlags = humidityModeAndFlags;
    this.humidityType = humidityType;
    this.level = level;
    this.rawLevel = rawLevel;
    this.auxLevel = auxLevel;
  }

  public byte getZoneGroup() {
    return zoneGroup;
  }

  public HVACZoneList getZoneList() {
    return zoneList;
  }

  public HVACHumidityModeAndFlags getHumidityModeAndFlags() {
    return humidityModeAndFlags;
  }

  public HVACHumidityType getHumidityType() {
    return humidityType;
  }

  public HVACHumidity getLevel() {
    return level;
  }

  public HVACRawLevels getRawLevel() {
    return rawLevel;
  }

  public HVACAuxiliaryLevel getAuxLevel() {
    return auxLevel;
  }

  @Override
  protected void serializeAirConditioningDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AirConditioningDataSetPlantHumidityLevel");

    // Simple Field (zoneGroup)
    writeSimpleField("zoneGroup", zoneGroup, writeByte(writeBuffer, 8));

    // Simple Field (zoneList)
    writeSimpleField("zoneList", zoneList, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (humidityModeAndFlags)
    writeSimpleField(
        "humidityModeAndFlags", humidityModeAndFlags, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (humidityType)
    writeSimpleEnumField(
        "humidityType",
        "HVACHumidityType",
        humidityType,
        new DataWriterEnumDefault<>(
            HVACHumidityType::getValue,
            HVACHumidityType::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Optional Field (level) (Can be skipped, if the value is null)
    writeOptionalField(
        "level",
        level,
        new DataWriterComplexDefault<>(writeBuffer),
        getHumidityModeAndFlags().getIsLevelHumidity());

    // Optional Field (rawLevel) (Can be skipped, if the value is null)
    writeOptionalField(
        "rawLevel",
        rawLevel,
        new DataWriterComplexDefault<>(writeBuffer),
        getHumidityModeAndFlags().getIsLevelRaw());

    // Optional Field (auxLevel) (Can be skipped, if the value is null)
    writeOptionalField(
        "auxLevel",
        auxLevel,
        new DataWriterComplexDefault<>(writeBuffer),
        getHumidityModeAndFlags().getIsAuxLevelUsed());

    writeBuffer.popContext("AirConditioningDataSetPlantHumidityLevel");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AirConditioningDataSetPlantHumidityLevel _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (zoneGroup)
    lengthInBits += 8;

    // Simple field (zoneList)
    lengthInBits += zoneList.getLengthInBits();

    // Simple field (humidityModeAndFlags)
    lengthInBits += humidityModeAndFlags.getLengthInBits();

    // Simple field (humidityType)
    lengthInBits += 8;

    // Optional Field (level)
    if (level != null) {
      lengthInBits += level.getLengthInBits();
    }

    // Optional Field (rawLevel)
    if (rawLevel != null) {
      lengthInBits += rawLevel.getLengthInBits();
    }

    // Optional Field (auxLevel)
    if (auxLevel != null) {
      lengthInBits += auxLevel.getLengthInBits();
    }

    return lengthInBits;
  }

  public static AirConditioningDataBuilder staticParseAirConditioningDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AirConditioningDataSetPlantHumidityLevel");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte zoneGroup = readSimpleField("zoneGroup", readByte(readBuffer, 8));

    HVACZoneList zoneList =
        readSimpleField(
            "zoneList",
            new DataReaderComplexDefault<>(() -> HVACZoneList.staticParse(readBuffer), readBuffer));

    HVACHumidityModeAndFlags humidityModeAndFlags =
        readSimpleField(
            "humidityModeAndFlags",
            new DataReaderComplexDefault<>(
                () -> HVACHumidityModeAndFlags.staticParse(readBuffer), readBuffer));

    HVACHumidityType humidityType =
        readEnumField(
            "humidityType",
            "HVACHumidityType",
            new DataReaderEnumDefault<>(
                HVACHumidityType::enumForValue, readUnsignedShort(readBuffer, 8)));

    HVACHumidity level =
        readOptionalField(
            "level",
            new DataReaderComplexDefault<>(() -> HVACHumidity.staticParse(readBuffer), readBuffer),
            humidityModeAndFlags.getIsLevelHumidity());

    HVACRawLevels rawLevel =
        readOptionalField(
            "rawLevel",
            new DataReaderComplexDefault<>(() -> HVACRawLevels.staticParse(readBuffer), readBuffer),
            humidityModeAndFlags.getIsLevelRaw());

    HVACAuxiliaryLevel auxLevel =
        readOptionalField(
            "auxLevel",
            new DataReaderComplexDefault<>(
                () -> HVACAuxiliaryLevel.staticParse(readBuffer), readBuffer),
            humidityModeAndFlags.getIsAuxLevelUsed());

    readBuffer.closeContext("AirConditioningDataSetPlantHumidityLevel");
    // Create the instance
    return new AirConditioningDataSetPlantHumidityLevelBuilderImpl(
        zoneGroup, zoneList, humidityModeAndFlags, humidityType, level, rawLevel, auxLevel);
  }

  public static class AirConditioningDataSetPlantHumidityLevelBuilderImpl
      implements AirConditioningData.AirConditioningDataBuilder {
    private final byte zoneGroup;
    private final HVACZoneList zoneList;
    private final HVACHumidityModeAndFlags humidityModeAndFlags;
    private final HVACHumidityType humidityType;
    private final HVACHumidity level;
    private final HVACRawLevels rawLevel;
    private final HVACAuxiliaryLevel auxLevel;

    public AirConditioningDataSetPlantHumidityLevelBuilderImpl(
        byte zoneGroup,
        HVACZoneList zoneList,
        HVACHumidityModeAndFlags humidityModeAndFlags,
        HVACHumidityType humidityType,
        HVACHumidity level,
        HVACRawLevels rawLevel,
        HVACAuxiliaryLevel auxLevel) {
      this.zoneGroup = zoneGroup;
      this.zoneList = zoneList;
      this.humidityModeAndFlags = humidityModeAndFlags;
      this.humidityType = humidityType;
      this.level = level;
      this.rawLevel = rawLevel;
      this.auxLevel = auxLevel;
    }

    public AirConditioningDataSetPlantHumidityLevel build(
        AirConditioningCommandTypeContainer commandTypeContainer) {
      AirConditioningDataSetPlantHumidityLevel airConditioningDataSetPlantHumidityLevel =
          new AirConditioningDataSetPlantHumidityLevel(
              commandTypeContainer,
              zoneGroup,
              zoneList,
              humidityModeAndFlags,
              humidityType,
              level,
              rawLevel,
              auxLevel);
      return airConditioningDataSetPlantHumidityLevel;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AirConditioningDataSetPlantHumidityLevel)) {
      return false;
    }
    AirConditioningDataSetPlantHumidityLevel that = (AirConditioningDataSetPlantHumidityLevel) o;
    return (getZoneGroup() == that.getZoneGroup())
        && (getZoneList() == that.getZoneList())
        && (getHumidityModeAndFlags() == that.getHumidityModeAndFlags())
        && (getHumidityType() == that.getHumidityType())
        && (getLevel() == that.getLevel())
        && (getRawLevel() == that.getRawLevel())
        && (getAuxLevel() == that.getAuxLevel())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getZoneGroup(),
        getZoneList(),
        getHumidityModeAndFlags(),
        getHumidityType(),
        getLevel(),
        getRawLevel(),
        getAuxLevel());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
