/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NPDUControl implements Message {

  // Properties.
  protected final boolean messageTypeFieldPresent;
  protected final boolean destinationSpecified;
  protected final boolean sourceSpecified;
  protected final boolean expectingReply;
  protected final NPDUNetworkPriority networkPriority;

  // Reserved Fields
  private Byte reservedField0;
  private Byte reservedField1;

  public NPDUControl(
      boolean messageTypeFieldPresent,
      boolean destinationSpecified,
      boolean sourceSpecified,
      boolean expectingReply,
      NPDUNetworkPriority networkPriority) {
    super();
    this.messageTypeFieldPresent = messageTypeFieldPresent;
    this.destinationSpecified = destinationSpecified;
    this.sourceSpecified = sourceSpecified;
    this.expectingReply = expectingReply;
    this.networkPriority = networkPriority;
  }

  public boolean getMessageTypeFieldPresent() {
    return messageTypeFieldPresent;
  }

  public boolean getDestinationSpecified() {
    return destinationSpecified;
  }

  public boolean getSourceSpecified() {
    return sourceSpecified;
  }

  public boolean getExpectingReply() {
    return expectingReply;
  }

  public NPDUNetworkPriority getNetworkPriority() {
    return networkPriority;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NPDUControl");

    // Simple Field (messageTypeFieldPresent)
    writeSimpleField("messageTypeFieldPresent", messageTypeFieldPresent, writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0,
        writeUnsignedByte(writeBuffer, 1));

    // Simple Field (destinationSpecified)
    writeSimpleField("destinationSpecified", destinationSpecified, writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (byte) 0,
        writeUnsignedByte(writeBuffer, 1));

    // Simple Field (sourceSpecified)
    writeSimpleField("sourceSpecified", sourceSpecified, writeBoolean(writeBuffer));

    // Simple Field (expectingReply)
    writeSimpleField("expectingReply", expectingReply, writeBoolean(writeBuffer));

    // Simple Field (networkPriority)
    writeSimpleEnumField(
        "networkPriority",
        "NPDUNetworkPriority",
        networkPriority,
        new DataWriterEnumDefault<>(
            NPDUNetworkPriority::getValue,
            NPDUNetworkPriority::name,
            writeUnsignedByte(writeBuffer, 2)));

    writeBuffer.popContext("NPDUControl");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    NPDUControl _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageTypeFieldPresent)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (destinationSpecified)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (sourceSpecified)
    lengthInBits += 1;

    // Simple field (expectingReply)
    lengthInBits += 1;

    // Simple field (networkPriority)
    lengthInBits += 2;

    return lengthInBits;
  }

  public static NPDUControl staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static NPDUControl staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("NPDUControl");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean messageTypeFieldPresent =
        readSimpleField("messageTypeFieldPresent", readBoolean(readBuffer));

    Byte reservedField0 = readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0);

    boolean destinationSpecified = readSimpleField("destinationSpecified", readBoolean(readBuffer));

    Byte reservedField1 = readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0);

    boolean sourceSpecified = readSimpleField("sourceSpecified", readBoolean(readBuffer));

    boolean expectingReply = readSimpleField("expectingReply", readBoolean(readBuffer));

    NPDUNetworkPriority networkPriority =
        readEnumField(
            "networkPriority",
            "NPDUNetworkPriority",
            new DataReaderEnumDefault<>(
                NPDUNetworkPriority::enumForValue, readUnsignedByte(readBuffer, 2)));

    readBuffer.closeContext("NPDUControl");
    // Create the instance
    NPDUControl _nPDUControl;
    _nPDUControl =
        new NPDUControl(
            messageTypeFieldPresent,
            destinationSpecified,
            sourceSpecified,
            expectingReply,
            networkPriority);
    _nPDUControl.reservedField0 = reservedField0;
    _nPDUControl.reservedField1 = reservedField1;
    return _nPDUControl;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NPDUControl)) {
      return false;
    }
    NPDUControl that = (NPDUControl) o;
    return (getMessageTypeFieldPresent() == that.getMessageTypeFieldPresent())
        && (getDestinationSpecified() == that.getDestinationSpecified())
        && (getSourceSpecified() == that.getSourceSpecified())
        && (getExpectingReply() == that.getExpectingReply())
        && (getNetworkPriority() == that.getNetworkPriority())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getMessageTypeFieldPresent(),
        getDestinationSpecified(),
        getSourceSpecified(),
        getExpectingReply(),
        getNetworkPriority());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
