/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetVendorId {
  ASHRAE((int) 0, (int) 0, (String) "ASHRAE"),
  NIST((int) 1, (int) 1, (String) "NIST"),
  THE_TRANE_COMPANY((int) 2, (int) 2, (String) "The Trane Company"),
  DAIKIN_APPLIED_AMERICAS((int) 3, (int) 3, (String) "Daikin Applied Americas"),
  POLAR_SOFT((int) 4, (int) 4, (String) "PolarSoft"),
  JOHNSON_CONTROLS_INC((int) 5, (int) 5, (String) "Johnson Controls, Inc."),
  ABB_FORMERLY_AMERICAN_AUTO_MATRIX(
      (int) 6, (int) 6, (String) "ABB (Formerly American Auto-Matrix)"),
  SIEMENS_SCHWEIZAG_FORMERLY_LANDIS_STAEFA_DIVISION_EUROPE(
      (int) 7, (int) 7, (String) "Siemens Schweiz AG (Formerly: Landis & Staefa Division Europe)"),
  DELTA_CONTROLS((int) 8, (int) 8, (String) "Delta Controls"),
  SIEMENS_SCHWEIZAG((int) 9, (int) 9, (String) "Siemens Schweiz AG"),
  SCHNEIDER_ELECTRIC((int) 10, (int) 10, (String) "Schneider Electric"),
  TAC((int) 11, (int) 11, (String) "TAC"),
  ORION_ANALYSIS_CORPORATION((int) 12, (int) 12, (String) "Orion Analysis Corporation"),
  TELETROL_SYSTEMS_INC((int) 13, (int) 13, (String) "Teletrol Systems Inc."),
  CIMETRICS_TECHNOLOGY((int) 14, (int) 14, (String) "Cimetrics Technology"),
  CORNELL_UNIVERSITY((int) 15, (int) 15, (String) "Cornell University"),
  UNITED_TECHNOLOGIES_CARRIER((int) 16, (int) 16, (String) "United Technologies Carrier"),
  HONEYWELL_INC((int) 17, (int) 17, (String) "Honeywell Inc."),
  ALERTON_HONEYWELL((int) 18, (int) 18, (String) "Alerton / Honeywell"),
  TACAB((int) 19, (int) 19, (String) "TAC AB"),
  HEWLETT_PACKARD_COMPANY((int) 20, (int) 20, (String) "Hewlett-Packard Company"),
  DORSETTES_INC((int) 21, (int) 21, (String) "Dorsette’s Inc."),
  SIEMENS_SCHWEIZAG_FORMERLY_CERBERUSAG(
      (int) 22, (int) 22, (String) "Siemens Schweiz AG (Formerly: Cerberus AG)"),
  YORK_CONTROLS_GROUP((int) 23, (int) 23, (String) "York Controls Group"),
  AUTOMATED_LOGIC_CORPORATION((int) 24, (int) 24, (String) "Automated Logic Corporation"),
  CSI_CONTROL_SYSTEMS_INTERNATIONAL(
      (int) 25, (int) 25, (String) "CSI Control Systems International"),
  PHOENIX_CONTROLS_CORPORATION((int) 26, (int) 26, (String) "Phoenix Controls Corporation"),
  INNOVEX_TECHNOLOGIES_INC((int) 27, (int) 27, (String) "Innovex Technologies, Inc."),
  KMC_CONTROLS_INC((int) 28, (int) 28, (String) "KMC Controls, Inc."),
  XN_TECHNOLOGIES_INC((int) 29, (int) 29, (String) "Xn Technologies, Inc."),
  HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD(
      (int) 30, (int) 30, (String) "Hyundai Information Technology Co., Ltd."),
  TOKIMEC_INC((int) 31, (int) 31, (String) "Tokimec Inc."),
  SIMPLEX((int) 32, (int) 32, (String) "Simplex"),
  NORTH_BUILDING_TECHNOLOGIES_LIMITED(
      (int) 33, (int) 33, (String) "North Building Technologies Limited"),
  NOTIFIER((int) 34, (int) 34, (String) "Notifier"),
  RELIABLE_CONTROLS_CORPORATION((int) 35, (int) 35, (String) "Reliable Controls Corporation"),
  TRIDIUM_INC((int) 36, (int) 36, (String) "Tridium Inc."),
  MSA_SAFETY((int) 37, (int) 37, (String) "MSA Safety"),
  SILICON_ENERGY((int) 38, (int) 38, (String) "Silicon Energy"),
  KIEBACK_PETER_GMBH_COKG((int) 39, (int) 39, (String) "Kieback & Peter GmbH & Co KG"),
  ANACON_SYSTEMS_INC((int) 40, (int) 40, (String) "Anacon Systems, Inc."),
  SYSTEMS_CONTROLS_INSTRUMENTSLLC(
      (int) 41, (int) 41, (String) "Systems Controls & Instruments, LLC"),
  ACUITY_BRANDS_LIGHTING_INC((int) 42, (int) 42, (String) "Acuity Brands Lighting, Inc."),
  MICROPOWER_MANUFACTURING((int) 43, (int) 43, (String) "Micropower Manufacturing"),
  MATRIX_CONTROLS((int) 44, (int) 44, (String) "Matrix Controls"),
  METALAIRE((int) 45, (int) 45, (String) "METALAIRE"),
  ESS_ENGINEERING((int) 46, (int) 46, (String) "ESS Engineering"),
  SPHERE_SYSTEMS_PTY_LTD((int) 47, (int) 47, (String) "Sphere Systems Pty Ltd."),
  WALKER_TECHNOLOGIES_CORPORATION((int) 48, (int) 48, (String) "Walker Technologies Corporation"),
  HI_SOLUTIONS_INC((int) 49, (int) 49, (String) "H I Solutions, Inc."),
  MBS_GMBH((int) 50, (int) 50, (String) "MBS GmbH"),
  SAMSONAG((int) 51, (int) 51, (String) "SAMSON AG"),
  BADGER_METER_INC((int) 52, (int) 52, (String) "Badger Meter Inc."),
  DAIKIN_INDUSTRIES_LTD((int) 53, (int) 53, (String) "DAIKIN Industries Ltd."),
  NARA_CONTROLS_INC((int) 54, (int) 54, (String) "NARA Controls Inc."),
  MAMMOTH_INC((int) 55, (int) 55, (String) "Mammoth Inc."),
  LIEBERT_CORPORATION((int) 56, (int) 56, (String) "Liebert Corporation"),
  SEMCO_INCORPORATED((int) 57, (int) 57, (String) "SEMCO Incorporated"),
  AIR_MONITOR_CORPORATION((int) 58, (int) 58, (String) "Air Monitor Corporation"),
  TRIATEKLLC((int) 59, (int) 59, (String) "TRIATEK, LLC"),
  NEX_LIGHT((int) 60, (int) 60, (String) "NexLight"),
  MULTISTACK((int) 61, (int) 61, (String) "Multistack"),
  TSI_INCORPORATED((int) 62, (int) 62, (String) "TSI Incorporated"),
  WEATHER_RITE_INC((int) 63, (int) 63, (String) "Weather-Rite, Inc."),
  DUNHAM_BUSH((int) 64, (int) 64, (String) "Dunham-Bush"),
  RELIANCE_ELECTRIC((int) 65, (int) 65, (String) "Reliance Electric"),
  LCS_INC((int) 66, (int) 66, (String) "LCS Inc."),
  REGULATOR_AUSTRALIAPTY_LTD((int) 67, (int) 67, (String) "Regulator Australia PTY Ltd."),
  TOUCH_PLATE_LIGHTING_CONTROLS((int) 68, (int) 68, (String) "Touch-Plate Lighting Controls"),
  AMANN_GMBH((int) 69, (int) 69, (String) "Amann GmbH"),
  RLE_TECHNOLOGIES((int) 70, (int) 70, (String) "RLE Technologies"),
  CARDKEY_SYSTEMS((int) 71, (int) 71, (String) "Cardkey Systems"),
  SECOM_CO_LTD((int) 72, (int) 72, (String) "SECOM Co., Ltd."),
  ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV(
      (int) 73, (int) 73, (String) "ABB Gebäudetechnik AG Bereich NetServ"),
  KNX_ASSOCIATIONCVBA((int) 74, (int) 74, (String) "KNX Association cvba"),
  INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ(
      (int) 75,
      (int) 75,
      (String) "Institute of Electrical Installation Engineers of Japan (IEIEJ)"),
  NOHMI_BOSAI_LTD((int) 76, (int) 76, (String) "Nohmi Bosai, Ltd."),
  CAREL_INDUSTRIES_SPA((int) 77, (int) 77, (String) "Carel Industries S.p.A."),
  UTC_FIRE_SECURITY_ESPAASL((int) 78, (int) 78, (String) "UTC Fire & Security España, S.L."),
  HOCHIKI_CORPORATION((int) 79, (int) 79, (String) "Hochiki Corporation"),
  FR_SAUTERAG((int) 80, (int) 80, (String) "Fr. Sauter AG"),
  MATSUSHITA_ELECTRIC_WORKS_LTD((int) 81, (int) 81, (String) "Matsushita Electric Works, Ltd."),
  MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS(
      (int) 82, (int) 82, (String) "Mitsubishi Electric Corporation, Inazawa Works"),
  MITSUBISHI_HEAVY_INDUSTRIES_LTD((int) 83, (int) 83, (String) "Mitsubishi Heavy Industries, Ltd."),
  XYLEM_INC((int) 84, (int) 84, (String) "Xylem, Inc."),
  YAMATAKE_BUILDING_SYSTEMS_CO_LTD(
      (int) 85, (int) 85, (String) "Yamatake Building Systems Co., Ltd."),
  THE_WATT_STOPPER_INC((int) 86, (int) 86, (String) "The Watt Stopper, Inc."),
  AICHI_TOKEI_DENKI_CO_LTD((int) 87, (int) 87, (String) "Aichi Tokei Denki Co., Ltd."),
  ACTIVATION_TECHNOLOGIESLLC((int) 88, (int) 88, (String) "Activation Technologies, LLC"),
  SAIA_BURGESS_CONTROLS_LTD((int) 89, (int) 89, (String) "Saia-Burgess Controls, Ltd."),
  HITACHI_LTD((int) 90, (int) 90, (String) "Hitachi, Ltd."),
  NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD(
      (int) 91, (int) 91, (String) "Novar Corp./Trend Control Systems Ltd."),
  MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION(
      (int) 92, (int) 92, (String) "Mitsubishi Electric Lighting Corporation"),
  ARGUS_CONTROL_SYSTEMS_LTD((int) 93, (int) 93, (String) "Argus Control Systems, Ltd."),
  KYUKI_CORPORATION((int) 94, (int) 94, (String) "Kyuki Corporation"),
  RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC(
      (int) 95, (int) 95, (String) "Richards-Zeta Building Intelligence, Inc."),
  SCIENTECHRD_INC((int) 96, (int) 96, (String) "Scientech R&D, Inc."),
  VCI_CONTROLS_INC((int) 97, (int) 97, (String) "VCI Controls, Inc."),
  TOSHIBA_CORPORATION((int) 98, (int) 98, (String) "Toshiba Corporation"),
  MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS(
      (int) 99,
      (int) 99,
      (String) "Mitsubishi Electric Corporation Air Conditioning & Refrigeration Systems Works"),
  CUSTOM_MECHANICAL_EQUIPMENTLLC((int) 100, (int) 100, (String) "Custom Mechanical Equipment, LLC"),
  CLIMATE_MASTER((int) 101, (int) 101, (String) "ClimateMaster"),
  ICP_PANEL_TEC_INC((int) 102, (int) 102, (String) "ICP Panel-Tec, Inc."),
  D_TEK_CONTROLS((int) 103, (int) 103, (String) "D-Tek Controls"),
  NEC_ENGINEERING_LTD((int) 104, (int) 104, (String) "NEC Engineering, Ltd."),
  PRIVABV((int) 105, (int) 105, (String) "PRIVA BV"),
  MEIDENSHA_CORPORATION((int) 106, (int) 106, (String) "Meidensha Corporation"),
  JCI_SYSTEMS_INTEGRATION_SERVICES(
      (int) 107, (int) 107, (String) "JCI Systems Integration Services"),
  FREEDOM_CORPORATION((int) 108, (int) 108, (String) "Freedom Corporation"),
  NEUBERGER_GEBUDEAUTOMATION_GMBH(
      (int) 109, (int) 109, (String) "Neuberger Gebäudeautomation GmbH"),
  E_ZI_CONTROLS((int) 110, (int) 110, (String) "eZi Controls"),
  LEVITON_MANUFACTURING((int) 111, (int) 111, (String) "Leviton Manufacturing"),
  FUJITSU_LIMITED((int) 112, (int) 112, (String) "Fujitsu Limited"),
  VERTIV_FORMERLY_EMERSON_NETWORK_POWER(
      (int) 113, (int) 113, (String) "Vertiv (Formerly Emerson Network Power)"),
  SA_ARMSTRONG_LTD((int) 114, (int) 114, (String) "S. A. Armstrong, Ltd."),
  VISONETAG((int) 115, (int) 115, (String) "Visonet AG"),
  MM_SYSTEMS_INC((int) 116, (int) 116, (String) "M&M Systems, Inc."),
  CUSTOM_SOFTWARE_ENGINEERING((int) 117, (int) 117, (String) "Custom Software Engineering"),
  NITTAN_COMPANY_LIMITED((int) 118, (int) 118, (String) "Nittan Company, Limited"),
  ELUTIONS_INC_WIZCON_SYSTEMSSAS(
      (int) 119, (int) 119, (String) "Elutions Inc. (Wizcon Systems SAS)"),
  PACOM_SYSTEMS_PTY_LTD((int) 120, (int) 120, (String) "Pacom Systems Pty., Ltd."),
  UNICO_INC((int) 121, (int) 121, (String) "Unico, Inc."),
  EBTRON_INC((int) 122, (int) 122, (String) "Ebtron, Inc."),
  SCADA_ENGINE((int) 123, (int) 123, (String) "Scada Engine"),
  LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION(
      (int) 124, (int) 124, (String) "Lenze Americas (Formerly: AC Technology Corporation)"),
  EAGLE_TECHNOLOGY((int) 125, (int) 125, (String) "Eagle Technology"),
  DATA_AIRE_INC((int) 126, (int) 126, (String) "Data Aire, Inc."),
  ABB_INC((int) 127, (int) 127, (String) "ABB, Inc."),
  TRANSBIT_SPZOO((int) 128, (int) 128, (String) "Transbit Sp. z o. o."),
  TOSHIBA_CARRIER_CORPORATION((int) 129, (int) 129, (String) "Toshiba Carrier Corporation"),
  SHENZHEN_JUNZHI_HI_TECH_CO_LTD(
      (int) 130, (int) 130, (String) "Shenzhen Junzhi Hi-Tech Co., Ltd."),
  TOKAI_SOFT((int) 131, (int) 131, (String) "Tokai Soft"),
  BLUE_RIDGE_TECHNOLOGIES((int) 132, (int) 132, (String) "Blue Ridge Technologies"),
  VERIS_INDUSTRIES((int) 133, (int) 133, (String) "Veris Industries"),
  CENTAURUS_PRIME((int) 134, (int) 134, (String) "Centaurus Prime"),
  SAND_NETWORK_SYSTEMS((int) 135, (int) 135, (String) "Sand Network Systems"),
  REGULVAR_INC((int) 136, (int) 136, (String) "Regulvar, Inc."),
  AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC(
      (int) 137, (int) 137, (String) "AFDtek Division of Fastek International Inc."),
  POWER_COLD_COMFORT_AIR_SOLUTIONS_INC(
      (int) 138, (int) 138, (String) "PowerCold Comfort Air Solutions, Inc."),
  I_CONTROLS((int) 139, (int) 139, (String) "I Controls"),
  VICONICS_ELECTRONICS_INC((int) 140, (int) 140, (String) "Viconics Electronics, Inc."),
  YASKAWA_AMERICA_INC((int) 141, (int) 141, (String) "Yaskawa America, Inc."),
  DEO_SCONTROLSYSTEMS_GMBH((int) 142, (int) 142, (String) "DEOS control systems GmbH"),
  DIGITALE_MESSUND_STEUERSYSTEMEAG(
      (int) 143, (int) 143, (String) "Digitale Mess- und Steuersysteme AG"),
  FUJITSU_GENERAL_LIMITED((int) 144, (int) 144, (String) "Fujitsu General Limited"),
  PROJECT_ENGINEERING_SRL((int) 145, (int) 145, (String) "Project Engineering S.r.l."),
  SANYO_ELECTRIC_CO_LTD((int) 146, (int) 146, (String) "Sanyo Electric Co., Ltd."),
  INTEGRATED_INFORMATION_SYSTEMS_INC(
      (int) 147, (int) 147, (String) "Integrated Information Systems, Inc."),
  TEMCO_CONTROLS_LTD((int) 148, (int) 148, (String) "Temco Controls, Ltd."),
  AIRTEK_INTERNATIONAL_INC((int) 149, (int) 149, (String) "Airtek International Inc."),
  ADVANTECH_CORPORATION((int) 150, (int) 150, (String) "Advantech Corporation"),
  TITAN_PRODUCTS_LTD((int) 151, (int) 151, (String) "Titan Products, Ltd."),
  REGEL_PARTNERS((int) 152, (int) 152, (String) "Regel Partners"),
  NATIONAL_ENVIRONMENTAL_PRODUCT((int) 153, (int) 153, (String) "National Environmental Product"),
  UNITEC_CORPORATION((int) 154, (int) 154, (String) "Unitec Corporation"),
  KANDEN_ENGINEERING_COMPANY((int) 155, (int) 155, (String) "Kanden Engineering Company"),
  MESSNER_GEBUDETECHNIK_GMBH((int) 156, (int) 156, (String) "Messner Gebäudetechnik GmbH"),
  INTEGRATEDCH((int) 157, (int) 157, (String) "Integrated.CH"),
  PRICE_INDUSTRIES((int) 158, (int) 158, (String) "Price Industries"),
  SE_ELEKTRONIC_GMBH((int) 159, (int) 159, (String) "SE-Elektronic GmbH"),
  ROCKWELL_AUTOMATION((int) 160, (int) 160, (String) "Rockwell Automation"),
  ENFLEX_CORP((int) 161, (int) 161, (String) "Enflex Corp."),
  ASI_CONTROLS((int) 162, (int) 162, (String) "ASI Controls"),
  SYS_MIK_GMBH_DRESDEN((int) 163, (int) 163, (String) "SysMik GmbH Dresden"),
  HSC_REGELUNGSTECHNIK_GMBH((int) 164, (int) 164, (String) "HSC Regelungstechnik GmbH"),
  SMART_TEMP_AUSTRALIA_PTY_LTD((int) 165, (int) 165, (String) "Smart Temp Australia Pty. Ltd."),
  COOPER_CONTROLS((int) 166, (int) 166, (String) "Cooper Controls"),
  DUKSAN_MECASYS_CO_LTD((int) 167, (int) 167, (String) "Duksan Mecasys Co., Ltd."),
  FUJIIT_CO_LTD((int) 168, (int) 168, (String) "Fuji IT Co., Ltd."),
  VACON_PLC((int) 169, (int) 169, (String) "Vacon Plc"),
  LEADER_CONTROLS((int) 170, (int) 170, (String) "Leader Controls"),
  ABB_FORMERLY_CYLON_CONTROLS_LTD(
      (int) 171, (int) 171, (String) "ABB (Formerly Cylon Controls, Ltd)"),
  COMPAS((int) 172, (int) 172, (String) "Compas"),
  MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD(
      (int) 173, (int) 173, (String) "Mitsubishi Electric Building Techno-Service Co., Ltd."),
  BUILDING_CONTROL_INTEGRATORS((int) 174, (int) 174, (String) "Building Control Integrators"),
  ITG_WORLDWIDEM_SDN_BHD((int) 175, (int) 175, (String) "ITG Worldwide (M) Sdn Bhd"),
  LUTRON_ELECTRONICS_CO_INC((int) 176, (int) 176, (String) "Lutron Electronics Co., Inc."),
  COOPER_ATKINS_CORPORATION((int) 177, (int) 177, (String) "Cooper-Atkins Corporation"),
  LOYTEC_ELECTRONICS_GMBH((int) 178, (int) 178, (String) "LOYTEC Electronics GmbH"),
  PRO_LON((int) 179, (int) 179, (String) "ProLon"),
  MEGA_CONTROLS_LIMITED((int) 180, (int) 180, (String) "Mega Controls Limited"),
  MICRO_CONTROL_SYSTEMS_INC((int) 181, (int) 181, (String) "Micro Control Systems, Inc."),
  KIYON_INC((int) 182, (int) 182, (String) "Kiyon, Inc."),
  DUST_NETWORKS((int) 183, (int) 183, (String) "Dust Networks"),
  ADVANCED_BUILDING_AUTOMATION_SYSTEMS(
      (int) 184, (int) 184, (String) "Advanced Building Automation Systems"),
  HERMOSAG((int) 185, (int) 185, (String) "Hermos AG"),
  CEZIM((int) 186, (int) 186, (String) "CEZIM"),
  SOFTING((int) 187, (int) 187, (String) "Softing"),
  LYNXSPRING_INC((int) 188, (int) 188, (String) "Lynxspring, Inc."),
  SCHNEIDER_TOSHIBA_INVERTER_EUROPE(
      (int) 189, (int) 189, (String) "Schneider Toshiba Inverter Europe"),
  DANFOSS_DRIVESAS((int) 190, (int) 190, (String) "Danfoss Drives A/S"),
  EATON_CORPORATION((int) 191, (int) 191, (String) "Eaton Corporation"),
  MATYCASA((int) 192, (int) 192, (String) "Matyca S.A."),
  BOTECHAB((int) 193, (int) 193, (String) "Botech AB"),
  NOVEO_INC((int) 194, (int) 194, (String) "Noveo, Inc."),
  AMEV((int) 195, (int) 195, (String) "AMEV"),
  YOKOGAWA_ELECTRIC_CORPORATION((int) 196, (int) 196, (String) "Yokogawa Electric Corporation"),
  BOSCH_BUILDING_AUTOMATION_GMBH((int) 197, (int) 197, (String) "Bosch Building Automation GmbH"),
  EXACT_LOGIC((int) 198, (int) 198, (String) "Exact Logic"),
  MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA(
      (int) 199,
      (int) 199,
      (String) "Mass Electronics Pty Ltd dba Innotech Control Systems Australia"),
  KANDENKO_CO_LTD((int) 200, (int) 200, (String) "Kandenko Co., Ltd."),
  DTF_DATEN_TECHNIK_FRIES((int) 201, (int) 201, (String) "DTF, Daten-Technik Fries"),
  KLIMASOFT_LTD((int) 202, (int) 202, (String) "Klimasoft, Ltd."),
  TOSHIBA_SCHNEIDER_INVERTER_CORPORATION(
      (int) 203, (int) 203, (String) "Toshiba Schneider Inverter Corporation"),
  CONTROL_APPLICATIONS_LTD((int) 204, (int) 204, (String) "Control Applications, Ltd."),
  CIMONCO_LTD((int) 205, (int) 205, (String) "CIMON CO., Ltd."),
  ONICON_INCORPORATED((int) 206, (int) 206, (String) "Onicon Incorporated"),
  AUTOMATION_DISPLAYS_INC((int) 207, (int) 207, (String) "Automation Displays, Inc."),
  CONTROL_SOLUTIONS_INC((int) 208, (int) 208, (String) "Control Solutions, Inc."),
  REMSDAQ_LIMITED((int) 209, (int) 209, (String) "Remsdaq Limited"),
  NTT_FACILITIES_INC((int) 210, (int) 210, (String) "NTT Facilities, Inc."),
  VIPA_GMBH((int) 211, (int) 211, (String) "VIPA GmbH"),
  TSC1_ASSOCIATIONOF_JAPAN((int) 212, (int) 212, (String) "TSC21 Association of Japan"),
  STRATO_AUTOMATION((int) 213, (int) 213, (String) "Strato Automation"),
  HRW_LIMITED((int) 214, (int) 214, (String) "HRW Limited"),
  LIGHTING_CONTROL_DESIGN_INC((int) 215, (int) 215, (String) "Lighting Control & Design, Inc."),
  MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES(
      (int) 216, (int) 216, (String) "Mercy Electronic and Electrical Industries"),
  SAMSUNGSDS_CO_LTD((int) 217, (int) 217, (String) "Samsung SDS Co., Ltd"),
  IMPACT_FACILITY_SOLUTIONS_INC((int) 218, (int) 218, (String) "Impact Facility Solutions, Inc."),
  AIRCUITY((int) 219, (int) 219, (String) "Aircuity"),
  CONTROL_TECHNIQUES_LTD((int) 220, (int) 220, (String) "Control Techniques, Ltd."),
  OPEN_GENERAL_PTY_LTD((int) 221, (int) 221, (String) "OpenGeneral Pty., Ltd."),
  WAGO_KONTAKTTECHNIK_GMBH_COKG((int) 222, (int) 222, (String) "WAGO Kontakttechnik GmbH & Co. KG"),
  FRANKLIN_ELECTRIC((int) 223, (int) 223, (String) "Franklin Electric"),
  CHLORIDE_POWER_PROTECTION_COMPANY(
      (int) 224, (int) 224, (String) "Chloride Power Protection Company"),
  COMPUTROLS_INC((int) 225, (int) 225, (String) "Computrols, Inc."),
  PHOENIX_CONTACT_GMBH_COKG((int) 226, (int) 226, (String) "Phoenix Contact GmbH & Co. KG"),
  GRUNDFOS_MANAGEMENTAS((int) 227, (int) 227, (String) "Grundfos Management A/S"),
  RIDDER_DRIVE_SYSTEMS((int) 228, (int) 228, (String) "Ridder Drive Systems"),
  SOFT_DEVICESDNBHD((int) 229, (int) 229, (String) "Soft Device SDN BHD"),
  INTEGRATED_CONTROL_TECHNOLOGY_LIMITED(
      (int) 230, (int) 230, (String) "Integrated Control Technology Limited"),
  AI_RXPERT_SYSTEMS_INC((int) 231, (int) 231, (String) "AIRxpert Systems, Inc."),
  MICROTROL_LIMITED((int) 232, (int) 232, (String) "Microtrol Limited"),
  RED_LION_CONTROLS((int) 233, (int) 233, (String) "Red Lion Controls"),
  DIGITAL_ELECTRONICS_CORPORATION((int) 234, (int) 234, (String) "Digital Electronics Corporation"),
  ENNOVATIS_GMBH((int) 235, (int) 235, (String) "Ennovatis GmbH"),
  SEROTONIN_SOFTWARE_TECHNOLOGIES_INC(
      (int) 236, (int) 236, (String) "Serotonin Software Technologies, Inc."),
  LS_INDUSTRIAL_SYSTEMS_CO_LTD((int) 237, (int) 237, (String) "LS Industrial Systems Co., Ltd."),
  SQUARED_COMPANY((int) 238, (int) 238, (String) "Square D Company"),
  S_SQUARED_INNOVATIONS_INC((int) 239, (int) 239, (String) "S Squared Innovations, Inc."),
  ARICENT_LTD((int) 240, (int) 240, (String) "Aricent Ltd."),
  ETHER_METRICSLLC((int) 241, (int) 241, (String) "EtherMetrics, LLC"),
  INDUSTRIAL_CONTROL_COMMUNICATIONS_INC(
      (int) 242, (int) 242, (String) "Industrial Control Communications, Inc."),
  PARAGON_CONTROLS_INC((int) 243, (int) 243, (String) "Paragon Controls, Inc."),
  AO_SMITH_CORPORATION((int) 244, (int) 244, (String) "A. O. Smith Corporation"),
  CONTEMPORARY_CONTROL_SYSTEMS_INC(
      (int) 245, (int) 245, (String) "Contemporary Control Systems, Inc."),
  HMS_INDUSTRIAL_NETWORKSSLU((int) 246, (int) 246, (String) "HMS Industrial Networks SLU"),
  INGENIEURGESELLSCHAFTN_HARTLEBMBH(
      (int) 247, (int) 247, (String) "Ingenieurgesellschaft N. Hartleb mbH"),
  HEAT_TIMER_CORPORATION((int) 248, (int) 248, (String) "Heat-Timer Corporation"),
  INGRASYS_TECHNOLOGY_INC((int) 249, (int) 249, (String) "Ingrasys Technology, Inc."),
  COSTERM_BUILDING_AUTOMATION((int) 250, (int) 250, (String) "Costerm Building Automation"),
  WILOSE((int) 251, (int) 251, (String) "WILO SE"),
  EMBEDIA_TECHNOLOGIES_CORP((int) 252, (int) 252, (String) "Embedia Technologies Corp."),
  TECHNILOG((int) 253, (int) 253, (String) "Technilog"),
  HR_CONTROLS_LTD_COKG((int) 254, (int) 254, (String) "HR Controls Ltd. & Co. KG"),
  LENNOX_INTERNATIONAL_INC((int) 255, (int) 255, (String) "Lennox International, Inc."),
  RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG(
      (int) 256, (int) 256, (String) "RK-Tec Rauchklappen-Steuerungssysteme GmbH & Co. KG"),
  THERMOMAX_LTD((int) 257, (int) 257, (String) "Thermomax, Ltd."),
  ELCON_ELECTRONIC_CONTROL_LTD((int) 258, (int) 258, (String) "ELCON Electronic Control, Ltd."),
  LARMIA_CONTROLAB((int) 259, (int) 259, (String) "Larmia Control AB"),
  BA_CNET_STACKAT_SOURCE_FORGE((int) 260, (int) 260, (String) "BACnet Stack at SourceForge"),
  GS_SECURITY_SERVICESAS((int) 261, (int) 261, (String) "G4S Security Services A/S"),
  EXOR_INTERNATIONAL_SPA((int) 262, (int) 262, (String) "Exor International S.p.A."),
  CRISTAL_CONTROLES((int) 263, (int) 263, (String) "Cristal Controles"),
  REGINAB((int) 264, (int) 264, (String) "Regin AB"),
  DIMENSION_SOFTWARE_INC((int) 265, (int) 265, (String) "Dimension Software, Inc."),
  SYNAP_SENSE_CORPORATION((int) 266, (int) 266, (String) "SynapSense Corporation"),
  BEIJING_NANTREE_ELECTRONIC_CO_LTD(
      (int) 267, (int) 267, (String) "Beijing Nantree Electronic Co., Ltd."),
  CAMUS_HYDRONICS_LTD((int) 268, (int) 268, (String) "Camus Hydronics Ltd."),
  KAWASAKI_HEAVY_INDUSTRIES_LTD((int) 269, (int) 269, (String) "Kawasaki Heavy Industries, Ltd."),
  CRITICAL_ENVIRONMENT_TECHNOLOGIES(
      (int) 270, (int) 270, (String) "Critical Environment Technologies"),
  ILSHINIBS_CO_LTD((int) 271, (int) 271, (String) "ILSHIN IBS Co., Ltd."),
  ELESTA_ENERGY_CONTROLAG((int) 272, (int) 272, (String) "ELESTA Energy Control AG"),
  KROPMAN_INSTALLATIETECHNIEK((int) 273, (int) 273, (String) "KROPMAN Installatietechniek"),
  BALDOR_ELECTRIC_COMPANY((int) 274, (int) 274, (String) "Baldor Electric Company"),
  ING_AMBH((int) 275, (int) 275, (String) "INGA mbH"),
  GE_CONSUMER_INDUSTRIAL((int) 276, (int) 276, (String) "GE Consumer & Industrial"),
  FUNCTIONAL_DEVICES_INC((int) 277, (int) 277, (String) "Functional Devices, Inc."),
  STUDIOSC((int) 278, (int) 278, (String) "StudioSC"),
  M_SYSTEM_CO_LTD((int) 279, (int) 279, (String) "M-System Co., Ltd."),
  YOKOTA_CO_LTD((int) 280, (int) 280, (String) "Yokota Co., Ltd."),
  HITRANSE_TECHNOLOGY_COLTD((int) 281, (int) 281, (String) "Hitranse Technology Co., LTD"),
  VIGILENT_CORPORATION((int) 282, (int) 282, (String) "Vigilent Corporation"),
  KELE_INC((int) 283, (int) 283, (String) "Kele, Inc."),
  BELIMO_AUTOMATIONAG((int) 284, (int) 284, (String) "BELIMO Automation AG"),
  GENTEC((int) 285, (int) 285, (String) "Gentec"),
  EMBEDDED_SCIENCE_LABSLLC((int) 286, (int) 286, (String) "Embedded Science Labs, LLC"),
  PARKER_HANNIFIN_CORPORATION((int) 287, (int) 287, (String) "Parker Hannifin Corporation"),
  MA_CAPS_INTERNATIONAL_LIMITED((int) 288, (int) 288, (String) "MaCaPS International Limited"),
  LINK_CORPORATION((int) 289, (int) 289, (String) "Link4 Corporation"),
  ROMUTEC_STEUERU_REGELSYSTEME_GMBH(
      (int) 290, (int) 290, (String) "Romutec Steuer-u. Regelsysteme GmbH"),
  PRIBUSIN_INC((int) 291, (int) 291, (String) "Pribusin, Inc."),
  ADVANTAGE_CONTROLS((int) 292, (int) 292, (String) "Advantage Controls"),
  CRITICAL_ROOM_CONTROL((int) 293, (int) 293, (String) "Critical Room Control"),
  LEGRAND((int) 294, (int) 294, (String) "LEGRAND"),
  TONGDY_CONTROL_TECHNOLOGY_CO_LTD(
      (int) 295, (int) 295, (String) "Tongdy Control Technology Co., Ltd."),
  ISSARO_INTEGRIERTE_SYSTEMTECHNIK(
      (int) 296, (int) 296, (String) "ISSARO Integrierte Systemtechnik"),
  PRO_DEV_INDUSTRIES((int) 297, (int) 297, (String) "Pro-Dev Industries"),
  DRISTEEM((int) 298, (int) 298, (String) "DRI-STEEM"),
  CREATIVE_ELECTRONIC_GMBH((int) 299, (int) 299, (String) "Creative Electronic GmbH"),
  SWEGONAB((int) 300, (int) 300, (String) "Swegon AB"),
  FIRVEN_ASRO((int) 301, (int) 301, (String) "FIRVENA s.r.o."),
  HITACHI_APPLIANCES_INC((int) 302, (int) 302, (String) "Hitachi Appliances, Inc."),
  REAL_TIME_AUTOMATION_INC((int) 303, (int) 303, (String) "Real Time Automation, Inc."),
  ITEC_HANKYU_HANSHIN_CO((int) 304, (int) 304, (String) "ITEC Hankyu-Hanshin Co."),
  CYRUSEM_ENGINEERING_CO_LTD((int) 305, (int) 305, (String) "Cyrus E&M Engineering Co., Ltd."),
  BADGER_METER((int) 306, (int) 306, (String) "Badger Meter"),
  CIRRASCALE_CORPORATION((int) 307, (int) 307, (String) "Cirrascale Corporation"),
  ELESTA_GMBH_BUILDING_AUTOMATION((int) 308, (int) 308, (String) "Elesta GmbH Building Automation"),
  SECURITON((int) 309, (int) 309, (String) "Securiton"),
  O_SLSOFT_INC((int) 310, (int) 310, (String) "OSlsoft, Inc."),
  HANAZEDER_ELECTRONIC_GMBH((int) 311, (int) 311, (String) "Hanazeder Electronic GmbH"),
  HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH(
      (int) 312, (int) 312, (String) "Honeywell Security Deutschland, Novar GmbH"),
  SIEMENS_INDUSTRY_INC((int) 313, (int) 313, (String) "Siemens Industry, Inc."),
  ETM_PROFESSIONAL_CONTROL_GMBH((int) 314, (int) 314, (String) "ETM Professional Control GmbH"),
  MEITAVTEC_LTD((int) 315, (int) 315, (String) "Meitav-tec, Ltd."),
  JANITZA_ELECTRONICS_GMBH((int) 316, (int) 316, (String) "Janitza Electronics GmbH"),
  MKS_NORDHAUSEN((int) 317, (int) 317, (String) "MKS Nordhausen"),
  DE_GIER_DRIVE_SYSTEMSBV((int) 318, (int) 318, (String) "De Gier Drive Systems B.V."),
  CYPRESS_ENVIROSYSTEMS((int) 319, (int) 319, (String) "Cypress Envirosystems"),
  SMAR_TRONSRO((int) 320, (int) 320, (String) "SMARTron s.r.o."),
  VERARI_SYSTEMS_INC((int) 321, (int) 321, (String) "Verari Systems, Inc."),
  KW_ELECTRONIC_SERVICE_INC((int) 322, (int) 322, (String) "K-W Electronic Service, Inc."),
  ALFASMART_ENERGY_MANAGEMENT((int) 323, (int) 323, (String) "ALFA-SMART Energy Management"),
  TELKONET_INC((int) 324, (int) 324, (String) "Telkonet, Inc."),
  SECURITON_GMBH((int) 325, (int) 325, (String) "Securiton GmbH"),
  CEMTREX_INC((int) 326, (int) 326, (String) "Cemtrex, Inc."),
  PERFORMANCE_TECHNOLOGIES_INC((int) 327, (int) 327, (String) "Performance Technologies, Inc."),
  XTRALIS_AUST_PTY_LTD((int) 328, (int) 328, (String) "Xtralis (Aust) Pty Ltd"),
  TROX_GMBH((int) 329, (int) 329, (String) "TROX GmbH"),
  BEIJING_HYSINE_TECHNOLOGY_CO_LTD(
      (int) 330, (int) 330, (String) "Beijing Hysine Technology Co., Ltd"),
  RCK_CONTROLS_INC((int) 331, (int) 331, (String) "RCK Controls, Inc."),
  DISTECH_CONTROLSSAS((int) 332, (int) 332, (String) "Distech Controls SAS"),
  NOVAR_HONEYWELL((int) 333, (int) 333, (String) "Novar/Honeywell"),
  S_INTEGRATION_SOLUTIONS((int) 334, (int) 334, (String) "S4 Integration Solutions"),
  SCHNEIDER_ELECTRIC1((int) 335, (int) 335, (String) "Schneider Electric"),
  LHA_SYSTEMS((int) 336, (int) 336, (String) "LHA Systems"),
  GH_MENGINEERING_GROUP_INC((int) 337, (int) 337, (String) "GHM engineering Group, Inc."),
  CLLIMALUXSA((int) 338, (int) 338, (String) "Cllimalux S.A."),
  VAISALA_OYJ((int) 339, (int) 339, (String) "VAISALA Oyj"),
  COMPLEX_BEIJING_TECHNOLOGY_COLTD(
      (int) 340, (int) 340, (String) "COMPLEX (Beijing) Technology, Co., LTD."),
  SCAD_AMETRICS((int) 341, (int) 341, (String) "SCADAmetrics"),
  POWERPEGNSI_LIMITED((int) 342, (int) 342, (String) "POWERPEG NSI Limited"),
  BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC(
      (int) 343, (int) 343, (String) "BACnet Interoperability Testing Services, Inc."),
  TECOAS((int) 344, (int) 344, (String) "Teco a.s."),
  PLEXUS_TECHNOLOGY_INC((int) 345, (int) 345, (String) "Plexus Technology, Inc."),
  ENERGY_FOCUS_INC((int) 346, (int) 346, (String) "Energy Focus, Inc."),
  POWERSMITHS_INTERNATIONAL_CORP((int) 347, (int) 347, (String) "Powersmiths International Corp."),
  NICHIBEI_CO_LTD((int) 348, (int) 348, (String) "Nichibei Co., Ltd."),
  HKC_TECHNOLOGY_LTD((int) 349, (int) 349, (String) "HKC Technology Ltd."),
  OVATION_NETWORKS_INC((int) 350, (int) 350, (String) "Ovation Networks, Inc."),
  SETRA_SYSTEMS((int) 351, (int) 351, (String) "Setra Systems"),
  AVG_AUTOMATION((int) 352, (int) 352, (String) "AVG Automation"),
  ZXC_LTD((int) 353, (int) 353, (String) "ZXC Ltd."),
  BYTE_SPHERE((int) 354, (int) 354, (String) "Byte Sphere"),
  GENERITON_CO_LTD((int) 355, (int) 355, (String) "Generiton Co., Ltd."),
  HOLTER_REGELARMATUREN_GMBH_COKG(
      (int) 356, (int) 356, (String) "Holter Regelarmaturen GmbH & Co. KG"),
  BEDFORD_INSTRUMENTSLLC((int) 357, (int) 357, (String) "Bedford Instruments, LLC"),
  STANDAIR_INC((int) 358, (int) 358, (String) "Standair Inc."),
  WEG_AUTOMATIONRD((int) 359, (int) 359, (String) "WEG Automation – R&D"),
  PROLON_CONTROL_SYSTEMS_APS((int) 360, (int) 360, (String) "Prolon Control Systems ApS"),
  INNEASOFT((int) 361, (int) 361, (String) "Inneasoft"),
  CONNEX_SOFT_GMBH((int) 362, (int) 362, (String) "ConneXSoft GmbH"),
  CEAG_NOTLICHTSYSTEME_GMBH((int) 363, (int) 363, (String) "CEAG Notlichtsysteme GmbH"),
  DISTECH_CONTROLS_INC((int) 364, (int) 364, (String) "Distech Controls Inc."),
  INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE(
      (int) 365, (int) 365, (String) "Industrial Technology Research Institute"),
  ICONICS_INC((int) 366, (int) 366, (String) "ICONICS, Inc."),
  IQ_CONTROLSSC((int) 367, (int) 367, (String) "IQ Controls s.c."),
  OJ_ELECTRONICSAS((int) 368, (int) 368, (String) "OJ Electronics A/S"),
  ROLBIT_LTD((int) 369, (int) 369, (String) "Rolbit Ltd."),
  SYNAPSYS_SOLUTIONS_LTD((int) 370, (int) 370, (String) "Synapsys Solutions Ltd."),
  ACME_ENGINEERING_PROD_LTD((int) 371, (int) 371, (String) "ACME Engineering Prod. Ltd."),
  ZENER_ELECTRIC_PTY_LTD((int) 372, (int) 372, (String) "Zener Electric Pty, Ltd."),
  SELECTRONIX_INC((int) 373, (int) 373, (String) "Selectronix, Inc."),
  GORBET_BANERJEELLC((int) 374, (int) 374, (String) "Gorbet & Banerjee, LLC."),
  IME((int) 375, (int) 375, (String) "IME"),
  STEPHENH_DAWSON_COMPUTER_SERVICE(
      (int) 376, (int) 376, (String) "Stephen H. Dawson Computer Service"),
  ACCUTROLLLC((int) 377, (int) 377, (String) "Accutrol, LLC"),
  SCHNEIDER_ELEKTRONIK_GMBH((int) 378, (int) 378, (String) "Schneider Elektronik GmbH"),
  ALPHA_INNO_TEC_GMBH((int) 379, (int) 379, (String) "Alpha-Inno Tec GmbH"),
  ADM_MICRO_INC((int) 380, (int) 380, (String) "ADMMicro, Inc."),
  GREYSTONE_ENERGY_SYSTEMS_INC((int) 381, (int) 381, (String) "Greystone Energy Systems, Inc."),
  CAP_TECHNOLOGIE((int) 382, (int) 382, (String) "CAP Technologie"),
  KE_RO_SYSTEMS((int) 383, (int) 383, (String) "KeRo Systems"),
  DOMAT_CONTROL_SYSTEMSRO((int) 384, (int) 384, (String) "Domat Control System s.r.o."),
  EFEKTRONICS_PTY_LTD((int) 385, (int) 385, (String) "Efektronics Pty. Ltd."),
  HEKATRON_VERTRIEBS_GMBH((int) 386, (int) 386, (String) "Hekatron Vertriebs GmbH"),
  SECURITONAG((int) 387, (int) 387, (String) "Securiton AG"),
  CARLO_GAVAZZI_CONTROLS_SPA((int) 388, (int) 388, (String) "Carlo Gavazzi Controls SpA"),
  CHIPKIN_AUTOMATION_SYSTEMS((int) 389, (int) 389, (String) "Chipkin Automation Systems"),
  SAVANT_SYSTEMSLLC((int) 390, (int) 390, (String) "Savant Systems, LLC"),
  SIMMTRONIC_LIGHTING_CONTROLS((int) 391, (int) 391, (String) "Simmtronic Lighting Controls"),
  ABELKO_INNOVATIONAB((int) 392, (int) 392, (String) "Abelko Innovation AB"),
  SERESCO_TECHNOLOGIES_INC((int) 393, (int) 393, (String) "Seresco Technologies Inc."),
  IT_WATCHDOGS((int) 394, (int) 394, (String) "IT Watchdogs"),
  AUTOMATION_ASSIST_JAPAN_CORP((int) 395, (int) 395, (String) "Automation Assist Japan Corp."),
  THERMOKON_SENSORTECHNIK_GMBH((int) 396, (int) 396, (String) "Thermokon Sensortechnik GmbH"),
  E_GAUGE_SYSTEMSLLC((int) 397, (int) 397, (String) "EGauge Systems, LLC"),
  QUANTUM_AUTOMATIONASIAPTE_LTD(
      (int) 398, (int) 398, (String) "Quantum Automation (ASIA) PTE, Ltd."),
  TOSHIBA_LIGHTING_TECHNOLOGY_CORP(
      (int) 399, (int) 399, (String) "Toshiba Lighting & Technology Corp."),
  SPIN_ENGENHARIADE_AUTOMAO_LTDA(
      (int) 400, (int) 400, (String) "SPIN Engenharia de Automação Ltda."),
  LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD(
      (int) 401, (int) 401, (String) "Logistics Systems & Software Services India PVT. Ltd."),
  DELTA_CONTROLS_INTEGRATION_PRODUCTS(
      (int) 402, (int) 402, (String) "Delta Controls Integration Products"),
  FOCUS_MEDIA((int) 403, (int) 403, (String) "Focus Media"),
  LUM_ENERGI_INC((int) 404, (int) 404, (String) "LUMEnergi Inc."),
  KARA_SYSTEMS((int) 405, (int) 405, (String) "Kara Systems"),
  RF_CODE_INC((int) 406, (int) 406, (String) "RF Code, Inc."),
  FATEK_AUTOMATION_CORP((int) 407, (int) 407, (String) "Fatek Automation Corp."),
  JANDA_SOFTWARE_COMPANYLLC((int) 408, (int) 408, (String) "JANDA Software Company, LLC"),
  OPEN_SYSTEM_SOLUTIONS_LIMITED((int) 409, (int) 409, (String) "Open System Solutions Limited"),
  INTELEC_SYSTEMSPTY_LTD((int) 410, (int) 410, (String) "Intelec Systems PTY Ltd."),
  ECOLODGIXLLC((int) 411, (int) 411, (String) "Ecolodgix, LLC"),
  DOUGLAS_LIGHTING_CONTROLS((int) 412, (int) 412, (String) "Douglas Lighting Controls"),
  IS_ATECH_GMBH((int) 413, (int) 413, (String) "iSAtech GmbH"),
  AREAL((int) 414, (int) 414, (String) "AREAL"),
  BECKHOFF_AUTOMATION((int) 415, (int) 415, (String) "Beckhoff Automation"),
  IPAS_GMBH((int) 416, (int) 416, (String) "IPAS GmbH"),
  KE_THERM_SOLUTIONS((int) 417, (int) 417, (String) "KE2 Therm Solutions"),
  BASE_PRODUCTS((int) 418, (int) 418, (String) "Base2Products"),
  DTL_CONTROLSLLC((int) 419, (int) 419, (String) "DTL Controls, LLC"),
  INNCOM_INTERNATIONAL_INC((int) 420, (int) 420, (String) "INNCOM International, Inc."),
  METZCONNECT_GMBH((int) 421, (int) 421, (String) "METZ CONNECT GmbH"),
  GREENTROL_AUTOMATION_INC((int) 422, (int) 422, (String) "Greentrol Automation, Inc"),
  BELIMO_AUTOMATIONAG1((int) 423, (int) 423, (String) "BELIMO Automation AG"),
  SAMSUNG_HEAVY_INDUSTRIES_CO_LTD(
      (int) 424, (int) 424, (String) "Samsung Heavy Industries Co, Ltd"),
  TRIACTA_POWER_TECHNOLOGIES_INC((int) 425, (int) 425, (String) "Triacta Power Technologies, Inc."),
  GLOBESTAR_SYSTEMS((int) 426, (int) 426, (String) "Globestar Systems"),
  MLB_ADVANCED_MEDIALP((int) 427, (int) 427, (String) "MLB Advanced Media, LP"),
  SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH(
      (int) 428, (int) 428, (String) "SWG Stuckmann Wirtschaftliche Gebäudesysteme GmbH"),
  SENSOR_SWITCH((int) 429, (int) 429, (String) "SensorSwitch"),
  MULTITEK_POWER_LIMITED((int) 430, (int) 430, (String) "Multitek Power Limited"),
  AQUAMETROAG((int) 431, (int) 431, (String) "Aquametro AG"),
  LG_ELECTRONICS_INC((int) 432, (int) 432, (String) "LG Electronics Inc."),
  ELECTRONIC_THEATRE_CONTROLS_INC(
      (int) 433, (int) 433, (String) "Electronic Theatre Controls, Inc."),
  MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS(
      (int) 434, (int) 434, (String) "Mitsubishi Electric Corporation Nagoya Works"),
  DELTA_ELECTRONICS_INC((int) 435, (int) 435, (String) "Delta Electronics, Inc."),
  ELMA_KURTALJ_LTD((int) 436, (int) 436, (String) "Elma Kurtalj, Ltd."),
  TYCO_FIRE_SECURITY_GMBH((int) 437, (int) 437, (String) "Tyco Fire & Security GmbH"),
  NEDAP_SECURITY_MANAGEMENT((int) 438, (int) 438, (String) "Nedap Security Management"),
  ESC_AUTOMATION_INC((int) 439, (int) 439, (String) "ESC Automation Inc."),
  DSPYOU_LTD((int) 440, (int) 440, (String) "DSP4YOU Ltd."),
  GE_SENSINGAND_INSPECTION_TECHNOLOGIES(
      (int) 441, (int) 441, (String) "GE Sensing and Inspection Technologies"),
  EMBEDDED_SYSTEMSSIA((int) 442, (int) 442, (String) "Embedded Systems SIA"),
  BEFEGA_GMBH((int) 443, (int) 443, (String) "BEFEGA GmbH"),
  BASELINE_INC((int) 444, (int) 444, (String) "Baseline Inc."),
  KEY_ACT((int) 445, (int) 445, (String) "Key2Act"),
  OEM_CTRL((int) 446, (int) 446, (String) "OEMCtrl"),
  CLARKSON_CONTROLS_LIMITED((int) 447, (int) 447, (String) "Clarkson Controls Limited"),
  ROGERWELL_CONTROL_SYSTEM_LIMITED(
      (int) 448, (int) 448, (String) "Rogerwell Control System Limited"),
  SCL_ELEMENTS((int) 449, (int) 449, (String) "SCL Elements"),
  HITACHI_LTD1((int) 450, (int) 450, (String) "Hitachi Ltd."),
  NEWRON_SYSTEMSA((int) 451, (int) 451, (String) "Newron System SA"),
  BEVECO_GEBOUWAUTOMATISERINGBV((int) 452, (int) 452, (String) "BEVECO Gebouwautomatisering BV"),
  STREAMSIDE_SOLUTIONS((int) 453, (int) 453, (String) "Streamside Solutions"),
  YELLOWSTONE_SOFT((int) 454, (int) 454, (String) "Yellowstone Soft"),
  OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD(
      (int) 455, (int) 455, (String) "Oztech Intelligent Systems Pty Ltd."),
  NOVELAN_GMBH((int) 456, (int) 456, (String) "Novelan GmbH"),
  FLEXIM_AMERICAS_CORPORATION((int) 457, (int) 457, (String) "Flexim Americas Corporation"),
  ICPDAS_CO_LTD((int) 458, (int) 458, (String) "ICP DAS Co., Ltd."),
  CARMA_INDUSTRIES_INC((int) 459, (int) 459, (String) "CARMA Industries Inc."),
  LOG_ONE_LTD((int) 460, (int) 460, (String) "Log-One Ltd."),
  TECO_ELECTRIC_MACHINERY_CO_LTD(
      (int) 461, (int) 461, (String) "TECO Electric & Machinery Co., Ltd."),
  CONNECT_EX_INC((int) 462, (int) 462, (String) "ConnectEx, Inc."),
  TURBODDC_SDWEST((int) 463, (int) 463, (String) "Turbo DDC Südwest"),
  QUATROSENSE_ENVIRONMENTAL_LTD((int) 464, (int) 464, (String) "Quatrosense Environmental Ltd."),
  FIFTH_LIGHT_TECHNOLOGY_LTD((int) 465, (int) 465, (String) "Fifth Light Technology Ltd."),
  SCIENTIFIC_SOLUTIONS_LTD((int) 466, (int) 466, (String) "Scientific Solutions, Ltd."),
  CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD(
      (int) 467, (int) 467, (String) "Controller Area Network Solutions (M) Sdn Bhd"),
  RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH(
      (int) 468, (int) 468, (String) "RESOL – Elektronische Regelungen GmbH"),
  RPBUSLLC((int) 469, (int) 469, (String) "RPBUS LLC"),
  BRS_SISTEMAS_ELETRONICOS((int) 470, (int) 470, (String) "BRS Sistemas Eletronicos"),
  WINDOW_MASTERAS((int) 471, (int) 471, (String) "WindowMaster A/S"),
  SUNLUX_TECHNOLOGIES_LTD((int) 472, (int) 472, (String) "Sunlux Technologies Ltd."),
  MEASURLOGIC((int) 473, (int) 473, (String) "Measurlogic"),
  FRIMAT_GMBH((int) 474, (int) 474, (String) "Frimat GmbH"),
  SPIRAX_SARCO((int) 475, (int) 475, (String) "Spirax Sarco"),
  LUXTRON((int) 476, (int) 476, (String) "Luxtron"),
  RAYPAK_INC((int) 477, (int) 477, (String) "Raypak Inc"),
  AIR_MONITOR_CORPORATION1((int) 478, (int) 478, (String) "Air Monitor Corporation"),
  REGLER_OCH_WEBBTEKNIK_SVERIGEROWS(
      (int) 479, (int) 479, (String) "Regler Och Webbteknik Sverige (ROWS)"),
  INTELLIGENT_LIGHTING_CONTROLS_INC(
      (int) 480, (int) 480, (String) "Intelligent Lighting Controls Inc."),
  SANYO_ELECTRIC_INDUSTRY_CO_LTD((int) 481, (int) 481, (String) "Sanyo Electric Industry Co., Ltd"),
  E_MON_ENERGY_MONITORING_PRODUCTS(
      (int) 482, (int) 482, (String) "E-Mon Energy Monitoring Products"),
  DIGITAL_CONTROL_SYSTEMS((int) 483, (int) 483, (String) "Digital Control Systems"),
  ATI_AIRTEST_TECHNOLOGIES_INC((int) 484, (int) 484, (String) "ATI Airtest Technologies, Inc."),
  SCSSA((int) 485, (int) 485, (String) "SCS SA"),
  HMS_INDUSTRIAL_NETWORKSAB((int) 486, (int) 486, (String) "HMS Industrial Networks AB"),
  SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD(
      (int) 487, (int) 487, (String) "Shenzhen Universal Intellisys Co Ltd"),
  EK_INTELLISYS_SDN_BHD((int) 488, (int) 488, (String) "EK Intellisys Sdn Bhd"),
  SYS_COM((int) 489, (int) 489, (String) "SysCom"),
  FIRECOM_INC((int) 490, (int) 490, (String) "Firecom, Inc."),
  ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH(
      (int) 491, (int) 491, (String) "ESA Elektroschaltanlagen Grimma GmbH"),
  KUMAHIRA_CO_LTD((int) 492, (int) 492, (String) "Kumahira Co Ltd"),
  HOTRACO((int) 493, (int) 493, (String) "Hotraco"),
  SABO_ELEKTRONIK_GMBH((int) 494, (int) 494, (String) "SABO Elektronik GmbH"),
  EQUIP_TRANS((int) 495, (int) 495, (String) "Equip’Trans"),
  TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS(
      (int) 496, (int) 496, (String) "Temperature Control Specialities Co., Inc (TCS)"),
  FLOW_CON_INTERNATIONALAS((int) 497, (int) 497, (String) "FlowCon International A/S"),
  THYSSEN_KRUPP_ELEVATOR_AMERICAS((int) 498, (int) 498, (String) "ThyssenKrupp Elevator Americas"),
  ABATEMENT_TECHNOLOGIES((int) 499, (int) 499, (String) "Abatement Technologies"),
  CONTINENTAL_CONTROL_SYSTEMSLLC((int) 500, (int) 500, (String) "Continental Control Systems, LLC"),
  WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG(
      (int) 501, (int) 501, (String) "WISAG Automatisierungstechnik GmbH & Co KG"),
  EASYIO((int) 502, (int) 502, (String) "EasyIO"),
  EAP_ELECTRIC_GMBH((int) 503, (int) 503, (String) "EAP-Electric GmbH"),
  HARDMEIER((int) 504, (int) 504, (String) "Hardmeier"),
  MIRCOM_GROUPOF_COMPANIES((int) 505, (int) 505, (String) "Mircom Group of Companies"),
  QUEST_CONTROLS((int) 506, (int) 506, (String) "Quest Controls"),
  MESTEK_INC((int) 507, (int) 507, (String) "Mestek, Inc"),
  PULSE_ENERGY((int) 508, (int) 508, (String) "Pulse Energy"),
  TACHIKAWA_CORPORATION((int) 509, (int) 509, (String) "Tachikawa Corporation"),
  UNIVERSITYOF_NEBRASKA_LINCOLN((int) 510, (int) 510, (String) "University of Nebraska-Lincoln"),
  REDWOOD_SYSTEMS((int) 511, (int) 511, (String) "Redwood Systems"),
  PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH(
      (int) 512, (int) 512, (String) "PASStec Industrie-Elektronik GmbH"),
  NGEK_INC((int) 513, (int) 513, (String) "NgEK, Inc."),
  TMAC_TECHNOLOGIES((int) 514, (int) 514, (String) "t-mac Technologies"),
  JIREH_ENERGY_TECH_CO_LTD((int) 515, (int) 515, (String) "Jireh Energy Tech Co., Ltd."),
  ENLIGHTED_INC((int) 516, (int) 516, (String) "Enlighted Inc."),
  EL_PIAST_SP_ZOO((int) 517, (int) 517, (String) "El-Piast Sp. Z o.o"),
  NETX_AUTOMATION_SOFTWARE_GMBH((int) 518, (int) 518, (String) "NetxAutomation Software GmbH"),
  INVERTEK_DRIVES((int) 519, (int) 519, (String) "Invertek Drives"),
  DEUTSCHMANN_AUTOMATION_GMBH_COKG(
      (int) 520, (int) 520, (String) "Deutschmann Automation GmbH & Co. KG"),
  EMU_ELECTRONICAG((int) 521, (int) 521, (String) "EMU Electronic AG"),
  PHAEDRUS_LIMITED((int) 522, (int) 522, (String) "Phaedrus Limited"),
  SIGMATEK_GMBH_COKG((int) 523, (int) 523, (String) "Sigmatek GmbH & Co KG"),
  MARLIN_CONTROLS((int) 524, (int) 524, (String) "Marlin Controls"),
  CIRCUTORSA((int) 525, (int) 525, (String) "Circutor, SA"),
  UTC_FIRE_SECURITY((int) 526, (int) 526, (String) "UTC Fire & Security"),
  DENT_INSTRUMENTS_INC((int) 527, (int) 527, (String) "DENT Instruments, Inc."),
  FHP_MANUFACTURING_COMPANY_BOSCH_GROUP(
      (int) 528, (int) 528, (String) "FHP Manufacturing Company – Bosch Group"),
  GE_INTELLIGENT_PLATFORMS((int) 529, (int) 529, (String) "GE Intelligent Platforms"),
  INNER_RANGE_PTY_LTD((int) 530, (int) 530, (String) "Inner Range Pty Ltd"),
  GLAS_ENERGY_TECHNOLOGY((int) 531, (int) 531, (String) "GLAS Energy Technology"),
  MSR_ELECTRONIC_GMBH((int) 532, (int) 532, (String) "MSR-Electronic-GmbH"),
  ENERGY_CONTROL_SYSTEMS_INC((int) 533, (int) 533, (String) "Energy Control Systems, Inc."),
  EMT_CONTROLS((int) 534, (int) 534, (String) "EMT Controls"),
  DAINTREE((int) 535, (int) 535, (String) "Daintree"),
  EUROIC_CDOO((int) 536, (int) 536, (String) "EURO ICC d.o.o"),
  TE_CONNECTIVITY_ENERGY((int) 537, (int) 537, (String) "TE Connectivity Energy"),
  GEZE_GMBH((int) 538, (int) 538, (String) "GEZE GmbH"),
  NEC_CORPORATION((int) 539, (int) 539, (String) "NEC Corporation"),
  HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED(
      (int) 540, (int) 540, (String) "Ho Cheung International Company Limited"),
  SHARP_MANUFACTURING_SYSTEMS_CORPORATION(
      (int) 541, (int) 541, (String) "Sharp Manufacturing Systems Corporation"),
  DOTCONTROL_SAS((int) 542, (int) 542, (String) "DOT CONTROLS a.s."),
  BEACON_MEDS((int) 543, (int) 543, (String) "BeaconMedæs"),
  MIDEA_COMMERCIAL_AIRCON((int) 544, (int) 544, (String) "Midea Commercial Aircon"),
  WATT_MASTER_CONTROLS((int) 545, (int) 545, (String) "WattMaster Controls"),
  KAMSTRUPAS((int) 546, (int) 546, (String) "Kamstrup A/S"),
  CA_COMPUTER_AUTOMATION_GMBH((int) 547, (int) 547, (String) "CA Computer Automation GmbH"),
  LAARS_HEATING_SYSTEMS_COMPANY((int) 548, (int) 548, (String) "Laars Heating Systems Company"),
  HITACHI_SYSTEMS_LTD((int) 549, (int) 549, (String) "Hitachi Systems, Ltd."),
  FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD(
      (int) 550, (int) 550, (String) "Fushan AKE Electronic Engineering Co., Ltd."),
  TOSHIBA_INTERNATIONAL_CORPORATION(
      (int) 551, (int) 551, (String) "Toshiba International Corporation"),
  STARMAN_SYSTEMSLLC((int) 552, (int) 552, (String) "Starman Systems, LLC"),
  SAMSUNG_TECHWIN_CO_LTD((int) 553, (int) 553, (String) "Samsung Techwin Co., Ltd."),
  ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL(
      (int) 554, (int) 554, (String) "ISAS-Integrated Switchgear and Systems P/L"),
  OBVIUS((int) 556, (int) 556, (String) "Obvius"),
  MAREK_GUZIK((int) 557, (int) 557, (String) "Marek Guzik"),
  VORTEK_INSTRUMENTSLLC((int) 558, (int) 558, (String) "Vortek Instruments, LLC"),
  UNIVERSAL_LIGHTING_TECHNOLOGIES((int) 559, (int) 559, (String) "Universal Lighting Technologies"),
  MYERS_POWER_PRODUCTS_INC((int) 560, (int) 560, (String) "Myers Power Products, Inc."),
  VECTOR_CONTROLS_GMBH((int) 561, (int) 561, (String) "Vector Controls GmbH"),
  CRESTRON_ELECTRONICS_INC((int) 562, (int) 562, (String) "Crestron Electronics, Inc."),
  AE_CONTROLS_LIMITED((int) 563, (int) 563, (String) "A&E Controls Limited"),
  PROJEKTOMONTAZAAD((int) 564, (int) 564, (String) "Projektomontaza A.D."),
  FREEAIRE_REFRIGERATION((int) 565, (int) 565, (String) "Freeaire Refrigeration"),
  AQUA_COOLER_PTY_LIMITED((int) 566, (int) 566, (String) "Aqua Cooler Pty Limited"),
  BASIC_CONTROLS((int) 567, (int) 567, (String) "Basic Controls"),
  GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS(
      (int) 568, (int) 568, (String) "GE Measurement and Control Solutions Advanced Sensors"),
  EQUAL_NETWORKS((int) 569, (int) 569, (String) "EQUAL Networks"),
  MILLENNIAL_NET((int) 570, (int) 570, (String) "Millennial Net"),
  APLI_LTD((int) 571, (int) 571, (String) "APLI Ltd"),
  ELECTRO_INDUSTRIES_GAUGE_TECH((int) 572, (int) 572, (String) "Electro Industries/GaugeTech"),
  SANG_MYUNG_UNIVERSITY((int) 573, (int) 573, (String) "SangMyung University"),
  COPPERTREE_ANALYTICS_INC((int) 574, (int) 574, (String) "Coppertree Analytics, Inc."),
  CORE_NETIX_GMBH((int) 575, (int) 575, (String) "CoreNetiX GmbH"),
  ACUTHERM((int) 576, (int) 576, (String) "Acutherm"),
  DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH(
      (int) 577, (int) 577, (String) "Dr. Riedel Automatisierungstechnik GmbH"),
  SHINA_SYSTEM_CO_LTD((int) 578, (int) 578, (String) "Shina System Co., Ltd"),
  IQAPERTUS((int) 579, (int) 579, (String) "Iqapertus"),
  PSE_TECHNOLOGY((int) 580, (int) 580, (String) "PSE Technology"),
  BA_SYSTEMS((int) 581, (int) 581, (String) "BA Systems"),
  BTICINO((int) 582, (int) 582, (String) "BTICINO"),
  MONICO_INC((int) 583, (int) 583, (String) "Monico, Inc."),
  I_CUE((int) 584, (int) 584, (String) "iCue"),
  TEKMAR_CONTROL_SYSTEMS_LTD((int) 585, (int) 585, (String) "tekmar Control Systems Ltd."),
  CONTROL_TECHNOLOGY_CORPORATION((int) 586, (int) 586, (String) "Control Technology Corporation"),
  GFAE_GMBH((int) 587, (int) 587, (String) "GFAE GmbH"),
  BE_KA_SOFTWARE_GMBH((int) 588, (int) 588, (String) "BeKa Software GmbH"),
  ISOIL_INDUSTRIA_SPA((int) 589, (int) 589, (String) "Isoil Industria SpA"),
  HOME_SYSTEMS_CONSULTING_SPA((int) 590, (int) 590, (String) "Home Systems Consulting SpA"),
  SOCOMEC((int) 591, (int) 591, (String) "Socomec"),
  EVEREX_COMMUNICATIONS_INC((int) 592, (int) 592, (String) "Everex Communications, Inc."),
  CEIEC_ELECTRIC_TECHNOLOGY((int) 593, (int) 593, (String) "Ceiec Electric Technology"),
  ATRILA_GMBH((int) 594, (int) 594, (String) "Atrila GmbH"),
  WING_TECHS((int) 595, (int) 595, (String) "WingTechs"),
  SHENZHEN_MEK_INTELLISYS_PTE_LTD(
      (int) 596, (int) 596, (String) "Shenzhen Mek Intellisys Pte Ltd."),
  NESTFIELD_CO_LTD((int) 597, (int) 597, (String) "Nestfield Co., Ltd."),
  SWISSPHONE_TELECOMAG((int) 598, (int) 598, (String) "Swissphone Telecom AG"),
  PNTECHJSC((int) 599, (int) 599, (String) "PNTECH JSC"),
  HORNERAPGLLC((int) 600, (int) 600, (String) "Horner APG, LLC"),
  PVI_INDUSTRIESLLC((int) 601, (int) 601, (String) "PVI Industries, LLC"),
  ELACOMPIL((int) 602, (int) 602, (String) "Ela-compil"),
  PEGASUS_AUTOMATION_INTERNATIONALLLC(
      (int) 603, (int) 603, (String) "Pegasus Automation International LLC"),
  WIGHT_ELECTRONIC_SERVICES_LTD((int) 604, (int) 604, (String) "Wight Electronic Services Ltd."),
  MARCOM((int) 605, (int) 605, (String) "Marcom"),
  EXHAUSTOAS((int) 606, (int) 606, (String) "Exhausto A/S"),
  DWYER_INSTRUMENTS_INC((int) 607, (int) 607, (String) "Dwyer Instruments, Inc."),
  LINK_GMBH((int) 608, (int) 608, (String) "Link GmbH"),
  OPPERMANN_REGELGERATE_GMBH((int) 609, (int) 609, (String) "Oppermann Regelgerate GmbH"),
  NU_AIRE_INC((int) 610, (int) 610, (String) "NuAire, Inc."),
  NORTEC_HUMIDITY_INC((int) 611, (int) 611, (String) "Nortec Humidity, Inc."),
  BIGWOOD_SYSTEMS_INC((int) 612, (int) 612, (String) "Bigwood Systems, Inc."),
  ENBALA_POWER_NETWORKS((int) 613, (int) 613, (String) "Enbala Power Networks"),
  INTER_ENERGY_CO_LTD((int) 614, (int) 614, (String) "Inter Energy Co., Ltd."),
  ETC((int) 615, (int) 615, (String) "ETC"),
  COMELECSARL((int) 616, (int) 616, (String) "COMELEC S.A.R.L"),
  PYTHIA_TECHNOLOGIES((int) 617, (int) 617, (String) "Pythia Technologies"),
  TREND_POINT_SYSTEMS_INC((int) 618, (int) 618, (String) "TrendPoint Systems, Inc."),
  AWEX((int) 619, (int) 619, (String) "AWEX"),
  EUREVIA((int) 620, (int) 620, (String) "Eurevia"),
  KONGSBERGELONAS((int) 621, (int) 621, (String) "Kongsberg E-lon AS"),
  FLAKT_WOODS((int) 622, (int) 622, (String) "FlaktWoods"),
  EE_ELEKTRONIKGESMBH((int) 623, (int) 623, (String) "E + E Elektronik GES M.B.H."),
  ARC_INFORMATIQUE((int) 624, (int) 624, (String) "ARC Informatique"),
  SKIDATAAG((int) 625, (int) 625, (String) "SKIDATA AG"),
  WSW_SOLUTIONS((int) 626, (int) 626, (String) "WSW Solutions"),
  TREFON_ELECTRONIC_GMBH((int) 627, (int) 627, (String) "Trefon Electronic GmbH"),
  DONGSEO_SYSTEM((int) 628, (int) 628, (String) "Dongseo System"),
  KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD(
      (int) 629, (int) 629, (String) "Kanontec Intelligence Technology Co., Ltd."),
  EVCO_SPA((int) 630, (int) 630, (String) "EVCO S.p.A."),
  ACCUENERGY_CANADA_INC((int) 631, (int) 631, (String) "Accuenergy (Canada) Inc."),
  SOFTDEL((int) 632, (int) 632, (String) "SoftDEL"),
  ORION_ENERGY_SYSTEMS_INC((int) 633, (int) 633, (String) "Orion Energy Systems, Inc."),
  ROBOTICSWARE((int) 634, (int) 634, (String) "Roboticsware"),
  DOMIQ_SPZOO((int) 635, (int) 635, (String) "DOMIQ Sp. z o.o."),
  SOLIDYNE((int) 636, (int) 636, (String) "Solidyne"),
  ELECSYS_CORPORATION((int) 637, (int) 637, (String) "Elecsys Corporation"),
  CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED(
      (int) 638, (int) 638, (String) "Conditionaire International Pty. Limited"),
  QUEBEC_INC((int) 639, (int) 639, (String) "Quebec, Inc."),
  HOMERUN_HOLDINGS((int) 640, (int) 640, (String) "Homerun Holdings"),
  MURATA_AMERICAS((int) 641, (int) 641, (String) "Murata Americas"),
  COMPTEK((int) 642, (int) 642, (String) "Comptek"),
  WESTCO_SYSTEMS_INC((int) 643, (int) 643, (String) "Westco Systems, Inc."),
  ADVANCIS_SOFTWARE_SERVICES_GMBH(
      (int) 644, (int) 644, (String) "Advancis Software & Services GmbH"),
  INTERGRIDLLC((int) 645, (int) 645, (String) "Intergrid, LLC"),
  MARKERR_CONTROLS_INC((int) 646, (int) 646, (String) "Markerr Controls, Inc."),
  TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION(
      (int) 647, (int) 647, (String) "Toshiba Elevator and Building Systems Corporation"),
  SPECTRUM_CONTROLS_INC((int) 648, (int) 648, (String) "Spectrum Controls, Inc."),
  MKSERVICE((int) 649, (int) 649, (String) "Mkservice"),
  FOX_THERMAL_INSTRUMENTS((int) 650, (int) 650, (String) "Fox Thermal Instruments"),
  SYXTH_SENSE_LTD((int) 651, (int) 651, (String) "SyxthSense Ltd"),
  DUHA_SYSTEMSRO((int) 652, (int) 652, (String) "DUHA System S R.O."),
  NIBE((int) 653, (int) 653, (String) "NIBE"),
  MELINK_CORPORATION((int) 654, (int) 654, (String) "Melink Corporation"),
  FRITZ_HABER_INSTITUT((int) 655, (int) 655, (String) "Fritz-Haber-Institut"),
  MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS(
      (int) 656, (int) 656, (String) "MTU Onsite Energy GmbH, Gas Power Systems"),
  OMEGA_ENGINEERING_INC((int) 657, (int) 657, (String) "Omega Engineering, Inc."),
  AVELON((int) 658, (int) 658, (String) "Avelon"),
  YWIRE_TECHNOLOGIES_INC((int) 659, (int) 659, (String) "Ywire Technologies, Inc."),
  MR_ENGINEERING_CO_LTD((int) 660, (int) 660, (String) "M.R. Engineering Co., Ltd."),
  LOCHINVARLLC((int) 661, (int) 661, (String) "Lochinvar, LLC"),
  SONTAY_LIMITED((int) 662, (int) 662, (String) "Sontay Limited"),
  GRUPA_SLAWOMIR_CHELMINSKI((int) 663, (int) 663, (String) "GRUPA Slawomir Chelminski"),
  ARCH_METER_CORPORATION((int) 664, (int) 664, (String) "Arch Meter Corporation"),
  SENVA_INC((int) 665, (int) 665, (String) "Senva, Inc."),
  FM_TEC((int) 667, (int) 667, (String) "FM-Tec"),
  SYSTEMS_SPECIALISTS_INC((int) 668, (int) 668, (String) "Systems Specialists, Inc."),
  SENSE_AIR((int) 669, (int) 669, (String) "SenseAir"),
  AB_INDUSTRIE_TECHNIK_SRL((int) 670, (int) 670, (String) "AB IndustrieTechnik Srl"),
  CORTLAND_RESEARCHLLC((int) 671, (int) 671, (String) "Cortland Research, LLC"),
  MEDIA_VIEW((int) 672, (int) 672, (String) "MediaView"),
  VDA_ELETTRONICA((int) 673, (int) 673, (String) "VDA Elettronica"),
  CSS_INC((int) 674, (int) 674, (String) "CSS, Inc."),
  TEK_AIR_SYSTEMS_INC((int) 675, (int) 675, (String) "Tek-Air Systems, Inc."),
  ICDT((int) 676, (int) 676, (String) "ICDT"),
  THE_ARMSTRONG_MONITORING_CORPORATION(
      (int) 677, (int) 677, (String) "The Armstrong Monitoring Corporation"),
  DIXELL_SRL((int) 678, (int) 678, (String) "DIXELL S.r.l"),
  LEAD_SYSTEM_INC((int) 679, (int) 679, (String) "Lead System, Inc."),
  ISM_EURO_CENTERSA((int) 680, (int) 680, (String) "ISM EuroCenter S.A."),
  TDIS((int) 681, (int) 681, (String) "TDIS"),
  TRADEFIDES((int) 682, (int) 682, (String) "Trade FIDES"),
  KNRR_GMBH_EMERSON_NETWORK_POWER(
      (int) 683, (int) 683, (String) "Knürr GmbH (Emerson Network Power)"),
  RESOURCE_DATA_MANAGEMENT((int) 684, (int) 684, (String) "Resource Data Management"),
  ABIES_TECHNOLOGY_INC((int) 685, (int) 685, (String) "Abies Technology, Inc."),
  UAB_KOMFOVENT((int) 686, (int) 686, (String) "UAB Komfovent"),
  MIRAE_ELECTRICAL_MFG_CO_LTD((int) 687, (int) 687, (String) "MIRAE Electrical Mfg. Co., Ltd."),
  HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS(
      (int) 688, (int) 688, (String) "HunterDouglas Architectural Projects Scandinavia ApS"),
  RUNPAQ_GROUP_CO_LTD((int) 689, (int) 689, (String) "RUNPAQ Group Co., Ltd"),
  UNICARDSA((int) 690, (int) 690, (String) "Unicard SA"),
  IE_TECHNOLOGIES((int) 691, (int) 691, (String) "IE Technologies"),
  RUSKIN_MANUFACTURING((int) 692, (int) 692, (String) "Ruskin Manufacturing"),
  CALON_ASSOCIATES_LIMITED((int) 693, (int) 693, (String) "Calon Associates Limited"),
  CONTEC_CO_LTD((int) 694, (int) 694, (String) "Contec Co., Ltd."),
  IT_GMBH((int) 695, (int) 695, (String) "iT GmbH"),
  AUTANI_CORPORATION((int) 696, (int) 696, (String) "Autani Corporation"),
  CHRISTIAN_FORTIN((int) 697, (int) 697, (String) "Christian Fortin"),
  HDL((int) 698, (int) 698, (String) "HDL"),
  IPID_SPZOO_LIMITED((int) 699, (int) 699, (String) "IPID Sp. Z.O.O Limited"),
  FUJI_ELECTRIC_CO_LTD((int) 700, (int) 700, (String) "Fuji Electric Co., Ltd"),
  VIEW_INC((int) 701, (int) 701, (String) "View, Inc."),
  SAMSUNGS1_CORPORATION((int) 702, (int) 702, (String) "Samsung S1 Corporation"),
  NEW_LIFT((int) 703, (int) 703, (String) "New Lift"),
  VRT_SYSTEMS((int) 704, (int) 704, (String) "VRT Systems"),
  MOTION_CONTROL_ENGINEERING_INC((int) 705, (int) 705, (String) "Motion Control Engineering, Inc."),
  WEISS_KLIMATECHNIK_GMBH((int) 706, (int) 706, (String) "Weiss Klimatechnik GmbH"),
  ELKON((int) 707, (int) 707, (String) "Elkon"),
  ELIWELL_CONTROLS_SRL((int) 708, (int) 708, (String) "Eliwell Controls S.r.l."),
  JAPAN_COMPUTER_TECHNOS_CORP((int) 709, (int) 709, (String) "Japan Computer Technos Corp"),
  RATIONAL_NETWORKEHF((int) 710, (int) 710, (String) "Rational Network ehf"),
  MAGNUM_ENERGY_SOLUTIONSLLC((int) 711, (int) 711, (String) "Magnum Energy Solutions, LLC"),
  MEL_ROK((int) 712, (int) 712, (String) "MelRok"),
  VAE_GROUP((int) 713, (int) 713, (String) "VAE Group"),
  LGCNS((int) 714, (int) 714, (String) "LGCNS"),
  BERGHOF_AUTOMATIONSTECHNIK_GMBH((int) 715, (int) 715, (String) "Berghof Automationstechnik GmbH"),
  QUARK_COMMUNICATIONS_INC((int) 716, (int) 716, (String) "Quark Communications, Inc."),
  SONTEX((int) 717, (int) 717, (String) "Sontex"),
  MIVUNEAG((int) 718, (int) 718, (String) "mivune AG"),
  PANDUIT((int) 719, (int) 719, (String) "Panduit"),
  SMART_CONTROLSLLC((int) 720, (int) 720, (String) "Smart Controls, LLC"),
  COMPU_AIRE_INC((int) 721, (int) 721, (String) "Compu-Aire, Inc."),
  SIERRA((int) 722, (int) 722, (String) "Sierra"),
  PROTO_SENSE_TECHNOLOGIES((int) 723, (int) 723, (String) "ProtoSense Technologies"),
  ELTRAC_TECHNOLOGIES_PVT_LTD((int) 724, (int) 724, (String) "Eltrac Technologies Pvt Ltd"),
  BEKTAS_INVISIBLE_CONTROLS_GMBH((int) 725, (int) 725, (String) "Bektas Invisible Controls GmbH"),
  ENTELEC((int) 726, (int) 726, (String) "Entelec"),
  INNEXIV((int) 727, (int) 727, (String) "INNEXIV"),
  COVENANT((int) 728, (int) 728, (String) "Covenant"),
  DAVITORAB((int) 729, (int) 729, (String) "Davitor AB"),
  TONG_FANG_TECHNOVATOR((int) 730, (int) 730, (String) "TongFang Technovator"),
  BUILDING_ROBOTICS_INC((int) 731, (int) 731, (String) "Building Robotics, Inc."),
  HSSMSRUG((int) 732, (int) 732, (String) "HSS-MSR UG"),
  FRAM_TACKLLC((int) 733, (int) 733, (String) "FramTack LLC"),
  BL_ACOUSTICS_LTD((int) 734, (int) 734, (String) "B. L. Acoustics, Ltd."),
  TRAXXON_ROCK_DRILLS_LTD((int) 735, (int) 735, (String) "Traxxon Rock Drills, Ltd"),
  FRANKE((int) 736, (int) 736, (String) "Franke"),
  WURM_GMBH_CO((int) 737, (int) 737, (String) "Wurm GmbH & Co"),
  ADDENERGIE((int) 738, (int) 738, (String) "AddENERGIE"),
  MIRLE_AUTOMATION_CORPORATION((int) 739, (int) 739, (String) "Mirle Automation Corporation"),
  IBIS_NETWORKS((int) 740, (int) 740, (String) "Ibis Networks"),
  IDKART_ASRO((int) 741, (int) 741, (String) "ID-KARTA s.r.o."),
  ANAREN_INC((int) 742, (int) 742, (String) "Anaren, Inc."),
  SPAN_INCORPORATED((int) 743, (int) 743, (String) "Span, Incorporated"),
  BOSCH_THERMOTECHNOLOGY_CORP((int) 744, (int) 744, (String) "Bosch Thermotechnology Corp"),
  DRC_TECHNOLOGYSA((int) 745, (int) 745, (String) "DRC Technology S.A."),
  SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD(
      (int) 746, (int) 746, (String) "Shanghai Energy Building Technology Co, Ltd"),
  FRAPORTAG((int) 747, (int) 747, (String) "Fraport AG"),
  FLOWGROUP((int) 748, (int) 748, (String) "Flowgroup"),
  SKYTRON_ENERGY_GMBH((int) 749, (int) 749, (String) "Skytron Energy, GmbH"),
  ALTEL_WICHA_GOLDA_SPJ((int) 750, (int) 750, (String) "ALTEL Wicha, Golda Sp. J."),
  DRUPAL((int) 751, (int) 751, (String) "Drupal"),
  AXIOMATIC_TECHNOLOGY_LTD((int) 752, (int) 752, (String) "Axiomatic Technology, Ltd"),
  BOHNKE_PARTNER((int) 753, (int) 753, (String) "Bohnke + Partner"),
  FUNCTION1((int) 754, (int) 754, (String) "Function1"),
  OPTERGY_PTY_LTD((int) 755, (int) 755, (String) "Optergy Pty, Ltd"),
  LSI_VIRTICUS((int) 756, (int) 756, (String) "LSI Virticus"),
  KONZEPTPARK_GMBH((int) 757, (int) 757, (String) "Konzeptpark GmbH"),
  NX_LIGHTING_CONTROLS((int) 758, (int) 758, (String) "NX Lighting Controls"),
  E_CURV_INC((int) 759, (int) 759, (String) "eCurv, Inc."),
  AGNOSYS_GMBH((int) 760, (int) 760, (String) "Agnosys GmbH"),
  SHANGHAI_SUNFULL_AUTOMATION_COLTD(
      (int) 761, (int) 761, (String) "Shanghai Sunfull Automation Co., LTD"),
  KURZ_INSTRUMENTS_INC((int) 762, (int) 762, (String) "Kurz Instruments, Inc."),
  CIAS_ELETTRONICA_SRL((int) 763, (int) 763, (String) "Cias Elettronica S.r.l."),
  MULTIAQUA_INC((int) 764, (int) 764, (String) "Multiaqua, Inc."),
  BLUE_BOX((int) 765, (int) 765, (String) "BlueBox"),
  SENSIDYNE((int) 766, (int) 766, (String) "Sensidyne"),
  VIESSMANN_ELEKTRONIK_GMBH((int) 767, (int) 767, (String) "Viessmann Elektronik GmbH"),
  AD_FWEBCOMSRL((int) 768, (int) 768, (String) "ADFweb.com srl"),
  GAYLORD_INDUSTRIES((int) 769, (int) 769, (String) "Gaylord Industries"),
  MAJUR_LTD((int) 770, (int) 770, (String) "Majur Ltd."),
  SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD(
      (int) 771, (int) 771, (String) "Shanghai Huilin Technology Co., Ltd."),
  EXOTRONIC((int) 772, (int) 772, (String) "Exotronic"),
  SAFECONTRO_LSRO((int) 773, (int) 773, (String) "SAFECONTROL s.r.o."),
  AMATIS((int) 774, (int) 774, (String) "Amatis"),
  UNIVERSAL_ELECTRIC_CORPORATION((int) 775, (int) 775, (String) "Universal Electric Corporation"),
  IBA_CNET((int) 776, (int) 776, (String) "iBACnet"),
  SMARTRISE_ENGINEERING_INC((int) 778, (int) 778, (String) "Smartrise Engineering, Inc."),
  MIRATRON_INC((int) 779, (int) 779, (String) "Miratron, Inc."),
  SMART_EDGE((int) 780, (int) 780, (String) "SmartEdge"),
  MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD(
      (int) 781, (int) 781, (String) "Mitsubishi Electric Australia Pty Ltd"),
  TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD(
      (int) 782, (int) 782, (String) "Triangle Research International Ptd Ltd"),
  PRODUAL_OY((int) 783, (int) 783, (String) "Produal Oy"),
  MILESTONE_SYSTEMSAS((int) 784, (int) 784, (String) "Milestone Systems A/S"),
  TRUSTBRIDGE((int) 785, (int) 785, (String) "Trustbridge"),
  FEEDBACK_SOLUTIONS((int) 786, (int) 786, (String) "Feedback Solutions"),
  IES((int) 787, (int) 787, (String) "IES"),
  ABB_POWER_PROTECTIONSA((int) 788, (int) 788, (String) "ABB Power Protection SA"),
  RIPTIDEIO((int) 789, (int) 789, (String) "Riptide IO"),
  MESSERSCHMITT_SYSTEMSAG((int) 790, (int) 790, (String) "Messerschmitt Systems AG"),
  DEZEM_ENERGY_CONTROLLING((int) 791, (int) 791, (String) "Dezem Energy Controlling"),
  MECHO_SYSTEMS((int) 792, (int) 792, (String) "MechoSystems"),
  EVON_GMBH((int) 793, (int) 793, (String) "evon GmbH"),
  CS_LAB_GMBH((int) 794, (int) 794, (String) "CS Lab GmbH"),
  N_0_ENTERPRISES_INC((int) 795, (int) 795, (String) "8760 Enterprises, Inc."),
  TOUCHE_CONTROLS((int) 796, (int) 796, (String) "Touche Controls"),
  ONTROL_TEKNIK_MALZEME_SANVE_TICAS(
      (int) 797, (int) 797, (String) "Ontrol Teknik Malzeme San. ve Tic. A.S."),
  UNI_CONTROL_SYSTEM_SP_ZOO((int) 798, (int) 798, (String) "Uni Control System Sp. Z o.o."),
  WEIHAI_PLOUMETER_CO_LTD((int) 799, (int) 799, (String) "Weihai Ploumeter Co., Ltd"),
  ELCOM_INTERNATIONAL_PVT_LTD((int) 800, (int) 800, (String) "Elcom International Pvt. Ltd"),
  SIGNIFY((int) 801, (int) 801, (String) "Signify"),
  AUTOMATION_DIRECT((int) 802, (int) 802, (String) "AutomationDirect"),
  PARAGON_ROBOTICS((int) 803, (int) 803, (String) "Paragon Robotics"),
  SMT_SYSTEM_MODULES_TECHNOLOGYAG(
      (int) 804, (int) 804, (String) "SMT System & Modules Technology AG"),
  RADIX_IOTLLC((int) 805, (int) 805, (String) "Radix IoT LLC"),
  CMR_CONTROLS_LTD((int) 806, (int) 806, (String) "CMR Controls Ltd"),
  INNOVARI_INC((int) 807, (int) 807, (String) "Innovari, Inc."),
  ABB_CONTROL_PRODUCTS((int) 808, (int) 808, (String) "ABB Control Products"),
  GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH(
      (int) 809, (int) 809, (String) "Gesellschaft fur Gebäudeautomation mbH"),
  RODI_SYSTEMS_CORP((int) 810, (int) 810, (String) "RODI Systems Corp."),
  NEXTEK_POWER_SYSTEMS((int) 811, (int) 811, (String) "Nextek Power Systems"),
  CREATIVE_LIGHTING((int) 812, (int) 812, (String) "Creative Lighting"),
  WATER_FURNACE_INTERNATIONAL((int) 813, (int) 813, (String) "WaterFurnace International"),
  MERCURY_SECURITY((int) 814, (int) 814, (String) "Mercury Security"),
  HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD(
      (int) 815, (int) 815, (String) "Hisense (Shandong) Air-Conditioning Co., Ltd."),
  LAYERED_SOLUTIONS_INC((int) 816, (int) 816, (String) "Layered Solutions, Inc."),
  LEEGOOD_AUTOMATIC_SYSTEM_INC((int) 817, (int) 817, (String) "Leegood Automatic System, Inc."),
  SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD(
      (int) 818, (int) 818, (String) "Shanghai Restar Technology Co., Ltd."),
  REIMANN_INGENIEURBRO((int) 819, (int) 819, (String) "Reimann Ingenieurbüro"),
  LYN_TEC((int) 820, (int) 820, (String) "LynTec"),
  HTP((int) 821, (int) 821, (String) "HTP"),
  ELKOR_TECHNOLOGIES_INC((int) 822, (int) 822, (String) "Elkor Technologies, Inc."),
  BENTROL_PTY_LTD((int) 823, (int) 823, (String) "Bentrol Pty Ltd"),
  TEAM_CONTROL_OY((int) 824, (int) 824, (String) "Team-Control Oy"),
  NEXT_DEVICELLC((int) 825, (int) 825, (String) "NextDevice, LLC"),
  ISMACONTROLLI_SPA((int) 826, (int) 826, (String) "iSMA CONTROLLI S.p.a."),
  KINGI_ELECTRONICS_CO_LTD((int) 827, (int) 827, (String) "King I Electronics Co., Ltd"),
  SAMDAV((int) 828, (int) 828, (String) "SAMDAV"),
  NEXT_GEN_INDUSTRIES_PVT_LTD((int) 829, (int) 829, (String) "Next Gen Industries Pvt. Ltd."),
  ENTICLLC((int) 830, (int) 830, (String) "Entic LLC"),
  ETAP((int) 831, (int) 831, (String) "ETAP"),
  MORALLE_ELECTRONICS_LIMITED((int) 832, (int) 832, (String) "Moralle Electronics Limited"),
  LEICOMAG((int) 833, (int) 833, (String) "Leicom AG"),
  WATTS_REGULATOR_COMPANY((int) 834, (int) 834, (String) "Watts Regulator Company"),
  SC_ORBTRONICSSRL((int) 835, (int) 835, (String) "S.C. Orbtronics S.R.L."),
  GAUSSAN_TECHNOLOGIES((int) 836, (int) 836, (String) "Gaussan Technologies"),
  WE_BFACTORY_GMBH((int) 837, (int) 837, (String) "WEBfactory GmbH"),
  OCEAN_CONTROLS((int) 838, (int) 838, (String) "Ocean Controls"),
  MESSANA_AIR_RAY_CONDITIONINGSRL(
      (int) 839, (int) 839, (String) "Messana Air-Ray Conditioning s.r.l."),
  HANGZHOUBATOWN_TECHNOLOGY_CO_LTD(
      (int) 840, (int) 840, (String) "Hangzhou BATOWN Technology Co. Ltd."),
  REASONABLE_CONTROLS((int) 841, (int) 841, (String) "Reasonable Controls"),
  SERVISYS_INC((int) 842, (int) 842, (String) "Servisys, Inc."),
  HALSTRUPWALCHER_GMBH((int) 843, (int) 843, (String) "halstrup-walcher GmbH"),
  SWG_AUTOMATION_FUZHOU_LIMITED((int) 844, (int) 844, (String) "SWG Automation Fuzhou Limited"),
  KSB_AKTIENGESELLSCHAFT((int) 845, (int) 845, (String) "KSB Aktiengesellschaft"),
  HYBRYD_SPZOO((int) 846, (int) 846, (String) "Hybryd Sp. z o.o."),
  HELVATRONAG((int) 847, (int) 847, (String) "Helvatron AG"),
  ODERON_SPZOO((int) 848, (int) 848, (String) "Oderon Sp. Z.O.O."),
  MIKOLAB((int) 849, (int) 849, (String) "mikolab"),
  EXODRAFT((int) 850, (int) 850, (String) "Exodraft"),
  HOCHHUTH_GMBH((int) 851, (int) 851, (String) "Hochhuth GmbH"),
  INTEGRATED_SYSTEM_TECHNOLOGIES_LTD(
      (int) 852, (int) 852, (String) "Integrated System Technologies Ltd."),
  SHANGHAI_CELLCONS_CONTROLS_CO_LTD(
      (int) 853, (int) 853, (String) "Shanghai Cellcons Controls Co., Ltd"),
  EMME_CONTROLSLLC((int) 854, (int) 854, (String) "Emme Controls, LLC"),
  FIELD_DIAGNOSTIC_SERVICES_INC((int) 855, (int) 855, (String) "Field Diagnostic Services, Inc."),
  GES_TEKNIKAS((int) 856, (int) 856, (String) "Ges Teknik A.S."),
  GLOBAL_POWER_PRODUCTS_INC((int) 857, (int) 857, (String) "Global Power Products, Inc."),
  OPTIONNV((int) 858, (int) 858, (String) "Option NV"),
  BV_CONTROLAG((int) 859, (int) 859, (String) "BV-Control AG"),
  SIGREN_ENGINEERINGAG((int) 860, (int) 860, (String) "Sigren Engineering AG"),
  SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD(
      (int) 861, (int) 861, (String) "Shanghai Jaltone Technology Co., Ltd."),
  MAX_LINE_SOLUTIONS_LTD((int) 862, (int) 862, (String) "MaxLine Solutions Ltd"),
  KRON_INSTRUMENTOS_ELTRICOS_LTDA(
      (int) 863, (int) 863, (String) "Kron Instrumentos Elétricos Ltda"),
  THERMO_MATRIX((int) 864, (int) 864, (String) "Thermo Matrix"),
  INFINITE_AUTOMATION_SYSTEMS_INC(
      (int) 865, (int) 865, (String) "Infinite Automation Systems, Inc."),
  VANTAGE((int) 866, (int) 866, (String) "Vantage"),
  ELECON_MEASUREMENTS_PVT_LTD((int) 867, (int) 867, (String) "Elecon Measurements Pvt Ltd"),
  TBA((int) 868, (int) 868, (String) "TBA"),
  CARNES_COMPANY((int) 869, (int) 869, (String) "Carnes Company"),
  HARMAN_PROFESSIONAL((int) 870, (int) 870, (String) "Harman Professional"),
  NENUTEC_ASIA_PACIFIC_PTE_LTD((int) 871, (int) 871, (String) "Nenutec Asia Pacific Pte Ltd"),
  GIANV((int) 872, (int) 872, (String) "Gia NV"),
  KEPWARE_TEHNOLOGIES((int) 873, (int) 873, (String) "Kepware Tehnologies"),
  TEMPERATURE_ELECTRONICS_LTD((int) 874, (int) 874, (String) "Temperature Electronics Ltd"),
  PACKET_POWER((int) 875, (int) 875, (String) "Packet Power"),
  PROJECT_HAYSTACK_CORPORATION((int) 876, (int) 876, (String) "Project Haystack Corporation"),
  DEOS_CONTROLS_AMERICAS_INC((int) 877, (int) 877, (String) "DEOS Controls Americas Inc."),
  SENSEWARE_INC((int) 878, (int) 878, (String) "Senseware Inc"),
  MST_SYSTEMTECHNIKAG((int) 879, (int) 879, (String) "MST Systemtechnik AG"),
  LONIX_LTD((int) 880, (int) 880, (String) "Lonix Ltd"),
  GOSSEN_METRAWATT_GMBH((int) 881, (int) 881, (String) "Gossen Metrawatt GmbH"),
  AVIOSYS_INTERNATIONAL_INC((int) 882, (int) 882, (String) "Aviosys International Inc."),
  EFFICIENT_BUILDING_AUTOMATION_CORP(
      (int) 883, (int) 883, (String) "Efficient Building Automation Corp."),
  ACCUTRON_INSTRUMENTS_INC((int) 884, (int) 884, (String) "Accutron Instruments Inc."),
  VERMONT_ENERGY_CONTROL_SYSTEMSLLC(
      (int) 885, (int) 885, (String) "Vermont Energy Control Systems LLC"),
  DCC_DYNAMICS((int) 886, (int) 886, (String) "DCC Dynamics"),
  BEG_BRCK_ELECTRONIC_GMBH((int) 887, (int) 887, (String) "B.E.G. Brück Electronic GmbH"),
  NGBS_HUNGARY_LTD((int) 889, (int) 889, (String) "NGBS Hungary Ltd."),
  ILLUM_TECHNOLOGYLLC((int) 890, (int) 890, (String) "ILLUM Technology, LLC"),
  DELTA_CONTROLS_GERMANY_LIMITED((int) 891, (int) 891, (String) "Delta Controls Germany Limited"),
  ST_SERVICE_TECHNIQUESA((int) 892, (int) 892, (String) "S+T Service & Technique S.A."),
  SIMPLE_SOFT((int) 893, (int) 893, (String) "SimpleSoft"),
  ALTAIR_ENGINEERING((int) 894, (int) 894, (String) "Altair Engineering"),
  EZEN_SOLUTION_INC((int) 895, (int) 895, (String) "EZEN Solution Inc."),
  FUJITEC_CO_LTD((int) 896, (int) 896, (String) "Fujitec Co. Ltd."),
  TERRALUX((int) 897, (int) 897, (String) "Terralux"),
  ANNICOM((int) 898, (int) 898, (String) "Annicom"),
  BIHL_WIEDEMANN_GMBH((int) 899, (int) 899, (String) "Bihl+Wiedemann GmbH"),
  DRAPER_INC((int) 900, (int) 900, (String) "Draper, Inc."),
  SCHCO_INTERNATIONALKG((int) 901, (int) 901, (String) "Schüco International KG"),
  OTIS_ELEVATOR_COMPANY((int) 902, (int) 902, (String) "Otis Elevator Company"),
  FIDELIX_OY((int) 903, (int) 903, (String) "Fidelix Oy"),
  RAM_GMBH_MESSUND_REGELTECHNIK((int) 904, (int) 904, (String) "RAM GmbH Mess- und Regeltechnik"),
  WEMS((int) 905, (int) 905, (String) "WEMS"),
  RAVEL_ELECTRONICS_PVT_LTD((int) 906, (int) 906, (String) "Ravel Electronics Pvt Ltd"),
  OMNI_MAGNI((int) 907, (int) 907, (String) "OmniMagni"),
  ECHELON((int) 908, (int) 908, (String) "Echelon"),
  INTELLIMETER_CANADA_INC((int) 909, (int) 909, (String) "Intellimeter Canada, Inc."),
  BITHOUSE_OY((int) 910, (int) 910, (String) "Bithouse Oy"),
  BUILD_PULSE((int) 912, (int) 912, (String) "BuildPulse"),
  SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD(
      (int) 913, (int) 913, (String) "Shenzhen 1000 Building Automation Co. Ltd"),
  AED_ENGINEERING_GMBH((int) 914, (int) 914, (String) "AED Engineering GmbH"),
  GNTNER_GMBH_COKG((int) 915, (int) 915, (String) "Güntner GmbH & Co. KG"),
  KN_XLOGIC((int) 916, (int) 916, (String) "KNXlogic"),
  CIM_ENVIRONMENTAL_GROUP((int) 917, (int) 917, (String) "CIM Environmental Group"),
  FLOW_CONTROL((int) 918, (int) 918, (String) "Flow Control"),
  LUMEN_CACHE_INC((int) 919, (int) 919, (String) "Lumen Cache, Inc."),
  ECOSYSTEM((int) 920, (int) 920, (String) "Ecosystem"),
  POTTER_ELECTRIC_SIGNAL_COMPANYLLC(
      (int) 921, (int) 921, (String) "Potter Electric Signal Company, LLC"),
  TYCO_FIRE_SECURITY_SPA((int) 922, (int) 922, (String) "Tyco Fire & Security S.p.A."),
  WATANABE_ELECTRIC_INDUSTRY_CO_LTD(
      (int) 923, (int) 923, (String) "Watanabe Electric Industry Co., Ltd."),
  CAUSAM_ENERGY((int) 924, (int) 924, (String) "Causam Energy"),
  WTECAG((int) 925, (int) 925, (String) "W-tec AG"),
  IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA(
      (int) 926, (int) 926, (String) "IMI Hydronic Engineering International SA"),
  ARIGO_SOFTWARE((int) 927, (int) 927, (String) "ARIGO Software"),
  MSA_SAFETY1((int) 928, (int) 928, (String) "MSA Safety"),
  SMART_SOLUCOES_LTDAMERCATO((int) 929, (int) 929, (String) "Smart Solucoes Ltda – MERCATO"),
  PIATRA_ENGINEERING((int) 930, (int) 930, (String) "PIATRA Engineering"),
  ODIN_AUTOMATION_SYSTEMSLLC((int) 931, (int) 931, (String) "ODIN Automation Systems, LLC"),
  BELPARTSNV((int) 932, (int) 932, (String) "Belparts NV"),
  UABSALDA((int) 933, (int) 933, (String) "UAB, SALDA"),
  ALREIT_REGELTECHNIK_GMBH((int) 934, (int) 934, (String) "Alre-IT Regeltechnik GmbH"),
  INGENIEURBROH_LERTES_GMBH_COKG(
      (int) 935, (int) 935, (String) "Ingenieurbüro H. Lertes GmbH & Co. KG"),
  BREATHING_BUILDINGS((int) 936, (int) 936, (String) "Breathing Buildings"),
  EWONSA((int) 937, (int) 937, (String) "eWON SA"),
  CAV_UFF_GIACOMO_CIMBERIO_SPA((int) 938, (int) 938, (String) "Cav. Uff. Giacomo Cimberio S.p.A"),
  PKE_ELECTRONICSAG((int) 939, (int) 939, (String) "PKE Electronics AG"),
  ALLEN((int) 940, (int) 940, (String) "Allen"),
  KASTLE_SYSTEMS((int) 941, (int) 941, (String) "Kastle Systems"),
  LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC(
      (int) 942, (int) 942, (String) "Logical Electro-Mechanical (EM) Systems, Inc."),
  PP_KINETICS_INSTRUMENTSLLC((int) 943, (int) 943, (String) "ppKinetics Instruments, LLC"),
  CATHEXIS_TECHNOLOGIES((int) 944, (int) 944, (String) "Cathexis Technologies"),
  SYLOPSP_ZOOSPK((int) 945, (int) 945, (String) "Sylop sp. Z o.o. sp.k"),
  BRAUNS_CONTROL_GMBH((int) 946, (int) 946, (String) "Brauns Control GmbH"),
  OMRONSOCIALSOLUTIONSCOLTD((int) 947, (int) 947, (String) "OMRON SOCIAL SOLUTIONS CO., LTD."),
  WILDEBOER_BAUTEILE_GMBH((int) 948, (int) 948, (String) "Wildeboer Bauteile Gmbh"),
  SHANGHAI_BIENS_TECHNOLOGIES_LTD((int) 949, (int) 949, (String) "Shanghai Biens Technologies Ltd"),
  BEIJINGHZHY_TECHNOLOGY_CO_LTD((int) 950, (int) 950, (String) "Beijing HZHY Technology Co., Ltd"),
  BUILDING_CLOUDS((int) 951, (int) 951, (String) "Building Clouds"),
  THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING(
      (int) 952,
      (int) 952,
      (String) "The University of Sheffield-Department of Electronic and Electrical Engineering"),
  FABTRONICS_AUSTRALIA_PTY_LTD((int) 953, (int) 953, (String) "Fabtronics Australia Pty Ltd"),
  SLAT((int) 954, (int) 954, (String) "SLAT"),
  SOFTWARE_MOTOR_CORPORATION((int) 955, (int) 955, (String) "Software Motor Corporation"),
  ARMSTRONG_INTERNATIONAL_INC((int) 956, (int) 956, (String) "Armstrong International Inc."),
  STERIL_AIRE_INC((int) 957, (int) 957, (String) "Steril-Aire, Inc."),
  INFINIQUE((int) 958, (int) 958, (String) "Infinique"),
  ARCOM((int) 959, (int) 959, (String) "Arcom"),
  ARGO_PERFORMANCE_LTD((int) 960, (int) 960, (String) "Argo Performance, Ltd"),
  DIALIGHT((int) 961, (int) 961, (String) "Dialight"),
  IDEAL_TECHNICAL_SOLUTIONS((int) 962, (int) 962, (String) "Ideal Technical Solutions"),
  NEUROBATAG((int) 963, (int) 963, (String) "Neurobat AG"),
  NEYER_SOFTWARE_CONSULTINGLLC((int) 964, (int) 964, (String) "Neyer Software Consulting LLC"),
  SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD(
      (int) 965, (int) 965, (String) "SCADA Technology Development Co., Ltd."),
  DEMAND_LOGIC_LIMITED((int) 966, (int) 966, (String) "Demand Logic Limited"),
  GWA_GROUP_LIMITED((int) 967, (int) 967, (String) "GWA Group Limited"),
  OCCITALINE((int) 968, (int) 968, (String) "Occitaline"),
  NAO_DIGITAL_CO_LTD((int) 969, (int) 969, (String) "NAO Digital Co., Ltd."),
  SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD(
      (int) 970, (int) 970, (String) "Shenzhen Chanslink Network Technology Co., Ltd."),
  SAMSUNG_ELECTRONICS_CO_LTD((int) 971, (int) 971, (String) "Samsung Electronics Co., Ltd."),
  MESA_LABORATORIES_INC((int) 972, (int) 972, (String) "Mesa Laboratories, Inc."),
  FISCHER((int) 973, (int) 973, (String) "Fischer"),
  OP_SYS_SOLUTIONS_LTD((int) 974, (int) 974, (String) "OpSys Solutions Ltd."),
  ADVANCED_DEVICES_LIMITED((int) 975, (int) 975, (String) "Advanced Devices Limited"),
  CONDAIR((int) 976, (int) 976, (String) "Condair"),
  INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA(
      (int) 977, (int) 977, (String) "INELCOM Ingenieria Electronica Comercial S.A."),
  GRID_POINT_INC((int) 978, (int) 978, (String) "GridPoint, Inc."),
  ADF_TECHNOLOGIES_SDN_BHD((int) 979, (int) 979, (String) "ADF Technologies Sdn Bhd"),
  EPM_INC((int) 980, (int) 980, (String) "EPM, Inc."),
  LIGHTING_CONTROLS_LTD((int) 981, (int) 981, (String) "Lighting Controls Ltd"),
  PERIX_CONTROLS_LTD((int) 982, (int) 982, (String) "Perix Controls Ltd."),
  AERCO_INTERNATIONAL_INC((int) 983, (int) 983, (String) "AERCO International, Inc."),
  KONE_INC((int) 984, (int) 984, (String) "KONE Inc."),
  ZIEHL_ABEGGSE((int) 985, (int) 985, (String) "Ziehl-Abegg SE"),
  ROBOTSA((int) 986, (int) 986, (String) "Robot, S.A."),
  OPTIGO_NETWORKS_INC((int) 987, (int) 987, (String) "Optigo Networks, Inc."),
  OPENMOTICSBVBA((int) 988, (int) 988, (String) "Openmotics BVBA"),
  METROPOLITAN_INDUSTRIES_INC((int) 989, (int) 989, (String) "Metropolitan Industries, Inc."),
  HUAWEI_TECHNOLOGIES_CO_LTD((int) 990, (int) 990, (String) "Huawei Technologies Co., Ltd."),
  DIGITAL_LUMENS_INC((int) 991, (int) 991, (String) "Digital Lumens, Inc."),
  VANTI((int) 992, (int) 992, (String) "Vanti"),
  CREE_LIGHTING((int) 993, (int) 993, (String) "Cree Lighting"),
  RICHMOND_HEIGHTSSDNBHD((int) 994, (int) 994, (String) "Richmond Heights SDN BHD"),
  PAYNE_SPARKMAN_LIGHTING_MANGEMENT(
      (int) 995, (int) 995, (String) "Payne-Sparkman Lighting Mangement"),
  ASHCROFT((int) 996, (int) 996, (String) "Ashcroft"),
  JET_CONTROLS_CORP((int) 997, (int) 997, (String) "Jet Controls Corp"),
  ZUMTOBEL_LIGHTING_GMBH((int) 998, (int) 998, (String) "Zumtobel Lighting GmbH"),
  EKON_GMBH((int) 1000, (int) 1000, (String) "Ekon GmbH"),
  MOLEX((int) 1001, (int) 1001, (String) "Molex"),
  MACO_LIGHTING_PTY_LTD((int) 1002, (int) 1002, (String) "Maco Lighting Pty Ltd."),
  AXECON_CORP((int) 1003, (int) 1003, (String) "Axecon Corp."),
  TENSORPLC((int) 1004, (int) 1004, (String) "Tensor plc"),
  KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED(
      (int) 1005,
      (int) 1005,
      (String) "Kaseman Environmental Control Equipment (Shanghai) Limited"),
  AB_AXIS_INDUSTRIES((int) 1006, (int) 1006, (String) "AB Axis Industries"),
  NETIX_CONTROLS((int) 1007, (int) 1007, (String) "Netix Controls"),
  ELDRIDGE_PRODUCTS_INC((int) 1008, (int) 1008, (String) "Eldridge Products, Inc."),
  MICRONICS((int) 1009, (int) 1009, (String) "Micronics"),
  FORTECHO_SOLUTIONS_LTD((int) 1010, (int) 1010, (String) "Fortecho Solutions Ltd"),
  SELLERS_MANUFACTURING_COMPANY((int) 1011, (int) 1011, (String) "Sellers Manufacturing Company"),
  RITE_HITE_DOORS_INC((int) 1012, (int) 1012, (String) "Rite-Hite Doors, Inc."),
  VIOLET_DEFENSELLC((int) 1013, (int) 1013, (String) "Violet Defense LLC"),
  SIMNA((int) 1014, (int) 1014, (String) "Simna"),
  MULTINERGIE_BEST_INC((int) 1015, (int) 1015, (String) "Multi-Énergie Best Inc."),
  MEGA_SYSTEM_TECHNOLOGIES_INC((int) 1016, (int) 1016, (String) "Mega System Technologies, Inc."),
  RHEEM((int) 1017, (int) 1017, (String) "Rheem"),
  ING_PUNZENBERGERCOPADATA_GMBH(
      (int) 1018, (int) 1018, (String) "Ing. Punzenberger COPA-DATA GmbH"),
  MEC_ELECTRONICS_GMBH((int) 1019, (int) 1019, (String) "MEC Electronics GmbH"),
  TACO_COMFORT_SOLUTIONS((int) 1020, (int) 1020, (String) "Taco Comfort Solutions"),
  ALEXANDER_MAIER_GMBH((int) 1021, (int) 1021, (String) "Alexander Maier GmbH"),
  ECORITHM_INC((int) 1022, (int) 1022, (String) "Ecorithm, Inc."),
  ACCURRO_LTD((int) 1023, (int) 1023, (String) "Accurro Ltd"),
  ROMTECK_AUSTRALIA_PTY_LTD((int) 1024, (int) 1024, (String) "ROMTECK Australia Pty Ltd"),
  SPLASH_MONITORING_LIMITED((int) 1025, (int) 1025, (String) "Splash Monitoring Limited"),
  LIGHT_APPLICATION((int) 1026, (int) 1026, (String) "Light Application"),
  LOGICAL_BUILDING_AUTOMATION((int) 1027, (int) 1027, (String) "Logical Building Automation"),
  EXILIGHT_OY((int) 1028, (int) 1028, (String) "Exilight Oy"),
  HAGER_ELECTROSAS((int) 1029, (int) 1029, (String) "Hager Electro SAS"),
  KLIF_COLTD((int) 1030, (int) 1030, (String) "KLIF Co., LTD"),
  HYGRO_MATIK((int) 1031, (int) 1031, (String) "HygroMatik"),
  DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE(
      (int) 1032, (int) 1032, (String) "Daniel Mousseau Programmation & Electronique"),
  AERIONICS_INC((int) 1033, (int) 1033, (String) "Aerionics Inc."),
  MS_ELECTRONIQUE_LTEE((int) 1034, (int) 1034, (String) "M2S Electronique Ltee"),
  AUTOMATION_COMPONENTS_INC((int) 1035, (int) 1035, (String) "Automation Components, Inc."),
  NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION(
      (int) 1036, (int) 1036, (String) "Niobrara Research & Development Corporation"),
  NETCOM_SICHERHEITSTECHNIK_GMBH((int) 1037, (int) 1037, (String) "Netcom Sicherheitstechnik GmbH"),
  LUMELSA((int) 1038, (int) 1038, (String) "Lumel S.A."),
  GREAT_PLAINS_INDUSTRIES_INC((int) 1039, (int) 1039, (String) "Great Plains Industries, Inc."),
  DOMOTICA_LABSSRL((int) 1040, (int) 1040, (String) "Domotica Labs S.R.L"),
  ENERGY_CLOUD_INC((int) 1041, (int) 1041, (String) "Energy Cloud, Inc."),
  VOMATEC((int) 1042, (int) 1042, (String) "Vomatec"),
  DEMMA_COMPANIES((int) 1043, (int) 1043, (String) "Demma Companies"),
  VALSENA((int) 1044, (int) 1044, (String) "Valsena"),
  COMSYS_BRTSCHAG((int) 1045, (int) 1045, (String) "Comsys Bärtsch AG"),
  B_GRID((int) 1046, (int) 1046, (String) "bGrid"),
  MDJ_SOFTWARE_PTY_LTD((int) 1047, (int) 1047, (String) "MDJ Software Pty Ltd"),
  DIMONOFF_INC((int) 1048, (int) 1048, (String) "Dimonoff, Inc."),
  EDOMO_SYSTEMS_GMBH((int) 1049, (int) 1049, (String) "Edomo Systems, GmbH"),
  EFFEKTIVLLC((int) 1050, (int) 1050, (String) "Effektiv, LLC"),
  STEAMO_VAP((int) 1051, (int) 1051, (String) "SteamOVap"),
  GRANDCENTRIX_GMBH((int) 1052, (int) 1052, (String) "grandcentrix GmbH"),
  WEINTEK_LABS_INC((int) 1053, (int) 1053, (String) "Weintek Labs, Inc."),
  INTEFOX_GMBH((int) 1054, (int) 1054, (String) "Intefox GmbH"),
  RADIUS_AUTOMATION_COMPANY((int) 1055, (int) 1055, (String) "Radius22 Automation Company"),
  RINGDALE_INC((int) 1056, (int) 1056, (String) "Ringdale, Inc."),
  IWAKI_AMERICA((int) 1057, (int) 1057, (String) "Iwaki America"),
  BRACTLET((int) 1058, (int) 1058, (String) "Bractlet"),
  STULZ_AIR_TECHNOLOGY_SYSTEMS_INC(
      (int) 1059, (int) 1059, (String) "STULZ Air Technology Systems, Inc."),
  CLIMATE_READY_ENGINEERING_PTY_LTD(
      (int) 1060, (int) 1060, (String) "Climate Ready Engineering Pty Ltd"),
  GENEA_ENERGY_PARTNERS((int) 1061, (int) 1061, (String) "Genea Energy Partners"),
  IO_TALL_CHILE((int) 1062, (int) 1062, (String) "IoTall Chile"),
  IKS_CO_LTD((int) 1063, (int) 1063, (String) "IKS Co., Ltd."),
  YODIWOAB((int) 1064, (int) 1064, (String) "Yodiwo AB"),
  TITA_NELECTRONIC_GMBH((int) 1065, (int) 1065, (String) "TITAN electronic GmbH"),
  IDEC_CORPORATION((int) 1066, (int) 1066, (String) "IDEC Corporation"),
  SIFRISL((int) 1067, (int) 1067, (String) "SIFRI SL"),
  THERMAL_GAS_SYSTEMS_INC((int) 1068, (int) 1068, (String) "Thermal Gas Systems Inc."),
  BUILDING_AUTOMATION_PRODUCTS_INC(
      (int) 1069, (int) 1069, (String) "Building Automation Products, Inc."),
  ASSET_MAPPING((int) 1070, (int) 1070, (String) "Asset Mapping"),
  SMARTEH_COMPANY((int) 1071, (int) 1071, (String) "Smarteh Company"),
  DATAPOD_AUSTRALIA_PTY_LTD((int) 1072, (int) 1072, (String) "Datapod (Australia) Pty Ltd."),
  BUILDINGS_ALIVE_PTY_LTD((int) 1073, (int) 1073, (String) "Buildings Alive Pty Ltd"),
  DIGITAL_ELEKTRONIK((int) 1074, (int) 1074, (String) "Digital Elektronik"),
  TALENT_AUTOMAOE_TECNOLOGIA_LTDA(
      (int) 1075, (int) 1075, (String) "Talent Automação e Tecnologia Ltda"),
  NORPOSH_LIMITED((int) 1076, (int) 1076, (String) "Norposh Limited"),
  MERKUR_FUNKSYSTEMEAG((int) 1077, (int) 1077, (String) "Merkur Funksysteme AG"),
  FASTERC_ZSPOL_SRO((int) 1078, (int) 1078, (String) "Faster CZ spol. S.r.o"),
  ECO_ADAPT((int) 1079, (int) 1079, (String) "Eco-Adapt"),
  ENERGOCENTRUM_PLUSSRO((int) 1080, (int) 1080, (String) "Energocentrum Plus, s.r.o"),
  AMBXUK_LTD((int) 1081, (int) 1081, (String) "amBX UK Ltd"),
  WESTERN_RESERVE_CONTROLS_INC((int) 1082, (int) 1082, (String) "Western Reserve Controls, Inc."),
  LAYER_ZERO_POWER_SYSTEMS_INC((int) 1083, (int) 1083, (String) "LayerZero Power Systems, Inc."),
  CIC_JAN_HEBECSRO((int) 1084, (int) 1084, (String) "CIC Jan Hřebec s.r.o."),
  SIGROVBV((int) 1085, (int) 1085, (String) "Sigrov BV"),
  ISYS_INTELLIGENT_SYSTEMS((int) 1086, (int) 1086, (String) "ISYS-Intelligent Systems"),
  GAS_DETECTION_AUSTRALIA_PTY_LTD(
      (int) 1087, (int) 1087, (String) "Gas Detection (Australia) Pty Ltd"),
  KINCO_AUTOMATION_SHANGHAI_LTD(
      (int) 1088, (int) 1088, (String) "Kinco Automation (Shanghai) Ltd."),
  LARS_ENERGYLLC((int) 1089, (int) 1089, (String) "Lars Energy, LLC"),
  FLAMEFASTUK_LTD((int) 1090, (int) 1090, (String) "Flamefast (UK) Ltd."),
  ROYAL_SERVICE_AIR_CONDITIONING((int) 1091, (int) 1091, (String) "Royal Service Air Conditioning"),
  AMPIO_SP_ZOO((int) 1092, (int) 1092, (String) "Ampio Sp. Z o.o."),
  INOVONICS_WIRELESS_CORPORATION((int) 1093, (int) 1093, (String) "Inovonics Wireless Corporation"),
  NVENT_THERMAL_MANAGEMENT((int) 1094, (int) 1094, (String) "Nvent Thermal Management"),
  SINOWELL_CONTROL_SYSTEM_LTD((int) 1095, (int) 1095, (String) "Sinowell Control System Ltd"),
  MOXA_INC((int) 1096, (int) 1096, (String) "Moxa Inc."),
  MATRIXI_CONTROLSDNBHD((int) 1097, (int) 1097, (String) "Matrix iControl SDN BHD"),
  PURPLE_SWIFT((int) 1098, (int) 1098, (String) "PurpleSwift"),
  OTIM_TECHNOLOGIES((int) 1099, (int) 1099, (String) "OTIM Technologies"),
  FLOW_MATE_LIMITED((int) 1100, (int) 1100, (String) "FlowMate Limited"),
  DEGREE_CONTROLS_INC((int) 1101, (int) 1101, (String) "Degree Controls, Inc."),
  FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD(
      (int) 1102, (int) 1102, (String) "Fei Xing (Shanghai) Software Technologies Co., Ltd."),
  BERG_GMBH((int) 1103, (int) 1103, (String) "Berg GmbH"),
  ARENZIT((int) 1104, (int) 1104, (String) "ARENZ.IT"),
  EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC(
      (int) 1105, (int) 1105, (String) "Edelstrom Electronic Devices & Designing LLC"),
  DRIVE_CONNECTLLC((int) 1106, (int) 1106, (String) "Drive Connect, LLC"),
  DEVELOP_NOW((int) 1107, (int) 1107, (String) "DevelopNow"),
  POORT((int) 1108, (int) 1108, (String) "Poort"),
  VMEIL_INFORMATION_SHANGHAI_LTD(
      (int) 1109, (int) 1109, (String) "VMEIL Information (Shanghai) Ltd"),
  RAYLEIGH_INSTRUMENTS((int) 1110, (int) 1110, (String) "Rayleigh Instruments"),
  CODESYS_DEVELOPMENT((int) 1112, (int) 1112, (String) "CODESYS Development"),
  SMARTWARE_TECHNOLOGIES_GROUPLLC(
      (int) 1113, (int) 1113, (String) "Smartware Technologies Group, LLC"),
  POLAR_BEAR_SOLUTIONS((int) 1114, (int) 1114, (String) "Polar Bear Solutions"),
  CODRA((int) 1115, (int) 1115, (String) "Codra"),
  PHAROS_ARCHITECTURAL_CONTROLS_LTD(
      (int) 1116, (int) 1116, (String) "Pharos Architectural Controls Ltd"),
  ENGI_NEAR_LTD((int) 1117, (int) 1117, (String) "EngiNear Ltd."),
  AD_HOC_ELECTRONICS((int) 1118, (int) 1118, (String) "Ad Hoc Electronics"),
  UNIFIED_MICROSYSTEMS((int) 1119, (int) 1119, (String) "Unified Microsystems"),
  INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH(
      (int) 1120, (int) 1120, (String) "Industrieelektronik Brandenburg GmbH"),
  HARTMANN_GMBH((int) 1121, (int) 1121, (String) "Hartmann GmbH"),
  PISCADA((int) 1122, (int) 1122, (String) "Piscada"),
  KM_BSYSTEMSSRO((int) 1123, (int) 1123, (String) "KMB systems, s.r.o."),
  POWER_TECH_ENGINEERINGAS((int) 1124, (int) 1124, (String) "PowerTech Engineering AS"),
  TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG(
      (int) 1125, (int) 1125, (String) "Telefonbau Arthur Schwabe GmbH & Co. KG"),
  WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD(
      (int) 1126, (int) 1126, (String) "Wuxi Fistwelove Technology Co., Ltd."),
  PRYSM((int) 1127, (int) 1127, (String) "Prysm"),
  STEINEL_GMBH((int) 1128, (int) 1128, (String) "STEINEL GmbH"),
  GEORG_FISCHERJRGAG((int) 1129, (int) 1129, (String) "Georg Fischer JRG AG"),
  MAKE_DEVELOPSL((int) 1130, (int) 1130, (String) "Make Develop SL"),
  MONNIT_CORPORATION((int) 1131, (int) 1131, (String) "Monnit Corporation"),
  MIRROR_LIFE_CORPORATION((int) 1132, (int) 1132, (String) "Mirror Life Corporation"),
  SECURE_METERS_LIMITED((int) 1133, (int) 1133, (String) "Secure Meters Limited"),
  PECO((int) 1134, (int) 1134, (String) "PECO"),
  CCTECH_INC((int) 1135, (int) 1135, (String) ".CCTECH, Inc."),
  LIGHT_FI_LIMITED((int) 1136, (int) 1136, (String) "LightFi Limited"),
  NICE_SPA((int) 1137, (int) 1137, (String) "Nice Spa"),
  FIBER_SEN_SYS_INC((int) 1138, (int) 1138, (String) "Fiber SenSys, Inc."),
  BD_BUCHTAUND_DEGEORGI((int) 1139, (int) 1139, (String) "B&D Buchta und Degeorgi"),
  VENTACITY_SYSTEMS_INC((int) 1140, (int) 1140, (String) "Ventacity Systems, Inc."),
  HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC(
      (int) 1141, (int) 1141, (String) "Hitachi-Johnson Controls Air Conditioning, Inc."),
  SAGE_METERING_INC((int) 1142, (int) 1142, (String) "Sage Metering, Inc."),
  ANDEL_LIMITED((int) 1143, (int) 1143, (String) "Andel Limited"),
  ECO_SMART_TECHNOLOGIES((int) 1144, (int) 1144, (String) "ECOSmart Technologies"),
  SET((int) 1145, (int) 1145, (String) "S.E.T."),
  PROTEC_FIRE_DETECTION_SPAINSL((int) 1146, (int) 1146, (String) "Protec Fire Detection Spain SL"),
  AGRAMERUG((int) 1147, (int) 1147, (String) "AGRAMER UG"),
  ANYLINK_ELECTRONIC_GMBH((int) 1148, (int) 1148, (String) "Anylink Electronic GmbH"),
  SCHINDLER_LTD((int) 1149, (int) 1149, (String) "Schindler, Ltd"),
  JIBREEL_ABDEEN_EST((int) 1150, (int) 1150, (String) "Jibreel Abdeen Est."),
  FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD(
      (int) 1151, (int) 1151, (String) "Fluidyne Control Systems Pvt. Ltd"),
  PRISM_SYSTEMS_INC((int) 1152, (int) 1152, (String) "Prism Systems, Inc."),
  ENERTIV((int) 1153, (int) 1153, (String) "Enertiv"),
  MIRASOFT_GMBH_COKG((int) 1154, (int) 1154, (String) "Mirasoft GmbH & Co. KG"),
  DUALTECHIT((int) 1155, (int) 1155, (String) "DUALTECH IT"),
  COUNTLOGICLLC((int) 1156, (int) 1156, (String) "Countlogic, LLC"),
  KOHLER((int) 1157, (int) 1157, (String) "Kohler"),
  CHEN_SEN_CONTROLS_CO_LTD((int) 1158, (int) 1158, (String) "Chen Sen Controls Co., Ltd."),
  GREENHECK((int) 1159, (int) 1159, (String) "Greenheck"),
  INTWINE_CONNECTLLC((int) 1160, (int) 1160, (String) "Intwine Connect, LLC"),
  KARLBORGS_ELKONTROLL((int) 1161, (int) 1161, (String) "Karlborgs Elkontroll"),
  DATAKOM((int) 1162, (int) 1162, (String) "Datakom"),
  HOGA_CONTROLAS((int) 1163, (int) 1163, (String) "Hoga Control AS"),
  COOL_AUTOMATION((int) 1164, (int) 1164, (String) "Cool Automation"),
  INTER_SEARCH_CO_LTD((int) 1165, (int) 1165, (String) "Inter Search Co., Ltd"),
  DABBEL_AUTOMATION_INTELLIGENCE_GMBH(
      (int) 1166, (int) 1166, (String) "DABBEL-Automation Intelligence GmbH"),
  GADGEON_ENGINEERING_SMARTNESS((int) 1167, (int) 1167, (String) "Gadgeon Engineering Smartness"),
  COSTER_GROUP_SRL((int) 1168, (int) 1168, (String) "Coster Group S.r.l."),
  WALTER_MLLERAG((int) 1169, (int) 1169, (String) "Walter Müller AG"),
  FLUKE((int) 1170, (int) 1170, (String) "Fluke"),
  QUINTEX_SYSTEMS_LTD((int) 1171, (int) 1171, (String) "Quintex Systems Ltd"),
  SENFFICIENTSDNBHD((int) 1172, (int) 1172, (String) "Senfficient SDN BHD"),
  NUBEIO_OPERATIONS_PTY_LTD((int) 1173, (int) 1173, (String) "Nube iO Operations Pty Ltd"),
  DAS_INTEGRATOR_PTE_LTD((int) 1174, (int) 1174, (String) "DAS Integrator Pte Ltd"),
  CREVIS_CO_LTD((int) 1175, (int) 1175, (String) "CREVIS Co., Ltd"),
  I_SQUAREDSOFTWAREINC((int) 1176, (int) 1176, (String) "iSquared software inc."),
  KTG_GMBH((int) 1177, (int) 1177, (String) "KTG GmbH"),
  POK_GROUP_OY((int) 1178, (int) 1178, (String) "POK Group Oy"),
  ADISCOM((int) 1179, (int) 1179, (String) "Adiscom"),
  INCUSENSE((int) 1180, (int) 1180, (String) "Incusense"),
  F((int) 1181, (int) 1181, (String) "75F"),
  ANORD_MARDIX_INC((int) 1182, (int) 1182, (String) "Anord Mardix, Inc."),
  HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH(
      (int) 1183, (int) 1183, (String) "HOSCH Gebäudeautomation Neue Produkte GmbH"),
  BOSCHIO_GMBH((int) 1184, (int) 1184, (String) "Bosch.IO GmbH"),
  ROYAL_BOON_EDAM_INTERNATIONALBV(
      (int) 1185, (int) 1185, (String) "Royal Boon Edam International B.V."),
  CLACK_CORPORATION((int) 1186, (int) 1186, (String) "Clack Corporation"),
  UNITEX_CONTROLSLLC((int) 1187, (int) 1187, (String) "Unitex Controls LLC"),
  KTC_GTEBORGAB((int) 1188, (int) 1188, (String) "KTC Göteborg AB"),
  INTERZONAB((int) 1189, (int) 1189, (String) "Interzon AB"),
  ISDEINGSL((int) 1190, (int) 1190, (String) "ISDE ING SL"),
  AB_MAUTOMATIONBUILDINGMESSAGING_GMBH(
      (int) 1191, (int) 1191, (String) "ABM automation building messaging GmbH"),
  KENTEC_ELECTRONICS_LTD((int) 1192, (int) 1192, (String) "Kentec Electronics Ltd"),
  EMERSON_COMMERCIALAND_RESIDENTIAL_SOLUTIONS(
      (int) 1193, (int) 1193, (String) "Emerson Commercial and Residential Solutions"),
  POWERSIDE((int) 1194, (int) 1194, (String) "Powerside"),
  SMC_GROUP((int) 1195, (int) 1195, (String) "SMC Group"),
  EOS_WEATHER_INSTRUMENTS((int) 1196, (int) 1196, (String) "EOS Weather Instruments"),
  ZONEX_SYSTEMS((int) 1197, (int) 1197, (String) "Zonex Systems"),
  GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH(
      (int) 1198, (int) 1198, (String) "Generex Systems Computervertriebsgesellschaft mbH"),
  ENERGY_WALLLLC((int) 1199, (int) 1199, (String) "Energy Wall LLC"),
  THERMOFIN((int) 1200, (int) 1200, (String) "Thermofin"),
  SDATAWAYSA((int) 1201, (int) 1201, (String) "SDATAWAY SA"),
  BIDDLE_AIR_SYSTEMS_LIMITED((int) 1202, (int) 1202, (String) "Biddle Air Systems Limited"),
  KESSLER_ELLIS_PRODUCTS((int) 1203, (int) 1203, (String) "Kessler Ellis Products"),
  THERMOSCREENS((int) 1204, (int) 1204, (String) "Thermoscreens"),
  MODIO((int) 1205, (int) 1205, (String) "Modio"),
  NEWRON_SOLUTIONS((int) 1206, (int) 1206, (String) "Newron Solutions"),
  UNITRONICS((int) 1207, (int) 1207, (String) "Unitronics"),
  TRILUX_GMBH_COKG((int) 1208, (int) 1208, (String) "TRILUX GmbH & Co. KG"),
  KOLLMORGEN_STEUERUNGSTECHNIK_GMBH(
      (int) 1209, (int) 1209, (String) "Kollmorgen Steuerungstechnik GmbH"),
  BOSCH_REXROTHAG((int) 1210, (int) 1210, (String) "Bosch Rexroth AG"),
  ALARKO_CARRIER((int) 1211, (int) 1211, (String) "Alarko Carrier"),
  VERDIGRIS_TECHNOLOGIES((int) 1212, (int) 1212, (String) "Verdigris Technologies"),
  SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD(
      (int) 1213, (int) 1213, (String) "Shanghai SIIC-Longchuang Smartech So., Ltd."),
  QUINDA_CO((int) 1214, (int) 1214, (String) "Quinda Co."),
  GRUNERAG((int) 1215, (int) 1215, (String) "GRUNER AG"),
  BACMOVE((int) 1216, (int) 1216, (String) "BACMOVE"),
  PSIDACAB((int) 1217, (int) 1217, (String) "PSIDAC AB"),
  ISICON_CONTROL_AUTOMATION((int) 1218, (int) 1218, (String) "ISICON-Control Automation"),
  BIG_ASS_FANS((int) 1219, (int) 1219, (String) "Big Ass Fans"),
  DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH(
      (int) 1220, (int) 1220, (String) "din – Dietmar Nocker Facility Management GmbH"),
  TELDIO((int) 1221, (int) 1221, (String) "Teldio"),
  MIKROKLIM_ASRO((int) 1222, (int) 1222, (String) "MIKROKLIMA s.r.o."),
  DENSITY((int) 1223, (int) 1223, (String) "Density"),
  ICONAG_LEITTECHNIK_GMBH((int) 1224, (int) 1224, (String) "ICONAG-Leittechnik GmbH"),
  AWAIR((int) 1225, (int) 1225, (String) "Awair"),
  TD_ENGINEERING_LTD((int) 1226, (int) 1226, (String) "T&D Engineering, Ltd"),
  SISTEMAS_DIGITALES((int) 1227, (int) 1227, (String) "Sistemas Digitales"),
  LOXONE_ELECTRONICS_GMBH((int) 1228, (int) 1228, (String) "Loxone Electronics GmbH"),
  ACTRON_AIR((int) 1229, (int) 1229, (String) "ActronAir"),
  INDUCTIVE_AUTOMATION((int) 1230, (int) 1230, (String) "Inductive Automation"),
  THOR_ENGINEERING_GMBH((int) 1231, (int) 1231, (String) "Thor Engineering GmbH"),
  BERNER_INTERNATIONALLLC((int) 1232, (int) 1232, (String) "Berner International, LLC"),
  POTSDAM_SENSORSLLC((int) 1233, (int) 1233, (String) "Potsdam Sensors LLC"),
  KOHLER_MIRA_LTD((int) 1234, (int) 1234, (String) "Kohler Mira Ltd"),
  TECOMON_GMBH((int) 1235, (int) 1235, (String) "Tecomon GmbH"),
  TWO_DIMENSIONAL_INSTRUMENTSLLC(
      (int) 1236, (int) 1236, (String) "Two Dimensional Instruments, LLC"),
  LEFA_TECHNOLOGIES_PTE_LTD((int) 1237, (int) 1237, (String) "LEFA Technologies Pte. Ltd."),
  EATONCEAG_NOTLICHTSYSTEME_GMBH(
      (int) 1238, (int) 1238, (String) "EATON CEAG Notlichtsysteme GmbH"),
  COMMBOX_TECNOLOGIA((int) 1239, (int) 1239, (String) "Commbox Tecnologia"),
  IP_VIDEO_CORPORATION((int) 1240, (int) 1240, (String) "IPVideo Corporation"),
  BENDER_GMBH_COKG((int) 1241, (int) 1241, (String) "Bender GmbH & Co. KG"),
  RHYMEBUS_CORPORATION((int) 1242, (int) 1242, (String) "Rhymebus Corporation"),
  AXON_SYSTEMS_LTD((int) 1243, (int) 1243, (String) "Axon Systems Ltd"),
  ENGINEERED_AIR((int) 1244, (int) 1244, (String) "Engineered Air"),
  ELIPSE_SOFTWARE_LTDA((int) 1245, (int) 1245, (String) "Elipse Software Ltda"),
  SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD(
      (int) 1246, (int) 1246, (String) "Simatix Building Technologies Pvt. Ltd."),
  WA_BENJAMIN_ELECTRIC_CO((int) 1247, (int) 1247, (String) "W.A. Benjamin Electric Co."),
  TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD(
      (int) 1248, (int) 1248, (String) "TROX Air Conditioning Components (Suzhou) Co. Ltd."),
  SC_MEDICAL_PTY_LTD((int) 1249, (int) 1249, (String) "SC Medical Pty Ltd."),
  ELCANICAS((int) 1250, (int) 1250, (String) "Elcanic A/S"),
  OBEOAS((int) 1251, (int) 1251, (String) "Obeo AS"),
  TAPA_INC((int) 1252, (int) 1252, (String) "Tapa, Inc."),
  ASE_SMART_ENERGY_INC((int) 1253, (int) 1253, (String) "ASE Smart Energy, Inc."),
  PERFORMANCE_SERVICES_INC((int) 1254, (int) 1254, (String) "Performance Services, Inc."),
  VERIDIFY_SECURITY((int) 1255, (int) 1255, (String) "Veridify Security"),
  CD_INNOVATIONLTD((int) 1256, (int) 1256, (String) "CD Innovation LTD"),
  BEN_PEOPLES_INDUSTRIESLLC((int) 1257, (int) 1257, (String) "Ben Peoples Industries, LLC"),
  UNICOMM_SPZOO((int) 1258, (int) 1258, (String) "UNICOMM Sp. z o.o"),
  THING_TECHNOLOGIES_GMBH((int) 1259, (int) 1259, (String) "Thing Technologies GmbH"),
  BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC(
      (int) 1260, (int) 1260, (String) "Beijing Hailin Control Technology, Inc."),
  DIGITAL_REALTY((int) 1261, (int) 1261, (String) "Digital Realty"),
  AGROWTEK_INC((int) 1262, (int) 1262, (String) "Agrowtek Inc."),
  DSP_INNOVATIONBV((int) 1263, (int) 1263, (String) "DSP Innovation BV"),
  STV_ELECTRONIC_GMBH((int) 1264, (int) 1264, (String) "STV Electronic GmbH"),
  ELMEASURE_INDIA_PVT_LTD((int) 1265, (int) 1265, (String) "Elmeasure India Pvt Ltd."),
  PINESHORE_ENERGYLLC((int) 1266, (int) 1266, (String) "Pineshore Energy LLC"),
  BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC(
      (int) 1267, (int) 1267, (String) "Brasch Environmental Technologies, LLC"),
  LION_CONTROLS_COLTD((int) 1268, (int) 1268, (String) "Lion Controls Co., LTD"),
  SINUX((int) 1269, (int) 1269, (String) "Sinux"),
  AVNET_INC((int) 1270, (int) 1270, (String) "Avnet Inc."),
  SOMFY_ACTIVITESSA((int) 1271, (int) 1271, (String) "Somfy Activites SA"),
  AMICO((int) 1272, (int) 1272, (String) "Amico"),
  SAGE_GLASS((int) 1273, (int) 1273, (String) "SageGlass"),
  AU_VERTE((int) 1274, (int) 1274, (String) "AuVerte"),
  AGILE_CONNECTS_PVT_LTD((int) 1275, (int) 1275, (String) "Agile Connects Pvt. Ltd."),
  LOCIMATION_PTY_LTD((int) 1276, (int) 1276, (String) "Locimation Pty Ltd"),
  ENVIO_SYSTEMS_GMBH((int) 1277, (int) 1277, (String) "Envio Systems GmbH"),
  VOYTECH_SYSTEMS_LIMITED((int) 1278, (int) 1278, (String) "Voytech Systems Limited"),
  DAVIDSMEYERUND_PAUL_GMBH((int) 1279, (int) 1279, (String) "Davidsmeyer und Paul GmbH"),
  LUSHER_ENGINEERING_SERVICES((int) 1280, (int) 1280, (String) "Lusher Engineering Services"),
  CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD(
      (int) 1281, (int) 1281, (String) "CHNT Nanjing Techsel Intelligent Company LTD"),
  THREETRONICS_PTY_LTD((int) 1282, (int) 1282, (String) "Threetronics Pty Ltd"),
  SKY_FOUNDRYLLC((int) 1283, (int) 1283, (String) "SkyFoundry, LLC"),
  HANIL_PRO_TECH((int) 1284, (int) 1284, (String) "HanilProTech"),
  SENSORSCALL((int) 1285, (int) 1285, (String) "Sensorscall"),
  SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD(
      (int) 1286, (int) 1286, (String) "Shanghai Jingpu Information Technology, Co., Ltd."),
  LICHTMANUFAKTUR_BERLIN_GMBH((int) 1287, (int) 1287, (String) "Lichtmanufaktur Berlin GmbH"),
  ECO_PARKING_TECHNOLOGIES((int) 1288, (int) 1288, (String) "Eco Parking Technologies"),
  ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD(
      (int) 1289, (int) 1289, (String) "Envision Digital International Pte Ltd"),
  ANTONY_DEVELOPPEMENT_ELECTRONIQUE(
      (int) 1290, (int) 1290, (String) "Antony Developpement Electronique"),
  ISYSTEMS((int) 1291, (int) 1291, (String) "i2systems"),
  THUREON_INTERNATIONAL_LIMITED((int) 1292, (int) 1292, (String) "Thureon International Limited"),
  PULSAFEEDER((int) 1293, (int) 1293, (String) "Pulsafeeder"),
  MEGA_CHIPS_CORPORATION((int) 1294, (int) 1294, (String) "MegaChips Corporation"),
  TES_CONTROLS((int) 1295, (int) 1295, (String) "TES Controls"),
  CERMATE((int) 1296, (int) 1296, (String) "Cermate"),
  GRAND_VALLEY_STATE_UNIVERSITY((int) 1297, (int) 1297, (String) "Grand Valley State University"),
  SYMCON_GMBH((int) 1298, (int) 1298, (String) "Symcon Gmbh"),
  THE_CHICAGO_FAUCET_COMPANY((int) 1299, (int) 1299, (String) "The Chicago Faucet Company"),
  GEBERITAG((int) 1300, (int) 1300, (String) "Geberit AG"),
  REX_CONTROLS((int) 1301, (int) 1301, (String) "Rex Controls"),
  IVMS_GMBH((int) 1302, (int) 1302, (String) "IVMS GmbH"),
  MNPP_SATURN_LTD((int) 1303, (int) 1303, (String) "MNPP Saturn Ltd."),
  REGAL_BELOIT((int) 1304, (int) 1304, (String) "Regal Beloit"),
  ACS_AIR_CONDITIONING_SOLUTIONS((int) 1305, (int) 1305, (String) "ACS-Air Conditioning Solutions"),
  GBX_TECHNOLOGYLLC((int) 1306, (int) 1306, (String) "GBX Technology, LLC"),
  KAITERRA((int) 1307, (int) 1307, (String) "Kaiterra"),
  THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD(
      (int) 1308, (int) 1308, (String) "ThinKuan loT Technology (Shanghai) Co., Ltd"),
  HO_CO_STOBV((int) 1309, (int) 1309, (String) "HoCoSto B.V."),
  SHENZHENASAI_TECHNOLOGY_CO_LTD(
      (int) 1310, (int) 1310, (String) "Shenzhen AS-AI Technology Co., Ltd."),
  RPS_SPA((int) 1311, (int) 1311, (String) "RPS S.p.a."),
  ESMSOLUTIONS((int) 1312, (int) 1312, (String) "Esmé solutions"),
  IO_TECH_SYSTEMS_LIMITED((int) 1313, (int) 1313, (String) "IOTech Systems Limited"),
  I_AUTO_LOGIC_CO_LTD((int) 1314, (int) 1314, (String) "i-AutoLogic Co., Ltd."),
  NEW_AGE_MICROLLC((int) 1315, (int) 1315, (String) "New Age Micro, LLC"),
  GUARDIAN_GLASS((int) 1316, (int) 1316, (String) "Guardian Glass"),
  GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY(
      (int) 1317, (int) 1317, (String) "Guangzhou Zhaoyu Information Technology"),
  ACE_IOT_SOLUTIONSLLC((int) 1318, (int) 1318, (String) "ACE IoT Solutions LLC"),
  PORIS_ELECTRONICS_CO_LTD((int) 1319, (int) 1319, (String) "Poris Electronics Co., Ltd."),
  TERMINUS_TECHNOLOGIES_GROUP((int) 1320, (int) 1320, (String) "Terminus Technologies Group"),
  INTECH1_INC((int) 1321, (int) 1321, (String) "Intech 21, Inc."),
  ACCURATE_ELECTRONICS((int) 1322, (int) 1322, (String) "Accurate Electronics"),
  FLUENCE_BIOENGINEERING((int) 1323, (int) 1323, (String) "Fluence Bioengineering"),
  MUN_HEAN_SINGAPORE_PTE_LTD((int) 1324, (int) 1324, (String) "Mun Hean Singapore Pte Ltd"),
  KATRONICAG_COKG((int) 1325, (int) 1325, (String) "Katronic AG & Co. KG"),
  SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD(
      (int) 1326, (int) 1326, (String) "Suzhou XinAo Information Technology Co. Ltd"),
  LINKTEKK_TECHNOLOGYJSC((int) 1327, (int) 1327, (String) "Linktekk Technology, JSC."),
  STIRLING_ULTRACOLD((int) 1328, (int) 1328, (String) "Stirling Ultracold"),
  UV_PARTNERS_INC((int) 1329, (int) 1329, (String) "UV Partners, Inc."),
  PRO_MINENT_GMBH((int) 1330, (int) 1330, (String) "ProMinent GmbH"),
  MULTI_TECH_SYSTEMS_INC((int) 1331, (int) 1331, (String) "Multi-Tech Systems, Inc."),
  JUMO_GMBH_COKG((int) 1332, (int) 1332, (String) "JUMO GmbH & Co. KG"),
  QINGDAO_HUARUI_TECHNOLOGY_CO_LTD(
      (int) 1333, (int) 1333, (String) "Qingdao Huarui Technology Co. Ltd.,"),
  CAIRN_SYSTEMES((int) 1334, (int) 1334, (String) "Cairn Systemes"),
  NEURO_LOGIC_RESEARCH_CORP((int) 1335, (int) 1335, (String) "NeuroLogic Research Corp."),
  TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO(
      (int) 1336, (int) 1336, (String) "Transition Technologies Advanced Solutions Sp. z o.o"),
  XXTERBV((int) 1337, (int) 1337, (String) "Xxter bv"),
  PASSIVE_LOGIC((int) 1338, (int) 1338, (String) "PassiveLogic"),
  EN_SMART_CONTROLS((int) 1339, (int) 1339, (String) "EnSmart Controls"),
  WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC(
      (int) 1340, (int) 1340, (String) "Watts Heating and Hot Water Solutions, dba Lync"),
  TROPOSPHAIRA_TECHNOLOGIESLLP((int) 1341, (int) 1341, (String) "Troposphaira Technologies LLP"),
  NETWORK_THERMOSTAT((int) 1342, (int) 1342, (String) "Network Thermostat"),
  TITANIUM_INTELLIGENT_SOLUTIONSLLC(
      (int) 1343, (int) 1343, (String) "Titanium Intelligent Solutions, LLC"),
  NUMA_PRODUCTSLLC((int) 1344, (int) 1344, (String) "Numa Products, LLC"),
  WAREMA_RENKHOFFSE((int) 1345, (int) 1345, (String) "WAREMA Renkhoff SE"),
  FRESEAS((int) 1346, (int) 1346, (String) "Frese A/S"),
  MAPPED((int) 1347, (int) 1347, (String) "Mapped"),
  ELEKTRODESIG_NVENTILATORYSRO((int) 1348, (int) 1348, (String) "ELEKTRODESIGN ventilatory s.r.o"),
  AIR_CARE_AUTOMATION_INC((int) 1349, (int) 1349, (String) "AirCare Automation, Inc."),
  ANTRUM((int) 1350, (int) 1350, (String) "Antrum"),
  BAO_LINH_CONNECT_TECHNOLOGY((int) 1351, (int) 1351, (String) "Bao Linh Connect Technology"),
  VIRGINIA_CONTROLSLLC((int) 1352, (int) 1352, (String) "Virginia Controls, LLC"),
  DUOSYSSDNBHD((int) 1353, (int) 1353, (String) "Duosys SDN BHD"),
  ONSENSAS((int) 1354, (int) 1354, (String) "Onsen SAS"),
  VAUGHN_THERMAL_CORPORATION((int) 1355, (int) 1355, (String) "Vaughn Thermal Corporation"),
  THERMOPLASTIC_ENGINEERING_LTDTPE(
      (int) 1356, (int) 1356, (String) "Thermoplastic Engineering Ltd (TPE)"),
  WIRTH_RESEARCH_LTD((int) 1357, (int) 1357, (String) "Wirth Research Ltd."),
  SST_AUTOMATION((int) 1358, (int) 1358, (String) "SST Automation"),
  SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD(
      (int) 1359, (int) 1359, (String) "Shanghai Bencol Electronic Technology Co., Ltd"),
  AIWAA_SYSTEMS_PRIVATE_LIMITED((int) 1360, (int) 1360, (String) "AIWAA Systems Private Limited"),
  ENLESS_WIRELESS((int) 1361, (int) 1361, (String) "Enless Wireless"),
  OZUNO_ENGINEERING_PTY_LTD((int) 1362, (int) 1362, (String) "Ozuno Engineering Pty Ltd"),
  HUBBELL_THE_ELECTRIC_HEATER_COMPANY(
      (int) 1363, (int) 1363, (String) "Hubbell, The Electric Heater Company"),
  INDUSTRIAL_TURNAROUND_CORPORATIONITAC(
      (int) 1364, (int) 1364, (String) "Industrial Turnaround Corporation (ITAC)"),
  WADSWORTH_CONTROL_SYSTEMS((int) 1365, (int) 1365, (String) "Wadsworth Control Systems"),
  SERVICES_HILO_INC((int) 1366, (int) 1366, (String) "Services Hilo Inc."),
  IDM_ENERGIESYSTEME_GMBH((int) 1367, (int) 1367, (String) "iDM Energiesysteme GmbH"),
  BE_NEXTBV((int) 1368, (int) 1368, (String) "BeNext B.V."),
  CLEAN_AIRAI_CORPORATION((int) 1369, (int) 1369, (String) "CleanAir.ai Corporation"),
  REVOLUTION_MICROELECTRONICS_AMERICA_INC(
      (int) 1370, (int) 1370, (String) "Revolution Microelectronics (America) Inc."),
  REAL_TIME_SYSTEMS_GMBH((int) 1371, (int) 1371, (String) "Real-Time Systems GmbH"),
  ZED_BEE_TECHNOLOGIES_PVT_LTD((int) 1372, (int) 1372, (String) "ZedBee Technologies Pvt Ltd"),
  WINMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD(
      (int) 1373, (int) 1373, (String) "Winmate Technology Solutions Pvt. Ltd."),
  SENTICON_LTD((int) 1374, (int) 1374, (String) "Senticon Ltd."),
  ROSSAKERAB((int) 1375, (int) 1375, (String) "Rossaker AB"),
  OPIT_SOLUTIONS_LTD((int) 1376, (int) 1376, (String) "OPIT Solutions Ltd"),
  HOTOWELL_INTERNATIONAL_CO_LIMITED(
      (int) 1377, (int) 1377, (String) "Hotowell International Co., Limited"),
  INIM_ELECTRONICSSRL_UNIPERSONALE(
      (int) 1378, (int) 1378, (String) "Inim Electronics S.R.L. Unipersonale"),
  AIRTHINGSASA((int) 1379, (int) 1379, (String) "Airthings ASA"),
  ANALOG_DEVICES_INC((int) 1380, (int) 1380, (String) "Analog Devices, Inc."),
  AI_DIRECTIONSDMCC((int) 1381, (int) 1381, (String) "AIDirections DMCC"),
  PRIMA_ELECTRO_SPA((int) 1382, (int) 1382, (String) "Prima Electro S.p.A."),
  KLT_CONTROL_SYSTEM_LTD((int) 1383, (int) 1383, (String) "KLT Control System Ltd."),
  EVOLUTION_CONTROLS_INC((int) 1384, (int) 1384, (String) "Evolution Controls Inc."),
  BEVER_INNOVATIONS((int) 1385, (int) 1385, (String) "Bever Innovations"),
  PELICAN_WIRELESS_SYSTEMS((int) 1386, (int) 1386, (String) "Pelican Wireless Systems"),
  CONTROL_CONCEPTS_INC((int) 1387, (int) 1387, (String) "Control Concepts Inc."),
  AUGMATIC_TECHNOLOGIES_PVT_LTD((int) 1388, (int) 1388, (String) "Augmatic Technologies Pvt. Ltd."),
  XIAMEN_MILESIGHTLOT_CO_LTD((int) 1389, (int) 1389, (String) "Xiamen Milesight loT Co., Ltd"),
  TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD(
      (int) 1390, (int) 1390, (String) "Tianjin Anjie loT Schience and Technology Co., Ltd"),
  GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD(
      (int) 1391, (int) 1391, (String) "Guangzhou S. Energy Electronics Technology Co. Ltd."),
  AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD(
      (int) 1392, (int) 1392, (String) "AKVO Atmospheric Water Systems Pvt. Ltd."),
  EM_FIRST_CO_LTD((int) 1393, (int) 1393, (String) "EmFirst Co. Ltd."),
  IION_SYSTEMS_APS((int) 1394, (int) 1394, (String) "Iion Systems ApS"),
  SAF_TEHNIKAJSC((int) 1396, (int) 1396, (String) "SAF Tehnika JSC"),
  KOMFORTIQ_INC((int) 1397, (int) 1397, (String) "Komfort IQ, Inc."),
  COOL_TERA_LIMITED((int) 1398, (int) 1398, (String) "CoolTera Limited"),
  HADRON_SOLUTIONS_SRLS((int) 1399, (int) 1399, (String) "Hadron Solutions S.r.l.s"),
  BITPOOL((int) 1401, (int) 1401, (String) "Bitpool"),
  SONICULLC((int) 1402, (int) 1402, (String) "Sonicu, LLC"),
  RISHABH_INSTRUMENTS_LIMITED((int) 1403, (int) 1403, (String) "Rishabh Instruments Limited"),
  THING_WAREHOUSELLC((int) 1404, (int) 1404, (String) "Thing Warehouse LLC"),
  INNOFRIENDS_GMBH((int) 1405, (int) 1405, (String) "Innofriends GmbH"),
  METRONICAKP_SPJ((int) 1406, (int) 1406, (String) "Metronic AKP Sp. J."),
  TECHKNAVE((int) 1407, (int) 1407, (String) "Techknave"),
  ELSNER_ELEKTRONIK((int) 1408, (int) 1408, (String) "Elsner Elektronik"),
  LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD(
      (int) 1409, (int) 1409, (String) "LEFOO Industrial (Hangzhou) Co., Ltd."),
  CALIBRATION_TECHNOLOGIES_INC((int) 1410, (int) 1410, (String) "Calibration Technologies, Inc."),
  ALLORADO((int) 1411, (int) 1411, (String) "Allorado"),
  VERKADA((int) 1412, (int) 1412, (String) "Verkada"),
  WATTSENSE((int) 1413, (int) 1413, (String) "Wattsense"),
  EMERSON_AUTOMATION_SOLUTIONS((int) 1414, (int) 1414, (String) "Emerson Automation Solutions"),
  GROWLINK((int) 1415, (int) 1415, (String) "Growlink"),
  OLYMPIA_ELECTRONICS((int) 1416, (int) 1416, (String) "Olympia Electronics"),
  NORMAL_SOFTWARE_INC((int) 1417, (int) 1417, (String) "Normal Software, Inc."),
  ST_ENGINEERING_SOLUTIONJSC((int) 1418, (int) 1418, (String) "ST Engineering Solution JSC"),
  INDUSTRIAL_FLOW_SOLUTIONS((int) 1419, (int) 1419, (String) "Industrial Flow Solutions"),
  UBIQISENSE_APS((int) 1420, (int) 1420, (String) "Ubiqisense ApS"),
  TIGER_SOFT((int) 1421, (int) 1421, (String) "Tiger-Soft"),
  ECODOM_SRL((int) 1422, (int) 1422, (String) "Ecodom Srl"),
  BILGIPRO_IOT_SYSTEMS((int) 1423, (int) 1423, (String) "Bilgipro IoT Systems"),
  PLANSPURNETDESIGN_GMBH((int) 1424, (int) 1424, (String) "planspur netdesign GmbH"),
  DOLPHIN_SOLUTIONS_LTD((int) 1425, (int) 1425, (String) "Dolphin Solutions Ltd"),
  MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS(
      (int) 1426, (int) 1426, (String) "Mitsubishi Electric Corporation, Kobe Works"),
  ECOVENA((int) 1427, (int) 1427, (String) "Ecovena"),
  GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI(
      (int) 1428, (int) 1428, (String) "Gree Electric Appliances Inc of Zhuhai"),
  CONSPEC_CONTROLS((int) 1429, (int) 1429, (String) "Conspec Controls"),
  HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD(
      (int) 1430, (int) 1430, (String) "Hangzhou Hikvision Digital Technology Co., Ltd."),
  CRYSTAL_PEAK_SECURITY((int) 1431, (int) 1431, (String) "Crystal Peak Security"),
  PERM_ALERT((int) 1432, (int) 1432, (String) "PermAlert"),
  ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD(
      (int) 1433, (int) 1433, (String) "Zhejiang Misilin Technology Co., Ltd."),
  DEKKER_VACUUM_TECHNOLOGIES((int) 1434, (int) 1434, (String) "Dekker Vacuum Technologies"),
  EDWARDS_LIMITED((int) 1435, (int) 1435, (String) "Edwards Limited"),
  LEYBOLD_GMBH((int) 1436, (int) 1436, (String) "Leybold GmbH"),
  INTERNATIONAL_GAS_DETECTORS((int) 1437, (int) 1437, (String) "International Gas Detectors"),
  ATLAS_COPCO_AIRPOWERNV((int) 1438, (int) 1438, (String) "Atlas Copco Airpower NV"),
  AIR_SENTRY_LIMITED((int) 1439, (int) 1439, (String) "Air Sentry Limited"),
  AELSYS((int) 1440, (int) 1440, (String) "Aelsys"),
  GRANBY_CONSULTINGLLC((int) 1441, (int) 1441, (String) "Granby Consulting LLC"),
  CLEVER_RELAY((int) 1442, (int) 1442, (String) "Clever Relay"),
  MONICO_MONITORING_INC((int) 1443, (int) 1443, (String) "Monico Monitoring, Inc."),
  OQDO((int) 1444, (int) 1444, (String) "Oqdo"),
  MATRIX_COMSEC_PRIVATE_LIMITED((int) 1445, (int) 1445, (String) "Matrix Comsec Private Limited"),
  RESOURCE_SOLUTIONS((int) 1446, (int) 1446, (String) "Resource Solutions"),
  AMERICAN_GAS_SAFETYLLC((int) 1447, (int) 1447, (String) "American Gas Safety, LLC"),
  SS_NORTHERN_LTD((int) 1448, (int) 1448, (String) "S&S Northern Ltd."),
  ULBIOS_TECHSENS((int) 1449, (int) 1449, (String) "Ulbios Techsens"),
  BOWERY_FARMING_INC((int) 1450, (int) 1450, (String) "Bowery Farming, Inc."),
  RYOBI_LIMITED((int) 1451, (int) 1451, (String) "Ryobi Limited"),
  EKKO_SENSE_LTD((int) 1452, (int) 1452, (String) "EkkoSense Ltd"),
  CLIMA_COOL((int) 1453, (int) 1453, (String) "ClimaCool"),
  GRID_CONNECT_INC((int) 1454, (int) 1454, (String) "Grid Connect Inc."),
  ZIEGLER_INSTRUMENTATIONUK_LTD((int) 1455, (int) 1455, (String) "Ziegler Instrumentation UK Ltd"),
  CONTROL_TECLLC((int) 1456, (int) 1456, (String) "ControlTec, LLC"),
  AETERLINK_CORPORATION((int) 1457, (int) 1457, (String) "Aeterlink Corporation"),
  ALPHA_EPSILON_AUTOMATION((int) 1458, (int) 1458, (String) "Alpha Epsilon Automation"),
  ASTRALITE_INC((int) 1459, (int) 1459, (String) "Astralite Inc."),
  DELTA_FIRE_LTDA((int) 1460, (int) 1460, (String) "Delta Fire Ltda."),
  BOCK_WATER_HEATERS_INC((int) 1461, (int) 1461, (String) "Bock Water Heaters, Inc."),
  CLEAVER_BROOKS((int) 1462, (int) 1462, (String) "Cleaver-Brooks"),
  UNKNOWN_VENDOR((int) 0xFFFF, (int) 0xFFFF, (String) "Unknown");
  private static final Map<Integer, BACnetVendorId> map;

  static {
    map = new HashMap<>();
    for (BACnetVendorId value : BACnetVendorId.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;
  private final int vendorId;
  private final String vendorName;

  BACnetVendorId(int value, int vendorId, String vendorName) {
    this.value = value;
    this.vendorId = vendorId;
    this.vendorName = vendorName;
  }

  public int getValue() {
    return value;
  }

  public int getVendorId() {
    return vendorId;
  }

  public static BACnetVendorId firstEnumForFieldVendorId(int fieldValue) {
    for (BACnetVendorId _val : BACnetVendorId.values()) {
      if (_val.getVendorId() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<BACnetVendorId> enumsForFieldVendorId(int fieldValue) {
    List<BACnetVendorId> _values = new ArrayList<>();
    for (BACnetVendorId _val : BACnetVendorId.values()) {
      if (_val.getVendorId() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getVendorName() {
    return vendorName;
  }

  public static BACnetVendorId firstEnumForFieldVendorName(String fieldValue) {
    for (BACnetVendorId _val : BACnetVendorId.values()) {
      if (_val.getVendorName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<BACnetVendorId> enumsForFieldVendorName(String fieldValue) {
    List<BACnetVendorId> _values = new ArrayList<>();
    for (BACnetVendorId _val : BACnetVendorId.values()) {
      if (_val.getVendorName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static BACnetVendorId enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
