/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTagPayloadCharacterString implements Message {

  // Properties.
  protected final BACnetCharacterEncoding encoding;
  protected final String value;

  // Arguments.
  protected final Long actualLength;

  public BACnetTagPayloadCharacterString(
      BACnetCharacterEncoding encoding, String value, Long actualLength) {
    super();
    this.encoding = encoding;
    this.value = value;
    this.actualLength = actualLength;
  }

  public BACnetCharacterEncoding getEncoding() {
    return encoding;
  }

  public String getValue() {
    return value;
  }

  public int getActualLengthInBit() {
    return (int) (((actualLength) * (8)) - (8));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTagPayloadCharacterString");

    // Simple Field (encoding)
    writeSimpleEnumField(
        "encoding",
        "BACnetCharacterEncoding",
        encoding,
        new DataWriterEnumDefault<>(
            BACnetCharacterEncoding::getValue,
            BACnetCharacterEncoding::name,
            writeByte(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    int actualLengthInBit = getActualLengthInBit();
    writeBuffer.writeVirtual("actualLengthInBit", actualLengthInBit);

    // Simple Field (value)
    writeSimpleField(
        "value",
        value,
        writeString(writeBuffer, actualLengthInBit),
        WithOption.WithEncoding("UTF-8"));

    writeBuffer.popContext("BACnetTagPayloadCharacterString");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetTagPayloadCharacterString _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (encoding)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (value)
    lengthInBits += getActualLengthInBit();

    return lengthInBits;
  }

  public static BACnetTagPayloadCharacterString staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Long actualLength;
    if (args[0] instanceof Long) {
      actualLength = (Long) args[0];
    } else if (args[0] instanceof String) {
      actualLength = Long.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Long or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, actualLength);
  }

  public static BACnetTagPayloadCharacterString staticParse(
      ReadBuffer readBuffer, Long actualLength) throws ParseException {
    readBuffer.pullContext("BACnetTagPayloadCharacterString");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetCharacterEncoding encoding =
        readEnumField(
            "encoding",
            "BACnetCharacterEncoding",
            new DataReaderEnumDefault<>(
                BACnetCharacterEncoding::enumForValue, readByte(readBuffer, 8)));
    int actualLengthInBit =
        readVirtualField("actualLengthInBit", int.class, ((actualLength) * (8)) - (8));

    String value =
        readSimpleField(
            "value", readString(readBuffer, actualLengthInBit), WithOption.WithEncoding("UTF-8"));

    readBuffer.closeContext("BACnetTagPayloadCharacterString");
    // Create the instance
    BACnetTagPayloadCharacterString _bACnetTagPayloadCharacterString;
    _bACnetTagPayloadCharacterString =
        new BACnetTagPayloadCharacterString(encoding, value, actualLength);
    return _bACnetTagPayloadCharacterString;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTagPayloadCharacterString)) {
      return false;
    }
    BACnetTagPayloadCharacterString that = (BACnetTagPayloadCharacterString) o;
    return (getEncoding() == that.getEncoding()) && (getValue() == that.getValue()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getEncoding(), getValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
