/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetShedLevelLevel extends BACnetShedLevel implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetContextTagUnsignedInteger level;

  public BACnetShedLevelLevel(
      BACnetTagHeader peekedTagHeader, BACnetContextTagUnsignedInteger level) {
    super(peekedTagHeader);
    this.level = level;
  }

  public BACnetContextTagUnsignedInteger getLevel() {
    return level;
  }

  @Override
  protected void serializeBACnetShedLevelChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetShedLevelLevel");

    // Simple Field (level)
    writeSimpleField("level", level, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetShedLevelLevel");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetShedLevelLevel _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (level)
    lengthInBits += level.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetShedLevelBuilder staticParseBACnetShedLevelBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetShedLevelLevel");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger level =
        readSimpleField(
            "level",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetShedLevelLevel");
    // Create the instance
    return new BACnetShedLevelLevelBuilderImpl(level);
  }

  public static class BACnetShedLevelLevelBuilderImpl
      implements BACnetShedLevel.BACnetShedLevelBuilder {
    private final BACnetContextTagUnsignedInteger level;

    public BACnetShedLevelLevelBuilderImpl(BACnetContextTagUnsignedInteger level) {
      this.level = level;
    }

    public BACnetShedLevelLevel build(BACnetTagHeader peekedTagHeader) {
      BACnetShedLevelLevel bACnetShedLevelLevel = new BACnetShedLevelLevel(peekedTagHeader, level);
      return bACnetShedLevelLevel;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetShedLevelLevel)) {
      return false;
    }
    BACnetShedLevelLevel that = (BACnetShedLevelLevel) o;
    return (getLevel() == that.getLevel()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getLevel());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
