/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetRecipientAddress extends BACnetRecipient implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetAddressEnclosed addressValue;

  public BACnetRecipientAddress(
      BACnetTagHeader peekedTagHeader, BACnetAddressEnclosed addressValue) {
    super(peekedTagHeader);
    this.addressValue = addressValue;
  }

  public BACnetAddressEnclosed getAddressValue() {
    return addressValue;
  }

  @Override
  protected void serializeBACnetRecipientChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetRecipientAddress");

    // Simple Field (addressValue)
    writeSimpleField("addressValue", addressValue, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetRecipientAddress");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetRecipientAddress _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (addressValue)
    lengthInBits += addressValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetRecipientBuilder staticParseBACnetRecipientBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetRecipientAddress");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetAddressEnclosed addressValue =
        readSimpleField(
            "addressValue",
            new DataReaderComplexDefault<>(
                () -> BACnetAddressEnclosed.staticParse(readBuffer, (short) (1)), readBuffer));

    readBuffer.closeContext("BACnetRecipientAddress");
    // Create the instance
    return new BACnetRecipientAddressBuilderImpl(addressValue);
  }

  public static class BACnetRecipientAddressBuilderImpl
      implements BACnetRecipient.BACnetRecipientBuilder {
    private final BACnetAddressEnclosed addressValue;

    public BACnetRecipientAddressBuilderImpl(BACnetAddressEnclosed addressValue) {
      this.addressValue = addressValue;
    }

    public BACnetRecipientAddress build(BACnetTagHeader peekedTagHeader) {
      BACnetRecipientAddress bACnetRecipientAddress =
          new BACnetRecipientAddress(peekedTagHeader, addressValue);
      return bACnetRecipientAddress;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetRecipientAddress)) {
      return false;
    }
    BACnetRecipientAddress that = (BACnetRecipientAddress) o;
    return (getAddressValue() == that.getAddressValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAddressValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
