/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestAtomicWriteFile extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.ATOMIC_WRITE_FILE;
  }

  // Properties.
  protected final BACnetApplicationTagObjectIdentifier deviceIdentifier;
  protected final BACnetOpeningTag openingTag;
  protected final BACnetApplicationTagSignedInteger fileStartPosition;
  protected final BACnetApplicationTagOctetString fileData;
  protected final BACnetClosingTag closingTag;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestAtomicWriteFile(
      BACnetApplicationTagObjectIdentifier deviceIdentifier,
      BACnetOpeningTag openingTag,
      BACnetApplicationTagSignedInteger fileStartPosition,
      BACnetApplicationTagOctetString fileData,
      BACnetClosingTag closingTag,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.deviceIdentifier = deviceIdentifier;
    this.openingTag = openingTag;
    this.fileStartPosition = fileStartPosition;
    this.fileData = fileData;
    this.closingTag = closingTag;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetApplicationTagObjectIdentifier getDeviceIdentifier() {
    return deviceIdentifier;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public BACnetApplicationTagSignedInteger getFileStartPosition() {
    return fileStartPosition;
  }

  public BACnetApplicationTagOctetString getFileData() {
    return fileData;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestAtomicWriteFile");

    // Simple Field (deviceIdentifier)
    writeSimpleField(
        "deviceIdentifier", deviceIdentifier, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (openingTag) (Can be skipped, if the value is null)
    writeOptionalField("openingTag", openingTag, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (fileStartPosition)
    writeSimpleField(
        "fileStartPosition", fileStartPosition, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (fileData)
    writeSimpleField("fileData", fileData, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (closingTag) (Can be skipped, if the value is null)
    writeOptionalField("closingTag", closingTag, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestAtomicWriteFile");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestAtomicWriteFile _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (deviceIdentifier)
    lengthInBits += deviceIdentifier.getLengthInBits();

    // Optional Field (openingTag)
    if (openingTag != null) {
      lengthInBits += openingTag.getLengthInBits();
    }

    // Simple field (fileStartPosition)
    lengthInBits += fileStartPosition.getLengthInBits();

    // Simple field (fileData)
    lengthInBits += fileData.getLengthInBits();

    // Optional Field (closingTag)
    if (closingTag != null) {
      lengthInBits += closingTag.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestAtomicWriteFile");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetApplicationTagObjectIdentifier deviceIdentifier =
        readSimpleField(
            "deviceIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetApplicationTagObjectIdentifier)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetOpeningTag openingTag =
        readOptionalField(
            "openingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetApplicationTagSignedInteger fileStartPosition =
        readSimpleField(
            "fileStartPosition",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetApplicationTagSignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetApplicationTagOctetString fileData =
        readSimpleField(
            "fileData",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetApplicationTagOctetString) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetClosingTag closingTag =
        readOptionalField(
            "closingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (0)), readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestAtomicWriteFile");
    // Create the instance
    return new BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl(
        deviceIdentifier,
        openingTag,
        fileStartPosition,
        fileData,
        closingTag,
        serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetApplicationTagObjectIdentifier deviceIdentifier;
    private final BACnetOpeningTag openingTag;
    private final BACnetApplicationTagSignedInteger fileStartPosition;
    private final BACnetApplicationTagOctetString fileData;
    private final BACnetClosingTag closingTag;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl(
        BACnetApplicationTagObjectIdentifier deviceIdentifier,
        BACnetOpeningTag openingTag,
        BACnetApplicationTagSignedInteger fileStartPosition,
        BACnetApplicationTagOctetString fileData,
        BACnetClosingTag closingTag,
        Long serviceRequestLength) {
      this.deviceIdentifier = deviceIdentifier;
      this.openingTag = openingTag;
      this.fileStartPosition = fileStartPosition;
      this.fileData = fileData;
      this.closingTag = closingTag;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestAtomicWriteFile build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestAtomicWriteFile bACnetConfirmedServiceRequestAtomicWriteFile =
          new BACnetConfirmedServiceRequestAtomicWriteFile(
              deviceIdentifier,
              openingTag,
              fileStartPosition,
              fileData,
              closingTag,
              serviceRequestLength);
      return bACnetConfirmedServiceRequestAtomicWriteFile;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestAtomicWriteFile)) {
      return false;
    }
    BACnetConfirmedServiceRequestAtomicWriteFile that =
        (BACnetConfirmedServiceRequestAtomicWriteFile) o;
    return (getDeviceIdentifier() == that.getDeviceIdentifier())
        && (getOpeningTag() == that.getOpeningTag())
        && (getFileStartPosition() == that.getFileStartPosition())
        && (getFileData() == that.getFileData())
        && (getClosingTag() == that.getClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDeviceIdentifier(),
        getOpeningTag(),
        getFileStartPosition(),
        getFileData(),
        getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
