/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class APDUAbort extends APDU implements Message {

  // Accessors for discriminator values.
  public ApduType getApduType() {
    return ApduType.ABORT_PDU;
  }

  // Properties.
  protected final boolean server;
  protected final short originalInvokeId;
  protected final BACnetAbortReasonTagged abortReason;

  // Arguments.
  protected final Integer apduLength;
  // Reserved Fields
  private Byte reservedField0;

  public APDUAbort(
      boolean server,
      short originalInvokeId,
      BACnetAbortReasonTagged abortReason,
      Integer apduLength) {
    super(apduLength);
    this.server = server;
    this.originalInvokeId = originalInvokeId;
    this.abortReason = abortReason;
    this.apduLength = apduLength;
  }

  public boolean getServer() {
    return server;
  }

  public short getOriginalInvokeId() {
    return originalInvokeId;
  }

  public BACnetAbortReasonTagged getAbortReason() {
    return abortReason;
  }

  @Override
  protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("APDUAbort");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 3));

    // Simple Field (server)
    writeSimpleField("server", server, writeBoolean(writeBuffer));

    // Simple Field (originalInvokeId)
    writeSimpleField("originalInvokeId", originalInvokeId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (abortReason)
    writeSimpleField("abortReason", abortReason, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("APDUAbort");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    APDUAbort _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 3;

    // Simple field (server)
    lengthInBits += 1;

    // Simple field (originalInvokeId)
    lengthInBits += 8;

    // Simple field (abortReason)
    lengthInBits += abortReason.getLengthInBits();

    return lengthInBits;
  }

  public static APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("APDUAbort");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

    boolean server = readSimpleField("server", readBoolean(readBuffer));

    short originalInvokeId = readSimpleField("originalInvokeId", readUnsignedShort(readBuffer, 8));

    BACnetAbortReasonTagged abortReason =
        readSimpleField(
            "abortReason",
            new DataReaderComplexDefault<>(
                () -> BACnetAbortReasonTagged.staticParse(readBuffer, (long) (1L)), readBuffer));

    readBuffer.closeContext("APDUAbort");
    // Create the instance
    return new APDUAbortBuilderImpl(
        server, originalInvokeId, abortReason, apduLength, reservedField0);
  }

  public static class APDUAbortBuilderImpl implements APDU.APDUBuilder {
    private final boolean server;
    private final short originalInvokeId;
    private final BACnetAbortReasonTagged abortReason;
    private final Integer apduLength;
    private final Byte reservedField0;

    public APDUAbortBuilderImpl(
        boolean server,
        short originalInvokeId,
        BACnetAbortReasonTagged abortReason,
        Integer apduLength,
        Byte reservedField0) {
      this.server = server;
      this.originalInvokeId = originalInvokeId;
      this.abortReason = abortReason;
      this.apduLength = apduLength;
      this.reservedField0 = reservedField0;
    }

    public APDUAbort build(Integer apduLength) {

      APDUAbort aPDUAbort = new APDUAbort(server, originalInvokeId, abortReason, apduLength);
      aPDUAbort.reservedField0 = reservedField0;
      return aPDUAbort;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof APDUAbort)) {
      return false;
    }
    APDUAbort that = (APDUAbort) o;
    return (getServer() == that.getServer())
        && (getOriginalInvokeId() == that.getOriginalInvokeId())
        && (getAbortReason() == that.getAbortReason())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getServer(), getOriginalInvokeId(), getAbortReason());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
