/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsDiscoveryBlockUserName extends AdsDiscoveryBlock implements Message {

  // Accessors for discriminator values.
  public AdsDiscoveryBlockType getBlockType() {
    return AdsDiscoveryBlockType.USER_NAME;
  }

  // Properties.
  protected final AmsString userName;

  public AdsDiscoveryBlockUserName(AmsString userName) {
    super();
    this.userName = userName;
  }

  public AmsString getUserName() {
    return userName;
  }

  @Override
  protected void serializeAdsDiscoveryBlockChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AdsDiscoveryBlockUserName");

    // Simple Field (userName)
    writeSimpleField("userName", userName, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("AdsDiscoveryBlockUserName");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsDiscoveryBlockUserName _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (userName)
    lengthInBits += userName.getLengthInBits();

    return lengthInBits;
  }

  public static AdsDiscoveryBlockBuilder staticParseAdsDiscoveryBlockBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AdsDiscoveryBlockUserName");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    AmsString userName =
        readSimpleField(
            "userName",
            new DataReaderComplexDefault<>(() -> AmsString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AdsDiscoveryBlockUserName");
    // Create the instance
    return new AdsDiscoveryBlockUserNameBuilderImpl(userName);
  }

  public static class AdsDiscoveryBlockUserNameBuilderImpl
      implements AdsDiscoveryBlock.AdsDiscoveryBlockBuilder {
    private final AmsString userName;

    public AdsDiscoveryBlockUserNameBuilderImpl(AmsString userName) {
      this.userName = userName;
    }

    public AdsDiscoveryBlockUserName build() {
      AdsDiscoveryBlockUserName adsDiscoveryBlockUserName = new AdsDiscoveryBlockUserName(userName);
      return adsDiscoveryBlockUserName;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsDiscoveryBlockUserName)) {
      return false;
    }
    AdsDiscoveryBlockUserName that = (AdsDiscoveryBlockUserName) o;
    return (getUserName() == that.getUserName()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getUserName());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
