/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItemCyclicServicesSubscribeRequest is the corresponding interface of S7PayloadUserDataItemCyclicServicesSubscribeRequest
type S7PayloadUserDataItemCyclicServicesSubscribeRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	S7PayloadUserDataItem
	// GetItemsCount returns ItemsCount (property field)
	GetItemsCount() uint16
	// GetTimeBase returns TimeBase (property field)
	GetTimeBase() TimeBase
	// GetTimeFactor returns TimeFactor (property field)
	GetTimeFactor() uint8
	// GetItem returns Item (property field)
	GetItem() []CycServiceItemType
}

// S7PayloadUserDataItemCyclicServicesSubscribeRequestExactly can be used when we want exactly this type and not a type which fulfills S7PayloadUserDataItemCyclicServicesSubscribeRequest.
// This is useful for switch cases.
type S7PayloadUserDataItemCyclicServicesSubscribeRequestExactly interface {
	S7PayloadUserDataItemCyclicServicesSubscribeRequest
	isS7PayloadUserDataItemCyclicServicesSubscribeRequest() bool
}

// _S7PayloadUserDataItemCyclicServicesSubscribeRequest is the data-structure of this message
type _S7PayloadUserDataItemCyclicServicesSubscribeRequest struct {
	*_S7PayloadUserDataItem
	ItemsCount uint16
	TimeBase   TimeBase
	TimeFactor uint8
	Item       []CycServiceItemType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuFunctionGroup() uint8 {
	return 0x02
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuFunctionType() uint8 {
	return 0x04
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetCpuSubfunction() uint8 {
	return 0x01
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) InitializeParent(parent S7PayloadUserDataItem, returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) {
	m.ReturnCode = returnCode
	m.TransportSize = transportSize
	m.DataLength = dataLength
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetParent() S7PayloadUserDataItem {
	return m._S7PayloadUserDataItem
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetItemsCount() uint16 {
	return m.ItemsCount
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTimeBase() TimeBase {
	return m.TimeBase
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTimeFactor() uint8 {
	return m.TimeFactor
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetItem() []CycServiceItemType {
	return m.Item
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewS7PayloadUserDataItemCyclicServicesSubscribeRequest factory function for _S7PayloadUserDataItemCyclicServicesSubscribeRequest
func NewS7PayloadUserDataItemCyclicServicesSubscribeRequest(itemsCount uint16, timeBase TimeBase, timeFactor uint8, item []CycServiceItemType, returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) *_S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	_result := &_S7PayloadUserDataItemCyclicServicesSubscribeRequest{
		ItemsCount:             itemsCount,
		TimeBase:               timeBase,
		TimeFactor:             timeFactor,
		Item:                   item,
		_S7PayloadUserDataItem: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
	}
	_result._S7PayloadUserDataItem._S7PayloadUserDataItemChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItemCyclicServicesSubscribeRequest(structType any) S7PayloadUserDataItemCyclicServicesSubscribeRequest {
	if casted, ok := structType.(S7PayloadUserDataItemCyclicServicesSubscribeRequest); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItemCyclicServicesSubscribeRequest); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetTypeName() string {
	return "S7PayloadUserDataItemCyclicServicesSubscribeRequest"
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (itemsCount)
	lengthInBits += 16

	// Simple field (timeBase)
	lengthInBits += 8

	// Simple field (timeFactor)
	lengthInBits += 8

	// Array field
	if len(m.Item) > 0 {
		for _curItem, element := range m.Item {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Item), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func S7PayloadUserDataItemCyclicServicesSubscribeRequestParse(ctx context.Context, theBytes []byte, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (S7PayloadUserDataItemCyclicServicesSubscribeRequest, error) {
	return S7PayloadUserDataItemCyclicServicesSubscribeRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
}

func S7PayloadUserDataItemCyclicServicesSubscribeRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (S7PayloadUserDataItemCyclicServicesSubscribeRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (itemsCount)
	_itemsCount, _itemsCountErr := readBuffer.ReadUint16("itemsCount", 16)
	if _itemsCountErr != nil {
		return nil, errors.Wrap(_itemsCountErr, "Error parsing 'itemsCount' field of S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}
	itemsCount := _itemsCount

	// Simple Field (timeBase)
	if pullErr := readBuffer.PullContext("timeBase"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for timeBase")
	}
	_timeBase, _timeBaseErr := TimeBaseParseWithBuffer(ctx, readBuffer)
	if _timeBaseErr != nil {
		return nil, errors.Wrap(_timeBaseErr, "Error parsing 'timeBase' field of S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}
	timeBase := _timeBase
	if closeErr := readBuffer.CloseContext("timeBase"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for timeBase")
	}

	// Simple Field (timeFactor)
	_timeFactor, _timeFactorErr := readBuffer.ReadUint8("timeFactor", 8)
	if _timeFactorErr != nil {
		return nil, errors.Wrap(_timeFactorErr, "Error parsing 'timeFactor' field of S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}
	timeFactor := _timeFactor

	// Array field (item)
	if pullErr := readBuffer.PullContext("item", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for item")
	}
	// Count array
	item := make([]CycServiceItemType, utils.Max(itemsCount, 0))
	// This happens when the size is set conditional to 0
	if len(item) == 0 {
		item = nil
	}
	{
		_numItems := uint16(utils.Max(itemsCount, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := CycServiceItemTypeParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'item' field of S7PayloadUserDataItemCyclicServicesSubscribeRequest")
			}
			item[_curItem] = _item.(CycServiceItemType)
		}
	}
	if closeErr := readBuffer.CloseContext("item", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for item")
	}

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
	}

	// Create a partially initialized instance
	_child := &_S7PayloadUserDataItemCyclicServicesSubscribeRequest{
		_S7PayloadUserDataItem: &_S7PayloadUserDataItem{},
		ItemsCount:             itemsCount,
		TimeBase:               timeBase,
		TimeFactor:             timeFactor,
		Item:                   item,
	}
	_child._S7PayloadUserDataItem._S7PayloadUserDataItemChildRequirements = _child
	return _child, nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
		}

		// Simple Field (itemsCount)
		itemsCount := uint16(m.GetItemsCount())
		_itemsCountErr := writeBuffer.WriteUint16("itemsCount", 16, uint16((itemsCount)))
		if _itemsCountErr != nil {
			return errors.Wrap(_itemsCountErr, "Error serializing 'itemsCount' field")
		}

		// Simple Field (timeBase)
		if pushErr := writeBuffer.PushContext("timeBase"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for timeBase")
		}
		_timeBaseErr := writeBuffer.WriteSerializable(ctx, m.GetTimeBase())
		if popErr := writeBuffer.PopContext("timeBase"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for timeBase")
		}
		if _timeBaseErr != nil {
			return errors.Wrap(_timeBaseErr, "Error serializing 'timeBase' field")
		}

		// Simple Field (timeFactor)
		timeFactor := uint8(m.GetTimeFactor())
		_timeFactorErr := writeBuffer.WriteUint8("timeFactor", 8, uint8((timeFactor)))
		if _timeFactorErr != nil {
			return errors.Wrap(_timeFactorErr, "Error serializing 'timeFactor' field")
		}

		// Array Field (item)
		if pushErr := writeBuffer.PushContext("item", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for item")
		}
		for _curItem, _element := range m.GetItem() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetItem()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'item' field")
			}
		}
		if popErr := writeBuffer.PopContext("item", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for item")
		}

		if popErr := writeBuffer.PopContext("S7PayloadUserDataItemCyclicServicesSubscribeRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItemCyclicServicesSubscribeRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) isS7PayloadUserDataItemCyclicServicesSubscribeRequest() bool {
	return true
}

func (m *_S7PayloadUserDataItemCyclicServicesSubscribeRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
