/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const CycServiceItemType_FUNCTIONID uint8 = 0x12

// CycServiceItemType is the corresponding interface of CycServiceItemType
type CycServiceItemType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetByteLength returns ByteLength (property field)
	GetByteLength() uint8
	// GetSyntaxId returns SyntaxId (property field)
	GetSyntaxId() uint8
}

// CycServiceItemTypeExactly can be used when we want exactly this type and not a type which fulfills CycServiceItemType.
// This is useful for switch cases.
type CycServiceItemTypeExactly interface {
	CycServiceItemType
	isCycServiceItemType() bool
}

// _CycServiceItemType is the data-structure of this message
type _CycServiceItemType struct {
	_CycServiceItemTypeChildRequirements
	ByteLength uint8
	SyntaxId   uint8
}

type _CycServiceItemTypeChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetSyntaxId() uint8
}

type CycServiceItemTypeParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child CycServiceItemType, serializeChildFunction func() error) error
	GetTypeName() string
}

type CycServiceItemTypeChild interface {
	utils.Serializable
	InitializeParent(parent CycServiceItemType, byteLength uint8, syntaxId uint8)
	GetParent() *CycServiceItemType

	GetTypeName() string
	CycServiceItemType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CycServiceItemType) GetByteLength() uint8 {
	return m.ByteLength
}

func (m *_CycServiceItemType) GetSyntaxId() uint8 {
	return m.SyntaxId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_CycServiceItemType) GetFunctionId() uint8 {
	return CycServiceItemType_FUNCTIONID
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCycServiceItemType factory function for _CycServiceItemType
func NewCycServiceItemType(byteLength uint8, syntaxId uint8) *_CycServiceItemType {
	return &_CycServiceItemType{ByteLength: byteLength, SyntaxId: syntaxId}
}

// Deprecated: use the interface for direct cast
func CastCycServiceItemType(structType any) CycServiceItemType {
	if casted, ok := structType.(CycServiceItemType); ok {
		return casted
	}
	if casted, ok := structType.(*CycServiceItemType); ok {
		return *casted
	}
	return nil
}

func (m *_CycServiceItemType) GetTypeName() string {
	return "CycServiceItemType"
}

func (m *_CycServiceItemType) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (functionId)
	lengthInBits += 8

	// Simple field (byteLength)
	lengthInBits += 8

	// Simple field (syntaxId)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CycServiceItemType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CycServiceItemTypeParse(ctx context.Context, theBytes []byte) (CycServiceItemType, error) {
	return CycServiceItemTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func CycServiceItemTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (CycServiceItemType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("CycServiceItemType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CycServiceItemType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Const Field (functionId)
	functionId, _functionIdErr := readBuffer.ReadUint8("functionId", 8)
	if _functionIdErr != nil {
		return nil, errors.Wrap(_functionIdErr, "Error parsing 'functionId' field of CycServiceItemType")
	}
	if functionId != CycServiceItemType_FUNCTIONID {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CycServiceItemType_FUNCTIONID) + " but got " + fmt.Sprintf("%d", functionId))
	}

	// Simple Field (byteLength)
	_byteLength, _byteLengthErr := readBuffer.ReadUint8("byteLength", 8)
	if _byteLengthErr != nil {
		return nil, errors.Wrap(_byteLengthErr, "Error parsing 'byteLength' field of CycServiceItemType")
	}
	byteLength := _byteLength

	// Simple Field (syntaxId)
	_syntaxId, _syntaxIdErr := readBuffer.ReadUint8("syntaxId", 8)
	if _syntaxIdErr != nil {
		return nil, errors.Wrap(_syntaxIdErr, "Error parsing 'syntaxId' field of CycServiceItemType")
	}
	syntaxId := _syntaxId

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type CycServiceItemTypeChildSerializeRequirement interface {
		CycServiceItemType
		InitializeParent(CycServiceItemType, uint8, uint8)
		GetParent() CycServiceItemType
	}
	var _childTemp any
	var _child CycServiceItemTypeChildSerializeRequirement
	var typeSwitchError error
	switch {
	case syntaxId == 0x10: // CycServiceItemAnyType
		_childTemp, typeSwitchError = CycServiceItemAnyTypeParseWithBuffer(ctx, readBuffer)
	case syntaxId == 0xb0: // CycServiceItemDbReadType
		_childTemp, typeSwitchError = CycServiceItemDbReadTypeParseWithBuffer(ctx, readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [syntaxId=%v]", syntaxId)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of CycServiceItemType")
	}
	_child = _childTemp.(CycServiceItemTypeChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("CycServiceItemType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CycServiceItemType")
	}

	// Finish initializing
	_child.InitializeParent(_child, byteLength, syntaxId)
	return _child, nil
}

func (pm *_CycServiceItemType) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child CycServiceItemType, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("CycServiceItemType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CycServiceItemType")
	}

	// Const Field (functionId)
	_functionIdErr := writeBuffer.WriteUint8("functionId", 8, uint8(0x12))
	if _functionIdErr != nil {
		return errors.Wrap(_functionIdErr, "Error serializing 'functionId' field")
	}

	// Simple Field (byteLength)
	byteLength := uint8(m.GetByteLength())
	_byteLengthErr := writeBuffer.WriteUint8("byteLength", 8, uint8((byteLength)))
	if _byteLengthErr != nil {
		return errors.Wrap(_byteLengthErr, "Error serializing 'byteLength' field")
	}

	// Simple Field (syntaxId)
	syntaxId := uint8(m.GetSyntaxId())
	_syntaxIdErr := writeBuffer.WriteUint8("syntaxId", 8, uint8((syntaxId)))
	if _syntaxIdErr != nil {
		return errors.Wrap(_syntaxIdErr, "Error serializing 'syntaxId' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("CycServiceItemType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CycServiceItemType")
	}
	return nil
}

func (m *_CycServiceItemType) isCycServiceItemType() bool {
	return true
}

func (m *_CycServiceItemType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
