/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// TwoByteNodeId is the corresponding interface of TwoByteNodeId
type TwoByteNodeId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetIdentifier returns Identifier (property field)
	GetIdentifier() uint8
}

// TwoByteNodeIdExactly can be used when we want exactly this type and not a type which fulfills TwoByteNodeId.
// This is useful for switch cases.
type TwoByteNodeIdExactly interface {
	TwoByteNodeId
	isTwoByteNodeId() bool
}

// _TwoByteNodeId is the data-structure of this message
type _TwoByteNodeId struct {
	Identifier uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TwoByteNodeId) GetIdentifier() uint8 {
	return m.Identifier
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewTwoByteNodeId factory function for _TwoByteNodeId
func NewTwoByteNodeId(identifier uint8) *_TwoByteNodeId {
	return &_TwoByteNodeId{Identifier: identifier}
}

// Deprecated: use the interface for direct cast
func CastTwoByteNodeId(structType any) TwoByteNodeId {
	if casted, ok := structType.(TwoByteNodeId); ok {
		return casted
	}
	if casted, ok := structType.(*TwoByteNodeId); ok {
		return *casted
	}
	return nil
}

func (m *_TwoByteNodeId) GetTypeName() string {
	return "TwoByteNodeId"
}

func (m *_TwoByteNodeId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (identifier)
	lengthInBits += 8

	return lengthInBits
}

func (m *_TwoByteNodeId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func TwoByteNodeIdParse(ctx context.Context, theBytes []byte) (TwoByteNodeId, error) {
	return TwoByteNodeIdParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func TwoByteNodeIdParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (TwoByteNodeId, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("TwoByteNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TwoByteNodeId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (identifier)
	_identifier, _identifierErr := readBuffer.ReadUint8("identifier", 8)
	if _identifierErr != nil {
		return nil, errors.Wrap(_identifierErr, "Error parsing 'identifier' field of TwoByteNodeId")
	}
	identifier := _identifier

	if closeErr := readBuffer.CloseContext("TwoByteNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TwoByteNodeId")
	}

	// Create the instance
	return &_TwoByteNodeId{
		Identifier: identifier,
	}, nil
}

func (m *_TwoByteNodeId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TwoByteNodeId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("TwoByteNodeId"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for TwoByteNodeId")
	}

	// Simple Field (identifier)
	identifier := uint8(m.GetIdentifier())
	_identifierErr := writeBuffer.WriteUint8("identifier", 8, uint8((identifier)))
	if _identifierErr != nil {
		return errors.Wrap(_identifierErr, "Error serializing 'identifier' field")
	}

	if popErr := writeBuffer.PopContext("TwoByteNodeId"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for TwoByteNodeId")
	}
	return nil
}

func (m *_TwoByteNodeId) isTwoByteNodeId() bool {
	return true
}

func (m *_TwoByteNodeId) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
