/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// TsnFailureCode is an enum
type TsnFailureCode uint32

type ITsnFailureCode interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	TsnFailureCode_tsnFailureCodeNoFailure                         TsnFailureCode = 0
	TsnFailureCode_tsnFailureCodeInsufficientBandwidth             TsnFailureCode = 1
	TsnFailureCode_tsnFailureCodeInsufficientResources             TsnFailureCode = 2
	TsnFailureCode_tsnFailureCodeInsufficientTrafficClassBandwidth TsnFailureCode = 3
	TsnFailureCode_tsnFailureCodeStreamIdInUse                     TsnFailureCode = 4
	TsnFailureCode_tsnFailureCodeStreamDestinationAddressInUse     TsnFailureCode = 5
	TsnFailureCode_tsnFailureCodeStreamPreemptedByHigherRank       TsnFailureCode = 6
	TsnFailureCode_tsnFailureCodeLatencyHasChanged                 TsnFailureCode = 7
	TsnFailureCode_tsnFailureCodeEgressPortNotAvbCapable           TsnFailureCode = 8
	TsnFailureCode_tsnFailureCodeUseDifferentDestinationAddress    TsnFailureCode = 9
	TsnFailureCode_tsnFailureCodeOutOfMsrpResources                TsnFailureCode = 10
	TsnFailureCode_tsnFailureCodeOutOfMmrpResources                TsnFailureCode = 11
	TsnFailureCode_tsnFailureCodeCannotStoreDestinationAddress     TsnFailureCode = 12
	TsnFailureCode_tsnFailureCodePriorityIsNotAnSrcClass           TsnFailureCode = 13
	TsnFailureCode_tsnFailureCodeMaxFrameSizeTooLarge              TsnFailureCode = 14
	TsnFailureCode_tsnFailureCodeMaxFanInPortsLimitReached         TsnFailureCode = 15
	TsnFailureCode_tsnFailureCodeFirstValueChangedForStreamId      TsnFailureCode = 16
	TsnFailureCode_tsnFailureCodeVlanBlockedOnEgress               TsnFailureCode = 17
	TsnFailureCode_tsnFailureCodeVlanTaggingDisabledOnEgress       TsnFailureCode = 18
	TsnFailureCode_tsnFailureCodeSrClassPriorityMismatch           TsnFailureCode = 19
	TsnFailureCode_tsnFailureCodeFeatureNotPropagated              TsnFailureCode = 20
	TsnFailureCode_tsnFailureCodeMaxLatencyExceeded                TsnFailureCode = 21
	TsnFailureCode_tsnFailureCodeBridgeDoesNotProvideNetworkId     TsnFailureCode = 22
	TsnFailureCode_tsnFailureCodeStreamTransformNotSupported       TsnFailureCode = 23
	TsnFailureCode_tsnFailureCodeStreamIdTypeNotSupported          TsnFailureCode = 24
	TsnFailureCode_tsnFailureCodeFeatureNotSupported               TsnFailureCode = 25
)

var TsnFailureCodeValues []TsnFailureCode

func init() {
	_ = errors.New
	TsnFailureCodeValues = []TsnFailureCode{
		TsnFailureCode_tsnFailureCodeNoFailure,
		TsnFailureCode_tsnFailureCodeInsufficientBandwidth,
		TsnFailureCode_tsnFailureCodeInsufficientResources,
		TsnFailureCode_tsnFailureCodeInsufficientTrafficClassBandwidth,
		TsnFailureCode_tsnFailureCodeStreamIdInUse,
		TsnFailureCode_tsnFailureCodeStreamDestinationAddressInUse,
		TsnFailureCode_tsnFailureCodeStreamPreemptedByHigherRank,
		TsnFailureCode_tsnFailureCodeLatencyHasChanged,
		TsnFailureCode_tsnFailureCodeEgressPortNotAvbCapable,
		TsnFailureCode_tsnFailureCodeUseDifferentDestinationAddress,
		TsnFailureCode_tsnFailureCodeOutOfMsrpResources,
		TsnFailureCode_tsnFailureCodeOutOfMmrpResources,
		TsnFailureCode_tsnFailureCodeCannotStoreDestinationAddress,
		TsnFailureCode_tsnFailureCodePriorityIsNotAnSrcClass,
		TsnFailureCode_tsnFailureCodeMaxFrameSizeTooLarge,
		TsnFailureCode_tsnFailureCodeMaxFanInPortsLimitReached,
		TsnFailureCode_tsnFailureCodeFirstValueChangedForStreamId,
		TsnFailureCode_tsnFailureCodeVlanBlockedOnEgress,
		TsnFailureCode_tsnFailureCodeVlanTaggingDisabledOnEgress,
		TsnFailureCode_tsnFailureCodeSrClassPriorityMismatch,
		TsnFailureCode_tsnFailureCodeFeatureNotPropagated,
		TsnFailureCode_tsnFailureCodeMaxLatencyExceeded,
		TsnFailureCode_tsnFailureCodeBridgeDoesNotProvideNetworkId,
		TsnFailureCode_tsnFailureCodeStreamTransformNotSupported,
		TsnFailureCode_tsnFailureCodeStreamIdTypeNotSupported,
		TsnFailureCode_tsnFailureCodeFeatureNotSupported,
	}
}

func TsnFailureCodeByValue(value uint32) (enum TsnFailureCode, ok bool) {
	switch value {
	case 0:
		return TsnFailureCode_tsnFailureCodeNoFailure, true
	case 1:
		return TsnFailureCode_tsnFailureCodeInsufficientBandwidth, true
	case 10:
		return TsnFailureCode_tsnFailureCodeOutOfMsrpResources, true
	case 11:
		return TsnFailureCode_tsnFailureCodeOutOfMmrpResources, true
	case 12:
		return TsnFailureCode_tsnFailureCodeCannotStoreDestinationAddress, true
	case 13:
		return TsnFailureCode_tsnFailureCodePriorityIsNotAnSrcClass, true
	case 14:
		return TsnFailureCode_tsnFailureCodeMaxFrameSizeTooLarge, true
	case 15:
		return TsnFailureCode_tsnFailureCodeMaxFanInPortsLimitReached, true
	case 16:
		return TsnFailureCode_tsnFailureCodeFirstValueChangedForStreamId, true
	case 17:
		return TsnFailureCode_tsnFailureCodeVlanBlockedOnEgress, true
	case 18:
		return TsnFailureCode_tsnFailureCodeVlanTaggingDisabledOnEgress, true
	case 19:
		return TsnFailureCode_tsnFailureCodeSrClassPriorityMismatch, true
	case 2:
		return TsnFailureCode_tsnFailureCodeInsufficientResources, true
	case 20:
		return TsnFailureCode_tsnFailureCodeFeatureNotPropagated, true
	case 21:
		return TsnFailureCode_tsnFailureCodeMaxLatencyExceeded, true
	case 22:
		return TsnFailureCode_tsnFailureCodeBridgeDoesNotProvideNetworkId, true
	case 23:
		return TsnFailureCode_tsnFailureCodeStreamTransformNotSupported, true
	case 24:
		return TsnFailureCode_tsnFailureCodeStreamIdTypeNotSupported, true
	case 25:
		return TsnFailureCode_tsnFailureCodeFeatureNotSupported, true
	case 3:
		return TsnFailureCode_tsnFailureCodeInsufficientTrafficClassBandwidth, true
	case 4:
		return TsnFailureCode_tsnFailureCodeStreamIdInUse, true
	case 5:
		return TsnFailureCode_tsnFailureCodeStreamDestinationAddressInUse, true
	case 6:
		return TsnFailureCode_tsnFailureCodeStreamPreemptedByHigherRank, true
	case 7:
		return TsnFailureCode_tsnFailureCodeLatencyHasChanged, true
	case 8:
		return TsnFailureCode_tsnFailureCodeEgressPortNotAvbCapable, true
	case 9:
		return TsnFailureCode_tsnFailureCodeUseDifferentDestinationAddress, true
	}
	return 0, false
}

func TsnFailureCodeByName(value string) (enum TsnFailureCode, ok bool) {
	switch value {
	case "tsnFailureCodeNoFailure":
		return TsnFailureCode_tsnFailureCodeNoFailure, true
	case "tsnFailureCodeInsufficientBandwidth":
		return TsnFailureCode_tsnFailureCodeInsufficientBandwidth, true
	case "tsnFailureCodeOutOfMsrpResources":
		return TsnFailureCode_tsnFailureCodeOutOfMsrpResources, true
	case "tsnFailureCodeOutOfMmrpResources":
		return TsnFailureCode_tsnFailureCodeOutOfMmrpResources, true
	case "tsnFailureCodeCannotStoreDestinationAddress":
		return TsnFailureCode_tsnFailureCodeCannotStoreDestinationAddress, true
	case "tsnFailureCodePriorityIsNotAnSrcClass":
		return TsnFailureCode_tsnFailureCodePriorityIsNotAnSrcClass, true
	case "tsnFailureCodeMaxFrameSizeTooLarge":
		return TsnFailureCode_tsnFailureCodeMaxFrameSizeTooLarge, true
	case "tsnFailureCodeMaxFanInPortsLimitReached":
		return TsnFailureCode_tsnFailureCodeMaxFanInPortsLimitReached, true
	case "tsnFailureCodeFirstValueChangedForStreamId":
		return TsnFailureCode_tsnFailureCodeFirstValueChangedForStreamId, true
	case "tsnFailureCodeVlanBlockedOnEgress":
		return TsnFailureCode_tsnFailureCodeVlanBlockedOnEgress, true
	case "tsnFailureCodeVlanTaggingDisabledOnEgress":
		return TsnFailureCode_tsnFailureCodeVlanTaggingDisabledOnEgress, true
	case "tsnFailureCodeSrClassPriorityMismatch":
		return TsnFailureCode_tsnFailureCodeSrClassPriorityMismatch, true
	case "tsnFailureCodeInsufficientResources":
		return TsnFailureCode_tsnFailureCodeInsufficientResources, true
	case "tsnFailureCodeFeatureNotPropagated":
		return TsnFailureCode_tsnFailureCodeFeatureNotPropagated, true
	case "tsnFailureCodeMaxLatencyExceeded":
		return TsnFailureCode_tsnFailureCodeMaxLatencyExceeded, true
	case "tsnFailureCodeBridgeDoesNotProvideNetworkId":
		return TsnFailureCode_tsnFailureCodeBridgeDoesNotProvideNetworkId, true
	case "tsnFailureCodeStreamTransformNotSupported":
		return TsnFailureCode_tsnFailureCodeStreamTransformNotSupported, true
	case "tsnFailureCodeStreamIdTypeNotSupported":
		return TsnFailureCode_tsnFailureCodeStreamIdTypeNotSupported, true
	case "tsnFailureCodeFeatureNotSupported":
		return TsnFailureCode_tsnFailureCodeFeatureNotSupported, true
	case "tsnFailureCodeInsufficientTrafficClassBandwidth":
		return TsnFailureCode_tsnFailureCodeInsufficientTrafficClassBandwidth, true
	case "tsnFailureCodeStreamIdInUse":
		return TsnFailureCode_tsnFailureCodeStreamIdInUse, true
	case "tsnFailureCodeStreamDestinationAddressInUse":
		return TsnFailureCode_tsnFailureCodeStreamDestinationAddressInUse, true
	case "tsnFailureCodeStreamPreemptedByHigherRank":
		return TsnFailureCode_tsnFailureCodeStreamPreemptedByHigherRank, true
	case "tsnFailureCodeLatencyHasChanged":
		return TsnFailureCode_tsnFailureCodeLatencyHasChanged, true
	case "tsnFailureCodeEgressPortNotAvbCapable":
		return TsnFailureCode_tsnFailureCodeEgressPortNotAvbCapable, true
	case "tsnFailureCodeUseDifferentDestinationAddress":
		return TsnFailureCode_tsnFailureCodeUseDifferentDestinationAddress, true
	}
	return 0, false
}

func TsnFailureCodeKnows(value uint32) bool {
	for _, typeValue := range TsnFailureCodeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastTsnFailureCode(structType any) TsnFailureCode {
	castFunc := func(typ any) TsnFailureCode {
		if sTsnFailureCode, ok := typ.(TsnFailureCode); ok {
			return sTsnFailureCode
		}
		return 0
	}
	return castFunc(structType)
}

func (m TsnFailureCode) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m TsnFailureCode) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func TsnFailureCodeParse(ctx context.Context, theBytes []byte) (TsnFailureCode, error) {
	return TsnFailureCodeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func TsnFailureCodeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (TsnFailureCode, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("TsnFailureCode", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading TsnFailureCode")
	}
	if enum, ok := TsnFailureCodeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for TsnFailureCode")
		return TsnFailureCode(val), nil
	} else {
		return enum, nil
	}
}

func (e TsnFailureCode) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e TsnFailureCode) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("TsnFailureCode", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e TsnFailureCode) PLC4XEnumName() string {
	switch e {
	case TsnFailureCode_tsnFailureCodeNoFailure:
		return "tsnFailureCodeNoFailure"
	case TsnFailureCode_tsnFailureCodeInsufficientBandwidth:
		return "tsnFailureCodeInsufficientBandwidth"
	case TsnFailureCode_tsnFailureCodeOutOfMsrpResources:
		return "tsnFailureCodeOutOfMsrpResources"
	case TsnFailureCode_tsnFailureCodeOutOfMmrpResources:
		return "tsnFailureCodeOutOfMmrpResources"
	case TsnFailureCode_tsnFailureCodeCannotStoreDestinationAddress:
		return "tsnFailureCodeCannotStoreDestinationAddress"
	case TsnFailureCode_tsnFailureCodePriorityIsNotAnSrcClass:
		return "tsnFailureCodePriorityIsNotAnSrcClass"
	case TsnFailureCode_tsnFailureCodeMaxFrameSizeTooLarge:
		return "tsnFailureCodeMaxFrameSizeTooLarge"
	case TsnFailureCode_tsnFailureCodeMaxFanInPortsLimitReached:
		return "tsnFailureCodeMaxFanInPortsLimitReached"
	case TsnFailureCode_tsnFailureCodeFirstValueChangedForStreamId:
		return "tsnFailureCodeFirstValueChangedForStreamId"
	case TsnFailureCode_tsnFailureCodeVlanBlockedOnEgress:
		return "tsnFailureCodeVlanBlockedOnEgress"
	case TsnFailureCode_tsnFailureCodeVlanTaggingDisabledOnEgress:
		return "tsnFailureCodeVlanTaggingDisabledOnEgress"
	case TsnFailureCode_tsnFailureCodeSrClassPriorityMismatch:
		return "tsnFailureCodeSrClassPriorityMismatch"
	case TsnFailureCode_tsnFailureCodeInsufficientResources:
		return "tsnFailureCodeInsufficientResources"
	case TsnFailureCode_tsnFailureCodeFeatureNotPropagated:
		return "tsnFailureCodeFeatureNotPropagated"
	case TsnFailureCode_tsnFailureCodeMaxLatencyExceeded:
		return "tsnFailureCodeMaxLatencyExceeded"
	case TsnFailureCode_tsnFailureCodeBridgeDoesNotProvideNetworkId:
		return "tsnFailureCodeBridgeDoesNotProvideNetworkId"
	case TsnFailureCode_tsnFailureCodeStreamTransformNotSupported:
		return "tsnFailureCodeStreamTransformNotSupported"
	case TsnFailureCode_tsnFailureCodeStreamIdTypeNotSupported:
		return "tsnFailureCodeStreamIdTypeNotSupported"
	case TsnFailureCode_tsnFailureCodeFeatureNotSupported:
		return "tsnFailureCodeFeatureNotSupported"
	case TsnFailureCode_tsnFailureCodeInsufficientTrafficClassBandwidth:
		return "tsnFailureCodeInsufficientTrafficClassBandwidth"
	case TsnFailureCode_tsnFailureCodeStreamIdInUse:
		return "tsnFailureCodeStreamIdInUse"
	case TsnFailureCode_tsnFailureCodeStreamDestinationAddressInUse:
		return "tsnFailureCodeStreamDestinationAddressInUse"
	case TsnFailureCode_tsnFailureCodeStreamPreemptedByHigherRank:
		return "tsnFailureCodeStreamPreemptedByHigherRank"
	case TsnFailureCode_tsnFailureCodeLatencyHasChanged:
		return "tsnFailureCodeLatencyHasChanged"
	case TsnFailureCode_tsnFailureCodeEgressPortNotAvbCapable:
		return "tsnFailureCodeEgressPortNotAvbCapable"
	case TsnFailureCode_tsnFailureCodeUseDifferentDestinationAddress:
		return "tsnFailureCodeUseDifferentDestinationAddress"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e TsnFailureCode) String() string {
	return e.PLC4XEnumName()
}
