/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SubscriptionAcknowledgement is the corresponding interface of SubscriptionAcknowledgement
type SubscriptionAcknowledgement interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() uint32
}

// SubscriptionAcknowledgementExactly can be used when we want exactly this type and not a type which fulfills SubscriptionAcknowledgement.
// This is useful for switch cases.
type SubscriptionAcknowledgementExactly interface {
	SubscriptionAcknowledgement
	isSubscriptionAcknowledgement() bool
}

// _SubscriptionAcknowledgement is the data-structure of this message
type _SubscriptionAcknowledgement struct {
	*_ExtensionObjectDefinition
	SubscriptionId uint32
	SequenceNumber uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SubscriptionAcknowledgement) GetIdentifier() string {
	return "823"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SubscriptionAcknowledgement) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SubscriptionAcknowledgement) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SubscriptionAcknowledgement) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_SubscriptionAcknowledgement) GetSequenceNumber() uint32 {
	return m.SequenceNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSubscriptionAcknowledgement factory function for _SubscriptionAcknowledgement
func NewSubscriptionAcknowledgement(subscriptionId uint32, sequenceNumber uint32) *_SubscriptionAcknowledgement {
	_result := &_SubscriptionAcknowledgement{
		SubscriptionId:             subscriptionId,
		SequenceNumber:             sequenceNumber,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSubscriptionAcknowledgement(structType any) SubscriptionAcknowledgement {
	if casted, ok := structType.(SubscriptionAcknowledgement); ok {
		return casted
	}
	if casted, ok := structType.(*SubscriptionAcknowledgement); ok {
		return *casted
	}
	return nil
}

func (m *_SubscriptionAcknowledgement) GetTypeName() string {
	return "SubscriptionAcknowledgement"
}

func (m *_SubscriptionAcknowledgement) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (sequenceNumber)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SubscriptionAcknowledgement) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SubscriptionAcknowledgementParse(ctx context.Context, theBytes []byte, identifier string) (SubscriptionAcknowledgement, error) {
	return SubscriptionAcknowledgementParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SubscriptionAcknowledgementParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SubscriptionAcknowledgement, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SubscriptionAcknowledgement"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SubscriptionAcknowledgement")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (subscriptionId)
	_subscriptionId, _subscriptionIdErr := readBuffer.ReadUint32("subscriptionId", 32)
	if _subscriptionIdErr != nil {
		return nil, errors.Wrap(_subscriptionIdErr, "Error parsing 'subscriptionId' field of SubscriptionAcknowledgement")
	}
	subscriptionId := _subscriptionId

	// Simple Field (sequenceNumber)
	_sequenceNumber, _sequenceNumberErr := readBuffer.ReadUint32("sequenceNumber", 32)
	if _sequenceNumberErr != nil {
		return nil, errors.Wrap(_sequenceNumberErr, "Error parsing 'sequenceNumber' field of SubscriptionAcknowledgement")
	}
	sequenceNumber := _sequenceNumber

	if closeErr := readBuffer.CloseContext("SubscriptionAcknowledgement"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SubscriptionAcknowledgement")
	}

	// Create a partially initialized instance
	_child := &_SubscriptionAcknowledgement{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		SubscriptionId:             subscriptionId,
		SequenceNumber:             sequenceNumber,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SubscriptionAcknowledgement) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SubscriptionAcknowledgement) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SubscriptionAcknowledgement"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SubscriptionAcknowledgement")
		}

		// Simple Field (subscriptionId)
		subscriptionId := uint32(m.GetSubscriptionId())
		_subscriptionIdErr := writeBuffer.WriteUint32("subscriptionId", 32, uint32((subscriptionId)))
		if _subscriptionIdErr != nil {
			return errors.Wrap(_subscriptionIdErr, "Error serializing 'subscriptionId' field")
		}

		// Simple Field (sequenceNumber)
		sequenceNumber := uint32(m.GetSequenceNumber())
		_sequenceNumberErr := writeBuffer.WriteUint32("sequenceNumber", 32, uint32((sequenceNumber)))
		if _sequenceNumberErr != nil {
			return errors.Wrap(_sequenceNumberErr, "Error serializing 'sequenceNumber' field")
		}

		if popErr := writeBuffer.PopContext("SubscriptionAcknowledgement"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SubscriptionAcknowledgement")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SubscriptionAcknowledgement) isSubscriptionAcknowledgement() bool {
	return true
}

func (m *_SubscriptionAcknowledgement) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
