/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SignedSoftwareCertificate is the corresponding interface of SignedSoftwareCertificate
type SignedSoftwareCertificate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetCertificateData returns CertificateData (property field)
	GetCertificateData() PascalByteString
	// GetSignature returns Signature (property field)
	GetSignature() PascalByteString
}

// SignedSoftwareCertificateExactly can be used when we want exactly this type and not a type which fulfills SignedSoftwareCertificate.
// This is useful for switch cases.
type SignedSoftwareCertificateExactly interface {
	SignedSoftwareCertificate
	isSignedSoftwareCertificate() bool
}

// _SignedSoftwareCertificate is the data-structure of this message
type _SignedSoftwareCertificate struct {
	*_ExtensionObjectDefinition
	CertificateData PascalByteString
	Signature       PascalByteString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SignedSoftwareCertificate) GetIdentifier() string {
	return "346"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SignedSoftwareCertificate) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SignedSoftwareCertificate) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SignedSoftwareCertificate) GetCertificateData() PascalByteString {
	return m.CertificateData
}

func (m *_SignedSoftwareCertificate) GetSignature() PascalByteString {
	return m.Signature
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSignedSoftwareCertificate factory function for _SignedSoftwareCertificate
func NewSignedSoftwareCertificate(certificateData PascalByteString, signature PascalByteString) *_SignedSoftwareCertificate {
	_result := &_SignedSoftwareCertificate{
		CertificateData:            certificateData,
		Signature:                  signature,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSignedSoftwareCertificate(structType any) SignedSoftwareCertificate {
	if casted, ok := structType.(SignedSoftwareCertificate); ok {
		return casted
	}
	if casted, ok := structType.(*SignedSoftwareCertificate); ok {
		return *casted
	}
	return nil
}

func (m *_SignedSoftwareCertificate) GetTypeName() string {
	return "SignedSoftwareCertificate"
}

func (m *_SignedSoftwareCertificate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (certificateData)
	lengthInBits += m.CertificateData.GetLengthInBits(ctx)

	// Simple field (signature)
	lengthInBits += m.Signature.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SignedSoftwareCertificate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SignedSoftwareCertificateParse(ctx context.Context, theBytes []byte, identifier string) (SignedSoftwareCertificate, error) {
	return SignedSoftwareCertificateParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SignedSoftwareCertificateParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SignedSoftwareCertificate, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SignedSoftwareCertificate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SignedSoftwareCertificate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (certificateData)
	if pullErr := readBuffer.PullContext("certificateData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for certificateData")
	}
	_certificateData, _certificateDataErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _certificateDataErr != nil {
		return nil, errors.Wrap(_certificateDataErr, "Error parsing 'certificateData' field of SignedSoftwareCertificate")
	}
	certificateData := _certificateData.(PascalByteString)
	if closeErr := readBuffer.CloseContext("certificateData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for certificateData")
	}

	// Simple Field (signature)
	if pullErr := readBuffer.PullContext("signature"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for signature")
	}
	_signature, _signatureErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _signatureErr != nil {
		return nil, errors.Wrap(_signatureErr, "Error parsing 'signature' field of SignedSoftwareCertificate")
	}
	signature := _signature.(PascalByteString)
	if closeErr := readBuffer.CloseContext("signature"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for signature")
	}

	if closeErr := readBuffer.CloseContext("SignedSoftwareCertificate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SignedSoftwareCertificate")
	}

	// Create a partially initialized instance
	_child := &_SignedSoftwareCertificate{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		CertificateData:            certificateData,
		Signature:                  signature,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SignedSoftwareCertificate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SignedSoftwareCertificate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SignedSoftwareCertificate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SignedSoftwareCertificate")
		}

		// Simple Field (certificateData)
		if pushErr := writeBuffer.PushContext("certificateData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for certificateData")
		}
		_certificateDataErr := writeBuffer.WriteSerializable(ctx, m.GetCertificateData())
		if popErr := writeBuffer.PopContext("certificateData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for certificateData")
		}
		if _certificateDataErr != nil {
			return errors.Wrap(_certificateDataErr, "Error serializing 'certificateData' field")
		}

		// Simple Field (signature)
		if pushErr := writeBuffer.PushContext("signature"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for signature")
		}
		_signatureErr := writeBuffer.WriteSerializable(ctx, m.GetSignature())
		if popErr := writeBuffer.PopContext("signature"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for signature")
		}
		if _signatureErr != nil {
			return errors.Wrap(_signatureErr, "Error serializing 'signature' field")
		}

		if popErr := writeBuffer.PopContext("SignedSoftwareCertificate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SignedSoftwareCertificate")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SignedSoftwareCertificate) isSignedSoftwareCertificate() bool {
	return true
}

func (m *_SignedSoftwareCertificate) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
