/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SessionDiagnosticsDataType is the corresponding interface of SessionDiagnosticsDataType
type SessionDiagnosticsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetSessionId returns SessionId (property field)
	GetSessionId() NodeId
	// GetSessionName returns SessionName (property field)
	GetSessionName() PascalString
	// GetClientDescription returns ClientDescription (property field)
	GetClientDescription() ExtensionObjectDefinition
	// GetServerUri returns ServerUri (property field)
	GetServerUri() PascalString
	// GetEndpointUrl returns EndpointUrl (property field)
	GetEndpointUrl() PascalString
	// GetNoOfLocaleIds returns NoOfLocaleIds (property field)
	GetNoOfLocaleIds() int32
	// GetLocaleIds returns LocaleIds (property field)
	GetLocaleIds() []PascalString
	// GetActualSessionTimeout returns ActualSessionTimeout (property field)
	GetActualSessionTimeout() float64
	// GetMaxResponseMessageSize returns MaxResponseMessageSize (property field)
	GetMaxResponseMessageSize() uint32
	// GetClientConnectionTime returns ClientConnectionTime (property field)
	GetClientConnectionTime() int64
	// GetClientLastContactTime returns ClientLastContactTime (property field)
	GetClientLastContactTime() int64
	// GetCurrentSubscriptionsCount returns CurrentSubscriptionsCount (property field)
	GetCurrentSubscriptionsCount() uint32
	// GetCurrentMonitoredItemsCount returns CurrentMonitoredItemsCount (property field)
	GetCurrentMonitoredItemsCount() uint32
	// GetCurrentPublishRequestsInQueue returns CurrentPublishRequestsInQueue (property field)
	GetCurrentPublishRequestsInQueue() uint32
	// GetTotalRequestCount returns TotalRequestCount (property field)
	GetTotalRequestCount() ExtensionObjectDefinition
	// GetUnauthorizedRequestCount returns UnauthorizedRequestCount (property field)
	GetUnauthorizedRequestCount() uint32
	// GetReadCount returns ReadCount (property field)
	GetReadCount() ExtensionObjectDefinition
	// GetHistoryReadCount returns HistoryReadCount (property field)
	GetHistoryReadCount() ExtensionObjectDefinition
	// GetWriteCount returns WriteCount (property field)
	GetWriteCount() ExtensionObjectDefinition
	// GetHistoryUpdateCount returns HistoryUpdateCount (property field)
	GetHistoryUpdateCount() ExtensionObjectDefinition
	// GetCallCount returns CallCount (property field)
	GetCallCount() ExtensionObjectDefinition
	// GetCreateMonitoredItemsCount returns CreateMonitoredItemsCount (property field)
	GetCreateMonitoredItemsCount() ExtensionObjectDefinition
	// GetModifyMonitoredItemsCount returns ModifyMonitoredItemsCount (property field)
	GetModifyMonitoredItemsCount() ExtensionObjectDefinition
	// GetSetMonitoringModeCount returns SetMonitoringModeCount (property field)
	GetSetMonitoringModeCount() ExtensionObjectDefinition
	// GetSetTriggeringCount returns SetTriggeringCount (property field)
	GetSetTriggeringCount() ExtensionObjectDefinition
	// GetDeleteMonitoredItemsCount returns DeleteMonitoredItemsCount (property field)
	GetDeleteMonitoredItemsCount() ExtensionObjectDefinition
	// GetCreateSubscriptionCount returns CreateSubscriptionCount (property field)
	GetCreateSubscriptionCount() ExtensionObjectDefinition
	// GetModifySubscriptionCount returns ModifySubscriptionCount (property field)
	GetModifySubscriptionCount() ExtensionObjectDefinition
	// GetSetPublishingModeCount returns SetPublishingModeCount (property field)
	GetSetPublishingModeCount() ExtensionObjectDefinition
	// GetPublishCount returns PublishCount (property field)
	GetPublishCount() ExtensionObjectDefinition
	// GetRepublishCount returns RepublishCount (property field)
	GetRepublishCount() ExtensionObjectDefinition
	// GetTransferSubscriptionsCount returns TransferSubscriptionsCount (property field)
	GetTransferSubscriptionsCount() ExtensionObjectDefinition
	// GetDeleteSubscriptionsCount returns DeleteSubscriptionsCount (property field)
	GetDeleteSubscriptionsCount() ExtensionObjectDefinition
	// GetAddNodesCount returns AddNodesCount (property field)
	GetAddNodesCount() ExtensionObjectDefinition
	// GetAddReferencesCount returns AddReferencesCount (property field)
	GetAddReferencesCount() ExtensionObjectDefinition
	// GetDeleteNodesCount returns DeleteNodesCount (property field)
	GetDeleteNodesCount() ExtensionObjectDefinition
	// GetDeleteReferencesCount returns DeleteReferencesCount (property field)
	GetDeleteReferencesCount() ExtensionObjectDefinition
	// GetBrowseCount returns BrowseCount (property field)
	GetBrowseCount() ExtensionObjectDefinition
	// GetBrowseNextCount returns BrowseNextCount (property field)
	GetBrowseNextCount() ExtensionObjectDefinition
	// GetTranslateBrowsePathsToNodeIdsCount returns TranslateBrowsePathsToNodeIdsCount (property field)
	GetTranslateBrowsePathsToNodeIdsCount() ExtensionObjectDefinition
	// GetQueryFirstCount returns QueryFirstCount (property field)
	GetQueryFirstCount() ExtensionObjectDefinition
	// GetQueryNextCount returns QueryNextCount (property field)
	GetQueryNextCount() ExtensionObjectDefinition
	// GetRegisterNodesCount returns RegisterNodesCount (property field)
	GetRegisterNodesCount() ExtensionObjectDefinition
	// GetUnregisterNodesCount returns UnregisterNodesCount (property field)
	GetUnregisterNodesCount() ExtensionObjectDefinition
}

// SessionDiagnosticsDataTypeExactly can be used when we want exactly this type and not a type which fulfills SessionDiagnosticsDataType.
// This is useful for switch cases.
type SessionDiagnosticsDataTypeExactly interface {
	SessionDiagnosticsDataType
	isSessionDiagnosticsDataType() bool
}

// _SessionDiagnosticsDataType is the data-structure of this message
type _SessionDiagnosticsDataType struct {
	*_ExtensionObjectDefinition
	SessionId                          NodeId
	SessionName                        PascalString
	ClientDescription                  ExtensionObjectDefinition
	ServerUri                          PascalString
	EndpointUrl                        PascalString
	NoOfLocaleIds                      int32
	LocaleIds                          []PascalString
	ActualSessionTimeout               float64
	MaxResponseMessageSize             uint32
	ClientConnectionTime               int64
	ClientLastContactTime              int64
	CurrentSubscriptionsCount          uint32
	CurrentMonitoredItemsCount         uint32
	CurrentPublishRequestsInQueue      uint32
	TotalRequestCount                  ExtensionObjectDefinition
	UnauthorizedRequestCount           uint32
	ReadCount                          ExtensionObjectDefinition
	HistoryReadCount                   ExtensionObjectDefinition
	WriteCount                         ExtensionObjectDefinition
	HistoryUpdateCount                 ExtensionObjectDefinition
	CallCount                          ExtensionObjectDefinition
	CreateMonitoredItemsCount          ExtensionObjectDefinition
	ModifyMonitoredItemsCount          ExtensionObjectDefinition
	SetMonitoringModeCount             ExtensionObjectDefinition
	SetTriggeringCount                 ExtensionObjectDefinition
	DeleteMonitoredItemsCount          ExtensionObjectDefinition
	CreateSubscriptionCount            ExtensionObjectDefinition
	ModifySubscriptionCount            ExtensionObjectDefinition
	SetPublishingModeCount             ExtensionObjectDefinition
	PublishCount                       ExtensionObjectDefinition
	RepublishCount                     ExtensionObjectDefinition
	TransferSubscriptionsCount         ExtensionObjectDefinition
	DeleteSubscriptionsCount           ExtensionObjectDefinition
	AddNodesCount                      ExtensionObjectDefinition
	AddReferencesCount                 ExtensionObjectDefinition
	DeleteNodesCount                   ExtensionObjectDefinition
	DeleteReferencesCount              ExtensionObjectDefinition
	BrowseCount                        ExtensionObjectDefinition
	BrowseNextCount                    ExtensionObjectDefinition
	TranslateBrowsePathsToNodeIdsCount ExtensionObjectDefinition
	QueryFirstCount                    ExtensionObjectDefinition
	QueryNextCount                     ExtensionObjectDefinition
	RegisterNodesCount                 ExtensionObjectDefinition
	UnregisterNodesCount               ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SessionDiagnosticsDataType) GetIdentifier() string {
	return "867"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SessionDiagnosticsDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SessionDiagnosticsDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SessionDiagnosticsDataType) GetSessionId() NodeId {
	return m.SessionId
}

func (m *_SessionDiagnosticsDataType) GetSessionName() PascalString {
	return m.SessionName
}

func (m *_SessionDiagnosticsDataType) GetClientDescription() ExtensionObjectDefinition {
	return m.ClientDescription
}

func (m *_SessionDiagnosticsDataType) GetServerUri() PascalString {
	return m.ServerUri
}

func (m *_SessionDiagnosticsDataType) GetEndpointUrl() PascalString {
	return m.EndpointUrl
}

func (m *_SessionDiagnosticsDataType) GetNoOfLocaleIds() int32 {
	return m.NoOfLocaleIds
}

func (m *_SessionDiagnosticsDataType) GetLocaleIds() []PascalString {
	return m.LocaleIds
}

func (m *_SessionDiagnosticsDataType) GetActualSessionTimeout() float64 {
	return m.ActualSessionTimeout
}

func (m *_SessionDiagnosticsDataType) GetMaxResponseMessageSize() uint32 {
	return m.MaxResponseMessageSize
}

func (m *_SessionDiagnosticsDataType) GetClientConnectionTime() int64 {
	return m.ClientConnectionTime
}

func (m *_SessionDiagnosticsDataType) GetClientLastContactTime() int64 {
	return m.ClientLastContactTime
}

func (m *_SessionDiagnosticsDataType) GetCurrentSubscriptionsCount() uint32 {
	return m.CurrentSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetCurrentMonitoredItemsCount() uint32 {
	return m.CurrentMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetCurrentPublishRequestsInQueue() uint32 {
	return m.CurrentPublishRequestsInQueue
}

func (m *_SessionDiagnosticsDataType) GetTotalRequestCount() ExtensionObjectDefinition {
	return m.TotalRequestCount
}

func (m *_SessionDiagnosticsDataType) GetUnauthorizedRequestCount() uint32 {
	return m.UnauthorizedRequestCount
}

func (m *_SessionDiagnosticsDataType) GetReadCount() ExtensionObjectDefinition {
	return m.ReadCount
}

func (m *_SessionDiagnosticsDataType) GetHistoryReadCount() ExtensionObjectDefinition {
	return m.HistoryReadCount
}

func (m *_SessionDiagnosticsDataType) GetWriteCount() ExtensionObjectDefinition {
	return m.WriteCount
}

func (m *_SessionDiagnosticsDataType) GetHistoryUpdateCount() ExtensionObjectDefinition {
	return m.HistoryUpdateCount
}

func (m *_SessionDiagnosticsDataType) GetCallCount() ExtensionObjectDefinition {
	return m.CallCount
}

func (m *_SessionDiagnosticsDataType) GetCreateMonitoredItemsCount() ExtensionObjectDefinition {
	return m.CreateMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetModifyMonitoredItemsCount() ExtensionObjectDefinition {
	return m.ModifyMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetSetMonitoringModeCount() ExtensionObjectDefinition {
	return m.SetMonitoringModeCount
}

func (m *_SessionDiagnosticsDataType) GetSetTriggeringCount() ExtensionObjectDefinition {
	return m.SetTriggeringCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteMonitoredItemsCount() ExtensionObjectDefinition {
	return m.DeleteMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetCreateSubscriptionCount() ExtensionObjectDefinition {
	return m.CreateSubscriptionCount
}

func (m *_SessionDiagnosticsDataType) GetModifySubscriptionCount() ExtensionObjectDefinition {
	return m.ModifySubscriptionCount
}

func (m *_SessionDiagnosticsDataType) GetSetPublishingModeCount() ExtensionObjectDefinition {
	return m.SetPublishingModeCount
}

func (m *_SessionDiagnosticsDataType) GetPublishCount() ExtensionObjectDefinition {
	return m.PublishCount
}

func (m *_SessionDiagnosticsDataType) GetRepublishCount() ExtensionObjectDefinition {
	return m.RepublishCount
}

func (m *_SessionDiagnosticsDataType) GetTransferSubscriptionsCount() ExtensionObjectDefinition {
	return m.TransferSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteSubscriptionsCount() ExtensionObjectDefinition {
	return m.DeleteSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetAddNodesCount() ExtensionObjectDefinition {
	return m.AddNodesCount
}

func (m *_SessionDiagnosticsDataType) GetAddReferencesCount() ExtensionObjectDefinition {
	return m.AddReferencesCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteNodesCount() ExtensionObjectDefinition {
	return m.DeleteNodesCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteReferencesCount() ExtensionObjectDefinition {
	return m.DeleteReferencesCount
}

func (m *_SessionDiagnosticsDataType) GetBrowseCount() ExtensionObjectDefinition {
	return m.BrowseCount
}

func (m *_SessionDiagnosticsDataType) GetBrowseNextCount() ExtensionObjectDefinition {
	return m.BrowseNextCount
}

func (m *_SessionDiagnosticsDataType) GetTranslateBrowsePathsToNodeIdsCount() ExtensionObjectDefinition {
	return m.TranslateBrowsePathsToNodeIdsCount
}

func (m *_SessionDiagnosticsDataType) GetQueryFirstCount() ExtensionObjectDefinition {
	return m.QueryFirstCount
}

func (m *_SessionDiagnosticsDataType) GetQueryNextCount() ExtensionObjectDefinition {
	return m.QueryNextCount
}

func (m *_SessionDiagnosticsDataType) GetRegisterNodesCount() ExtensionObjectDefinition {
	return m.RegisterNodesCount
}

func (m *_SessionDiagnosticsDataType) GetUnregisterNodesCount() ExtensionObjectDefinition {
	return m.UnregisterNodesCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSessionDiagnosticsDataType factory function for _SessionDiagnosticsDataType
func NewSessionDiagnosticsDataType(sessionId NodeId, sessionName PascalString, clientDescription ExtensionObjectDefinition, serverUri PascalString, endpointUrl PascalString, noOfLocaleIds int32, localeIds []PascalString, actualSessionTimeout float64, maxResponseMessageSize uint32, clientConnectionTime int64, clientLastContactTime int64, currentSubscriptionsCount uint32, currentMonitoredItemsCount uint32, currentPublishRequestsInQueue uint32, totalRequestCount ExtensionObjectDefinition, unauthorizedRequestCount uint32, readCount ExtensionObjectDefinition, historyReadCount ExtensionObjectDefinition, writeCount ExtensionObjectDefinition, historyUpdateCount ExtensionObjectDefinition, callCount ExtensionObjectDefinition, createMonitoredItemsCount ExtensionObjectDefinition, modifyMonitoredItemsCount ExtensionObjectDefinition, setMonitoringModeCount ExtensionObjectDefinition, setTriggeringCount ExtensionObjectDefinition, deleteMonitoredItemsCount ExtensionObjectDefinition, createSubscriptionCount ExtensionObjectDefinition, modifySubscriptionCount ExtensionObjectDefinition, setPublishingModeCount ExtensionObjectDefinition, publishCount ExtensionObjectDefinition, republishCount ExtensionObjectDefinition, transferSubscriptionsCount ExtensionObjectDefinition, deleteSubscriptionsCount ExtensionObjectDefinition, addNodesCount ExtensionObjectDefinition, addReferencesCount ExtensionObjectDefinition, deleteNodesCount ExtensionObjectDefinition, deleteReferencesCount ExtensionObjectDefinition, browseCount ExtensionObjectDefinition, browseNextCount ExtensionObjectDefinition, translateBrowsePathsToNodeIdsCount ExtensionObjectDefinition, queryFirstCount ExtensionObjectDefinition, queryNextCount ExtensionObjectDefinition, registerNodesCount ExtensionObjectDefinition, unregisterNodesCount ExtensionObjectDefinition) *_SessionDiagnosticsDataType {
	_result := &_SessionDiagnosticsDataType{
		SessionId:                          sessionId,
		SessionName:                        sessionName,
		ClientDescription:                  clientDescription,
		ServerUri:                          serverUri,
		EndpointUrl:                        endpointUrl,
		NoOfLocaleIds:                      noOfLocaleIds,
		LocaleIds:                          localeIds,
		ActualSessionTimeout:               actualSessionTimeout,
		MaxResponseMessageSize:             maxResponseMessageSize,
		ClientConnectionTime:               clientConnectionTime,
		ClientLastContactTime:              clientLastContactTime,
		CurrentSubscriptionsCount:          currentSubscriptionsCount,
		CurrentMonitoredItemsCount:         currentMonitoredItemsCount,
		CurrentPublishRequestsInQueue:      currentPublishRequestsInQueue,
		TotalRequestCount:                  totalRequestCount,
		UnauthorizedRequestCount:           unauthorizedRequestCount,
		ReadCount:                          readCount,
		HistoryReadCount:                   historyReadCount,
		WriteCount:                         writeCount,
		HistoryUpdateCount:                 historyUpdateCount,
		CallCount:                          callCount,
		CreateMonitoredItemsCount:          createMonitoredItemsCount,
		ModifyMonitoredItemsCount:          modifyMonitoredItemsCount,
		SetMonitoringModeCount:             setMonitoringModeCount,
		SetTriggeringCount:                 setTriggeringCount,
		DeleteMonitoredItemsCount:          deleteMonitoredItemsCount,
		CreateSubscriptionCount:            createSubscriptionCount,
		ModifySubscriptionCount:            modifySubscriptionCount,
		SetPublishingModeCount:             setPublishingModeCount,
		PublishCount:                       publishCount,
		RepublishCount:                     republishCount,
		TransferSubscriptionsCount:         transferSubscriptionsCount,
		DeleteSubscriptionsCount:           deleteSubscriptionsCount,
		AddNodesCount:                      addNodesCount,
		AddReferencesCount:                 addReferencesCount,
		DeleteNodesCount:                   deleteNodesCount,
		DeleteReferencesCount:              deleteReferencesCount,
		BrowseCount:                        browseCount,
		BrowseNextCount:                    browseNextCount,
		TranslateBrowsePathsToNodeIdsCount: translateBrowsePathsToNodeIdsCount,
		QueryFirstCount:                    queryFirstCount,
		QueryNextCount:                     queryNextCount,
		RegisterNodesCount:                 registerNodesCount,
		UnregisterNodesCount:               unregisterNodesCount,
		_ExtensionObjectDefinition:         NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSessionDiagnosticsDataType(structType any) SessionDiagnosticsDataType {
	if casted, ok := structType.(SessionDiagnosticsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*SessionDiagnosticsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_SessionDiagnosticsDataType) GetTypeName() string {
	return "SessionDiagnosticsDataType"
}

func (m *_SessionDiagnosticsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (sessionId)
	lengthInBits += m.SessionId.GetLengthInBits(ctx)

	// Simple field (sessionName)
	lengthInBits += m.SessionName.GetLengthInBits(ctx)

	// Simple field (clientDescription)
	lengthInBits += m.ClientDescription.GetLengthInBits(ctx)

	// Simple field (serverUri)
	lengthInBits += m.ServerUri.GetLengthInBits(ctx)

	// Simple field (endpointUrl)
	lengthInBits += m.EndpointUrl.GetLengthInBits(ctx)

	// Simple field (noOfLocaleIds)
	lengthInBits += 32

	// Array field
	if len(m.LocaleIds) > 0 {
		for _curItem, element := range m.LocaleIds {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LocaleIds), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (actualSessionTimeout)
	lengthInBits += 64

	// Simple field (maxResponseMessageSize)
	lengthInBits += 32

	// Simple field (clientConnectionTime)
	lengthInBits += 64

	// Simple field (clientLastContactTime)
	lengthInBits += 64

	// Simple field (currentSubscriptionsCount)
	lengthInBits += 32

	// Simple field (currentMonitoredItemsCount)
	lengthInBits += 32

	// Simple field (currentPublishRequestsInQueue)
	lengthInBits += 32

	// Simple field (totalRequestCount)
	lengthInBits += m.TotalRequestCount.GetLengthInBits(ctx)

	// Simple field (unauthorizedRequestCount)
	lengthInBits += 32

	// Simple field (readCount)
	lengthInBits += m.ReadCount.GetLengthInBits(ctx)

	// Simple field (historyReadCount)
	lengthInBits += m.HistoryReadCount.GetLengthInBits(ctx)

	// Simple field (writeCount)
	lengthInBits += m.WriteCount.GetLengthInBits(ctx)

	// Simple field (historyUpdateCount)
	lengthInBits += m.HistoryUpdateCount.GetLengthInBits(ctx)

	// Simple field (callCount)
	lengthInBits += m.CallCount.GetLengthInBits(ctx)

	// Simple field (createMonitoredItemsCount)
	lengthInBits += m.CreateMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (modifyMonitoredItemsCount)
	lengthInBits += m.ModifyMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (setMonitoringModeCount)
	lengthInBits += m.SetMonitoringModeCount.GetLengthInBits(ctx)

	// Simple field (setTriggeringCount)
	lengthInBits += m.SetTriggeringCount.GetLengthInBits(ctx)

	// Simple field (deleteMonitoredItemsCount)
	lengthInBits += m.DeleteMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (createSubscriptionCount)
	lengthInBits += m.CreateSubscriptionCount.GetLengthInBits(ctx)

	// Simple field (modifySubscriptionCount)
	lengthInBits += m.ModifySubscriptionCount.GetLengthInBits(ctx)

	// Simple field (setPublishingModeCount)
	lengthInBits += m.SetPublishingModeCount.GetLengthInBits(ctx)

	// Simple field (publishCount)
	lengthInBits += m.PublishCount.GetLengthInBits(ctx)

	// Simple field (republishCount)
	lengthInBits += m.RepublishCount.GetLengthInBits(ctx)

	// Simple field (transferSubscriptionsCount)
	lengthInBits += m.TransferSubscriptionsCount.GetLengthInBits(ctx)

	// Simple field (deleteSubscriptionsCount)
	lengthInBits += m.DeleteSubscriptionsCount.GetLengthInBits(ctx)

	// Simple field (addNodesCount)
	lengthInBits += m.AddNodesCount.GetLengthInBits(ctx)

	// Simple field (addReferencesCount)
	lengthInBits += m.AddReferencesCount.GetLengthInBits(ctx)

	// Simple field (deleteNodesCount)
	lengthInBits += m.DeleteNodesCount.GetLengthInBits(ctx)

	// Simple field (deleteReferencesCount)
	lengthInBits += m.DeleteReferencesCount.GetLengthInBits(ctx)

	// Simple field (browseCount)
	lengthInBits += m.BrowseCount.GetLengthInBits(ctx)

	// Simple field (browseNextCount)
	lengthInBits += m.BrowseNextCount.GetLengthInBits(ctx)

	// Simple field (translateBrowsePathsToNodeIdsCount)
	lengthInBits += m.TranslateBrowsePathsToNodeIdsCount.GetLengthInBits(ctx)

	// Simple field (queryFirstCount)
	lengthInBits += m.QueryFirstCount.GetLengthInBits(ctx)

	// Simple field (queryNextCount)
	lengthInBits += m.QueryNextCount.GetLengthInBits(ctx)

	// Simple field (registerNodesCount)
	lengthInBits += m.RegisterNodesCount.GetLengthInBits(ctx)

	// Simple field (unregisterNodesCount)
	lengthInBits += m.UnregisterNodesCount.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SessionDiagnosticsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SessionDiagnosticsDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (SessionDiagnosticsDataType, error) {
	return SessionDiagnosticsDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SessionDiagnosticsDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SessionDiagnosticsDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SessionDiagnosticsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SessionDiagnosticsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (sessionId)
	if pullErr := readBuffer.PullContext("sessionId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for sessionId")
	}
	_sessionId, _sessionIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _sessionIdErr != nil {
		return nil, errors.Wrap(_sessionIdErr, "Error parsing 'sessionId' field of SessionDiagnosticsDataType")
	}
	sessionId := _sessionId.(NodeId)
	if closeErr := readBuffer.CloseContext("sessionId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for sessionId")
	}

	// Simple Field (sessionName)
	if pullErr := readBuffer.PullContext("sessionName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for sessionName")
	}
	_sessionName, _sessionNameErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _sessionNameErr != nil {
		return nil, errors.Wrap(_sessionNameErr, "Error parsing 'sessionName' field of SessionDiagnosticsDataType")
	}
	sessionName := _sessionName.(PascalString)
	if closeErr := readBuffer.CloseContext("sessionName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for sessionName")
	}

	// Simple Field (clientDescription)
	if pullErr := readBuffer.PullContext("clientDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for clientDescription")
	}
	_clientDescription, _clientDescriptionErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("310"))
	if _clientDescriptionErr != nil {
		return nil, errors.Wrap(_clientDescriptionErr, "Error parsing 'clientDescription' field of SessionDiagnosticsDataType")
	}
	clientDescription := _clientDescription.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("clientDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for clientDescription")
	}

	// Simple Field (serverUri)
	if pullErr := readBuffer.PullContext("serverUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverUri")
	}
	_serverUri, _serverUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _serverUriErr != nil {
		return nil, errors.Wrap(_serverUriErr, "Error parsing 'serverUri' field of SessionDiagnosticsDataType")
	}
	serverUri := _serverUri.(PascalString)
	if closeErr := readBuffer.CloseContext("serverUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverUri")
	}

	// Simple Field (endpointUrl)
	if pullErr := readBuffer.PullContext("endpointUrl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for endpointUrl")
	}
	_endpointUrl, _endpointUrlErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _endpointUrlErr != nil {
		return nil, errors.Wrap(_endpointUrlErr, "Error parsing 'endpointUrl' field of SessionDiagnosticsDataType")
	}
	endpointUrl := _endpointUrl.(PascalString)
	if closeErr := readBuffer.CloseContext("endpointUrl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for endpointUrl")
	}

	// Simple Field (noOfLocaleIds)
	_noOfLocaleIds, _noOfLocaleIdsErr := readBuffer.ReadInt32("noOfLocaleIds", 32)
	if _noOfLocaleIdsErr != nil {
		return nil, errors.Wrap(_noOfLocaleIdsErr, "Error parsing 'noOfLocaleIds' field of SessionDiagnosticsDataType")
	}
	noOfLocaleIds := _noOfLocaleIds

	// Array field (localeIds)
	if pullErr := readBuffer.PullContext("localeIds", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for localeIds")
	}
	// Count array
	localeIds := make([]PascalString, utils.Max(noOfLocaleIds, 0))
	// This happens when the size is set conditional to 0
	if len(localeIds) == 0 {
		localeIds = nil
	}
	{
		_numItems := uint16(utils.Max(noOfLocaleIds, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := PascalStringParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'localeIds' field of SessionDiagnosticsDataType")
			}
			localeIds[_curItem] = _item.(PascalString)
		}
	}
	if closeErr := readBuffer.CloseContext("localeIds", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for localeIds")
	}

	// Simple Field (actualSessionTimeout)
	_actualSessionTimeout, _actualSessionTimeoutErr := readBuffer.ReadFloat64("actualSessionTimeout", 64)
	if _actualSessionTimeoutErr != nil {
		return nil, errors.Wrap(_actualSessionTimeoutErr, "Error parsing 'actualSessionTimeout' field of SessionDiagnosticsDataType")
	}
	actualSessionTimeout := _actualSessionTimeout

	// Simple Field (maxResponseMessageSize)
	_maxResponseMessageSize, _maxResponseMessageSizeErr := readBuffer.ReadUint32("maxResponseMessageSize", 32)
	if _maxResponseMessageSizeErr != nil {
		return nil, errors.Wrap(_maxResponseMessageSizeErr, "Error parsing 'maxResponseMessageSize' field of SessionDiagnosticsDataType")
	}
	maxResponseMessageSize := _maxResponseMessageSize

	// Simple Field (clientConnectionTime)
	_clientConnectionTime, _clientConnectionTimeErr := readBuffer.ReadInt64("clientConnectionTime", 64)
	if _clientConnectionTimeErr != nil {
		return nil, errors.Wrap(_clientConnectionTimeErr, "Error parsing 'clientConnectionTime' field of SessionDiagnosticsDataType")
	}
	clientConnectionTime := _clientConnectionTime

	// Simple Field (clientLastContactTime)
	_clientLastContactTime, _clientLastContactTimeErr := readBuffer.ReadInt64("clientLastContactTime", 64)
	if _clientLastContactTimeErr != nil {
		return nil, errors.Wrap(_clientLastContactTimeErr, "Error parsing 'clientLastContactTime' field of SessionDiagnosticsDataType")
	}
	clientLastContactTime := _clientLastContactTime

	// Simple Field (currentSubscriptionsCount)
	_currentSubscriptionsCount, _currentSubscriptionsCountErr := readBuffer.ReadUint32("currentSubscriptionsCount", 32)
	if _currentSubscriptionsCountErr != nil {
		return nil, errors.Wrap(_currentSubscriptionsCountErr, "Error parsing 'currentSubscriptionsCount' field of SessionDiagnosticsDataType")
	}
	currentSubscriptionsCount := _currentSubscriptionsCount

	// Simple Field (currentMonitoredItemsCount)
	_currentMonitoredItemsCount, _currentMonitoredItemsCountErr := readBuffer.ReadUint32("currentMonitoredItemsCount", 32)
	if _currentMonitoredItemsCountErr != nil {
		return nil, errors.Wrap(_currentMonitoredItemsCountErr, "Error parsing 'currentMonitoredItemsCount' field of SessionDiagnosticsDataType")
	}
	currentMonitoredItemsCount := _currentMonitoredItemsCount

	// Simple Field (currentPublishRequestsInQueue)
	_currentPublishRequestsInQueue, _currentPublishRequestsInQueueErr := readBuffer.ReadUint32("currentPublishRequestsInQueue", 32)
	if _currentPublishRequestsInQueueErr != nil {
		return nil, errors.Wrap(_currentPublishRequestsInQueueErr, "Error parsing 'currentPublishRequestsInQueue' field of SessionDiagnosticsDataType")
	}
	currentPublishRequestsInQueue := _currentPublishRequestsInQueue

	// Simple Field (totalRequestCount)
	if pullErr := readBuffer.PullContext("totalRequestCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for totalRequestCount")
	}
	_totalRequestCount, _totalRequestCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _totalRequestCountErr != nil {
		return nil, errors.Wrap(_totalRequestCountErr, "Error parsing 'totalRequestCount' field of SessionDiagnosticsDataType")
	}
	totalRequestCount := _totalRequestCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("totalRequestCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for totalRequestCount")
	}

	// Simple Field (unauthorizedRequestCount)
	_unauthorizedRequestCount, _unauthorizedRequestCountErr := readBuffer.ReadUint32("unauthorizedRequestCount", 32)
	if _unauthorizedRequestCountErr != nil {
		return nil, errors.Wrap(_unauthorizedRequestCountErr, "Error parsing 'unauthorizedRequestCount' field of SessionDiagnosticsDataType")
	}
	unauthorizedRequestCount := _unauthorizedRequestCount

	// Simple Field (readCount)
	if pullErr := readBuffer.PullContext("readCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for readCount")
	}
	_readCount, _readCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _readCountErr != nil {
		return nil, errors.Wrap(_readCountErr, "Error parsing 'readCount' field of SessionDiagnosticsDataType")
	}
	readCount := _readCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("readCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for readCount")
	}

	// Simple Field (historyReadCount)
	if pullErr := readBuffer.PullContext("historyReadCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for historyReadCount")
	}
	_historyReadCount, _historyReadCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _historyReadCountErr != nil {
		return nil, errors.Wrap(_historyReadCountErr, "Error parsing 'historyReadCount' field of SessionDiagnosticsDataType")
	}
	historyReadCount := _historyReadCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("historyReadCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for historyReadCount")
	}

	// Simple Field (writeCount)
	if pullErr := readBuffer.PullContext("writeCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for writeCount")
	}
	_writeCount, _writeCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _writeCountErr != nil {
		return nil, errors.Wrap(_writeCountErr, "Error parsing 'writeCount' field of SessionDiagnosticsDataType")
	}
	writeCount := _writeCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("writeCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for writeCount")
	}

	// Simple Field (historyUpdateCount)
	if pullErr := readBuffer.PullContext("historyUpdateCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for historyUpdateCount")
	}
	_historyUpdateCount, _historyUpdateCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _historyUpdateCountErr != nil {
		return nil, errors.Wrap(_historyUpdateCountErr, "Error parsing 'historyUpdateCount' field of SessionDiagnosticsDataType")
	}
	historyUpdateCount := _historyUpdateCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("historyUpdateCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for historyUpdateCount")
	}

	// Simple Field (callCount)
	if pullErr := readBuffer.PullContext("callCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for callCount")
	}
	_callCount, _callCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _callCountErr != nil {
		return nil, errors.Wrap(_callCountErr, "Error parsing 'callCount' field of SessionDiagnosticsDataType")
	}
	callCount := _callCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("callCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for callCount")
	}

	// Simple Field (createMonitoredItemsCount)
	if pullErr := readBuffer.PullContext("createMonitoredItemsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for createMonitoredItemsCount")
	}
	_createMonitoredItemsCount, _createMonitoredItemsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _createMonitoredItemsCountErr != nil {
		return nil, errors.Wrap(_createMonitoredItemsCountErr, "Error parsing 'createMonitoredItemsCount' field of SessionDiagnosticsDataType")
	}
	createMonitoredItemsCount := _createMonitoredItemsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("createMonitoredItemsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for createMonitoredItemsCount")
	}

	// Simple Field (modifyMonitoredItemsCount)
	if pullErr := readBuffer.PullContext("modifyMonitoredItemsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for modifyMonitoredItemsCount")
	}
	_modifyMonitoredItemsCount, _modifyMonitoredItemsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _modifyMonitoredItemsCountErr != nil {
		return nil, errors.Wrap(_modifyMonitoredItemsCountErr, "Error parsing 'modifyMonitoredItemsCount' field of SessionDiagnosticsDataType")
	}
	modifyMonitoredItemsCount := _modifyMonitoredItemsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("modifyMonitoredItemsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for modifyMonitoredItemsCount")
	}

	// Simple Field (setMonitoringModeCount)
	if pullErr := readBuffer.PullContext("setMonitoringModeCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for setMonitoringModeCount")
	}
	_setMonitoringModeCount, _setMonitoringModeCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _setMonitoringModeCountErr != nil {
		return nil, errors.Wrap(_setMonitoringModeCountErr, "Error parsing 'setMonitoringModeCount' field of SessionDiagnosticsDataType")
	}
	setMonitoringModeCount := _setMonitoringModeCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("setMonitoringModeCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for setMonitoringModeCount")
	}

	// Simple Field (setTriggeringCount)
	if pullErr := readBuffer.PullContext("setTriggeringCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for setTriggeringCount")
	}
	_setTriggeringCount, _setTriggeringCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _setTriggeringCountErr != nil {
		return nil, errors.Wrap(_setTriggeringCountErr, "Error parsing 'setTriggeringCount' field of SessionDiagnosticsDataType")
	}
	setTriggeringCount := _setTriggeringCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("setTriggeringCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for setTriggeringCount")
	}

	// Simple Field (deleteMonitoredItemsCount)
	if pullErr := readBuffer.PullContext("deleteMonitoredItemsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for deleteMonitoredItemsCount")
	}
	_deleteMonitoredItemsCount, _deleteMonitoredItemsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _deleteMonitoredItemsCountErr != nil {
		return nil, errors.Wrap(_deleteMonitoredItemsCountErr, "Error parsing 'deleteMonitoredItemsCount' field of SessionDiagnosticsDataType")
	}
	deleteMonitoredItemsCount := _deleteMonitoredItemsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("deleteMonitoredItemsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for deleteMonitoredItemsCount")
	}

	// Simple Field (createSubscriptionCount)
	if pullErr := readBuffer.PullContext("createSubscriptionCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for createSubscriptionCount")
	}
	_createSubscriptionCount, _createSubscriptionCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _createSubscriptionCountErr != nil {
		return nil, errors.Wrap(_createSubscriptionCountErr, "Error parsing 'createSubscriptionCount' field of SessionDiagnosticsDataType")
	}
	createSubscriptionCount := _createSubscriptionCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("createSubscriptionCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for createSubscriptionCount")
	}

	// Simple Field (modifySubscriptionCount)
	if pullErr := readBuffer.PullContext("modifySubscriptionCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for modifySubscriptionCount")
	}
	_modifySubscriptionCount, _modifySubscriptionCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _modifySubscriptionCountErr != nil {
		return nil, errors.Wrap(_modifySubscriptionCountErr, "Error parsing 'modifySubscriptionCount' field of SessionDiagnosticsDataType")
	}
	modifySubscriptionCount := _modifySubscriptionCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("modifySubscriptionCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for modifySubscriptionCount")
	}

	// Simple Field (setPublishingModeCount)
	if pullErr := readBuffer.PullContext("setPublishingModeCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for setPublishingModeCount")
	}
	_setPublishingModeCount, _setPublishingModeCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _setPublishingModeCountErr != nil {
		return nil, errors.Wrap(_setPublishingModeCountErr, "Error parsing 'setPublishingModeCount' field of SessionDiagnosticsDataType")
	}
	setPublishingModeCount := _setPublishingModeCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("setPublishingModeCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for setPublishingModeCount")
	}

	// Simple Field (publishCount)
	if pullErr := readBuffer.PullContext("publishCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for publishCount")
	}
	_publishCount, _publishCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _publishCountErr != nil {
		return nil, errors.Wrap(_publishCountErr, "Error parsing 'publishCount' field of SessionDiagnosticsDataType")
	}
	publishCount := _publishCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("publishCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for publishCount")
	}

	// Simple Field (republishCount)
	if pullErr := readBuffer.PullContext("republishCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for republishCount")
	}
	_republishCount, _republishCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _republishCountErr != nil {
		return nil, errors.Wrap(_republishCountErr, "Error parsing 'republishCount' field of SessionDiagnosticsDataType")
	}
	republishCount := _republishCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("republishCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for republishCount")
	}

	// Simple Field (transferSubscriptionsCount)
	if pullErr := readBuffer.PullContext("transferSubscriptionsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for transferSubscriptionsCount")
	}
	_transferSubscriptionsCount, _transferSubscriptionsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _transferSubscriptionsCountErr != nil {
		return nil, errors.Wrap(_transferSubscriptionsCountErr, "Error parsing 'transferSubscriptionsCount' field of SessionDiagnosticsDataType")
	}
	transferSubscriptionsCount := _transferSubscriptionsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("transferSubscriptionsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for transferSubscriptionsCount")
	}

	// Simple Field (deleteSubscriptionsCount)
	if pullErr := readBuffer.PullContext("deleteSubscriptionsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for deleteSubscriptionsCount")
	}
	_deleteSubscriptionsCount, _deleteSubscriptionsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _deleteSubscriptionsCountErr != nil {
		return nil, errors.Wrap(_deleteSubscriptionsCountErr, "Error parsing 'deleteSubscriptionsCount' field of SessionDiagnosticsDataType")
	}
	deleteSubscriptionsCount := _deleteSubscriptionsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("deleteSubscriptionsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for deleteSubscriptionsCount")
	}

	// Simple Field (addNodesCount)
	if pullErr := readBuffer.PullContext("addNodesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for addNodesCount")
	}
	_addNodesCount, _addNodesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _addNodesCountErr != nil {
		return nil, errors.Wrap(_addNodesCountErr, "Error parsing 'addNodesCount' field of SessionDiagnosticsDataType")
	}
	addNodesCount := _addNodesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("addNodesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for addNodesCount")
	}

	// Simple Field (addReferencesCount)
	if pullErr := readBuffer.PullContext("addReferencesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for addReferencesCount")
	}
	_addReferencesCount, _addReferencesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _addReferencesCountErr != nil {
		return nil, errors.Wrap(_addReferencesCountErr, "Error parsing 'addReferencesCount' field of SessionDiagnosticsDataType")
	}
	addReferencesCount := _addReferencesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("addReferencesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for addReferencesCount")
	}

	// Simple Field (deleteNodesCount)
	if pullErr := readBuffer.PullContext("deleteNodesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for deleteNodesCount")
	}
	_deleteNodesCount, _deleteNodesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _deleteNodesCountErr != nil {
		return nil, errors.Wrap(_deleteNodesCountErr, "Error parsing 'deleteNodesCount' field of SessionDiagnosticsDataType")
	}
	deleteNodesCount := _deleteNodesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("deleteNodesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for deleteNodesCount")
	}

	// Simple Field (deleteReferencesCount)
	if pullErr := readBuffer.PullContext("deleteReferencesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for deleteReferencesCount")
	}
	_deleteReferencesCount, _deleteReferencesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _deleteReferencesCountErr != nil {
		return nil, errors.Wrap(_deleteReferencesCountErr, "Error parsing 'deleteReferencesCount' field of SessionDiagnosticsDataType")
	}
	deleteReferencesCount := _deleteReferencesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("deleteReferencesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for deleteReferencesCount")
	}

	// Simple Field (browseCount)
	if pullErr := readBuffer.PullContext("browseCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for browseCount")
	}
	_browseCount, _browseCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _browseCountErr != nil {
		return nil, errors.Wrap(_browseCountErr, "Error parsing 'browseCount' field of SessionDiagnosticsDataType")
	}
	browseCount := _browseCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("browseCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for browseCount")
	}

	// Simple Field (browseNextCount)
	if pullErr := readBuffer.PullContext("browseNextCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for browseNextCount")
	}
	_browseNextCount, _browseNextCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _browseNextCountErr != nil {
		return nil, errors.Wrap(_browseNextCountErr, "Error parsing 'browseNextCount' field of SessionDiagnosticsDataType")
	}
	browseNextCount := _browseNextCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("browseNextCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for browseNextCount")
	}

	// Simple Field (translateBrowsePathsToNodeIdsCount)
	if pullErr := readBuffer.PullContext("translateBrowsePathsToNodeIdsCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for translateBrowsePathsToNodeIdsCount")
	}
	_translateBrowsePathsToNodeIdsCount, _translateBrowsePathsToNodeIdsCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _translateBrowsePathsToNodeIdsCountErr != nil {
		return nil, errors.Wrap(_translateBrowsePathsToNodeIdsCountErr, "Error parsing 'translateBrowsePathsToNodeIdsCount' field of SessionDiagnosticsDataType")
	}
	translateBrowsePathsToNodeIdsCount := _translateBrowsePathsToNodeIdsCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("translateBrowsePathsToNodeIdsCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for translateBrowsePathsToNodeIdsCount")
	}

	// Simple Field (queryFirstCount)
	if pullErr := readBuffer.PullContext("queryFirstCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for queryFirstCount")
	}
	_queryFirstCount, _queryFirstCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _queryFirstCountErr != nil {
		return nil, errors.Wrap(_queryFirstCountErr, "Error parsing 'queryFirstCount' field of SessionDiagnosticsDataType")
	}
	queryFirstCount := _queryFirstCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("queryFirstCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for queryFirstCount")
	}

	// Simple Field (queryNextCount)
	if pullErr := readBuffer.PullContext("queryNextCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for queryNextCount")
	}
	_queryNextCount, _queryNextCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _queryNextCountErr != nil {
		return nil, errors.Wrap(_queryNextCountErr, "Error parsing 'queryNextCount' field of SessionDiagnosticsDataType")
	}
	queryNextCount := _queryNextCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("queryNextCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for queryNextCount")
	}

	// Simple Field (registerNodesCount)
	if pullErr := readBuffer.PullContext("registerNodesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for registerNodesCount")
	}
	_registerNodesCount, _registerNodesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _registerNodesCountErr != nil {
		return nil, errors.Wrap(_registerNodesCountErr, "Error parsing 'registerNodesCount' field of SessionDiagnosticsDataType")
	}
	registerNodesCount := _registerNodesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("registerNodesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for registerNodesCount")
	}

	// Simple Field (unregisterNodesCount)
	if pullErr := readBuffer.PullContext("unregisterNodesCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for unregisterNodesCount")
	}
	_unregisterNodesCount, _unregisterNodesCountErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("873"))
	if _unregisterNodesCountErr != nil {
		return nil, errors.Wrap(_unregisterNodesCountErr, "Error parsing 'unregisterNodesCount' field of SessionDiagnosticsDataType")
	}
	unregisterNodesCount := _unregisterNodesCount.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("unregisterNodesCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for unregisterNodesCount")
	}

	if closeErr := readBuffer.CloseContext("SessionDiagnosticsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SessionDiagnosticsDataType")
	}

	// Create a partially initialized instance
	_child := &_SessionDiagnosticsDataType{
		_ExtensionObjectDefinition:         &_ExtensionObjectDefinition{},
		SessionId:                          sessionId,
		SessionName:                        sessionName,
		ClientDescription:                  clientDescription,
		ServerUri:                          serverUri,
		EndpointUrl:                        endpointUrl,
		NoOfLocaleIds:                      noOfLocaleIds,
		LocaleIds:                          localeIds,
		ActualSessionTimeout:               actualSessionTimeout,
		MaxResponseMessageSize:             maxResponseMessageSize,
		ClientConnectionTime:               clientConnectionTime,
		ClientLastContactTime:              clientLastContactTime,
		CurrentSubscriptionsCount:          currentSubscriptionsCount,
		CurrentMonitoredItemsCount:         currentMonitoredItemsCount,
		CurrentPublishRequestsInQueue:      currentPublishRequestsInQueue,
		TotalRequestCount:                  totalRequestCount,
		UnauthorizedRequestCount:           unauthorizedRequestCount,
		ReadCount:                          readCount,
		HistoryReadCount:                   historyReadCount,
		WriteCount:                         writeCount,
		HistoryUpdateCount:                 historyUpdateCount,
		CallCount:                          callCount,
		CreateMonitoredItemsCount:          createMonitoredItemsCount,
		ModifyMonitoredItemsCount:          modifyMonitoredItemsCount,
		SetMonitoringModeCount:             setMonitoringModeCount,
		SetTriggeringCount:                 setTriggeringCount,
		DeleteMonitoredItemsCount:          deleteMonitoredItemsCount,
		CreateSubscriptionCount:            createSubscriptionCount,
		ModifySubscriptionCount:            modifySubscriptionCount,
		SetPublishingModeCount:             setPublishingModeCount,
		PublishCount:                       publishCount,
		RepublishCount:                     republishCount,
		TransferSubscriptionsCount:         transferSubscriptionsCount,
		DeleteSubscriptionsCount:           deleteSubscriptionsCount,
		AddNodesCount:                      addNodesCount,
		AddReferencesCount:                 addReferencesCount,
		DeleteNodesCount:                   deleteNodesCount,
		DeleteReferencesCount:              deleteReferencesCount,
		BrowseCount:                        browseCount,
		BrowseNextCount:                    browseNextCount,
		TranslateBrowsePathsToNodeIdsCount: translateBrowsePathsToNodeIdsCount,
		QueryFirstCount:                    queryFirstCount,
		QueryNextCount:                     queryNextCount,
		RegisterNodesCount:                 registerNodesCount,
		UnregisterNodesCount:               unregisterNodesCount,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SessionDiagnosticsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SessionDiagnosticsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SessionDiagnosticsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SessionDiagnosticsDataType")
		}

		// Simple Field (sessionId)
		if pushErr := writeBuffer.PushContext("sessionId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for sessionId")
		}
		_sessionIdErr := writeBuffer.WriteSerializable(ctx, m.GetSessionId())
		if popErr := writeBuffer.PopContext("sessionId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for sessionId")
		}
		if _sessionIdErr != nil {
			return errors.Wrap(_sessionIdErr, "Error serializing 'sessionId' field")
		}

		// Simple Field (sessionName)
		if pushErr := writeBuffer.PushContext("sessionName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for sessionName")
		}
		_sessionNameErr := writeBuffer.WriteSerializable(ctx, m.GetSessionName())
		if popErr := writeBuffer.PopContext("sessionName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for sessionName")
		}
		if _sessionNameErr != nil {
			return errors.Wrap(_sessionNameErr, "Error serializing 'sessionName' field")
		}

		// Simple Field (clientDescription)
		if pushErr := writeBuffer.PushContext("clientDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for clientDescription")
		}
		_clientDescriptionErr := writeBuffer.WriteSerializable(ctx, m.GetClientDescription())
		if popErr := writeBuffer.PopContext("clientDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for clientDescription")
		}
		if _clientDescriptionErr != nil {
			return errors.Wrap(_clientDescriptionErr, "Error serializing 'clientDescription' field")
		}

		// Simple Field (serverUri)
		if pushErr := writeBuffer.PushContext("serverUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverUri")
		}
		_serverUriErr := writeBuffer.WriteSerializable(ctx, m.GetServerUri())
		if popErr := writeBuffer.PopContext("serverUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverUri")
		}
		if _serverUriErr != nil {
			return errors.Wrap(_serverUriErr, "Error serializing 'serverUri' field")
		}

		// Simple Field (endpointUrl)
		if pushErr := writeBuffer.PushContext("endpointUrl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for endpointUrl")
		}
		_endpointUrlErr := writeBuffer.WriteSerializable(ctx, m.GetEndpointUrl())
		if popErr := writeBuffer.PopContext("endpointUrl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for endpointUrl")
		}
		if _endpointUrlErr != nil {
			return errors.Wrap(_endpointUrlErr, "Error serializing 'endpointUrl' field")
		}

		// Simple Field (noOfLocaleIds)
		noOfLocaleIds := int32(m.GetNoOfLocaleIds())
		_noOfLocaleIdsErr := writeBuffer.WriteInt32("noOfLocaleIds", 32, int32((noOfLocaleIds)))
		if _noOfLocaleIdsErr != nil {
			return errors.Wrap(_noOfLocaleIdsErr, "Error serializing 'noOfLocaleIds' field")
		}

		// Array Field (localeIds)
		if pushErr := writeBuffer.PushContext("localeIds", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for localeIds")
		}
		for _curItem, _element := range m.GetLocaleIds() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetLocaleIds()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'localeIds' field")
			}
		}
		if popErr := writeBuffer.PopContext("localeIds", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for localeIds")
		}

		// Simple Field (actualSessionTimeout)
		actualSessionTimeout := float64(m.GetActualSessionTimeout())
		_actualSessionTimeoutErr := writeBuffer.WriteFloat64("actualSessionTimeout", 64, (actualSessionTimeout))
		if _actualSessionTimeoutErr != nil {
			return errors.Wrap(_actualSessionTimeoutErr, "Error serializing 'actualSessionTimeout' field")
		}

		// Simple Field (maxResponseMessageSize)
		maxResponseMessageSize := uint32(m.GetMaxResponseMessageSize())
		_maxResponseMessageSizeErr := writeBuffer.WriteUint32("maxResponseMessageSize", 32, uint32((maxResponseMessageSize)))
		if _maxResponseMessageSizeErr != nil {
			return errors.Wrap(_maxResponseMessageSizeErr, "Error serializing 'maxResponseMessageSize' field")
		}

		// Simple Field (clientConnectionTime)
		clientConnectionTime := int64(m.GetClientConnectionTime())
		_clientConnectionTimeErr := writeBuffer.WriteInt64("clientConnectionTime", 64, int64((clientConnectionTime)))
		if _clientConnectionTimeErr != nil {
			return errors.Wrap(_clientConnectionTimeErr, "Error serializing 'clientConnectionTime' field")
		}

		// Simple Field (clientLastContactTime)
		clientLastContactTime := int64(m.GetClientLastContactTime())
		_clientLastContactTimeErr := writeBuffer.WriteInt64("clientLastContactTime", 64, int64((clientLastContactTime)))
		if _clientLastContactTimeErr != nil {
			return errors.Wrap(_clientLastContactTimeErr, "Error serializing 'clientLastContactTime' field")
		}

		// Simple Field (currentSubscriptionsCount)
		currentSubscriptionsCount := uint32(m.GetCurrentSubscriptionsCount())
		_currentSubscriptionsCountErr := writeBuffer.WriteUint32("currentSubscriptionsCount", 32, uint32((currentSubscriptionsCount)))
		if _currentSubscriptionsCountErr != nil {
			return errors.Wrap(_currentSubscriptionsCountErr, "Error serializing 'currentSubscriptionsCount' field")
		}

		// Simple Field (currentMonitoredItemsCount)
		currentMonitoredItemsCount := uint32(m.GetCurrentMonitoredItemsCount())
		_currentMonitoredItemsCountErr := writeBuffer.WriteUint32("currentMonitoredItemsCount", 32, uint32((currentMonitoredItemsCount)))
		if _currentMonitoredItemsCountErr != nil {
			return errors.Wrap(_currentMonitoredItemsCountErr, "Error serializing 'currentMonitoredItemsCount' field")
		}

		// Simple Field (currentPublishRequestsInQueue)
		currentPublishRequestsInQueue := uint32(m.GetCurrentPublishRequestsInQueue())
		_currentPublishRequestsInQueueErr := writeBuffer.WriteUint32("currentPublishRequestsInQueue", 32, uint32((currentPublishRequestsInQueue)))
		if _currentPublishRequestsInQueueErr != nil {
			return errors.Wrap(_currentPublishRequestsInQueueErr, "Error serializing 'currentPublishRequestsInQueue' field")
		}

		// Simple Field (totalRequestCount)
		if pushErr := writeBuffer.PushContext("totalRequestCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for totalRequestCount")
		}
		_totalRequestCountErr := writeBuffer.WriteSerializable(ctx, m.GetTotalRequestCount())
		if popErr := writeBuffer.PopContext("totalRequestCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for totalRequestCount")
		}
		if _totalRequestCountErr != nil {
			return errors.Wrap(_totalRequestCountErr, "Error serializing 'totalRequestCount' field")
		}

		// Simple Field (unauthorizedRequestCount)
		unauthorizedRequestCount := uint32(m.GetUnauthorizedRequestCount())
		_unauthorizedRequestCountErr := writeBuffer.WriteUint32("unauthorizedRequestCount", 32, uint32((unauthorizedRequestCount)))
		if _unauthorizedRequestCountErr != nil {
			return errors.Wrap(_unauthorizedRequestCountErr, "Error serializing 'unauthorizedRequestCount' field")
		}

		// Simple Field (readCount)
		if pushErr := writeBuffer.PushContext("readCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for readCount")
		}
		_readCountErr := writeBuffer.WriteSerializable(ctx, m.GetReadCount())
		if popErr := writeBuffer.PopContext("readCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for readCount")
		}
		if _readCountErr != nil {
			return errors.Wrap(_readCountErr, "Error serializing 'readCount' field")
		}

		// Simple Field (historyReadCount)
		if pushErr := writeBuffer.PushContext("historyReadCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for historyReadCount")
		}
		_historyReadCountErr := writeBuffer.WriteSerializable(ctx, m.GetHistoryReadCount())
		if popErr := writeBuffer.PopContext("historyReadCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for historyReadCount")
		}
		if _historyReadCountErr != nil {
			return errors.Wrap(_historyReadCountErr, "Error serializing 'historyReadCount' field")
		}

		// Simple Field (writeCount)
		if pushErr := writeBuffer.PushContext("writeCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for writeCount")
		}
		_writeCountErr := writeBuffer.WriteSerializable(ctx, m.GetWriteCount())
		if popErr := writeBuffer.PopContext("writeCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for writeCount")
		}
		if _writeCountErr != nil {
			return errors.Wrap(_writeCountErr, "Error serializing 'writeCount' field")
		}

		// Simple Field (historyUpdateCount)
		if pushErr := writeBuffer.PushContext("historyUpdateCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for historyUpdateCount")
		}
		_historyUpdateCountErr := writeBuffer.WriteSerializable(ctx, m.GetHistoryUpdateCount())
		if popErr := writeBuffer.PopContext("historyUpdateCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for historyUpdateCount")
		}
		if _historyUpdateCountErr != nil {
			return errors.Wrap(_historyUpdateCountErr, "Error serializing 'historyUpdateCount' field")
		}

		// Simple Field (callCount)
		if pushErr := writeBuffer.PushContext("callCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for callCount")
		}
		_callCountErr := writeBuffer.WriteSerializable(ctx, m.GetCallCount())
		if popErr := writeBuffer.PopContext("callCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for callCount")
		}
		if _callCountErr != nil {
			return errors.Wrap(_callCountErr, "Error serializing 'callCount' field")
		}

		// Simple Field (createMonitoredItemsCount)
		if pushErr := writeBuffer.PushContext("createMonitoredItemsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for createMonitoredItemsCount")
		}
		_createMonitoredItemsCountErr := writeBuffer.WriteSerializable(ctx, m.GetCreateMonitoredItemsCount())
		if popErr := writeBuffer.PopContext("createMonitoredItemsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for createMonitoredItemsCount")
		}
		if _createMonitoredItemsCountErr != nil {
			return errors.Wrap(_createMonitoredItemsCountErr, "Error serializing 'createMonitoredItemsCount' field")
		}

		// Simple Field (modifyMonitoredItemsCount)
		if pushErr := writeBuffer.PushContext("modifyMonitoredItemsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for modifyMonitoredItemsCount")
		}
		_modifyMonitoredItemsCountErr := writeBuffer.WriteSerializable(ctx, m.GetModifyMonitoredItemsCount())
		if popErr := writeBuffer.PopContext("modifyMonitoredItemsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for modifyMonitoredItemsCount")
		}
		if _modifyMonitoredItemsCountErr != nil {
			return errors.Wrap(_modifyMonitoredItemsCountErr, "Error serializing 'modifyMonitoredItemsCount' field")
		}

		// Simple Field (setMonitoringModeCount)
		if pushErr := writeBuffer.PushContext("setMonitoringModeCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for setMonitoringModeCount")
		}
		_setMonitoringModeCountErr := writeBuffer.WriteSerializable(ctx, m.GetSetMonitoringModeCount())
		if popErr := writeBuffer.PopContext("setMonitoringModeCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for setMonitoringModeCount")
		}
		if _setMonitoringModeCountErr != nil {
			return errors.Wrap(_setMonitoringModeCountErr, "Error serializing 'setMonitoringModeCount' field")
		}

		// Simple Field (setTriggeringCount)
		if pushErr := writeBuffer.PushContext("setTriggeringCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for setTriggeringCount")
		}
		_setTriggeringCountErr := writeBuffer.WriteSerializable(ctx, m.GetSetTriggeringCount())
		if popErr := writeBuffer.PopContext("setTriggeringCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for setTriggeringCount")
		}
		if _setTriggeringCountErr != nil {
			return errors.Wrap(_setTriggeringCountErr, "Error serializing 'setTriggeringCount' field")
		}

		// Simple Field (deleteMonitoredItemsCount)
		if pushErr := writeBuffer.PushContext("deleteMonitoredItemsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for deleteMonitoredItemsCount")
		}
		_deleteMonitoredItemsCountErr := writeBuffer.WriteSerializable(ctx, m.GetDeleteMonitoredItemsCount())
		if popErr := writeBuffer.PopContext("deleteMonitoredItemsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for deleteMonitoredItemsCount")
		}
		if _deleteMonitoredItemsCountErr != nil {
			return errors.Wrap(_deleteMonitoredItemsCountErr, "Error serializing 'deleteMonitoredItemsCount' field")
		}

		// Simple Field (createSubscriptionCount)
		if pushErr := writeBuffer.PushContext("createSubscriptionCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for createSubscriptionCount")
		}
		_createSubscriptionCountErr := writeBuffer.WriteSerializable(ctx, m.GetCreateSubscriptionCount())
		if popErr := writeBuffer.PopContext("createSubscriptionCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for createSubscriptionCount")
		}
		if _createSubscriptionCountErr != nil {
			return errors.Wrap(_createSubscriptionCountErr, "Error serializing 'createSubscriptionCount' field")
		}

		// Simple Field (modifySubscriptionCount)
		if pushErr := writeBuffer.PushContext("modifySubscriptionCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for modifySubscriptionCount")
		}
		_modifySubscriptionCountErr := writeBuffer.WriteSerializable(ctx, m.GetModifySubscriptionCount())
		if popErr := writeBuffer.PopContext("modifySubscriptionCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for modifySubscriptionCount")
		}
		if _modifySubscriptionCountErr != nil {
			return errors.Wrap(_modifySubscriptionCountErr, "Error serializing 'modifySubscriptionCount' field")
		}

		// Simple Field (setPublishingModeCount)
		if pushErr := writeBuffer.PushContext("setPublishingModeCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for setPublishingModeCount")
		}
		_setPublishingModeCountErr := writeBuffer.WriteSerializable(ctx, m.GetSetPublishingModeCount())
		if popErr := writeBuffer.PopContext("setPublishingModeCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for setPublishingModeCount")
		}
		if _setPublishingModeCountErr != nil {
			return errors.Wrap(_setPublishingModeCountErr, "Error serializing 'setPublishingModeCount' field")
		}

		// Simple Field (publishCount)
		if pushErr := writeBuffer.PushContext("publishCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for publishCount")
		}
		_publishCountErr := writeBuffer.WriteSerializable(ctx, m.GetPublishCount())
		if popErr := writeBuffer.PopContext("publishCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for publishCount")
		}
		if _publishCountErr != nil {
			return errors.Wrap(_publishCountErr, "Error serializing 'publishCount' field")
		}

		// Simple Field (republishCount)
		if pushErr := writeBuffer.PushContext("republishCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for republishCount")
		}
		_republishCountErr := writeBuffer.WriteSerializable(ctx, m.GetRepublishCount())
		if popErr := writeBuffer.PopContext("republishCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for republishCount")
		}
		if _republishCountErr != nil {
			return errors.Wrap(_republishCountErr, "Error serializing 'republishCount' field")
		}

		// Simple Field (transferSubscriptionsCount)
		if pushErr := writeBuffer.PushContext("transferSubscriptionsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for transferSubscriptionsCount")
		}
		_transferSubscriptionsCountErr := writeBuffer.WriteSerializable(ctx, m.GetTransferSubscriptionsCount())
		if popErr := writeBuffer.PopContext("transferSubscriptionsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for transferSubscriptionsCount")
		}
		if _transferSubscriptionsCountErr != nil {
			return errors.Wrap(_transferSubscriptionsCountErr, "Error serializing 'transferSubscriptionsCount' field")
		}

		// Simple Field (deleteSubscriptionsCount)
		if pushErr := writeBuffer.PushContext("deleteSubscriptionsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for deleteSubscriptionsCount")
		}
		_deleteSubscriptionsCountErr := writeBuffer.WriteSerializable(ctx, m.GetDeleteSubscriptionsCount())
		if popErr := writeBuffer.PopContext("deleteSubscriptionsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for deleteSubscriptionsCount")
		}
		if _deleteSubscriptionsCountErr != nil {
			return errors.Wrap(_deleteSubscriptionsCountErr, "Error serializing 'deleteSubscriptionsCount' field")
		}

		// Simple Field (addNodesCount)
		if pushErr := writeBuffer.PushContext("addNodesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for addNodesCount")
		}
		_addNodesCountErr := writeBuffer.WriteSerializable(ctx, m.GetAddNodesCount())
		if popErr := writeBuffer.PopContext("addNodesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for addNodesCount")
		}
		if _addNodesCountErr != nil {
			return errors.Wrap(_addNodesCountErr, "Error serializing 'addNodesCount' field")
		}

		// Simple Field (addReferencesCount)
		if pushErr := writeBuffer.PushContext("addReferencesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for addReferencesCount")
		}
		_addReferencesCountErr := writeBuffer.WriteSerializable(ctx, m.GetAddReferencesCount())
		if popErr := writeBuffer.PopContext("addReferencesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for addReferencesCount")
		}
		if _addReferencesCountErr != nil {
			return errors.Wrap(_addReferencesCountErr, "Error serializing 'addReferencesCount' field")
		}

		// Simple Field (deleteNodesCount)
		if pushErr := writeBuffer.PushContext("deleteNodesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for deleteNodesCount")
		}
		_deleteNodesCountErr := writeBuffer.WriteSerializable(ctx, m.GetDeleteNodesCount())
		if popErr := writeBuffer.PopContext("deleteNodesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for deleteNodesCount")
		}
		if _deleteNodesCountErr != nil {
			return errors.Wrap(_deleteNodesCountErr, "Error serializing 'deleteNodesCount' field")
		}

		// Simple Field (deleteReferencesCount)
		if pushErr := writeBuffer.PushContext("deleteReferencesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for deleteReferencesCount")
		}
		_deleteReferencesCountErr := writeBuffer.WriteSerializable(ctx, m.GetDeleteReferencesCount())
		if popErr := writeBuffer.PopContext("deleteReferencesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for deleteReferencesCount")
		}
		if _deleteReferencesCountErr != nil {
			return errors.Wrap(_deleteReferencesCountErr, "Error serializing 'deleteReferencesCount' field")
		}

		// Simple Field (browseCount)
		if pushErr := writeBuffer.PushContext("browseCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for browseCount")
		}
		_browseCountErr := writeBuffer.WriteSerializable(ctx, m.GetBrowseCount())
		if popErr := writeBuffer.PopContext("browseCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for browseCount")
		}
		if _browseCountErr != nil {
			return errors.Wrap(_browseCountErr, "Error serializing 'browseCount' field")
		}

		// Simple Field (browseNextCount)
		if pushErr := writeBuffer.PushContext("browseNextCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for browseNextCount")
		}
		_browseNextCountErr := writeBuffer.WriteSerializable(ctx, m.GetBrowseNextCount())
		if popErr := writeBuffer.PopContext("browseNextCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for browseNextCount")
		}
		if _browseNextCountErr != nil {
			return errors.Wrap(_browseNextCountErr, "Error serializing 'browseNextCount' field")
		}

		// Simple Field (translateBrowsePathsToNodeIdsCount)
		if pushErr := writeBuffer.PushContext("translateBrowsePathsToNodeIdsCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for translateBrowsePathsToNodeIdsCount")
		}
		_translateBrowsePathsToNodeIdsCountErr := writeBuffer.WriteSerializable(ctx, m.GetTranslateBrowsePathsToNodeIdsCount())
		if popErr := writeBuffer.PopContext("translateBrowsePathsToNodeIdsCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for translateBrowsePathsToNodeIdsCount")
		}
		if _translateBrowsePathsToNodeIdsCountErr != nil {
			return errors.Wrap(_translateBrowsePathsToNodeIdsCountErr, "Error serializing 'translateBrowsePathsToNodeIdsCount' field")
		}

		// Simple Field (queryFirstCount)
		if pushErr := writeBuffer.PushContext("queryFirstCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for queryFirstCount")
		}
		_queryFirstCountErr := writeBuffer.WriteSerializable(ctx, m.GetQueryFirstCount())
		if popErr := writeBuffer.PopContext("queryFirstCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for queryFirstCount")
		}
		if _queryFirstCountErr != nil {
			return errors.Wrap(_queryFirstCountErr, "Error serializing 'queryFirstCount' field")
		}

		// Simple Field (queryNextCount)
		if pushErr := writeBuffer.PushContext("queryNextCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for queryNextCount")
		}
		_queryNextCountErr := writeBuffer.WriteSerializable(ctx, m.GetQueryNextCount())
		if popErr := writeBuffer.PopContext("queryNextCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for queryNextCount")
		}
		if _queryNextCountErr != nil {
			return errors.Wrap(_queryNextCountErr, "Error serializing 'queryNextCount' field")
		}

		// Simple Field (registerNodesCount)
		if pushErr := writeBuffer.PushContext("registerNodesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for registerNodesCount")
		}
		_registerNodesCountErr := writeBuffer.WriteSerializable(ctx, m.GetRegisterNodesCount())
		if popErr := writeBuffer.PopContext("registerNodesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for registerNodesCount")
		}
		if _registerNodesCountErr != nil {
			return errors.Wrap(_registerNodesCountErr, "Error serializing 'registerNodesCount' field")
		}

		// Simple Field (unregisterNodesCount)
		if pushErr := writeBuffer.PushContext("unregisterNodesCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for unregisterNodesCount")
		}
		_unregisterNodesCountErr := writeBuffer.WriteSerializable(ctx, m.GetUnregisterNodesCount())
		if popErr := writeBuffer.PopContext("unregisterNodesCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for unregisterNodesCount")
		}
		if _unregisterNodesCountErr != nil {
			return errors.Wrap(_unregisterNodesCountErr, "Error serializing 'unregisterNodesCount' field")
		}

		if popErr := writeBuffer.PopContext("SessionDiagnosticsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SessionDiagnosticsDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SessionDiagnosticsDataType) isSessionDiagnosticsDataType() bool {
	return true
}

func (m *_SessionDiagnosticsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
