/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ServerOnNetwork is the corresponding interface of ServerOnNetwork
type ServerOnNetwork interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRecordId returns RecordId (property field)
	GetRecordId() uint32
	// GetServerName returns ServerName (property field)
	GetServerName() PascalString
	// GetDiscoveryUrl returns DiscoveryUrl (property field)
	GetDiscoveryUrl() PascalString
	// GetNoOfServerCapabilities returns NoOfServerCapabilities (property field)
	GetNoOfServerCapabilities() int32
	// GetServerCapabilities returns ServerCapabilities (property field)
	GetServerCapabilities() []PascalString
}

// ServerOnNetworkExactly can be used when we want exactly this type and not a type which fulfills ServerOnNetwork.
// This is useful for switch cases.
type ServerOnNetworkExactly interface {
	ServerOnNetwork
	isServerOnNetwork() bool
}

// _ServerOnNetwork is the data-structure of this message
type _ServerOnNetwork struct {
	*_ExtensionObjectDefinition
	RecordId               uint32
	ServerName             PascalString
	DiscoveryUrl           PascalString
	NoOfServerCapabilities int32
	ServerCapabilities     []PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ServerOnNetwork) GetIdentifier() string {
	return "12191"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ServerOnNetwork) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ServerOnNetwork) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ServerOnNetwork) GetRecordId() uint32 {
	return m.RecordId
}

func (m *_ServerOnNetwork) GetServerName() PascalString {
	return m.ServerName
}

func (m *_ServerOnNetwork) GetDiscoveryUrl() PascalString {
	return m.DiscoveryUrl
}

func (m *_ServerOnNetwork) GetNoOfServerCapabilities() int32 {
	return m.NoOfServerCapabilities
}

func (m *_ServerOnNetwork) GetServerCapabilities() []PascalString {
	return m.ServerCapabilities
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewServerOnNetwork factory function for _ServerOnNetwork
func NewServerOnNetwork(recordId uint32, serverName PascalString, discoveryUrl PascalString, noOfServerCapabilities int32, serverCapabilities []PascalString) *_ServerOnNetwork {
	_result := &_ServerOnNetwork{
		RecordId:                   recordId,
		ServerName:                 serverName,
		DiscoveryUrl:               discoveryUrl,
		NoOfServerCapabilities:     noOfServerCapabilities,
		ServerCapabilities:         serverCapabilities,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastServerOnNetwork(structType any) ServerOnNetwork {
	if casted, ok := structType.(ServerOnNetwork); ok {
		return casted
	}
	if casted, ok := structType.(*ServerOnNetwork); ok {
		return *casted
	}
	return nil
}

func (m *_ServerOnNetwork) GetTypeName() string {
	return "ServerOnNetwork"
}

func (m *_ServerOnNetwork) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (recordId)
	lengthInBits += 32

	// Simple field (serverName)
	lengthInBits += m.ServerName.GetLengthInBits(ctx)

	// Simple field (discoveryUrl)
	lengthInBits += m.DiscoveryUrl.GetLengthInBits(ctx)

	// Simple field (noOfServerCapabilities)
	lengthInBits += 32

	// Array field
	if len(m.ServerCapabilities) > 0 {
		for _curItem, element := range m.ServerCapabilities {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerCapabilities), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ServerOnNetwork) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ServerOnNetworkParse(ctx context.Context, theBytes []byte, identifier string) (ServerOnNetwork, error) {
	return ServerOnNetworkParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ServerOnNetworkParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ServerOnNetwork, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ServerOnNetwork"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ServerOnNetwork")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (recordId)
	_recordId, _recordIdErr := readBuffer.ReadUint32("recordId", 32)
	if _recordIdErr != nil {
		return nil, errors.Wrap(_recordIdErr, "Error parsing 'recordId' field of ServerOnNetwork")
	}
	recordId := _recordId

	// Simple Field (serverName)
	if pullErr := readBuffer.PullContext("serverName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverName")
	}
	_serverName, _serverNameErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _serverNameErr != nil {
		return nil, errors.Wrap(_serverNameErr, "Error parsing 'serverName' field of ServerOnNetwork")
	}
	serverName := _serverName.(PascalString)
	if closeErr := readBuffer.CloseContext("serverName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverName")
	}

	// Simple Field (discoveryUrl)
	if pullErr := readBuffer.PullContext("discoveryUrl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for discoveryUrl")
	}
	_discoveryUrl, _discoveryUrlErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _discoveryUrlErr != nil {
		return nil, errors.Wrap(_discoveryUrlErr, "Error parsing 'discoveryUrl' field of ServerOnNetwork")
	}
	discoveryUrl := _discoveryUrl.(PascalString)
	if closeErr := readBuffer.CloseContext("discoveryUrl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for discoveryUrl")
	}

	// Simple Field (noOfServerCapabilities)
	_noOfServerCapabilities, _noOfServerCapabilitiesErr := readBuffer.ReadInt32("noOfServerCapabilities", 32)
	if _noOfServerCapabilitiesErr != nil {
		return nil, errors.Wrap(_noOfServerCapabilitiesErr, "Error parsing 'noOfServerCapabilities' field of ServerOnNetwork")
	}
	noOfServerCapabilities := _noOfServerCapabilities

	// Array field (serverCapabilities)
	if pullErr := readBuffer.PullContext("serverCapabilities", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverCapabilities")
	}
	// Count array
	serverCapabilities := make([]PascalString, utils.Max(noOfServerCapabilities, 0))
	// This happens when the size is set conditional to 0
	if len(serverCapabilities) == 0 {
		serverCapabilities = nil
	}
	{
		_numItems := uint16(utils.Max(noOfServerCapabilities, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := PascalStringParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'serverCapabilities' field of ServerOnNetwork")
			}
			serverCapabilities[_curItem] = _item.(PascalString)
		}
	}
	if closeErr := readBuffer.CloseContext("serverCapabilities", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverCapabilities")
	}

	if closeErr := readBuffer.CloseContext("ServerOnNetwork"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ServerOnNetwork")
	}

	// Create a partially initialized instance
	_child := &_ServerOnNetwork{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RecordId:                   recordId,
		ServerName:                 serverName,
		DiscoveryUrl:               discoveryUrl,
		NoOfServerCapabilities:     noOfServerCapabilities,
		ServerCapabilities:         serverCapabilities,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ServerOnNetwork) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ServerOnNetwork) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ServerOnNetwork"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ServerOnNetwork")
		}

		// Simple Field (recordId)
		recordId := uint32(m.GetRecordId())
		_recordIdErr := writeBuffer.WriteUint32("recordId", 32, uint32((recordId)))
		if _recordIdErr != nil {
			return errors.Wrap(_recordIdErr, "Error serializing 'recordId' field")
		}

		// Simple Field (serverName)
		if pushErr := writeBuffer.PushContext("serverName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverName")
		}
		_serverNameErr := writeBuffer.WriteSerializable(ctx, m.GetServerName())
		if popErr := writeBuffer.PopContext("serverName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverName")
		}
		if _serverNameErr != nil {
			return errors.Wrap(_serverNameErr, "Error serializing 'serverName' field")
		}

		// Simple Field (discoveryUrl)
		if pushErr := writeBuffer.PushContext("discoveryUrl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for discoveryUrl")
		}
		_discoveryUrlErr := writeBuffer.WriteSerializable(ctx, m.GetDiscoveryUrl())
		if popErr := writeBuffer.PopContext("discoveryUrl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for discoveryUrl")
		}
		if _discoveryUrlErr != nil {
			return errors.Wrap(_discoveryUrlErr, "Error serializing 'discoveryUrl' field")
		}

		// Simple Field (noOfServerCapabilities)
		noOfServerCapabilities := int32(m.GetNoOfServerCapabilities())
		_noOfServerCapabilitiesErr := writeBuffer.WriteInt32("noOfServerCapabilities", 32, int32((noOfServerCapabilities)))
		if _noOfServerCapabilitiesErr != nil {
			return errors.Wrap(_noOfServerCapabilitiesErr, "Error serializing 'noOfServerCapabilities' field")
		}

		// Array Field (serverCapabilities)
		if pushErr := writeBuffer.PushContext("serverCapabilities", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverCapabilities")
		}
		for _curItem, _element := range m.GetServerCapabilities() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetServerCapabilities()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'serverCapabilities' field")
			}
		}
		if popErr := writeBuffer.PopContext("serverCapabilities", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverCapabilities")
		}

		if popErr := writeBuffer.PopContext("ServerOnNetwork"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ServerOnNetwork")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ServerOnNetwork) isServerOnNetwork() bool {
	return true
}

func (m *_ServerOnNetwork) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
