/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// RegisteredServer is the corresponding interface of RegisteredServer
type RegisteredServer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetServerUri returns ServerUri (property field)
	GetServerUri() PascalString
	// GetProductUri returns ProductUri (property field)
	GetProductUri() PascalString
	// GetNoOfServerNames returns NoOfServerNames (property field)
	GetNoOfServerNames() int32
	// GetServerNames returns ServerNames (property field)
	GetServerNames() []LocalizedText
	// GetServerType returns ServerType (property field)
	GetServerType() ApplicationType
	// GetGatewayServerUri returns GatewayServerUri (property field)
	GetGatewayServerUri() PascalString
	// GetNoOfDiscoveryUrls returns NoOfDiscoveryUrls (property field)
	GetNoOfDiscoveryUrls() int32
	// GetDiscoveryUrls returns DiscoveryUrls (property field)
	GetDiscoveryUrls() []PascalString
	// GetSemaphoreFilePath returns SemaphoreFilePath (property field)
	GetSemaphoreFilePath() PascalString
	// GetIsOnline returns IsOnline (property field)
	GetIsOnline() bool
}

// RegisteredServerExactly can be used when we want exactly this type and not a type which fulfills RegisteredServer.
// This is useful for switch cases.
type RegisteredServerExactly interface {
	RegisteredServer
	isRegisteredServer() bool
}

// _RegisteredServer is the data-structure of this message
type _RegisteredServer struct {
	*_ExtensionObjectDefinition
	ServerUri         PascalString
	ProductUri        PascalString
	NoOfServerNames   int32
	ServerNames       []LocalizedText
	ServerType        ApplicationType
	GatewayServerUri  PascalString
	NoOfDiscoveryUrls int32
	DiscoveryUrls     []PascalString
	SemaphoreFilePath PascalString
	IsOnline          bool
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RegisteredServer) GetIdentifier() string {
	return "434"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RegisteredServer) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_RegisteredServer) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RegisteredServer) GetServerUri() PascalString {
	return m.ServerUri
}

func (m *_RegisteredServer) GetProductUri() PascalString {
	return m.ProductUri
}

func (m *_RegisteredServer) GetNoOfServerNames() int32 {
	return m.NoOfServerNames
}

func (m *_RegisteredServer) GetServerNames() []LocalizedText {
	return m.ServerNames
}

func (m *_RegisteredServer) GetServerType() ApplicationType {
	return m.ServerType
}

func (m *_RegisteredServer) GetGatewayServerUri() PascalString {
	return m.GatewayServerUri
}

func (m *_RegisteredServer) GetNoOfDiscoveryUrls() int32 {
	return m.NoOfDiscoveryUrls
}

func (m *_RegisteredServer) GetDiscoveryUrls() []PascalString {
	return m.DiscoveryUrls
}

func (m *_RegisteredServer) GetSemaphoreFilePath() PascalString {
	return m.SemaphoreFilePath
}

func (m *_RegisteredServer) GetIsOnline() bool {
	return m.IsOnline
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewRegisteredServer factory function for _RegisteredServer
func NewRegisteredServer(serverUri PascalString, productUri PascalString, noOfServerNames int32, serverNames []LocalizedText, serverType ApplicationType, gatewayServerUri PascalString, noOfDiscoveryUrls int32, discoveryUrls []PascalString, semaphoreFilePath PascalString, isOnline bool) *_RegisteredServer {
	_result := &_RegisteredServer{
		ServerUri:                  serverUri,
		ProductUri:                 productUri,
		NoOfServerNames:            noOfServerNames,
		ServerNames:                serverNames,
		ServerType:                 serverType,
		GatewayServerUri:           gatewayServerUri,
		NoOfDiscoveryUrls:          noOfDiscoveryUrls,
		DiscoveryUrls:              discoveryUrls,
		SemaphoreFilePath:          semaphoreFilePath,
		IsOnline:                   isOnline,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastRegisteredServer(structType any) RegisteredServer {
	if casted, ok := structType.(RegisteredServer); ok {
		return casted
	}
	if casted, ok := structType.(*RegisteredServer); ok {
		return *casted
	}
	return nil
}

func (m *_RegisteredServer) GetTypeName() string {
	return "RegisteredServer"
}

func (m *_RegisteredServer) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (serverUri)
	lengthInBits += m.ServerUri.GetLengthInBits(ctx)

	// Simple field (productUri)
	lengthInBits += m.ProductUri.GetLengthInBits(ctx)

	// Simple field (noOfServerNames)
	lengthInBits += 32

	// Array field
	if len(m.ServerNames) > 0 {
		for _curItem, element := range m.ServerNames {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerNames), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (serverType)
	lengthInBits += 32

	// Simple field (gatewayServerUri)
	lengthInBits += m.GatewayServerUri.GetLengthInBits(ctx)

	// Simple field (noOfDiscoveryUrls)
	lengthInBits += 32

	// Array field
	if len(m.DiscoveryUrls) > 0 {
		for _curItem, element := range m.DiscoveryUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiscoveryUrls), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (semaphoreFilePath)
	lengthInBits += m.SemaphoreFilePath.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isOnline)
	lengthInBits += 1

	return lengthInBits
}

func (m *_RegisteredServer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RegisteredServerParse(ctx context.Context, theBytes []byte, identifier string) (RegisteredServer, error) {
	return RegisteredServerParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func RegisteredServerParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (RegisteredServer, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("RegisteredServer"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RegisteredServer")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (serverUri)
	if pullErr := readBuffer.PullContext("serverUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverUri")
	}
	_serverUri, _serverUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _serverUriErr != nil {
		return nil, errors.Wrap(_serverUriErr, "Error parsing 'serverUri' field of RegisteredServer")
	}
	serverUri := _serverUri.(PascalString)
	if closeErr := readBuffer.CloseContext("serverUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverUri")
	}

	// Simple Field (productUri)
	if pullErr := readBuffer.PullContext("productUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for productUri")
	}
	_productUri, _productUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _productUriErr != nil {
		return nil, errors.Wrap(_productUriErr, "Error parsing 'productUri' field of RegisteredServer")
	}
	productUri := _productUri.(PascalString)
	if closeErr := readBuffer.CloseContext("productUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for productUri")
	}

	// Simple Field (noOfServerNames)
	_noOfServerNames, _noOfServerNamesErr := readBuffer.ReadInt32("noOfServerNames", 32)
	if _noOfServerNamesErr != nil {
		return nil, errors.Wrap(_noOfServerNamesErr, "Error parsing 'noOfServerNames' field of RegisteredServer")
	}
	noOfServerNames := _noOfServerNames

	// Array field (serverNames)
	if pullErr := readBuffer.PullContext("serverNames", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverNames")
	}
	// Count array
	serverNames := make([]LocalizedText, utils.Max(noOfServerNames, 0))
	// This happens when the size is set conditional to 0
	if len(serverNames) == 0 {
		serverNames = nil
	}
	{
		_numItems := uint16(utils.Max(noOfServerNames, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := LocalizedTextParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'serverNames' field of RegisteredServer")
			}
			serverNames[_curItem] = _item.(LocalizedText)
		}
	}
	if closeErr := readBuffer.CloseContext("serverNames", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverNames")
	}

	// Simple Field (serverType)
	if pullErr := readBuffer.PullContext("serverType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serverType")
	}
	_serverType, _serverTypeErr := ApplicationTypeParseWithBuffer(ctx, readBuffer)
	if _serverTypeErr != nil {
		return nil, errors.Wrap(_serverTypeErr, "Error parsing 'serverType' field of RegisteredServer")
	}
	serverType := _serverType
	if closeErr := readBuffer.CloseContext("serverType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serverType")
	}

	// Simple Field (gatewayServerUri)
	if pullErr := readBuffer.PullContext("gatewayServerUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for gatewayServerUri")
	}
	_gatewayServerUri, _gatewayServerUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _gatewayServerUriErr != nil {
		return nil, errors.Wrap(_gatewayServerUriErr, "Error parsing 'gatewayServerUri' field of RegisteredServer")
	}
	gatewayServerUri := _gatewayServerUri.(PascalString)
	if closeErr := readBuffer.CloseContext("gatewayServerUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for gatewayServerUri")
	}

	// Simple Field (noOfDiscoveryUrls)
	_noOfDiscoveryUrls, _noOfDiscoveryUrlsErr := readBuffer.ReadInt32("noOfDiscoveryUrls", 32)
	if _noOfDiscoveryUrlsErr != nil {
		return nil, errors.Wrap(_noOfDiscoveryUrlsErr, "Error parsing 'noOfDiscoveryUrls' field of RegisteredServer")
	}
	noOfDiscoveryUrls := _noOfDiscoveryUrls

	// Array field (discoveryUrls)
	if pullErr := readBuffer.PullContext("discoveryUrls", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for discoveryUrls")
	}
	// Count array
	discoveryUrls := make([]PascalString, utils.Max(noOfDiscoveryUrls, 0))
	// This happens when the size is set conditional to 0
	if len(discoveryUrls) == 0 {
		discoveryUrls = nil
	}
	{
		_numItems := uint16(utils.Max(noOfDiscoveryUrls, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := PascalStringParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'discoveryUrls' field of RegisteredServer")
			}
			discoveryUrls[_curItem] = _item.(PascalString)
		}
	}
	if closeErr := readBuffer.CloseContext("discoveryUrls", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for discoveryUrls")
	}

	// Simple Field (semaphoreFilePath)
	if pullErr := readBuffer.PullContext("semaphoreFilePath"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for semaphoreFilePath")
	}
	_semaphoreFilePath, _semaphoreFilePathErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _semaphoreFilePathErr != nil {
		return nil, errors.Wrap(_semaphoreFilePathErr, "Error parsing 'semaphoreFilePath' field of RegisteredServer")
	}
	semaphoreFilePath := _semaphoreFilePath.(PascalString)
	if closeErr := readBuffer.CloseContext("semaphoreFilePath"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for semaphoreFilePath")
	}

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of RegisteredServer")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (isOnline)
	_isOnline, _isOnlineErr := readBuffer.ReadBit("isOnline")
	if _isOnlineErr != nil {
		return nil, errors.Wrap(_isOnlineErr, "Error parsing 'isOnline' field of RegisteredServer")
	}
	isOnline := _isOnline

	if closeErr := readBuffer.CloseContext("RegisteredServer"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RegisteredServer")
	}

	// Create a partially initialized instance
	_child := &_RegisteredServer{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		ServerUri:                  serverUri,
		ProductUri:                 productUri,
		NoOfServerNames:            noOfServerNames,
		ServerNames:                serverNames,
		ServerType:                 serverType,
		GatewayServerUri:           gatewayServerUri,
		NoOfDiscoveryUrls:          noOfDiscoveryUrls,
		DiscoveryUrls:              discoveryUrls,
		SemaphoreFilePath:          semaphoreFilePath,
		IsOnline:                   isOnline,
		reservedField0:             reservedField0,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_RegisteredServer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RegisteredServer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RegisteredServer"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RegisteredServer")
		}

		// Simple Field (serverUri)
		if pushErr := writeBuffer.PushContext("serverUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverUri")
		}
		_serverUriErr := writeBuffer.WriteSerializable(ctx, m.GetServerUri())
		if popErr := writeBuffer.PopContext("serverUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverUri")
		}
		if _serverUriErr != nil {
			return errors.Wrap(_serverUriErr, "Error serializing 'serverUri' field")
		}

		// Simple Field (productUri)
		if pushErr := writeBuffer.PushContext("productUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for productUri")
		}
		_productUriErr := writeBuffer.WriteSerializable(ctx, m.GetProductUri())
		if popErr := writeBuffer.PopContext("productUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for productUri")
		}
		if _productUriErr != nil {
			return errors.Wrap(_productUriErr, "Error serializing 'productUri' field")
		}

		// Simple Field (noOfServerNames)
		noOfServerNames := int32(m.GetNoOfServerNames())
		_noOfServerNamesErr := writeBuffer.WriteInt32("noOfServerNames", 32, int32((noOfServerNames)))
		if _noOfServerNamesErr != nil {
			return errors.Wrap(_noOfServerNamesErr, "Error serializing 'noOfServerNames' field")
		}

		// Array Field (serverNames)
		if pushErr := writeBuffer.PushContext("serverNames", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverNames")
		}
		for _curItem, _element := range m.GetServerNames() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetServerNames()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'serverNames' field")
			}
		}
		if popErr := writeBuffer.PopContext("serverNames", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverNames")
		}

		// Simple Field (serverType)
		if pushErr := writeBuffer.PushContext("serverType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for serverType")
		}
		_serverTypeErr := writeBuffer.WriteSerializable(ctx, m.GetServerType())
		if popErr := writeBuffer.PopContext("serverType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for serverType")
		}
		if _serverTypeErr != nil {
			return errors.Wrap(_serverTypeErr, "Error serializing 'serverType' field")
		}

		// Simple Field (gatewayServerUri)
		if pushErr := writeBuffer.PushContext("gatewayServerUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for gatewayServerUri")
		}
		_gatewayServerUriErr := writeBuffer.WriteSerializable(ctx, m.GetGatewayServerUri())
		if popErr := writeBuffer.PopContext("gatewayServerUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for gatewayServerUri")
		}
		if _gatewayServerUriErr != nil {
			return errors.Wrap(_gatewayServerUriErr, "Error serializing 'gatewayServerUri' field")
		}

		// Simple Field (noOfDiscoveryUrls)
		noOfDiscoveryUrls := int32(m.GetNoOfDiscoveryUrls())
		_noOfDiscoveryUrlsErr := writeBuffer.WriteInt32("noOfDiscoveryUrls", 32, int32((noOfDiscoveryUrls)))
		if _noOfDiscoveryUrlsErr != nil {
			return errors.Wrap(_noOfDiscoveryUrlsErr, "Error serializing 'noOfDiscoveryUrls' field")
		}

		// Array Field (discoveryUrls)
		if pushErr := writeBuffer.PushContext("discoveryUrls", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for discoveryUrls")
		}
		for _curItem, _element := range m.GetDiscoveryUrls() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetDiscoveryUrls()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'discoveryUrls' field")
			}
		}
		if popErr := writeBuffer.PopContext("discoveryUrls", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for discoveryUrls")
		}

		// Simple Field (semaphoreFilePath)
		if pushErr := writeBuffer.PushContext("semaphoreFilePath"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for semaphoreFilePath")
		}
		_semaphoreFilePathErr := writeBuffer.WriteSerializable(ctx, m.GetSemaphoreFilePath())
		if popErr := writeBuffer.PopContext("semaphoreFilePath"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for semaphoreFilePath")
		}
		if _semaphoreFilePathErr != nil {
			return errors.Wrap(_semaphoreFilePathErr, "Error serializing 'semaphoreFilePath' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 7, uint8(reserved))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (isOnline)
		isOnline := bool(m.GetIsOnline())
		_isOnlineErr := writeBuffer.WriteBit("isOnline", (isOnline))
		if _isOnlineErr != nil {
			return errors.Wrap(_isOnlineErr, "Error serializing 'isOnline' field")
		}

		if popErr := writeBuffer.PopContext("RegisteredServer"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RegisteredServer")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RegisteredServer) isRegisteredServer() bool {
	return true
}

func (m *_RegisteredServer) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
