/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ReferenceDescription is the corresponding interface of ReferenceDescription
type ReferenceDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetReferenceTypeId returns ReferenceTypeId (property field)
	GetReferenceTypeId() NodeId
	// GetIsForward returns IsForward (property field)
	GetIsForward() bool
	// GetNodeId returns NodeId (property field)
	GetNodeId() ExpandedNodeId
	// GetBrowseName returns BrowseName (property field)
	GetBrowseName() QualifiedName
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetNodeClass returns NodeClass (property field)
	GetNodeClass() NodeClass
	// GetTypeDefinition returns TypeDefinition (property field)
	GetTypeDefinition() ExpandedNodeId
}

// ReferenceDescriptionExactly can be used when we want exactly this type and not a type which fulfills ReferenceDescription.
// This is useful for switch cases.
type ReferenceDescriptionExactly interface {
	ReferenceDescription
	isReferenceDescription() bool
}

// _ReferenceDescription is the data-structure of this message
type _ReferenceDescription struct {
	*_ExtensionObjectDefinition
	ReferenceTypeId NodeId
	IsForward       bool
	NodeId          ExpandedNodeId
	BrowseName      QualifiedName
	DisplayName     LocalizedText
	NodeClass       NodeClass
	TypeDefinition  ExpandedNodeId
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReferenceDescription) GetIdentifier() string {
	return "520"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReferenceDescription) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ReferenceDescription) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReferenceDescription) GetReferenceTypeId() NodeId {
	return m.ReferenceTypeId
}

func (m *_ReferenceDescription) GetIsForward() bool {
	return m.IsForward
}

func (m *_ReferenceDescription) GetNodeId() ExpandedNodeId {
	return m.NodeId
}

func (m *_ReferenceDescription) GetBrowseName() QualifiedName {
	return m.BrowseName
}

func (m *_ReferenceDescription) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_ReferenceDescription) GetNodeClass() NodeClass {
	return m.NodeClass
}

func (m *_ReferenceDescription) GetTypeDefinition() ExpandedNodeId {
	return m.TypeDefinition
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewReferenceDescription factory function for _ReferenceDescription
func NewReferenceDescription(referenceTypeId NodeId, isForward bool, nodeId ExpandedNodeId, browseName QualifiedName, displayName LocalizedText, nodeClass NodeClass, typeDefinition ExpandedNodeId) *_ReferenceDescription {
	_result := &_ReferenceDescription{
		ReferenceTypeId:            referenceTypeId,
		IsForward:                  isForward,
		NodeId:                     nodeId,
		BrowseName:                 browseName,
		DisplayName:                displayName,
		NodeClass:                  nodeClass,
		TypeDefinition:             typeDefinition,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastReferenceDescription(structType any) ReferenceDescription {
	if casted, ok := structType.(ReferenceDescription); ok {
		return casted
	}
	if casted, ok := structType.(*ReferenceDescription); ok {
		return *casted
	}
	return nil
}

func (m *_ReferenceDescription) GetTypeName() string {
	return "ReferenceDescription"
}

func (m *_ReferenceDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (referenceTypeId)
	lengthInBits += m.ReferenceTypeId.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isForward)
	lengthInBits += 1

	// Simple field (nodeId)
	lengthInBits += m.NodeId.GetLengthInBits(ctx)

	// Simple field (browseName)
	lengthInBits += m.BrowseName.GetLengthInBits(ctx)

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (nodeClass)
	lengthInBits += 32

	// Simple field (typeDefinition)
	lengthInBits += m.TypeDefinition.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReferenceDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ReferenceDescriptionParse(ctx context.Context, theBytes []byte, identifier string) (ReferenceDescription, error) {
	return ReferenceDescriptionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ReferenceDescriptionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ReferenceDescription, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ReferenceDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReferenceDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (referenceTypeId)
	if pullErr := readBuffer.PullContext("referenceTypeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for referenceTypeId")
	}
	_referenceTypeId, _referenceTypeIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _referenceTypeIdErr != nil {
		return nil, errors.Wrap(_referenceTypeIdErr, "Error parsing 'referenceTypeId' field of ReferenceDescription")
	}
	referenceTypeId := _referenceTypeId.(NodeId)
	if closeErr := readBuffer.CloseContext("referenceTypeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for referenceTypeId")
	}

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of ReferenceDescription")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (isForward)
	_isForward, _isForwardErr := readBuffer.ReadBit("isForward")
	if _isForwardErr != nil {
		return nil, errors.Wrap(_isForwardErr, "Error parsing 'isForward' field of ReferenceDescription")
	}
	isForward := _isForward

	// Simple Field (nodeId)
	if pullErr := readBuffer.PullContext("nodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for nodeId")
	}
	_nodeId, _nodeIdErr := ExpandedNodeIdParseWithBuffer(ctx, readBuffer)
	if _nodeIdErr != nil {
		return nil, errors.Wrap(_nodeIdErr, "Error parsing 'nodeId' field of ReferenceDescription")
	}
	nodeId := _nodeId.(ExpandedNodeId)
	if closeErr := readBuffer.CloseContext("nodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for nodeId")
	}

	// Simple Field (browseName)
	if pullErr := readBuffer.PullContext("browseName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for browseName")
	}
	_browseName, _browseNameErr := QualifiedNameParseWithBuffer(ctx, readBuffer)
	if _browseNameErr != nil {
		return nil, errors.Wrap(_browseNameErr, "Error parsing 'browseName' field of ReferenceDescription")
	}
	browseName := _browseName.(QualifiedName)
	if closeErr := readBuffer.CloseContext("browseName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for browseName")
	}

	// Simple Field (displayName)
	if pullErr := readBuffer.PullContext("displayName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for displayName")
	}
	_displayName, _displayNameErr := LocalizedTextParseWithBuffer(ctx, readBuffer)
	if _displayNameErr != nil {
		return nil, errors.Wrap(_displayNameErr, "Error parsing 'displayName' field of ReferenceDescription")
	}
	displayName := _displayName.(LocalizedText)
	if closeErr := readBuffer.CloseContext("displayName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for displayName")
	}

	// Simple Field (nodeClass)
	if pullErr := readBuffer.PullContext("nodeClass"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for nodeClass")
	}
	_nodeClass, _nodeClassErr := NodeClassParseWithBuffer(ctx, readBuffer)
	if _nodeClassErr != nil {
		return nil, errors.Wrap(_nodeClassErr, "Error parsing 'nodeClass' field of ReferenceDescription")
	}
	nodeClass := _nodeClass
	if closeErr := readBuffer.CloseContext("nodeClass"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for nodeClass")
	}

	// Simple Field (typeDefinition)
	if pullErr := readBuffer.PullContext("typeDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for typeDefinition")
	}
	_typeDefinition, _typeDefinitionErr := ExpandedNodeIdParseWithBuffer(ctx, readBuffer)
	if _typeDefinitionErr != nil {
		return nil, errors.Wrap(_typeDefinitionErr, "Error parsing 'typeDefinition' field of ReferenceDescription")
	}
	typeDefinition := _typeDefinition.(ExpandedNodeId)
	if closeErr := readBuffer.CloseContext("typeDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for typeDefinition")
	}

	if closeErr := readBuffer.CloseContext("ReferenceDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReferenceDescription")
	}

	// Create a partially initialized instance
	_child := &_ReferenceDescription{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		ReferenceTypeId:            referenceTypeId,
		IsForward:                  isForward,
		NodeId:                     nodeId,
		BrowseName:                 browseName,
		DisplayName:                displayName,
		NodeClass:                  nodeClass,
		TypeDefinition:             typeDefinition,
		reservedField0:             reservedField0,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ReferenceDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReferenceDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReferenceDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReferenceDescription")
		}

		// Simple Field (referenceTypeId)
		if pushErr := writeBuffer.PushContext("referenceTypeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for referenceTypeId")
		}
		_referenceTypeIdErr := writeBuffer.WriteSerializable(ctx, m.GetReferenceTypeId())
		if popErr := writeBuffer.PopContext("referenceTypeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for referenceTypeId")
		}
		if _referenceTypeIdErr != nil {
			return errors.Wrap(_referenceTypeIdErr, "Error serializing 'referenceTypeId' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 7, uint8(reserved))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (isForward)
		isForward := bool(m.GetIsForward())
		_isForwardErr := writeBuffer.WriteBit("isForward", (isForward))
		if _isForwardErr != nil {
			return errors.Wrap(_isForwardErr, "Error serializing 'isForward' field")
		}

		// Simple Field (nodeId)
		if pushErr := writeBuffer.PushContext("nodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nodeId")
		}
		_nodeIdErr := writeBuffer.WriteSerializable(ctx, m.GetNodeId())
		if popErr := writeBuffer.PopContext("nodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nodeId")
		}
		if _nodeIdErr != nil {
			return errors.Wrap(_nodeIdErr, "Error serializing 'nodeId' field")
		}

		// Simple Field (browseName)
		if pushErr := writeBuffer.PushContext("browseName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for browseName")
		}
		_browseNameErr := writeBuffer.WriteSerializable(ctx, m.GetBrowseName())
		if popErr := writeBuffer.PopContext("browseName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for browseName")
		}
		if _browseNameErr != nil {
			return errors.Wrap(_browseNameErr, "Error serializing 'browseName' field")
		}

		// Simple Field (displayName)
		if pushErr := writeBuffer.PushContext("displayName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for displayName")
		}
		_displayNameErr := writeBuffer.WriteSerializable(ctx, m.GetDisplayName())
		if popErr := writeBuffer.PopContext("displayName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for displayName")
		}
		if _displayNameErr != nil {
			return errors.Wrap(_displayNameErr, "Error serializing 'displayName' field")
		}

		// Simple Field (nodeClass)
		if pushErr := writeBuffer.PushContext("nodeClass"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nodeClass")
		}
		_nodeClassErr := writeBuffer.WriteSerializable(ctx, m.GetNodeClass())
		if popErr := writeBuffer.PopContext("nodeClass"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nodeClass")
		}
		if _nodeClassErr != nil {
			return errors.Wrap(_nodeClassErr, "Error serializing 'nodeClass' field")
		}

		// Simple Field (typeDefinition)
		if pushErr := writeBuffer.PushContext("typeDefinition"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for typeDefinition")
		}
		_typeDefinitionErr := writeBuffer.WriteSerializable(ctx, m.GetTypeDefinition())
		if popErr := writeBuffer.PopContext("typeDefinition"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for typeDefinition")
		}
		if _typeDefinitionErr != nil {
			return errors.Wrap(_typeDefinitionErr, "Error serializing 'typeDefinition' field")
		}

		if popErr := writeBuffer.PopContext("ReferenceDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReferenceDescription")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReferenceDescription) isReferenceDescription() bool {
	return true
}

func (m *_ReferenceDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
