/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ReaderGroupMessageDataType is the corresponding interface of ReaderGroupMessageDataType
type ReaderGroupMessageDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
}

// ReaderGroupMessageDataTypeExactly can be used when we want exactly this type and not a type which fulfills ReaderGroupMessageDataType.
// This is useful for switch cases.
type ReaderGroupMessageDataTypeExactly interface {
	ReaderGroupMessageDataType
	isReaderGroupMessageDataType() bool
}

// _ReaderGroupMessageDataType is the data-structure of this message
type _ReaderGroupMessageDataType struct {
	*_ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReaderGroupMessageDataType) GetIdentifier() string {
	return "15624"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReaderGroupMessageDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ReaderGroupMessageDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

// NewReaderGroupMessageDataType factory function for _ReaderGroupMessageDataType
func NewReaderGroupMessageDataType() *_ReaderGroupMessageDataType {
	_result := &_ReaderGroupMessageDataType{
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastReaderGroupMessageDataType(structType any) ReaderGroupMessageDataType {
	if casted, ok := structType.(ReaderGroupMessageDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ReaderGroupMessageDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ReaderGroupMessageDataType) GetTypeName() string {
	return "ReaderGroupMessageDataType"
}

func (m *_ReaderGroupMessageDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	return lengthInBits
}

func (m *_ReaderGroupMessageDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ReaderGroupMessageDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (ReaderGroupMessageDataType, error) {
	return ReaderGroupMessageDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ReaderGroupMessageDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ReaderGroupMessageDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ReaderGroupMessageDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReaderGroupMessageDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ReaderGroupMessageDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReaderGroupMessageDataType")
	}

	// Create a partially initialized instance
	_child := &_ReaderGroupMessageDataType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ReaderGroupMessageDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReaderGroupMessageDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReaderGroupMessageDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReaderGroupMessageDataType")
		}

		if popErr := writeBuffer.PopContext("ReaderGroupMessageDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReaderGroupMessageDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReaderGroupMessageDataType) isReaderGroupMessageDataType() bool {
	return true
}

func (m *_ReaderGroupMessageDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
