/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Payload is the corresponding interface of Payload
type Payload interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetExtensible returns Extensible (discriminator field)
	GetExtensible() bool
	// GetSequenceHeader returns SequenceHeader (property field)
	GetSequenceHeader() SequenceHeader
}

// PayloadExactly can be used when we want exactly this type and not a type which fulfills Payload.
// This is useful for switch cases.
type PayloadExactly interface {
	Payload
	isPayload() bool
}

// _Payload is the data-structure of this message
type _Payload struct {
	_PayloadChildRequirements
	SequenceHeader SequenceHeader

	// Arguments.
	ByteCount uint32
}

type _PayloadChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetExtensible() bool
}

type PayloadParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child Payload, serializeChildFunction func() error) error
	GetTypeName() string
}

type PayloadChild interface {
	utils.Serializable
	InitializeParent(parent Payload, sequenceHeader SequenceHeader)
	GetParent() *Payload

	GetTypeName() string
	Payload
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Payload) GetSequenceHeader() SequenceHeader {
	return m.SequenceHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewPayload factory function for _Payload
func NewPayload(sequenceHeader SequenceHeader, byteCount uint32) *_Payload {
	return &_Payload{SequenceHeader: sequenceHeader, ByteCount: byteCount}
}

// Deprecated: use the interface for direct cast
func CastPayload(structType any) Payload {
	if casted, ok := structType.(Payload); ok {
		return casted
	}
	if casted, ok := structType.(*Payload); ok {
		return *casted
	}
	return nil
}

func (m *_Payload) GetTypeName() string {
	return "Payload"
}

func (m *_Payload) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (sequenceHeader)
	lengthInBits += m.SequenceHeader.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_Payload) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PayloadParse(ctx context.Context, theBytes []byte, extensible bool, byteCount uint32) (Payload, error) {
	return PayloadParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), extensible, byteCount)
}

func PayloadParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, extensible bool, byteCount uint32) (Payload, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Payload"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Payload")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (sequenceHeader)
	if pullErr := readBuffer.PullContext("sequenceHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for sequenceHeader")
	}
	_sequenceHeader, _sequenceHeaderErr := SequenceHeaderParseWithBuffer(ctx, readBuffer)
	if _sequenceHeaderErr != nil {
		return nil, errors.Wrap(_sequenceHeaderErr, "Error parsing 'sequenceHeader' field of Payload")
	}
	sequenceHeader := _sequenceHeader.(SequenceHeader)
	if closeErr := readBuffer.CloseContext("sequenceHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for sequenceHeader")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type PayloadChildSerializeRequirement interface {
		Payload
		InitializeParent(Payload, SequenceHeader)
		GetParent() Payload
	}
	var _childTemp any
	var _child PayloadChildSerializeRequirement
	var typeSwitchError error
	switch {
	case extensible == bool(true): // ExtensiblePayload
		_childTemp, typeSwitchError = ExtensiblePayloadParseWithBuffer(ctx, readBuffer, extensible, byteCount)
	case extensible == bool(false): // BinaryPayload
		_childTemp, typeSwitchError = BinaryPayloadParseWithBuffer(ctx, readBuffer, extensible, byteCount)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [extensible=%v]", extensible)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of Payload")
	}
	_child = _childTemp.(PayloadChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("Payload"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Payload")
	}

	// Finish initializing
	_child.InitializeParent(_child, sequenceHeader)
	return _child, nil
}

func (pm *_Payload) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child Payload, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Payload"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Payload")
	}

	// Simple Field (sequenceHeader)
	if pushErr := writeBuffer.PushContext("sequenceHeader"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for sequenceHeader")
	}
	_sequenceHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetSequenceHeader())
	if popErr := writeBuffer.PopContext("sequenceHeader"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for sequenceHeader")
	}
	if _sequenceHeaderErr != nil {
		return errors.Wrap(_sequenceHeaderErr, "Error serializing 'sequenceHeader' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("Payload"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Payload")
	}
	return nil
}

////
// Arguments Getter

func (m *_Payload) GetByteCount() uint32 {
	return m.ByteCount
}

//
////

func (m *_Payload) isPayload() bool {
	return true
}

func (m *_Payload) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
