/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ParsingResult is the corresponding interface of ParsingResult
type ParsingResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetNoOfDataStatusCodes returns NoOfDataStatusCodes (property field)
	GetNoOfDataStatusCodes() int32
	// GetDataStatusCodes returns DataStatusCodes (property field)
	GetDataStatusCodes() []StatusCode
	// GetNoOfDataDiagnosticInfos returns NoOfDataDiagnosticInfos (property field)
	GetNoOfDataDiagnosticInfos() int32
	// GetDataDiagnosticInfos returns DataDiagnosticInfos (property field)
	GetDataDiagnosticInfos() []DiagnosticInfo
}

// ParsingResultExactly can be used when we want exactly this type and not a type which fulfills ParsingResult.
// This is useful for switch cases.
type ParsingResultExactly interface {
	ParsingResult
	isParsingResult() bool
}

// _ParsingResult is the data-structure of this message
type _ParsingResult struct {
	*_ExtensionObjectDefinition
	StatusCode              StatusCode
	NoOfDataStatusCodes     int32
	DataStatusCodes         []StatusCode
	NoOfDataDiagnosticInfos int32
	DataDiagnosticInfos     []DiagnosticInfo
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ParsingResult) GetIdentifier() string {
	return "612"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ParsingResult) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ParsingResult) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ParsingResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_ParsingResult) GetNoOfDataStatusCodes() int32 {
	return m.NoOfDataStatusCodes
}

func (m *_ParsingResult) GetDataStatusCodes() []StatusCode {
	return m.DataStatusCodes
}

func (m *_ParsingResult) GetNoOfDataDiagnosticInfos() int32 {
	return m.NoOfDataDiagnosticInfos
}

func (m *_ParsingResult) GetDataDiagnosticInfos() []DiagnosticInfo {
	return m.DataDiagnosticInfos
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewParsingResult factory function for _ParsingResult
func NewParsingResult(statusCode StatusCode, noOfDataStatusCodes int32, dataStatusCodes []StatusCode, noOfDataDiagnosticInfos int32, dataDiagnosticInfos []DiagnosticInfo) *_ParsingResult {
	_result := &_ParsingResult{
		StatusCode:                 statusCode,
		NoOfDataStatusCodes:        noOfDataStatusCodes,
		DataStatusCodes:            dataStatusCodes,
		NoOfDataDiagnosticInfos:    noOfDataDiagnosticInfos,
		DataDiagnosticInfos:        dataDiagnosticInfos,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastParsingResult(structType any) ParsingResult {
	if casted, ok := structType.(ParsingResult); ok {
		return casted
	}
	if casted, ok := structType.(*ParsingResult); ok {
		return *casted
	}
	return nil
}

func (m *_ParsingResult) GetTypeName() string {
	return "ParsingResult"
}

func (m *_ParsingResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Simple field (noOfDataStatusCodes)
	lengthInBits += 32

	// Array field
	if len(m.DataStatusCodes) > 0 {
		for _curItem, element := range m.DataStatusCodes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DataStatusCodes), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (noOfDataDiagnosticInfos)
	lengthInBits += 32

	// Array field
	if len(m.DataDiagnosticInfos) > 0 {
		for _curItem, element := range m.DataDiagnosticInfos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DataDiagnosticInfos), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ParsingResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ParsingResultParse(ctx context.Context, theBytes []byte, identifier string) (ParsingResult, error) {
	return ParsingResultParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ParsingResultParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ParsingResult, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ParsingResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ParsingResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (statusCode)
	if pullErr := readBuffer.PullContext("statusCode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for statusCode")
	}
	_statusCode, _statusCodeErr := StatusCodeParseWithBuffer(ctx, readBuffer)
	if _statusCodeErr != nil {
		return nil, errors.Wrap(_statusCodeErr, "Error parsing 'statusCode' field of ParsingResult")
	}
	statusCode := _statusCode.(StatusCode)
	if closeErr := readBuffer.CloseContext("statusCode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for statusCode")
	}

	// Simple Field (noOfDataStatusCodes)
	_noOfDataStatusCodes, _noOfDataStatusCodesErr := readBuffer.ReadInt32("noOfDataStatusCodes", 32)
	if _noOfDataStatusCodesErr != nil {
		return nil, errors.Wrap(_noOfDataStatusCodesErr, "Error parsing 'noOfDataStatusCodes' field of ParsingResult")
	}
	noOfDataStatusCodes := _noOfDataStatusCodes

	// Array field (dataStatusCodes)
	if pullErr := readBuffer.PullContext("dataStatusCodes", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for dataStatusCodes")
	}
	// Count array
	dataStatusCodes := make([]StatusCode, utils.Max(noOfDataStatusCodes, 0))
	// This happens when the size is set conditional to 0
	if len(dataStatusCodes) == 0 {
		dataStatusCodes = nil
	}
	{
		_numItems := uint16(utils.Max(noOfDataStatusCodes, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := StatusCodeParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'dataStatusCodes' field of ParsingResult")
			}
			dataStatusCodes[_curItem] = _item.(StatusCode)
		}
	}
	if closeErr := readBuffer.CloseContext("dataStatusCodes", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for dataStatusCodes")
	}

	// Simple Field (noOfDataDiagnosticInfos)
	_noOfDataDiagnosticInfos, _noOfDataDiagnosticInfosErr := readBuffer.ReadInt32("noOfDataDiagnosticInfos", 32)
	if _noOfDataDiagnosticInfosErr != nil {
		return nil, errors.Wrap(_noOfDataDiagnosticInfosErr, "Error parsing 'noOfDataDiagnosticInfos' field of ParsingResult")
	}
	noOfDataDiagnosticInfos := _noOfDataDiagnosticInfos

	// Array field (dataDiagnosticInfos)
	if pullErr := readBuffer.PullContext("dataDiagnosticInfos", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for dataDiagnosticInfos")
	}
	// Count array
	dataDiagnosticInfos := make([]DiagnosticInfo, utils.Max(noOfDataDiagnosticInfos, 0))
	// This happens when the size is set conditional to 0
	if len(dataDiagnosticInfos) == 0 {
		dataDiagnosticInfos = nil
	}
	{
		_numItems := uint16(utils.Max(noOfDataDiagnosticInfos, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := DiagnosticInfoParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'dataDiagnosticInfos' field of ParsingResult")
			}
			dataDiagnosticInfos[_curItem] = _item.(DiagnosticInfo)
		}
	}
	if closeErr := readBuffer.CloseContext("dataDiagnosticInfos", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for dataDiagnosticInfos")
	}

	if closeErr := readBuffer.CloseContext("ParsingResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ParsingResult")
	}

	// Create a partially initialized instance
	_child := &_ParsingResult{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		StatusCode:                 statusCode,
		NoOfDataStatusCodes:        noOfDataStatusCodes,
		DataStatusCodes:            dataStatusCodes,
		NoOfDataDiagnosticInfos:    noOfDataDiagnosticInfos,
		DataDiagnosticInfos:        dataDiagnosticInfos,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ParsingResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ParsingResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ParsingResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ParsingResult")
		}

		// Simple Field (statusCode)
		if pushErr := writeBuffer.PushContext("statusCode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for statusCode")
		}
		_statusCodeErr := writeBuffer.WriteSerializable(ctx, m.GetStatusCode())
		if popErr := writeBuffer.PopContext("statusCode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for statusCode")
		}
		if _statusCodeErr != nil {
			return errors.Wrap(_statusCodeErr, "Error serializing 'statusCode' field")
		}

		// Simple Field (noOfDataStatusCodes)
		noOfDataStatusCodes := int32(m.GetNoOfDataStatusCodes())
		_noOfDataStatusCodesErr := writeBuffer.WriteInt32("noOfDataStatusCodes", 32, int32((noOfDataStatusCodes)))
		if _noOfDataStatusCodesErr != nil {
			return errors.Wrap(_noOfDataStatusCodesErr, "Error serializing 'noOfDataStatusCodes' field")
		}

		// Array Field (dataStatusCodes)
		if pushErr := writeBuffer.PushContext("dataStatusCodes", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for dataStatusCodes")
		}
		for _curItem, _element := range m.GetDataStatusCodes() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetDataStatusCodes()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'dataStatusCodes' field")
			}
		}
		if popErr := writeBuffer.PopContext("dataStatusCodes", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for dataStatusCodes")
		}

		// Simple Field (noOfDataDiagnosticInfos)
		noOfDataDiagnosticInfos := int32(m.GetNoOfDataDiagnosticInfos())
		_noOfDataDiagnosticInfosErr := writeBuffer.WriteInt32("noOfDataDiagnosticInfos", 32, int32((noOfDataDiagnosticInfos)))
		if _noOfDataDiagnosticInfosErr != nil {
			return errors.Wrap(_noOfDataDiagnosticInfosErr, "Error serializing 'noOfDataDiagnosticInfos' field")
		}

		// Array Field (dataDiagnosticInfos)
		if pushErr := writeBuffer.PushContext("dataDiagnosticInfos", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for dataDiagnosticInfos")
		}
		for _curItem, _element := range m.GetDataDiagnosticInfos() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetDataDiagnosticInfos()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'dataDiagnosticInfos' field")
			}
		}
		if popErr := writeBuffer.PopContext("dataDiagnosticInfos", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for dataDiagnosticInfos")
		}

		if popErr := writeBuffer.PopContext("ParsingResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ParsingResult")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ParsingResult) isParsingResult() bool {
	return true
}

func (m *_ParsingResult) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
