/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OverrideValueHandling is an enum
type OverrideValueHandling uint32

type IOverrideValueHandling interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OverrideValueHandling_overrideValueHandlingDisabled        OverrideValueHandling = 0
	OverrideValueHandling_overrideValueHandlingLastUsableValue OverrideValueHandling = 1
	OverrideValueHandling_overrideValueHandlingOverrideValue   OverrideValueHandling = 2
)

var OverrideValueHandlingValues []OverrideValueHandling

func init() {
	_ = errors.New
	OverrideValueHandlingValues = []OverrideValueHandling{
		OverrideValueHandling_overrideValueHandlingDisabled,
		OverrideValueHandling_overrideValueHandlingLastUsableValue,
		OverrideValueHandling_overrideValueHandlingOverrideValue,
	}
}

func OverrideValueHandlingByValue(value uint32) (enum OverrideValueHandling, ok bool) {
	switch value {
	case 0:
		return OverrideValueHandling_overrideValueHandlingDisabled, true
	case 1:
		return OverrideValueHandling_overrideValueHandlingLastUsableValue, true
	case 2:
		return OverrideValueHandling_overrideValueHandlingOverrideValue, true
	}
	return 0, false
}

func OverrideValueHandlingByName(value string) (enum OverrideValueHandling, ok bool) {
	switch value {
	case "overrideValueHandlingDisabled":
		return OverrideValueHandling_overrideValueHandlingDisabled, true
	case "overrideValueHandlingLastUsableValue":
		return OverrideValueHandling_overrideValueHandlingLastUsableValue, true
	case "overrideValueHandlingOverrideValue":
		return OverrideValueHandling_overrideValueHandlingOverrideValue, true
	}
	return 0, false
}

func OverrideValueHandlingKnows(value uint32) bool {
	for _, typeValue := range OverrideValueHandlingValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOverrideValueHandling(structType any) OverrideValueHandling {
	castFunc := func(typ any) OverrideValueHandling {
		if sOverrideValueHandling, ok := typ.(OverrideValueHandling); ok {
			return sOverrideValueHandling
		}
		return 0
	}
	return castFunc(structType)
}

func (m OverrideValueHandling) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OverrideValueHandling) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OverrideValueHandlingParse(ctx context.Context, theBytes []byte) (OverrideValueHandling, error) {
	return OverrideValueHandlingParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OverrideValueHandlingParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OverrideValueHandling, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("OverrideValueHandling", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OverrideValueHandling")
	}
	if enum, ok := OverrideValueHandlingByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OverrideValueHandling")
		return OverrideValueHandling(val), nil
	} else {
		return enum, nil
	}
}

func (e OverrideValueHandling) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OverrideValueHandling) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("OverrideValueHandling", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OverrideValueHandling) PLC4XEnumName() string {
	switch e {
	case OverrideValueHandling_overrideValueHandlingDisabled:
		return "overrideValueHandlingDisabled"
	case OverrideValueHandling_overrideValueHandlingLastUsableValue:
		return "overrideValueHandlingLastUsableValue"
	case OverrideValueHandling_overrideValueHandlingOverrideValue:
		return "overrideValueHandlingOverrideValue"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e OverrideValueHandling) String() string {
	return e.PLC4XEnumName()
}
