/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpenChannelMessageRequest is the corresponding interface of OpenChannelMessageRequest
type OpenChannelMessageRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	OpenChannelMessage
	// GetSecureChannelId returns SecureChannelId (property field)
	GetSecureChannelId() int32
	// GetEndpoint returns Endpoint (property field)
	GetEndpoint() PascalString
	// GetSenderCertificate returns SenderCertificate (property field)
	GetSenderCertificate() PascalByteString
	// GetReceiverCertificateThumbprint returns ReceiverCertificateThumbprint (property field)
	GetReceiverCertificateThumbprint() PascalByteString
}

// OpenChannelMessageRequestExactly can be used when we want exactly this type and not a type which fulfills OpenChannelMessageRequest.
// This is useful for switch cases.
type OpenChannelMessageRequestExactly interface {
	OpenChannelMessageRequest
	isOpenChannelMessageRequest() bool
}

// _OpenChannelMessageRequest is the data-structure of this message
type _OpenChannelMessageRequest struct {
	*_OpenChannelMessage
	SecureChannelId               int32
	Endpoint                      PascalString
	SenderCertificate             PascalByteString
	ReceiverCertificateThumbprint PascalByteString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpenChannelMessageRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpenChannelMessageRequest) InitializeParent(parent OpenChannelMessage) {}

func (m *_OpenChannelMessageRequest) GetParent() OpenChannelMessage {
	return m._OpenChannelMessage
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpenChannelMessageRequest) GetSecureChannelId() int32 {
	return m.SecureChannelId
}

func (m *_OpenChannelMessageRequest) GetEndpoint() PascalString {
	return m.Endpoint
}

func (m *_OpenChannelMessageRequest) GetSenderCertificate() PascalByteString {
	return m.SenderCertificate
}

func (m *_OpenChannelMessageRequest) GetReceiverCertificateThumbprint() PascalByteString {
	return m.ReceiverCertificateThumbprint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpenChannelMessageRequest factory function for _OpenChannelMessageRequest
func NewOpenChannelMessageRequest(secureChannelId int32, endpoint PascalString, senderCertificate PascalByteString, receiverCertificateThumbprint PascalByteString) *_OpenChannelMessageRequest {
	_result := &_OpenChannelMessageRequest{
		SecureChannelId:               secureChannelId,
		Endpoint:                      endpoint,
		SenderCertificate:             senderCertificate,
		ReceiverCertificateThumbprint: receiverCertificateThumbprint,
		_OpenChannelMessage:           NewOpenChannelMessage(),
	}
	_result._OpenChannelMessage._OpenChannelMessageChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOpenChannelMessageRequest(structType any) OpenChannelMessageRequest {
	if casted, ok := structType.(OpenChannelMessageRequest); ok {
		return casted
	}
	if casted, ok := structType.(*OpenChannelMessageRequest); ok {
		return *casted
	}
	return nil
}

func (m *_OpenChannelMessageRequest) GetTypeName() string {
	return "OpenChannelMessageRequest"
}

func (m *_OpenChannelMessageRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (secureChannelId)
	lengthInBits += 32

	// Simple field (endpoint)
	lengthInBits += m.Endpoint.GetLengthInBits(ctx)

	// Simple field (senderCertificate)
	lengthInBits += m.SenderCertificate.GetLengthInBits(ctx)

	// Simple field (receiverCertificateThumbprint)
	lengthInBits += m.ReceiverCertificateThumbprint.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpenChannelMessageRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpenChannelMessageRequestParse(ctx context.Context, theBytes []byte, response bool) (OpenChannelMessageRequest, error) {
	return OpenChannelMessageRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), response)
}

func OpenChannelMessageRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, response bool) (OpenChannelMessageRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpenChannelMessageRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpenChannelMessageRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (secureChannelId)
	_secureChannelId, _secureChannelIdErr := readBuffer.ReadInt32("secureChannelId", 32)
	if _secureChannelIdErr != nil {
		return nil, errors.Wrap(_secureChannelIdErr, "Error parsing 'secureChannelId' field of OpenChannelMessageRequest")
	}
	secureChannelId := _secureChannelId

	// Simple Field (endpoint)
	if pullErr := readBuffer.PullContext("endpoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for endpoint")
	}
	_endpoint, _endpointErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _endpointErr != nil {
		return nil, errors.Wrap(_endpointErr, "Error parsing 'endpoint' field of OpenChannelMessageRequest")
	}
	endpoint := _endpoint.(PascalString)
	if closeErr := readBuffer.CloseContext("endpoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for endpoint")
	}

	// Simple Field (senderCertificate)
	if pullErr := readBuffer.PullContext("senderCertificate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for senderCertificate")
	}
	_senderCertificate, _senderCertificateErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _senderCertificateErr != nil {
		return nil, errors.Wrap(_senderCertificateErr, "Error parsing 'senderCertificate' field of OpenChannelMessageRequest")
	}
	senderCertificate := _senderCertificate.(PascalByteString)
	if closeErr := readBuffer.CloseContext("senderCertificate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for senderCertificate")
	}

	// Simple Field (receiverCertificateThumbprint)
	if pullErr := readBuffer.PullContext("receiverCertificateThumbprint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for receiverCertificateThumbprint")
	}
	_receiverCertificateThumbprint, _receiverCertificateThumbprintErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _receiverCertificateThumbprintErr != nil {
		return nil, errors.Wrap(_receiverCertificateThumbprintErr, "Error parsing 'receiverCertificateThumbprint' field of OpenChannelMessageRequest")
	}
	receiverCertificateThumbprint := _receiverCertificateThumbprint.(PascalByteString)
	if closeErr := readBuffer.CloseContext("receiverCertificateThumbprint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for receiverCertificateThumbprint")
	}

	if closeErr := readBuffer.CloseContext("OpenChannelMessageRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpenChannelMessageRequest")
	}

	// Create a partially initialized instance
	_child := &_OpenChannelMessageRequest{
		_OpenChannelMessage:           &_OpenChannelMessage{},
		SecureChannelId:               secureChannelId,
		Endpoint:                      endpoint,
		SenderCertificate:             senderCertificate,
		ReceiverCertificateThumbprint: receiverCertificateThumbprint,
	}
	_child._OpenChannelMessage._OpenChannelMessageChildRequirements = _child
	return _child, nil
}

func (m *_OpenChannelMessageRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpenChannelMessageRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpenChannelMessageRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpenChannelMessageRequest")
		}

		// Simple Field (secureChannelId)
		secureChannelId := int32(m.GetSecureChannelId())
		_secureChannelIdErr := writeBuffer.WriteInt32("secureChannelId", 32, int32((secureChannelId)))
		if _secureChannelIdErr != nil {
			return errors.Wrap(_secureChannelIdErr, "Error serializing 'secureChannelId' field")
		}

		// Simple Field (endpoint)
		if pushErr := writeBuffer.PushContext("endpoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for endpoint")
		}
		_endpointErr := writeBuffer.WriteSerializable(ctx, m.GetEndpoint())
		if popErr := writeBuffer.PopContext("endpoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for endpoint")
		}
		if _endpointErr != nil {
			return errors.Wrap(_endpointErr, "Error serializing 'endpoint' field")
		}

		// Simple Field (senderCertificate)
		if pushErr := writeBuffer.PushContext("senderCertificate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for senderCertificate")
		}
		_senderCertificateErr := writeBuffer.WriteSerializable(ctx, m.GetSenderCertificate())
		if popErr := writeBuffer.PopContext("senderCertificate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for senderCertificate")
		}
		if _senderCertificateErr != nil {
			return errors.Wrap(_senderCertificateErr, "Error serializing 'senderCertificate' field")
		}

		// Simple Field (receiverCertificateThumbprint)
		if pushErr := writeBuffer.PushContext("receiverCertificateThumbprint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for receiverCertificateThumbprint")
		}
		_receiverCertificateThumbprintErr := writeBuffer.WriteSerializable(ctx, m.GetReceiverCertificateThumbprint())
		if popErr := writeBuffer.PopContext("receiverCertificateThumbprint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for receiverCertificateThumbprint")
		}
		if _receiverCertificateThumbprintErr != nil {
			return errors.Wrap(_receiverCertificateThumbprintErr, "Error serializing 'receiverCertificateThumbprint' field")
		}

		if popErr := writeBuffer.PopContext("OpenChannelMessageRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpenChannelMessageRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OpenChannelMessageRequest) isOpenChannelMessageRequest() bool {
	return true
}

func (m *_OpenChannelMessageRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
