/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpenChannelMessage is the corresponding interface of OpenChannelMessage
type OpenChannelMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetResponse returns Response (discriminator field)
	GetResponse() bool
}

// OpenChannelMessageExactly can be used when we want exactly this type and not a type which fulfills OpenChannelMessage.
// This is useful for switch cases.
type OpenChannelMessageExactly interface {
	OpenChannelMessage
	isOpenChannelMessage() bool
}

// _OpenChannelMessage is the data-structure of this message
type _OpenChannelMessage struct {
	_OpenChannelMessageChildRequirements
}

type _OpenChannelMessageChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetResponse() bool
}

type OpenChannelMessageParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child OpenChannelMessage, serializeChildFunction func() error) error
	GetTypeName() string
}

type OpenChannelMessageChild interface {
	utils.Serializable
	InitializeParent(parent OpenChannelMessage)
	GetParent() *OpenChannelMessage

	GetTypeName() string
	OpenChannelMessage
}

// NewOpenChannelMessage factory function for _OpenChannelMessage
func NewOpenChannelMessage() *_OpenChannelMessage {
	return &_OpenChannelMessage{}
}

// Deprecated: use the interface for direct cast
func CastOpenChannelMessage(structType any) OpenChannelMessage {
	if casted, ok := structType.(OpenChannelMessage); ok {
		return casted
	}
	if casted, ok := structType.(*OpenChannelMessage); ok {
		return *casted
	}
	return nil
}

func (m *_OpenChannelMessage) GetTypeName() string {
	return "OpenChannelMessage"
}

func (m *_OpenChannelMessage) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_OpenChannelMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpenChannelMessageParse(ctx context.Context, theBytes []byte, response bool) (OpenChannelMessage, error) {
	return OpenChannelMessageParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), response)
}

func OpenChannelMessageParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, response bool) (OpenChannelMessage, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpenChannelMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpenChannelMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type OpenChannelMessageChildSerializeRequirement interface {
		OpenChannelMessage
		InitializeParent(OpenChannelMessage)
		GetParent() OpenChannelMessage
	}
	var _childTemp any
	var _child OpenChannelMessageChildSerializeRequirement
	var typeSwitchError error
	switch {
	case response == bool(false): // OpenChannelMessageRequest
		_childTemp, typeSwitchError = OpenChannelMessageRequestParseWithBuffer(ctx, readBuffer, response)
	case response == bool(true): // OpenChannelMessageResponse
		_childTemp, typeSwitchError = OpenChannelMessageResponseParseWithBuffer(ctx, readBuffer, response)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [response=%v]", response)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of OpenChannelMessage")
	}
	_child = _childTemp.(OpenChannelMessageChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("OpenChannelMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpenChannelMessage")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_OpenChannelMessage) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child OpenChannelMessage, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("OpenChannelMessage"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for OpenChannelMessage")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("OpenChannelMessage"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for OpenChannelMessage")
	}
	return nil
}

func (m *_OpenChannelMessage) isOpenChannelMessage() bool {
	return true
}

func (m *_OpenChannelMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
