/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaProtocolLimits is the corresponding interface of OpcuaProtocolLimits
type OpcuaProtocolLimits interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetReceiveBufferSize returns ReceiveBufferSize (property field)
	GetReceiveBufferSize() uint32
	// GetSendBufferSize returns SendBufferSize (property field)
	GetSendBufferSize() uint32
	// GetMaxMessageSize returns MaxMessageSize (property field)
	GetMaxMessageSize() uint32
	// GetMaxChunkCount returns MaxChunkCount (property field)
	GetMaxChunkCount() uint32
}

// OpcuaProtocolLimitsExactly can be used when we want exactly this type and not a type which fulfills OpcuaProtocolLimits.
// This is useful for switch cases.
type OpcuaProtocolLimitsExactly interface {
	OpcuaProtocolLimits
	isOpcuaProtocolLimits() bool
}

// _OpcuaProtocolLimits is the data-structure of this message
type _OpcuaProtocolLimits struct {
	ReceiveBufferSize uint32
	SendBufferSize    uint32
	MaxMessageSize    uint32
	MaxChunkCount     uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpcuaProtocolLimits) GetReceiveBufferSize() uint32 {
	return m.ReceiveBufferSize
}

func (m *_OpcuaProtocolLimits) GetSendBufferSize() uint32 {
	return m.SendBufferSize
}

func (m *_OpcuaProtocolLimits) GetMaxMessageSize() uint32 {
	return m.MaxMessageSize
}

func (m *_OpcuaProtocolLimits) GetMaxChunkCount() uint32 {
	return m.MaxChunkCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpcuaProtocolLimits factory function for _OpcuaProtocolLimits
func NewOpcuaProtocolLimits(receiveBufferSize uint32, sendBufferSize uint32, maxMessageSize uint32, maxChunkCount uint32) *_OpcuaProtocolLimits {
	return &_OpcuaProtocolLimits{ReceiveBufferSize: receiveBufferSize, SendBufferSize: sendBufferSize, MaxMessageSize: maxMessageSize, MaxChunkCount: maxChunkCount}
}

// Deprecated: use the interface for direct cast
func CastOpcuaProtocolLimits(structType any) OpcuaProtocolLimits {
	if casted, ok := structType.(OpcuaProtocolLimits); ok {
		return casted
	}
	if casted, ok := structType.(*OpcuaProtocolLimits); ok {
		return *casted
	}
	return nil
}

func (m *_OpcuaProtocolLimits) GetTypeName() string {
	return "OpcuaProtocolLimits"
}

func (m *_OpcuaProtocolLimits) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (receiveBufferSize)
	lengthInBits += 32

	// Simple field (sendBufferSize)
	lengthInBits += 32

	// Simple field (maxMessageSize)
	lengthInBits += 32

	// Simple field (maxChunkCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_OpcuaProtocolLimits) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaProtocolLimitsParse(ctx context.Context, theBytes []byte) (OpcuaProtocolLimits, error) {
	return OpcuaProtocolLimitsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaProtocolLimitsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaProtocolLimits, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpcuaProtocolLimits"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpcuaProtocolLimits")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (receiveBufferSize)
	_receiveBufferSize, _receiveBufferSizeErr := readBuffer.ReadUint32("receiveBufferSize", 32)
	if _receiveBufferSizeErr != nil {
		return nil, errors.Wrap(_receiveBufferSizeErr, "Error parsing 'receiveBufferSize' field of OpcuaProtocolLimits")
	}
	receiveBufferSize := _receiveBufferSize

	// Simple Field (sendBufferSize)
	_sendBufferSize, _sendBufferSizeErr := readBuffer.ReadUint32("sendBufferSize", 32)
	if _sendBufferSizeErr != nil {
		return nil, errors.Wrap(_sendBufferSizeErr, "Error parsing 'sendBufferSize' field of OpcuaProtocolLimits")
	}
	sendBufferSize := _sendBufferSize

	// Simple Field (maxMessageSize)
	_maxMessageSize, _maxMessageSizeErr := readBuffer.ReadUint32("maxMessageSize", 32)
	if _maxMessageSizeErr != nil {
		return nil, errors.Wrap(_maxMessageSizeErr, "Error parsing 'maxMessageSize' field of OpcuaProtocolLimits")
	}
	maxMessageSize := _maxMessageSize

	// Simple Field (maxChunkCount)
	_maxChunkCount, _maxChunkCountErr := readBuffer.ReadUint32("maxChunkCount", 32)
	if _maxChunkCountErr != nil {
		return nil, errors.Wrap(_maxChunkCountErr, "Error parsing 'maxChunkCount' field of OpcuaProtocolLimits")
	}
	maxChunkCount := _maxChunkCount

	if closeErr := readBuffer.CloseContext("OpcuaProtocolLimits"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpcuaProtocolLimits")
	}

	// Create the instance
	return &_OpcuaProtocolLimits{
		ReceiveBufferSize: receiveBufferSize,
		SendBufferSize:    sendBufferSize,
		MaxMessageSize:    maxMessageSize,
		MaxChunkCount:     maxChunkCount,
	}, nil
}

func (m *_OpcuaProtocolLimits) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpcuaProtocolLimits) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("OpcuaProtocolLimits"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for OpcuaProtocolLimits")
	}

	// Simple Field (receiveBufferSize)
	receiveBufferSize := uint32(m.GetReceiveBufferSize())
	_receiveBufferSizeErr := writeBuffer.WriteUint32("receiveBufferSize", 32, uint32((receiveBufferSize)))
	if _receiveBufferSizeErr != nil {
		return errors.Wrap(_receiveBufferSizeErr, "Error serializing 'receiveBufferSize' field")
	}

	// Simple Field (sendBufferSize)
	sendBufferSize := uint32(m.GetSendBufferSize())
	_sendBufferSizeErr := writeBuffer.WriteUint32("sendBufferSize", 32, uint32((sendBufferSize)))
	if _sendBufferSizeErr != nil {
		return errors.Wrap(_sendBufferSizeErr, "Error serializing 'sendBufferSize' field")
	}

	// Simple Field (maxMessageSize)
	maxMessageSize := uint32(m.GetMaxMessageSize())
	_maxMessageSizeErr := writeBuffer.WriteUint32("maxMessageSize", 32, uint32((maxMessageSize)))
	if _maxMessageSizeErr != nil {
		return errors.Wrap(_maxMessageSizeErr, "Error serializing 'maxMessageSize' field")
	}

	// Simple Field (maxChunkCount)
	maxChunkCount := uint32(m.GetMaxChunkCount())
	_maxChunkCountErr := writeBuffer.WriteUint32("maxChunkCount", 32, uint32((maxChunkCount)))
	if _maxChunkCountErr != nil {
		return errors.Wrap(_maxChunkCountErr, "Error serializing 'maxChunkCount' field")
	}

	if popErr := writeBuffer.PopContext("OpcuaProtocolLimits"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for OpcuaProtocolLimits")
	}
	return nil
}

func (m *_OpcuaProtocolLimits) isOpcuaProtocolLimits() bool {
	return true
}

func (m *_OpcuaProtocolLimits) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
