/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaOpenResponse is the corresponding interface of OpcuaOpenResponse
type OpcuaOpenResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	MessagePDU
	// GetOpenResponse returns OpenResponse (property field)
	GetOpenResponse() OpenChannelMessage
	// GetMessage returns Message (property field)
	GetMessage() Payload
}

// OpcuaOpenResponseExactly can be used when we want exactly this type and not a type which fulfills OpcuaOpenResponse.
// This is useful for switch cases.
type OpcuaOpenResponseExactly interface {
	OpcuaOpenResponse
	isOpcuaOpenResponse() bool
}

// _OpcuaOpenResponse is the data-structure of this message
type _OpcuaOpenResponse struct {
	*_MessagePDU
	OpenResponse OpenChannelMessage
	Message      Payload

	// Arguments.
	TotalLength uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpcuaOpenResponse) GetMessageType() string {
	return "OPN"
}

func (m *_OpcuaOpenResponse) GetResponse() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpcuaOpenResponse) InitializeParent(parent MessagePDU, chunk ChunkType) {
	m.Chunk = chunk
}

func (m *_OpcuaOpenResponse) GetParent() MessagePDU {
	return m._MessagePDU
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpcuaOpenResponse) GetOpenResponse() OpenChannelMessage {
	return m.OpenResponse
}

func (m *_OpcuaOpenResponse) GetMessage() Payload {
	return m.Message
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpcuaOpenResponse factory function for _OpcuaOpenResponse
func NewOpcuaOpenResponse(openResponse OpenChannelMessage, message Payload, chunk ChunkType, totalLength uint32) *_OpcuaOpenResponse {
	_result := &_OpcuaOpenResponse{
		OpenResponse: openResponse,
		Message:      message,
		_MessagePDU:  NewMessagePDU(chunk),
	}
	_result._MessagePDU._MessagePDUChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOpcuaOpenResponse(structType any) OpcuaOpenResponse {
	if casted, ok := structType.(OpcuaOpenResponse); ok {
		return casted
	}
	if casted, ok := structType.(*OpcuaOpenResponse); ok {
		return *casted
	}
	return nil
}

func (m *_OpcuaOpenResponse) GetTypeName() string {
	return "OpcuaOpenResponse"
}

func (m *_OpcuaOpenResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (openResponse)
	lengthInBits += m.OpenResponse.GetLengthInBits(ctx)

	// Simple field (message)
	lengthInBits += m.Message.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpcuaOpenResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaOpenResponseParse(ctx context.Context, theBytes []byte, totalLength uint32, response bool) (OpcuaOpenResponse, error) {
	return OpcuaOpenResponseParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), totalLength, response)
}

func OpcuaOpenResponseParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, totalLength uint32, response bool) (OpcuaOpenResponse, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpcuaOpenResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpcuaOpenResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (openResponse)
	if pullErr := readBuffer.PullContext("openResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for openResponse")
	}
	_openResponse, _openResponseErr := OpenChannelMessageParseWithBuffer(ctx, readBuffer, bool(response))
	if _openResponseErr != nil {
		return nil, errors.Wrap(_openResponseErr, "Error parsing 'openResponse' field of OpcuaOpenResponse")
	}
	openResponse := _openResponse.(OpenChannelMessage)
	if closeErr := readBuffer.CloseContext("openResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for openResponse")
	}

	// Simple Field (message)
	if pullErr := readBuffer.PullContext("message"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for message")
	}
	_message, _messageErr := PayloadParseWithBuffer(ctx, readBuffer, bool(bool(false)), uint32(uint32(uint32(totalLength)-uint32(openResponse.GetLengthInBytes(ctx)))-uint32(uint32(16))))
	if _messageErr != nil {
		return nil, errors.Wrap(_messageErr, "Error parsing 'message' field of OpcuaOpenResponse")
	}
	message := _message.(Payload)
	if closeErr := readBuffer.CloseContext("message"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for message")
	}

	if closeErr := readBuffer.CloseContext("OpcuaOpenResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpcuaOpenResponse")
	}

	// Create a partially initialized instance
	_child := &_OpcuaOpenResponse{
		_MessagePDU:  &_MessagePDU{},
		OpenResponse: openResponse,
		Message:      message,
	}
	_child._MessagePDU._MessagePDUChildRequirements = _child
	return _child, nil
}

func (m *_OpcuaOpenResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpcuaOpenResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpcuaOpenResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpcuaOpenResponse")
		}

		// Simple Field (openResponse)
		if pushErr := writeBuffer.PushContext("openResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for openResponse")
		}
		_openResponseErr := writeBuffer.WriteSerializable(ctx, m.GetOpenResponse())
		if popErr := writeBuffer.PopContext("openResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for openResponse")
		}
		if _openResponseErr != nil {
			return errors.Wrap(_openResponseErr, "Error serializing 'openResponse' field")
		}

		// Simple Field (message)
		if pushErr := writeBuffer.PushContext("message"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for message")
		}
		_messageErr := writeBuffer.WriteSerializable(ctx, m.GetMessage())
		if popErr := writeBuffer.PopContext("message"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for message")
		}
		if _messageErr != nil {
			return errors.Wrap(_messageErr, "Error serializing 'message' field")
		}

		if popErr := writeBuffer.PopContext("OpcuaOpenResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpcuaOpenResponse")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_OpcuaOpenResponse) GetTotalLength() uint32 {
	return m.TotalLength
}

//
////

func (m *_OpcuaOpenResponse) isOpcuaOpenResponse() bool {
	return true
}

func (m *_OpcuaOpenResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
